/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.componentization.mappings;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.Messages;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramDescriptionMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramDescriptionMappingsRegistry;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManagerRegistry;
import org.eclipse.sirius.diagram.business.internal.componentization.mappings.DiagramMappingsManagerImpl;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramExtensionDescription;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.viewpoint.DRepresentation;

public final class DiagramMappingsManagerRegistryImpl
extends AdapterImpl
implements DiagramMappingsManagerRegistry {
    private Map<DDiagram, DiagramMappingsManager> diagramMappingsManagers = new HashMap<DDiagram, DiagramMappingsManager>();

    private DiagramMappingsManagerRegistryImpl() {
        SessionManager.INSTANCE.addSessionsListener((SessionManagerListener)new SessionManagerListener.Stub(){

            public void notifyRemoveSession(Session removedSession) {
                DiagramMappingsManagerRegistryImpl.this.cleanDiagramMappingsManagers(removedSession);
            }

            public void notify(Session closingSession, int notification) {
                if (notification == 8) {
                    DiagramMappingsManagerRegistryImpl.this.cleanDiagramMappingsManagers(closingSession);
                }
            }
        });
    }

    public static DiagramMappingsManagerRegistry init() {
        return new DiagramMappingsManagerRegistryImpl();
    }

    @Override
    public DiagramMappingsManager getDiagramMappingsManager(Session session, DDiagram diagram) {
        if (diagram == null) {
            throw new IllegalArgumentException(Messages.DiagramMappingsManagerRegistryImpl_diagramParamErrorMsg);
        }
        if (this.diagramMappingsManagers.containsKey(diagram)) {
            return this.diagramMappingsManagers.get(diagram);
        }
        DiagramDescription desc = diagram.getDescription();
        DiagramDescriptionMappingsRegistry mappingsRegistry = DiagramDescriptionMappingsRegistry.INSTANCE;
        DiagramDescriptionMappingsManager descManager = mappingsRegistry.getDiagramDescriptionMappingsManager(session, desc);
        DiagramMappingsManagerImpl newManager = new DiagramMappingsManagerImpl(diagram, descManager);
        diagram.eAdapters().add((Object)this);
        if (session != null) {
            newManager.computeMappings(session.getSelectedViewpoints(false), false);
        } else {
            newManager.computeMappings(null, false);
        }
        this.diagramMappingsManagers.put(diagram, newManager);
        return newManager;
    }

    public void notifyChanged(Notification msg) {
        int featureID;
        Object notifier = msg.getNotifier();
        if (notifier instanceof DDiagram && (featureID = msg.getFeatureID(DDiagram.class)) == 22) {
            switch (msg.getEventType()) {
                case 3: 
                case 4: {
                    this.computeMappings((DDiagram)notifier, (Layer)msg.getNewValue());
                    break;
                }
            }
        }
    }

    private void computeMappings(DDiagram diagram, Layer layer) {
        DiagramMappingsManager manager = this.diagramMappingsManagers.get(diagram);
        if (manager != null) {
            Session sess;
            boolean needToRecomputeDescMappings = false;
            if (layer != null && layer.eContainer() instanceof DiagramExtensionDescription) {
                needToRecomputeDescMappings = true;
            }
            if ((sess = SessionManager.INSTANCE.getSession(((DSemanticDiagram)diagram).getTarget())) != null) {
                manager.computeMappings(sess.getSelectedViewpoints(false), needToRecomputeDescMappings);
            } else {
                manager.computeMappings(null, needToRecomputeDescMappings);
            }
        }
    }

    private void cleanDiagramMappingsManagers(Session session) {
        HashSet<DDiagram> diagramInSession = new HashSet<DDiagram>();
        for (DRepresentation representation : DialectManager.INSTANCE.getAllLoadedRepresentations(session)) {
            if (!(representation instanceof DDiagram)) continue;
            diagramInSession.add((DDiagram)representation);
        }
        HashSet<DDiagram> keysToRemove = new HashSet<DDiagram>();
        for (DDiagram diagram : this.diagramMappingsManagers.keySet()) {
            if (!diagramInSession.contains(diagram)) continue;
            keysToRemove.add(diagram);
        }
        for (DDiagram keyToRemove : keysToRemove) {
            this.diagramMappingsManagers.remove(keyToRemove);
        }
    }

    @Override
    public void removeDiagramMappingsManagers(DiagramMappingsManager manager) {
        LinkedHashSet<DDiagram> toRemove = new LinkedHashSet<DDiagram>();
        for (Map.Entry<DDiagram, DiagramMappingsManager> entry : this.diagramMappingsManagers.entrySet()) {
            if (entry.getValue() != manager) continue;
            toRemove.add(entry.getKey());
        }
        for (DDiagram diagramToRemove : toRemove) {
            this.diagramMappingsManagers.remove(diagramToRemove);
        }
    }
}

