/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.transformations;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.time4sys.design.DesignModel;
import org.polarsys.time4sys.mapping.Context;
import org.polarsys.time4sys.mapping.Link;
import org.polarsys.time4sys.mapping.MappableArtefact;
import org.polarsys.time4sys.marte.gqam.ArrivalPattern;
import org.polarsys.time4sys.marte.gqam.BehaviorScenario;
import org.polarsys.time4sys.marte.gqam.GqamFactory;
import org.polarsys.time4sys.marte.gqam.PeriodicPattern;
import org.polarsys.time4sys.marte.gqam.SlidingWindowPattern;
import org.polarsys.time4sys.marte.gqam.Step;
import org.polarsys.time4sys.marte.gqam.WorkloadEvent;
import org.polarsys.time4sys.model.time4sys.Project;
import org.polarsys.time4sys.model.time4sys.Transformation;
import org.polarsys.time4sys.transformations.IdentityDerivation;

public class ToPeriodicDerivation
extends IdentityDerivation {
    public static final String STEP_RULE_NAME = "Sliding to Periodic Step".intern();
    public static final String PATTERN_RULE_NAME = "Sliding to Periodic Pattern".intern();
    public static final String TRANS_NAME = "Sliding to Periodic Transformation".intern();
    protected Context slide2periodic;
    private Context slide2periodicStep;
    private Context slide2periodicMapping;

    public static Transformation getOrApply(Project project) {
        return ToPeriodicDerivation.getOrApply(project, project.getDesign());
    }

    public static Transformation getOrApply(Project project, DesignModel source) {
        for (Transformation tr : project.getTransformations()) {
            EObject srcModel;
            Context transKind = tr.getMapping().getRationale();
            if (transKind == null || !TRANS_NAME.equals(transKind.getName()) || !source.equals(srcModel = ((Link)tr.getMapping().getSubLinks().get(0)).getUniqueSourceValue("original"))) continue;
            return tr;
        }
        return ToPeriodicDerivation.duplicate(project, source);
    }

    public static Transformation duplicate(Project project, DesignModel source) {
        return new ToPeriodicDerivation(project, source).transform();
    }

    public ToPeriodicDerivation(Project project, DesignModel source) {
        super(project, source);
    }

    @Override
    public Transformation transform() {
        Transformation result = super.transform();
        result.getMapping().setRationale(this.slide2periodicMapping);
        return result;
    }

    @Override
    public void createRules() {
        super.createRules();
        this.slide2periodicMapping = mappingFactory.createContext(TRANS_NAME);
        this.mapping.getRules().add((Object)this.slide2periodicMapping);
        this.slide2periodic = mappingFactory.createContext(PATTERN_RULE_NAME);
        this.mapping.getRules().add((Object)this.slide2periodic);
        this.slide2periodicStep = mappingFactory.createContext(STEP_RULE_NAME);
        this.mapping.getRules().add((Object)this.slide2periodicStep);
    }

    @Override
    protected void finalize(DesignModel target) {
        for (WorkloadEvent evt : target.getWorkloadBehavior().getDemand()) {
            if (!(evt.getPattern() instanceof SlidingWindowPattern)) continue;
            this.finalizeSlidingWindowPattern(evt);
        }
    }

    protected void finalizeSlidingWindowPattern(WorkloadEvent evt) {
        SlidingWindowPattern previousPattern = (SlidingWindowPattern)evt.getPattern();
        PeriodicPattern newPattern = GqamFactory.eINSTANCE.createPeriodicPattern();
        newPattern.setPeriod(previousPattern.getWindowSize());
        newPattern.setJitter(previousPattern.getJitter());
        newPattern.setPhase(previousPattern.getPhase());
        newPattern.setReference(previousPattern.getReference());
        evt.setPattern((ArrivalPattern)newPattern);
        Link copyLnk = this.getUniqueLinkFor((EObject)previousPattern);
        MappableArtefact patternArtefact = (MappableArtefact)copyLnk.getTargets().get(0);
        assert (previousPattern == patternArtefact.getValue());
        patternArtefact.setValue((EObject)newPattern);
        patternArtefact.setName("modified");
        copyLnk.setRationale(this.slide2periodic);
        BehaviorScenario step = evt.getEffect();
        copyLnk.getTargets().add((Object)mappingFactory.createMappableArtefact("step", (EObject)step));
        assert (step instanceof Step);
        step.setWorstCET(step.getWorstCET().multiply(previousPattern.getNbEvents()));
        Link stepLnk = this.getUniqueLinkFor((EObject)step);
        MappableArtefact stepArtefact = (MappableArtefact)stepLnk.getTargets().get(0);
        stepArtefact.setName("modified");
        stepLnk.setRationale(this.slide2periodicStep);
        Step targetStep = (Step)stepArtefact.getValue();
        assert (targetStep == step);
        ArrivalPattern originalPattern = (ArrivalPattern)((MappableArtefact)copyLnk.getSources().get(0)).getValue();
        stepLnk.getSources().add((Object)mappingFactory.createMappableArtefact("pattern", (EObject)originalPattern));
    }
}

