/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.trace;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SchedulingEventKind implements Enumerator
{
    ACTIVATED(0, "ACTIVATED", "ACTIVATED"),
    RUNNING(1, "RUNNING", "RUNNING"),
    SUSPENDED(2, "SUSPENDED", "SUSPENDED"),
    BLOCKED(3, "BLOCKED", "BLOCKED"),
    TERMINATED(4, "TERMINATED", "TERMINATED"),
    DEADLINE(5, "DEADLINE", "DEADLINE");

    public static final int ACTIVATED_VALUE = 0;
    public static final int RUNNING_VALUE = 1;
    public static final int SUSPENDED_VALUE = 2;
    public static final int BLOCKED_VALUE = 3;
    public static final int TERMINATED_VALUE = 4;
    public static final int DEADLINE_VALUE = 5;
    private static final SchedulingEventKind[] VALUES_ARRAY;
    public static final List<SchedulingEventKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SchedulingEventKind[]{ACTIVATED, RUNNING, SUSPENDED, BLOCKED, TERMINATED, DEADLINE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SchedulingEventKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SchedulingEventKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SchedulingEventKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SchedulingEventKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SchedulingEventKind get(int value) {
        switch (value) {
            case 0: {
                return ACTIVATED;
            }
            case 1: {
                return RUNNING;
            }
            case 2: {
                return SUSPENDED;
            }
            case 3: {
                return BLOCKED;
            }
            case 4: {
                return TERMINATED;
            }
            case 5: {
                return DEADLINE;
            }
        }
        return null;
    }

    private SchedulingEventKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

