/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.equinox.internal.p2.ui.ProvUIImages;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.IResolutionErrorReportingPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.ISelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.RemediationPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.ResolutionResultsWizardPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.SelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.UninstallWizardPage;
import org.eclipse.equinox.internal.p2.ui.model.ElementUtils;
import org.eclipse.equinox.internal.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.internal.p2.ui.model.InstalledIUElement;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.UninstallOperation;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.wizard.IWizardPage;

public class UninstallWizard
extends ProvisioningOperationWizard {
    public UninstallWizard(ProvisioningUI ui, UninstallOperation operation, Collection<IInstallableUnit> initialSelections, LoadMetadataRepositoryJob job) {
        super(ui, (ProfileChangeOperation)operation, initialSelections.toArray(), job);
        this.setWindowTitle(ProvUIMessages.UninstallIUOperationLabel);
        this.setDefaultPageImageDescriptor(ProvUIImages.getImageDescriptor("wizban/uninstall_wiz.gif"));
    }

    @Override
    protected ISelectableIUsPage createMainPage(IUElementListRoot input, Object[] selections) {
        this.mainPage = new SelectableIUsPage(this.ui, this, input, selections);
        this.mainPage.setTitle(ProvUIMessages.UninstallIUOperationLabel);
        this.mainPage.setDescription(ProvUIMessages.UninstallDialog_UninstallMessage);
        ((SelectableIUsPage)this.mainPage).updateStatus(input, this.operation);
        return this.mainPage;
    }

    @Override
    protected ResolutionResultsWizardPage createResolutionPage() {
        return new UninstallWizardPage(this.ui, (ProvisioningOperationWizard)this, this.root, (UninstallOperation)this.operation);
    }

    @Override
    protected void initializeResolutionModelElements(Object[] selectedElements) {
        this.root = new IUElementListRoot();
        ArrayList<InstalledIUElement> list = new ArrayList<InstalledIUElement>(selectedElements.length);
        ArrayList<InstalledIUElement> selections = new ArrayList<InstalledIUElement>(selectedElements.length);
        int i = 0;
        while (i < selectedElements.length) {
            IInstallableUnit iu = ElementUtils.getIU(selectedElements[i]);
            if (iu != null) {
                InstalledIUElement element = new InstalledIUElement(this.root, this.getProfileId(), iu);
                list.add(element);
                selections.add(element);
            }
            ++i;
        }
        this.root.setChildren(list.toArray());
        this.planSelections = selections.toArray();
    }

    @Override
    protected IResolutionErrorReportingPage createErrorReportingPage() {
        return (SelectableIUsPage)this.mainPage;
    }

    public IWizardPage getStartingPage() {
        if (this.getCurrentStatus().isOK()) {
            ((SelectableIUsPage)this.mainPage).setPageComplete(true);
            return this.resolutionPage;
        }
        return super.getStartingPage();
    }

    @Override
    protected ProfileChangeOperation getProfileChangeOperation(Object[] elements) {
        UninstallOperation op = new UninstallOperation(this.ui.getSession(), ElementUtils.elementsToIUs(elements));
        op.setProfileId(this.getProfileId());
        op.setProvisioningContext(this.getProvisioningContext());
        return op;
    }

    @Override
    protected RemediationPage createRemediationPage() {
        return null;
    }
}

