/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.api.command.semantic;

import com.google.common.collect.Sets;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.Messages;

public class AddSemanticResourceCommand
extends RecordingCommand {
    protected Session session;
    protected URI semanticResourceURI;
    protected IProgressMonitor monitor;
    private Collection<Session> result = Sets.newLinkedHashSet();

    public AddSemanticResourceCommand(Session session, URI semanticResourceURI, IProgressMonitor monitor) {
        super(session.getTransactionalEditingDomain(), Messages.AddSemanticResourceCommand_label);
        this.session = session;
        this.semanticResourceURI = semanticResourceURI;
        this.monitor = monitor;
    }

    protected void doExecute() {
        if (this.monitor == null) {
            this.monitor = new NullProgressMonitor();
        }
        this.session.addSemanticResource(this.semanticResourceURI, this.monitor);
        Resource addedResource = this.session.getTransactionalEditingDomain().getResourceSet().getResource(this.semanticResourceURI, false);
        if (addedResource != null) {
            this.result.add(this.session);
        }
    }

    public Collection<?> getResult() {
        return this.result;
    }
}

