/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.business.internal.session.danalysis.SemanticResourceGetter;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class SemanticResourcesUpdater
extends AdapterImpl
implements Adapter {
    private DAnalysisSessionImpl dAnalysisSessionImpl;
    private Collection<Resource> semanticResources;
    private Map<String, EObject> resourceToRootEObjectMap = Maps.newHashMap();

    public SemanticResourcesUpdater(DAnalysisSessionImpl dAnalysisSessionImpl) {
        this.dAnalysisSessionImpl = dAnalysisSessionImpl;
    }

    public void setSemanticResources(Collection<Resource> semanticResources) {
        for (DAnalysis dAnalysis : this.dAnalysisSessionImpl.allAnalyses()) {
            if (dAnalysis.eAdapters().contains((Object)this)) continue;
            dAnalysis.eAdapters().add((Object)this);
        }
        this.semanticResources = semanticResources;
    }

    public void notifyChanged(Notification msg) {
        if (msg.getEventType() != 8 && (msg.getFeature() == ViewpointPackage.Literals.DANALYSIS_SESSION_EOBJECT__ANALYSES || msg.getFeature() == ViewpointPackage.Literals.DANALYSIS__REFERENCED_ANALYSIS || msg.getFeature() == ViewpointPackage.Literals.DANALYSIS_SESSION_EOBJECT__ANALYSES || msg.getFeature() == ViewpointPackage.Literals.DANALYSIS__SEMANTIC_RESOURCES || msg.getFeature() == ViewpointPackage.Literals.DANALYSIS_SESSION_EOBJECT__CONTROLLED_RESOURCES)) {
            BasicEList oldValue;
            String uriString;
            URI oldResourceURI;
            Map uriResourceMap;
            if (this.isRemoveSemanticResourceNotification(msg) && this.isRemoveManyStringNotification(msg) && (uriResourceMap = ((ResourceSetImpl)this.semanticResources.iterator().next().getResourceSet()).getURIResourceMap()).containsKey(oldResourceURI = URI.createURI((String)(uriString = (String)(oldValue = (BasicEList)msg.getOldValue()).get(0)))) && !((Resource)uriResourceMap.get(oldResourceURI)).getURI().toString().equals(uriString)) {
                Resource resource = (Resource)uriResourceMap.get(oldResourceURI);
                uriResourceMap.remove(oldResourceURI);
                uriResourceMap.put(resource.getURI(), resource);
            }
            Collection<Resource> updatedSemanticResources = SemanticResourceGetter.collectTopLevelSemanticResources(this.dAnalysisSessionImpl);
            boolean newSemanticResourceAdded = false;
            for (Resource semanticResource : updatedSemanticResources) {
                if (this.semanticResources.contains(semanticResource)) continue;
                newSemanticResourceAdded = true;
                this.dAnalysisSessionImpl.registerResourceInCrossReferencer(semanticResource);
            }
            if (newSemanticResourceAdded || this.semanticResources.size() != updatedSemanticResources.size()) {
                this.semanticResources.clear();
                this.semanticResources.addAll(updatedSemanticResources);
                this.dAnalysisSessionImpl.notifyListeners(11);
            }
        }
    }

    private boolean isRemoveSemanticResourceNotification(Notification msg) {
        return msg.getFeature() == ViewpointPackage.Literals.DANALYSIS__SEMANTIC_RESOURCES && !this.semanticResources.isEmpty();
    }

    private boolean isRemoveManyStringNotification(Notification msg) {
        return msg.getEventType() == 6 && msg.getOldValue() instanceof BasicEList && !((BasicEList)msg.getOldValue()).isEmpty() && ((BasicEList)msg.getOldValue()).get(0) instanceof String;
    }

    public void dispose() {
        for (DAnalysis dAnalysis : this.dAnalysisSessionImpl.allAnalyses()) {
            if (!dAnalysis.eAdapters().contains((Object)this)) continue;
            dAnalysis.eAdapters().remove((Object)this);
        }
        this.dAnalysisSessionImpl = null;
        this.semanticResources = null;
        this.resourceToRootEObjectMap.clear();
    }
}

