/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.CreateTextFileChange;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileDocumentSetupParticipant;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileSourceViewerConfiguration;
import org.eclipse.jdt.internal.ui.util.ViewerPane;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.ui.refactoring.ChangePreviewViewerInput;
import org.eclipse.ltk.ui.refactoring.IChangePreviewViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.model.IWorkbenchAdapter;

public final class CreateTextFileChangePreviewViewer
implements IChangePreviewViewer {
    private CreateTextFilePreviewer fPane;
    private SourceViewer fSourceViewer;

    public void createControl(Composite parent) {
        this.fPane = new CreateTextFilePreviewer(parent, 0x800800);
        Dialog.applyDialogFont((Control)this.fPane);
        this.fSourceViewer = new SourceViewer((Composite)this.fPane, null, 66306);
        this.fSourceViewer.setEditable(false);
        this.fSourceViewer.getControl().setFont(JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont"));
        this.fPane.setContent(this.fSourceViewer.getControl());
    }

    public Control getControl() {
        return this.fPane;
    }

    public void refresh() {
        this.fSourceViewer.refresh();
    }

    public void setInput(ChangePreviewViewerInput input) {
        Change change = input.getChange();
        if (change != null) {
            Object element = change.getModifiedElement();
            if (element instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)element;
                IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter)adaptable.getAdapter(IWorkbenchAdapter.class);
                if (workbenchAdapter != null) {
                    this.fPane.setImageDescriptor(workbenchAdapter.getImageDescriptor(element));
                } else {
                    this.fPane.setImageDescriptor(null);
                }
            } else {
                this.fPane.setImageDescriptor(null);
            }
        }
        if (!(change instanceof CreateTextFileChange)) {
            this.fSourceViewer.setInput(null);
            this.fPane.setText("");
            return;
        }
        CreateTextFileChange textFileChange = (CreateTextFileChange)change;
        this.fPane.setText(textFileChange.getName());
        Document document = new Document(textFileChange.getPreview());
        this.fSourceViewer.unconfigure();
        String textType = textFileChange.getTextType();
        JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
        IPreferenceStore store = JavaPlugin.getDefault().getCombinedPreferenceStore();
        if ("java".equals(textType)) {
            textTools.setupJavaDocumentPartitioner((IDocument)document);
            this.fSourceViewer.configure((SourceViewerConfiguration)new JavaSourceViewerConfiguration(textTools.getColorManager(), store, null, null));
            this.fSourceViewer.getTextWidget().setOrientation(0x2000000);
        } else if ("properties".equals(textType)) {
            PropertiesFileDocumentSetupParticipant.setupDocument((IDocument)document);
            this.fSourceViewer.configure((SourceViewerConfiguration)new PropertiesFileSourceViewerConfiguration(textTools.getColorManager(), store, null, "___pf_partitioning"));
            this.fSourceViewer.getTextWidget().setOrientation(0x2000000);
        } else {
            this.fSourceViewer.configure(new SourceViewerConfiguration());
            this.fSourceViewer.getTextWidget().setOrientation(this.fSourceViewer.getTextWidget().getParent().getOrientation());
        }
        this.fSourceViewer.setInput((Object)document);
    }

    private static class CreateTextFilePreviewer
    extends ViewerPane {
        private ImageDescriptor fDescriptor;
        private Image fImage;

        public CreateTextFilePreviewer(Composite parent, int style) {
            super(parent, style);
            this.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    CreateTextFilePreviewer.this.disposeImage();
                }
            });
        }

        void disposeImage() {
            if (this.fImage != null) {
                this.fImage.dispose();
            }
        }

        public void setImageDescriptor(ImageDescriptor imageDescriptor) {
            this.fDescriptor = imageDescriptor;
        }

        @Override
        public void setText(String text) {
            super.setText(text);
            Image current = null;
            if (this.fDescriptor != null) {
                current = this.fImage;
                this.fImage = this.fDescriptor.createImage();
            } else {
                current = this.fImage;
                this.fImage = null;
            }
            this.setImage(this.fImage);
            if (current != null) {
                current.dispose();
            }
        }
    }
}

