/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.core.refactoring.descriptors.MoveStaticMembersDescriptor;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CollectingSearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.base.ReferencesInBinaryContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.delegates.DelegateFieldCreator;
import org.eclipse.jdt.internal.corext.refactoring.delegates.DelegateMethodCreator;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRewriteUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.MemberCheckUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.MemberVisibilityAdjustor;
import org.eclipse.jdt.internal.corext.refactoring.structure.MovedMemberAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.structure.ReferenceAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IDelegateUpdating;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.SearchUtils;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.participants.MoveProcessor;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public final class MoveStaticMembersProcessor
extends MoveProcessor
implements IDelegateUpdating {
    private static final String ATTRIBUTE_DELEGATE = "delegate";
    private static final String ATTRIBUTE_DEPRECATE = "deprecate";
    private static final String TRACKED_POSITION_PROPERTY = "MoveStaticMembersProcessor.trackedPosition";
    private IMember[] fMembersToMove;
    private IType fDestinationType;
    private String fDestinationTypeName;
    private CodeGenerationSettings fPreferences;
    private CompositeChange fChange;
    private CompilationUnitRewrite fSource;
    private ITypeBinding fSourceBinding;
    private CompilationUnitRewrite fTarget;
    private IBinding[] fMemberBindings;
    private BodyDeclaration[] fMemberDeclarations;
    private boolean fDelegateUpdating;
    private boolean fDelegateDeprecation;

    public MoveStaticMembersProcessor(IMember[] members, CodeGenerationSettings settings) {
        this.fMembersToMove = members;
        this.fPreferences = settings;
        this.fDelegateUpdating = false;
        this.fDelegateDeprecation = true;
    }

    public MoveStaticMembersProcessor(JavaRefactoringArguments arguments, RefactoringStatus status) {
        this.fDelegateUpdating = false;
        this.fDelegateDeprecation = true;
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isMoveStaticMembersAvailable(this.fMembersToMove);
    }

    public Object[] getElements() {
        Object[] result = new Object[this.fMembersToMove.length];
        System.arraycopy(this.fMembersToMove, 0, result, 0, this.fMembersToMove.length);
        return result;
    }

    public String getIdentifier() {
        return "org.eclipse.jdt.ui.MoveStaticMemberProcessor";
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        ArrayList<MoveParticipant> result = new ArrayList<MoveParticipant>();
        MoveArguments args = new MoveArguments((Object)this.fDestinationType, true);
        String[] natures = JavaProcessors.computeAffectedNaturs((IJavaElement[])this.fMembersToMove);
        int i = 0;
        while (i < this.fMembersToMove.length) {
            IMember member = this.fMembersToMove[i];
            result.addAll(Arrays.asList(ParticipantManager.loadMoveParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)member, (MoveArguments)args, (String[])natures, (SharableParticipants)sharedParticipants)));
            ++i;
        }
        return result.toArray(new RefactoringParticipant[result.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean canEnableDelegateUpdating() {
        try {
            int i = 0;
            while (true) {
                if (i >= this.fMembersToMove.length) {
                    return false;
                }
                if (this.isDelegateCreationAvailable(this.fMembersToMove[i])) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private boolean isDelegateCreationAvailable(IMember member) throws JavaModelException {
        if (member instanceof IMethod) {
            return true;
        }
        return member instanceof IField && RefactoringAvailabilityTester.isDelegateCreationAvailable((IField)member);
    }

    @Override
    public boolean getDelegateUpdating() {
        return this.fDelegateUpdating;
    }

    @Override
    public void setDelegateUpdating(boolean updating) {
        this.fDelegateUpdating = updating;
    }

    @Override
    public boolean getDeprecateDelegates() {
        return this.fDelegateDeprecation;
    }

    @Override
    public void setDeprecateDelegates(boolean deprecate) {
        this.fDelegateDeprecation = deprecate;
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.MoveMembersRefactoring_Move_Members;
    }

    public IType getDestinationType() {
        return this.fDestinationType;
    }

    public void setDestinationTypeFullyQualifiedName(String fullyQualifiedTypeName) throws JavaModelException {
        Assert.isNotNull((Object)fullyQualifiedTypeName);
        this.fDestinationType = this.resolveType(fullyQualifiedTypeName);
        this.fDestinationTypeName = fullyQualifiedTypeName;
    }

    public IMember[] getMembersToMove() {
        return this.fMembersToMove;
    }

    public IType getDeclaringType() {
        return this.fMembersToMove[0].getDeclaringType();
    }

    private IType resolveType(String qualifiedTypeName) throws JavaModelException {
        IType type = this.getDeclaringType().getJavaProject().findType(qualifiedTypeName);
        if (type == null) {
            type = this.getDeclaringType().getJavaProject().findType(this.getDeclaringType().getPackageFragment().getElementName(), qualifiedTypeName);
        }
        return type;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(RefactoringCoreMessages.MoveMembersRefactoring_checking, 1);
            RefactoringStatus result = new RefactoringStatus();
            result.merge(this.checkDeclaringType());
            pm.worked(1);
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            this.fSource = new CompilationUnitRewrite(this.fMembersToMove[0].getCompilationUnit());
            this.fSourceBinding = (ITypeBinding)((SimpleName)NodeFinder.perform((ASTNode)this.fSource.getRoot(), (ISourceRange)this.fMembersToMove[0].getDeclaringType().getNameRange())).resolveBinding();
            this.fMemberBindings = this.getMemberBindings();
            if (this.fSourceBinding == null || this.hasUnresolvedMemberBinding()) {
                result.addFatalError(Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_compile_errors, BasicElementLabels.getFileName((ITypeRoot)this.fSource.getCu())));
            }
            this.fMemberDeclarations = this.getASTMembers(result);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private boolean hasUnresolvedMemberBinding() {
        int i = 0;
        while (i < this.fMemberBindings.length) {
            if (this.fMemberBindings[i] == null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private RefactoringStatus checkDeclaringType() {
        IType declaringType = this.getDeclaringType();
        if (declaringType.getFullyQualifiedName('.').equals("java.lang.Object")) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveMembersRefactoring_Object);
        }
        if (declaringType.isBinary()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveMembersRefactoring_binary);
        }
        if (declaringType.isReadOnly()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveMembersRefactoring_read_only);
        }
        return null;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        this.fTarget = null;
        try {
            pm.beginTask(RefactoringCoreMessages.MoveMembersRefactoring_checking, 10);
            RefactoringStatus result = new RefactoringStatus();
            this.fSource.clearASTAndImportRewrites();
            result.merge(this.checkDestinationType());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            result.merge(this.checkDestinationInsideTypeToMove());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            result.merge(MemberCheckUtil.checkMembersInDestinationType(this.fMembersToMove, this.fDestinationType));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            result.merge(this.checkNativeMovedMethods((IProgressMonitor)new SubProgressMonitor(pm, 1)));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            ArrayList<ICompilationUnit> modifiedCus = new ArrayList<ICompilationUnit>();
            this.createChange(modifiedCus, result, (IProgressMonitor)new SubProgressMonitor(pm, 7));
            IFile[] changedFiles = this.getAllFilesToModify(modifiedCus);
            ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
            int i = 0;
            while (i < changedFiles.length) {
                checker.getDeltaFactory().change(changedFiles[i]);
                ++i;
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private IFile[] getAllFilesToModify(List<ICompilationUnit> modifiedCus) {
        HashSet<IResource> result = new HashSet<IResource>();
        IResource resource = this.fDestinationType.getCompilationUnit().getResource();
        result.add(resource);
        int i = 0;
        while (i < this.fMembersToMove.length) {
            resource = this.fMembersToMove[i].getCompilationUnit().getResource();
            if (resource != null) {
                result.add(resource);
            }
            ++i;
        }
        for (ICompilationUnit unit : modifiedCus) {
            if (unit.getResource() == null) continue;
            result.add(unit.getResource());
        }
        return result.toArray(new IFile[result.size()]);
    }

    private RefactoringStatus checkDestinationType() throws JavaModelException {
        if (this.fDestinationType == null) {
            String message = Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_not_found, BasicElementLabels.getJavaElementName(this.fDestinationTypeName));
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        if (this.fDestinationType.equals(this.getDeclaringType())) {
            String message = Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_same, JavaElementUtil.createSignature((IMember)this.fDestinationType));
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        if (!this.fDestinationType.exists()) {
            String message = Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_not_exist, JavaElementUtil.createSignature((IMember)this.fDestinationType));
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        if (this.fDestinationType.isBinary()) {
            String message = Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_dest_binary, JavaElementUtil.createSignature((IMember)this.fDestinationType));
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        RefactoringStatus result = new RefactoringStatus();
        if (this.fDestinationType.isInterface()) {
            result.merge(this.checkMoveToInterface());
        }
        if (result.hasFatalError()) {
            return result;
        }
        if (!JdtFlags.isStatic((IMember)this.fDestinationType) && this.fDestinationType.getDeclaringType() != null) {
            String message = RefactoringCoreMessages.MoveMembersRefactoring_static_declaration;
            result.addError(message);
        }
        return result;
    }

    private RefactoringStatus checkDestinationInsideTypeToMove() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < this.fMembersToMove.length) {
            IType type;
            if (this.fMembersToMove[i] instanceof IType && (this.fDestinationType.equals(type = (IType)this.fMembersToMove[i]) || JavaElementUtil.isAncestorOf((IJavaElement)type, (IJavaElement)this.fDestinationType))) {
                String message = Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_inside, new String[]{this.getQualifiedTypeLabel(type), this.getQualifiedTypeLabel(this.fDestinationType)});
                RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)this.fDestinationType.getCompilationUnit(), this.fDestinationType.getNameRange());
                result.addFatalError(message, context);
                return result;
            }
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkMoveToInterface() throws JavaModelException {
        boolean is18OrHigher = JavaModelUtil.is18OrHigher(this.fDestinationType.getJavaProject());
        RefactoringStatus result = new RefactoringStatus();
        boolean declaringIsInterface = this.getDeclaringType().isInterface();
        if (declaringIsInterface && is18OrHigher) {
            return result;
        }
        String moveMembersMsg = is18OrHigher ? RefactoringCoreMessages.MoveMembersRefactoring_only_public_static_18 : RefactoringCoreMessages.MoveMembersRefactoring_only_public_static;
        int i = 0;
        while (i < this.fMembersToMove.length) {
            if (!declaringIsInterface || this.fMembersToMove[i] instanceof IMethod || is18OrHigher) {
                if (!this.canMoveToInterface(this.fMembersToMove[i], is18OrHigher)) {
                    result.addError(moveMembersMsg, JavaStatusContext.create(this.fMembersToMove[i]));
                } else if (!Flags.isPublic((int)this.fMembersToMove[i].getFlags()) && !declaringIsInterface) {
                    result.addWarning(RefactoringCoreMessages.MoveMembersRefactoring_member_will_be_public, JavaStatusContext.create(this.fMembersToMove[i]));
                }
            }
            ++i;
        }
        return result;
    }

    private boolean canMoveToInterface(IMember member, boolean is18OrHigher) throws JavaModelException {
        int flags = member.getFlags();
        switch (member.getElementType()) {
            case 8: {
                if (!Flags.isStatic((int)flags) || !Flags.isFinal((int)flags)) {
                    return false;
                }
                if (Flags.isEnum((int)flags)) {
                    return false;
                }
                VariableDeclarationFragment declaration = ASTNodeSearchUtil.getFieldDeclarationFragmentNode((IField)member, this.fSource.getRoot());
                if (declaration != null) {
                    return declaration.getInitializer() != null;
                }
                return false;
            }
            case 7: {
                IType type = (IType)member;
                if (type.isInterface() && !Checks.isTopLevel(type)) {
                    return true;
                }
                return Flags.isStatic((int)flags);
            }
            case 9: {
                return is18OrHigher && Flags.isStatic((int)flags);
            }
        }
        return false;
    }

    private RefactoringStatus checkMovedMemberAvailability(IMember memberToMove, IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        if (memberToMove instanceof IType) {
            IJavaElement[] typeMembers = ((IType)memberToMove).getChildren();
            pm.beginTask(RefactoringCoreMessages.MoveMembersRefactoring_checking, typeMembers.length + 1);
            int i = 0;
            while (i < typeMembers.length) {
                if (typeMembers[i] instanceof IInitializer) {
                    pm.worked(1);
                } else {
                    result.merge(this.checkMovedMemberAvailability((IMember)typeMembers[i], (IProgressMonitor)new SubProgressMonitor(pm, 1)));
                }
                ++i;
            }
        } else {
            pm.beginTask(RefactoringCoreMessages.MoveMembersRefactoring_checking, 1);
        }
        IType[] blindAccessorTypes = this.getTypesNotSeeingMovedMember(memberToMove, (IProgressMonitor)new SubProgressMonitor(pm, 1), result);
        int k = 0;
        while (k < blindAccessorTypes.length) {
            String message = this.createNonAccessibleMemberMessage(memberToMove, blindAccessorTypes[k], true);
            result.addError(message, JavaStatusContext.create(memberToMove));
            ++k;
        }
        pm.done();
        return result;
    }

    private IType[] getTypesNotSeeingMovedMember(IMember member, IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        IType type;
        if (JdtFlags.isPublic(member) && JdtFlags.isPublic((IMember)this.fDestinationType)) {
            return new IType[0];
        }
        HashSet<IType> blindAccessorTypes = new HashSet<IType>();
        SearchResultGroup[] references = MoveStaticMembersProcessor.getReferences(member, (IProgressMonitor)new SubProgressMonitor(pm, 1), status);
        int i = 0;
        while (i < references.length) {
            SearchMatch[] searchResults = references[i].getSearchResults();
            int k = 0;
            while (k < searchResults.length) {
                SearchMatch searchResult = searchResults[k];
                IJavaElement element = SearchUtils.getEnclosingJavaElement(searchResult);
                IType type2 = (IType)element.getAncestor(7);
                if (!(type2 == null || blindAccessorTypes.contains(type2) || this.isWithinMemberToMove(searchResult) || MoveStaticMembersProcessor.isVisibleFrom(this.getDestinationType(), type2))) {
                    blindAccessorTypes.add(type2);
                }
                ++k;
            }
            ++i;
        }
        if (this.fDelegateUpdating && this.isDelegateCreationAvailable(member) && !blindAccessorTypes.contains(type = member.getDeclaringType()) && !MoveStaticMembersProcessor.isVisibleFrom(this.getDestinationType(), type)) {
            blindAccessorTypes.add(type);
        }
        return blindAccessorTypes.toArray(new IType[blindAccessorTypes.size()]);
    }

    private String createNonAccessibleMemberMessage(IMember member, IType accessingType, boolean moved) {
        IType declaringType = moved ? this.getDestinationType() : this.getDeclaringType();
        switch (member.getElementType()) {
            case 8: {
                String message = moved ? Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_moved_field, new String[]{JavaElementUtil.createFieldSignature((IField)member), this.getQualifiedTypeLabel(accessingType), this.getQualifiedTypeLabel(declaringType)}) : Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_accessed_field, new String[]{JavaElementUtil.createFieldSignature((IField)member), this.getQualifiedTypeLabel(accessingType)});
                return message;
            }
            case 9: {
                String message = moved ? Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_moved_method, new String[]{JavaElementUtil.createMethodSignature((IMethod)member), this.getQualifiedTypeLabel(accessingType), this.getQualifiedTypeLabel(declaringType)}) : Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_accessed_method, new String[]{JavaElementUtil.createMethodSignature((IMethod)member), this.getQualifiedTypeLabel(accessingType)});
                return message;
            }
            case 7: {
                String message = moved ? Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_moved_type, new String[]{this.getQualifiedTypeLabel((IType)member), this.getQualifiedTypeLabel(accessingType), this.getQualifiedTypeLabel(declaringType)}) : Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_accessed_type, new String[]{this.getQualifiedTypeLabel((IType)member), this.getQualifiedTypeLabel(accessingType)});
                return message;
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private String getQualifiedTypeLabel(IType accessingType) {
        return BasicElementLabels.getJavaCodeString(accessingType.getFullyQualifiedName('.'));
    }

    private static SearchResultGroup[] getReferences(IMember member, IProgressMonitor monitor, RefactoringStatus status) throws JavaModelException {
        RefactoringSearchEngine2 engine = new RefactoringSearchEngine2(SearchPattern.createPattern((IJavaElement)member, (int)2, (int)24));
        engine.setFiltering(true, true);
        engine.setScope(RefactoringScopeFactory.create((IJavaElement)member));
        engine.setStatus(status);
        engine.searchPattern((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        return (SearchResultGroup[])engine.getResults();
    }

    private static boolean isVisibleFrom(IType newMemberDeclaringType, IType accessingType) throws JavaModelException {
        int memberVisibility = JdtFlags.getVisibilityCode((IMember)newMemberDeclaringType);
        IType declaringType = newMemberDeclaringType.getDeclaringType();
        while (declaringType != null) {
            memberVisibility = JdtFlags.getLowerVisibility(memberVisibility, JdtFlags.getVisibilityCode((IMember)declaringType));
            declaringType = declaringType.getDeclaringType();
        }
        switch (memberVisibility) {
            case 2: {
                return MoveStaticMembersProcessor.isEqualOrEnclosedType(accessingType, newMemberDeclaringType);
            }
            case 0: {
                return JavaModelUtil.isSamePackage(accessingType.getPackageFragment(), newMemberDeclaringType.getPackageFragment());
            }
            case 4: {
                return JavaModelUtil.isSamePackage(accessingType.getPackageFragment(), newMemberDeclaringType.getPackageFragment()) || accessingType.newSupertypeHierarchy(null).contains(newMemberDeclaringType);
            }
            case 1: {
                return true;
            }
        }
        Assert.isTrue((boolean)false);
        return false;
    }

    private static boolean isEqualOrEnclosedType(IType inner, IType outer) {
        while (inner != null) {
            if (inner.equals(outer)) {
                return true;
            }
            inner = inner.getDeclaringType();
        }
        return false;
    }

    private boolean isWithinMemberToMove(SearchMatch result) throws JavaModelException {
        ICompilationUnit referenceCU = SearchUtils.getCompilationUnit(result);
        if (!referenceCU.equals(this.fSource.getCu())) {
            return false;
        }
        int referenceStart = result.getOffset();
        int i = 0;
        while (i < this.fMembersToMove.length) {
            ISourceRange range = this.fMembersToMove[i].getSourceRange();
            if (range.getOffset() <= referenceStart && range.getOffset() + range.getLength() >= referenceStart) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private RefactoringStatus checkNativeMovedMethods(IProgressMonitor pm) throws JavaModelException {
        pm.beginTask(RefactoringCoreMessages.MoveMembersRefactoring_checking, this.fMembersToMove.length);
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < this.fMembersToMove.length) {
            if (this.fMembersToMove[i].getElementType() == 9 && JdtFlags.isNative(this.fMembersToMove[i])) {
                String message = Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_native, JavaElementUtil.createMethodSignature((IMethod)this.fMembersToMove[i]));
                result.addWarning(message, JavaStatusContext.create(this.fMembersToMove[i]));
                pm.worked(1);
            }
            ++i;
        }
        pm.done();
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        pm.done();
        return this.fChange;
    }

    private void createChange(List<ICompilationUnit> modifiedCus, RefactoringStatus status, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(RefactoringCoreMessages.MoveMembersRefactoring_creating, 5);
        this.fChange = new DynamicValidationRefactoringChange((JavaRefactoringDescriptor)this.createDescriptor(), RefactoringCoreMessages.MoveMembersRefactoring_move_members);
        this.fTarget = this.getCuRewrite(this.fDestinationType.getCompilationUnit());
        ITypeBinding targetBinding = this.getDestinationBinding();
        if (targetBinding == null) {
            status.addFatalError(Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_compile_errors, BasicElementLabels.getFileName((ITypeRoot)this.fTarget.getCu())));
            monitor.done();
            return;
        }
        try {
            HashMap<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment> adjustments = new HashMap<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment>();
            IMember member = null;
            SubProgressMonitor sub = new SubProgressMonitor(monitor, 1, 2);
            sub.beginTask(RefactoringCoreMessages.MoveMembersRefactoring_creating, this.fMembersToMove.length);
            HashSet rewritten = new HashSet();
            int index = 0;
            while (index < this.fMembersToMove.length) {
                member = this.fMembersToMove[index];
                MemberVisibilityAdjustor adjustor = new MemberVisibilityAdjustor((IJavaElement)this.fDestinationType, member);
                adjustor.setAdjustments(adjustments);
                adjustor.setStatus(status);
                adjustor.setVisibilitySeverity(2);
                adjustor.setFailureSeverity(2);
                adjustor.setRewrite(this.fSource.getASTRewrite(), this.fSource.getRoot());
                adjustor.adjustVisibility((IProgressMonitor)new NullProgressMonitor());
                if (this.fDelegateUpdating && this.isDelegateCreationAvailable(member)) {
                    Modifier.ModifierKeyword kw;
                    Modifier.ModifierKeyword threshold = adjustor.getVisibilityThreshold((IJavaElement)member, (IMember)this.fDestinationType, (IProgressMonitor)new NullProgressMonitor());
                    MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment adjustment = (MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment)adjustments.get(member);
                    Modifier.ModifierKeyword modifierKeyword = kw = adjustment != null ? adjustment.getKeyword() : Modifier.ModifierKeyword.fromFlagValue((int)JdtFlags.getVisibilityCode(member));
                    if (MemberVisibilityAdjustor.hasLowerVisibility(kw, threshold)) {
                        adjustments.put(member, new MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment(member, threshold, RefactoringStatus.createWarningStatus((String)Messages.format(MemberVisibilityAdjustor.getMessage(member), new String[]{MemberVisibilityAdjustor.getLabel((IJavaElement)member), MemberVisibilityAdjustor.getLabel(threshold)}), (RefactoringStatusContext)JavaStatusContext.create(member))));
                    }
                }
                status.merge(this.checkMovedMemberAvailability(member, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)sub, 1)));
                Iterator iterator = rewritten.iterator();
                while (iterator.hasNext()) {
                    adjustments.remove(iterator.next());
                }
                rewritten.addAll(adjustments.keySet());
                adjustor.rewriteVisibility((IProgressMonitor)new NullProgressMonitor());
                ++index;
            }
            String[] memberSources = this.getUpdatedMemberSource(status, this.fMemberDeclarations, targetBinding);
            monitor.worked(1);
            if (status.hasFatalError()) {
                return;
            }
            ReferencesInBinaryContext binaryRefs = new ReferencesInBinaryContext(RefactoringCoreMessages.ReferencesInBinaryContext_ref_in_binaries_description_plural);
            IJavaSearchScope scope = RefactoringScopeFactory.create(this.fMembersToMove, false);
            SearchPattern pattern = RefactoringSearchEngine.createOrPattern((IJavaElement[])this.fMembersToMove, 3);
            final HashSet affectedCompilationUnits = new HashSet();
            CollectingSearchRequestor requestor = new CollectingSearchRequestor(binaryRefs){
                private ICompilationUnit fLastCU;

                @Override
                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    if (this.filterMatch(match)) {
                        return;
                    }
                    if (match.getAccuracy() == 1) {
                        return;
                    }
                    ICompilationUnit unit = SearchUtils.getCompilationUnit(match);
                    if (unit != null && !unit.equals(this.fLastCU)) {
                        this.fLastCU = unit;
                        affectedCompilationUnits.add(unit);
                    }
                }
            };
            RefactoringSearchEngine.search(pattern, scope, requestor, (IProgressMonitor)new NullProgressMonitor(), status);
            binaryRefs.addErrorIfNecessary(status);
            ICompilationUnit[] units = affectedCompilationUnits.toArray(new ICompilationUnit[affectedCompilationUnits.size()]);
            modifiedCus.addAll(Arrays.asList(units));
            MemberVisibilityAdjustor adjustor = new MemberVisibilityAdjustor((IJavaElement)this.fDestinationType, (IMember)this.fDestinationType);
            sub = new SubProgressMonitor(monitor, 1);
            sub.beginTask(RefactoringCoreMessages.MoveMembersRefactoring_creating, units.length);
            int index2 = 0;
            while (index2 < units.length) {
                ICompilationUnit unit = units[index2];
                CompilationUnitRewrite rewrite = this.getCuRewrite(unit);
                adjustor.setRewrites(Collections.singletonMap(unit, rewrite));
                adjustor.setAdjustments(adjustments);
                adjustor.rewriteVisibility(unit, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)sub, 1));
                ReferenceAnalyzer analyzer = new ReferenceAnalyzer(rewrite, this.fMemberBindings, targetBinding, this.fSourceBinding);
                rewrite.getRoot().accept((ASTVisitor)analyzer);
                status.merge(analyzer.getStatus());
                if (status.hasFatalError()) {
                    this.fChange = null;
                    return;
                }
                if (!this.fSource.getCu().equals(unit) && !this.fTarget.getCu().equals(unit)) {
                    this.fChange.add((Change)rewrite.createChange(true));
                }
                ++index2;
            }
            status.merge(this.moveMembers(this.fMemberDeclarations, memberSources));
            this.fChange.add((Change)this.fSource.createChange(true));
            modifiedCus.add(this.fSource.getCu());
            if (!this.fSource.getCu().equals(this.fTarget.getCu())) {
                this.fChange.add((Change)this.fTarget.createChange(true));
                modifiedCus.add(this.fTarget.getCu());
            }
            monitor.worked(1);
        }
        catch (BadLocationException exception) {
            JavaPlugin.log(exception);
        }
    }

    private MoveStaticMembersDescriptor createDescriptor() {
        IMember[] members = this.getMembersToMove();
        String project = null;
        IJavaProject javaProject = this.getDeclaringType().getJavaProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        String header = null;
        header = members.length == 1 ? Messages.format(RefactoringCoreMessages.MoveStaticMembersProcessor_descriptor_description_single, new String[]{JavaElementLabels.getElementLabel((IJavaElement)members[0], JavaElementLabels.ALL_FULLY_QUALIFIED), this.getQualifiedTypeLabel(this.fDestinationType)}) : Messages.format(RefactoringCoreMessages.MoveStaticMembersProcessor_descriptor_description_multi, new String[]{String.valueOf(members.length), this.getQualifiedTypeLabel(this.fDestinationType)});
        int flags = 589830;
        IType declaring = members[0].getDeclaringType();
        try {
            if (declaring.isLocal() || declaring.isAnonymous()) {
                flags |= 0x40000;
            }
        }
        catch (JavaModelException exception) {
            JavaPlugin.log(exception);
        }
        String description = members.length == 1 ? Messages.format(RefactoringCoreMessages.MoveStaticMembersProcessor_description_descriptor_short_multi, BasicElementLabels.getJavaElementName(members[0].getElementName())) : RefactoringCoreMessages.MoveMembersRefactoring_move_members;
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
        comment.addSetting(Messages.format(RefactoringCoreMessages.MoveStaticMembersProcessor_target_element_pattern, this.getQualifiedTypeLabel(this.fDestinationType)));
        MoveStaticMembersDescriptor descriptor = RefactoringSignatureDescriptorFactory.createMoveStaticMembersDescriptor();
        descriptor.setProject(project);
        descriptor.setDescription(description);
        descriptor.setComment(comment.asString());
        descriptor.setFlags(flags);
        descriptor.setDestinationType(this.fDestinationType);
        descriptor.setKeepOriginal(this.fDelegateUpdating);
        descriptor.setDeprecateDelegate(this.fDelegateDeprecation);
        descriptor.setMembers(members);
        return descriptor;
    }

    private CompilationUnitRewrite getCuRewrite(ICompilationUnit unit) {
        if (this.fSource.getCu().equals(unit)) {
            return this.fSource;
        }
        if (this.fTarget != null && this.fTarget.getCu().equals(unit)) {
            return this.fTarget;
        }
        return new CompilationUnitRewrite(unit);
    }

    private AbstractTypeDeclaration getDestinationNode() throws JavaModelException {
        AbstractTypeDeclaration destination = (AbstractTypeDeclaration)ASTNodes.getParent(NodeFinder.perform((ASTNode)this.fTarget.getRoot(), (ISourceRange)this.fDestinationType.getNameRange()), AbstractTypeDeclaration.class);
        return destination;
    }

    private ITypeBinding getDestinationBinding() throws JavaModelException {
        ASTNode node = NodeFinder.perform((ASTNode)this.fTarget.getRoot(), (ISourceRange)this.fDestinationType.getNameRange());
        if (!(node instanceof SimpleName)) {
            return null;
        }
        IBinding binding = ((SimpleName)node).resolveBinding();
        if (!(binding instanceof ITypeBinding)) {
            return null;
        }
        return (ITypeBinding)binding;
    }

    private IBinding[] getMemberBindings() throws JavaModelException {
        IBinding[] result = new IBinding[this.fMembersToMove.length];
        int i = 0;
        while (i < this.fMembersToMove.length) {
            IMember member = this.fMembersToMove[i];
            SimpleName name = (SimpleName)NodeFinder.perform((ASTNode)this.fSource.getRoot(), (ISourceRange)member.getNameRange());
            result[i] = name.resolveBinding();
            ++i;
        }
        return result;
    }

    private String[] getUpdatedMemberSource(RefactoringStatus status, BodyDeclaration[] members, ITypeBinding target) throws CoreException, BadLocationException {
        ArrayList<IBinding> typeRefs = new ArrayList<IBinding>();
        boolean targetNeedsSourceImport = false;
        boolean isSourceNotTarget = this.fSource != this.fTarget;
        HashSet<IBinding> exclude = new HashSet<IBinding>();
        int i = 0;
        while (i < members.length) {
            ITypeBinding binding;
            BodyDeclaration declaration = members[i];
            if (declaration instanceof AbstractTypeDeclaration) {
                AbstractTypeDeclaration abstractTypeDeclaration = (AbstractTypeDeclaration)declaration;
                binding = abstractTypeDeclaration.resolveBinding();
                if (binding != null) {
                    exclude.add((IBinding)binding);
                }
            } else if (declaration instanceof MethodDeclaration) {
                MethodDeclaration methodDeclaration = (MethodDeclaration)declaration;
                binding = methodDeclaration.resolveBinding();
                if (binding != null) {
                    exclude.add((IBinding)binding);
                }
            } else if (declaration instanceof FieldDeclaration) {
                FieldDeclaration fieldDeclaration = (FieldDeclaration)declaration;
                for (VariableDeclarationFragment fragment : fieldDeclaration.fragments()) {
                    IVariableBinding binding2 = fragment.resolveBinding();
                    if (binding2 == null) continue;
                    exclude.add((IBinding)binding2);
                }
            }
            ++i;
        }
        ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)this.getDestinationNode(), this.fTarget.getImportRewrite());
        int i2 = 0;
        while (i2 < members.length) {
            BodyDeclaration bodyDeclaration = members[i2];
            if (isSourceNotTarget) {
                typeRefs.addAll(TypeReferenceFinder.perform((ASTNode)bodyDeclaration));
            }
            MovedMemberAnalyzer analyzer = new MovedMemberAnalyzer(this.fSource, this.fMemberBindings, this.fSourceBinding, target);
            bodyDeclaration.accept((ASTVisitor)analyzer);
            ImportRewriteUtil.addImports(this.fTarget, context, (ASTNode)bodyDeclaration, new HashMap<Name, String>(), new HashMap<Name, String>(), exclude, false);
            if (this.getDeclaringType().isInterface() && !this.fDestinationType.isInterface()) {
                if (bodyDeclaration instanceof FieldDeclaration) {
                    FieldDeclaration fieldDecl = (FieldDeclaration)bodyDeclaration;
                    int psfModifiers = 25;
                    if ((fieldDecl.getModifiers() & psfModifiers) != psfModifiers) {
                        ModifierRewrite.create(this.fSource.getASTRewrite(), (ASTNode)fieldDecl).setModifiers(psfModifiers, null);
                    }
                } else if (bodyDeclaration instanceof AbstractTypeDeclaration) {
                    AbstractTypeDeclaration typeDecl = (AbstractTypeDeclaration)bodyDeclaration;
                    int psModifiers = 9;
                    if ((typeDecl.getModifiers() & psModifiers) != psModifiers) {
                        ModifierRewrite.create(this.fSource.getASTRewrite(), (ASTNode)typeDecl).setModifiers(typeDecl.getModifiers() | psModifiers, null);
                    }
                } else if (bodyDeclaration instanceof MethodDeclaration) {
                    MethodDeclaration methodDecl = (MethodDeclaration)bodyDeclaration;
                    int psModifiers = 9;
                    if ((methodDecl.getModifiers() & psModifiers) != psModifiers) {
                        ModifierRewrite.create(this.fSource.getASTRewrite(), (ASTNode)methodDecl).setModifiers(methodDecl.getModifiers() | psModifiers, null);
                    }
                }
            }
            if (this.fDestinationType.isInterface()) {
                int modifiers = bodyDeclaration.getModifiers();
                modifiers = JdtFlags.clearAccessModifiers(modifiers);
                modifiers = JdtFlags.clearFlag(1040, modifiers);
                if (!(bodyDeclaration instanceof MethodDeclaration)) {
                    modifiers = JdtFlags.clearFlag(8, modifiers);
                }
                ModifierRewrite.create(this.fSource.getASTRewrite(), (ASTNode)bodyDeclaration).setModifiers(modifiers, null);
            }
            ITrackedNodePosition trackedPosition = this.fSource.getASTRewrite().track((ASTNode)bodyDeclaration);
            bodyDeclaration.setProperty(TRACKED_POSITION_PROPERTY, (Object)trackedPosition);
            targetNeedsSourceImport |= analyzer.targetNeedsSourceImport();
            status.merge(analyzer.getStatus());
            ++i2;
        }
        if (targetNeedsSourceImport && isSourceNotTarget) {
            this.fTarget.getImportRewrite().addImport(this.fSourceBinding, (ImportRewrite.ImportRewriteContext)context);
        }
        if (isSourceNotTarget) {
            for (ITypeBinding iTypeBinding : typeRefs) {
                this.fTarget.getImportRewrite().addImport(iTypeBinding, (ImportRewrite.ImportRewriteContext)context);
            }
        }
        String[] updatedMemberSources = new String[members.length];
        Document document = new Document(this.fSource.getCu().getBuffer().getContents());
        TextEdit edit = this.fSource.getASTRewrite().rewriteAST((IDocument)document, this.fSource.getCu().getJavaProject().getOptions(true));
        edit.apply((IDocument)document, 2);
        int i3 = 0;
        while (i3 < members.length) {
            updatedMemberSources[i3] = this.getUpdatedMember((IDocument)document, members[i3]);
            ++i3;
        }
        this.fSource.clearASTRewrite();
        return updatedMemberSources;
    }

    private String getUpdatedMember(IDocument document, BodyDeclaration declaration) throws BadLocationException {
        ITrackedNodePosition trackedPosition = (ITrackedNodePosition)declaration.getProperty(TRACKED_POSITION_PROPERTY);
        return Strings.trimIndentation(document.get(trackedPosition.getStartPosition(), trackedPosition.getLength()), this.fPreferences.tabWidth, this.fPreferences.indentWidth, false);
    }

    private RefactoringStatus moveMembers(BodyDeclaration[] members, String[] sources) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        AbstractTypeDeclaration destination = this.getDestinationNode();
        ListRewrite containerRewrite = this.fTarget.getASTRewrite().getListRewrite((ASTNode)destination, destination.getBodyDeclarationsProperty());
        TextEditGroup delete = this.fSource.createGroupDescription(RefactoringCoreMessages.MoveMembersRefactoring_deleteMembers);
        TextEditGroup add = this.fTarget.createGroupDescription(RefactoringCoreMessages.MoveMembersRefactoring_addMembers);
        int i = 0;
        while (i < members.length) {
            BodyDeclaration declaration = members[i];
            BodyDeclaration removeImportsOf = null;
            boolean addedDelegate = false;
            if (this.fDelegateUpdating) {
                if (declaration instanceof MethodDeclaration) {
                    DelegateMethodCreator creator = new DelegateMethodCreator();
                    creator.setDeclaration(declaration);
                    creator.setDeclareDeprecated(this.fDelegateDeprecation);
                    creator.setSourceRewrite(this.fSource);
                    creator.setCopy(false);
                    creator.setNewLocation(this.getDestinationBinding());
                    creator.prepareDelegate();
                    creator.createEdit();
                    removeImportsOf = ((MethodDeclaration)declaration).getBody();
                    addedDelegate = true;
                }
                if (declaration instanceof FieldDeclaration) {
                    VariableDeclarationFragment frag = (VariableDeclarationFragment)((FieldDeclaration)declaration).fragments().get(0);
                    if (!Modifier.isFinal((int)declaration.getModifiers())) {
                        result.addInfo(Messages.format(RefactoringCoreMessages.DelegateCreator_cannot_create_field_delegate_not_final, BasicElementLabels.getJavaElementName(frag.getName().getIdentifier())), null);
                    } else if (frag.getInitializer() == null) {
                        result.addInfo(Messages.format(RefactoringCoreMessages.DelegateCreator_cannot_create_field_delegate_no_initializer, BasicElementLabels.getJavaElementName(frag.getName().getIdentifier())), null);
                    } else {
                        DelegateFieldCreator creator = new DelegateFieldCreator();
                        creator.setDeclaration(declaration);
                        creator.setDeclareDeprecated(this.fDelegateDeprecation);
                        creator.setSourceRewrite(this.fSource);
                        creator.setCopy(false);
                        creator.setNewLocation(this.getDestinationBinding());
                        creator.prepareDelegate();
                        creator.createEdit();
                        removeImportsOf = frag.getInitializer();
                        addedDelegate = true;
                    }
                }
                if (declaration instanceof AbstractTypeDeclaration) {
                    result.addInfo(Messages.format(RefactoringCoreMessages.DelegateCreator_cannot_create_delegate_for_type, BasicElementLabels.getJavaElementName(((AbstractTypeDeclaration)declaration).getName().getIdentifier())), null);
                }
            }
            if (!addedDelegate) {
                this.fSource.getASTRewrite().remove((ASTNode)declaration, delete);
                removeImportsOf = declaration;
            }
            if (removeImportsOf != null && this.fSource != this.fTarget) {
                this.fSource.getImportRemover().registerRemovedNode((ASTNode)removeImportsOf);
            }
            ASTNode node = this.fTarget.getASTRewrite().createStringPlaceholder(sources[i], declaration.getNodeType());
            List container = containerRewrite.getRewrittenList();
            int insertionIndex = ASTNodes.getInsertionIndex((BodyDeclaration)node, container);
            containerRewrite.insertAt(node, insertionIndex, add);
            ++i;
        }
        return result;
    }

    private BodyDeclaration[] getASTMembers(RefactoringStatus status) throws JavaModelException {
        BodyDeclaration[] result = new BodyDeclaration[this.fMembersToMove.length];
        int i = 0;
        while (i < this.fMembersToMove.length) {
            IMember member = this.fMembersToMove[i];
            ASTNode node = NodeFinder.perform((ASTNode)this.fSource.getRoot(), (ISourceRange)member.getNameRange());
            result[i] = (BodyDeclaration)ASTNodes.getParent(node, BodyDeclaration.class);
            if (result[i] instanceof FieldDeclaration && ((FieldDeclaration)result[i]).fragments().size() != 1) {
                status.addFatalError(RefactoringCoreMessages.MoveMembersRefactoring_multi_var_fields);
                return result;
            }
            ++i;
        }
        Arrays.sort(result, new Comparator<BodyDeclaration>(){

            @Override
            public int compare(BodyDeclaration o1, BodyDeclaration o2) {
                return o1.getStartPosition() - o2.getStartPosition();
            }
        });
        return result;
    }

    private RefactoringStatus initialize(JavaRefactoringArguments extended) {
        IJavaElement element;
        String handle = extended.getAttribute("input");
        if (handle != null) {
            element = JavaRefactoringDescriptorUtil.handleToElement(extended.getProject(), handle, false);
            if (element == null || !element.exists() || element.getElementType() != 7) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getProcessorName(), "org.eclipse.jdt.ui.move.static");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        this.fDestinationType = (IType)element;
        this.fDestinationTypeName = this.fDestinationType.getFullyQualifiedName();
        String delegate = extended.getAttribute(ATTRIBUTE_DELEGATE);
        if (delegate == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_DELEGATE));
        }
        this.fDelegateUpdating = Boolean.valueOf(delegate);
        String deprecate = extended.getAttribute(ATTRIBUTE_DEPRECATE);
        if (deprecate == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_DEPRECATE));
        }
        this.fDelegateDeprecation = Boolean.valueOf(deprecate);
        int count = 1;
        ArrayList<IJavaElement> elements = new ArrayList<IJavaElement>();
        String attribute = "element" + count;
        RefactoringStatus status = new RefactoringStatus();
        while ((handle = extended.getAttribute(attribute)) != null) {
            IJavaElement element2 = JavaRefactoringDescriptorUtil.handleToElement(extended.getProject(), handle, false);
            if (element2 == null || !element2.exists()) {
                status.merge(JavaRefactoringDescriptorUtil.createInputWarningStatus(element2, this.getProcessorName(), "org.eclipse.jdt.ui.move.static"));
            } else {
                elements.add(element2);
            }
            attribute = "element" + ++count;
        }
        this.fMembersToMove = elements.toArray(new IMember[elements.size()]);
        if (elements.isEmpty()) {
            return JavaRefactoringDescriptorUtil.createInputFatalStatus(null, this.getProcessorName(), "org.eclipse.jdt.ui.move.static");
        }
        IJavaProject project = null;
        if (this.fMembersToMove.length > 0) {
            project = this.fMembersToMove[0].getJavaProject();
        }
        this.fPreferences = JavaPreferencesSettings.getCodeGenerationSettings(project);
        if (!status.isOK()) {
            return status;
        }
        return new RefactoringStatus();
    }

    @Override
    public String getDelegateUpdatingTitle(boolean plural) {
        if (plural) {
            return RefactoringCoreMessages.DelegateMethodCreator_keep_original_moved_plural_member;
        }
        return RefactoringCoreMessages.DelegateMethodCreator_keep_original_moved_singular_member;
    }

    private static class TypeReferenceFinder
    extends ASTVisitor {
        List<IBinding> fResult = new ArrayList<IBinding>();
        Set<ITypeBinding> fDefined = new HashSet<ITypeBinding>();

        private TypeReferenceFinder() {
        }

        public static List<IBinding> perform(ASTNode root) {
            TypeReferenceFinder visitor = new TypeReferenceFinder();
            root.accept((ASTVisitor)visitor);
            return visitor.fResult;
        }

        public boolean visit(TypeDeclaration node) {
            this.fDefined.add(node.resolveBinding());
            return true;
        }

        public boolean visit(SimpleName node) {
            IBinding binding = node.resolveBinding();
            if (!(binding instanceof ITypeBinding)) {
                return true;
            }
            if (!this.fDefined.contains(binding)) {
                this.fResult.add(binding);
            }
            return true;
        }

        public boolean visit(AnnotationTypeDeclaration node) {
            this.fDefined.add(node.resolveBinding());
            return true;
        }

        public boolean visit(EnumDeclaration node) {
            this.fDefined.add(node.resolveBinding());
            return true;
        }
    }
}

