/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.transformations;

import java.util.LinkedList;
import java.util.concurrent.LinkedBlockingQueue;
import org.polarsys.time4sys.builder.design.DesignBuilder;
import org.polarsys.time4sys.builder.design.StepBuilder;
import org.polarsys.time4sys.design.DesignModel;
import org.polarsys.time4sys.marte.gqam.BehaviorScenario;
import org.polarsys.time4sys.marte.gqam.PrecedenceRelation;
import org.polarsys.time4sys.marte.gqam.Step;
import org.polarsys.time4sys.marte.grm.EDFParameters;
import org.polarsys.time4sys.marte.grm.FixedPriorityParameters;
import org.polarsys.time4sys.marte.grm.GrmFactory;
import org.polarsys.time4sys.marte.grm.Resource;
import org.polarsys.time4sys.marte.grm.ResourcePackage;
import org.polarsys.time4sys.marte.grm.SchedulingParameter;
import org.polarsys.time4sys.marte.nfp.NfpFactory;
import org.polarsys.time4sys.marte.srm.SoftwareSchedulableResource;
import org.polarsys.time4sys.model.time4sys.Project;

public class RemoveAndReplaceDeprecated {
    private Project project;
    private DesignBuilder designBuilder;

    public static void removeAndReplaceDeprecated(Project project) {
        new RemoveAndReplaceDeprecated(project).transform();
    }

    public RemoveAndReplaceDeprecated(Project project) {
        this.project = project;
    }

    public void transform() {
        if (this.project == null) {
            return;
        }
        this.transform(this.project.getDesign());
        for (DesignModel model : this.project.getDerivations()) {
            this.transform(model);
        }
    }

    protected void transform(DesignModel design) {
        if (design == null) {
            return;
        }
        this.designBuilder = new DesignBuilder(design);
        for (BehaviorScenario scn : design.getWorkloadBehavior().getBehavior()) {
            this.transform(scn);
        }
        this.transform(design.getResourcePackage());
    }

    protected void transform(ResourcePackage resourcePackage) {
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        queue.addAll(resourcePackage.getOwnedElement());
        while (!queue.isEmpty()) {
            Object current = queue.poll();
            System.out.print(current.toString());
            if (current instanceof ResourcePackage) {
                queue.addAll(((ResourcePackage)current).getOwnedElement());
            }
            if (current instanceof Resource) {
                queue.addAll(((Resource)current).getOwnedResource());
            }
            if (!(current instanceof SoftwareSchedulableResource)) continue;
            this.transform((SoftwareSchedulableResource)current);
        }
    }

    protected void transform(SoftwareSchedulableResource current) {
        LinkedList params = new LinkedList(current.getSchedParams());
        for (SchedulingParameter param : params) {
            if ("FixedPriority".equals(param.getName()) && !(param instanceof FixedPriorityParameters)) {
                current.getSchedParams().remove((Object)param);
                FixedPriorityParameters fpParam = GrmFactory.eINSTANCE.createFixedPriorityParameters();
                fpParam.setName("FixedPriority");
                fpParam.setPriority(Integer.parseInt(param.getValue()));
                current.getSchedParams().add((Object)fpParam);
            }
            if (!"Deadline".equals(param.getName()) || param instanceof EDFParameters) continue;
            current.getSchedParams().remove((Object)param);
            if (param.getValue() == null || param.getValue().isEmpty()) continue;
            EDFParameters edfParam = GrmFactory.eINSTANCE.createEDFParameters();
            edfParam.setDeadline(NfpFactory.eINSTANCE.createDurationFromString(param.getValue()));
            edfParam.setName("EDF");
            current.getSchedParams().add((Object)edfParam);
        }
    }

    protected void transform(BehaviorScenario scenario) {
        if (scenario == null) {
            return;
        }
        if (scenario instanceof Step) {
            this.transform(((Step)scenario).getChildScenario());
        }
        for (PrecedenceRelation rel : scenario.getConnectors()) {
            this.transform(rel);
        }
        scenario.getConnectors().clear();
    }

    protected void transform(PrecedenceRelation rel) {
        for (Step next : rel.getSucces()) {
            StepBuilder nextB = new StepBuilder(this.designBuilder, null, next);
            for (Step pred : rel.getPredec()) {
                StepBuilder predB = new StepBuilder(this.designBuilder, null, pred);
                nextB.hasOneInputPinNamed("token" + pred.getName()).activatedBy(predB).build();
            }
        }
    }
}

