/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.builder.design;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.time4sys.builder.ProjectBuilder;
import org.polarsys.time4sys.builder.design.AlarmBuilder;
import org.polarsys.time4sys.builder.design.BusBuilder;
import org.polarsys.time4sys.builder.design.CommunicationChannelBuilder;
import org.polarsys.time4sys.builder.design.CommunicationMediaBuilder;
import org.polarsys.time4sys.builder.design.EndToEndFlowConstraintBuilder;
import org.polarsys.time4sys.builder.design.PrecedenceRelationBuilder;
import org.polarsys.time4sys.builder.design.ProcessorBuilder;
import org.polarsys.time4sys.builder.design.ReferenceBuilder;
import org.polarsys.time4sys.builder.design.StepBuilder;
import org.polarsys.time4sys.builder.design.TaskBuilder;
import org.polarsys.time4sys.builder.design.WorkloadEventBuilder;
import org.polarsys.time4sys.builder.simulation.SimulationBuilder;
import org.polarsys.time4sys.design.DesignFactory;
import org.polarsys.time4sys.design.DesignModel;
import org.polarsys.time4sys.marte.gqam.ArrivalPattern;
import org.polarsys.time4sys.marte.gqam.BehaviorScenario;
import org.polarsys.time4sys.marte.gqam.CommunicationChannel;
import org.polarsys.time4sys.marte.gqam.GqamFactory;
import org.polarsys.time4sys.marte.gqam.Once;
import org.polarsys.time4sys.marte.gqam.PeriodicPattern;
import org.polarsys.time4sys.marte.gqam.PrecedenceRelation;
import org.polarsys.time4sys.marte.gqam.Reference;
import org.polarsys.time4sys.marte.gqam.SlidingWindowPattern;
import org.polarsys.time4sys.marte.gqam.SporadicPattern;
import org.polarsys.time4sys.marte.gqam.Step;
import org.polarsys.time4sys.marte.gqam.WorkloadBehavior;
import org.polarsys.time4sys.marte.gqam.WorkloadEvent;
import org.polarsys.time4sys.marte.grm.CommunicationMedia;
import org.polarsys.time4sys.marte.grm.GrmFactory;
import org.polarsys.time4sys.marte.grm.Resource;
import org.polarsys.time4sys.marte.grm.ResourcePackage;
import org.polarsys.time4sys.marte.hrm.HardwareBus;
import org.polarsys.time4sys.marte.hrm.HardwareProcessor;
import org.polarsys.time4sys.marte.hrm.HrmFactory;
import org.polarsys.time4sys.marte.nfp.Duration;
import org.polarsys.time4sys.marte.nfp.NfpFactory;
import org.polarsys.time4sys.marte.nfp.coreelements.PackageableElement;
import org.polarsys.time4sys.marte.sam.EndToEndFlow;
import org.polarsys.time4sys.marte.srm.Alarm;
import org.polarsys.time4sys.marte.srm.SoftwareSchedulableResource;
import org.polarsys.time4sys.marte.srm.SrmFactory;
import org.polarsys.time4sys.model.time4sys.Simulation;
import org.polarsys.time4sys.model.time4sys.Time4sysFactory;

public class DesignBuilder {
    protected static DesignFactory df = DesignFactory.eINSTANCE;
    protected static GqamFactory gqamFactory = GqamFactory.eINSTANCE;
    protected static SrmFactory srmFactory = SrmFactory.eINSTANCE;
    protected static GrmFactory grmFactory = GrmFactory.eINSTANCE;
    protected static HrmFactory hrmFactory = HrmFactory.eINSTANCE;
    protected static NfpFactory nfpFactory = NfpFactory.eINSTANCE;
    private DesignModel design;
    private ProjectBuilder prjBuidler;

    public static DesignBuilder containing(EObject value) {
        value = DesignBuilder.searchDesign(value);
        return new DesignBuilder((DesignModel)value);
    }

    public static DesignModel searchDesign(EObject value) {
        while (value != null && !(value instanceof DesignModel)) {
            value = value.eContainer();
        }
        return (DesignModel)value;
    }

    public DesignBuilder(DesignModel model) {
        this.design = model;
        if (model == null) {
            this.design = df.createDesignModel();
            WorkloadBehavior behavior = gqamFactory.createWorkloadBehavior();
            this.design.setWorkloadBehavior(behavior);
            ResourcePackage resPkg = grmFactory.createResourcePackage();
            this.design.setResourcePackage(resPkg);
        }
    }

    public DesignBuilder(ProjectBuilder projectBuilder, DesignModel designModel) {
        this(designModel);
        this.prjBuidler = projectBuilder;
    }

    public ProcessorBuilder hasAProcessor() {
        HardwareProcessor proc = hrmFactory.createHardwareProcessor();
        this.design.getResourcePackage().getOwnedElement().add((Object)proc);
        return new ProcessorBuilder(this, proc);
    }

    public AlarmBuilder hasAWatchdog() {
        return new AlarmBuilder(this, null).usedAsAWatchdog();
    }

    public CommunicationMediaBuilder hasCommunicationMedia() {
        CommunicationMedia bus = grmFactory.createCommunicationMedia();
        this.design.getResourcePackage().getOwnedElement().add((Object)bus);
        return new CommunicationMediaBuilder(this, bus);
    }

    public BusBuilder hasANetwork() {
        HardwareBus bus = hrmFactory.createHardwareBus();
        this.design.getResourcePackage().getOwnedElement().add((Object)bus);
        return new BusBuilder(this, bus);
    }

    public WorkloadEventBuilder hasAPeriodicEvent(String periodValue) {
        Duration period = nfpFactory.createDurationFromString(periodValue);
        WorkloadEvent taskActivation = gqamFactory.createWorkloadEvent();
        this.design.getWorkloadBehavior().getDemand().add((Object)taskActivation);
        PeriodicPattern pattern = gqamFactory.createPeriodicPattern();
        pattern.setPeriod(period);
        taskActivation.setPattern((ArrivalPattern)pattern);
        return new WorkloadEventBuilder(this, taskActivation);
    }

    public WorkloadEventBuilder hasASlidingWindowEvent(int nbEvents, String windowSizeValue) {
        Duration windowSize = nfpFactory.createDurationFromString(windowSizeValue);
        WorkloadEvent taskActivation = gqamFactory.createWorkloadEvent();
        this.design.getWorkloadBehavior().getDemand().add((Object)taskActivation);
        SlidingWindowPattern pattern = gqamFactory.createSlidingWindowPattern();
        pattern.setWindowSize(windowSize);
        pattern.setNbEvents((long)nbEvents);
        taskActivation.setPattern((ArrivalPattern)pattern);
        return new WorkloadEventBuilder(this, taskActivation);
    }

    public WorkloadEventBuilder hasSporadicEvent(String minInterarrivalStr, String maxInterarrivalStr) {
        Duration value;
        WorkloadEvent taskActivation = gqamFactory.createWorkloadEvent();
        this.design.getWorkloadBehavior().getDemand().add((Object)taskActivation);
        SporadicPattern pattern = gqamFactory.createSporadicPattern();
        if (minInterarrivalStr != null) {
            value = nfpFactory.createDurationFromString(minInterarrivalStr);
            pattern.setMinInterarrival(value);
        }
        if (maxInterarrivalStr != null) {
            value = nfpFactory.createDurationFromString(maxInterarrivalStr);
            pattern.setMaxInterarrival(value);
        }
        taskActivation.setPattern((ArrivalPattern)pattern);
        return new WorkloadEventBuilder(this, taskActivation);
    }

    public WorkloadEventBuilder hasActivationOnce() {
        WorkloadEvent taskActivation = gqamFactory.createWorkloadEvent();
        this.design.getWorkloadBehavior().getDemand().add((Object)taskActivation);
        Once pattern = gqamFactory.createOnce();
        taskActivation.setPattern((ArrivalPattern)pattern);
        return new WorkloadEventBuilder(this, taskActivation);
    }

    public DesignModel build() {
        return this.design;
    }

    public int countTasks() {
        return DesignBuilder.countTasks(this.design);
    }

    private static int countTasks(DesignModel design) {
        assert (design != null);
        assert (design.getResourcePackage() != null);
        return DesignBuilder.countTasks((List<? extends PackageableElement>)design.getResourcePackage().getOwnedElement());
    }

    private static int countTasks(List<? extends PackageableElement> elts) {
        int t = 0;
        for (PackageableElement packageableElement : elts) {
            if (packageableElement instanceof SoftwareSchedulableResource) {
                ++t;
            }
            if (!(packageableElement instanceof Resource)) continue;
            t += DesignBuilder.countTasks((List<? extends PackageableElement>)((Resource)packageableElement).getOwnedResource());
        }
        return t;
    }

    public TaskBuilder task(String name) {
        SoftwareSchedulableResource task = DesignBuilder.searchTask((List<? extends PackageableElement>)this.design.getResourcePackage().getOwnedElement(), name);
        if (task == null) {
            return null;
        }
        return new TaskBuilder(this, task);
    }

    public CommunicationChannelBuilder message(String name) {
        CommunicationChannel task = DesignBuilder.searchCommunicationChannel((List<? extends PackageableElement>)this.design.getResourcePackage().getOwnedElement(), name);
        if (task == null) {
            return null;
        }
        return new CommunicationChannelBuilder(this, task);
    }

    private static SoftwareSchedulableResource searchTask(List<? extends PackageableElement> elts, String name) {
        for (PackageableElement packageableElement : elts) {
            SoftwareSchedulableResource sub;
            if (packageableElement instanceof SoftwareSchedulableResource && name.equals(((SoftwareSchedulableResource)packageableElement).getName())) {
                return (SoftwareSchedulableResource)packageableElement;
            }
            if (!(packageableElement instanceof Resource) || (sub = DesignBuilder.searchTask((List<? extends PackageableElement>)((Resource)packageableElement).getOwnedResource(), name)) == null) continue;
            return sub;
        }
        return null;
    }

    public AlarmBuilder watchdog(String name) {
        return this.alarm(name);
    }

    public AlarmBuilder alarm(String name) {
        Alarm alarm = DesignBuilder.searchAlarm((List<? extends PackageableElement>)this.design.getResourcePackage().getOwnedElement(), name);
        if (alarm == null) {
            return null;
        }
        return new AlarmBuilder(this, alarm);
    }

    private static Alarm searchAlarm(List<? extends PackageableElement> elts, String name) {
        for (PackageableElement packageableElement : elts) {
            Alarm sub;
            if (packageableElement instanceof Alarm && name.equals(((Alarm)packageableElement).getName())) {
                return (Alarm)packageableElement;
            }
            if (!(packageableElement instanceof Resource) || (sub = DesignBuilder.searchAlarm((List<? extends PackageableElement>)((Resource)packageableElement).getOwnedResource(), name)) == null) continue;
            return sub;
        }
        return null;
    }

    private static CommunicationChannel searchCommunicationChannel(List<? extends PackageableElement> elts, String name) {
        for (PackageableElement packageableElement : elts) {
            CommunicationChannel sub;
            if (packageableElement instanceof CommunicationChannel && name.equals(((CommunicationChannel)packageableElement).getName())) {
                return (CommunicationChannel)packageableElement;
            }
            if (!(packageableElement instanceof Resource) || (sub = DesignBuilder.searchCommunicationChannel((List<? extends PackageableElement>)((Resource)packageableElement).getOwnedResource(), name)) == null) continue;
            return sub;
        }
        return null;
    }

    public Collection<Step> allSteps() {
        HashSet<Step> steps = new HashSet<Step>();
        for (BehaviorScenario behav : this.design.getWorkloadBehavior().getBehavior()) {
            if (behav instanceof Step) {
                steps.add((Step)behav);
            }
            steps.addAll((Collection<Step>)behav.getSteps());
        }
        return steps;
    }

    public int countSteps() {
        return this.allSteps().size();
    }

    public StepBuilder step(String name) {
        for (Step step : this.allSteps()) {
            if (!name.equals(step.getName())) continue;
            return new StepBuilder(this, this.task(step.getConcurRes().getName()), step);
        }
        throw new IllegalStateException("Step must have been already declared");
    }

    public StepBuilder aStep() {
        return new StepBuilder(this, null);
    }

    public int countPrecedenceRelations() {
        int c = 0;
        for (BehaviorScenario behav : this.design.getWorkloadBehavior().getBehavior()) {
            c += behav.getConnectors().size();
        }
        return c;
    }

    public PrecedenceRelationBuilder hasAPrecedenceRelation() {
        return new PrecedenceRelationBuilder(this);
    }

    public BehaviorScenario getMainScenario() {
        if (this.build().getWorkloadBehavior().getBehavior().isEmpty()) {
            BehaviorScenario mainScenario = gqamFactory.createBehaviorScenario();
            mainScenario.setName("main");
            this.build().getWorkloadBehavior().getBehavior().add((Object)mainScenario);
        }
        return (BehaviorScenario)this.build().getWorkloadBehavior().getBehavior().get(0);
    }

    public DesignBuilder called(String name) {
        this.design.setName(name);
        return this;
    }

    public List<PrecedenceRelation> allPrecedenceRelations() {
        LinkedList<PrecedenceRelation> result = new LinkedList<PrecedenceRelation>();
        for (BehaviorScenario behav : this.design.getWorkloadBehavior().getBehavior()) {
            result.addAll((Collection<PrecedenceRelation>)behav.getConnectors());
        }
        return result;
    }

    public void has(EndToEndFlowConstraintBuilder ... values) {
        EndToEndFlowConstraintBuilder[] endToEndFlowConstraintBuilderArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            EndToEndFlowConstraintBuilder cst = endToEndFlowConstraintBuilderArray[n2];
            cst.build(this);
            ++n2;
        }
    }

    public ProjectBuilder getProject() {
        if (this.prjBuidler != null) {
            return this.prjBuidler;
        }
        this.prjBuidler = new ProjectBuilder(this);
        return this.prjBuidler;
    }

    public DesignBuilder isNamed(String name) {
        this.design.setName(name);
        return this;
    }

    public SimulationBuilder hasASimulation() {
        if (this.prjBuidler == null) {
            Simulation simu = Time4sysFactory.eINSTANCE.createSimulation();
            return new SimulationBuilder(this.prjBuidler, simu).of(this);
        }
        SimulationBuilder result = this.prjBuidler.hasASimulation().of(this);
        return result;
    }

    public EndToEndFlowConstraintBuilder firstEndToEndFlowsConstraints() {
        EndToEndFlow first = (EndToEndFlow)this.design.getEndToEndFlows().get(0);
        return new EndToEndFlowConstraintBuilder(first);
    }

    public ReferenceBuilder hasAReference() {
        return new ReferenceBuilder(this);
    }

    public boolean addReference(Reference ref) {
        return this.design.getWorkloadBehavior().getReferences().add((Object)ref);
    }

    public ReferenceBuilder reference(String refname) {
        for (Reference ref : this.design.getWorkloadBehavior().getReferences()) {
            if (!refname.equals(ref.getReferenceName())) continue;
            return new ReferenceBuilder(ref);
        }
        return null;
    }
}

