/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.felix.gogo.runtime.Closure;
import org.apache.felix.gogo.runtime.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pipe
extends Thread {
    static final ThreadLocal<InputStream> tIn = new ThreadLocal();
    static final ThreadLocal<PrintStream> tOut = new ThreadLocal();
    static final ThreadLocal<PrintStream> tErr = new ThreadLocal();
    InputStream in;
    PrintStream out;
    PrintStream err;
    PipedOutputStream pout;
    Closure closure;
    Exception exception;
    Object result;
    List<Token> statement;

    public static Object[] mark() {
        Object[] mark = new Object[]{tIn.get(), tOut.get(), tErr.get()};
        return mark;
    }

    public static void reset(Object[] mark) {
        tIn.set((InputStream)mark[0]);
        tOut.set((PrintStream)mark[1]);
        tErr.set((PrintStream)mark[2]);
    }

    public Pipe(Closure closure, List<Token> statement) {
        super("pipe-" + statement);
        this.closure = closure;
        this.statement = statement;
        this.in = tIn.get();
        this.out = tOut.get();
        this.err = tErr.get();
    }

    @Override
    public String toString() {
        return "pipe<" + this.statement + "> out=" + this.out;
    }

    public void setIn(InputStream in) {
        this.in = in;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public void setErr(PrintStream err) {
        this.err = err;
    }

    public Pipe connect(Pipe next) throws IOException {
        next.setOut(this.out);
        next.setErr(this.err);
        this.pout = new PipedOutputStream();
        next.setIn(new PipedInputStream(this.pout));
        this.out = new PrintStream(this.pout);
        return next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block15: {
            block14: {
                tIn.set(this.in);
                tOut.set(this.out);
                tErr.set(this.err);
                this.closure.session().threadIO().setStreams(this.in, this.out, this.err);
                this.result = this.closure.executeStatement(this.statement);
                if (this.result == null || this.pout == null || Boolean.FALSE.equals(this.closure.session().get(".FormatPipe"))) break block14;
                this.out.println(this.closure.session().format(this.result, 0));
            }
            Object var3_1 = null;
            this.out.flush();
            this.closure.session().threadIO().close();
            try {
                if (this.pout != null) {
                    this.pout.close();
                }
                if (this.in instanceof PipedInputStream) {
                    this.in.close();
                    Method m = this.in.getClass().getDeclaredMethod("receivedLast", null);
                    m.setAccessible(true);
                    m.invoke((Object)this.in, (Object[])null);
                }
                break block15;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            break block15;
            {
                catch (Exception e) {
                    this.exception = e;
                    Object var3_2 = null;
                    this.out.flush();
                    this.closure.session().threadIO().close();
                    try {
                        if (this.pout != null) {
                            this.pout.close();
                        }
                        if (this.in instanceof PipedInputStream) {
                            this.in.close();
                            Method m = this.in.getClass().getDeclaredMethod("receivedLast", null);
                            m.setAccessible(true);
                            m.invoke((Object)this.in, (Object[])null);
                        }
                        break block15;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.out.flush();
                this.closure.session().threadIO().close();
                try {
                    if (this.pout != null) {
                        this.pout.close();
                    }
                    if (this.in instanceof PipedInputStream) {
                        this.in.close();
                        Method m = this.in.getClass().getDeclaredMethod("receivedLast", null);
                        m.setAccessible(true);
                        m.invoke((Object)this.in, (Object[])null);
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
        }
    }
}

