/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.viewpoint;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ui.tools.api.views.ViewHelper;
import org.eclipse.sirius.ui.tools.internal.viewpoint.ViewpointHelper;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;

public class ViewpointsSelectionGraphicalHandler {
    private static final String HTML_TAG_REGEXP = "<[^/>]*/>";
    private static final String HTML_TAG_REGEXP_WITHOUT_CLOSING_CHARACTER = "<[^>]*>";
    private static final String BROWSER_SUFFIX = "</b></center>";
    private static final String BROWSER_PREFIX = "<br><br><center><b>";
    private GridLayout rootGridLayout;
    private Browser browser;
    private Composite rootComposite;
    private GridData browserGridData;
    private CheckboxTableViewer viewer;
    private GridData rootLayoutData;
    private GridData viewerGridData;
    private GridData browserErrorMessageLayoutData;
    private Text browserErrorMessageText;
    private Composite browserErrorMessageComposite;
    private Composite browserRootComposite;
    private Composite browserReplacementComposite;
    private Text browserReplacementText;

    public Composite getRootComposite() {
        return this.rootComposite;
    }

    public Composite getBrowser() {
        if (this.browser != null) {
            return this.browser;
        }
        return this.browserRootComposite;
    }

    public Composite getBrowserRootComposite() {
        return this.browserRootComposite;
    }

    public Collection<String> computeSemanticFileExtensions(Session theSession) {
        HashSet<String> extensions = new HashSet<String>();
        for (Resource resource : theSession.getSemanticResources()) {
            String currentFileExtension;
            if (resource == null || resource.getURI() == null || (currentFileExtension = resource.getURI().fileExtension()) == null) continue;
            extensions.add(currentFileExtension);
        }
        return extensions;
    }

    public void createControl(Composite parent, boolean makeColumnsEqual) {
        this.rootComposite = new Composite(parent, 0);
        this.rootGridLayout = GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(makeColumnsEqual).create();
        this.rootComposite.setLayout((Layout)this.rootGridLayout);
        this.rootLayoutData = new GridData(4, 4, true, true);
        this.rootComposite.setLayoutData((Object)this.rootLayoutData);
        this.createTableViewer(this.rootComposite);
        this.createBrowser(this.rootComposite);
        this.setBrowserInput(null);
    }

    public Composite createBrowser(Composite parent) {
        this.browserRootComposite = new Composite(parent, 2048);
        this.browserRootComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.browserRootComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.browserErrorMessageComposite = new Composite(this.browserRootComposite, 0);
        this.browserErrorMessageComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.browserErrorMessageLayoutData = new GridData(4, 4, true, false);
        this.browserErrorMessageComposite.setLayoutData((Object)this.browserErrorMessageLayoutData);
        this.browserErrorMessageLayoutData.exclude = true;
        Composite browserComposite = new Composite(this.browserRootComposite, 0);
        browserComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        browserComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.browserErrorMessageText = new Text(this.browserErrorMessageComposite, 66);
        this.browserErrorMessageText.setLayoutData((Object)new GridData(16384, 128, true, false));
        this.browserErrorMessageText.setText("");
        this.browserErrorMessageText.setForeground(this.browserRootComposite.getDisplay().getSystemColor(3));
        try {
            this.browser = new Browser(browserComposite, 4);
            this.browserGridData = new GridData(4, 4, true, true);
            this.browserGridData.widthHint = 0;
            this.browserGridData.heightHint = 0;
            this.browser.setLayoutData((Object)this.browserGridData);
            return this.browser;
        }
        catch (SWTError e) {
            if (e.code == 2) {
                SiriusEditPlugin.getPlugin().getLog().log((IStatus)new Status(2, "org.eclipse.sirius", Messages.OpenViewpointSelectionBrowser_Error_Message, (Throwable)e));
                this.browserReplacementComposite = new Composite(browserComposite, 0);
                this.browserReplacementComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
                this.browserGridData = new GridData(4, 4, true, true);
                this.browserGridData.widthHint = 0;
                this.browserGridData.heightHint = 0;
                this.browserReplacementComposite.setLayoutData((Object)this.browserGridData);
                this.browserReplacementText = new Text(this.browserReplacementComposite, 66);
                this.browserReplacementText.setLayoutData((Object)new GridData(4, 4, true, true));
                this.browserReplacementText.setText("");
                this.setBrowserErrorMessageText(Messages.No_Browser_Error_Message);
                return this.browserReplacementComposite;
            }
            throw e;
        }
    }

    public void setBrowserErrorMessageText(String errorMessage) {
        this.browserErrorMessageLayoutData.exclude = false;
        this.browserErrorMessageText.setText(errorMessage);
        this.browserErrorMessageComposite.setVisible(true);
        this.browserRootComposite.layout(true, true);
    }

    public void clearBrowserErrorMessageText() {
        this.browserErrorMessageLayoutData.exclude = true;
        this.browserErrorMessageText.setText("");
        this.browserErrorMessageComposite.setVisible(false);
        this.browserRootComposite.getParent().layout(true, true);
    }

    public void setBrowserMinWidth(int minwidth) {
        if (this.browserGridData != null) {
            this.browserGridData.minimumWidth = minwidth;
        }
    }

    public CheckboxTableViewer getViewer() {
        return this.viewer;
    }

    private TableViewer createTableViewer(Composite parent) {
        this.viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2820);
        Table table = this.viewer.getTable();
        this.viewerGridData = new GridData(4, 4, false, false);
        this.viewer.getControl().setLayoutData((Object)this.viewerGridData);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewpointsTableLabelProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object firstElement;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof Viewpoint) {
                    ViewpointsSelectionGraphicalHandler.this.setBrowserInput((Viewpoint)firstElement);
                }
            }
        });
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer theViewer, Object e1, Object e2) {
                String e1label = new IdentifiedElementQuery((IdentifiedElement)((Viewpoint)e1)).getLabel();
                String e2label = new IdentifiedElementQuery((IdentifiedElement)((Viewpoint)e2)).getLabel();
                return e1label.compareTo(e2label);
            }
        });
        return this.viewer;
    }

    public void setBrowserInput(Viewpoint viewpoint) {
        if (this.browser != null && viewpoint != null) {
            String content = this.getDocumentation(viewpoint.getEndUserDocumentation(), (EObject)viewpoint, true);
            this.browser.setText(content);
        } else if (this.browserReplacementText != null && viewpoint != null) {
            String content = this.getDocumentation(viewpoint.getEndUserDocumentation(), (EObject)viewpoint, false);
            this.browserReplacementText.setText(content);
        } else if (this.browser != null) {
            this.browser.setText(BROWSER_PREFIX + Messages.ViewpointsSelectionWizardPage_documentation_none + BROWSER_SUFFIX);
        } else if (this.browserReplacementText != null) {
            this.browserReplacementText.setText(BROWSER_PREFIX + Messages.ViewpointsSelectionWizardPage_documentation_none + BROWSER_SUFFIX);
        }
    }

    public void setBrowserInput(Viewpoint viewpoint, RepresentationDescription representationDescription) {
        if (this.browser != null && representationDescription != null && viewpoint != null) {
            String content = this.getRepresentationDescription(viewpoint, representationDescription, true);
            this.browser.setText(content);
        } else if (this.browserReplacementText != null && viewpoint != null) {
            String content = this.getRepresentationDescription(viewpoint, representationDescription, false);
            this.browserReplacementText.setText(content);
        } else if (this.browser != null) {
            this.browser.setText(BROWSER_PREFIX + Messages.ViewpointsSelectionWizardPage_documentation_none + BROWSER_SUFFIX);
        } else if (this.browserReplacementText != null) {
            this.browserReplacementText.setText(BROWSER_PREFIX + Messages.ViewpointsSelectionWizardPage_documentation_none + BROWSER_SUFFIX);
        }
    }

    private String getRepresentationDescription(Viewpoint viewpoint, RepresentationDescription representationDescription, boolean addHtmlContent) {
        RepresentationDescription resource;
        String userDocumentation;
        if (!StringUtil.isEmpty((String)representationDescription.getEndUserDocumentation())) {
            userDocumentation = representationDescription.getEndUserDocumentation();
            resource = representationDescription;
        } else {
            userDocumentation = viewpoint.getEndUserDocumentation();
            resource = viewpoint;
        }
        return this.getDocumentation(userDocumentation, (EObject)resource, addHtmlContent);
    }

    private String getDocumentation(String endUserDocumentation, EObject resource, boolean addHtmlContent) {
        String content = addHtmlContent && this.containsHTMLDocumentation(endUserDocumentation) ? this.getContentWhenHtml(endUserDocumentation, resource.eResource().getURI()) : (addHtmlContent ? this.getContentWhenNoHtml(endUserDocumentation) : endUserDocumentation.replaceAll(HTML_TAG_REGEXP, "").replaceAll(HTML_TAG_REGEXP_WITHOUT_CLOSING_CHARACTER, ""));
        return content;
    }

    private boolean containsHTMLDocumentation(String endUserDocumentation) {
        if (!StringUtil.isEmpty((String)endUserDocumentation)) {
            return endUserDocumentation.startsWith("<html>");
        }
        return false;
    }

    private String getContentWhenHtml(String endUserDocumentation, URI uri) {
        LinkedHashSet urlToRewrite = Sets.newLinkedHashSet();
        this.extractUrlToRewrite(endUserDocumentation, urlToRewrite);
        return this.rewriteURLs(uri, endUserDocumentation, urlToRewrite);
    }

    private void extractUrlToRewrite(String document, Set<String> urlToRewrite) {
        int imgSrcStartIndex;
        int imgSrcStopIndex;
        String imgSrcPattern = "img src=\"";
        int patternStartIndex = document.indexOf(imgSrcPattern);
        if (patternStartIndex != -1 && (imgSrcStopIndex = document.indexOf("\"", imgSrcStartIndex = patternStartIndex + imgSrcPattern.length())) != -1) {
            String newToRewrite = document.substring(imgSrcStartIndex, imgSrcStopIndex);
            urlToRewrite.add(newToRewrite);
            this.extractUrlToRewrite(document.substring(imgSrcStopIndex), urlToRewrite);
        }
    }

    private String rewriteURLs(URI uri, String document, Set<String> urls) {
        String newDocument = document;
        for (String url : urls) {
            newDocument = newDocument.replace(url, this.rewriteURL(uri, url));
        }
        StringBuilder css = new StringBuilder();
        this.appendCss(css);
        String headClose = "</head>";
        newDocument = newDocument.replace(headClose, css.append(headClose));
        return newDocument;
    }

    private String rewriteURL(URI uri, String url) {
        String pluginId = uri.segment(1);
        String rewrittenURL = "";
        if (uri.isPlatformPlugin()) {
            Bundle bundle = Platform.getBundle((String)pluginId);
            URL imageURL = bundle.getEntry(url);
            String string = rewrittenURL = imageURL != null ? imageURL.toString() : rewrittenURL;
            if (imageURL != null) {
                try {
                    URL fileURL = FileLocator.toFileURL((URL)imageURL);
                    rewrittenURL = fileURL.toString();
                }
                catch (IOException iOException) {}
            }
        } else {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            Path path = new Path("/" + pluginId + url);
            if (workspace.getRoot().exists((IPath)path)) {
                IResource resource = workspace.getRoot().findMember((IPath)path);
                rewrittenURL = resource.getLocation().toFile().toURI().toString();
            }
        }
        return rewrittenURL;
    }

    private String getContentWhenNoHtml(String endUserDocumentation) {
        StringBuilder content = new StringBuilder();
        return this.begin(content).head(content).body(content, endUserDocumentation).end(content);
    }

    private ViewpointsSelectionGraphicalHandler begin(StringBuilder content) {
        content.append("<html>");
        return this;
    }

    private ViewpointsSelectionGraphicalHandler head(StringBuilder content) {
        content.append("<head>");
        this.appendCss(content);
        content.append("</head>");
        return this;
    }

    private ViewpointsSelectionGraphicalHandler body(StringBuilder content, String endUserDocumentation) {
        content.append("<body>");
        if (!StringUtil.isEmpty((String)endUserDocumentation)) {
            content.append(endUserDocumentation);
        } else {
            content.append(Messages.ViewpointsSelectionWizardPage_documentation_none);
        }
        content.append("</body>");
        return this;
    }

    private StringBuilder appendCss(StringBuilder content) {
        Font currentFont = JFaceResources.getDialogFont();
        FontData data = currentFont.getFontData()[0];
        String fontName = data.getName();
        int fontHeight = data.getHeight() + 3;
        content.append("<style type=\"text/css\">");
        content.append("body{font-family:" + fontName + ",Arial, sans-serif;}");
        content.append("body{font-size:" + fontHeight + "px;}");
        content.append("</style>");
        return content;
    }

    private String end(StringBuilder content) {
        content.append("</html>");
        return content.toString();
    }

    public void setHeight(int height) {
        this.viewerGridData.grabExcessVerticalSpace = false;
        this.viewerGridData.heightHint = height;
    }

    private class ViewpointsTableLabelProvider
    extends AdapterFactoryLabelProvider
    implements ITableLabelProvider {
        ViewpointsTableLabelProvider() {
            super(ViewHelper.INSTANCE.createAdapterFactory());
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Image image = null;
            if (columnIndex == 0) {
                if (element instanceof Viewpoint) {
                    Viewpoint vp = (Viewpoint)element;
                    image = ViewpointHelper.getImage(vp);
                } else {
                    image = super.getImage(element);
                }
            }
            return image;
        }
    }
}

