/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ds.internal.annotations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;
import org.eclipse.pde.ds.internal.annotations.ComponentPropertyTester;
import org.eclipse.pde.ds.internal.annotations.ComponentRefactoringParticipant;
import org.eclipse.pde.ds.internal.annotations.DSAnnotationCompilationParticipant;
import org.eclipse.pde.ds.internal.annotations.Debug;
import org.eclipse.pde.ds.internal.annotations.Messages;
import org.eclipse.pde.ds.internal.annotations.ProjectState;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.text.IDocumentAttributeNode;
import org.eclipse.pde.internal.ds.core.IDSComponent;
import org.eclipse.pde.internal.ds.core.text.DSModel;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class ComponentRefactoringHelper {
    private static final Debug debug = Debug.getDebug("component-refactoring-helper");
    private final HashMap<Object, RefactoringArguments> elements = new HashMap();
    private Map<IType, IFile> modelFiles;
    private Map<IFile, String> componentNames;
    private Map<IFile, IFile> renames;
    private final RefactoringParticipant participant;

    public ComponentRefactoringHelper(RefactoringParticipant participant) {
        this.participant = participant;
    }

    public boolean initialize(Object element) {
        this.elements.put(element, this.getArguments());
        return true;
    }

    private RefactoringArguments getArguments() {
        if (this.participant instanceof RenameParticipant) {
            return ((RenameParticipant)this.participant).getArguments();
        }
        if (this.participant instanceof MoveParticipant) {
            return ((MoveParticipant)this.participant).getArguments();
        }
        return null;
    }

    public void addElement(Object element, RefactoringArguments arguments) {
        this.elements.put(element, arguments);
    }

    public RefactoringStatus checkConditions(IProgressMonitor monitor, CheckConditionsContext context) throws OperationCanceledException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ComponentRefactoringHelper_checkConditionsTaskLabel, (int)this.elements.size());
        try {
            this.modelFiles = new HashMap<IType, IFile>(this.elements.size());
            this.componentNames = new HashMap<IFile, String>(this.elements.size());
            this.renames = new HashMap<IFile, IFile>(this.elements.size());
            HashMap<IJavaProject, ProjectState> states = new HashMap<IJavaProject, ProjectState>();
            HashSet<IJavaProject> unmanaged = new HashSet<IJavaProject>();
            ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
            IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
            for (Map.Entry<Object, RefactoringArguments> entry : this.elements.entrySet()) {
                IJavaElement element;
                IJavaProject javaProject;
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                progress.worked(1);
                RefactoringArguments args = entry.getValue();
                if (!this.getUpdateReferences(args) || unmanaged.contains(javaProject = (element = (IJavaElement)entry.getKey()).getJavaProject())) continue;
                ProjectState state = (ProjectState)states.get(javaProject);
                if (state == null) {
                    state = DSAnnotationCompilationParticipant.getState(javaProject);
                }
                if (state == null) {
                    unmanaged.add(javaProject);
                    continue;
                }
                states.put(javaProject, state);
                if (element.getElementType() == 7) {
                    this.createRenames((IType)element, args, state, deltaFactory);
                    continue;
                }
                if (element.getElementType() != 4) continue;
                this.createRenames((IPackageFragment)element, args, state, deltaFactory);
            }
            return new RefactoringStatus();
        }
        catch (JavaModelException e) {
            return RefactoringStatus.create((IStatus)e.getStatus());
        }
    }

    private boolean getUpdateReferences(RefactoringArguments args) {
        if (args instanceof RenameArguments) {
            return ((RenameArguments)args).getUpdateReferences();
        }
        if (args instanceof MoveArguments) {
            return ((MoveArguments)args).getUpdateReferences();
        }
        return false;
    }

    private void createRenames(IPackageFragment fragment, RefactoringArguments args, ProjectState state, IResourceChangeDescriptionFactory deltaFactory) throws JavaModelException {
        String compName = this.getComponentName((IJavaElement)fragment, args);
        ICompilationUnit[] iCompilationUnitArray = fragment.getCompilationUnits();
        int n = iCompilationUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit cu = iCompilationUnitArray[n2];
            IType[] iTypeArray = cu.getTypes();
            int n3 = iTypeArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IType type = iTypeArray[n4];
                this.createRenames(type, type, compName.length() == 0 ? type.getElementName() : String.format("%s.%s", compName, type.getElementName()), args, state, deltaFactory);
                ++n4;
            }
            ++n2;
        }
    }

    private void createRenames(IType type, RefactoringArguments args, ProjectState state, IResourceChangeDescriptionFactory deltaFactory) throws JavaModelException {
        this.createRenames(type, type, this.getComponentName((IJavaElement)type, args), args, state, deltaFactory);
    }

    private void createRenames(IType type, IType rootType, String rootName, RefactoringArguments args, ProjectState state, IResourceChangeDescriptionFactory deltaFactory) throws JavaModelException {
        if (ComponentPropertyTester.hasImplicitName(type)) {
            IProject project;
            IFile modelFile;
            String modelPath = state.getModelFile(type.getFullyQualifiedName());
            if (modelPath != null && (modelFile = PDEProject.getBundleRelativeFile((IProject)(project = type.getJavaProject().getProject()), (IPath)Path.fromPortableString((String)modelPath))).isAccessible()) {
                this.modelFiles.put(type, modelFile);
                deltaFactory.change(modelFile);
                String compName = String.format("%s%s", rootName, this.getTypeRelativeName(type, rootType));
                this.componentNames.put(modelFile, compName);
                IPath newPath = new Path(state.getPath()).addTrailingSeparator().append(compName).addFileExtension("xml");
                IFile newModelFile = PDEProject.getBundleRelativeFile((IProject)project, (IPath)newPath);
                this.renames.put(modelFile, newModelFile);
                deltaFactory.move((IResource)modelFile, newModelFile.getFullPath());
            }
        } else if (debug.isDebugging()) {
            debug.trace(String.format("Type %s does not have implicit component name.", type.getFullyQualifiedName()));
        }
        IType[] iTypeArray = type.getTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType child = iTypeArray[n2];
            this.createRenames(child, rootType, rootName, args, state, deltaFactory);
            ++n2;
        }
    }

    private String getComponentName(IJavaElement element, RefactoringArguments args) {
        return ((ComponentRefactoringParticipant)this.participant).getComponentNameRoot(element, args);
    }

    private String getTypeRelativeName(IType type, IType rootType) {
        ArrayList<String> segments = new ArrayList<String>(2);
        while (type != null && !type.equals(rootType)) {
            segments.add(type.getElementName());
            type = type.getDeclaringType();
        }
        StringBuilder buf = new StringBuilder();
        ListIterator i = segments.listIterator(segments.size());
        while (i.hasPrevious()) {
            buf.append('$').append((String)i.previous());
        }
        return buf.toString();
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ComponentRefactoringHelper_createChangeTaskLabel, (int)this.elements.size());
        CompositeChange compositeChange = new CompositeChange(Messages.ComponentRefactoringHelper_topLevelChangeLabel);
        for (Map.Entry<Object, RefactoringArguments> entry : this.elements.entrySet()) {
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            progress.worked(1);
            RefactoringArguments args = entry.getValue();
            if (!this.getUpdateReferences(args)) continue;
            IJavaElement element = (IJavaElement)entry.getKey();
            if (element.getElementType() == 4) {
                this.collectChanges((IPackageFragment)element, compositeChange);
                continue;
            }
            if (element.getElementType() != 7) continue;
            this.collectChanges((IType)element, compositeChange);
        }
        return compositeChange;
    }

    private void collectChanges(IPackageFragment fragment, CompositeChange compositeChange) throws CoreException {
        ICompilationUnit[] iCompilationUnitArray = fragment.getCompilationUnits();
        int n = iCompilationUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit cu = iCompilationUnitArray[n2];
            IType[] iTypeArray = cu.getTypes();
            int n3 = iTypeArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IType type = iTypeArray[n4];
                this.collectChanges(type, compositeChange);
                ++n4;
            }
            ++n2;
        }
    }

    private void collectChanges(IType type, CompositeChange compositeChange) throws CoreException {
        Change change = this.createChange(type);
        if (change != null) {
            compositeChange.add(change);
        }
        IType[] iTypeArray = type.getTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType child = iTypeArray[n2];
            this.collectChanges(child, compositeChange);
            ++n2;
        }
    }

    private Change createChange(IType type) throws CoreException {
        IDocumentAttributeNode attrClass;
        IDocumentAttributeNode attrName;
        IFile modelFile = this.modelFiles.get(type);
        if (modelFile == null) {
            return null;
        }
        String componentName = this.componentNames.get(modelFile);
        if (componentName == null) {
            return null;
        }
        IFile newModelFile = this.renames.get(modelFile);
        if (newModelFile == null) {
            return null;
        }
        if (debug.isDebugging()) {
            debug.trace(String.format("Changing %s from %s to %s.", type.getFullyQualifiedName(), modelFile.getFullPath(), newModelFile.getFullPath()));
        }
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        manager.connect(modelFile.getFullPath(), LocationKind.IFILE, null);
        DSModel model = null;
        try {
            ITextFileBuffer buf = manager.getTextFileBuffer(modelFile.getFullPath(), LocationKind.IFILE);
            if (buf == null) {
                return null;
            }
            IDocument doc = buf.getDocument();
            model = new DSModel(doc, false);
            model.setUnderlyingResource((IResource)modelFile);
            model.setCharset(modelFile.getCharset());
            model.load();
            IDSComponent component = model.getDSComponent();
            attrName = component.getDocumentAttribute("name");
            attrClass = component.getImplementation().getDocumentAttribute("class");
        }
        finally {
            if (model != null) {
                model.dispose();
            }
            manager.disconnect(modelFile.getFullPath(), LocationKind.IFILE, null);
        }
        CompositeChange change = new CompositeChange(attrName.getAttributeValue());
        TextFileChange textChange = new TextFileChange(modelFile.getName(), modelFile);
        textChange.setTextType("xml");
        textChange.setEdit((TextEdit)new MultiTextEdit());
        textChange.addEdit((TextEdit)new ReplaceEdit(attrName.getValueOffset(), attrName.getValueLength(), componentName));
        textChange.addEdit((TextEdit)new ReplaceEdit(attrClass.getValueOffset(), attrClass.getValueLength(), componentName));
        change.add((Change)textChange);
        RenameResourceChange renameChange = new RenameResourceChange(modelFile.getFullPath(), newModelFile.getName());
        change.add((Change)renameChange);
        return change;
    }
}

