/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.internal.environment;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.common.internal.utils.AcceleoPackageRegistry;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.event.IAcceleoTextGenerationListener;
import org.eclipse.acceleo.engine.generation.AbstractAcceleoEnvironmentFactory;
import org.eclipse.acceleo.engine.generation.strategy.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.engine.internal.environment.AcceleoEnvironment;
import org.eclipse.acceleo.engine.internal.environment.AcceleoEvaluationEnvironment;
import org.eclipse.acceleo.engine.internal.environment.AcceleoLibraryOperationVisitor;
import org.eclipse.acceleo.engine.internal.environment.AcceleoPropertiesLookup;
import org.eclipse.acceleo.engine.internal.evaluation.AcceleoEvaluationContext;
import org.eclipse.acceleo.engine.internal.evaluation.AcceleoEvaluationVisitor;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.EvaluationVisitor;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.SendSignalAction;

public class AcceleoEnvironmentFactory
extends AbstractAcceleoEnvironmentFactory {
    protected AcceleoEvaluationContext<EClassifier> context;
    private final Module module;
    private AcceleoPropertiesLookup propertiesLookup;

    public AcceleoEnvironmentFactory(File generationRoot, Module module, List<IAcceleoTextGenerationListener> listeners, AcceleoPropertiesLookup properties, IAcceleoGenerationStrategy strategy, Monitor monitor) {
        super((EPackage.Registry)AcceleoPackageRegistry.INSTANCE);
        this.context = new AcceleoEvaluationContext(generationRoot, listeners, strategy, monitor);
        this.propertiesLookup = properties;
        this.module = module;
    }

    public Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> createEnvironment() {
        AcceleoEnvironment result = new AcceleoEnvironment(this.getEPackageRegistry());
        result.setFactory((EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>)this);
        result.restoreBrokenEnvironmentPackages(this.module.eResource());
        return result;
    }

    public Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> createEnvironment(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> parent) {
        if (!(parent instanceof AcceleoEnvironment)) {
            throw new IllegalArgumentException(AcceleoEngineMessages.getString("AcceleoEnvironmentFactory.IllegalParent", parent.getClass().getName()));
        }
        AcceleoEnvironment result = new AcceleoEnvironment(parent);
        result.setFactory((EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>)this);
        result.restoreBrokenEnvironmentPackages(this.module.eResource());
        return result;
    }

    public EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> createEvaluationEnvironment() {
        return new AcceleoEvaluationEnvironment(this.module, this.propertiesLookup);
    }

    public EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> createEvaluationEnvironment(EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> parent) {
        return new AcceleoEvaluationEnvironment(parent, this.module, this.propertiesLookup);
    }

    public EvaluationVisitor<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> createEvaluationVisitor(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env, EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> evalEnv, Map<? extends EClass, ? extends Set<? extends EObject>> extentMap) {
        return new AcceleoEvaluationVisitor(super.createEvaluationVisitor(env, evalEnv, extentMap), this.context);
    }

    @Override
    public void dispose() {
        this.context.dispose();
        this.propertiesLookup = null;
        AcceleoLibraryOperationVisitor.dispose();
    }

    @Override
    public Map<String, String> getEvaluationPreview() {
        return this.context.getGenerationPreview();
    }

    @Override
    public void hookGenerationEnd() {
        this.context.hookGenerationEnd();
    }
}

