/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching.sourcelookup.advanced;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.sourcelookup.advanced.IJDIHelpers;

public final class JDIHelpers
implements IJDIHelpers {
    public static final String STRATA_ID = "jdt";
    private static final IStackFrame[] EMPTY_STACK = new IStackFrame[0];

    JDIHelpers() {
    }

    @Override
    public File getClassesLocation(Object element) throws DebugException {
        IJavaVariable javaVariable;
        IJavaType javaType;
        IJavaReferenceType declaringType = null;
        if (element instanceof IJavaStackFrame) {
            IJavaStackFrame stackFrame = (IJavaStackFrame)element;
            declaringType = stackFrame.getReferenceType();
        } else if (element instanceof IJavaObject) {
            IJavaType javaType2 = ((IJavaObject)element).getJavaType();
            if (javaType2 instanceof IJavaReferenceType) {
                declaringType = (IJavaReferenceType)javaType2;
            }
        } else if (element instanceof IJavaReferenceType) {
            declaringType = (IJavaReferenceType)element;
        } else if (element instanceof IJavaVariable && (javaType = ((IJavaValue)(javaVariable = (IJavaVariable)element).getValue()).getJavaType()) instanceof IJavaReferenceType) {
            declaringType = (IJavaReferenceType)javaType;
        }
        if (declaringType != null) {
            String[] locations = declaringType.getSourceNames(STRATA_ID);
            if (locations == null || locations.length < 2) {
                return null;
            }
            String spec = locations[1];
            try {
                URL url = new URL(spec);
                if ("file".equals(url.getProtocol())) {
                    return new File(url.toURI()).toPath().normalize().toFile();
                }
            }
            catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
                IStatus status = Status.error((String)("Unable to resolve class location from: '" + spec + "'"), (Throwable)e);
                LaunchingPlugin.log(status);
            }
        }
        return null;
    }

    @Override
    public String getSourcePath(Object element) throws DebugException {
        IJavaType javaType;
        IJavaReferenceType declaringType = null;
        if (element instanceof IJavaStackFrame) {
            IJavaStackFrame stackFrame = (IJavaStackFrame)element;
            String sourcePath = stackFrame.getSourcePath(STRATA_ID);
            if (sourcePath != null) {
                return sourcePath;
            }
            declaringType = stackFrame.getReferenceType();
        } else if (element instanceof IJavaObject) {
            javaType = ((IJavaObject)element).getJavaType();
            if (javaType instanceof IJavaReferenceType) {
                declaringType = (IJavaReferenceType)javaType;
            }
        } else if (element instanceof IJavaReferenceType) {
            declaringType = (IJavaReferenceType)element;
        } else if (element instanceof IJavaVariable && (javaType = ((IJavaVariable)element).getJavaType()) instanceof IJavaReferenceType) {
            declaringType = (IJavaReferenceType)javaType;
        }
        if (declaringType != null) {
            String[] sourcePaths = declaringType.getSourcePaths(STRATA_ID);
            if (sourcePaths != null && sourcePaths.length > 0 && sourcePaths[0] != null) {
                return sourcePaths[0];
            }
            return JDIHelpers.generateSourceName(declaringType.getName());
        }
        return null;
    }

    private IStackFrame[] getStackFrames(Object element) throws DebugException {
        if (element instanceof IStackFrame) {
            IStackFrame[] frames = ((IStackFrame)element).getThread().getStackFrames();
            int i = 0;
            while (i < frames.length - 1) {
                if (frames[i] == element) {
                    return Arrays.copyOfRange(frames, i + 1, frames.length);
                }
                ++i;
            }
        }
        return EMPTY_STACK;
    }

    @Override
    public Iterable<File> getStackFramesClassesLocations(Object element) throws DebugException {
        final IStackFrame[] stack = this.getStackFrames(element);
        return new Iterable<File>(){

            @Override
            public Iterator<File> iterator() {
                return Arrays.stream(stack).map(frame -> this.getClassesLocation((IStackFrame)frame)).filter(frameLocation -> frameLocation != null).iterator();
            }

            File getClassesLocation(IStackFrame frame) {
                try {
                    return JDIHelpers.this.getClassesLocation(frame);
                }
                catch (DebugException debugException) {
                    return null;
                }
            }
        };
    }

    private static String generateSourceName(String qualifiedTypeName) {
        int index = qualifiedTypeName.indexOf(36);
        if (index >= 0) {
            qualifiedTypeName = qualifiedTypeName.substring(0, index);
        }
        return qualifiedTypeName.replace('.', File.separatorChar) + ".java";
    }
}

