/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.text.correction;

import java.util.Comparator;
import org.eclipse.jdt.ls.core.internal.handlers.CodeActionHandler;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class CodeActionComparator
implements Comparator<Either<Command, CodeAction>> {
    public static int ORGANIZE_IMPORTS_PRIORITY = 0;
    public static int ADD_ALL_MISSING_IMPORTS_PRIORITY = 5;
    public static int GENERATE_ACCESSORS_PRIORITY = 10;
    public static int GENERATE_CONSTRUCTORS_PRIORITY = 20;
    public static int GENERATE_HASHCODE_EQUALS_PRIORITY = 30;
    public static int GENERATE_TOSTRING_PRIORITY = 40;
    public static int GENERATE_OVERRIDE_IMPLEMENT_PRIORITY = 50;
    public static int GENERATE_DELEGATE_METHOD_PRIORITY = 60;
    public static int SORT_MEMBERS_PRIORITY = 65;
    public static int CHANGE_MODIFIER_TO_FINAL_PRIORITY = 70;
    public static int LOWEST_PRIORITY = 100;

    /*
     * WARNING - void declaration
     */
    @Override
    public int compare(Either<Command, CodeAction> e1, Either<Command, CodeAction> e2) {
        if (e1.isRight() && e2.isRight()) {
            CodeAction action1 = (CodeAction)e1.getRight();
            CodeAction action2 = (CodeAction)e2.getRight();
            int kindDiff = this.getCodeActionKindOrdinal(action1.getKind()) - this.getCodeActionKindOrdinal(action2.getKind());
            if (kindDiff != 0) {
                return kindDiff;
            }
            Object data1 = action1.getData();
            Object data2 = action2.getData();
            Object object = data1;
            if (object instanceof CodeActionHandler.CodeActionData) {
                CodeActionHandler.CodeActionData codeActionData = (CodeActionHandler.CodeActionData)object;
                CodeActionHandler.CodeActionData cfr_ignored_0 = (CodeActionHandler.CodeActionData)object;
                Object object2 = data2;
                if (object2 instanceof CodeActionHandler.CodeActionData) {
                    void codeActionData2;
                    void codeActionData1;
                    CodeActionHandler.CodeActionData codeActionData3 = (CodeActionHandler.CodeActionData)object2;
                    CodeActionHandler.CodeActionData cfr_ignored_1 = (CodeActionHandler.CodeActionData)object2;
                    int priority1 = codeActionData1.getPriority();
                    int priority2 = codeActionData2.getPriority();
                    return priority1 - priority2;
                }
            }
            if (data1 instanceof CodeActionHandler.CodeActionData) {
                return 10;
            }
            if (data2 instanceof CodeActionHandler.CodeActionData) {
                return -10;
            }
        }
        return 0;
    }

    private int getCodeActionKindOrdinal(String kind) {
        if (kind.equals("quickfix")) {
            return 0;
        }
        if (kind.startsWith("refactor")) {
            return 1000;
        }
        if (kind.equals("quickassist")) {
            return 2000;
        }
        if (kind.startsWith("source")) {
            return 3000;
        }
        return 4000;
    }
}

