/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.semantictokens;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public enum TokenModifier {
    ABSTRACT("abstract"),
    STATIC("static"),
    FINAL("readonly"),
    DEPRECATED("deprecated"),
    DECLARATION("declaration"),
    DOCUMENTATION("documentation"),
    PUBLIC("public"),
    PRIVATE("private"),
    PROTECTED("protected"),
    NATIVE("native"),
    GENERIC("generic"),
    TYPE_ARGUMENT("typeArgument"),
    IMPORT_DECLARATION("importDeclaration"),
    CONSTRUCTOR("constructor");

    private final String genericName;
    public final int bitmask = 1 << this.ordinal();
    public final int inverseBitmask = ~this.bitmask;

    private TokenModifier(String genericName) {
        this.genericName = genericName;
    }

    public String toString() {
        return this.genericName;
    }

    public static int checkJavaModifiers(IBinding binding) {
        if (binding == null) {
            return 0;
        }
        int modifiers = 0;
        int bindingModifiers = binding.getModifiers();
        if (Modifier.isPublic((int)bindingModifiers)) {
            modifiers |= TokenModifier.PUBLIC.bitmask;
        }
        if (Modifier.isPrivate((int)bindingModifiers)) {
            modifiers |= TokenModifier.PRIVATE.bitmask;
        }
        if (Modifier.isProtected((int)bindingModifiers)) {
            modifiers |= TokenModifier.PROTECTED.bitmask;
        }
        if (Modifier.isAbstract((int)bindingModifiers)) {
            modifiers |= TokenModifier.ABSTRACT.bitmask;
        }
        if (Modifier.isStatic((int)bindingModifiers)) {
            modifiers |= TokenModifier.STATIC.bitmask;
        }
        if (Modifier.isFinal((int)bindingModifiers)) {
            modifiers |= TokenModifier.FINAL.bitmask;
        }
        if (Modifier.isNative((int)bindingModifiers)) {
            modifiers |= TokenModifier.NATIVE.bitmask;
        }
        if (binding.isDeprecated()) {
            modifiers |= TokenModifier.DEPRECATED.bitmask;
        }
        return modifiers;
    }

    /*
     * WARNING - void declaration
     */
    public static int checkConstructor(IBinding binding) {
        IBinding iBinding = binding;
        if (iBinding instanceof IMethodBinding) {
            void methodBinding;
            IMethodBinding iMethodBinding = (IMethodBinding)iBinding;
            IMethodBinding cfr_ignored_0 = (IMethodBinding)iBinding;
            if (methodBinding.isConstructor()) {
                return TokenModifier.CONSTRUCTOR.bitmask;
            }
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public static int checkGeneric(IBinding binding) {
        IBinding iBinding;
        IBinding iBinding2 = binding;
        if (iBinding2 instanceof ITypeBinding) {
            void typeBinding;
            ITypeBinding iTypeBinding = (ITypeBinding)iBinding2;
            ITypeBinding cfr_ignored_0 = (ITypeBinding)iBinding2;
            if (typeBinding.isGenericType() || typeBinding.isParameterizedType()) {
                return TokenModifier.GENERIC.bitmask;
            }
        }
        if ((iBinding = binding) instanceof IMethodBinding) {
            void methodBinding;
            IMethodBinding iMethodBinding = (IMethodBinding)iBinding;
            IMethodBinding cfr_ignored_1 = (IMethodBinding)iBinding;
            if (methodBinding.isGenericMethod() || methodBinding.isParameterizedMethod()) {
                return TokenModifier.GENERIC.bitmask;
            }
            return TokenModifier.checkGeneric((IBinding)methodBinding.getDeclaringClass());
        }
        return 0;
    }

    public static int checkDeclaration(SimpleName simpleName) {
        if (TokenModifier.isDeclaration(simpleName)) {
            return TokenModifier.DECLARATION.bitmask;
        }
        return 0;
    }

    private static boolean isDeclaration(SimpleName simpleName) {
        StructuralPropertyDescriptor d = simpleName.getLocationInParent();
        if (d == null) {
            return false;
        }
        ASTNode parent = simpleName.getParent();
        if (parent instanceof TypeDeclaration) {
            return d == TypeDeclaration.NAME_PROPERTY;
        }
        if (parent instanceof MethodDeclaration) {
            return d == MethodDeclaration.NAME_PROPERTY;
        }
        if (parent instanceof SingleVariableDeclaration) {
            return d == SingleVariableDeclaration.NAME_PROPERTY;
        }
        if (parent instanceof VariableDeclarationFragment) {
            return d == VariableDeclarationFragment.NAME_PROPERTY;
        }
        if (parent instanceof EnumDeclaration) {
            return d == EnumDeclaration.NAME_PROPERTY;
        }
        if (parent instanceof EnumConstantDeclaration) {
            return d == EnumConstantDeclaration.NAME_PROPERTY;
        }
        if (parent instanceof TypeParameter) {
            return d == TypeParameter.NAME_PROPERTY;
        }
        if (parent instanceof AnnotationTypeDeclaration) {
            return d == AnnotationTypeDeclaration.NAME_PROPERTY;
        }
        if (parent instanceof AnnotationTypeMemberDeclaration) {
            return d == AnnotationTypeMemberDeclaration.NAME_PROPERTY;
        }
        if (parent instanceof RecordDeclaration) {
            return d == RecordDeclaration.NAME_PROPERTY;
        }
        return false;
    }
}

