/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.DiagnosticsTagSupport;
import org.eclipse.lsp4j.DynamicRegistrationCapabilities;
import org.eclipse.lsp4j.InsertTextMode;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class ClientPreferences {
    private final ClientCapabilities capabilities;
    private final boolean v3supported;
    private Map<String, Object> extendedClientCapabilities;

    public ClientPreferences(ClientCapabilities caps) {
        this(caps, null);
    }

    public ClientPreferences(ClientCapabilities caps, Map<String, Object> extendedClientCapabilities) {
        if (caps == null) {
            throw new IllegalArgumentException("ClientCapabilities can not be null");
        }
        this.capabilities = caps;
        this.v3supported = this.capabilities.getTextDocument() != null;
        this.extendedClientCapabilities = extendedClientCapabilities == null ? Collections.emptyMap() : extendedClientCapabilities;
    }

    public boolean isSignatureHelpSupported() {
        return this.v3supported && this.capabilities.getTextDocument().getSignatureHelp() != null;
    }

    public boolean isWorkspaceFoldersSupported() {
        return this.capabilities.getWorkspace() != null && BooleanUtils.isTrue((Boolean)this.capabilities.getWorkspace().getWorkspaceFolders());
    }

    public boolean isCompletionDynamicRegistered() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getTextDocument().getCompletion());
    }

    public boolean isCompletionSnippetsSupported() {
        return this.v3supported && this.capabilities.getTextDocument().getCompletion() != null && this.capabilities.getTextDocument().getCompletion().getCompletionItem() != null && BooleanUtils.isTrue((Boolean)this.capabilities.getTextDocument().getCompletion().getCompletionItem().getSnippetSupport());
    }

    public boolean isV3Supported() {
        return this.v3supported;
    }

    public boolean isFormattingDynamicRegistrationSupported() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getTextDocument().getFormatting());
    }

    public boolean isRangeFormattingDynamicRegistrationSupported() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getTextDocument().getRangeFormatting());
    }

    public boolean isOnTypeFormattingDynamicRegistrationSupported() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getTextDocument().getOnTypeFormatting());
    }

    public boolean isCodeLensDynamicRegistrationSupported() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getTextDocument().getCodeLens());
    }

    public boolean isSignatureHelpDynamicRegistrationSupported() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getTextDocument().getSignatureHelp());
    }

    private boolean isDynamicRegistrationSupported(DynamicRegistrationCapabilities capability) {
        return capability != null && BooleanUtils.isTrue((Boolean)capability.getDynamicRegistration());
    }

    public boolean isRenameDynamicRegistrationSupported() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getTextDocument().getRename());
    }

    public boolean isExecuteCommandDynamicRegistrationSupported() {
        return this.v3supported && this.capabilities.getWorkspace() != null && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getWorkspace().getExecuteCommand());
    }

    public boolean isWorkspaceSymbolDynamicRegistered() {
        return this.v3supported && this.capabilities.getWorkspace() != null && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getWorkspace().getSymbol());
    }

    public boolean isWorkspaceChangeWatchedFilesDynamicRegistered() {
        return this.v3supported && this.capabilities.getWorkspace() != null && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getWorkspace().getDidChangeWatchedFiles());
    }

    public boolean isWorkspaceConfigurationSupported() {
        return this.v3supported && this.capabilities.getWorkspace() != null && BooleanUtils.isTrue((Boolean)this.capabilities.getWorkspace().getConfiguration());
    }

    public boolean isDocumentSymbolDynamicRegistered() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getTextDocument().getDocumentSymbol());
    }

    public boolean isCodeActionDynamicRegistered() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getTextDocument().getCodeAction());
    }

    public boolean isDefinitionDynamicRegistered() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getTextDocument().getDefinition());
    }

    public boolean isDeclarationDynamicRegistered() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getTextDocument().getDeclaration());
    }

    public boolean isTypeDefinitionDynamicRegistered() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getTextDocument().getTypeDefinition());
    }

    public boolean isHoverDynamicRegistered() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getTextDocument().getHover());
    }

    public boolean isReferencesDynamicRegistered() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getTextDocument().getReferences());
    }

    public boolean isDocumentHighlightDynamicRegistered() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getTextDocument().getDocumentHighlight());
    }

    public boolean isFoldgingRangeDynamicRegistered() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getTextDocument().getFoldingRange());
    }

    public boolean isImplementationDynamicRegistered() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getTextDocument().getImplementation());
    }

    public boolean isSelectionRangeDynamicRegistered() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getTextDocument().getSelectionRange());
    }

    public boolean isInlayHintDynamicRegistered() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getTextDocument().getInlayHint());
    }

    public boolean isWillSaveRegistered() {
        return this.v3supported && this.capabilities.getTextDocument().getSynchronization() != null && BooleanUtils.isTrue((Boolean)this.capabilities.getTextDocument().getSynchronization().getWillSave());
    }

    public boolean isWillSaveWaitUntilRegistered() {
        return this.v3supported && this.capabilities.getTextDocument().getSynchronization() != null && BooleanUtils.isTrue((Boolean)this.capabilities.getTextDocument().getSynchronization().getWillSaveWaitUntil());
    }

    public boolean isWorkDoneProgressSupported() {
        return this.v3supported && this.capabilities.getWindow() != null && this.capabilities.getWindow().getWorkDoneProgress() != null && this.capabilities.getWindow().getWorkDoneProgress() != false;
    }

    public boolean isWorkspaceApplyEditSupported() {
        return this.capabilities.getWorkspace() != null && BooleanUtils.isTrue((Boolean)this.capabilities.getWorkspace().getApplyEdit());
    }

    public boolean isProgressReportSupported() {
        return Boolean.parseBoolean(this.extendedClientCapabilities.getOrDefault("progressReportProvider", "false").toString());
    }

    public boolean isClassFileContentSupported() {
        return Boolean.parseBoolean(this.extendedClientCapabilities.getOrDefault("classFileContentsSupport", "false").toString());
    }

    public boolean isOverrideMethodsPromptSupported() {
        return Boolean.parseBoolean(this.extendedClientCapabilities.getOrDefault("overrideMethodsPromptSupport", "false").toString());
    }

    public boolean isHashCodeEqualsPromptSupported() {
        return Boolean.parseBoolean(this.extendedClientCapabilities.getOrDefault("hashCodeEqualsPromptSupport", "false").toString());
    }

    public boolean isAdvancedOrganizeImportsSupported() {
        return Boolean.parseBoolean(this.extendedClientCapabilities.getOrDefault("advancedOrganizeImportsSupport", "false").toString());
    }

    public boolean isGenerateToStringPromptSupported() {
        return Boolean.parseBoolean(this.extendedClientCapabilities.getOrDefault("generateToStringPromptSupport", "false").toString());
    }

    public boolean isAdvancedGenerateAccessorsSupported() {
        return Boolean.parseBoolean(this.extendedClientCapabilities.getOrDefault("advancedGenerateAccessorsSupport", "false").toString());
    }

    public boolean isGenerateConstructorsPromptSupported() {
        return Boolean.parseBoolean(this.extendedClientCapabilities.getOrDefault("generateConstructorsPromptSupport", "false").toString());
    }

    public boolean isGenerateDelegateMethodsPromptSupported() {
        return Boolean.parseBoolean(this.extendedClientCapabilities.getOrDefault("generateDelegateMethodsPromptSupport", "false").toString());
    }

    public boolean isAdvancedExtractRefactoringSupported() {
        return Boolean.parseBoolean(this.extendedClientCapabilities.getOrDefault("advancedExtractRefactoringSupport", "false").toString());
    }

    public boolean isExtractInterfaceSupport() {
        return Boolean.parseBoolean(this.extendedClientCapabilities.getOrDefault("extractInterfaceSupport", "false").toString());
    }

    public boolean isAdvancedUpgradeGradleSupport() {
        return Boolean.parseBoolean(this.extendedClientCapabilities.getOrDefault("advancedUpgradeGradleSupport", "false").toString());
    }

    /*
     * WARNING - void declaration
     */
    public boolean isExtractMethodInferSelectionSupported() {
        ArrayList supportList = this.extendedClientCapabilities.getOrDefault("inferSelectionSupport", new ArrayList());
        ArrayList arrayList = supportList;
        if (arrayList instanceof List) {
            void list;
            List list2 = arrayList;
            if (list.contains("extractMethod")) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isExtractVariableInferSelectionSupported() {
        ArrayList supportList = this.extendedClientCapabilities.getOrDefault("inferSelectionSupport", new ArrayList());
        ArrayList arrayList = supportList;
        if (arrayList instanceof List) {
            void list;
            List list2 = arrayList;
            if (list.contains("extractVariable")) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isExtractFieldInferSelectionSupported() {
        ArrayList supportList = this.extendedClientCapabilities.getOrDefault("inferSelectionSupport", new ArrayList());
        ArrayList arrayList = supportList;
        if (arrayList instanceof List) {
            void list;
            List list2 = arrayList;
            if (list.contains("extractField")) {
                return true;
            }
        }
        return false;
    }

    public boolean isAdvancedIntroduceParameterRefactoringSupported() {
        return Boolean.parseBoolean(this.extendedClientCapabilities.getOrDefault("advancedIntroduceParameterRefactoringSupport", "false").toString());
    }

    public boolean isMoveRefactoringSupported() {
        return Boolean.parseBoolean(this.extendedClientCapabilities.getOrDefault("moveRefactoringSupport", "false").toString());
    }

    public boolean isClientHoverProviderRegistered() {
        return Boolean.parseBoolean(this.extendedClientCapabilities.getOrDefault("clientHoverProvider", "false").toString());
    }

    public boolean isClientDocumentSymbolProviderRegistered() {
        return Boolean.parseBoolean(this.extendedClientCapabilities.getOrDefault("clientDocumentSymbolProvider", "false").toString());
    }

    public boolean isActionableNotificationSupported() {
        return Boolean.parseBoolean(this.extendedClientCapabilities.getOrDefault("actionableNotificationSupported", "false").toString());
    }

    public boolean isActionableRuntimeNotificationSupport() {
        return Boolean.parseBoolean(this.extendedClientCapabilities.getOrDefault("actionableRuntimeNotificationSupport", "false").toString());
    }

    public boolean shouldLanguageServerExitOnShutdown() {
        return Boolean.parseBoolean(this.extendedClientCapabilities.getOrDefault("shouldLanguageServerExitOnShutdown", "false").toString());
    }

    public boolean isGradleChecksumWrapperPromptSupport() {
        return Boolean.parseBoolean(this.extendedClientCapabilities.getOrDefault("gradleChecksumWrapperPromptSupport", "false").toString());
    }

    public boolean isExecuteClientCommandSupport() {
        return Boolean.parseBoolean(this.extendedClientCapabilities.getOrDefault("executeClientCommandSupport", "false").toString());
    }

    public String getCompletionItemCommand() {
        return String.valueOf(this.extendedClientCapabilities.getOrDefault("onCompletionItemSelectedCommand", ""));
    }

    public boolean canUseInternalSettings() {
        return Boolean.parseBoolean(this.extendedClientCapabilities.getOrDefault("canUseInternalSettings", "false").toString());
    }

    public boolean isSupportsCompletionDocumentationMarkdown() {
        return this.v3supported && this.capabilities.getTextDocument().getCompletion() != null && this.capabilities.getTextDocument().getCompletion().getCompletionItem() != null && this.capabilities.getTextDocument().getCompletion().getCompletionItem().getDocumentationFormat() != null && this.capabilities.getTextDocument().getCompletion().getCompletionItem().getDocumentationFormat().contains("markdown");
    }

    public boolean isResourceOperationSupported() {
        return this.capabilities.getWorkspace() != null && this.capabilities.getWorkspace().getWorkspaceEdit() != null && this.capabilities.getWorkspace().getWorkspaceEdit().getResourceOperations() != null && this.capabilities.getWorkspace().getWorkspaceEdit().getResourceOperations().contains("create") && this.capabilities.getWorkspace().getWorkspaceEdit().getResourceOperations().contains("rename") && this.capabilities.getWorkspace().getWorkspaceEdit().getResourceOperations().contains("delete");
    }

    public boolean isHierarchicalDocumentSymbolSupported() {
        return this.v3supported && this.capabilities.getTextDocument().getDocumentSymbol() != null && this.capabilities.getTextDocument().getDocumentSymbol().getHierarchicalDocumentSymbolSupport() != null && this.capabilities.getTextDocument().getDocumentSymbol().getHierarchicalDocumentSymbolSupport() != false;
    }

    public boolean isSupportedCodeActionKind(String kind) {
        return this.v3supported && this.capabilities.getTextDocument().getCodeAction() != null && this.capabilities.getTextDocument().getCodeAction().getCodeActionLiteralSupport() != null && this.capabilities.getTextDocument().getCodeAction().getCodeActionLiteralSupport().getCodeActionKind() != null && this.capabilities.getTextDocument().getCodeAction().getCodeActionLiteralSupport().getCodeActionKind().getValueSet() != null && this.capabilities.getTextDocument().getCodeAction().getCodeActionLiteralSupport().getCodeActionKind().getValueSet().stream().filter(k -> kind.startsWith((String)k)).findAny().isPresent();
    }

    public boolean isDiagnosticTagSupported() {
        return this.v3supported && this.capabilities.getTextDocument().getPublishDiagnostics() != null && this.capabilities.getTextDocument().getPublishDiagnostics().getTagSupport() != null && this.isTagSupported((Either<Boolean, DiagnosticsTagSupport>)this.capabilities.getTextDocument().getPublishDiagnostics().getTagSupport());
    }

    private boolean isTagSupported(Either<Boolean, DiagnosticsTagSupport> tagSupport) {
        return tagSupport.isLeft() ? (Boolean)tagSupport.getLeft() : ((DiagnosticsTagSupport)tagSupport.getRight()).getValueSet() != null;
    }

    public boolean isCallHierarchyDynamicRegistered() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getTextDocument().getCallHierarchy());
    }

    public boolean isTypeHierarchyDynamicRegistrationSupported() {
        return this.v3supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.capabilities.getTextDocument().getTypeHierarchy());
    }

    public boolean isResolveCodeActionSupported() {
        return this.v3supported && this.capabilities.getTextDocument().getCodeAction() != null && this.capabilities.getTextDocument().getCodeAction().getDataSupport() != null && this.capabilities.getTextDocument().getCodeAction().getDataSupport() != false && this.capabilities.getTextDocument().getCodeAction().getResolveSupport() != null && this.capabilities.getTextDocument().getCodeAction().getResolveSupport().getProperties() != null && this.capabilities.getTextDocument().getCodeAction().getResolveSupport().getProperties().contains("edit");
    }

    public boolean isCompletionItemTagSupported() {
        return this.v3supported && this.capabilities.getTextDocument().getCompletion() != null && this.capabilities.getTextDocument().getCompletion().getCompletionItem() != null && this.capabilities.getTextDocument().getCompletion().getCompletionItem().getTagSupport() != null;
    }

    public boolean isSymbolTagSupported() {
        return this.v3supported && this.capabilities.getTextDocument().getDocumentSymbol() != null && this.capabilities.getTextDocument().getDocumentSymbol().getTagSupport() != null;
    }

    public boolean isCompletionInsertReplaceSupport() {
        return this.v3supported && this.capabilities.getTextDocument().getCompletion() != null && this.capabilities.getTextDocument().getCompletion().getCompletionItem() != null && this.capabilities.getTextDocument().getCompletion().getCompletionItem().getInsertReplaceSupport() != null && this.capabilities.getTextDocument().getCompletion().getCompletionItem().getInsertReplaceSupport() != false;
    }

    public boolean isCompletionListItemDefaultsPropertySupport(String property) {
        return this.v3supported && this.capabilities.getTextDocument().getCompletion() != null && this.capabilities.getTextDocument().getCompletion().getCompletionList() != null && this.capabilities.getTextDocument().getCompletion().getCompletionList().getItemDefaults() != null && this.capabilities.getTextDocument().getCompletion().getCompletionList().getItemDefaults().contains(property);
    }

    public boolean isCompletionItemInsertTextModeSupport(InsertTextMode insertMode) {
        return this.v3supported && this.capabilities.getTextDocument().getCompletion() != null && this.capabilities.getTextDocument().getCompletion().getCompletionItem() != null && this.capabilities.getTextDocument().getCompletion().getCompletionItem().getInsertTextModeSupport() != null && this.capabilities.getTextDocument().getCompletion().getCompletionItem().getInsertTextModeSupport().getValueSet().contains(insertMode);
    }

    public InsertTextMode getCompletionItemInsertTextModeDefault() {
        return this.capabilities.getTextDocument().getCompletion().getInsertTextMode();
    }

    public boolean isCompletionListItemDefaultsSupport() {
        return this.isCompletionListItemDefaultsPropertySupport("editRange") || this.isCompletionListItemDefaultsPropertySupport("insertTextFormat") || this.isCompletionListItemDefaultsPropertySupport("insertTextMode");
    }

    public boolean isCompletionItemLabelDetailsSupport() {
        return this.v3supported && this.capabilities.getTextDocument().getCompletion() != null && this.capabilities.getTextDocument().getCompletion().getCompletionItem() != null && this.capabilities.getTextDocument().getCompletion().getCompletionItem().getLabelDetailsSupport() != null && this.capabilities.getTextDocument().getCompletion().getCompletionItem().getLabelDetailsSupport() != false;
    }

    public boolean isResolveAdditionalTextEditsSupport() {
        return this.isPropertySupportedForCompletionResolve("additionalTextEdits") || Boolean.parseBoolean(this.extendedClientCapabilities.getOrDefault("resolveAdditionalTextEditsSupport", "false").toString());
    }

    public boolean isCompletionResolveDocumentSupport() {
        return this.isPropertySupportedForCompletionResolve("documentation");
    }

    public boolean isCompletionResolveDetailSupport() {
        return this.isPropertySupportedForCompletionResolve("detail");
    }

    public boolean isPropertySupportedForCompletionResolve(String property) {
        return this.v3supported && this.capabilities.getTextDocument().getCompletion() != null && this.capabilities.getTextDocument().getCompletion().getCompletionItem() != null && this.capabilities.getTextDocument().getCompletion().getCompletionItem().getResolveSupport() != null && this.capabilities.getTextDocument().getCompletion().getCompletionItem().getResolveSupport().getProperties() != null && this.capabilities.getTextDocument().getCompletion().getCompletionItem().getResolveSupport().getProperties().contains(property);
    }

    public boolean isInlayHintRefreshSupported() {
        return this.v3supported && this.capabilities.getWorkspace().getInlayHint() != null && this.capabilities.getWorkspace().getInlayHint().getRefreshSupport() != null && this.capabilities.getWorkspace().getInlayHint().getRefreshSupport() != false;
    }

    /*
     * WARNING - void declaration
     */
    public Collection<String> excludedMarkerTypes() {
        List<String> list;
        Object list2 = this.extendedClientCapabilities.getOrDefault("excludedMarkerTypes", null);
        Object var4_2 = list2;
        if (var4_2 instanceof Collection) {
            void excludedMarkerTypes;
            Collection collection = var4_2;
            list = excludedMarkerTypes.stream().filter(String.class::isInstance).map(String.class::cast).toList();
        } else {
            list = List.of();
        }
        return list;
    }

    public boolean isChangeAnnotationSupport() {
        return this.v3supported && this.capabilities.getWorkspace() != null && this.capabilities.getWorkspace().getWorkspaceEdit() != null && this.capabilities.getWorkspace().getWorkspaceEdit().getChangeAnnotationSupport() != null;
    }

    public boolean skipProjectConfiguration() {
        return Boolean.parseBoolean(this.extendedClientCapabilities.getOrDefault("skipProjectConfiguration", "false").toString());
    }

    public boolean skipTextEventPropagation() {
        return Boolean.parseBoolean(this.extendedClientCapabilities.getOrDefault("skipTextEventPropagation", "false").toString());
    }
}

