/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.contentassist;

import com.google.common.io.CharStreams;
import com.google.common.util.concurrent.SimpleTimeLimiter;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.codeassist.InternalCompletionProposal;
import org.eclipse.jdt.internal.codeassist.impl.Engine;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.contentassist.CompletionProposalDescriptionProvider;
import org.eclipse.jdt.ls.core.internal.handlers.SignatureHelpUtils;
import org.eclipse.jdt.ls.core.internal.javadoc.JavadocContentAccess;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.lsp4j.ParameterInformation;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureInformation;

public final class SignatureHelpRequestor
extends CompletionRequestor {
    private Map<String, CompletionProposal> proposals = new LinkedHashMap<String, CompletionProposal>();
    private List<CompletionProposal> typeProposals = new ArrayList<CompletionProposal>();
    private final ICompilationUnit unit;
    private Map<SignatureInformation, CompletionProposal> infoProposals;
    private boolean acceptType = false;
    private String methodName;
    private boolean isDescriptionEnabled;
    private List<String> declaringTypeNames;

    public SignatureHelpRequestor(ICompilationUnit aUnit, String methodName, List<String> declaringTypeName) {
        this(aUnit, methodName, declaringTypeName, false);
    }

    public SignatureHelpRequestor(ICompilationUnit aUnit, String methodName, List<String> declaringTypeName, boolean acceptType) {
        this.unit = aUnit;
        this.setRequireExtendedContext(true);
        this.infoProposals = new HashMap<SignatureInformation, CompletionProposal>();
        this.acceptType = acceptType;
        this.methodName = methodName;
        this.isDescriptionEnabled = this.isDescriptionEnabled();
        this.declaringTypeNames = declaringTypeName;
    }

    public SignatureHelp getSignatureHelp(IProgressMonitor monitor) {
        SignatureHelp signatureHelp = new SignatureHelp();
        ArrayList<SignatureInformation> infos = new ArrayList<SignatureInformation>();
        for (CompletionProposal proposal : this.proposals.values()) {
            if (!monitor.isCanceled()) {
                if (proposal.getKind() != 6) {
                    this.typeProposals.add(proposal);
                    continue;
                }
                SignatureInformation signatureInformation = this.toSignatureInformation(proposal);
                this.infoProposals.put(signatureInformation, proposal);
                infos.add(signatureInformation);
                continue;
            }
            return signatureHelp;
        }
        infos.sort((a, b) -> a.getParameters().size() - b.getParameters().size());
        signatureHelp.getSignatures().addAll(infos);
        return signatureHelp;
    }

    public boolean isIgnored(int completionProposalKind) {
        if (this.acceptType) {
            return completionProposalKind != 6 && completionProposalKind != 9;
        }
        return completionProposalKind != 6;
    }

    public void accept(CompletionProposal proposal) {
        if (!this.isIgnored(proposal.getKind())) {
            char[] declarationSignature;
            if (proposal.getKind() == 6 && !Objects.equals(proposal.getName() == null ? null : new String(proposal.getName()), this.methodName)) {
                return;
            }
            if (this.declaringTypeNames != null && (declarationSignature = proposal.getDeclarationSignature()) != null) {
                String proposalTypeSimpleName = SignatureHelpUtils.getSimpleTypeName(String.valueOf(declarationSignature));
                for (String typeName : this.declaringTypeNames) {
                    String declaringTypeSimpleName = Signature.getSimpleName((String)typeName);
                    if (!Objects.equals(proposalTypeSimpleName, declaringTypeSimpleName)) continue;
                    this.proposals.putIfAbsent(String.valueOf(proposal.getSignature()), proposal);
                    return;
                }
                return;
            }
            this.proposals.putIfAbsent(String.valueOf(proposal.getSignature()), proposal);
        }
    }

    public SignatureInformation toSignatureInformation(CompletionProposal methodProposal) {
        SignatureInformation $ = new SignatureInformation();
        StringBuilder description = CompletionProposalDescriptionProvider.createMethodProposalDescription(methodProposal);
        $.setLabel(description.toString());
        if (this.isDescriptionEnabled) {
            $.setDocumentation(this.computeJavaDoc(methodProposal));
        }
        char[] signature = SignatureUtil.fix83600((char[])methodProposal.getSignature());
        char[][] parameterNames = methodProposal.findParameterNames(null);
        char[][] parameterTypes = Signature.getParameterTypes((char[])signature);
        int i = 0;
        while (i < parameterTypes.length) {
            parameterTypes[i] = Signature.getSimpleName((char[])Signature.toCharArray((char[])SignatureUtil.getLowerBound((char[])parameterTypes[i])));
            ++i;
        }
        if (Flags.isVarargs((int)methodProposal.getFlags())) {
            int index = parameterTypes.length - 1;
            parameterTypes[index] = this.convertToVararg(parameterTypes[index]);
        }
        LinkedList<ParameterInformation> parameterInfos = new LinkedList<ParameterInformation>();
        int i2 = 0;
        while (i2 < parameterTypes.length) {
            StringBuilder builder = new StringBuilder();
            builder.append(parameterTypes[i2]);
            builder.append(' ');
            builder.append(parameterNames[i2]);
            parameterInfos.add(new ParameterInformation(builder.toString()));
            ++i2;
        }
        $.setParameters(parameterInfos);
        return $;
    }

    private char[] convertToVararg(char[] typeName) {
        if (typeName == null) {
            return typeName;
        }
        int len = typeName.length;
        if (len < 2) {
            return typeName;
        }
        if (typeName[len - 1] != ']') {
            return typeName;
        }
        if (typeName[len - 2] != '[') {
            return typeName;
        }
        char[] vararg = new char[len + 1];
        System.arraycopy(typeName, 0, vararg, 0, len - 2);
        vararg[len - 2] = 46;
        vararg[len - 1] = 46;
        vararg[len] = 46;
        return vararg;
    }

    /*
     * WARNING - void declaration
     */
    public String computeJavaDoc(CompletionProposal proposal) {
        block8: {
            try {
                void methodBinding;
                void internalCompletionProposal;
                Binding binding;
                CompletionProposal completionProposal;
                String fullyQualifiedName = SignatureUtil.stripSignatureToFQN((String)String.valueOf(proposal.getDeclarationSignature()));
                IType type = this.unit.getJavaProject().findType(fullyQualifiedName);
                if (type == null) {
                    type = this.unit.getJavaProject().findType(fullyQualifiedName, (IProgressMonitor)new NullProgressMonitor());
                }
                if (type == null || !((completionProposal = proposal) instanceof InternalCompletionProposal)) break block8;
                InternalCompletionProposal internalCompletionProposal2 = (InternalCompletionProposal)completionProposal;
                InternalCompletionProposal cfr_ignored_0 = (InternalCompletionProposal)completionProposal;
                Binding binding2 = binding = internalCompletionProposal.getBinding();
                if (!(binding2 instanceof MethodBinding)) break block8;
                MethodBinding methodBinding2 = (MethodBinding)binding2;
                MethodBinding cfr_ignored_1 = (MethodBinding)binding2;
                MethodBinding original = methodBinding.original();
                char[] signature = original != binding ? Engine.getSignature((MethodBinding)original) : Engine.getSignature((MethodBinding)methodBinding);
                String[] parameters = Signature.getParameterTypes((String)String.valueOf(SignatureUtil.fix83600((char[])signature)));
                int i = 0;
                while (i < parameters.length) {
                    parameters[i] = SignatureUtil.getLowerBound((String)parameters[i]);
                    ++i;
                }
                IMethod method = JavaModelUtil.findMethod((String)String.valueOf(proposal.getName()), (String[])parameters, (boolean)proposal.isConstructor(), (IType)type);
                if (method == null || !method.exists()) break block8;
                ICompilationUnit unit = type.getCompilationUnit();
                if (unit != null) {
                    unit.reconcile(0, false, null, null);
                }
                String javadoc = null;
                try {
                    javadoc = (String)SimpleTimeLimiter.create((ExecutorService)JavaLanguageServerPlugin.getExecutorService()).callWithTimeout(() -> {
                        Reader reader = JavadocContentAccess.getPlainTextContentReader((IMember)method);
                        return reader == null ? null : CharStreams.toString((Readable)reader);
                    }, 500L, TimeUnit.MILLISECONDS);
                }
                catch (UncheckedTimeoutException uncheckedTimeoutException) {
                }
                catch (Exception e) {
                    JavaLanguageServerPlugin.logException("Unable to read documentation", e);
                }
                return javadoc;
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.logException("Unable to resolve signaturehelp javadoc", e);
            }
        }
        return null;
    }

    public Map<SignatureInformation, CompletionProposal> getInfoProposals() {
        return this.infoProposals;
    }

    public List<CompletionProposal> getTypeProposals() {
        return this.typeProposals;
    }

    private boolean isDescriptionEnabled() {
        PreferenceManager preferencesManager = JavaLanguageServerPlugin.getPreferencesManager();
        if (preferencesManager == null) {
            return false;
        }
        Preferences preferences = preferencesManager.getPreferences();
        if (preferences == null) {
            return false;
        }
        return preferences.isSignatureHelpDescriptionEnabled();
    }
}

