/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.javadoc;

import java.util.Collection;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;

public class TableHelper {
    public static void normalizeTableHeaders(Element table) {
        TableHelper.addMissingTableHeaders(table);
        Element thead = table.select("thead").first();
        if (thead != null) {
            Elements theadRows = thead.select("tr");
            if (theadRows.size() > 1) {
                Element tbody = table.select("tbody").first();
                if (tbody == null) {
                    tbody = new Element("tbody");
                    table.appendChild((Node)tbody);
                }
                int i = theadRows.size() - 1;
                while (i >= 1) {
                    Element row = (Element)theadRows.get(i);
                    row.remove();
                    tbody.prependChild((Node)row);
                    --i;
                }
            }
            table.select("tbody th").forEach(TableHelper::convertThToTd);
        }
        table.select("tr").forEach(TableHelper::normalizeMixedTableRow);
    }

    private static void addMissingTableHeaders(Element table) {
        Element tbody;
        Elements tbodyRows;
        int numCols = 0;
        Elements theadElements = table.select("thead");
        if (!theadElements.isEmpty()) {
            return;
        }
        Element thead = new Element("thead");
        table.insertChildren(0, new Node[]{thead});
        Elements tbodyElements = table.select("tbody");
        if (!tbodyElements.isEmpty() && !(tbodyRows = (tbody = tbodyElements.first()).select("tr")).isEmpty()) {
            Element potentialHeader = tbodyRows.first();
            int cols1stRow = potentialHeader.childrenSize();
            int thSize = potentialHeader.getElementsByTag("th").size();
            if (thSize == cols1stRow) {
                thead.appendChild((Node)potentialHeader);
                return;
            }
            for (Element row : tbodyRows) {
                int colSize = row.getElementsByTag("td").size() + row.getElementsByTag("th").size();
                if (colSize <= numCols) continue;
                numCols = colSize;
            }
        }
        if (numCols > 0 && thead.childrenSize() == 0) {
            Element newHeader = new Element("tr");
            int i = 0;
            while (i < numCols) {
                newHeader.appendChild((Node)new Element("th"));
                ++i;
            }
            thead.appendChild((Node)newHeader);
        }
    }

    private static void normalizeMixedTableRow(Element row) {
        Elements thElements = row.getElementsByTag("th");
        Elements tdElements = row.getElementsByTag("td");
        if (!thElements.isEmpty() && !tdElements.isEmpty()) {
            thElements.forEach(TableHelper::convertThToTd);
        }
    }

    private static void convertThToTd(Element th) {
        Element td = new Element("td");
        td.attributes().addAll(th.attributes());
        Element strong = new Element("strong");
        strong.appendChildren((Collection)th.childNodes());
        td.appendChild((Node)strong);
        th.replaceWith((Node)td);
    }
}

