/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac;

import com.sun.source.util.Plugin;
import com.sun.tools.javac.file.PathFileObject;
import com.sun.tools.javac.main.Arguments;
import com.sun.tools.javac.main.DelegatingJavaFileManager;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.platform.PlatformDescription;
import com.sun.tools.javac.platform.PlatformUtils;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.processing.Processor;
import javax.tools.FileObject;
import javax.tools.ForwardingFileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.eclipse.core.runtime.ILog;
import org.eclipse.jdt.internal.javac.ZipFileSystemProviderWithCache;

public class CachingJDKPlatformArguments
extends Arguments {
    private static Map<String, JavaFileManager> platformFMCache = new ConcurrentHashMap<String, JavaFileManager>();
    private final Options options;
    private final Context context;

    public static void preRegister(Context context) {
        context.put(Arguments.argsKey, c -> new CachingJDKPlatformArguments(c));
    }

    private CachingJDKPlatformArguments(Context context) {
        super(context);
        this.options = Options.instance(context);
        this.context = context;
    }

    @Override
    public boolean handleReleaseOptions(Predicate<Iterable<String>> additionalOptions) {
        String platformString = this.options.get(Option.RELEASE);
        this.checkOptionAllowed(platformString == null, option -> Log.instance(this.context).error(CompilerProperties.Errors.ReleaseBootclasspathConflict(option)), Option.BOOT_CLASS_PATH, Option.XBOOTCLASSPATH, Option.XBOOTCLASSPATH_APPEND, Option.XBOOTCLASSPATH_PREPEND, Option.ENDORSEDDIRS, Option.DJAVA_ENDORSED_DIRS, Option.EXTDIRS, Option.DJAVA_EXT_DIRS, Option.SOURCE, Option.TARGET, Option.SYSTEM, Option.UPGRADE_MODULE_PATH);
        if (platformString != null) {
            PlatformDescription platformDescription = CachingJDKPlatformArguments.toReusable(PlatformUtils.lookupPlatformDescription(platformString));
            if (platformDescription == null) {
                Log.instance(this.context).error(CompilerProperties.Errors.UnsupportedReleaseVersion(platformString));
                return false;
            }
            this.options.put(Option.SOURCE, platformDescription.getSourceVersion());
            this.options.put(Option.TARGET, platformDescription.getTargetVersion());
            this.context.put(PlatformDescription.class, platformDescription);
            if (!additionalOptions.test(platformDescription.getAdditionalOptions())) {
                return false;
            }
            JavaFileManager platformFM = platformDescription.getFileManager();
            DelegatingJavaFileManager.installReleaseFileManager(this.context, platformFM, this.context.get(JavaFileManager.class));
        }
        return true;
    }

    private static PlatformDescription toReusable(final PlatformDescription delegate) {
        if (delegate == null) {
            return null;
        }
        return new PlatformDescription(){

            @Override
            public JavaFileManager getFileManager() {
                return platformFMCache.computeIfAbsent(this.getSourceVersion(), string -> new ForwardingJavaFileManager<JavaFileManager>(this, delegate.getFileManager()){
                    {
                        Objects.requireNonNull(this$0);
                        super(arg0);
                    }

                    @Override
                    public void close() {
                    }

                    @Override
                    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
                        FileObject res = super.getFileForInput(location, packageName, relativeName);
                        this.makeUnderlyingFileObjectUninterruptible(res);
                        return res;
                    }

                    @Override
                    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
                        JavaFileObject res = super.getJavaFileForInput(location, className, kind);
                        this.makeUnderlyingFileObjectUninterruptible(res);
                        return res;
                    }

                    @Override
                    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
                        Iterable<JavaFileObject> res = super.list(location, packageName, kinds, recurse);
                        res.forEach(this::makeUnderlyingFileObjectUninterruptible);
                        return res;
                    }

                    private void makeUnderlyingFileObjectUninterruptible(FileObject fo) {
                        PathFileObject toUninterrupted = null;
                        if (fo instanceof PathFileObject) {
                            PathFileObject o;
                            toUninterrupted = o = (PathFileObject)fo;
                        }
                        if (fo instanceof ForwardingFileObject) {
                            ForwardingFileObject forwarding = (ForwardingFileObject)fo;
                            try {
                                Field fileObjectField = ForwardingFileObject.class.getDeclaredField("fileObject");
                                fileObjectField.setAccessible(true);
                                Object o = fileObjectField.get(forwarding);
                                if (o instanceof PathFileObject) {
                                    PathFileObject pathFileObject;
                                    toUninterrupted = pathFileObject = (PathFileObject)o;
                                }
                            }
                            catch (Exception e) {
                                ILog.get().error(e.getMessage(), (Throwable)e);
                            }
                        }
                        if (toUninterrupted != null) {
                            ZipFileSystemProviderWithCache.makeFileSystemUninterruptible(toUninterrupted.getPath().getFileSystem());
                        }
                    }
                });
            }

            @Override
            public String getSourceVersion() {
                return delegate.getSourceVersion();
            }

            @Override
            public String getTargetVersion() {
                return delegate.getTargetVersion();
            }

            @Override
            public List<PlatformDescription.PluginInfo<Processor>> getAnnotationProcessors() {
                return delegate.getAnnotationProcessors();
            }

            @Override
            public List<PlatformDescription.PluginInfo<Plugin>> getPlugins() {
                return delegate.getPlugins();
            }

            @Override
            public List<String> getAdditionalOptions() {
                return delegate.getAdditionalOptions();
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    void checkOptionAllowed(boolean allowed, Consumer<Option> r, Option ... opts) {
        if (!allowed) {
            Stream.of(opts).filter(this.options::isSet).forEach(r::accept);
        }
    }
}

