/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac;

import java.lang.reflect.Field;
import org.eclipse.core.runtime.ILog;
import org.eclipse.jdt.core.compiler.CompilationProgress;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.core.builder.AbstractImageBuilder;
import org.eclipse.jdt.internal.core.builder.BuildNotifier;

public class BuildNotifierCompilationProgress
extends CompilationProgress {
    private BuildNotifier buildNotifier;

    public BuildNotifierCompilationProgress(ICompilerRequestor requestor) {
        this.buildNotifier = this.findBuildNotifier(requestor);
    }

    private BuildNotifier findBuildNotifier(ICompilerRequestor requestor) {
        if (requestor instanceof AbstractImageBuilder) {
            try {
                BuildNotifier notifier;
                Field notifierField = AbstractImageBuilder.class.getDeclaredField("notifier");
                notifierField.setAccessible(true);
                Object object = notifierField.get(requestor);
                return object instanceof BuildNotifier ? (notifier = (BuildNotifier)object) : null;
            }
            catch (Exception ex) {
                ILog.get().warn(ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    public void begin(int remainingWork) {
        if (this.buildNotifier != null) {
            this.buildNotifier.checkCancelWithinCompiler();
        }
    }

    public void done() {
    }

    public boolean isCanceled() {
        if (this.buildNotifier != null) {
            this.buildNotifier.checkCancel();
        }
        return false;
    }

    public void setTaskName(String name) {
        if (this.buildNotifier != null) {
            this.buildNotifier.subTask(name);
        }
    }

    public void worked(int workIncrement, int remainingWork) {
    }
}

