/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import java.util.function.Consumer;

class StreamInterceptor
extends PrintStream {
    private final PrintStream originalStream;
    private final Consumer<PrintStream> unregisterAction;
    private final int maxNumberOfBytesPerThread;
    private final ThreadLocal<RewindableByteArrayOutputStream> output = ThreadLocal.withInitial(RewindableByteArrayOutputStream::new);

    static Optional<StreamInterceptor> registerStdout(int maxNumberOfBytesPerThread) {
        return StreamInterceptor.register(System.out, System::setOut, maxNumberOfBytesPerThread);
    }

    static Optional<StreamInterceptor> registerStderr(int maxNumberOfBytesPerThread) {
        return StreamInterceptor.register(System.err, System::setErr, maxNumberOfBytesPerThread);
    }

    static Optional<StreamInterceptor> register(PrintStream originalStream, Consumer<PrintStream> streamSetter, int maxNumberOfBytesPerThread) {
        if (originalStream instanceof StreamInterceptor) {
            return Optional.empty();
        }
        StreamInterceptor interceptor = new StreamInterceptor(originalStream, streamSetter, maxNumberOfBytesPerThread);
        streamSetter.accept(interceptor);
        return Optional.of(interceptor);
    }

    private StreamInterceptor(PrintStream originalStream, Consumer<PrintStream> unregisterAction, int maxNumberOfBytesPerThread) {
        super(originalStream);
        this.originalStream = originalStream;
        this.unregisterAction = unregisterAction;
        this.maxNumberOfBytesPerThread = maxNumberOfBytesPerThread;
    }

    void capture() {
        this.output.get().mark();
    }

    String consume() {
        return this.output.get().rewind();
    }

    void unregister() {
        this.unregisterAction.accept(this.originalStream);
    }

    @Override
    public void write(int b) {
        RewindableByteArrayOutputStream out = this.output.get();
        if (out.isMarked() && out.size() < this.maxNumberOfBytesPerThread) {
            out.write(b);
        }
        super.write(b);
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        int actualLength;
        RewindableByteArrayOutputStream out = this.output.get();
        if (out.isMarked() && (actualLength = Math.max(0, Math.min(len, this.maxNumberOfBytesPerThread - out.size()))) > 0) {
            out.write(buf, off, actualLength);
        }
        super.write(buf, off, len);
    }

    static class RewindableByteArrayOutputStream
    extends ByteArrayOutputStream {
        private final Deque<Integer> markedPositions = new ArrayDeque<Integer>();

        RewindableByteArrayOutputStream() {
        }

        boolean isMarked() {
            return !this.markedPositions.isEmpty();
        }

        void mark() {
            this.markedPositions.addFirst(this.count);
        }

        String rewind() {
            Integer position = this.markedPositions.pollFirst();
            if (position == null || position == this.count) {
                return "";
            }
            int length = this.count - position;
            this.count -= length;
            return new String(this.buf, (int)position, length);
        }
    }
}

