/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filesystem.provider;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.internal.filesystem.FileCache;
import org.eclipse.core.internal.filesystem.Messages;
import org.eclipse.core.internal.filesystem.Policy;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public abstract class FileStore
extends PlatformObject
implements IFileStore {
    protected static final IFileInfo[] EMPTY_FILE_INFO_ARRAY = new IFileInfo[0];
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];

    @Override
    public IFileInfo[] childInfos(int options, IProgressMonitor monitor) throws CoreException {
        IFileStore[] childStores = this.childStores(options, monitor);
        IFileInfo[] childInfos = new IFileInfo[childStores.length];
        int i = 0;
        while (i < childStores.length) {
            childInfos[i] = childStores[i].fetchInfo();
            ++i;
        }
        return childInfos;
    }

    @Override
    public abstract String[] childNames(int var1, IProgressMonitor var2) throws CoreException;

    @Override
    public IFileStore[] childStores(int options, IProgressMonitor monitor) throws CoreException {
        String[] children = this.childNames(options, monitor);
        IFileStore[] wrapped = new IFileStore[children.length];
        int i = 0;
        while (i < wrapped.length) {
            wrapped[i] = this.getChild(children[i]);
            ++i;
        }
        return wrapped;
    }

    @Override
    public void copy(IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        IFileInfo sourceInfo = this.fetchInfo(0, null);
        if (sourceInfo.isDirectory()) {
            this.copyDirectory(sourceInfo, destination, options, monitor);
        } else {
            this.copyFile(sourceInfo, destination, options, monitor);
        }
    }

    protected void copyDirectory(IFileInfo sourceInfo, IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        IFileStore[] children = null;
        int opWork = 1;
        if ((options & 4) == 0) {
            children = this.childStores(0, null);
            opWork += children.length;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)opWork);
        subMonitor.subTask(NLS.bind((String)Messages.copying, (Object)this.toString()));
        destination.mkdir(0, (IProgressMonitor)subMonitor.newChild(1));
        LocalFile.transferAttributes(sourceInfo, destination);
        if (children == null) {
            return;
        }
        IFileStore[] iFileStoreArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IFileStore c = iFileStoreArray[n2];
            c.copy(destination.getChild(c.getName()), options, (IProgressMonitor)subMonitor.newChild(1));
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void copyFile(IFileInfo sourceInfo, IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        if ((options & 2) == 0 && destination.fetchInfo().exists()) {
            Policy.error(268, NLS.bind((String)Messages.fileExists, (Object)destination));
        }
        String sourcePath = this.toString();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.copying, (Object)sourcePath), (int)100);
        try {
            Throwable throwable = null;
            Object var8_11 = null;
            try {
                InputStream in = this.openInputStream(0, (IProgressMonitor)subMonitor.newChild(1));
                try {
                    try (OutputStream out = destination.openOutputStream(0, (IProgressMonitor)subMonitor.newChild(1));){
                        in.transferTo(out);
                        subMonitor.worked(93);
                        LocalFile.transferAttributes(sourceInfo, destination);
                        subMonitor.worked(5);
                    }
                    if (in == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (in == null) throw throwable;
                    in.close();
                    throw throwable;
                }
                in.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Policy.error(272, NLS.bind((String)Messages.failedCopy, (Object)sourcePath), e);
            return;
        }
        catch (CoreException e) {
            if (destination.fetchInfo(0, null).exists()) throw e;
            destination.delete(0, null);
            throw e;
        }
    }

    @Override
    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        Policy.error(273, NLS.bind((String)Messages.noImplDelete, (Object)this.toString()));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FileStore)) {
            return false;
        }
        return this.toURI().equals(((FileStore)obj).toURI());
    }

    @Override
    public IFileInfo fetchInfo() {
        try {
            return this.fetchInfo(0, null);
        }
        catch (CoreException e) {
            FileInfo result = new FileInfo(this.getName());
            result.setExists(false);
            return result;
        }
    }

    @Override
    public abstract IFileInfo fetchInfo(int var1, IProgressMonitor var2) throws CoreException;

    @Override
    @Deprecated
    public IFileStore getChild(IPath path) {
        IFileStore result = this;
        int i = 0;
        int imax = path.segmentCount();
        while (i < imax) {
            result = result.getChild(path.segment(i));
            ++i;
        }
        return result;
    }

    @Override
    public IFileStore getFileStore(IPath path) {
        IFileStore result = this;
        String segment = null;
        int i = 0;
        int imax = path.segmentCount();
        while (i < imax) {
            segment = path.segment(i);
            if (!segment.equals(".")) {
                result = segment.equals("..") && result.getParent() != null ? result.getParent() : result.getChild(segment);
            }
            ++i;
        }
        return result;
    }

    @Override
    public abstract IFileStore getChild(String var1);

    @Override
    public IFileSystem getFileSystem() {
        try {
            return EFS.getFileSystem(this.toURI().getScheme());
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public abstract String getName();

    @Override
    public abstract IFileStore getParent();

    public int hashCode() {
        return this.toURI().hashCode();
    }

    @Override
    public boolean isParentOf(IFileStore other) {
        do {
            if ((other = other.getParent()) != null) continue;
            return false;
        } while (!this.equals(other));
        return true;
    }

    @Override
    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        Policy.error(272, NLS.bind((String)Messages.noImplWrite, (Object)this.toString()));
        return null;
    }

    @Override
    public void move(IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.moving, (Object)destination.toString()), (int)100);
            this.copy(destination, options & 2, (IProgressMonitor)subMonitor.newChild(70));
            this.delete(0, (IProgressMonitor)subMonitor.newChild(30));
        }
        catch (CoreException e) {
            String message = NLS.bind((String)Messages.couldNotMove, (Object)this.toString());
            Policy.error(272, message, e);
        }
    }

    @Override
    public abstract InputStream openInputStream(int var1, IProgressMonitor var2) throws CoreException;

    @Override
    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        Policy.error(272, NLS.bind((String)Messages.noImplWrite, (Object)this.toString()));
        return null;
    }

    @Override
    public void putInfo(IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
        Policy.error(272, NLS.bind((String)Messages.noImplWrite, (Object)this.toString()));
    }

    @Override
    public File toLocalFile(int options, IProgressMonitor monitor) throws CoreException {
        if (options != 4096) {
            return null;
        }
        return FileCache.getCache().cache(this, monitor);
    }

    @Override
    public String toString() {
        return this.toURI().toString();
    }

    @Override
    public abstract URI toURI();
}

