/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.template.java;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.internal.ui.text.template.contentassist.MultiVariable;
import org.eclipse.jdt.ls.core.internal.corext.template.java.VariablePosition;

public class MultiVariableGuess {
    private final Map<MultiVariable, Set<MultiVariable>> fDependencies = new HashMap<MultiVariable, Set<MultiVariable>>();
    private final Map<MultiVariable, MultiVariable> fBackwardDeps = new HashMap<MultiVariable, MultiVariable>();
    private final Map<MultiVariable, VariablePosition> fPositions = new HashMap<MultiVariable, VariablePosition>();

    public void addSlave(VariablePosition position) {
        this.fPositions.put(position.getVariable(), position);
    }

    public void addDependency(MultiVariable master, MultiVariable slave) {
        if (this.fBackwardDeps.containsKey(slave)) {
            throw new IllegalArgumentException("slave can only serve one master");
        }
        MultiVariable parent = master;
        while (parent != null) {
            if ((parent = this.fBackwardDeps.get(parent)) != slave) continue;
            throw new IllegalArgumentException("cycle detected");
        }
        Set<MultiVariable> slaves = this.fDependencies.get(master);
        if (slaves == null) {
            slaves = new HashSet<MultiVariable>();
            this.fDependencies.put(master, slaves);
        }
        this.fBackwardDeps.put(slave, master);
        slaves.add(slave);
    }
}

