/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.contentassist;

import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.codeassist.InternalCompletionProposal;
import org.eclipse.jdt.internal.core.manipulation.util.Strings;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;

public class GetterSetterCompletionProposal
extends InternalCompletionProposal {
    private IField fField;
    private boolean fIsGetter;

    public static void evaluateProposals(IType type, String prefix, int offset, int length, int relevance, Collection<CompletionProposal> result) throws JavaModelException {
        if (prefix.length() == 0) {
            --relevance;
        }
        IField[] fields = type.getFields();
        IMethod[] methods = type.getMethods();
        IField[] iFieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            IField curr = iFieldArray[n2];
            if (!JdtFlags.isEnum((IMember)curr)) {
                String setterName;
                String signature;
                GetterSetterCompletionProposal proposal;
                String getterName = GetterSetterUtil.getGetterName((IField)curr, null);
                if (Strings.startsWithIgnoreCase((String)getterName, (String)prefix) && !GetterSetterCompletionProposal.hasMethod(methods, getterName)) {
                    int getterRelevance = relevance;
                    if (JdtFlags.isStatic((IMember)curr) && JdtFlags.isFinal((IMember)curr)) {
                        getterRelevance = relevance - 1;
                    }
                    proposal = new GetterSetterCompletionProposal(curr, true, offset);
                    proposal.setName(getterName.toCharArray());
                    signature = Signature.createMethodSignature((String[])new String[0], (String)curr.getTypeSignature());
                    proposal.setReplaceRange(offset, offset + prefix.length());
                    proposal.setSignature(signature.toCharArray());
                    proposal.setCompletion(getterName.toCharArray());
                    proposal.setDeclarationSignature(curr.getTypeSignature().toCharArray());
                    result.add((CompletionProposal)proposal);
                }
                if (!JdtFlags.isFinal((IMember)curr) && Strings.startsWithIgnoreCase((String)(setterName = GetterSetterUtil.getSetterName((IField)curr, null)), (String)prefix) && !GetterSetterCompletionProposal.hasMethod(methods, setterName)) {
                    proposal = new GetterSetterCompletionProposal(curr, false, offset);
                    proposal.setName(setterName.toCharArray());
                    signature = Signature.createMethodSignature((String[])new String[]{curr.getTypeSignature()}, (String)"V");
                    proposal.setReplaceRange(offset, offset + prefix.length());
                    proposal.setSignature(signature.toCharArray());
                    proposal.setParameterNames(new char[][]{curr.getElementName().toCharArray()});
                    proposal.setCompletion(getterName.toCharArray());
                    proposal.setDeclarationSignature(curr.getTypeSignature().toCharArray());
                    result.add((CompletionProposal)proposal);
                }
            }
            ++n2;
        }
    }

    private static boolean hasMethod(IMethod[] methods, String name) {
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getElementName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public GetterSetterCompletionProposal(IField field, boolean isGetter, int offset) {
        super(11, offset);
        this.fField = field;
        this.fIsGetter = isGetter;
    }

    public String updateReplacementString(IDocument document, int offset, ImportRewrite importRewrite, boolean completionSnippetsSupported, boolean addComments) throws CoreException, BadLocationException {
        String stub;
        int flags = 1 | this.fField.getFlags() & 8;
        if (this.fIsGetter) {
            String getterName = GetterSetterUtil.getGetterName((IField)this.fField, null);
            stub = GetterSetterUtil.getGetterStub((IField)this.fField, (String)getterName, (boolean)addComments, (int)flags);
        } else {
            String setterName = GetterSetterUtil.getSetterName((IField)this.fField, null);
            stub = GetterSetterUtil.getSetterStub((IField)this.fField, (String)setterName, (boolean)addComments, (int)flags);
        }
        String lineDelim = TextUtilities.getDefaultLineDelimiter((IDocument)document);
        String replacement = CodeFormatterUtil.format((int)4, (String)stub, (int)0, (String)lineDelim, (IJavaProject)this.fField.getJavaProject());
        if (replacement.endsWith(lineDelim)) {
            replacement = replacement.substring(0, replacement.length() - lineDelim.length());
        }
        return replacement;
    }
}

