/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.fix.IProposableFix;
import org.eclipse.jdt.internal.corext.fix.UnusedCodeFixCore;
import org.eclipse.jdt.internal.corext.refactoring.changes.CreatePackageChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.MoveCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameCompilationUnitChange;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.fix.UnusedCodeCleanUp;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.IInvocationContextCore;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.CorrectPackageDeclarationProposalCore;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;

public abstract class ReorgCorrectionsBaseSubProcessor<T> {
    protected ReorgCorrectionsBaseSubProcessor() {
    }

    /*
     * WARNING - void declaration
     */
    public void addWrongTypeNameProposals(IInvocationContextCore context, IProblemLocationCore problem, Collection<T> proposals) {
        T prop1;
        void simpleCovered;
        ICompilationUnit cu = context.getCompilationUnit();
        boolean isLinked = cu.getResource().isLinked();
        IJavaProject javaProject = cu.getJavaProject();
        String sourceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
        String compliance = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        String previewEnabled = javaProject.getOption("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", true);
        CompilationUnit root = context.getASTRoot();
        ASTNode coveredNode = problem.getCoveredNode(root);
        ASTNode aSTNode = coveredNode;
        if (!(aSTNode instanceof SimpleName)) {
            return;
        }
        SimpleName simpleName = (SimpleName)aSTNode;
        SimpleName cfr_ignored_0 = (SimpleName)aSTNode;
        ASTNode parentType = coveredNode.getParent();
        if (!(parentType instanceof AbstractTypeDeclaration)) {
            return;
        }
        String currTypeName = simpleCovered.getIdentifier();
        String newTypeName = JavaCore.removeJavaLikeExtension((String)cu.getElementName());
        boolean hasOtherPublicTypeBefore = false;
        boolean found = false;
        List types = root.types();
        for (AbstractTypeDeclaration curr : types) {
            if (parentType != curr) {
                if (newTypeName.equals(curr.getName().getIdentifier())) {
                    return;
                }
                if (found || !Modifier.isPublic((int)curr.getModifiers())) continue;
                hasOtherPublicTypeBefore = true;
                continue;
            }
            found = true;
        }
        if (!JavaConventions.validateJavaTypeName((String)newTypeName, (String)sourceLevel, (String)compliance, (String)previewEnabled).matches(4) && (prop1 = this.createCorrectMainTypeNameProposal(cu, context, currTypeName, newTypeName, 5)) != null) {
            proposals.add(prop1);
        }
        if (!hasOtherPublicTypeBefore) {
            String newCUName = JavaModelUtil.getRenamedCUName(cu, currTypeName);
            ICompilationUnit newCU = ((IPackageFragment)cu.getParent()).getCompilationUnit(newCUName);
            if (!(newCU.exists() || isLinked || JavaConventions.validateCompilationUnitName((String)newCUName, (String)sourceLevel, (String)compliance).matches(4))) {
                RenameCompilationUnitChange change = new RenameCompilationUnitChange(cu, newCUName);
                String label = Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_renamecu_description, BasicElementLabels.getResourceName(newCUName));
                T p2 = this.createRenameCUProposal(label, change, 6);
                if (p2 != null) {
                    proposals.add(p2);
                }
            }
        }
    }

    public void addWrongPackageDeclNameProposals(IInvocationContextCore context, IProblemLocationCore problem, Collection<T> proposals) throws CoreException {
        IPackageDeclaration[] packDecls;
        T p1;
        int relevance;
        ICompilationUnit cu = context.getCompilationUnit();
        boolean isLinked = cu.getResource().isLinked();
        int n = relevance = cu.getPackageDeclarations().length == 0 ? 7 : 5;
        if (CorrectPackageDeclarationProposalCore.isValidProposal(cu) && (p1 = this.createCorrectPackageDeclarationProposal(cu, problem, relevance)) != null) {
            proposals.add(p1);
        }
        String newPackName = (packDecls = cu.getPackageDeclarations()).length > 0 ? packDecls[0].getElementName() : "";
        IPackageFragmentRoot root = JavaModelUtil.getPackageFragmentRoot((IJavaElement)cu);
        IPackageFragment newPack = root.getPackageFragment(newPackName);
        ICompilationUnit newCU = newPack.getCompilationUnit(cu.getElementName());
        if (!newCU.exists() && !isLinked) {
            String label;
            if (newPack.isDefaultPackage()) {
                label = Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_movecu_default_description, BasicElementLabels.getFileName((ITypeRoot)cu));
            } else {
                String packageLabel = JavaElementLabelsCore.getElementLabel((IJavaElement)newPack, 0x200009L);
                label = Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_movecu_description, new Object[]{BasicElementLabels.getFileName((ITypeRoot)cu), packageLabel});
            }
            CompositeChange composite = new CompositeChange(label);
            composite.add((Change)new CreatePackageChange(newPack));
            composite.add((Change)new MoveCompilationUnitChange(cu, newPack));
            T p12 = this.createMoveToNewPackageProposal(label, composite, 6);
            if (p12 != null) {
                proposals.add(p12);
            }
        }
    }

    public void addRemoveImportStatementProposals(IInvocationContextCore context, IProblemLocationCore problem, Collection<T> proposals) {
        ICompilationUnit cu;
        String name;
        T proposal;
        UnusedCodeFixCore fix = UnusedCodeFixCore.createRemoveUnusedImportFix(context.getASTRoot(), problem);
        if (fix != null) {
            Hashtable<String, String> options = new Hashtable<String, String>();
            options.put("cleanup.remove_unused_imports", "true");
            T proposal2 = this.createRemoveUnusedImportProposal(fix, new UnusedCodeCleanUp(options), 6, context);
            if (proposal2 != null) {
                proposals.add(proposal2);
            }
        }
        if ((proposal = this.createOrganizeImportsProposal(name = CorrectionMessages.ReorgCorrectionsSubProcessor_organizeimports_description, null, cu = context.getCompilationUnit(), 5)) != null) {
            proposals.add(proposal);
        }
    }

    public void addProjectSetupFixProposals(IInvocationContextCore context, IProblemLocationCore problem, String missingType, Collection<T> proposals) {
        T prop = this.createProjectSetupFixProposal(context, problem, missingType, proposals);
        if (prop != null) {
            proposals.add(prop);
        }
    }

    public void addNeedHigherComplianceProposals(IInvocationContextCore context, IProblemLocationCore problem, Collection<T> proposals, String requiredVersion) {
        this.addNeedHigherComplianceProposals(context, problem, proposals, false, requiredVersion);
    }

    public void addNeedHigherComplianceProposals(IInvocationContextCore context, IProblemLocationCore problem, Collection<T> proposals) {
        String[] args = problem.getProblemArguments();
        if (args != null && args.length == 2) {
            this.addNeedHigherComplianceProposals(context, problem, proposals, false, args[1]);
        }
    }

    protected void addNeedHigherComplianceProposals(IInvocationContextCore context, IProblemLocationCore problem, Collection<T> proposals, boolean enablePreviews, String requiredVersion) {
        IJavaProject project = context.getCompilationUnit().getJavaProject();
        String label1 = Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_change_project_compliance_description, requiredVersion);
        if (enablePreviews) {
            label1 = Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_combine_two_quickfixes, new String[]{label1, CorrectionMessages.PreviewFeaturesSubProcessor_enable_preview_features});
            proposals.add(this.createChangeToRequiredCompilerComplianceProposal(label1, project, false, requiredVersion, enablePreviews, 6));
        } else {
            proposals.add(this.createChangeToRequiredCompilerComplianceProposal(label1, project, false, requiredVersion, 6));
        }
        if (project.getOption("org.eclipse.jdt.core.compiler.compliance", false) == null) {
            T p1;
            String label2 = Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_change_workspace_compliance_description, requiredVersion);
            if (enablePreviews) {
                label2 = Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_combine_two_quickfixes, new String[]{label2, CorrectionMessages.PreviewFeaturesSubProcessor_enable_preview_features_workspace});
            }
            if ((p1 = this.createChangeToRequiredCompilerComplianceProposal(label2, project, true, requiredVersion, enablePreviews, 7)) != null) {
                proposals.add(p1);
            }
        }
    }

    public void addIncorrectBuildPathProposals(IInvocationContextCore context, IProblemLocationCore problem, Collection<T> proposals) {
        String label;
        IProject project = context.getCompilationUnit().getJavaProject().getProject();
        T proposal = this.createOpenBuildPathCorrectionProposal(project, label = CorrectionMessages.ReorgCorrectionsSubProcessor_configure_buildpath_label, 5, null);
        if (proposal != null) {
            proposals.add(proposal);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addAccessRulesProposals(IInvocationContextCore context, IProblemLocationCore problem, Collection<T> proposals) {
        String label;
        IProject project;
        T proposal;
        ITypeBinding referencedElement = null;
        ASTNode node = problem.getCoveredNode(context.getASTRoot());
        ASTNode aSTNode = node;
        if (aSTNode instanceof Type) {
            void type;
            Type type2 = (Type)aSTNode;
            Type cfr_ignored_0 = (Type)aSTNode;
            referencedElement = type.resolveBinding();
        } else {
            ASTNode aSTNode2 = node;
            if (aSTNode2 instanceof Name) {
                void name;
                Name name2 = (Name)aSTNode2;
                Name cfr_ignored_1 = (Name)aSTNode2;
                referencedElement = name.resolveBinding();
            }
        }
        if (referencedElement != null && ReorgCorrectionsBaseSubProcessor.canModifyAccessRules(referencedElement) && (proposal = this.createOpenBuildPathCorrectionProposal(project = context.getCompilationUnit().getJavaProject().getProject(), label = CorrectionMessages.ReorgCorrectionsSubProcessor_accessrules_description, 5, (IBinding)referencedElement)) != null) {
            proposals.add(proposal);
        }
    }

    private static boolean canModifyAccessRules(IBinding binding) {
        IClasspathEntry classpathEntry;
        IPackageFragmentRoot root;
        block8: {
            block7: {
                IJavaElement element = binding.getJavaElement();
                if (element == null) {
                    return false;
                }
                root = JavaModelUtil.getPackageFragmentRoot(element);
                if (root == null) {
                    return false;
                }
                try {
                    classpathEntry = root.getRawClasspathEntry();
                    if (classpathEntry != null) break block7;
                    return false;
                }
                catch (JavaModelException e) {
                    return false;
                }
            }
            if (classpathEntry.getEntryKind() != 1) break block8;
            return true;
        }
        if (classpathEntry.getEntryKind() == 5) {
            ClasspathContainerInitializer classpathContainerInitializer = JavaCore.getClasspathContainerInitializer((String)classpathEntry.getPath().segment(0));
            IStatus status = classpathContainerInitializer.getAccessRulesStatus(classpathEntry.getPath(), root.getJavaProject());
            return status.isOK();
        }
        return false;
    }

    public abstract T createRenameCUProposal(String var1, RenameCompilationUnitChange var2, int var3);

    public abstract T createCorrectMainTypeNameProposal(ICompilationUnit var1, IInvocationContextCore var2, String var3, String var4, int var5);

    protected abstract T createCorrectPackageDeclarationProposal(ICompilationUnit var1, IProblemLocationCore var2, int var3);

    protected abstract T createMoveToNewPackageProposal(String var1, CompositeChange var2, int var3);

    protected abstract T createOrganizeImportsProposal(String var1, Change var2, ICompilationUnit var3, int var4);

    protected abstract T createRemoveUnusedImportProposal(IProposableFix var1, UnusedCodeCleanUp var2, int var3, IInvocationContextCore var4);

    public abstract T createProjectSetupFixProposal(IInvocationContextCore var1, IProblemLocationCore var2, String var3, Collection<T> var4);

    public abstract boolean addImportNotFoundProposals(IInvocationContextCore var1, IProblemLocationCore var2, Collection<T> var3) throws CoreException;

    protected abstract T createChangeToRequiredCompilerComplianceProposal(String var1, IJavaProject var2, boolean var3, String var4, int var5);

    protected abstract T createChangeToRequiredCompilerComplianceProposal(String var1, IJavaProject var2, boolean var3, String var4, boolean var5, int var6);

    protected abstract T createOpenBuildPathCorrectionProposal(IProject var1, String var2, int var3, IBinding var4);
}

