/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jdt.ls.core.internal.ActionableNotification;
import org.eclipse.jdt.ls.core.internal.EventNotification;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProgressReport;
import org.eclipse.jdt.ls.core.internal.ServiceStatus;
import org.eclipse.jdt.ls.core.internal.StatusReport;
import org.eclipse.jdt.ls.core.internal.handlers.LogHandler;
import org.eclipse.jdt.ls.core.internal.lsp.ExecuteCommandProposedClient;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.ApplyWorkspaceEditResponse;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.ConfigurationParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.RegistrationParams;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.lsp4j.UnregistrationParams;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.services.JsonNotification;
import org.eclipse.lsp4j.services.LanguageClient;

public class JavaClientConnection {
    private final LogHandler logHandler;
    final JavaLanguageClient client;

    public JavaClientConnection(JavaLanguageClient client) {
        this.client = client;
        this.logHandler = new LogHandler();
        this.logHandler.install(this);
    }

    public Object executeClientCommand(Duration timeout, String id, Object ... params) throws InterruptedException, ExecutionException, TimeoutException {
        return this.client.executeClientCommand(new ExecuteCommandParams(id, (List)ImmutableList.copyOf((Object[])params))).get(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    public Object executeClientCommand(String id, Object ... params) {
        return this.client.executeClientCommand(new ExecuteCommandParams(id, (List)ImmutableList.copyOf((Object[])params))).join();
    }

    public void sendNotification(String id, Object ... params) {
        this.client.sendNotification(new ExecuteCommandParams(id, (List)ImmutableList.copyOf((Object[])params)));
    }

    public void logMessage(MessageType type, String msg) {
        MessageParams $ = new MessageParams();
        $.setMessage(msg);
        $.setType(type);
        this.client.logMessage($);
    }

    public void showNotificationMessage(MessageType type, String msg) {
        MessageParams $ = new MessageParams();
        $.setMessage(msg);
        $.setType(type);
        this.client.showMessage($);
    }

    public MessageActionItem showNotificationMessageRequest(MessageType type, String msg, List<MessageActionItem> actions) {
        ShowMessageRequestParams $ = new ShowMessageRequestParams();
        $.setMessage(msg);
        $.setType(type);
        $.setActions(actions);
        return (MessageActionItem)this.client.showMessageRequest($).join();
    }

    public void sendStatus(ServiceStatus serverStatus, String status) {
        StatusReport $ = new StatusReport();
        this.client.sendStatusReport($.withMessage(status).withType(serverStatus.name()));
    }

    public void sendActionableNotification(MessageType severity, String message, Object data, List<Command> commands) {
        ActionableNotification notification = new ActionableNotification().withSeverity(severity).withMessage(message).withData(data).withCommands(commands);
        this.sendActionableNotification(notification);
    }

    public void sendActionableNotification(ActionableNotification notification) {
        this.client.sendActionableNotification(notification);
    }

    public void sendEventNotification(EventNotification notification) {
        this.client.sendEventNotification(notification);
    }

    public void publishDiagnostics(PublishDiagnosticsParams diagnostics) {
        this.client.publishDiagnostics(diagnostics);
    }

    public boolean applyWorkspaceEdit(WorkspaceEdit edit) {
        ApplyWorkspaceEditParams $ = new ApplyWorkspaceEditParams();
        $.setEdit(edit);
        ApplyWorkspaceEditResponse response = (ApplyWorkspaceEditResponse)this.client.applyEdit($).join();
        return response.isApplied();
    }

    public void unregisterCapability(UnregistrationParams params) {
        this.client.unregisterCapability(params);
    }

    public void registerCapability(RegistrationParams params) {
        this.client.registerCapability(params);
    }

    public List<Object> configuration(ConfigurationParams configurationParams) {
        return (List)this.client.configuration(configurationParams).join();
    }

    public CompletableFuture<Void> refreshInlayHints() {
        return this.client.refreshInlayHints();
    }

    public void disconnect() {
        if (this.logHandler != null) {
            this.logHandler.uninstall();
        }
    }

    public void telemetryEvent(Object object) {
        if (JavaLanguageServerPlugin.getPreferencesManager() != null && JavaLanguageServerPlugin.getPreferencesManager().getPreferences().isTelemetryEnabled()) {
            this.client.telemetryEvent(object);
        }
    }

    public static interface JavaLanguageClient
    extends LanguageClient,
    ExecuteCommandProposedClient {
        @JsonNotification(value="language/status")
        public void sendStatusReport(StatusReport var1);

        @JsonNotification(value="language/actionableNotification")
        public void sendActionableNotification(ActionableNotification var1);

        @JsonNotification(value="language/eventNotification")
        public void sendEventNotification(EventNotification var1);

        @JsonNotification(value="language/progressReport")
        public void sendProgressReport(ProgressReport var1);
    }
}

