/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.DimensionRewrite;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;

public final class SplitVariableFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public SplitVariableFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] operations) {
        super(name, compilationUnit, operations);
    }

    public static SplitVariableFixCore createSplitVariableFix(CompilationUnit compilationUnit, ASTNode node) {
        VariableDeclarationStatement statement;
        VariableDeclarationFragment fragment;
        if (node instanceof VariableDeclarationFragment) {
            fragment = (VariableDeclarationFragment)node;
        } else if (node.getLocationInParent() == VariableDeclarationFragment.NAME_PROPERTY) {
            fragment = (VariableDeclarationFragment)node.getParent();
        } else {
            return null;
        }
        if (fragment.getInitializer() == null) {
            return null;
        }
        ASTNode fragParent = fragment.getParent();
        boolean isVarType = false;
        if (fragParent instanceof VariableDeclarationStatement) {
            statement = (VariableDeclarationStatement)fragParent;
            type = ((VariableDeclarationStatement)fragParent).getType();
            isVarType = type == null ? false : type.isVar();
        } else if (fragParent instanceof VariableDeclarationExpression) {
            if (fragParent.getLocationInParent() == TryStatement.RESOURCES2_PROPERTY) {
                return null;
            }
            statement = (Statement)fragParent.getParent();
            type = ((VariableDeclarationExpression)fragParent).getType();
            isVarType = type == null ? false : type.isVar();
        } else {
            return null;
        }
        if (!(statement instanceof ForStatement) && !(statement instanceof VariableDeclarationStatement)) {
            return null;
        }
        ASTNode statementParent = statement.getParent();
        StructuralPropertyDescriptor property = statement.getLocationInParent();
        if (!property.isChildListProperty()) {
            return null;
        }
        return new SplitVariableFixCore(CorrectionMessages.QuickAssistProcessor_splitdeclaration_description, compilationUnit, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{new SplitVariableProposalOperation((Statement)statement, fragment, fragParent, isVarType, statementParent, property)});
    }

    private static class SplitVariableProposalOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private Statement statement;
        private VariableDeclarationFragment fragment;
        private ASTNode fragParent;
        private boolean isVarType;
        private ASTNode statementParent;
        private StructuralPropertyDescriptor property;

        public SplitVariableProposalOperation(Statement statement, VariableDeclarationFragment fragment, ASTNode fragParent, boolean isVarType, ASTNode statementParent, StructuralPropertyDescriptor property) {
            this.statement = statement;
            this.fragment = fragment;
            this.fragParent = fragParent;
            this.isVarType = isVarType;
            this.statementParent = statementParent;
            this.property = property;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            CompilationUnit cup = (CompilationUnit)this.fragment.getRoot();
            AST ast = cuRewrite.getAST();
            if (this.statement instanceof ForStatement) {
                IBuffer buffer = cuRewrite.getCu().getBuffer();
                ForStatement forStatement = (ForStatement)this.statement;
                VariableDeclarationExpression oldVarDecl = (VariableDeclarationExpression)this.fragParent;
                Type type = oldVarDecl.getType();
                ITypeBinding tBinding = type.resolveBinding();
                List oldFragments = oldVarDecl.fragments();
                ListRewrite forListRewrite = rewrite.getListRewrite((ASTNode)forStatement, ForStatement.INITIALIZERS_PROPERTY);
                for (VariableDeclarationFragment oldFragment : oldFragments) {
                    int extendedStartPositionFragment = cup.getExtendedStartPosition((ASTNode)oldFragment);
                    int extendedLengthFragment = cup.getExtendedLength((ASTNode)oldFragment);
                    StringBuilder codeFragment = new StringBuilder(buffer.getText(extendedStartPositionFragment, extendedLengthFragment));
                    if (oldFragment.getInitializer() == null) {
                        ITypeBinding typeBinding = type.resolveBinding();
                        if ("Z".equals(typeBinding.getBinaryName())) {
                            codeFragment.append(" = false");
                        } else if (type.isPrimitiveType()) {
                            codeFragment.append(" = 0");
                        } else {
                            codeFragment.append(" = null");
                        }
                    }
                    Assignment newAssignmentFragment = (Assignment)rewrite.createStringPlaceholder(codeFragment.toString(), 7);
                    forListRewrite.insertLast((ASTNode)newAssignmentFragment, null);
                }
                Type nType = null;
                if (this.isVarType) {
                    ImportRewrite importRewrite = cuRewrite.getImportRewrite();
                    ContextSensitiveImportRewriteContext icontext = new ContextSensitiveImportRewriteContext((ASTNode)cup, importRewrite);
                    nType = importRewrite.addImport(tBinding, ast, (ImportRewrite.ImportRewriteContext)icontext, ImportRewrite.TypeLocation.LOCAL_VARIABLE);
                    codeDeclaration = tBinding.getName();
                    String commentToken = "";
                    int extendedStatementStart = cup.getExtendedStartPosition((ASTNode)oldVarDecl);
                    if (oldVarDecl.getStartPosition() > extendedStatementStart) {
                        commentToken = buffer.getText(extendedStatementStart, oldVarDecl.getStartPosition() - extendedStatementStart);
                    }
                    codeDeclaration = commentToken + (String)codeDeclaration;
                    nType = (Type)rewrite.createStringPlaceholder(((String)codeDeclaration).trim(), type.getNodeType());
                } else {
                    int extendedStartPositionDeclaration = cup.getExtendedStartPosition((ASTNode)oldVarDecl);
                    int firstFragmentStart = ((ASTNode)oldVarDecl.fragments().get(0)).getStartPosition();
                    codeDeclaration = buffer.getText(extendedStartPositionDeclaration, firstFragmentStart - extendedStartPositionDeclaration);
                    nType = (Type)rewrite.createStringPlaceholder(((String)codeDeclaration).trim(), type.getNodeType());
                }
                VariableDeclarationFragment newFrag = ast.newVariableDeclarationFragment();
                VariableDeclarationStatement newVarDec = ast.newVariableDeclarationStatement(newFrag);
                newVarDec.setType(nType);
                newFrag.setName(ast.newSimpleName(((VariableDeclarationFragment)oldFragments.get(0)).getName().getIdentifier()));
                newFrag.extraDimensions().addAll(DimensionRewrite.copyDimensions(((VariableDeclarationFragment)oldFragments.get(0)).extraDimensions(), rewrite));
                int i = 1;
                while (i < oldFragments.size()) {
                    VariableDeclarationFragment oldFragment = (VariableDeclarationFragment)oldFragments.get(i);
                    newFrag = ast.newVariableDeclarationFragment();
                    newFrag.setName(ast.newSimpleName(oldFragment.getName().getIdentifier()));
                    newFrag.extraDimensions().addAll(DimensionRewrite.copyDimensions(oldFragment.extraDimensions(), rewrite));
                    newVarDec.fragments().add(newFrag);
                    ++i;
                }
                newVarDec.modifiers().addAll(ASTNodeFactory.newModifiers(ast, oldVarDecl.getModifiers()));
                ListRewrite listRewriter = rewrite.getListRewrite(this.statementParent, (ChildListPropertyDescriptor)this.property);
                listRewriter.insertBefore((ASTNode)newVarDec, (ASTNode)this.statement, null);
                rewrite.remove((ASTNode)oldVarDecl, null);
            } else {
                List list = ASTNodes.getChildListProperty(this.statementParent, (ChildListPropertyDescriptor)this.property);
                int insertIndex = list.indexOf(this.statement);
                ITypeBinding binding = this.fragment.getInitializer().resolveTypeBinding();
                Expression placeholder = (Expression)rewrite.createMoveTarget((ASTNode)this.fragment.getInitializer());
                if (placeholder instanceof ArrayInitializer && binding != null && binding.isArray()) {
                    ArrayCreation creation = ast.newArrayCreation();
                    creation.setInitializer((ArrayInitializer)placeholder);
                    ITypeBinding componentType = binding.getElementType();
                    Object type = null;
                    type = componentType.isPrimitive() ? ast.newPrimitiveType(PrimitiveType.toCode((String)componentType.getName())) : ast.newSimpleType((Name)ast.newSimpleName(componentType.getName()));
                    creation.setType(ast.newArrayType((Type)type, binding.getDimensions()));
                    placeholder = creation;
                }
                Assignment assignment = ast.newAssignment();
                assignment.setRightHandSide(placeholder);
                assignment.setLeftHandSide((Expression)ast.newSimpleName(this.fragment.getName().getIdentifier()));
                ExpressionStatement newStatement = ast.newExpressionStatement((Expression)assignment);
                ++insertIndex;
                if (this.isVarType) {
                    VariableDeclarationStatement varDecl = (VariableDeclarationStatement)this.statement;
                    Type type = varDecl.getType();
                    ITypeBinding tBinding = type.resolveBinding();
                    ImportRewrite importRewrite = cuRewrite.getImportRewrite();
                    ContextSensitiveImportRewriteContext icontext = new ContextSensitiveImportRewriteContext((ASTNode)cup, importRewrite);
                    Type nType = importRewrite.addImport(tBinding, ast, (ImportRewrite.ImportRewriteContext)icontext, ImportRewrite.TypeLocation.LOCAL_VARIABLE);
                    rewrite.set((ASTNode)varDecl, (StructuralPropertyDescriptor)VariableDeclarationStatement.TYPE_PROPERTY, (Object)nType, null);
                    DimensionRewrite.removeAllChildren((ASTNode)this.fragment, VariableDeclarationFragment.EXTRA_DIMENSIONS2_PROPERTY, rewrite, null);
                }
                ListRewrite listRewriter = rewrite.getListRewrite(this.statementParent, (ChildListPropertyDescriptor)this.property);
                listRewriter.insertAt((ASTNode)newStatement, insertIndex, null);
            }
        }
    }
}

