/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac.dom;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import javax.lang.model.element.ElementKind;
import org.eclipse.core.runtime.ILog;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.JavacBindingResolver;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.codeassist.DOMCompletionUtils;
import org.eclipse.jdt.internal.core.BinaryMember;
import org.eclipse.jdt.internal.core.DOMToModelPopulator;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.LambdaMethod;
import org.eclipse.jdt.internal.core.LocalVariable;
import org.eclipse.jdt.internal.core.ResolvedBinaryField;
import org.eclipse.jdt.internal.core.ResolvedSourceField;
import org.eclipse.jdt.internal.core.SourceField;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jdt.internal.javac.dom.JavacMethodBinding;
import org.eclipse.jdt.internal.javac.dom.JavacTypeBinding;

public abstract class JavacVariableBinding
implements IVariableBinding {
    public final Symbol.VarSymbol variableSymbol;
    private final JavacBindingResolver resolver;
    private IJavaElement javaElement;
    private String key;

    public JavacVariableBinding(Symbol.VarSymbol sym, JavacBindingResolver resolver) {
        this.variableSymbol = sym;
        this.resolver = resolver;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof JavacVariableBinding)) return false;
        JavacVariableBinding other = (JavacVariableBinding)obj;
        if (!Objects.equals((Object)this.resolver, (Object)other.resolver)) return false;
        if (!Objects.equals(this.variableSymbol, other.variableSymbol)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resolver, this.variableSymbol});
    }

    public IAnnotationBinding[] getAnnotations() {
        if (this.isRecordComponent()) {
            return Arrays.stream(this.getDeclaringClass().getDeclaredMethods()).filter(method -> this.getName().equals(method.getName())).findAny().map(IBinding::getAnnotations).orElseGet(() -> new IAnnotationBinding[0]);
        }
        if (this.variableSymbol == null) {
            return new IAnnotationBinding[0];
        }
        Stream<Object> anns = this.variableSymbol.getAnnotationMirrors().stream();
        if (!this.resolver.isRecoveringBindings()) {
            anns = anns.filter(ann -> !ann.type.isErroneous());
        }
        return (IAnnotationBinding[])anns.map(ann -> this.resolver.bindings.getAnnotationBinding((Attribute.Compound)ann, (IBinding)this)).toArray(IAnnotationBinding[]::new);
    }

    public int getKind() {
        return 3;
    }

    public int getModifiers() {
        ASTNode decl = this.resolver.findDeclaringNode((IBinding)this);
        if (decl instanceof SingleVariableDeclaration) {
            SingleVariableDeclaration singleDecl = (SingleVariableDeclaration)decl;
            return singleDecl.getModifiers();
        }
        return JavacMethodBinding.toInt(this.variableSymbol.getModifiers());
    }

    public boolean isDeprecated() {
        return this.variableSymbol.isDeprecated();
    }

    public boolean isRecovered() {
        return this.variableSymbol.kind == Kinds.Kind.ERR || this.variableSymbol.type == null;
    }

    public boolean isSynthetic() {
        return (this.variableSymbol.flags() & 0x1000L) != 0L;
    }

    public IJavaElement getJavaElement() {
        if (this.javaElement == null) {
            this.javaElement = this.computeJavaElement();
        }
        return this.javaElement;
    }

    private IJavaElement computeJavaElement() {
        Object object;
        IJavaElement iJavaElement;
        if (this.resolver.javaProject == null) {
            return null;
        }
        Symbol symbol = this.variableSymbol.owner;
        if (symbol instanceof Symbol.TypeSymbol) {
            Symbol.TypeSymbol parentType = (Symbol.TypeSymbol)symbol;
            if (parentType.type != null && (symbol = this.resolver.bindings.getTypeBinding(parentType.type).getJavaElement()) instanceof IType) {
                IType type = (IType)symbol;
                return this.resolved(type.getField(this.variableSymbol.name.toString()));
            }
        }
        IMethodBinding methodBinding = this.getDeclaringMethod();
        IMethod parent = null;
        if (methodBinding != null && (iJavaElement = methodBinding.getJavaElement()) instanceof IMethod) {
            IMethod method;
            parent = method = (IMethod)iJavaElement;
            if (this.isParameter()) {
                if (method instanceof LambdaMethod) {
                    LambdaMethod parentLambda = (LambdaMethod)method;
                    ASTNode aSTNode = this.resolver.findDeclaringNode((IBinding)this);
                    if (aSTNode instanceof VariableDeclaration) {
                        VariableDeclaration decl = (VariableDeclaration)aSTNode;
                        return new LocalVariable((JavaElement)parentLambda, this.getName(), decl.getStartPosition(), decl.getStartPosition() + decl.getLength() - 1, decl.getName().getStartPosition(), decl.getName().getStartPosition() + decl.getName().getLength() - 1, Signature.createTypeSignature((String)this.getType().getQualifiedName(), (boolean)true), null, this.getModifiers(), true);
                    }
                }
                try {
                    return Arrays.stream(method.getParameters()).filter(param -> Objects.equals(param.getElementName(), this.getName())).findAny().orElse(null);
                }
                catch (JavaModelException e) {
                    ILog.get().error(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (parent == null && (object = this.variableSymbol.owner) instanceof Symbol.MethodSymbol) {
            Symbol.MethodSymbol meth = (Symbol.MethodSymbol)object;
            if (meth.name.isEmpty() && (object = meth.owner) instanceof Symbol.ClassSymbol) {
                Object clazzBinding;
                Symbol.ClassSymbol clazz = (Symbol.ClassSymbol)object;
                object = this.resolver.bindings.getTypeBinding(clazz.type);
                if (object instanceof JavacTypeBinding && (object = ((JavacTypeBinding)(clazzBinding = object)).getJavaElement()) instanceof IType) {
                    IType owningType = (IType)object;
                    parent = owningType.getInitializer(1);
                }
            }
        }
        if (parent instanceof JavaElement) {
            VariableDeclarationExpression expression;
            VariableDeclarationStatement statement;
            JavaElement p = (JavaElement)parent;
            ASTNode node = this.resolver.findNode(this.variableSymbol);
            if (node instanceof VariableDeclarationFragment) {
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)node;
                return JavacVariableBinding.toLocalVariable(fragment, p);
            }
            if (node instanceof SingleVariableDeclaration) {
                SingleVariableDeclaration variableDecl = (SingleVariableDeclaration)node;
                return DOMToModelPopulator.toLocalVariable((SingleVariableDeclaration)variableDecl, (JavaElement)p);
            }
            if (node instanceof VariableDeclarationStatement && (statement = (VariableDeclarationStatement)node).fragments().size() == 1) {
                return JavacVariableBinding.toLocalVariable((VariableDeclarationFragment)statement.fragments().get(0), p);
            }
            if (node instanceof VariableDeclarationExpression && (expression = (VariableDeclarationExpression)node).fragments().size() == 1) {
                return JavacVariableBinding.toLocalVariable((VariableDeclarationFragment)expression.fragments().get(0), p);
            }
        }
        return null;
    }

    private IField resolved(IField field) {
        if (field instanceof SourceField && !(field instanceof ResolvedSourceField)) {
            return new ResolvedSourceField((JavaElement)field.getParent(), field.getElementName(), this.getKey(), field.getOccurrenceCount());
        }
        if (field instanceof BinaryMember && !(field instanceof ResolvedBinaryField)) {
            return new ResolvedBinaryField((JavaElement)field.getParent(), field.getElementName(), this.getKey(), field.getOccurrenceCount());
        }
        return field;
    }

    public String getKey() {
        if (this.key == null) {
            this.key = this.computeKey();
        }
        return this.key;
    }

    private String computeKey() {
        try {
            return this.getKeyImpl();
        }
        catch (JavacBindingResolver.BindingKeyException bke) {
            return null;
        }
    }

    private String getKeyImpl() throws JavacBindingResolver.BindingKeyException {
        StringBuilder builder = new StringBuilder();
        Symbol symbol = this.variableSymbol.owner;
        if (symbol instanceof Symbol.TypeSymbol) {
            Symbol.TypeSymbol classSymbol = (Symbol.TypeSymbol)symbol;
            if (classSymbol.type.asElement() == null) {
                return null;
            }
            JavacTypeBinding.getKey(builder, classSymbol.type, false, false, true, this.resolver);
            builder.append('.');
            builder.append(this.variableSymbol.name);
            builder.append(')');
            if (this.variableSymbol.type != null) {
                JavacTypeBinding.getKey(builder, this.variableSymbol.type, false, false, true, this.resolver);
            } else {
                builder.append('V');
            }
            return builder.toString();
        }
        symbol = this.variableSymbol.owner;
        if (symbol instanceof Symbol.MethodSymbol) {
            Type.MethodType methodType;
            Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
            Type type = methodSymbol.type;
            Type.MethodType toUse = type instanceof Type.MethodType ? (methodType = (Type.MethodType)type) : null;
            JavacMethodBinding.getKey(builder, methodSymbol, toUse, null, true, this.resolver);
            if (!this.isUnique()) {
                builder.append(this.variableSymbol.pos);
            }
            builder.append("#");
            builder.append(this.variableSymbol.name);
            return builder.toString();
        }
        throw new UnsupportedOperationException("unhandled `Symbol` subclass " + this.variableSymbol.owner.getClass().toString());
    }

    private boolean isUnique() {
        final ASTNode variable = this.resolver.findDeclaringNode((IBinding)this);
        MethodDeclaration parentMethod = (MethodDeclaration)DOMCompletionUtils.findParent(variable, new int[]{31});
        if (parentMethod == null) {
            return true;
        }
        final String variableName = this.getName().toString();
        class UniquenessVisitor
        extends ASTVisitor {
            boolean isUnique;

            UniquenessVisitor() {
                Objects.requireNonNull(this$0);
                this.isUnique = true;
            }

            public boolean visit(VariableDeclarationFragment node) {
                if (node != variable && variableName.equals(node.getName().toString())) {
                    this.isUnique = false;
                }
                return super.visit(node);
            }

            public boolean visit(SingleVariableDeclaration node) {
                if (node != variable && variableName.equals(node.getName().toString())) {
                    this.isUnique = false;
                }
                return super.visit(node);
            }
        }
        UniquenessVisitor uniquenessVisitor = new UniquenessVisitor();
        parentMethod.accept((ASTVisitor)uniquenessVisitor);
        return uniquenessVisitor.isUnique;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEqualTo(IBinding binding) {
        if (!(binding instanceof JavacVariableBinding)) return false;
        JavacVariableBinding other = (JavacVariableBinding)binding;
        if (!Objects.equals(this.getKey(), other.getKey())) return false;
        return true;
    }

    public boolean isField() {
        return this.variableSymbol.owner instanceof Symbol.ClassSymbol;
    }

    public boolean isEnumConstant() {
        return this.variableSymbol.isEnum();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isParameter() {
        Symbol symbol = this.variableSymbol.owner;
        if (!(symbol instanceof Symbol.MethodSymbol)) return false;
        Symbol.MethodSymbol ownerMethod = (Symbol.MethodSymbol)symbol;
        if ((this.variableSymbol.flags() & 0x200000000L) == 0L) return false;
        if (this.variableSymbol.getKind() == ElementKind.EXCEPTION_PARAMETER) return false;
        return true;
    }

    public String getName() {
        return ((Name)this.variableSymbol.getSimpleName()).toString();
    }

    public JavacTypeBinding getDeclaringClass() {
        Symbol parentSymbol = this.variableSymbol.owner;
        do {
            if (parentSymbol instanceof Symbol.MethodSymbol) {
                return null;
            }
            if (!(parentSymbol instanceof Symbol.ClassSymbol)) continue;
            Symbol.ClassSymbol clazz = (Symbol.ClassSymbol)parentSymbol;
            if (clazz.name.toString().equals("Array") && clazz.owner != null && clazz.owner.kind == Kinds.Kind.NIL) {
                return null;
            }
            if (clazz.type == null) continue;
            return this.resolver.bindings.getTypeBinding(clazz.type);
        } while ((parentSymbol = parentSymbol.owner) != null);
        return null;
    }

    public ITypeBinding getType() {
        JavacTypeBinding res = this.resolver.bindings.getTypeBinding(this.variableSymbol.type);
        if (res != null) {
            return res;
        }
        ASTNode node = this.resolver.findDeclaringNode((IBinding)this);
        if (node == null) {
            return null;
        }
        org.eclipse.jdt.core.dom.Type declType = null;
        if (node instanceof SingleVariableDeclaration) {
            SingleVariableDeclaration decl = (SingleVariableDeclaration)node;
            declType = decl.getType();
        } else if (node instanceof VariableDeclarationFragment) {
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)node;
            ASTNode aSTNode = fragment.getParent();
            if (aSTNode instanceof VariableDeclarationExpression) {
                VariableDeclarationExpression expr = (VariableDeclarationExpression)aSTNode;
                declType = expr.getType();
            } else {
                aSTNode = fragment.getParent();
                if (aSTNode instanceof VariableDeclarationStatement) {
                    VariableDeclarationStatement expr = (VariableDeclarationStatement)aSTNode;
                    declType = expr.getType();
                } else {
                    aSTNode = fragment.getParent();
                    if (aSTNode instanceof FieldDeclaration) {
                        FieldDeclaration fieldDecl = (FieldDeclaration)aSTNode;
                        declType = fieldDecl.getType();
                    }
                }
            }
        }
        return declType != null && (node.getAST().apiLevel() < 10 || !declType.isVar()) ? declType.resolveBinding() : null;
    }

    public int getVariableId() {
        ASTNode aSTNode;
        if (this.resolver.symbolToDeclaration != null && (aSTNode = this.resolver.symbolToDeclaration.get(this.variableSymbol)) instanceof VariableDeclaration) {
            VariableDeclaration decl = (VariableDeclaration)aSTNode;
            return decl.getStartPosition();
        }
        return this.variableSymbol.adr;
    }

    public Object getConstantValue() {
        return this.variableSymbol.getConstantValue();
    }

    public IMethodBinding getDeclaringMethod() {
        Symbol parentSymbol = this.variableSymbol.owner;
        if (parentSymbol instanceof Symbol.ClassSymbol) {
            return null;
        }
        do {
            ASTNode parent;
            if (!(parentSymbol instanceof Symbol.MethodSymbol)) continue;
            Symbol.MethodSymbol method = (Symbol.MethodSymbol)parentSymbol;
            if (method.type == null || method.type.asMethodType() == null) {
                return null;
            }
            if (((Name)method.getSimpleName()).isEmpty()) {
                return null;
            }
            JavacMethodBinding res = this.resolver.bindings.getMethodBinding(method.type.asMethodType(), method, null, false, null);
            ASTNode declaring = this.resolver.findDeclaringNode((IBinding)this);
            ASTNode aSTNode = parent = declaring == null ? null : declaring.getParent();
            if (parent instanceof LambdaExpression) {
                LambdaExpression lambda = (LambdaExpression)parent;
                return lambda.resolveMethodBinding();
            }
            return res;
        } while ((parentSymbol = parentSymbol.owner) != null);
        return null;
    }

    public IVariableBinding getVariableDeclaration() {
        return this;
    }

    public boolean isEffectivelyFinal() {
        return (this.variableSymbol.flags() & 0x20000000000L) != 0L;
    }

    private static LocalVariable toLocalVariable(VariableDeclarationFragment fragment, JavaElement parent) {
        ASTNode aSTNode = fragment.getParent();
        if (aSTNode instanceof VariableDeclarationStatement) {
            VariableDeclarationStatement variableDeclaration = (VariableDeclarationStatement)aSTNode;
            return new LocalVariable(parent, fragment.getName().getIdentifier(), variableDeclaration.getStartPosition(), variableDeclaration.getStartPosition() + variableDeclaration.getLength() - 1, fragment.getName().getStartPosition(), fragment.getName().getStartPosition() + fragment.getName().getLength() - 1, Util.getSignature((org.eclipse.jdt.core.dom.Type)variableDeclaration.getType()), null, JavacVariableBinding.toModelFlags(variableDeclaration.getModifiers(), false), false);
        }
        aSTNode = fragment.getParent();
        if (aSTNode instanceof VariableDeclarationExpression) {
            VariableDeclarationExpression variableDeclaration = (VariableDeclarationExpression)aSTNode;
            return new LocalVariable(parent, fragment.getName().getIdentifier(), variableDeclaration.getStartPosition(), variableDeclaration.getStartPosition() + variableDeclaration.getLength() - 1, fragment.getName().getStartPosition(), fragment.getName().getStartPosition() + fragment.getName().getLength() - 1, Util.getSignature((org.eclipse.jdt.core.dom.Type)variableDeclaration.getType()), null, JavacVariableBinding.toModelFlags(variableDeclaration.getModifiers(), false), false);
        }
        return null;
    }

    private static int toModelFlags(int domModifiers, boolean isDeprecated) {
        int res = 0;
        if (Modifier.isAbstract((int)domModifiers)) {
            res |= 0x400;
        }
        if (Modifier.isDefault((int)domModifiers)) {
            res |= 0x10000;
        }
        if (Modifier.isFinal((int)domModifiers)) {
            res |= 0x10;
        }
        if (Modifier.isNative((int)domModifiers)) {
            res |= 0x100;
        }
        if (Modifier.isNonSealed((int)domModifiers)) {
            res |= 0x4000000;
        }
        if (Modifier.isPrivate((int)domModifiers)) {
            res |= 2;
        }
        if (Modifier.isProtected((int)domModifiers)) {
            res |= 4;
        }
        if (Modifier.isPublic((int)domModifiers)) {
            res |= 1;
        }
        if (Modifier.isSealed((int)domModifiers)) {
            res |= 0x10000000;
        }
        if (Modifier.isStatic((int)domModifiers)) {
            res |= 8;
        }
        if (Modifier.isStrictfp((int)domModifiers)) {
            res |= 0x800;
        }
        if (Modifier.isSynchronized((int)domModifiers)) {
            res |= 0x20;
        }
        if (Modifier.isTransient((int)domModifiers)) {
            res |= 0x80;
        }
        if (Modifier.isVolatile((int)domModifiers)) {
            res |= 0x40;
        }
        if (isDeprecated) {
            res |= 0x100000;
        }
        return res;
    }

    public String toString() {
        return this.getType().getQualifiedName() + " " + this.getName();
    }

    public boolean isRecordComponent() {
        Symbol.MethodSymbol method;
        Symbol.ClassSymbol ownerType;
        Symbol symbol = this.variableSymbol.owner;
        return symbol instanceof Symbol.ClassSymbol && (ownerType = (Symbol.ClassSymbol)symbol).isRecord() || (symbol = this.variableSymbol.owner) instanceof Symbol.MethodSymbol && (method = (Symbol.MethodSymbol)symbol).params().contains(this.variableSymbol) && method.isConstructor() && (method.flags() & 0x2000000000000000L) != 0L;
    }
}

