/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.manipulation;

import java.util.regex.Pattern;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class JavaElementPropertyTester
extends PropertyTester {
    public static final String NAME = "name";
    public static final String IS_IN_JAVA_PROJECT = "isInJavaProject";
    public static final String IS_IN_JAVA_PROJECT_WITH_NATURE = "isInJavaProjectWithNature";
    public static final String IS_ON_CLASSPATH = "isOnClasspath";
    public static final String HAS_TYPE_ON_CLASSPATH = "hasTypeOnClasspath";
    public static final String IN_SOURCE_FOLDER = "inSourceFolder";
    public static final String IN_ARCHIVE = "inArchive";
    public static final String IN_EXTERNAL_ARCHIVE = "inExternalArchive";
    public static final String PROJECT_OPTION = "projectOption";

    public boolean test(Object receiver, String method, Object[] args, Object expectedValue) {
        return (Boolean)JavaCore.callReadOnly(() -> this.testCached(receiver, method, args, expectedValue));
    }

    private boolean testCached(Object receiver, String method, Object[] args, Object expectedValue) {
        if (!(receiver instanceof IJavaElement)) {
            return false;
        }
        IJavaElement res = (IJavaElement)receiver;
        switch (method) {
            case "name": {
                return Pattern.matches(this.toString(expectedValue), res.getElementName());
            }
            case "isInJavaProject": {
                IJavaProject javaProject = res.getJavaProject();
                return javaProject != null && javaProject.exists() && javaProject.getProject().isOpen();
            }
            case "isInJavaProjectWithNature": {
                IJavaProject javaProject = res.getJavaProject();
                if (javaProject != null && javaProject.exists() && javaProject.getProject().isOpen() && expectedValue != null) {
                    try {
                        return javaProject.getProject().hasNature(this.toString(expectedValue));
                    }
                    catch (CoreException e) {
                        return false;
                    }
                }
                return false;
            }
            case "isOnClasspath": {
                IJavaProject javaProject = res.getJavaProject();
                if (javaProject != null && javaProject.exists()) {
                    return javaProject.isOnClasspath(res);
                }
                return false;
            }
            case "inSourceFolder": {
                IJavaElement root = res.getAncestor(3);
                if (root != null) {
                    try {
                        return ((IPackageFragmentRoot)root).getKind() == 1;
                    }
                    catch (JavaModelException e) {
                        // empty catch block
                    }
                }
                return false;
            }
            case "inArchive": {
                IJavaElement root = res.getAncestor(3);
                if (root != null) {
                    return ((IPackageFragmentRoot)root).isArchive();
                }
                return false;
            }
            case "inExternalArchive": {
                IJavaElement root = res.getAncestor(3);
                if (root != null) {
                    return ((IPackageFragmentRoot)root).isExternal();
                }
                return false;
            }
            case "projectOption": {
                IJavaProject project = res.getJavaProject();
                if (project != null) {
                    if (args.length == 2) {
                        String current = project.getOption(this.toString(args[0]), true);
                        return current != null && current.equals(args[1]);
                    }
                    if (args.length == 1) {
                        return project.getOption(this.toString(args[0]), false) != null;
                    }
                }
                return false;
            }
            case "hasTypeOnClasspath": {
                IJavaProject javaProject = res.getJavaProject();
                if (javaProject == null || !javaProject.exists()) break;
                try {
                    return javaProject.findType(this.toString(expectedValue)) != null;
                }
                catch (JavaModelException e) {
                    return false;
                }
            }
        }
        return false;
    }

    private String toString(Object expectedValue) {
        return expectedValue == null ? "" : expectedValue.toString();
    }
}

