/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.serviceregistry;

import java.lang.reflect.Array;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.framework.util.CaseInsensitiveDictionaryMap;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.util.NLS;

class ServiceProperties
extends CaseInsensitiveDictionaryMap<String, Object> {
    ServiceProperties(Dictionary<String, ?> props) {
        this(props, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceProperties(Dictionary<String, ?> props, int extra) {
        super(ServiceProperties.initialCapacity(props == null ? extra : props.size() + extra));
        if (props == null) {
            return;
        }
        Dictionary<String, ?> dictionary = props;
        synchronized (dictionary) {
            Enumeration<String> keysEnum = props.keys();
            while (keysEnum.hasMoreElements()) {
                String header;
                Object value;
                String key = keysEnum.nextElement();
                if (!(key instanceof String) || (value = ServiceProperties.cloneValue(props.get(header = key))) == null || this.put(header, value) == null) continue;
                throw new IllegalArgumentException(NLS.bind(Msg.HEADER_DUPLICATE_KEY_EXCEPTION, key));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceProperties(Map<String, ?> props) {
        super(ServiceProperties.initialCapacity(props == null ? 0 : props.size()));
        if (props == null) {
            return;
        }
        Map<String, ?> map = props;
        synchronized (map) {
            for (Map.Entry<String, ?> e : props.entrySet()) {
                String header;
                Object value;
                String key = e.getKey();
                if (!(key instanceof String) || (value = ServiceProperties.cloneValue(props.get(header = key))) == null || this.put(header, value) == null) continue;
                throw new IllegalArgumentException(NLS.bind(Msg.HEADER_DUPLICATE_KEY_EXCEPTION, key));
            }
        }
    }

    static Object cloneValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return value;
        }
        if (value instanceof Number) {
            return value;
        }
        if (value instanceof Character) {
            return value;
        }
        if (value instanceof Boolean) {
            return value;
        }
        Class<?> clazz = value.getClass();
        if (clazz.isArray()) {
            Class<?> type = clazz.getComponentType();
            int len = Array.getLength(value);
            Object clonedArray = Array.newInstance(type, len);
            System.arraycopy(value, 0, clonedArray, 0, len);
            return clonedArray;
        }
        if (value instanceof Cloneable) {
            try {
                return clazz.getMethod("clone", null).invoke(value, null);
            }
            catch (Exception exception) {}
        }
        return value;
    }

    @Override
    public String toString() {
        Set keys = this.keySet();
        StringBuilder sb = new StringBuilder(20 * keys.size());
        sb.append('{');
        int n = 0;
        for (String key : keys) {
            if (key.equals("objectClass")) continue;
            if (n > 0) {
                sb.append(", ");
            }
            sb.append(key);
            sb.append('=');
            Object value = this.get(key);
            if (value.getClass().isArray()) {
                sb.append('[');
                int length = Array.getLength(value);
                int j = 0;
                while (j < length) {
                    if (j > 0) {
                        sb.append(',');
                    }
                    sb.append(Array.get(value, j));
                    ++j;
                }
                sb.append(']');
            } else {
                sb.append(value);
            }
            ++n;
        }
        sb.append('}');
        return sb.toString();
    }
}

