/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.AbstractScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.osgi.service.prefs.Preferences;

public final class ProjectScope
extends AbstractScope {
    public static final String SCOPE = "project";
    private final IProject project;

    public ProjectScope(IProject context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        this.project = context;
    }

    public IEclipsePreferences getNode(String qualifier) {
        if (qualifier == null) {
            throw new IllegalArgumentException();
        }
        IPreferencesService preferencesService = Platform.getPreferencesService();
        Preferences scopeNode = preferencesService.getRootNode().node(SCOPE);
        Preferences projectNode = scopeNode.node(this.project.getName());
        return (IEclipsePreferences)projectNode.node(qualifier);
    }

    public IPath getLocation() {
        IPath location = this.project.getLocation();
        return location == null ? null : location.append(".settings");
    }

    public String getName() {
        return SCOPE;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ProjectScope)) {
            return false;
        }
        ProjectScope other = (ProjectScope)((Object)obj);
        return this.project.equals(other.project);
    }

    public int hashCode() {
        return super.hashCode() * 31 + this.project.getFullPath().hashCode();
    }
}

