/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class VirtualFileStore
extends FileStore {
    private final URI location;

    public VirtualFileStore(URI location) {
        this.location = location;
    }

    @Override
    public String[] childNames(int options, IProgressMonitor monitor) {
        return FileStore.EMPTY_STRING_ARRAY;
    }

    @Override
    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) {
        FileInfo result = new FileInfo();
        result.setDirectory(true);
        result.setExists(true);
        result.setLastModified(1L);
        return result;
    }

    @Override
    public void delete(int options, IProgressMonitor monitor) {
    }

    @Override
    public IFileStore getChild(String name) {
        return EFS.getNullFileSystem().getStore(IPath.fromOSString(name).makeAbsolute());
    }

    @Override
    public String getName() {
        return "virtual";
    }

    @Override
    public IFileStore getParent() {
        return null;
    }

    @Override
    public void move(IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        destination.mkdir(0, monitor);
    }

    @Override
    public InputStream openInputStream(int options, IProgressMonitor monitor) {
        return null;
    }

    @Override
    public URI toURI() {
        return this.location;
    }
}

