/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist;

import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.runtime.ILog;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.internal.codeassist.DOMCompletionEngine;

final class DOMCompletionEngineRecoveredNodeScanner {
    private ICompilationUnit cu;
    private int offset;

    public DOMCompletionEngineRecoveredNodeScanner(ICompilationUnit cu, int offset) {
        this.cu = cu;
        this.offset = offset;
    }

    static Stream<IType> findTypes(String name, String qualifier, ICompilationUnit unit) {
        final ArrayList types = new ArrayList();
        IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope(new IJavaElement[]{unit.getJavaProject()});
        TypeNameMatchRequestor typeRequestor = new TypeNameMatchRequestor(){

            @Override
            public void acceptTypeNameMatch(TypeNameMatch match) {
                types.add(match.getType());
            }
        };
        try {
            new SearchEngine(unit.getOwner()).searchAllTypeNames(qualifier == null ? null : qualifier.toCharArray(), 0, name.toCharArray(), 0, 0, searchScope, typeRequestor, 3, null);
        }
        catch (JavaModelException ex) {
            ILog.get().error(ex.getMessage(), (Throwable)((Object)ex));
        }
        return types.stream();
    }

    public ITypeBinding findClosestSuitableBinding(ASTNode node, DOMCompletionEngine.Bindings scope) {
        ASTNode parent = node;
        SuitableNodeVisitor visitor = new SuitableNodeVisitor(scope, this.cu, this.offset);
        while (parent != null && this.withInOffset(parent)) {
            parent.accept(visitor);
            if (visitor.foundNode()) break;
            parent = parent.getParent();
        }
        return visitor.foundTypeBinding();
    }

    private boolean withInOffset(ASTNode node) {
        return node.getStartPosition() <= this.offset;
    }

    private class SuitableNodeVisitor
    extends ASTVisitor {
        private ITypeBinding foundBinding = null;
        private DOMCompletionEngine.Bindings scope;
        private ICompilationUnit cu;
        private int offset;

        public SuitableNodeVisitor(DOMCompletionEngine.Bindings scope, ICompilationUnit cu, int offset) {
            this.scope = scope;
            this.cu = cu;
            this.offset = offset;
        }

        public boolean foundNode() {
            return this.foundBinding != null;
        }

        @Override
        public boolean visit(MethodInvocation node) {
            this.foundBinding = node.resolveTypeBinding();
            if (this.foundBinding != null) {
                return false;
            }
            return super.visit(node);
        }

        @Override
        public boolean visit(FieldAccess node) {
            this.foundBinding = node.resolveTypeBinding();
            if (this.foundBinding != null) {
                return false;
            }
            return super.visit(node);
        }

        @Override
        public boolean visit(ExpressionStatement node) {
            this.foundBinding = node.getExpression().resolveTypeBinding();
            if (this.foundBinding != null) {
                return false;
            }
            return super.visit(node);
        }

        @Override
        public boolean visit(SimpleType node) {
            ITypeBinding binding = node.resolveBinding();
            if (binding == null) {
                return super.visit(node);
            }
            if (!binding.isRecovered()) {
                this.foundBinding = binding;
                return false;
            }
            String possibleVarName = binding.getName();
            Optional<ITypeBinding> result = this.scope.all().filter(IVariableBinding.class::isInstance).filter(b -> possibleVarName.equals(b.getName())).map(IVariableBinding.class::cast).map(v -> v.getType()).findFirst();
            if (result.isPresent()) {
                this.foundBinding = result.get();
                return false;
            }
            return super.visit(node);
        }

        @Override
        public boolean visit(QualifiedName node) {
            this.foundBinding = node.getQualifier().resolveTypeBinding();
            if (this.foundBinding != null) {
                return false;
            }
            return super.visit(node);
        }

        @Override
        public boolean visit(SimpleName node) {
            try {
                char charAt;
                if (this.offset > 0 && (charAt = this.cu.getSource().charAt(this.offset - 1)) == '.' && node.getStartPosition() + node.getLength() == this.offset - 1) {
                    String name = node.getIdentifier();
                    Optional<ITypeBinding> result = this.scope.all().filter(IVariableBinding.class::isInstance).filter(b -> name.equals(b.getName())).map(IVariableBinding.class::cast).map(v -> v.getType()).findFirst();
                    if (result.isPresent()) {
                        this.foundBinding = result.get();
                        return false;
                    }
                }
            }
            catch (JavaModelException ex) {
                ILog.get().error(ex.getMessage(), (Throwable)((Object)ex));
            }
            this.foundBinding = null;
            return false;
        }

        public ITypeBinding foundTypeBinding() {
            return this.foundBinding;
        }
    }
}

