/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.filesystem;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.ls.core.internal.filesystem.JDTLSFilesystemActivator;

public class JLSFsUtils {
    static final IPath METADATA_FOLDER_PATH = ResourcesPlugin.getPlugin().getStateLocation().append(".projects");
    static final String GENERATES_METADATA_FILES_AT_PROJECT_ROOT = "java.import.generatesMetadataFilesAtProjectRoot";
    static final String FACTORY_PATH = ".factorypath";
    static final Set<String> METADATA_NAMES = new HashSet<String>(Arrays.asList(".project", ".settings", ".classpath", ".factorypath"));

    private JLSFsUtils() {
    }

    static boolean shouldStoreInMetadataArea(IPath location) {
        if (JLSFsUtils.generatesMetadataFilesAtProjectRoot()) {
            return false;
        }
        if (!JLSFsUtils.isProjectMetadataFile(location)) {
            return false;
        }
        if (location.toFile().exists()) {
            return false;
        }
        if (location.lastSegment().endsWith("prefs")) {
            return !(location = location.removeLastSegments(1)).toFile().exists();
        }
        return true;
    }

    static boolean isProjectMetadataFile(IPath location) {
        if (location == null || location.segmentCount() < 2) {
            return false;
        }
        if (location.lastSegment().endsWith("prefs")) {
            location = location.removeLastSegments(1);
        }
        if (location.segmentCount() < 2) {
            return false;
        }
        return METADATA_NAMES.contains(location.lastSegment());
    }

    public static boolean isExcluded(IPath path) {
        if (path != null && JDTLSFilesystemActivator.getResourcePatterns() != null) {
            String[] stringArray = path.segments();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                for (Pattern pattern : JDTLSFilesystemActivator.getResourcePatterns()) {
                    Matcher m = pattern.matcher(segment);
                    if (!m.matches()) continue;
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return true;
    }

    static IPath getContainerPath(IPath filePath) {
        if (filePath.lastSegment().endsWith("prefs")) {
            filePath = filePath.removeLastSegments(1);
        }
        return filePath.removeLastSegments(1);
    }

    static String getProjectNameIfLocationIsProjectRoot(IPath location) {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects(8);
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            IPath projectLocation = project.getLocation();
            if (Objects.equals(projectLocation, location)) {
                return project.getName();
            }
            ++n2;
        }
        return null;
    }

    static IPath getMetaDataFilePath(String projectName, IPath path) {
        if (path.segmentCount() == 1) {
            return METADATA_FOLDER_PATH.append(projectName).append(path);
        }
        String lastSegment = path.lastSegment();
        if (METADATA_NAMES.contains(lastSegment)) {
            return METADATA_FOLDER_PATH.append(projectName).append(lastSegment);
        }
        if (lastSegment.endsWith("prefs")) {
            return METADATA_FOLDER_PATH.append(projectName).append(".settings").append(lastSegment);
        }
        return null;
    }

    public static boolean generatesMetadataFilesAtProjectRoot() {
        String property = System.getProperty(GENERATES_METADATA_FILES_AT_PROJECT_ROOT);
        if (property == null) {
            return true;
        }
        return Boolean.parseBoolean(property);
    }
}

