/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.internal.codeassist.CompletionEngine;
import org.eclipse.jdt.internal.codeassist.DOMCompletionContext;
import org.eclipse.jdt.internal.codeassist.DOMCompletionEngineBuilder;
import org.eclipse.jdt.internal.codeassist.DOMCompletionEngineMethodDeclHandler;
import org.eclipse.jdt.internal.codeassist.DOMCompletionEngineRecoveredNodeScanner;
import org.eclipse.jdt.internal.codeassist.DOMCompletionEngineVariableDeclHandler;
import org.eclipse.jdt.internal.codeassist.ExpectedTypes;
import org.eclipse.jdt.internal.codeassist.InternalCompletionProposal;
import org.eclipse.jdt.internal.codeassist.impl.AssistOptions;
import org.eclipse.jdt.internal.codeassist.impl.Keywords;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.RecoveryScanner;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaElementRequestor;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.ModuleSourcePathManager;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.core.util.Messages;

public class DOMCompletionEngine
implements Runnable {
    private static final String FAKE_IDENTIFIER = new String(RecoveryScanner.FAKE_IDENTIFIER);
    private final int offset;
    private final CompilationUnit unit;
    private final CompletionRequestor requestor;
    private final ICompilationUnit modelUnit;
    private final SearchableEnvironment nameEnvironment;
    private final AssistOptions assistOptions;
    private final SearchPattern pattern;
    private final CompletionEngine nestedEngine;
    private ExpectedTypes expectedTypes;
    private String prefix;
    private String qualifiedPrefix;
    private ASTNode toComplete;
    private final DOMCompletionEngineVariableDeclHandler variableDeclHandler;
    private final DOMCompletionEngineRecoveredNodeScanner recoveredNodeScanner;
    private final IProgressMonitor monitor;

    public DOMCompletionEngine(int offset, CompilationUnit domUnit, ICompilationUnit modelUnit, WorkingCopyOwner workingCopyOwner, CompletionRequestor requestor, IProgressMonitor monitor) {
        this.offset = offset;
        this.unit = domUnit;
        this.modelUnit = modelUnit;
        this.requestor = requestor;
        SearchableEnvironment env = null;
        IJavaProject iJavaProject = this.modelUnit.getJavaProject();
        if (iJavaProject instanceof JavaProject) {
            JavaProject p = (JavaProject)iJavaProject;
            try {
                env = p.newSearchableNameEnvironment(workingCopyOwner, requestor.isTestCodeExcluded());
            }
            catch (JavaModelException e) {
                ILog.get().error(e.getMessage(), (Throwable)((Object)e));
            }
        }
        this.nameEnvironment = env;
        this.assistOptions = new AssistOptions(this.modelUnit.getOptions(true));
        this.pattern = new SearchPattern(1 | (this.assistOptions.camelCaseMatch ? 128 : 0) | (this.assistOptions.substringMatch ? 512 : 0) | (this.assistOptions.subwordMatch ? 1024 : 0)){

            @Override
            public SearchPattern getBlankPattern() {
                return null;
            }
        };
        this.nestedEngine = new CompletionEngine(this.nameEnvironment, this.requestor, this.modelUnit.getOptions(true), this.modelUnit.getJavaProject(), workingCopyOwner, monitor);
        this.variableDeclHandler = new DOMCompletionEngineVariableDeclHandler();
        this.recoveredNodeScanner = new DOMCompletionEngineRecoveredNodeScanner(modelUnit, offset);
        this.monitor = monitor;
    }

    private Collection<? extends IBinding> visibleBindings(ASTNode node) {
        ArrayList<IVariableBinding> visibleBindings = new ArrayList<IVariableBinding>();
        if (node instanceof MethodDeclaration) {
            MethodDeclaration m = (MethodDeclaration)node;
            visibleBindings.addAll(m.parameters().stream().map(VariableDeclaration::resolveBinding).toList());
        }
        if (node instanceof LambdaExpression) {
            LambdaExpression le = (LambdaExpression)node;
            visibleBindings.addAll(le.parameters().stream().map(VariableDeclaration::resolveBinding).toList());
        }
        if (node instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration typeDecl = (AbstractTypeDeclaration)node;
            visibleBindings.addAll(typeDecl.bodyDeclarations().stream().flatMap(bodyDecl -> {
                if (bodyDecl instanceof FieldDeclaration) {
                    FieldDeclaration fieldDecl = (FieldDeclaration)bodyDecl;
                    return fieldDecl.fragments().stream().map(fragment -> fragment.resolveBinding());
                }
                if (bodyDecl instanceof MethodDeclaration) {
                    MethodDeclaration methodDecl = (MethodDeclaration)bodyDecl;
                    return Stream.of(methodDecl.resolveBinding());
                }
                return Stream.of(new Object[0]);
            }).toList());
        }
        if (node instanceof Block) {
            Block block = (Block)node;
            List<IVariableBinding> bindings = block.statements().stream().filter(statement -> statement.getStartPosition() < this.offset).filter(VariableDeclarationStatement.class::isInstance).map(VariableDeclarationStatement.class::cast).flatMap(decl -> decl.fragments().stream()).map(VariableDeclaration::resolveBinding).toList();
            visibleBindings.addAll(bindings);
        }
        return visibleBindings;
    }

    private Collection<? extends ITypeBinding> visibleTypeBindings(ASTNode node) {
        ArrayList<? extends ITypeBinding> visibleBindings = new ArrayList<ITypeBinding>();
        if (node instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration typeDeclaration = (AbstractTypeDeclaration)node;
            visibleBindings.add(typeDeclaration.resolveBinding());
            for (ASTNode bodyDeclaration : typeDeclaration.bodyDeclarations()) {
                visibleBindings.addAll(this.visibleTypeBindings(bodyDeclaration));
            }
        }
        if (node instanceof Block) {
            Block block = (Block)node;
            List<ITypeBinding> bindings = block.statements().stream().filter(statement -> statement.getStartPosition() < this.offset).filter(TypeDeclaration.class::isInstance).map(TypeDeclaration.class::cast).map(AbstractTypeDeclaration::resolveBinding).toList();
            visibleBindings.addAll(bindings);
        }
        return visibleBindings;
    }

    private IJavaElement computeEnclosingElement() {
        block3: {
            try {
                if (this.modelUnit != null) break block3;
                return null;
            }
            catch (JavaModelException e) {
                ILog.get().error(e.getMessage(), (Throwable)((Object)e));
                return null;
            }
        }
        IJavaElement enclosingElement = this.modelUnit.getElementAt(this.offset);
        return enclosingElement == null ? this.modelUnit : enclosingElement;
    }

    @Override
    public void run() {
        if (this.monitor != null) {
            this.monitor.beginTask(Messages.engine_completing, -1);
        }
        this.requestor.beginReporting();
        try {
            MethodInvocation invocation;
            ASTNode aSTNode;
            Object object;
            ASTNode aSTNode2;
            ASTNode aSTNode3;
            this.toComplete = NodeFinder.perform(this.unit, this.offset, 0);
            this.expectedTypes = new ExpectedTypes(this.assistOptions, this.toComplete);
            ASTNode context = this.toComplete;
            String completeAfter = "";
            ASTNode aSTNode4 = this.toComplete;
            if (aSTNode4 instanceof SimpleName) {
                SimpleName simpleName = (SimpleName)aSTNode4;
                int charCount = this.offset - simpleName.getStartPosition();
                if (!FAKE_IDENTIFIER.equals(simpleName.getIdentifier())) {
                    completeAfter = simpleName.getIdentifier().substring(0, charCount);
                }
                if (simpleName.getParent() instanceof FieldAccess || simpleName.getParent() instanceof MethodInvocation || simpleName.getParent() instanceof VariableDeclaration || simpleName.getParent() instanceof QualifiedName || simpleName.getParent() instanceof SuperFieldAccess) {
                    context = this.toComplete.getParent();
                }
            } else {
                ASTNode aSTNode5 = this.toComplete;
                if (aSTNode5 instanceof SimpleType) {
                    SimpleType simpleType = (SimpleType)aSTNode5;
                    if (FAKE_IDENTIFIER.equals(simpleType.getName().toString())) {
                        context = this.toComplete.getParent();
                    } else {
                        var8_8 = simpleType.getName();
                        if (var8_8 instanceof QualifiedName) {
                            QualifiedName qualifiedName = (QualifiedName)var8_8;
                            context = qualifiedName;
                        }
                    }
                } else {
                    Block block;
                    var8_8 = this.toComplete;
                    if (var8_8 instanceof Block && this.offset == (block = (Block)var8_8).getStartPosition()) {
                        context = this.toComplete.getParent();
                    }
                }
            }
            this.qualifiedPrefix = this.prefix = completeAfter;
            ASTNode aSTNode6 = this.toComplete;
            if (aSTNode6 instanceof QualifiedName) {
                QualifiedName qualifiedName = (QualifiedName)aSTNode6;
                this.qualifiedPrefix = qualifiedName.getQualifier().toString();
            } else if (this.toComplete != null && (aSTNode3 = this.toComplete.getParent()) instanceof QualifiedName) {
                QualifiedName qualifiedName = (QualifiedName)aSTNode3;
                this.qualifiedPrefix = qualifiedName.getQualifier().toString();
            } else {
                SimpleType simpleType;
                Name name2;
                ASTNode aSTNode7 = this.toComplete;
                if (aSTNode7 instanceof SimpleType && (name2 = (simpleType = (SimpleType)aSTNode7).getName()) instanceof QualifiedName) {
                    QualifiedName qualifiedName = (QualifiedName)name2;
                    this.qualifiedPrefix = qualifiedName.getQualifier().toString();
                }
            }
            Bindings defaultCompletionBindings = new Bindings();
            Bindings specificCompletionBindings = new Bindings();
            DOMCompletionContext completionContext = new DOMCompletionContext(this.offset, completeAfter.toCharArray(), this.computeEnclosingElement(), defaultCompletionBindings::stream);
            this.requestor.acceptContext(completionContext);
            boolean suggestDefaultCompletions = true;
            this.checkCancelled();
            if (context instanceof FieldAccess) {
                FieldAccess parentFieldAccess;
                FieldAccess fieldAccess = (FieldAccess)context;
                this.statementLikeKeywords();
                ITypeBinding fieldAccessType = fieldAccess.getExpression().resolveTypeBinding();
                if (fieldAccessType != null) {
                    this.processMembers(fieldAccess, fieldAccess.getExpression().resolveTypeBinding(), specificCompletionBindings, false);
                }
                if (specificCompletionBindings.stream().findAny().isPresent()) {
                    specificCompletionBindings.stream().filter(binding -> this.pattern.matchesName(this.prefix.toCharArray(), binding.getName().toCharArray())).map(binding -> this.toProposal((IBinding)binding)).forEach(this.requestor::accept);
                    this.requestor.endReporting();
                    return;
                }
                String packageName = "";
                aSTNode2 = fieldAccess.getExpression();
                if (aSTNode2 instanceof FieldAccess && (object = (parentFieldAccess = (FieldAccess)aSTNode2).getName().resolveBinding()) instanceof IPackageBinding) {
                    IPackageBinding packageBinding = (IPackageBinding)object;
                    packageName = packageBinding.getName();
                } else {
                    SimpleName name3;
                    IBinding iBinding;
                    aSTNode = fieldAccess.getExpression();
                    if (aSTNode instanceof SimpleName && (iBinding = (name3 = (SimpleName)aSTNode).resolveBinding()) instanceof IPackageBinding) {
                        IPackageBinding packageBinding = (IPackageBinding)iBinding;
                        packageName = packageBinding.getName();
                    }
                }
                this.suggestPackages();
                this.suggestTypesInPackage(packageName);
                suggestDefaultCompletions = false;
            }
            if (context instanceof MethodInvocation && this.offset <= (invocation = (MethodInvocation)context).getName().getStartPosition() + invocation.getName().getLength()) {
                Expression expression = invocation.getExpression();
                if (expression == null) {
                    return;
                }
                ITypeBinding type2 = expression.resolveTypeBinding();
                if (type2 != null) {
                    this.processMembers(expression, type2, specificCompletionBindings, false);
                    specificCompletionBindings.stream().filter(binding -> this.pattern.matchesName(this.prefix.toCharArray(), binding.getName().toCharArray())).filter(IMethodBinding.class::isInstance).map(binding -> this.toProposal((IBinding)binding)).forEach(this.requestor::accept);
                }
                suggestDefaultCompletions = false;
            }
            if (context instanceof VariableDeclaration) {
                VariableDeclaration declaration = (VariableDeclaration)context;
                IVariableBinding binding2 = declaration.resolveBinding();
                if (binding2 != null) {
                    this.variableDeclHandler.findVariableNames(binding2, completeAfter, specificCompletionBindings).stream().map(name -> this.toProposal(binding2, (String)name)).forEach(this.requestor::accept);
                }
                suggestDefaultCompletions = false;
            }
            if (context instanceof ModuleDeclaration) {
                ModuleDeclaration mod = (ModuleDeclaration)context;
                this.findModules(this.prefix.toCharArray(), this.modelUnit.getJavaProject(), this.assistOptions, Set.of(mod.getName().toString()));
            }
            if (context instanceof SimpleName) {
                FieldDeclaration fieldDeclaration;
                SimpleType simpleType;
                aSTNode2 = context.getParent();
                if (aSTNode2 instanceof SimpleType && (object = (simpleType = (SimpleType)aSTNode2).getParent()) instanceof FieldDeclaration && (aSTNode = (fieldDeclaration = (FieldDeclaration)object).getParent()) instanceof AbstractTypeDeclaration) {
                    AbstractTypeDeclaration typeDecl = (AbstractTypeDeclaration)aSTNode;
                    ITypeBinding typeDeclBinding = typeDecl.resolveBinding();
                    this.findOverridableMethods(typeDeclBinding, this.modelUnit.getJavaProject(), context);
                    suggestDefaultCompletions = false;
                }
                if (context.getParent() instanceof MarkerAnnotation) {
                    this.completeMarkerAnnotation(completeAfter);
                    suggestDefaultCompletions = false;
                }
                if (context.getParent() instanceof MemberValuePair) {
                    suggestDefaultCompletions = false;
                }
                if (context.getParent() instanceof MethodDeclaration) {
                    suggestDefaultCompletions = false;
                }
            }
            if (context instanceof AbstractTypeDeclaration) {
                AbstractTypeDeclaration typeDecl = (AbstractTypeDeclaration)context;
                ITypeBinding typeDeclBinding = typeDecl.resolveBinding();
                this.findOverridableMethods(typeDeclBinding, this.modelUnit.getJavaProject(), null);
                suggestDefaultCompletions = false;
            }
            if (context instanceof QualifiedName) {
                ITypeBinding qualifierTypeBinding;
                QualifiedName qualifiedName = (QualifiedName)context;
                IBinding qualifiedNameBinding = qualifiedName.getQualifier().resolveBinding();
                if (qualifiedNameBinding instanceof ITypeBinding && !(qualifierTypeBinding = (ITypeBinding)qualifiedNameBinding).isRecovered()) {
                    this.processMembers(qualifiedName, qualifierTypeBinding, specificCompletionBindings, true);
                    this.publishFromScope(specificCompletionBindings);
                    int startPos = this.offset;
                    int endPos = this.offset;
                    if ((qualifiedName.getName().getFlags() & 1) != 0) {
                        startPos = qualifiedName.getName().getStartPosition();
                        endPos = startPos + qualifiedName.getName().getLength();
                    }
                    if (!this.isFailedMatch(this.toComplete.toString().toCharArray(), Keywords.THIS)) {
                        this.requestor.accept(this.createKeywordProposal(Keywords.THIS, startPos, endPos));
                    }
                    if (!this.isFailedMatch(this.toComplete.toString().toCharArray(), Keywords.SUPER)) {
                        this.requestor.accept(this.createKeywordProposal(Keywords.SUPER, startPos, endPos));
                    }
                    if (!this.isFailedMatch(this.toComplete.toString().toCharArray(), Keywords.CLASS)) {
                        this.requestor.accept(this.createClassKeywordProposal(qualifierTypeBinding, startPos, endPos));
                    }
                    suggestDefaultCompletions = false;
                } else if (qualifiedNameBinding instanceof IPackageBinding) {
                    IPackageBinding qualifierPackageBinding = (IPackageBinding)qualifiedNameBinding;
                    if (!qualifierPackageBinding.isRecovered()) {
                        this.suggestPackages();
                        this.suggestTypesInPackage(qualifierPackageBinding.getName());
                        suggestDefaultCompletions = false;
                    } else {
                        Bindings tempScope = new Bindings();
                        this.scrapeAccessibleBindings(tempScope);
                        Optional<ITypeBinding> potentialBinding = tempScope.stream().filter(binding -> {
                            IJavaElement elt = binding.getJavaElement();
                            if (elt == null) {
                                return false;
                            }
                            return elt.getElementName().equals(qualifiedName.getQualifier().toString());
                        }).map(binding -> {
                            if (binding instanceof IVariableBinding) {
                                IVariableBinding variableBinding = (IVariableBinding)binding;
                                return variableBinding.getType();
                            }
                            if (binding instanceof ITypeBinding) {
                                ITypeBinding typeBinding = (ITypeBinding)binding;
                                return typeBinding;
                            }
                            throw new IllegalStateException("method, type var, etc. are likely not interpreted as a package");
                        }).map(ITypeBinding.class::cast).findFirst();
                        if (potentialBinding.isPresent()) {
                            this.processMembers(qualifiedName, potentialBinding.get(), specificCompletionBindings, false);
                            this.publishFromScope(specificCompletionBindings);
                            suggestDefaultCompletions = false;
                        } else {
                            this.suggestPackages();
                            this.suggestTypesInPackage(qualifierPackageBinding.getName());
                            suggestDefaultCompletions = false;
                        }
                    }
                } else if (qualifiedNameBinding instanceof IVariableBinding) {
                    IVariableBinding variableBinding = (IVariableBinding)qualifiedNameBinding;
                    ITypeBinding typeBinding = variableBinding.getType();
                    this.processMembers(qualifiedName, typeBinding, specificCompletionBindings, false);
                    this.publishFromScope(specificCompletionBindings);
                    suggestDefaultCompletions = false;
                }
            }
            if (context instanceof SuperFieldAccess) {
                SuperFieldAccess superFieldAccess = (SuperFieldAccess)context;
                ITypeBinding superTypeBinding = superFieldAccess.resolveTypeBinding();
                this.processMembers(superFieldAccess, superTypeBinding, specificCompletionBindings, false);
                this.publishFromScope(specificCompletionBindings);
                suggestDefaultCompletions = false;
            }
            if (context instanceof MarkerAnnotation) {
                this.completeMarkerAnnotation(completeAfter);
                suggestDefaultCompletions = false;
            }
            if (context instanceof NormalAnnotation) {
                NormalAnnotation normalAnnotation = (NormalAnnotation)context;
                this.completeNormalAnnotationParams(normalAnnotation, specificCompletionBindings);
                suggestDefaultCompletions = false;
            }
            if (context instanceof MethodDeclaration) {
                MethodDeclaration methodDeclaration = (MethodDeclaration)context;
                if (this.offset < methodDeclaration.getName().getStartPosition()) {
                    this.completeMethodModifiers(methodDeclaration);
                    if (methodDeclaration.getReturnType2() == null) {
                        ASTNode current = this.toComplete;
                        while (current != null) {
                            specificCompletionBindings.addAll(this.visibleTypeBindings(current));
                            current = current.getParent();
                        }
                        this.publishFromScope(specificCompletionBindings);
                    }
                    suggestDefaultCompletions = false;
                } else if (methodDeclaration.getBody() != null && this.offset <= methodDeclaration.getBody().getStartPosition()) {
                    this.completeThrowsClause(methodDeclaration, specificCompletionBindings);
                    suggestDefaultCompletions = false;
                }
            }
            this.scrapeAccessibleBindings(defaultCompletionBindings);
            if (suggestDefaultCompletions) {
                this.statementLikeKeywords();
                this.publishFromScope(defaultCompletionBindings);
                if (!completeAfter.isBlank()) {
                    int typeMatchRule = this.toComplete.getParent() instanceof Annotation ? 8 : 0;
                    ExtendsOrImplementsInfo extendsOrImplementsInfo = DOMCompletionEngine.isInExtendsOrImplements(this.toComplete);
                    this.findTypes(completeAfter, typeMatchRule, null).filter(type -> this.pattern.matchesName(this.prefix.toCharArray(), type.getElementName().toCharArray())).filter(type -> this.filterBasedOnExtendsOrImplementsInfo((IType)type, extendsOrImplementsInfo)).map(this::toProposal).forEach(this.requestor::accept);
                }
                this.checkCancelled();
                this.suggestPackages();
            }
            this.checkCancelled();
        }
        finally {
            this.requestor.endReporting();
            if (this.monitor != null) {
                this.monitor.done();
            }
        }
    }

    private void scrapeAccessibleBindings(Bindings scope) {
        ASTNode current = this.toComplete;
        while (current != null) {
            Collection<? extends IBinding> gottenVisibleBindings = this.visibleBindings(current);
            scope.addAll(gottenVisibleBindings);
            if (current instanceof NormalAnnotation) {
                NormalAnnotation normalAnnotation = (NormalAnnotation)current;
                this.completeNormalAnnotationParams(normalAnnotation, scope);
                break;
            }
            if (current instanceof AbstractTypeDeclaration) {
                AbstractTypeDeclaration typeDecl = (AbstractTypeDeclaration)current;
                this.processMembers(this.toComplete, typeDecl.resolveBinding(), scope, false);
            }
            current = current.getParent();
        }
    }

    private void completeMethodModifiers(MethodDeclaration methodDeclaration) {
        ArrayList<char[]> keywords = new ArrayList<char[]>();
        if ((methodDeclaration.getModifiers() & 0x400) == 0) {
            keywords.add(Keywords.ABSTRACT);
        }
        if ((methodDeclaration.getModifiers() & 7) == 0) {
            keywords.add(Keywords.PUBLIC);
            keywords.add(Keywords.PRIVATE);
            keywords.add(Keywords.PROTECTED);
        }
        if ((methodDeclaration.getModifiers() & 0x10000) == 0) {
            keywords.add(Keywords.DEFAULT);
        }
        if ((methodDeclaration.getModifiers() & 0x10) == 0) {
            keywords.add(Keywords.FINAL);
        }
        if ((methodDeclaration.getModifiers() & 0x100) == 0) {
            keywords.add(Keywords.NATIVE);
        }
        if ((methodDeclaration.getModifiers() & 0x800) == 0) {
            keywords.add(Keywords.STRICTFP);
        }
        if ((methodDeclaration.getModifiers() & 0x20) == 0) {
            keywords.add(Keywords.SYNCHRONIZED);
        }
        for (char[] keyword : keywords) {
            if (this.isFailedMatch(this.prefix.toCharArray(), keyword)) continue;
            this.requestor.accept(this.createKeywordProposal(keyword, this.offset, this.offset));
        }
    }

    private void checkCancelled() {
        if (this.monitor != null && this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void statementLikeKeywords() {
        ASTNode prevStatement;
        Block block;
        int exprIndex;
        ASTNode statementParent;
        ExpressionStatement exprStatement;
        ArrayList<char[]> keywords = new ArrayList<char[]>();
        keywords.add(Keywords.ASSERT);
        keywords.add(Keywords.RETURN);
        keywords.add(Keywords.SUPER);
        if (DOMCompletionEngine.findParent(this.toComplete, new int[]{61, 19, 24}) != null) {
            keywords.add(Keywords.BREAK);
            keywords.add(Keywords.CONTINUE);
        }
        if ((exprStatement = (ExpressionStatement)DOMCompletionEngine.findParent(this.toComplete, new int[]{21})) != null && (statementParent = exprStatement.getParent()) instanceof Block && (exprIndex = (block = (Block)statementParent).statements().indexOf(exprStatement)) > 0 && (prevStatement = (ASTNode)block.statements().get(exprIndex - 1)).getNodeType() == 25) {
            keywords.add(Keywords.ELSE);
        }
        for (char[] keyword : keywords) {
            if (this.isFailedMatch(this.toComplete.toString().toCharArray(), keyword)) continue;
            this.requestor.accept(this.createKeywordProposal(keyword, this.toComplete.getStartPosition(), this.offset));
        }
    }

    private void completeThrowsClause(MethodDeclaration methodDeclaration, Bindings scope) {
        if (methodDeclaration.thrownExceptionTypes().size() == 0 && !this.isFailedMatch(this.prefix.toCharArray(), Keywords.THROWS)) {
            this.requestor.accept(this.createKeywordProposal(Keywords.THROWS, this.offset, this.offset));
        }
        ASTNode current = this.toComplete;
        while (current != null) {
            scope.addAll(this.visibleTypeBindings(current));
            current = current.getParent();
        }
        this.publishFromScope(scope);
    }

    private void suggestPackages() {
        try {
            if (this.requestor.isIgnored(8)) {
                return;
            }
            if (this.prefix.isEmpty() && this.qualifiedPrefix.isEmpty()) {
                return;
            }
            Arrays.stream(this.modelUnit.getJavaProject().getPackageFragments()).map(IPackageFragment::getElementName).distinct().filter(name -> !name.isBlank()).filter(name -> CharOperation.prefixEquals((char[])(this.qualifiedPrefix + ".").toCharArray(), (char[])name.toCharArray()) && name.length() > this.qualifiedPrefix.length()).filter(name -> this.pattern.matchesName(this.prefix.toCharArray(), name.toCharArray())).map(pack -> this.toPackageProposal((String)pack, this.toComplete)).forEach(this.requestor::accept);
        }
        catch (JavaModelException ex) {
            ILog.get().error(ex.getMessage(), (Throwable)((Object)ex));
        }
    }

    private void suggestTypesInPackage(String packageName) {
        if (!this.requestor.isIgnored(9)) {
            List<IType> foundTypes = this.findTypes(this.prefix, packageName).toList();
            ExtendsOrImplementsInfo extendsOrImplementsInfo = DOMCompletionEngine.isInExtendsOrImplements(this.toComplete);
            for (IType foundType : foundTypes) {
                if (!this.pattern.matchesName(this.prefix.toCharArray(), foundType.getElementName().toCharArray()) || !this.filterBasedOnExtendsOrImplementsInfo(foundType, extendsOrImplementsInfo)) continue;
                this.requestor.accept(this.toProposal(foundType));
            }
        }
    }

    private boolean filterBasedOnExtendsOrImplementsInfo(IType toFilter, ExtendsOrImplementsInfo info) {
        TypeDeclaration typeDeclaration;
        block7: {
            block6: {
                if (info == null) {
                    return true;
                }
                try {
                    if (info.typeDecl instanceof TypeDeclaration) {
                        typeDeclaration = (TypeDeclaration)info.typeDecl;
                        if ((toFilter.getFlags() & 0x10) == 0 && !typeDeclaration.resolveBinding().getKey().equals(toFilter.getKey())) break block6;
                    }
                    return false;
                }
                catch (JavaModelException e) {
                    return true;
                }
            }
            if (!typeDeclaration.isInterface() || !toFilter.isInterface() || DOMCompletionEngine.extendsOrImplementsGivenType(typeDeclaration, toFilter)) break block7;
            return true;
        }
        return !typeDeclaration.isInterface() && info.isImplements == toFilter.isInterface() && !DOMCompletionEngine.extendsOrImplementsGivenType(typeDeclaration, toFilter);
    }

    private static ExtendsOrImplementsInfo isInExtendsOrImplements(ASTNode completion) {
        ASTNode cursor = completion;
        while (cursor != null && cursor.getNodeType() != 55 && cursor.getNodeType() != 71 && cursor.getNodeType() != 103 && cursor.getNodeType() != 81) {
            StructuralPropertyDescriptor locationInParent = cursor.getLocationInParent();
            if (locationInParent == null) {
                return null;
            }
            if (locationInParent.isChildListProperty()) {
                locationId = locationInParent.getId();
                if (TypeDeclaration.SUPER_INTERFACE_TYPES_PROPERTY.getId().equals(locationId) || EnumDeclaration.SUPER_INTERFACE_TYPES_PROPERTY.getId().equals(locationId) || RecordDeclaration.SUPER_INTERFACE_TYPES_PROPERTY.getId().equals(locationId)) {
                    return new ExtendsOrImplementsInfo((AbstractTypeDeclaration)cursor.getParent(), true);
                }
            } else if (locationInParent.isChildProperty()) {
                locationId = locationInParent.getId();
                if (TypeDeclaration.SUPERCLASS_TYPE_PROPERTY.getId().equals(locationId)) {
                    return new ExtendsOrImplementsInfo((AbstractTypeDeclaration)cursor.getParent(), false);
                }
            }
            cursor = cursor.getParent();
        }
        return null;
    }

    private static boolean extendsOrImplementsGivenType(TypeDeclaration typeDecl, IType typeRef) {
        String refKey = typeRef.getKey();
        if (typeDecl.getSuperclassType() != null && typeDecl.getSuperclassType().resolveBinding() != null && refKey.equals(typeDecl.getSuperclassType().resolveBinding().getKey())) {
            return true;
        }
        for (Object superInterface : typeDecl.superInterfaceTypes()) {
            ITypeBinding superInterfaceBinding = ((Type)superInterface).resolveBinding();
            if (superInterfaceBinding == null || !refKey.equals(superInterfaceBinding.getKey())) continue;
            return true;
        }
        return false;
    }

    private static ASTNode findParent(ASTNode nodeToSearch, int[] kindsToFind) {
        ASTNode cursor = nodeToSearch;
        while (cursor != null) {
            int[] nArray = kindsToFind;
            int n = kindsToFind.length;
            int n2 = 0;
            while (n2 < n) {
                int kindToFind = nArray[n2];
                if (cursor.getNodeType() == kindToFind) {
                    return cursor;
                }
                ++n2;
            }
            cursor = cursor.getParent();
        }
        return null;
    }

    private void completeMarkerAnnotation(String completeAfter) {
        this.findTypes(completeAfter, 8, null).filter(type -> this.pattern.matchesName(this.prefix.toCharArray(), type.getElementName().toCharArray())).map(this::toProposal).forEach(this.requestor::accept);
    }

    private void completeNormalAnnotationParams(NormalAnnotation normalAnnotation, Bindings scope) {
        Set definedKeys = normalAnnotation.values().stream().map(mvp -> mvp.getName().toString()).collect(Collectors.toSet());
        Arrays.stream(normalAnnotation.resolveTypeBinding().getDeclaredMethods()).filter(declaredMethod -> (declaredMethod.getModifiers() & 8) == 0 && !definedKeys.contains(declaredMethod.getName().toString())).forEach(scope::add);
        this.publishFromScope(scope);
    }

    private void publishFromScope(Bindings scope) {
        scope.stream().filter(binding -> this.pattern.matchesName(this.prefix.toCharArray(), binding.getName().toCharArray())).map(binding -> this.toProposal((IBinding)binding)).forEach(this.requestor::accept);
    }

    private void findOverridableMethods(ITypeBinding typeBinding, IJavaProject javaProject, ASTNode toReplace) {
        String originalPackageKey = typeBinding.getPackage().getKey();
        HashSet<String> alreadySuggestedMethodKeys = new HashSet<String>();
        if (typeBinding.getSuperclass() != null) {
            this.findOverridableMethods0(typeBinding.getSuperclass(), alreadySuggestedMethodKeys, javaProject, originalPackageKey, toReplace);
        }
        ITypeBinding[] iTypeBindingArray = typeBinding.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding superInterface = iTypeBindingArray[n2];
            this.findOverridableMethods0(superInterface, alreadySuggestedMethodKeys, javaProject, originalPackageKey, toReplace);
            ++n2;
        }
    }

    private void findOverridableMethods0(ITypeBinding typeBinding, Set<String> alreadySuggestedKeys, IJavaProject javaProject, String originalPackageKey, ASTNode toReplace) {
        IBinding[] iBindingArray = typeBinding.getDeclaredMethods();
        int n2 = iBindingArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IMethodBinding method = iBindingArray[n3];
            if (!(alreadySuggestedKeys.contains(method.getKey()) || method.isSynthetic() || method.isConstructor() || this.assistOptions.checkDeprecation && method.isDeprecated() || (method.getModifiers() & 8) != 0 || (method.getModifiers() & 2) != 0 || (method.getModifiers() & 7) == 0 && !typeBinding.getPackage().getKey().equals(originalPackageKey))) {
                alreadySuggestedKeys.add(method.getKey());
                if ((method.getModifiers() & 0x10) == 0 && !this.isFailedMatch(this.prefix.toCharArray(), method.getName().toCharArray())) {
                    InternalCompletionProposal proposal = this.createProposal(7);
                    proposal.setReplaceRange(this.offset, this.offset);
                    if (toReplace != null) {
                        proposal.setReplaceRange(toReplace.getStartPosition(), toReplace.getStartPosition() + toReplace.getLength());
                    }
                    proposal.setName(method.getName().toCharArray());
                    proposal.setFlags(method.getModifiers());
                    proposal.setTypeName(method.getReturnType().getName().toCharArray());
                    proposal.setDeclarationPackageName(typeBinding.getPackage().getName().toCharArray());
                    proposal.setDeclarationTypeName(typeBinding.getQualifiedName().toCharArray());
                    proposal.setDeclarationSignature(DOMCompletionEngineBuilder.getSignature(method.getDeclaringClass()));
                    proposal.setKey(method.getKey().toCharArray());
                    proposal.setSignature(DOMCompletionEngineBuilder.getSignature(method));
                    proposal.setParameterNames((char[][])Stream.of(method.getParameterNames()).map(name -> name.toCharArray()).toArray(n -> new char[n][]));
                    int relevance = 39 + ((method.getModifiers() & 0x400) != 0 ? 20 : 0) + 3;
                    proposal.setRelevance(relevance);
                    StringBuilder completion = new StringBuilder();
                    DOMCompletionEngineBuilder.createMethod(method, completion);
                    proposal.setCompletion(completion.toString().toCharArray());
                    this.requestor.accept(proposal);
                }
            }
            ++n3;
        }
        if (typeBinding.getSuperclass() != null) {
            this.findOverridableMethods0(typeBinding.getSuperclass(), alreadySuggestedKeys, javaProject, originalPackageKey, toReplace);
        }
        iBindingArray = typeBinding.getInterfaces();
        n2 = iBindingArray.length;
        n3 = 0;
        while (n3 < n2) {
            IBinding superInterface = iBindingArray[n3];
            this.findOverridableMethods0((ITypeBinding)superInterface, alreadySuggestedKeys, javaProject, originalPackageKey, toReplace);
            ++n3;
        }
    }

    private Stream<IType> findTypes(String namePrefix, String packageName) {
        return this.findTypes(namePrefix, 0, packageName);
    }

    private Stream<IType> findTypes(String namePrefix, int typeMatchRule, String packageName) {
        if (namePrefix == null) {
            namePrefix = "";
        }
        final ArrayList types = new ArrayList();
        IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope(new IJavaElement[]{this.modelUnit.getJavaProject()});
        TypeNameMatchRequestor typeRequestor = new TypeNameMatchRequestor(){

            @Override
            public void acceptTypeNameMatch(TypeNameMatch match) {
                types.add(match.getType());
            }
        };
        try {
            new SearchEngine(this.modelUnit.getOwner()).searchAllTypeNames(packageName == null ? null : packageName.toCharArray(), 0, namePrefix.toCharArray(), 1 | (this.assistOptions.substringMatch ? 512 : 0) | (this.assistOptions.subwordMatch ? 1024 : 0), typeMatchRule, searchScope, typeRequestor, 3, null);
        }
        catch (JavaModelException ex) {
            ILog.get().error(ex.getMessage(), (Throwable)((Object)ex));
        }
        return types.stream();
    }

    private void processMembers(ASTNode referencedFrom, ITypeBinding typeBinding, Bindings scope, boolean isStaticContext) {
        AbstractTypeDeclaration parentType = (AbstractTypeDeclaration)DOMCompletionEngine.findParent(referencedFrom, new int[]{81, 55, 71, 103});
        if (parentType == null) {
            return;
        }
        ITypeBinding referencedFromBinding = parentType.resolveBinding();
        boolean includePrivate = referencedFromBinding.getKey().equals(typeBinding.getKey());
        MethodDeclaration methodDeclaration = (MethodDeclaration)DOMCompletionEngine.findParent(referencedFrom, new int[]{31});
        boolean includeProtected = referencedFromBinding.getKey().equals(typeBinding.getKey()) ? true : (methodDeclaration != null && (methodDeclaration.getModifiers() & 8) != 0 ? false : DOMCompletionEngine.findInSupers(referencedFromBinding, typeBinding));
        this.processMembers(typeBinding, scope, includePrivate, includeProtected, referencedFromBinding.getPackage().getKey(), isStaticContext, false, new HashSet<String>(), new HashSet<String>());
    }

    private void processMembers(ITypeBinding typeBinding, Bindings scope, boolean includePrivate, boolean includeProtected, String originalPackageKey, boolean isStaticContext, boolean canUseAbstract, Set<String> impossibleMethods, Set<String> impossibleFields) {
        ITypeBinding superclassBinding;
        if (typeBinding == null) {
            return;
        }
        Predicate<IBinding> accessFilter = binding -> {
            boolean field = binding instanceof IVariableBinding;
            if (field ? impossibleFields.contains(binding.getName()) : impossibleMethods.contains(binding.getName())) {
                return false;
            }
            if (!includePrivate && (binding.getModifiers() & 2) != 0 || !includeProtected && (binding.getModifiers() & 4) != 0 || (binding.getModifiers() & 7) == 0 && !originalPackageKey.equals(typeBinding.getPackage().getKey()) || isStaticContext && (binding.getModifiers() & 8) == 0 || !canUseAbstract && (binding.getModifiers() & 0x400) != 0) {
                if (field) {
                    impossibleFields.add(binding.getName());
                } else {
                    impossibleMethods.add(binding.getName());
                }
                return false;
            }
            return true;
        };
        Arrays.stream(typeBinding.getDeclaredFields()).filter(accessFilter).forEach(scope::add);
        Arrays.stream(typeBinding.getDeclaredMethods()).filter(accessFilter).forEach(scope::add);
        if (typeBinding.getInterfaces() != null) {
            ITypeBinding[] iTypeBindingArray = typeBinding.getInterfaces();
            int n = iTypeBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding superinterfaceBinding = iTypeBindingArray[n2];
                this.processMembers(superinterfaceBinding, scope, false, includeProtected, originalPackageKey, isStaticContext, true, impossibleMethods, impossibleFields);
                ++n2;
            }
        }
        if ((superclassBinding = typeBinding.getSuperclass()) != null) {
            this.processMembers(superclassBinding, scope, false, includeProtected, originalPackageKey, isStaticContext, true, impossibleMethods, impossibleFields);
        }
    }

    private static boolean findInSupers(ITypeBinding root, ITypeBinding toFind) {
        String keyToFind = toFind.getErasure().getKey();
        LinkedList<ITypeBinding> toCheck = new LinkedList<ITypeBinding>();
        HashSet<String> alreadyChecked = new HashSet<String>();
        toCheck.add(root.getErasure());
        while (!toCheck.isEmpty()) {
            ITypeBinding current = (ITypeBinding)toCheck.poll();
            String currentKey = current.getErasure().getKey();
            if (alreadyChecked.contains(currentKey)) continue;
            alreadyChecked.add(currentKey);
            if (currentKey.equals(keyToFind)) {
                return true;
            }
            ITypeBinding[] iTypeBindingArray = current.getInterfaces();
            int n = iTypeBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding superInterface = iTypeBindingArray[n2];
                toCheck.add(superInterface);
                ++n2;
            }
            if (current.getSuperclass() == null) continue;
            toCheck.add(current.getSuperclass());
        }
        return false;
    }

    private CompletionProposal toProposal(IBinding binding) {
        return this.toProposal(binding, binding.getName());
    }

    private CompletionProposal toProposal(IBinding binding, String completion) {
        ITypeBinding iTypeBinding;
        IJavaElement iJavaElement;
        if (binding instanceof ITypeBinding && (iJavaElement = binding.getJavaElement()) instanceof IType) {
            IType type = (IType)iJavaElement;
            return this.toProposal(type);
        }
        int kind = -1;
        if (binding instanceof ITypeBinding) {
            kind = 9;
        } else if (binding instanceof IMethodBinding) {
            IMethodBinding m = (IMethodBinding)binding;
            kind = m.getDeclaringClass() != null && m.getDeclaringClass().isAnnotation() ? 13 : 6;
        } else if (binding instanceof IVariableBinding) {
            IVariableBinding variableBinding = (IVariableBinding)binding;
            kind = variableBinding.isField() ? 2 : 5;
        }
        InternalCompletionProposal res = new InternalCompletionProposal(kind, this.offset);
        res.setName(binding.getName().toCharArray());
        if (kind == 6) {
            completion = (String)completion + "()";
        }
        res.setCompletion(((String)completion).toCharArray());
        res.setFlags(binding.getModifiers());
        if (kind == 6) {
            methodBinding = (IMethodBinding)binding;
            List<String> paramNames = DOMCompletionEngineMethodDeclHandler.findVariableNames(methodBinding);
            if (paramNames.isEmpty()) {
                res.setParameterNames(null);
            } else {
                res.setParameterNames((char[][])paramNames.stream().map(String::toCharArray).toArray(i -> new char[i][]));
            }
            res.setParameterTypeNames((char[][])Stream.of(methodBinding.getParameterNames()).map(String::toCharArray).toArray(n -> new char[n][]));
            res.setSignature(DOMCompletionEngineBuilder.getSignature(methodBinding));
            res.setDeclarationSignature(Signature.createTypeSignature(methodBinding.getDeclaringClass().getQualifiedName().toCharArray(), true).toCharArray());
        } else if (kind == 5 || kind == 2) {
            IVariableBinding variableBinding = (IVariableBinding)binding;
            res.setSignature(Signature.createTypeSignature(variableBinding.getType().getQualifiedName().toCharArray(), true).toCharArray());
            if (variableBinding.isField()) {
                ITypeBinding declaringClass = variableBinding.getDeclaringClass();
                if (declaringClass != null) {
                    char[] declSignature = Signature.createTypeSignature(variableBinding.getDeclaringClass().getQualifiedName().toCharArray(), true).toCharArray();
                    res.setReceiverSignature(declSignature);
                    res.setDeclarationSignature(declSignature);
                } else {
                    res.setReceiverSignature(new char[0]);
                    res.setDeclarationSignature(new char[0]);
                }
            } else {
                res.setReceiverSignature(new char[0]);
                res.setDeclarationSignature(new char[0]);
            }
        } else if (kind == 9) {
            ITypeBinding typeBinding = (ITypeBinding)binding;
            res.setSignature(Signature.createTypeSignature(typeBinding.getQualifiedName().toCharArray(), true).toCharArray());
        } else if (kind == 13) {
            methodBinding = (IMethodBinding)binding;
            StringBuilder annotationCompletion = new StringBuilder((String)completion);
            boolean surroundWithSpaces = "insert".equals(this.unit.getJavaElement().getJavaProject().getOption("org.eclipse.jdt.core.formatter.insert_space_before_assignment_operator", true));
            if (surroundWithSpaces) {
                annotationCompletion.append(' ');
            }
            annotationCompletion.append('=');
            if (surroundWithSpaces) {
                annotationCompletion.append(' ');
            }
            res.setCompletion(annotationCompletion.toString().toCharArray());
            res.setSignature(Signature.createTypeSignature(this.qualifiedTypeName(methodBinding.getReturnType()), true).toCharArray());
            res.setReceiverSignature(Signature.createTypeSignature(methodBinding.getDeclaringClass().getQualifiedName().toCharArray(), true).toCharArray());
            res.setDeclarationSignature(Signature.createTypeSignature(methodBinding.getDeclaringClass().getQualifiedName().toCharArray(), true).toCharArray());
        } else {
            res.setSignature(new char[0]);
            res.setReceiverSignature(new char[0]);
            res.setDeclarationSignature(new char[0]);
        }
        res.setReplaceRange(this.toComplete instanceof SimpleName ? this.toComplete.getStartPosition() : this.offset, this.offset);
        IJavaElement element = binding.getJavaElement();
        if (element != null) {
            res.setDeclarationTypeName(((IType)element.getAncestor(7)).getFullyQualifiedName().toCharArray());
            res.setDeclarationPackageName(element.getAncestor(4).getElementName().toCharArray());
        }
        res.completionEngine = this.nestedEngine;
        res.nameLookup = this.nameEnvironment.nameLookup;
        int n2 = CompletionEngine.computeBaseRelevance() + CompletionEngine.computeRelevanceForResolution() + this.nestedEngine.computeRelevanceForInterestingProposal() + CompletionEngine.computeRelevanceForCaseMatching(this.prefix.toCharArray(), binding.getName().toCharArray(), this.assistOptions);
        if (binding instanceof ITypeBinding) {
            ITypeBinding typeBinding;
            iTypeBinding = typeBinding = (ITypeBinding)binding;
        } else if (binding instanceof IMethodBinding) {
            IMethodBinding methodBinding = (IMethodBinding)binding;
            iTypeBinding = methodBinding.getReturnType();
        } else if (binding instanceof IVariableBinding) {
            IVariableBinding variableBinding = (IVariableBinding)binding;
            iTypeBinding = variableBinding.getType();
        } else {
            iTypeBinding = this.toComplete.getAST().resolveWellKnownType(Object.class.getName());
        }
        res.setRelevance(n2 + this.computeRelevanceForExpectingType(iTypeBinding) + 3 + CompletionEngine.computeRelevanceForRestrictions(0));
        return res;
    }

    private String qualifiedTypeName(ITypeBinding typeBinding) {
        if (typeBinding.isTypeVariable()) {
            return typeBinding.getName();
        }
        return typeBinding.getQualifiedName();
    }

    private CompletionProposal toProposal(IType type) {
        InternalCompletionProposal res = new InternalCompletionProposal(9, this.offset);
        char[] simpleName = type.getElementName().toCharArray();
        char[] signature = Signature.createTypeSignature(type.getFullyQualifiedName(), true).toCharArray();
        res.setName(simpleName);
        res.setCompletion(type.getElementName().toCharArray());
        res.setSignature(signature);
        if (this.toComplete instanceof FieldAccess || this.prefix.isEmpty()) {
            res.setReplaceRange(this.offset, this.offset);
        } else if (this.toComplete instanceof MarkerAnnotation) {
            res.setReplaceRange(this.toComplete.getStartPosition() + 1, this.toComplete.getStartPosition() + this.toComplete.getLength());
        } else {
            SimpleName currentName;
            ASTNode aSTNode = this.toComplete;
            if (aSTNode instanceof SimpleName && FAKE_IDENTIFIER.equals((currentName = (SimpleName)aSTNode).toString())) {
                res.setReplaceRange(this.offset, this.offset);
            } else {
                res.setReplaceRange(this.toComplete.getStartPosition(), this.offset);
            }
        }
        try {
            res.setFlags(type.getFlags());
        }
        catch (JavaModelException ex) {
            ILog.get().error(ex.getMessage(), (Throwable)((Object)ex));
        }
        if (this.toComplete instanceof SimpleName) {
            res.setTokenRange(this.toComplete.getStartPosition(), this.toComplete.getStartPosition() + this.toComplete.getLength());
        } else if (this.toComplete instanceof MarkerAnnotation) {
            res.setTokenRange(this.offset, this.offset);
        }
        res.completionEngine = this.nestedEngine;
        res.nameLookup = this.nameEnvironment.nameLookup;
        int relevance = 39;
        relevance += DOMCompletionEngine.computeRelevanceForCaseMatching(this.prefix.toCharArray(), simpleName, this.assistOptions);
        try {
            if (type.isAnnotation()) {
                relevance += 20;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        res.setRelevance(relevance);
        res.setRequiredProposals(new CompletionProposal[]{this.toImportProposal(simpleName, signature)});
        return res;
    }

    private CompletionProposal toImportProposal(char[] simpleName, char[] signature) {
        InternalCompletionProposal res = new InternalCompletionProposal(23, this.offset);
        res.setName(simpleName);
        res.setSignature(signature);
        res.completionEngine = this.nestedEngine;
        res.nameLookup = this.nameEnvironment.nameLookup;
        return res;
    }

    private CompletionProposal toPackageProposal(String packageName, ASTNode completing) {
        InternalCompletionProposal res = new InternalCompletionProposal(8, this.offset);
        res.setName(packageName.toCharArray());
        res.setCompletion(packageName.toCharArray());
        res.setDeclarationSignature(packageName.toCharArray());
        res.setSignature(packageName.toCharArray());
        QualifiedName qualifiedName = (QualifiedName)DOMCompletionEngine.findParent(completing, new int[]{40});
        int relevance = 36 + DOMCompletionEngine.computeRelevanceForCaseMatching(this.prefix.toCharArray(), packageName.toCharArray(), this.assistOptions) + (qualifiedName != null ? 2 : 2) + 3;
        res.setRelevance(relevance);
        this.configureProposal(res, completing);
        if (qualifiedName != null) {
            res.setReplaceRange(qualifiedName.getStartPosition(), this.offset);
        }
        return res;
    }

    private void configureProposal(InternalCompletionProposal proposal, ASTNode completing) {
        proposal.setReplaceRange(completing.getStartPosition(), this.offset);
        proposal.completionEngine = this.nestedEngine;
        proposal.nameLookup = this.nameEnvironment.nameLookup;
    }

    private int computeRelevanceForExpectingType(ITypeBinding proposalType) {
        if (proposalType != null) {
            int relevance = 0;
            if (!this.expectedTypes.getExpectedTypes().isEmpty() && PrimitiveType.VOID.toString().equals(proposalType.getName())) {
                return -5;
            }
            for (ITypeBinding expectedType : this.expectedTypes.getExpectedTypes()) {
                if (this.expectedTypes.allowsSubtypes() && proposalType.getErasure().isSubTypeCompatible(expectedType.getErasure())) {
                    if (Objects.equals(expectedType.getQualifiedName(), proposalType.getQualifiedName())) {
                        return 30;
                    }
                    if (proposalType.getPackage() != null && proposalType.getPackage().isUnnamed()) {
                        return 25;
                    }
                    relevance = 20;
                }
                if (!this.expectedTypes.allowsSupertypes() || !expectedType.isSubTypeCompatible(proposalType)) continue;
                if (Objects.equals(expectedType.getQualifiedName(), proposalType.getQualifiedName())) {
                    return 30;
                }
                relevance = 20;
            }
            return relevance;
        }
        return 0;
    }

    private HashSet<String> getAllJarModuleNames(IJavaProject project) {
        HashSet<String> modules = new HashSet<String>();
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = project.getAllPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (root instanceof JarPackageFragmentRoot) {
                    String name;
                    IModuleDescription desc = root.getModuleDescription();
                    desc = desc == null ? ((JarPackageFragmentRoot)root).getAutomaticModuleDescription() : desc;
                    String string = name = desc != null ? desc.getElementName() : null;
                    if (name != null && name.length() > 0) {
                        modules.add(name);
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return modules;
    }

    private void findModules(char[] prefix, IJavaProject project, AssistOptions options, Set<String> skip) {
        if (this.requestor.isIgnored(29)) {
            return;
        }
        HashSet<String> probableModules = new HashSet<String>();
        ModuleSourcePathManager mManager = JavaModelManager.getModulePathManager();
        JavaElementRequestor javaElementRequestor = new JavaElementRequestor();
        try {
            IModuleDescription[] modules;
            mManager.seekModule(prefix, true, javaElementRequestor);
            IModuleDescription[] iModuleDescriptionArray = modules = javaElementRequestor.getModules();
            int n = modules.length;
            int n2 = 0;
            while (n2 < n) {
                IModuleDescription module = iModuleDescriptionArray[n2];
                String name = module.getElementName();
                if (name != null && !name.equals("")) {
                    probableModules.add(name);
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        probableModules.addAll(this.getAllJarModuleNames(project));
        if (prefix != CharOperation.ALL_PREFIX && prefix != null && prefix.length > 0) {
            probableModules.removeIf(e -> CompletionEngine.isFailedMatch(prefix, e.toCharArray(), options));
        }
        probableModules.removeIf(skip::contains);
        probableModules.forEach(m -> this.requestor.accept(this.toModuleCompletion((String)m, prefix)));
    }

    private CompletionProposal toModuleCompletion(String moduleName, char[] prefix) {
        char[] completion = moduleName.toCharArray();
        int relevance = CompletionEngine.computeBaseRelevance();
        relevance += CompletionEngine.computeRelevanceForResolution();
        relevance += this.nestedEngine.computeRelevanceForInterestingProposal();
        relevance += this.nestedEngine.computeRelevanceForCaseMatching(prefix, completion);
        relevance += this.nestedEngine.computeRelevanceForQualification(true);
        relevance += CompletionEngine.computeRelevanceForRestrictions(0);
        InternalCompletionProposal proposal = new InternalCompletionProposal(29, this.offset);
        proposal.setModuleName(completion);
        proposal.setDeclarationSignature(completion);
        proposal.setCompletion(completion);
        proposal.setReplaceRange(this.toComplete instanceof SimpleName ? this.toComplete.getStartPosition() : this.offset, this.offset);
        proposal.setRelevance(relevance);
        proposal.completionEngine = this.nestedEngine;
        proposal.nameLookup = this.nameEnvironment.nameLookup;
        return proposal;
    }

    protected InternalCompletionProposal createProposal(int kind) {
        InternalCompletionProposal proposal = (InternalCompletionProposal)CompletionProposal.create(kind, this.offset);
        proposal.nameLookup = this.nameEnvironment.nameLookup;
        proposal.completionEngine = this.nestedEngine;
        return proposal;
    }

    protected boolean isFailedMatch(char[] orphanedContent, char[] name) {
        if (name.length < orphanedContent.length) {
            return true;
        }
        return !(this.assistOptions.substringMatch && CharOperation.substringMatch((char[])orphanedContent, (char[])name) || this.assistOptions.camelCaseMatch && CharOperation.camelCaseMatch((char[])orphanedContent, (char[])name) || CharOperation.prefixEquals((char[])orphanedContent, (char[])name, (boolean)false) || this.assistOptions.subwordMatch && CharOperation.subWordMatch((char[])orphanedContent, (char[])name));
    }

    static int computeRelevanceForCaseMatching(char[] token, char[] proposalName, AssistOptions options) {
        if (CharOperation.equals((char[])token, (char[])proposalName, (boolean)true)) {
            return 14;
        }
        if (CharOperation.equals((char[])token, (char[])proposalName, (boolean)false)) {
            return 4;
        }
        if (CharOperation.prefixEquals((char[])token, (char[])proposalName, (boolean)false)) {
            if (CharOperation.prefixEquals((char[])token, (char[])proposalName, (boolean)true)) {
                return 10;
            }
        } else {
            if (options.camelCaseMatch && CharOperation.camelCaseMatch((char[])token, (char[])proposalName)) {
                return 5;
            }
            if (options.substringMatch && CharOperation.substringMatch((char[])token, (char[])proposalName)) {
                return -21;
            }
            if (options.subwordMatch && CharOperation.subWordMatch((char[])token, (char[])proposalName)) {
                return -22;
            }
        }
        return 0;
    }

    private CompletionProposal createKeywordProposal(char[] keyword, int startPos, int endPos) {
        int relevance = 39 + CompletionEngine.computeRelevanceForCaseMatching(this.prefix.toCharArray(), keyword, this.assistOptions);
        InternalCompletionProposal keywordProposal = this.createProposal(3);
        ((CompletionProposal)keywordProposal).setCompletion(keyword);
        ((CompletionProposal)keywordProposal).setName(keyword);
        ((CompletionProposal)keywordProposal).setReplaceRange(startPos, endPos);
        ((CompletionProposal)keywordProposal).setRelevance(relevance);
        return keywordProposal;
    }

    private CompletionProposal createClassKeywordProposal(ITypeBinding typeBinding, int startPos, int endPos) {
        int relevance = 59;
        if (!this.isFailedMatch(this.prefix.toCharArray(), Keywords.CLASS)) {
            relevance -= 21;
        }
        InternalCompletionProposal keywordProposal = this.createProposal(2);
        keywordProposal.setCompletion(Keywords.CLASS);
        keywordProposal.setReplaceRange(startPos, endPos);
        keywordProposal.setRelevance(relevance);
        keywordProposal.setPackageName(CharOperation.concatWith((char[][])TypeConstants.JAVA_LANG, (char)'.'));
        keywordProposal.setTypeName("Class".toCharArray());
        keywordProposal.setName(Keywords.CLASS);
        StringBuilder builder = new StringBuilder();
        builder.append("Ljava.lang.Class<");
        String typeBindingKey = typeBinding.getKey().replace('/', '.');
        builder.append(typeBindingKey);
        builder.append(">;");
        keywordProposal.setSignature(builder.toString().toCharArray());
        return keywordProposal;
    }

    private static boolean isNodeInStaticContext(ASTNode node) {
        boolean isStatic = false;
        ASTNode cursor = node;
        while (cursor != null && !(cursor instanceof MethodDeclaration)) {
            cursor = cursor.getParent();
        }
        if (cursor instanceof MethodDeclaration) {
            MethodDeclaration methodDecl = (MethodDeclaration)cursor;
            isStatic = (methodDecl.resolveBinding().getModifiers() & 8) != 0;
        }
        return isStatic;
    }

    static class Bindings {
        private HashSet<IMethodBinding> methods = new HashSet();
        private HashSet<IBinding> others = new HashSet();

        Bindings() {
        }

        public void add(IMethodBinding binding) {
            if (binding.isConstructor()) {
                return;
            }
            if (this.methods.stream().anyMatch(method -> method.overrides(binding))) {
                return;
            }
            this.methods.removeIf(method -> binding.overrides((IMethodBinding)method));
            this.methods.add(binding);
        }

        public void add(IBinding binding) {
            if (binding instanceof IMethodBinding) {
                IMethodBinding methodBinding = (IMethodBinding)binding;
                this.add(methodBinding);
            } else {
                this.others.add(binding);
            }
        }

        public void addAll(Collection<? extends IBinding> bindings) {
            bindings.forEach(this::add);
        }

        public Stream<IBinding> stream() {
            return Stream.of(this.methods, this.others).flatMap(Collection::stream);
        }
    }

    private record ExtendsOrImplementsInfo(AbstractTypeDeclaration typeDecl, boolean isImplements) {
    }
}

