/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.javac.UnusedProblemFactory;

public class UnusedTreeScanner<R, P>
extends TreeScanner<R, P> {
    final Set<Tree> privateDecls = new LinkedHashSet<Tree>();
    final Set<Symbol> usedElements = new HashSet<Symbol>();
    final Map<String, JCTree.JCImport> unusedImports = new LinkedHashMap<String, JCTree.JCImport>();
    private CompilationUnitTree unit = null;

    @Override
    public R visitCompilationUnit(CompilationUnitTree node, P p) {
        this.unit = node;
        return super.visitCompilationUnit(node, p);
    }

    @Override
    public R visitImport(ImportTree node, P p) {
        if (node instanceof JCTree.JCImport) {
            JCTree.JCImport jcImport = (JCTree.JCImport)node;
            String importClass = jcImport.qualid.toString();
            this.unusedImports.put(importClass, jcImport);
        }
        return super.visitImport(node, p);
    }

    @Override
    public R visitClass(ClassTree node, P p) {
        JCTree.JCClassDecl classDecl;
        if (node instanceof JCTree.JCClassDecl && this.isPotentialUnusedDeclaration(classDecl = (JCTree.JCClassDecl)node)) {
            this.privateDecls.add(classDecl);
        }
        return super.visitClass(node, p);
    }

    @Override
    public R visitIdentifier(IdentifierTree node, P p) {
        JCTree.JCIdent id;
        if (node instanceof JCTree.JCIdent) {
            id = (JCTree.JCIdent)node;
            if (this.isPrivateSymbol(id.sym)) {
                this.usedElements.add(id.sym);
            }
        }
        if (node instanceof JCTree.JCIdent) {
            id = (JCTree.JCIdent)node;
            if (this.isMemberSymbol(id.sym)) {
                String name = id.toString();
                String ownerName = id.sym.owner.toString();
                if (!ownerName.isBlank()) {
                    String starImport = ownerName + ".*";
                    String usualImport = ownerName + "." + name;
                    if (this.unusedImports.containsKey(starImport)) {
                        this.unusedImports.remove(starImport);
                    } else if (this.unusedImports.containsKey(usualImport)) {
                        this.unusedImports.remove(usualImport);
                    }
                }
            }
        }
        return super.visitIdentifier(node, p);
    }

    @Override
    public R visitMemberSelect(MemberSelectTree node, P p) {
        if (node instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess field = (JCTree.JCFieldAccess)node;
            if (this.isPrivateSymbol(field.sym)) {
                this.usedElements.add(field.sym);
            }
        }
        return super.visitMemberSelect(node, p);
    }

    @Override
    public R visitMethod(MethodTree node, P p) {
        boolean isPrivateMethod = this.isPotentialUnusedDeclaration(node);
        if (isPrivateMethod) {
            this.privateDecls.add(node);
        }
        return super.visitMethod(node, p);
    }

    @Override
    public R visitVariable(VariableTree node, P p) {
        boolean isPrivateVariable = this.isPotentialUnusedDeclaration(node);
        if (isPrivateVariable) {
            this.privateDecls.add(node);
        }
        return super.visitVariable(node, p);
    }

    @Override
    public R visitMemberReference(MemberReferenceTree node, P p) {
        if (node instanceof JCTree.JCMemberReference) {
            JCTree.JCMemberReference member = (JCTree.JCMemberReference)node;
            if (this.isPrivateSymbol(member.sym)) {
                this.usedElements.add(member.sym);
            }
        }
        return super.visitMemberReference(node, p);
    }

    @Override
    public R visitNewClass(NewClassTree node, P p) {
        if (node instanceof JCTree.JCNewClass) {
            Symbol.TypeSymbol targetClass;
            JCTree.JCNewClass newClass = (JCTree.JCNewClass)node;
            Symbol.TypeSymbol typeSymbol = targetClass = newClass.def != null ? newClass.def.sym : newClass.type.tsym;
            if (this.isPrivateSymbol(targetClass)) {
                this.usedElements.add(targetClass);
            }
        }
        return super.visitNewClass(node, p);
    }

    private boolean isPotentialUnusedDeclaration(Tree tree) {
        if (tree instanceof JCTree.JCClassDecl) {
            JCTree.JCClassDecl classTree = (JCTree.JCClassDecl)tree;
            return (classTree.getModifiers().flags & 2L) != 0L;
        }
        if (tree instanceof JCTree.JCMethodDecl) {
            JCTree.JCMethodDecl methodTree = (JCTree.JCMethodDecl)tree;
            if (this.isConstructor(methodTree)) {
                return (methodTree.getModifiers().flags & 2L) != 0L && this.hasPackageVisibleConstructor(methodTree.sym.owner);
            }
            return (methodTree.getModifiers().flags & 2L) != 0L;
        }
        if (tree instanceof JCTree.JCVariableDecl) {
            Symbol owner;
            JCTree.JCVariableDecl variable = (JCTree.JCVariableDecl)tree;
            Symbol symbol = owner = variable.sym == null ? null : variable.sym.owner;
            if (owner instanceof Symbol.ClassSymbol) {
                return !this.isSerialVersionConstant(variable) && (variable.getModifiers().flags & 2L) != 0L;
            }
            if (owner instanceof Symbol.MethodSymbol) {
                return true;
            }
        }
        return false;
    }

    private boolean isConstructor(JCTree.JCMethodDecl methodDecl) {
        return methodDecl.sym != null && methodDecl.sym.isConstructor();
    }

    private boolean hasPackageVisibleConstructor(Symbol symbol) {
        if (symbol instanceof Symbol.ClassSymbol) {
            Symbol.ClassSymbol clazz = (Symbol.ClassSymbol)symbol;
            for (Symbol member : clazz.members().getSymbols()) {
                Symbol.MethodSymbol method;
                if (!(member instanceof Symbol.MethodSymbol) || !(method = (Symbol.MethodSymbol)member).isConstructor() || (method.flags() & 2L) != 0L) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPrivateSymbol(Symbol symbol) {
        if (symbol instanceof Symbol.ClassSymbol || symbol instanceof Symbol.MethodSymbol) {
            return (symbol.flags() & 2L) != 0L;
        }
        if (symbol instanceof Symbol.VarSymbol) {
            if (symbol.owner instanceof Symbol.ClassSymbol) {
                return (symbol.flags() & 2L) != 0L;
            }
            if (symbol.owner instanceof Symbol.MethodSymbol) {
                return true;
            }
        }
        return false;
    }

    private boolean isMemberSymbol(Symbol symbol) {
        if (symbol instanceof Symbol.ClassSymbol || symbol instanceof Symbol.MethodSymbol) {
            return true;
        }
        if (symbol instanceof Symbol.VarSymbol) {
            return symbol.owner instanceof Symbol.ClassSymbol;
        }
        return false;
    }

    private boolean isSerialVersionConstant(JCTree.JCVariableDecl variable) {
        Type.JCPrimitiveType type;
        Type type2;
        long flags = variable.getModifiers().flags;
        return (flags & 0x10L) != 0L && (flags & 8L) != 0L && (type2 = variable.type) instanceof Type.JCPrimitiveType && (type = (Type.JCPrimitiveType)type2).getTag() == TypeTag.LONG && "serialVersionUID".equals(variable.name.toString());
    }

    public List<CategorizedProblem> getUnusedImports(UnusedProblemFactory problemFactory) {
        return problemFactory.addUnusedImports(this.unit, this.unusedImports);
    }

    public List<CategorizedProblem> getUnusedPrivateMembers(UnusedProblemFactory problemFactory) {
        ArrayList<Tree> unusedPrivateMembers = new ArrayList<Tree>();
        for (Tree decl : this.privateDecls) {
            if (decl instanceof JCTree.JCClassDecl) {
                JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)decl;
                if (!this.usedElements.contains(classDecl.sym)) {
                    unusedPrivateMembers.add(decl);
                    continue;
                }
            }
            if (decl instanceof JCTree.JCMethodDecl) {
                JCTree.JCMethodDecl methodDecl = (JCTree.JCMethodDecl)decl;
                if (!this.usedElements.contains(methodDecl.sym)) {
                    unusedPrivateMembers.add(decl);
                    continue;
                }
            }
            if (!(decl instanceof JCTree.JCVariableDecl)) continue;
            JCTree.JCVariableDecl variableDecl = (JCTree.JCVariableDecl)decl;
            if (this.usedElements.contains(variableDecl.sym)) continue;
            unusedPrivateMembers.add(decl);
        }
        return problemFactory.addUnusedPrivateMembers(this.unit, unusedPrivateMembers);
    }
}

