/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.manipulation.SharedASTProviderCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.codeassist.InternalCompletionProposal;
import org.eclipse.jdt.internal.codeassist.impl.Engine;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.core.NamedMember;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelComposerCore;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.core.manipulation.search.IOccurrencesFinder;
import org.eclipse.jdt.internal.core.manipulation.search.OccurrencesFinder;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.viewsupport.CoreJavaElementLinks;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.jdt.ls.core.internal.DocumentAdapter;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.managers.ContentProviderManager;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public final class JDTUtils {
    public static final String PATH_SEPARATOR = "/";
    public static final String PERIOD = ".";
    public static final String SRC = "src";
    private static final String JDT_SCHEME = "jdt";
    private static final long LABEL_FLAGS = 4787310288012503L;
    private static Set<String> SILENCED_CODEGENS = Collections.singleton("lombok");

    private JDTUtils() {
    }

    public static ICompilationUnit resolveCompilationUnit(String uriString) {
        return JDTUtils.resolveCompilationUnit(JDTUtils.toURI(uriString));
    }

    public static ICompilationUnit resolveCompilationUnit(URI uri) {
        if (uri == null || JDT_SCHEME.equals(uri.getScheme()) || !uri.isAbsolute()) {
            return null;
        }
        IFile resource = (IFile)JDTUtils.findResource(uri, arg_0 -> ((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).findFilesForLocationURI(arg_0));
        if (resource != null) {
            return JDTUtils.resolveCompilationUnit(resource);
        }
        return JDTUtils.getFakeCompilationUnit(uri, (IProgressMonitor)new NullProgressMonitor());
    }

    public static ICompilationUnit resolveCompilationUnit(IFile resource) {
        if (resource != null) {
            String name;
            if (!ProjectUtils.isJavaProject(resource.getProject())) {
                return null;
            }
            if (resource.getFileExtension() != null && Util.isJavaLikeFileName((String)(name = resource.getName()))) {
                return JavaCore.createCompilationUnitFrom((IFile)resource);
            }
        }
        return null;
    }

    public static IPackageFragment resolvePackage(String uriString) {
        return JDTUtils.resolvePackage(JDTUtils.toURI(uriString));
    }

    public static IPackageFragment resolvePackage(URI uri) {
        if (uri == null || JDT_SCHEME.equals(uri.getScheme()) || !uri.isAbsolute()) {
            return null;
        }
        IFolder resource = (IFolder)JDTUtils.findResource(uri, arg_0 -> ((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).findContainersForLocationURI(arg_0));
        if (resource != null) {
            if (!ProjectUtils.isJavaProject(resource.getProject())) {
                return null;
            }
            IJavaElement element = JavaCore.create((IFolder)resource);
            if (element instanceof IPackageFragment) {
                IPackageFragment pkg = (IPackageFragment)element;
                return pkg;
            }
        }
        return null;
    }

    public static ICompilationUnit getFakeCompilationUnit(String uri) {
        return JDTUtils.getFakeCompilationUnit(JDTUtils.toURI(uri), (IProgressMonitor)new NullProgressMonitor());
    }

    static ICompilationUnit getFakeCompilationUnit(URI uri, IProgressMonitor monitor) {
        if (uri == null || !"file".equals(uri.getScheme())) {
            return null;
        }
        final java.nio.file.Path path = Paths.get(uri);
        if (!JDTUtils.isJavaFile(path)) {
            return null;
        }
        if (!Files.isReadable(path)) {
            return null;
        }
        try {
            ProjectsManager.createJavaProject(ProjectsManager.getDefaultProject(), (IProgressMonitor)new NullProgressMonitor());
            ProjectsManager.cleanupResources(ProjectsManager.getDefaultProject());
        }
        catch (Exception exception) {
            // empty catch block
        }
        JavaLanguageServerPlugin.getProjectsManager();
        IProject project = ProjectsManager.getDefaultProject();
        if (project == null || !project.isAccessible()) {
            String fileName = path.getFileName().toString();
            if (JDTUtils.isJavaFile(fileName) || fileName.endsWith(".class")) {
                fileName = fileName.substring(0, fileName.lastIndexOf(46));
            }
            WorkingCopyOwner owner = new WorkingCopyOwner(){

                public IBuffer createBuffer(ICompilationUnit workingCopy) {
                    return new DocumentAdapter((IOpenable)workingCopy, path);
                }
            };
            try {
                return owner.newWorkingCopy(fileName, new IClasspathEntry[]{JavaRuntime.getDefaultJREContainerEntry()}, monitor);
            }
            catch (JavaModelException e) {
                return null;
            }
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        String packageName = JDTUtils.getPackageName(javaProject, uri);
        String fileName = path.getName(path.getNameCount() - 1).toString();
        String packagePath = packageName.replace(PERIOD, PATH_SEPARATOR);
        IPath filePath = new Path(SRC).append(packagePath).append(fileName);
        IFile file = project.getFile(filePath);
        if (!file.isLinked()) {
            try {
                JDTUtils.createFolders(file.getParent(), monitor);
                file.createLink(uri, 256, monitor);
            }
            catch (CoreException e) {
                String errMsg = "Failed to create linked resource from " + String.valueOf(uri) + " to " + project.getName();
                JavaLanguageServerPlugin.logException(errMsg, e);
            }
        }
        if (file.isLinked()) {
            return (ICompilationUnit)JavaCore.create((IResource)file, (IJavaProject)javaProject);
        }
        return null;
    }

    public static void createFolders(IContainer folder, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists() && folder instanceof IFolder) {
            IContainer parent = folder.getParent();
            JDTUtils.createFolders(parent, monitor);
            folder.refreshLocal(0, monitor);
            if (!folder.exists()) {
                ((IFolder)folder).create(true, true, monitor);
            }
        }
    }

    public static String getPackageName(IJavaProject javaProject, URI uri) {
        block4: {
            try {
                File file = ResourceUtils.toFile(uri);
                String content = Files.readString(file.toPath());
                if (content.isEmpty() && javaProject != null && "jdt.ls-java-project".equals(javaProject.getProject().getName())) {
                    java.nio.file.Path path;
                    java.nio.file.Path parent = path = Paths.get(uri);
                    while (parent.getParent() != null && parent.getParent().getNameCount() > 0) {
                        String pathStr;
                        String name = (parent = parent.getParent()).getName(parent.getNameCount() - 1).toString();
                        if (!SRC.equals(name) || (pathStr = path.getParent().toString()).length() <= parent.toString().length()) continue;
                        pathStr = pathStr.substring(parent.toString().length() + 1);
                        pathStr = pathStr.replace(PATH_SEPARATOR, PERIOD);
                        return pathStr;
                    }
                    break block4;
                }
                return JDTUtils.getPackageName(javaProject, content);
            }
            catch (IOException e) {
                JavaLanguageServerPlugin.logException("Failed to read package name from " + String.valueOf(uri), e);
            }
        }
        return "";
    }

    public static String getPackageName(IJavaProject javaProject, String fileContent) {
        if (fileContent == null) {
            return "";
        }
        char[] source = fileContent.toCharArray();
        ASTParser parser = ASTParser.newParser((int)IASTSharedValues.SHARED_AST_LEVEL);
        parser.setProject(javaProject);
        parser.setIgnoreMethodBodies(true);
        parser.setSource(source);
        CompilationUnit ast = (CompilationUnit)parser.createAST(null);
        PackageDeclaration pkg = ast.getPackage();
        return pkg == null || pkg.getName() == null ? "" : pkg.getName().getFullyQualifiedName();
    }

    public static String getName(IJavaElement element) {
        Assert.isNotNull((Object)element, (String)"element");
        String name = JavaElementLabelsCore.getElementLabel((IJavaElement)element, (long)1099513724969L);
        return name == null ? element.getElementName() : name;
    }

    public static boolean isDeprecated(IJavaElement element) throws JavaModelException {
        Assert.isNotNull((Object)element, (String)"element");
        if (element instanceof ITypeRoot) {
            ITypeRoot typeRoot = (ITypeRoot)element;
            return Flags.isDeprecated((int)typeRoot.findPrimaryType().getFlags());
        }
        if (element instanceof IMember) {
            IMember member = (IMember)element;
            return Flags.isDeprecated((int)member.getFlags());
        }
        return false;
    }

    public static IClassFile resolveClassFile(String uriString) {
        return JDTUtils.resolveClassFile(JDTUtils.toURI(uriString));
    }

    public static IClassFile resolveClassFile(URI uri) {
        if (uri != null && JDT_SCHEME.equals(uri.getScheme()) && "contents".equals(uri.getAuthority())) {
            String handleId = uri.getQuery();
            IJavaElement element = JavaCore.create((String)handleId);
            IClassFile cf = (IClassFile)element.getAncestor(6);
            return cf;
        }
        return null;
    }

    public static ITypeRoot resolveTypeRoot(String uriString) {
        return JDTUtils.resolveTypeRoot(uriString, false, null);
    }

    public static ITypeRoot resolveTypeRoot(String uriString, boolean returnCompilationUnit, IProgressMonitor monitor) {
        URI uri = JDTUtils.toURI(uriString);
        if (uri == null) {
            return null;
        }
        if (JDT_SCHEME.equals(uri.getScheme())) {
            IClassFile classFile;
            block8: {
                classFile = JDTUtils.resolveClassFile(uri);
                try {
                    String contents;
                    if (!returnCompilationUnit || classFile == null || classFile.getSourceRange() != null) break block8;
                    ContentProviderManager contentProvider = JavaLanguageServerPlugin.getContentProviderManager();
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    try {
                        contents = contentProvider.getSource(classFile, monitor);
                    }
                    catch (Exception e) {
                        JavaLanguageServerPlugin.logException(e.getMessage(), e);
                        return classFile;
                    }
                    if (contents != null && !contents.isBlank()) {
                        return JDTUtils.getWorkingCopy(classFile, contents, monitor);
                    }
                }
                catch (JavaModelException e) {
                    JavaLanguageServerPlugin.logException(e.getMessage(), e);
                }
            }
            return classFile;
        }
        return JDTUtils.resolveCompilationUnit(uri);
    }

    public static void discardClassFileWorkingCopy(ITypeRoot unit) {
        try {
            if (JDTUtils.getClassFile(unit) != null) {
                ((ICompilationUnit)unit).discardWorkingCopy();
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    public static IClassFile getClassFile(ITypeRoot unit) throws JavaModelException {
        IType primaryType;
        if (unit instanceof ICompilationUnit && unit.getResource() != null && !unit.getResource().exists() && (primaryType = unit.findPrimaryType()) != null) {
            String fqn = primaryType.getFullyQualifiedName();
            IType type = unit.getJavaProject().findType(fqn);
            if (type != null) {
                return type.getClassFile();
            }
        }
        return null;
    }

    public static boolean isJavaFile(java.nio.file.Path path) {
        try {
            return path != null && JDTUtils.isJavaFile(path.toFile().getName());
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
            return false;
        }
    }

    public static boolean isJavaFile(IPath path) {
        return path != null && JDTUtils.isJavaFile(path.lastSegment());
    }

    public static boolean isJavaFile(String name) {
        return name != null && Util.isJavaLikeFileName((String)name);
    }

    public static Location toLocation(IJavaElement element) throws JavaModelException {
        return JDTUtils.toLocation(element, LocationType.NAME_RANGE);
    }

    public static Location toLocation(IJavaElement element, LocationType type) throws JavaModelException {
        ICompilationUnit unit = (ICompilationUnit)element.getAncestor(5);
        IClassFile cf = (IClassFile)element.getAncestor(6);
        if (unit == null && cf == null) {
            return null;
        }
        if (element instanceof ISourceReference) {
            ISourceRange nameRange = type.getRange(element);
            if (SourceRange.isAvailable((ISourceRange)nameRange)) {
                if (cf == null) {
                    IType iType;
                    IMethod method;
                    if (element instanceof IMethod && JDTUtils.isGenerated((IMember)(method = (IMethod)element)) && (iType = method.getDeclaringType()) != null) {
                        IField[] iFieldArray = iType.getFields();
                        int n = iFieldArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IField field = iFieldArray[n2];
                            IMethod getter = GetterSetterUtil.getGetter((IField)field);
                            if (getter != null && JavaModelUtil.isSameMethodSignature((String)getter.getElementName(), (String[])getter.getParameterTypes(), (boolean)false, (IMethod)method)) {
                                nameRange = field.getNameRange();
                                break;
                            }
                            IMethod setter = GetterSetterUtil.getSetter((IField)field);
                            if (setter != null && JavaModelUtil.isSameMethodSignature((String)setter.getElementName(), (String[])setter.getParameterTypes(), (boolean)false, (IMethod)method)) {
                                nameRange = field.getNameRange();
                                break;
                            }
                            ++n2;
                        }
                    }
                    return JDTUtils.toLocation(unit, nameRange.getOffset(), nameRange.getLength());
                }
                return JDTUtils.toLocation(cf, nameRange.getOffset(), nameRange.getLength());
            }
            if (cf != null) {
                return JDTUtils.toLocation(cf);
            }
        }
        return null;
    }

    public static ISourceRange getNameRange(IJavaElement element) throws JavaModelException {
        ISourceRange nameRange = null;
        if (element instanceof IMember) {
            IMember member = (IMember)element;
            nameRange = member.getNameRange();
            if (!SourceRange.isAvailable((ISourceRange)nameRange)) {
                nameRange = member.getSourceRange();
            }
        } else if (element instanceof ITypeParameter || element instanceof ILocalVariable) {
            nameRange = ((ISourceReference)element).getNameRange();
        } else if (element instanceof ISourceReference) {
            ISourceReference sourceRef = (ISourceReference)element;
            nameRange = sourceRef.getSourceRange();
        }
        if (!SourceRange.isAvailable((ISourceRange)nameRange) && element.getParent() != null) {
            nameRange = JDTUtils.getNameRange(element.getParent());
        }
        return nameRange;
    }

    private static ISourceRange getSourceRange(IJavaElement element) throws JavaModelException {
        ISourceRange sourceRange = null;
        if (element instanceof IMember) {
            IMember member = (IMember)element;
            sourceRange = member.getSourceRange();
        } else if (element instanceof ITypeParameter || element instanceof ILocalVariable) {
            sourceRange = ((ISourceReference)element).getSourceRange();
        } else if (element instanceof ISourceReference) {
            ISourceReference sourceRef = (ISourceReference)element;
            sourceRange = sourceRef.getSourceRange();
        }
        if (!SourceRange.isAvailable((ISourceRange)sourceRange) && element.getParent() != null) {
            sourceRange = JDTUtils.getSourceRange(element.getParent());
        }
        return sourceRange;
    }

    public static Location toLocation(ICompilationUnit unit, int offset, int length) throws JavaModelException {
        return new Location(ResourceUtils.toClientUri(JDTUtils.toURI(unit)), JDTUtils.toRange((IOpenable)unit, offset, length));
    }

    public static Location toLocation(IClassFile classFile) throws JavaModelException {
        return JDTUtils.toLocation(classFile, 0, 0);
    }

    public static Location toLocation(String uri) {
        return new Location(ResourceUtils.toClientUri(uri), JDTUtils.newRange());
    }

    public static Location toLocation(IClassFile classFile, int offset, int length) throws JavaModelException {
        String uriString = JDTUtils.toUri(classFile);
        if (uriString != null) {
            Range range = JDTUtils.toRange((IOpenable)classFile, offset, length);
            return new Location(uriString, range);
        }
        return null;
    }

    public static String toUri(IClassFile classFile) {
        if (JavaLanguageServerPlugin.getPreferencesManager() != null && !JavaLanguageServerPlugin.getPreferencesManager().isClientSupportsClassFileContent()) {
            return null;
        }
        String packageName = classFile.getParent().getElementName();
        String jarName = classFile.getParent().getParent().getElementName();
        String uriString = null;
        try {
            uriString = new URI(JDT_SCHEME, "contents", PATH_SEPARATOR + jarName + PATH_SEPARATOR + packageName + PATH_SEPARATOR + classFile.getElementName(), classFile.getHandleIdentifier(), null).toASCIIString();
        }
        catch (URISyntaxException e) {
            JavaLanguageServerPlugin.logException("Error generating URI for class ", e);
        }
        return uriString;
    }

    public static String replaceUriFragment(String uriString, String fragment) {
        URI uri;
        if (uriString != null && (uri = JDTUtils.toURI(uriString)) != null && Objects.equals(JDT_SCHEME, uri.getScheme())) {
            try {
                return new URI(JDT_SCHEME, uri.getAuthority(), uri.getPath(), uri.getQuery(), fragment).toASCIIString();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return uriString;
    }

    public static String toUri(ITypeRoot typeRoot) {
        if (typeRoot instanceof ICompilationUnit) {
            ICompilationUnit unit = (ICompilationUnit)typeRoot;
            return JDTUtils.toURI(unit);
        }
        if (typeRoot instanceof IClassFile) {
            IClassFile classFile = (IClassFile)typeRoot;
            return JDTUtils.toUri(classFile);
        }
        return null;
    }

    public static Range toRange(IOpenable openable, int offset, int length) throws JavaModelException {
        Range range = JDTUtils.newRange();
        if (offset > 0 || length > 0) {
            int[] loc = null;
            int[] endLoc = null;
            IBuffer buffer = openable.getBuffer();
            if (buffer != null) {
                loc = JsonRpcHelpers.toLine(buffer, offset);
                endLoc = JsonRpcHelpers.toLine(buffer, offset + length);
            }
            if (loc == null) {
                loc = new int[2];
            }
            if (endLoc == null) {
                endLoc = new int[2];
            }
            JDTUtils.setPosition(range.getStart(), loc);
            JDTUtils.setPosition(range.getEnd(), endLoc);
        }
        return range;
    }

    public static Range toRange(IDocument document, int offset, int length) throws JavaModelException {
        Range range = JDTUtils.newRange();
        if (offset > 0 || length > 0) {
            int[] loc = null;
            int[] endLoc = null;
            if (document != null) {
                loc = JsonRpcHelpers.toLine(document, offset);
                endLoc = JsonRpcHelpers.toLine(document, offset + length);
            }
            if (loc == null) {
                loc = new int[2];
            }
            if (endLoc == null) {
                endLoc = new int[2];
            }
            JDTUtils.setPosition(range.getStart(), loc);
            JDTUtils.setPosition(range.getEnd(), endLoc);
        }
        return range;
    }

    public static Range newRange() {
        return new Range(new Position(), new Position());
    }

    public static Range newLineRange(int line, int start, int end) {
        return new Range(new Position(line, start), new Position(line, end));
    }

    private static void setPosition(Position position, int[] coords) {
        assert (coords.length == 2);
        position.setLine(coords[0]);
        position.setCharacter(coords[1]);
    }

    @Deprecated
    public static String getFileURI(ICompilationUnit cu) {
        return JDTUtils.toURI(cu);
    }

    public static String toURI(ICompilationUnit cu) {
        String uri;
        if (cu.getResource() != null && (uri = JDTUtils.getFileURI(cu.getResource())) != null) {
            return uri;
        }
        try {
            IBuffer iBuffer = cu.getBuffer();
            if (iBuffer instanceof DocumentAdapter) {
                DocumentAdapter adapter = (DocumentAdapter)iBuffer;
                return adapter.filePath.toFile().toURI().toString();
            }
        }
        catch (JavaModelException ex) {
            JavaLanguageServerPlugin.logException(ex);
        }
        return null;
    }

    public static String getFileURI(IResource resource) {
        URI uri = resource.getRawLocationURI();
        return ResourceUtils.fixURI(uri == null ? resource.getLocationURI() : uri);
    }

    public static IJavaElement findElementAtSelection(ITypeRoot unit, int line, int column, PreferenceManager preferenceManager, IProgressMonitor monitor) throws JavaModelException {
        IJavaElement[] elements = JDTUtils.findElementsAtSelection(unit, line, column, preferenceManager, monitor);
        if (monitor.isCanceled()) {
            return null;
        }
        if (elements != null && elements.length == 1) {
            return elements[0];
        }
        return null;
    }

    public static IJavaElement[] findElementsAtSelection(ITypeRoot unit, int line, int column, PreferenceManager preferenceManager, IProgressMonitor monitor) throws JavaModelException {
        if (unit == null || monitor.isCanceled()) {
            return null;
        }
        int offset = JsonRpcHelpers.toOffset(unit.getBuffer(), line, column);
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        if (offset > -1) {
            NamedMember namedMember;
            ISourceRange range;
            IJavaElement element;
            IJavaElement[] elements = unit.codeSelect(offset, 0);
            if ((elements == null || elements.length == 0) && (element = unit.getElementAt(offset)) instanceof NamedMember && (range = (namedMember = (NamedMember)element).getNameRange()).getOffset() <= offset && range.getOffset() + range.getLength() >= offset) {
                return new IJavaElement[]{element};
            }
            return elements;
        }
        return null;
    }

    public static boolean isSameParameters(IMethod method1, IMethod method2) {
        if (method1 == null || method2 == null) {
            return false;
        }
        String[] params1 = method1.getParameterTypes();
        String[] params2 = method2.getParameterTypes();
        if (params2.length == params1.length) {
            int i = 0;
            while (i < params2.length) {
                String t2;
                String t1 = Signature.getSimpleName((String)Signature.toString((String)params2[i]));
                if (!t1.equals(t2 = Signature.getSimpleName((String)Signature.toString((String)params1[i])))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean isFolder(String uriString) {
        IContainer parent;
        IFile fakeFile = JDTUtils.findFile(uriString);
        IContainer iContainer = parent = fakeFile == null ? null : fakeFile.getParent();
        if (parent == null) {
            return false;
        }
        if (!parent.isSynchronized(1)) {
            try {
                parent.refreshLocal(1, null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return parent.findMember(fakeFile.getName()) instanceof IFolder;
    }

    public static IFile findFile(String uriString) {
        return (IFile)JDTUtils.findResource(JDTUtils.toURI(uriString), arg_0 -> ((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).findFilesForLocationURI(arg_0));
    }

    public static ISchedulingRule getRule(String uri) {
        IFile resource = JDTUtils.findFile(uri);
        if (resource != null) {
            return ResourcesPlugin.getWorkspace().getRuleFactory().createRule((IResource)resource);
        }
        return null;
    }

    public static IContainer findFolder(String uriString) {
        return (IContainer)JDTUtils.findResource(JDTUtils.toURI(uriString), arg_0 -> ((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).findContainersForLocationURI(arg_0));
    }

    public static IResource findResource(URI uri, Function<URI, IResource[]> resourceFinder) {
        String uriString;
        int index;
        URI realUri;
        if (uri == null || !"file".equals(uri.getScheme())) {
            return null;
        }
        IResource[] resources = resourceFinder.apply(uri);
        if (resources.length == 0 && !uri.equals(realUri = FileUtil.realURI((URI)uri))) {
            uri = realUri;
            resources = resourceFinder.apply(uri);
        }
        if (resources.length == 0 && "win32".equals(Platform.getOS()) && uri.toString().startsWith("file:////") && (index = (uriString = uri.toString()).indexOf(PATH_SEPARATOR, "file:////".length())) > 0) {
            String server = uriString.substring("file:////".length(), index);
            uriString = uriString.replace(server, server.toUpperCase());
            try {
                uri = new URI(uriString);
            }
            catch (URISyntaxException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
            resources = resourceFinder.apply(uri);
        }
        switch (resources.length) {
            case 0: {
                return null;
            }
            case 1: {
                return resources[0];
            }
        }
        IResource resource = null;
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource f = iResourceArray[n2];
            JavaLanguageServerPlugin.getProjectsManager();
            if (ProjectsManager.getDefaultProject().equals((Object)f.getProject())) {
                try {
                    f.delete(true, null);
                }
                catch (CoreException e) {
                    JavaLanguageServerPlugin.logException(e.getMessage(), e);
                }
            }
            if (resource == null || f.getProjectRelativePath().segmentCount() < resource.getProjectRelativePath().segmentCount()) {
                resource = f;
            }
            ++n2;
        }
        return resource;
    }

    public static URI toURI(String uriString) {
        if (uriString == null || uriString.isEmpty()) {
            return null;
        }
        try {
            URI uri = new URI(uriString);
            if ("win32".equals(Platform.getOS()) && URIUtil.isFileURI((URI)uri)) {
                uri = URIUtil.toFile((URI)uri).toURI();
            }
            return uri;
        }
        catch (URISyntaxException e) {
            JavaLanguageServerPlugin.logException("Failed to resolve " + uriString, e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isHiddenGeneratedElement(IJavaElement element) {
        if (!(element instanceof IAnnotatable)) return false;
        IAnnotatable annotable = (IAnnotatable)element;
        try {
            IAnnotation[] annotations = annotable.getAnnotations();
            if (annotations.length == 0) return false;
            IAnnotation[] iAnnotationArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IAnnotation annotation = iAnnotationArray[n2];
                if (JDTUtils.isSilencedGeneratedAnnotation(annotation)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return false;
    }

    private static boolean isSilencedGeneratedAnnotation(IAnnotation annotation) throws JavaModelException {
        if ("javax.annotation.Generated".equals(annotation.getElementName()) || "javax.annotation.processing.Generated".equals(annotation.getElementName())) {
            IMemberValuePair[] memberValuePairs;
            IMemberValuePair[] iMemberValuePairArray = memberValuePairs = annotation.getMemberValuePairs();
            int n = memberValuePairs.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair m = iMemberValuePairArray[n2];
                if ("value".equals(m.getMemberName()) && 9 == m.getValueKind()) {
                    if (m.getValue() instanceof String) {
                        return SILENCED_CODEGENS.contains(m.getValue());
                    }
                    Object object = m.getValue();
                    if (object instanceof Object[]) {
                        Object[] values;
                        Object[] objectArray = values = (Object[])object;
                        int n3 = values.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Object val = objectArray[n4];
                            if (SILENCED_CODEGENS.contains(val)) {
                                return true;
                            }
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    public static IJavaSearchScope createSearchScope(IJavaProject project, PreferenceManager preferenceManager) {
        IJavaProject[] elements = project == null ? ProjectUtils.getJavaProjects() : new IJavaProject[]{project};
        int scope = 1;
        if (preferenceManager != null && preferenceManager.isClientSupportsClassFileContent()) {
            scope |= 6;
        }
        return SearchEngine.createJavaSearchScope((IJavaElement[])elements, (int)scope);
    }

    public static boolean isOnClassPath(ICompilationUnit unit) {
        if (unit != null && unit.getJavaProject() != null) {
            IProject iProject = unit.getJavaProject().getProject();
            JavaLanguageServerPlugin.getProjectsManager();
            if (!iProject.equals((Object)ProjectsManager.getDefaultProject())) {
                return unit.getJavaProject().isOnClasspath((IJavaElement)unit);
            }
        }
        return false;
    }

    public static boolean isDefaultProject(ICompilationUnit unit) {
        if (unit != null && unit.getResource() != null) {
            IProject iProject = unit.getResource().getProject();
            JavaLanguageServerPlugin.getProjectsManager();
            if (iProject.equals((Object)ProjectsManager.getDefaultProject())) {
                return true;
            }
        }
        return false;
    }

    public static void setCompatibleVMs(String id) {
        IExecutionEnvironment[] environments;
        IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
        IExecutionEnvironment[] iExecutionEnvironmentArray = environments = manager.getExecutionEnvironments();
        int n = environments.length;
        int n2 = 0;
        while (n2 < n) {
            IVMInstall[] compatibleVMs;
            IExecutionEnvironment environment = iExecutionEnvironmentArray[n2];
            IVMInstall[] iVMInstallArray = compatibleVMs = environment.getCompatibleVMs();
            int n3 = compatibleVMs.length;
            int n4 = 0;
            while (n4 < n3) {
                IVMInstall compatibleVM = iVMInstallArray[n4];
                if (id.equals(compatibleVM.getVMInstallType().getId()) && compatibleVM.getVMInstallType().findVMInstall(compatibleVM.getId()) != null && !compatibleVM.equals(environment.getDefaultVM()) && (environment.getDefaultVM() == null || compatibleVM.getId().compareTo(environment.getDefaultVM().getId()) < 0)) {
                    environment.setDefaultVM(compatibleVM);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static IResource getFileOrFolder(String uriString) {
        IContainer parent;
        IFile file = JDTUtils.findFile(uriString);
        IContainer iContainer = parent = file == null ? null : file.getParent();
        if (parent == null) {
            return file;
        }
        try {
            parent.refreshLocal(1, null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (parent.findMember(file.getName()) instanceof IFolder) {
            return JDTUtils.findFolder(uriString);
        }
        return file;
    }

    public static String getConstantValue(IField field, ITypeRoot typeRoot, IRegion region) {
        if (field == null || !JDTUtils.isStaticFinal(field)) {
            return null;
        }
        ASTNode node = JDTUtils.getHoveredASTNode(typeRoot, region);
        Object constantValue = node != null ? JDTUtils.getVariableBindingConstValue(node, field) : JDTUtils.computeFieldConstantFromTypeAST(field, null);
        if (constantValue == null) {
            return null;
        }
        if (constantValue instanceof String) {
            String s = (String)constantValue;
            return ASTNodes.getEscapedStringLiteral((String)s);
        }
        if (constantValue instanceof Character) {
            return "'" + constantValue.toString() + "'";
        }
        return constantValue.toString();
    }

    public static boolean isStaticFinal(IField field) {
        try {
            return JdtFlags.isFinal((IMember)field) && JdtFlags.isStatic((IMember)field);
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.log((CoreException)((Object)e));
            return false;
        }
    }

    public static ASTNode getHoveredASTNode(ITypeRoot typeRoot, IRegion region) {
        if (typeRoot == null || region == null) {
            return null;
        }
        CompilationUnit unit = SharedASTProviderCore.getAST((ITypeRoot)typeRoot, (SharedASTProviderCore.WAIT_FLAG)SharedASTProviderCore.WAIT_ACTIVE_ONLY, null);
        if (unit == null) {
            return null;
        }
        return NodeFinder.perform((ASTNode)unit, (int)region.getOffset(), (int)region.getLength());
    }

    private static Object getVariableBindingConstValue(ASTNode node, IField field) {
        IVariableBinding variableBinding;
        IBinding binding;
        if (node != null && node.getNodeType() == 42 && (binding = ((SimpleName)node).resolveBinding()) != null && binding.getKind() == 3 && field.equals((variableBinding = (IVariableBinding)binding).getJavaElement())) {
            return variableBinding.getConstantValue();
        }
        return null;
    }

    public static Object computeFieldConstantFromTypeAST(IField constantField, IProgressMonitor monitor) {
        IBinding[] createBindings;
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        CompilationUnit ast = SharedASTProviderCore.getAST((ITypeRoot)constantField.getTypeRoot(), (SharedASTProviderCore.WAIT_FLAG)SharedASTProviderCore.WAIT_NO, (IProgressMonitor)monitor);
        if (ast != null) {
            Expression initializer;
            block13: {
                VariableDeclarationFragment fieldDecl;
                block12: {
                    block11: {
                        if (!constantField.isEnumConstant()) break block11;
                        return null;
                    }
                    fieldDecl = ASTNodeSearchUtil.getFieldDeclarationFragmentNode((IField)constantField, (CompilationUnit)ast);
                    if (fieldDecl != null) break block12;
                    return null;
                }
                initializer = fieldDecl.getInitializer();
                if (initializer != null) break block13;
                return null;
            }
            try {
                return initializer.resolveConstantExpressionValue();
            }
            catch (JavaModelException fieldDecl) {
                // empty catch block
            }
        }
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        ASTParser p = ASTParser.newParser((int)IASTSharedValues.SHARED_AST_LEVEL);
        p.setProject(constantField.getJavaProject());
        try {
            createBindings = p.createBindings(new IJavaElement[]{constantField}, monitor);
        }
        catch (OperationCanceledException e) {
            return null;
        }
        IBinding iBinding = createBindings[0];
        if (iBinding instanceof IVariableBinding) {
            IVariableBinding variableBinding = (IVariableBinding)iBinding;
            return variableBinding.getConstantValue();
        }
        return null;
    }

    public static String getAnnotationMemberDefaultValue(IMethod method, ITypeRoot typeRoot, IRegion hoverRegion) throws JavaModelException {
        Object[] values;
        IMemberValuePair memberValuePair = method.getDefaultValue();
        if (memberValuePair == null) {
            return null;
        }
        Object defaultValue = memberValuePair.getValue();
        boolean isEmptyArray = defaultValue instanceof Object[] && (values = (Object[])defaultValue).length == 0;
        int valueKind = memberValuePair.getValueKind();
        if (valueKind == 14 && !isEmptyArray) {
            IBinding binding = JDTUtils.getHoveredNodeBinding((IJavaElement)method, typeRoot, hoverRegion);
            if (binding instanceof IMethodBinding) {
                IMethodBinding methodBinding = (IMethodBinding)binding;
                Object value = methodBinding.getDefaultValue();
                StringBuilder buf = new StringBuilder();
                try {
                    JDTUtils.addValue(buf, value, false);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                return buf.toString();
            }
        } else if (defaultValue != null) {
            IAnnotation parentAnnotation = (IAnnotation)method.getAncestor(16);
            StringBuffer buf = new StringBuffer();
            new JavaElementLabelComposerCore(buf).appendAnnotationValue(parentAnnotation, defaultValue, valueKind, 4787310288012503L);
            return buf.toString();
        }
        return null;
    }

    private static void addValue(StringBuilder buf, Object value, boolean addLinks) throws URISyntaxException {
        if (value instanceof ITypeBinding) {
            ITypeBinding typeBinding = (ITypeBinding)value;
            IJavaElement type = typeBinding.getJavaElement();
            if (type == null || !addLinks) {
                buf.append(typeBinding.getName());
            } else {
                String uri = CoreJavaElementLinks.createURI((String)"eclipse-javadoc", (IJavaElement)type);
                String name = type.getElementName();
                JDTUtils.addLink(buf, uri, name);
            }
            buf.append(".class");
        } else if (value instanceof IVariableBinding) {
            IVariableBinding variableBinding = (IVariableBinding)value;
            IJavaElement variable = variableBinding.getJavaElement();
            if (variable == null || !addLinks) {
                buf.append(variableBinding.getName());
            } else {
                String uri = CoreJavaElementLinks.createURI((String)"eclipse-javadoc", (IJavaElement)variable);
                String name = variable.getElementName();
                JDTUtils.addLink(buf, uri, name);
            }
        } else if (value instanceof IAnnotationBinding) {
            IAnnotationBinding annotationBinding = (IAnnotationBinding)value;
            JDTUtils.addAnnotation(buf, annotationBinding, addLinks);
        } else if (value instanceof String) {
            String s = (String)value;
            buf.append(ASTNodes.getEscapedStringLiteral((String)s));
        } else if (value instanceof Character) {
            Character c = (Character)value;
            buf.append(ASTNodes.getEscapedCharacterLiteral((char)c.charValue()));
        } else if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            buf.append('{');
            int i = 0;
            while (i < values.length) {
                if (i > 0) {
                    buf.append(JavaElementLabelsCore.COMMA_STRING);
                }
                JDTUtils.addValue(buf, values[i], addLinks);
                ++i;
            }
            buf.append('}');
        } else {
            buf.append(String.valueOf(value));
        }
    }

    private static StringBuilder addLink(StringBuilder buf, String uri, String label) {
        return buf.append(CoreJavaElementLinks.createLink((String)uri, (String)label));
    }

    private static void addAnnotation(StringBuilder buf, IAnnotationBinding annotation, boolean addLinks) throws URISyntaxException {
        IJavaElement javaElement = annotation.getAnnotationType().getJavaElement();
        buf.append('@');
        if (javaElement == null || !addLinks) {
            buf.append(annotation.getName());
        } else {
            String uri = CoreJavaElementLinks.createURI((String)"eclipse-javadoc", (IJavaElement)javaElement);
            JDTUtils.addLink(buf, uri, annotation.getName());
        }
        IMemberValuePairBinding[] mvPairs = annotation.getDeclaredMemberValuePairs();
        if (mvPairs.length > 0) {
            buf.append('(');
            int j = 0;
            while (j < mvPairs.length) {
                if (j > 0) {
                    buf.append(JavaElementLabelsCore.COMMA_STRING);
                }
                IMemberValuePairBinding mvPair = mvPairs[j];
                if (addLinks) {
                    String memberURI = CoreJavaElementLinks.createURI((String)"eclipse-javadoc", (IJavaElement)mvPair.getMethodBinding().getJavaElement());
                    JDTUtils.addLink(buf, memberURI, mvPair.getName());
                } else {
                    buf.append(mvPair.getName());
                }
                buf.append('=');
                JDTUtils.addValue(buf, mvPair.getValue(), addLinks);
                ++j;
            }
            buf.append(')');
        }
    }

    private static IBinding getHoveredNodeBinding(IJavaElement element, ITypeRoot typeRoot, IRegion region) {
        IBinding binding;
        if (typeRoot == null || region == null) {
            return null;
        }
        ASTNode node = JDTUtils.getHoveredASTNode(typeRoot, region);
        if (node == null) {
            ASTParser p = ASTParser.newParser((int)IASTSharedValues.SHARED_AST_LEVEL);
            p.setProject(element.getJavaProject());
            p.setBindingsRecovery(true);
            try {
                binding = p.createBindings(new IJavaElement[]{element}, null)[0];
            }
            catch (OperationCanceledException e) {
                return null;
            }
        } else {
            binding = JDTUtils.resolveBinding(node);
        }
        return binding;
    }

    private static IBinding resolveBinding(ASTNode node) {
        if (node instanceof SimpleName) {
            SimpleName simpleName = (SimpleName)node;
            ASTNode normalized = ASTNodes.getNormalizedNode((ASTNode)simpleName);
            if (normalized.getLocationInParent() == ClassInstanceCreation.TYPE_PROPERTY) {
                ClassInstanceCreation cic = (ClassInstanceCreation)normalized.getParent();
                IMethodBinding constructorBinding = cic.resolveConstructorBinding();
                if (constructorBinding == null) {
                    return null;
                }
                ITypeBinding declaringClass = constructorBinding.getDeclaringClass();
                if (!declaringClass.isAnonymous()) {
                    return constructorBinding;
                }
                ITypeBinding superTypeDeclaration = declaringClass.getSuperclass().getTypeDeclaration();
                return JDTUtils.resolveSuperclassConstructor(superTypeDeclaration, constructorBinding);
            }
            return simpleName.resolveBinding();
        }
        if (node instanceof SuperConstructorInvocation) {
            SuperConstructorInvocation superConstructorInvocation = (SuperConstructorInvocation)node;
            return superConstructorInvocation.resolveConstructorBinding();
        }
        if (node instanceof ConstructorInvocation) {
            ConstructorInvocation constructorInvocation = (ConstructorInvocation)node;
            return constructorInvocation.resolveConstructorBinding();
        }
        if (node instanceof LambdaExpression) {
            LambdaExpression lambda = (LambdaExpression)node;
            return lambda.resolveMethodBinding();
        }
        return null;
    }

    private static IBinding resolveSuperclassConstructor(ITypeBinding superClassDeclaration, IMethodBinding constructor) {
        IMethodBinding[] methods = superClassDeclaration.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            IMethodBinding method = methods[i];
            if (method.isConstructor() && constructor.isSubsignature(method)) {
                return method;
            }
            ++i;
        }
        return null;
    }

    public static IField resolveField(CompletionProposal proposal, IJavaProject javaProject) throws JavaModelException {
        String name;
        IField field;
        char[] declarationSignature = proposal.getDeclarationSignature();
        if (declarationSignature == null) {
            return null;
        }
        String typeName = SignatureUtil.stripSignatureToFQN((String)String.valueOf(declarationSignature));
        IType type = javaProject.findType(typeName);
        if (type != null && (field = type.getField(name = String.valueOf(proposal.getName()))).exists()) {
            return field;
        }
        return null;
    }

    public static IMethod resolveMethod(CompletionProposal proposal, IJavaProject javaProject) throws JavaModelException {
        return JDTUtils.resolveMethod(proposal, javaProject, null);
    }

    public static IMethod resolveMethod(CompletionProposal proposal, IJavaProject javaProject, IProgressMonitor monitor) throws JavaModelException {
        char[] declarationSignature = proposal.getDeclarationSignature();
        String typeName = SignatureUtil.stripSignatureToFQN((String)String.valueOf(declarationSignature));
        IType type = javaProject.findType(typeName);
        if (type == null && monitor != null) {
            type = javaProject.findType(typeName, (IProgressMonitor)new NullProgressMonitor());
        }
        if (type != null) {
            MethodBinding methodBinding;
            MethodBinding original;
            InternalCompletionProposal internalProposal;
            Binding binding;
            String name = String.valueOf(proposal.getName());
            if (proposal.getKind() == 13) {
                IMethod method = type.getMethod(name, CharOperation.NO_STRINGS);
                if (method.exists()) {
                    return method;
                }
                return null;
            }
            char[] signature = proposal.getSignature();
            if (proposal instanceof InternalCompletionProposal && (binding = (internalProposal = (InternalCompletionProposal)proposal).getBinding()) instanceof MethodBinding && (original = (methodBinding = (MethodBinding)binding).original()) != binding) {
                signature = Engine.getSignature((MethodBinding)original);
            }
            String[] parameters = Signature.getParameterTypes((String)String.valueOf(SignatureUtil.fix83600((char[])signature)));
            int i = 0;
            while (i < parameters.length) {
                parameters[i] = SignatureUtil.getLowerBound((String)parameters[i]);
                ++i;
            }
            boolean isConstructor = proposal.isConstructor();
            return JavaModelUtil.findMethod((String)name, (String[])parameters, (boolean)isConstructor, (IType)type);
        }
        return null;
    }

    public static List<Location> searchDecompiledSources(IJavaElement element, IClassFile classFile, boolean ignoreMethodBody, boolean declaration, IProgressMonitor monitor) throws JavaModelException {
        String contents;
        PreferenceManager preferencesManager = JavaLanguageServerPlugin.getPreferencesManager();
        if (preferencesManager == null || !preferencesManager.isClientSupportsClassFileContent() || !preferencesManager.getPreferences().isIncludeDecompiledSources()) {
            return Collections.emptyList();
        }
        ContentProviderManager contentProvider = JavaLanguageServerPlugin.getContentProviderManager();
        try {
            contents = contentProvider.getSource(classFile, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
            return Collections.emptyList();
        }
        if (monitor != null && monitor.isCanceled()) {
            return Collections.emptyList();
        }
        ArrayList<Location> locations = new ArrayList<Location>();
        if (contents != null && !contents.isBlank()) {
            ICompilationUnit workingCopy = JDTUtils.getWorkingCopy(classFile, contents, monitor);
            try {
                ASTParser parser = ASTParser.newParser((int)IASTSharedValues.SHARED_AST_LEVEL);
                parser.setResolveBindings(true);
                parser.setKind(8);
                parser.setStatementsRecovery(false);
                parser.setBindingsRecovery(false);
                parser.setSource(workingCopy);
                parser.setIgnoreMethodBodies(ignoreMethodBody);
                CompilationUnit unit = (CompilationUnit)parser.createAST(monitor);
                ASTNode[] nodes = new ASTNode[1];
                if (monitor != null && monitor.isCanceled()) {
                    List<Location> list = Collections.emptyList();
                    return list;
                }
                unit.accept((ASTVisitor)new ClassFileVisitor(element, nodes, monitor));
                ASTNode node = nodes[0];
                if (monitor != null && monitor.isCanceled()) {
                    List<Location> list = Collections.emptyList();
                    return list;
                }
                if (node != null) {
                    IOccurrencesFinder.OccurrenceLocation[] occurrences;
                    String uriString = JDTUtils.toUri(classFile);
                    Document document = new Document(contents);
                    if (declaration) {
                        Range range;
                        int offset = node.getStartPosition();
                        int length = node.getLength();
                        if (offset >= 0 && length > 0 && offset + length <= contents.length()) {
                            int[] start = JsonRpcHelpers.toLine((IDocument)document, offset);
                            int[] end = JsonRpcHelpers.toLine((IDocument)document, offset + length);
                            range = new Range(new Position(start[0], start[1]), new Position(end[0], end[1]));
                        } else {
                            range = new Range();
                        }
                        Location location = new Location(uriString, range);
                        locations.add(location);
                        ArrayList<Location> arrayList = locations;
                        return arrayList;
                    }
                    OccurrencesFinder finder = new OccurrencesFinder();
                    if (node instanceof MethodDeclaration) {
                        MethodDeclaration methodDecl = (MethodDeclaration)node;
                        SimpleName name = methodDecl.getName();
                        finder.initialize(unit, (ASTNode)name);
                    } else if (node instanceof Name) {
                        finder.initialize(unit, node);
                    } else if (node instanceof MethodInvocation) {
                        MethodInvocation methodInvocation = (MethodInvocation)node;
                        SimpleName start = methodInvocation.getName();
                    } else {
                        ArrayList<Location> arrayList = locations;
                        return arrayList;
                    }
                    IOccurrencesFinder.OccurrenceLocation[] occurrenceLocationArray = occurrences = finder.getOccurrences();
                    int n = occurrences.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Range range;
                        IOccurrencesFinder.OccurrenceLocation occurrence = occurrenceLocationArray[n2];
                        int offset = occurrence.getOffset();
                        int length = occurrence.getLength();
                        if (offset >= 0 && length > 0 && offset + length <= contents.length()) {
                            int[] start = JsonRpcHelpers.toLine((IDocument)document, offset);
                            int[] end = JsonRpcHelpers.toLine((IDocument)document, offset + length);
                            range = new Range(new Position(start[0], start[1]), new Position(end[0], end[1]));
                        } else {
                            range = new Range();
                        }
                        Location location = new Location(uriString, range);
                        locations.add(location);
                        ++n2;
                    }
                } else {
                    Location location = JDTUtils.toLocation(classFile, 0, 0);
                    locations.add(location);
                }
            }
            finally {
                if (workingCopy != null) {
                    workingCopy.discardWorkingCopy();
                }
            }
        }
        return locations;
    }

    public static ICompilationUnit getWorkingCopy(IClassFile classFile, String contents, IProgressMonitor monitor) throws JavaModelException {
        Object name = classFile.getElementName().replace(".class", ".java");
        IPackageFragment fragment = (IPackageFragment)classFile.getAncestor(4);
        if (!fragment.getElementName().isEmpty()) {
            name = fragment.getElementName().replace(PERIOD, PATH_SEPARATOR) + PATH_SEPARATOR + (String)name;
        }
        IClasspathEntry[] existingEntries = classFile.getJavaProject().getRawClasspath();
        Path path = new Path((String)name);
        IClasspathEntry[] iClasspathEntryArray = existingEntries;
        int n = existingEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3) {
                IPath srcPath = entry.getPath();
                path = srcPath.append((String)name).makeRelative().removeFirstSegments(1);
                break;
            }
            ++n2;
        }
        IFile file = classFile.getJavaProject().getProject().getFile((IPath)path);
        ICompilationUnit sourceUnit = JavaCore.createCompilationUnitFrom((IFile)file);
        ICompilationUnit workingCopy = sourceUnit.getWorkingCopy(new WorkingCopyOwner(){}, monitor);
        workingCopy.getBuffer().setContents(contents);
        workingCopy.becomeWorkingCopy(monitor);
        workingCopy.reconcile(0, false, null, monitor);
        if (monitor.isCanceled()) {
            workingCopy.discardWorkingCopy();
            return null;
        }
        return workingCopy;
    }

    public static boolean isExcludedFile(List<String> patterns, String uriString) {
        if (patterns.isEmpty()) {
            return false;
        }
        URI uri = JDTUtils.toURI(uriString);
        if (uri == null) {
            return false;
        }
        java.nio.file.Path[] path = new java.nio.file.Path[1];
        try {
            path[0] = Paths.get(uri.toURL().getPath(), new String[0]);
        }
        catch (MalformedURLException e) {
            path[0] = Paths.get(uri);
        }
        FileSystem fileSystems = path[0].getFileSystem();
        return !patterns.stream().filter(pattern -> fileSystems.getPathMatcher("glob:" + pattern).matches(path[0])).collect(Collectors.toList()).isEmpty();
    }

    public static boolean isGenerated(IMember member) {
        boolean result = false;
        try {
            result = member.getNameRange().getLength() <= 0 || member.getNameRange().equals(member.getSourceRange());
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return result;
    }

    public static boolean isUnnamedClass(IJavaElement element) {
        try {
            return element.getElementType() == 7 && ((IType)element).isImplicitlyDeclared();
        }
        catch (JavaModelException e) {
            return false;
        }
    }

    private static final class ClassFileVisitor
    extends ASTVisitor {
        private final IJavaElement element;
        private final IProgressMonitor monitor;
        private final ASTNode[] nodes;

        private ClassFileVisitor(IJavaElement element, ASTNode[] nodes, IProgressMonitor monitor) {
            this.element = element;
            this.monitor = monitor;
            this.nodes = nodes;
        }

        public boolean visit(SimpleName node) {
            if (this.element.getElementName().equals(node.getIdentifier()) && this.find(this.element, this.nodes, node)) {
                return false;
            }
            if (this.monitor != null && this.monitor.isCanceled()) {
                return false;
            }
            return super.visit(node);
        }

        public boolean visit(MethodInvocation node) {
            List astParameters;
            IMethod method;
            String[] parameters;
            IJavaElement iJavaElement;
            if (this.element.getElementName().equals(node.getName().getIdentifier()) && (iJavaElement = this.element) instanceof IMethod && (parameters = (method = (IMethod)iJavaElement).getParameterTypes()).length == (astParameters = node.typeArguments()).size()) {
                int size = astParameters.size();
                String[] astParameterTypes = new String[size];
                Iterator iterator = astParameters.iterator();
                int i = 0;
                while (i < size) {
                    Type parameter = (Type)iterator.next();
                    astParameterTypes[i] = this.getSignature(parameter);
                    ++i;
                }
                if (this.equals(parameters, astParameterTypes)) {
                    this.nodes[0] = node;
                    return false;
                }
            }
            if (this.monitor != null && this.monitor.isCanceled()) {
                return false;
            }
            return super.visit(node);
        }

        public boolean visit(MethodDeclaration node) {
            IJavaElement iJavaElement;
            if (this.element.getElementName().equals(node.getName().getIdentifier()) && (iJavaElement = this.element) instanceof IMethod) {
                List astParameters;
                IMethod method = (IMethod)iJavaElement;
                String[] parameters = method.getParameterTypes();
                IMethodBinding binding = node.resolveBinding();
                if (binding != null) {
                    ITypeBinding[] types = binding.getParameterTypes();
                    if (types.length != parameters.length) {
                        return false;
                    }
                    String[] astParameterTypes = new String[types.length];
                    int i = 0;
                    while (i < types.length) {
                        ITypeBinding type = types[i];
                        String fullName = type.getQualifiedName();
                        astParameterTypes[i] = Signature.createTypeSignature((String)fullName, (boolean)true);
                        ++i;
                    }
                    if (this.equals(parameters, astParameterTypes)) {
                        this.nodes[0] = node;
                        return false;
                    }
                }
                if (parameters.length == (astParameters = node.parameters()).size()) {
                    int size = astParameters.size();
                    String[] astParameterTypes = new String[size];
                    Iterator iterator = astParameters.iterator();
                    int i = 0;
                    while (i < size) {
                        SingleVariableDeclaration parameter = (SingleVariableDeclaration)iterator.next();
                        String typeSig = this.getSignature(parameter.getType());
                        int extraDimensions = parameter.getExtraDimensions();
                        if (node.isVarargs() && i == size - 1) {
                            ++extraDimensions;
                        }
                        astParameterTypes[i] = Signature.createArraySignature((String)typeSig, (int)extraDimensions);
                        ++i;
                    }
                    if (this.equals(parameters, astParameterTypes)) {
                        this.nodes[0] = node;
                        return false;
                    }
                }
            }
            if (this.monitor != null && this.monitor.isCanceled()) {
                return false;
            }
            return super.visit(node);
        }

        private boolean equals(String[] parameters, String[] parameterTypes) {
            boolean isSame = true;
            int i = 0;
            while (i < parameters.length) {
                if (!parameters[i].equals(parameterTypes[i])) {
                    isSame = false;
                    break;
                }
                ++i;
            }
            return isSame;
        }

        private String getSignature(Type type) {
            String signature = Util.getSignature((Type)type);
            String packageName = Signature.getSignatureQualifier((String)signature);
            String typeName = Signature.getSignatureSimpleName((String)signature);
            String fullName = "".equals(packageName) ? typeName : packageName + JDTUtils.PERIOD + typeName;
            signature = Signature.createTypeSignature((String)fullName, (boolean)true);
            return signature;
        }

        private boolean find(IJavaElement element, ASTNode[] nodes, SimpleName node) {
            ASTNode parent = node.getParent();
            boolean found = false;
            switch (parent.getNodeType()) {
                case 81: 
                case 82: {
                    found = element.getElementType() == 16;
                    break;
                }
                case 22: 
                case 23: 
                case 71: 
                case 72: {
                    found = element.getElementType() == 8 || element.getElementType() == 7;
                    break;
                }
                case 90: {
                    found = element.getElementType() == 9;
                    break;
                }
                case 55: 
                case 58: 
                case 59: 
                case 60: {
                    found = element.getElementType() == 7 || element.getElementType() == 8 || element.getElementType() == 9;
                    break;
                }
            }
            if (found) {
                nodes[0] = node;
            }
            return found;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum LocationType {
        NAME_RANGE{

            @Override
            ISourceRange getRange(IJavaElement element) throws JavaModelException {
                return JDTUtils.getNameRange(element);
            }
        }
        ,
        FULL_RANGE{

            @Override
            ISourceRange getRange(IJavaElement element) throws JavaModelException {
                return JDTUtils.getSourceRange(element);
            }
        };


        abstract ISourceRange getRange(IJavaElement var1) throws JavaModelException;

        public Location toLocation(IJavaElement element) throws JavaModelException {
            return JDTUtils.toLocation(element, this);
        }
    }
}

