/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import org.eclipse.jdt.internal.compiler.ast.FakeDefaultLiteral;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.Pattern;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.RecordPattern;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.SwitchStatement;
import org.eclipse.jdt.internal.compiler.ast.TypePattern;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.IntConstant;
import org.eclipse.jdt.internal.compiler.impl.JavaFeature;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class CaseStatement
extends Statement {
    public BranchLabel targetLabel;
    public Expression[] constantExpressions;
    public BranchLabel[] targetLabels;
    public boolean isExpr = false;
    public SwitchStatement swich;
    public int typeSwitchIndex;

    public CaseStatement(Expression[] constantExpressions, int sourceStart, int sourceEnd) {
        this.constantExpressions = constantExpressions;
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
    }

    public Expression[] peeledLabelExpressions() {
        Expression[] constants = Expression.NO_EXPRESSIONS;
        Expression[] expressionArray = this.constantExpressions;
        int n = this.constantExpressions.length;
        int n2 = 0;
        while (n2 < n) {
            Expression e = expressionArray[n2];
            if (e instanceof Pattern) {
                Pattern p1 = (Pattern)e;
                constants = (Expression[])Stream.concat(Arrays.stream(constants), Arrays.stream(p1.getAlternatives())).toArray(Expression[]::new);
            } else {
                constants = (Expression[])Stream.concat(Arrays.stream(constants), Stream.of(e)).toArray(Expression[]::new);
            }
            ++n2;
        }
        return constants;
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        int nullPatternCount = 0;
        int i = 0;
        int length = this.constantExpressions.length;
        while (i < length) {
            LocalVariableBinding binding;
            Expression e = this.constantExpressions[i];
            LocalVariableBinding[] localVariableBindingArray = e.bindingsWhenTrue();
            int n = localVariableBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                LocalVariableBinding local = localVariableBindingArray[n2];
                local.useFlag = 1;
                ++n2;
            }
            if (!(i <= 0 || !(e instanceof Pattern) || JavaFeature.UNNAMMED_PATTERNS_AND_VARS.isSupported(currentScope.compilerOptions().sourceLevel, currentScope.compilerOptions().enablePreviewFeatures) || i == (nullPatternCount += e instanceof NullLiteral ? 1 : 0) && e instanceof TypePattern)) {
                currentScope.problemReporter().IllegalFallThroughToPattern(e);
            }
            flowInfo = this.analyseConstantExpression(currentScope, flowContext, flowInfo, e);
            if (nullPatternCount > 0 && e instanceof TypePattern && (binding = ((TypePattern)e).local.binding) != null) {
                flowInfo.markNullStatus(binding, 16);
            }
            ++i;
        }
        return flowInfo;
    }

    private FlowInfo analyseConstantExpression(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, Expression e) {
        if (e.constant == Constant.NotAConstant && !e.resolvedType.isEnum()) {
            Expression switchValue;
            boolean caseNullorDefaultAllowed;
            boolean bl = caseNullorDefaultAllowed = JavaFeature.PATTERN_MATCHING_IN_SWITCH.isSupported(currentScope.compilerOptions()) && (e instanceof NullLiteral || e instanceof FakeDefaultLiteral || e instanceof Pattern);
            if (!caseNullorDefaultAllowed) {
                currentScope.problemReporter().caseExpressionMustBeConstant(e);
            }
            if (e instanceof NullLiteral && flowContext.associatedNode instanceof SwitchStatement && (switchValue = ((SwitchStatement)flowContext.associatedNode).expression) != null && switchValue.nullStatus(flowInfo, flowContext) == 4) {
                currentScope.problemReporter().unnecessaryNullCaseInSwitchOverNonNull(this);
            }
        }
        return e.analyseCode(currentScope, flowContext, flowInfo);
    }

    @Override
    public void resolve(BlockScope scope) {
    }

    public ResolvedCase[] resolveCase(BlockScope scope, TypeBinding switchExpressionType, SwitchStatement switchStatement) {
        this.swich = switchStatement;
        scope.enclosingCase = this;
        if (this.constantExpressions == Expression.NO_EXPRESSIONS) {
            this.checkDuplicateDefault(scope, switchStatement, this);
            return ResolvedCase.UnresolvedCase;
        }
        switchStatement.cases[switchStatement.caseCount++] = this;
        ArrayList<ResolvedCase> cases = new ArrayList<ResolvedCase>();
        int count = 0;
        int nullCaseCount = 0;
        boolean hasResolveErrors = false;
        Expression[] expressionArray = this.constantExpressions;
        int n = this.constantExpressions.length;
        int n2 = 0;
        while (n2 < n) {
            block24: {
                TypeBinding caseType;
                Expression e;
                block26: {
                    block25: {
                        block23: {
                            e = expressionArray[n2];
                            ++count;
                            if (!(e instanceof FakeDefaultLiteral)) break block23;
                            this.checkDuplicateDefault(scope, switchStatement, this.constantExpressions.length > 1 ? e : this);
                            if (count != 2 || nullCaseCount < 1) {
                                scope.problemReporter().patternSwitchCaseDefaultOnlyAsSecond(e);
                            }
                            break block24;
                        }
                        if (e instanceof NullLiteral) {
                            if (switchStatement.nullCase == null) {
                                switchStatement.nullCase = this;
                            }
                            if (count > 1 && ++nullCaseCount < 2) {
                                scope.problemReporter().patternSwitchNullOnlyOrFirstWithDefault(e);
                            }
                        }
                        if (switchExpressionType == null || !switchExpressionType.isEnum() || !(e instanceof SingleNameReference)) break block25;
                        ((SingleNameReference)e).setActualReceiverType((ReferenceBinding)switchExpressionType);
                        break block26;
                    }
                    if (e instanceof FakeDefaultLiteral) break block24;
                }
                e.setExpressionContext(ExpressionContext.TESTING_CONTEXT);
                if (e instanceof Pattern) {
                    Pattern p = (Pattern)e;
                    p.setOuterExpressionType(switchExpressionType);
                }
                if ((caseType = e.resolveType(scope)) == null || switchExpressionType == null) {
                    hasResolveErrors = true;
                } else if (caseType.isValidBinding()) {
                    if (e instanceof Pattern) {
                        Pattern[] patternArray = ((Pattern)e).getAlternatives();
                        int n3 = patternArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Pattern p = patternArray[n4];
                            Constant con = this.resolveCasePattern(scope, p.resolvedType, switchExpressionType, switchStatement, p, ((Pattern)e).isUnguarded());
                            if (con != Constant.NotAConstant) {
                                int index;
                                ++switchStatement.constantIndex;
                                cases.add(new ResolvedCase(con, p, p.resolvedType, index, false));
                            }
                            ++n4;
                        }
                    } else {
                        TypeBinding expectedCaseType = switchExpressionType;
                        if (switchExpressionType.isBoxedPrimitiveType()) {
                            expectedCaseType = scope.environment().computeBoxingType(switchExpressionType);
                        }
                        switch (expectedCaseType.id) {
                            case 5: 
                            case 7: 
                            case 8: 
                            case 9: {
                                if (caseType.id != expectedCaseType.id) {
                                    scope.problemReporter().caseExpressionWrongType(e, switchExpressionType, expectedCaseType);
                                    break;
                                }
                                switchExpressionType = expectedCaseType;
                            }
                            default: {
                                int n5;
                                Constant con = this.resolveConstantExpression(scope, caseType, switchExpressionType, switchStatement, e, cases);
                                if (con == Constant.NotAConstant) break;
                                if (this == switchStatement.nullCase && e instanceof NullLiteral) {
                                    n5 = -1;
                                } else {
                                    int n6 = switchStatement.constantIndex;
                                    n5 = n6;
                                    switchStatement.constantIndex = n6 + 1;
                                }
                                int index = n5;
                                cases.add(new ResolvedCase(con, e, caseType, index, false));
                            }
                        }
                    }
                }
            }
            ++n2;
        }
        return hasResolveErrors ? ResolvedCase.UnresolvedCase : cases.toArray(new ResolvedCase[cases.size()]);
    }

    private void checkDuplicateDefault(BlockScope scope, SwitchStatement switchStatement, ASTNode node) {
        if (switchStatement.defaultCase != null) {
            scope.problemReporter().duplicateDefaultCase(node);
        } else if ((switchStatement.switchBits & 4) != 0) {
            scope.problemReporter().illegalTotalPatternWithDefault(this);
        }
        switchStatement.defaultCase = this;
    }

    @Override
    public LocalVariableBinding[] bindingsWhenTrue() {
        LocalVariableBinding[] variables = NO_VARIABLES;
        Expression[] expressionArray = this.constantExpressions;
        int n = this.constantExpressions.length;
        int n2 = 0;
        while (n2 < n) {
            Expression e = expressionArray[n2];
            variables = LocalVariableBinding.merge(variables, e.bindingsWhenTrue());
            ++n2;
        }
        return variables;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Constant resolveConstantExpression(BlockScope scope, TypeBinding caseType, TypeBinding switchType, SwitchStatement switchStatement, Expression expression, List<ResolvedCase> cases) {
        boolean boxing;
        CompilerOptions options = scope.compilerOptions();
        boolean patternSwitchAllowed = JavaFeature.PATTERN_MATCHING_IN_SWITCH.isSupported(options);
        if (patternSwitchAllowed) {
            if (expression instanceof Pattern) {
                throw new AssertionError((Object)"Unexpected control flow");
            }
            if (expression instanceof NullLiteral) {
                if (!caseType.isCompatibleWith(switchType, scope)) {
                    scope.problemReporter().caseConstantIncompatible(TypeBinding.NULL, switchType, expression);
                }
                switchStatement.switchBits |= 2;
                return IntConstant.fromValue(-1);
            }
            if (!(expression instanceof FakeDefaultLiteral) && switchStatement.isNonTraditional && switchType.isBaseType() && !expression.isConstantValueOfTypeAssignableToType(caseType, switchType)) {
                scope.problemReporter().caseConstantIncompatible(caseType, switchType, expression);
                return Constant.NotAConstant;
            }
        }
        boolean bl = boxing = !patternSwitchAllowed || switchStatement.isAllowedType(switchType);
        if (expression.isConstantValueOfTypeAssignableToType(caseType, switchType) || caseType.isCompatibleWith(switchType) && !(expression instanceof StringLiteral)) {
            if (!caseType.isEnum()) return expression.constant;
            if ((expression.bits & 0x1FE00000) >> 21 != 0) {
                scope.problemReporter().enumConstantsCannotBeSurroundedByParenthesis(expression);
            }
            if (expression instanceof NameReference && (expression.bits & 7) == 1) {
                NameReference reference = (NameReference)expression;
                FieldBinding field = reference.fieldBinding();
                if ((field.modifiers & 0x4000) == 0) {
                    scope.problemReporter().enumSwitchCannotTargetField(reference, field);
                    return IntConstant.fromValue(field.original().id + 1);
                } else {
                    if (!(reference instanceof QualifiedNameReference)) return IntConstant.fromValue(field.original().id + 1);
                    if (options.complianceLevel < 0x410000L) {
                        scope.problemReporter().cannotUseQualifiedEnumConstantInCaseLabel(reference, field);
                        return IntConstant.fromValue(field.original().id + 1);
                    } else {
                        if (TypeBinding.equalsEquals(caseType, switchType)) return IntConstant.fromValue(field.original().id + 1);
                        switchStatement.switchBits |= 0x10;
                        StringConstant constant = (StringConstant)StringConstant.fromValue(new String(field.name));
                        cases.add(new ResolvedCase(constant, expression, caseType, -1, true));
                        return Constant.NotAConstant;
                    }
                }
            }
        } else if (boxing && this.isBoxingCompatible(caseType, switchType, expression, scope)) {
            return expression.constant;
        }
        scope.problemReporter().caseConstantIncompatible(expression.resolvedType, switchType, expression);
        return Constant.NotAConstant;
    }

    private Constant resolveCasePattern(BlockScope scope, TypeBinding caseType, TypeBinding switchExpressionType, SwitchStatement switchStatement, Pattern e, boolean isUnguarded) {
        Constant constant = Constant.NotAConstant;
        TypeBinding type = e.resolvedType;
        if (type != null) {
            constant = IntConstant.fromValue(switchStatement.constantIndex);
            switchStatement.caseLabelElements.add(e);
            if (isUnguarded) {
                switchStatement.caseLabelElementTypes.add(type);
            }
            TypeBinding expressionType = switchStatement.expression.resolvedType;
            if (!type.isReifiable()) {
                boolean isLegal;
                if (!(expressionType == TypeBinding.NULL || e instanceof RecordPattern || (isLegal = e.checkCastTypesCompatibility(scope, type, expressionType, e, false)) && (e.bits & 0x80) == 0)) {
                    scope.problemReporter().unsafeCastInInstanceof(e, type, expressionType);
                }
            } else if (type.isValidBinding()) {
                if (Pattern.findPrimitiveConversionRoute(type, expressionType, scope) == Pattern.PrimitiveConversionRoute.NO_CONVERSION_ROUTE) {
                    if (type.isPrimitiveType() && !JavaFeature.PRIMITIVES_IN_PATTERNS.isSupported(scope.compilerOptions())) {
                        scope.problemReporter().unexpectedTypeinSwitchPattern(type, e);
                        return Constant.NotAConstant;
                    }
                    if (!e.checkCastTypesCompatibility(scope, type, expressionType, null, false)) {
                        scope.problemReporter().typeMismatchError(expressionType, type, e, null);
                        return Constant.NotAConstant;
                    }
                } else {
                    this.swich.isPrimitiveSwitch = true;
                }
            }
            if (e.coversType(expressionType, scope)) {
                switchStatement.switchBits |= 8;
                e.isTotalTypeNode = true;
                if (e.isUnconditional(expressionType, scope)) {
                    switchStatement.switchBits |= 4;
                }
                if (switchStatement.nullCase == null) {
                    constant = IntConstant.fromValue(-1);
                }
            }
        }
        return constant;
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        if (this.targetLabels != null) {
            BranchLabel[] branchLabelArray = this.targetLabels;
            int n = this.targetLabels.length;
            int n2 = 0;
            while (n2 < n) {
                BranchLabel label = branchLabelArray[n2];
                label.place();
                ++n2;
            }
        }
        if (this.targetLabel != null) {
            this.targetLabel.place();
        }
        if (this.containsPatternVariable(true)) {
            BranchLabel patternMatchLabel = new BranchLabel(codeStream);
            BranchLabel matchFailLabel = new BranchLabel(codeStream);
            Pattern pattern = (Pattern)this.constantExpressions[0];
            codeStream.load(this.swich.dispatchPatternCopy);
            pattern.generateCode(currentScope, codeStream, patternMatchLabel, matchFailLabel);
            codeStream.goto_(patternMatchLabel);
            matchFailLabel.place();
            if (pattern.matchFailurePossible()) {
                LocalVariableBinding[] bindingsWhenTrue = pattern.bindingsWhenTrue();
                Stream.of(bindingsWhenTrue).forEach(v -> v.recordInitializationEndPC(codeStream.position));
                int caseIndex = this.typeSwitchIndex + pattern.getAlternatives().length;
                codeStream.loadInt(this.swich.nullProcessed ? caseIndex - 1 : caseIndex);
                codeStream.store(this.swich.restartIndexLocal, false);
                codeStream.goto_(this.swich.switchPatternRestartTarget);
                Stream.of(bindingsWhenTrue).forEach(v -> v.recordInitializationStartPC(codeStream.position));
            }
            patternMatchLabel.place();
        } else if (this.swich.containsNull) {
            this.swich.nullProcessed |= true;
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    @Override
    public StringBuilder printStatement(int tab, StringBuilder output) {
        CaseStatement.printIndent(tab, output);
        if (this.constantExpressions == Expression.NO_EXPRESSIONS) {
            output.append("default ");
            output.append(this.isExpr ? "->" : ":");
        } else {
            output.append("case ");
            int i = 0;
            int l = this.constantExpressions.length;
            while (i < l) {
                this.constantExpressions[i].printExpression(0, output);
                if (i < l - 1) {
                    output.append(',');
                }
                ++i;
            }
            output.append(this.isExpr ? " ->" : " :");
        }
        return output;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            Expression[] expressionArray = this.constantExpressions;
            int n = this.constantExpressions.length;
            int n2 = 0;
            while (n2 < n) {
                Expression e = expressionArray[n2];
                e.traverse(visitor, blockScope);
                ++n2;
            }
        }
        visitor.endVisit(this, blockScope);
    }

    public static class ResolvedCase {
        static final ResolvedCase[] UnresolvedCase = new ResolvedCase[0];
        public Constant c;
        public Expression e;
        public TypeBinding t;
        public int index;
        private int intValue;
        private final boolean isPattern;
        private final boolean isQualifiedEnum;
        public int enumDescIdx;
        public int classDescIdx;
        public int primitivesBootstrapIdx;

        ResolvedCase(Constant c, Expression e, TypeBinding t, int index, boolean isQualifiedEnum) {
            this.c = c;
            this.e = e;
            this.t = t;
            this.index = index;
            this.intValue = c.typeID() == 11 ? c.stringValue().hashCode() : c.intValue();
            this.isPattern = e instanceof Pattern;
            this.isQualifiedEnum = isQualifiedEnum;
        }

        public int intValue() {
            return this.intValue;
        }

        public boolean isPattern() {
            return this.isPattern;
        }

        public boolean isQualifiedEnum() {
            return this.isQualifiedEnum;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("case ");
            builder.append(this.e);
            builder.append(" [CONSTANT=");
            builder.append(this.c);
            builder.append("]");
            return builder.toString();
        }
    }
}

