/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.syntaxserver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.JobHelpers;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.managers.IBuildSupport;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.lsp4j.DidChangeWatchedFilesRegistrationOptions;
import org.eclipse.lsp4j.FileSystemWatcher;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class SyntaxProjectsManager
extends ProjectsManager {
    private static final List<String> basicWatchers = Arrays.asList("**/*.java");
    private final Set<String> watchers = new LinkedHashSet<String>();
    private Job registerWatcherJob = new Job("Register Watchers"){

        protected IStatus run(IProgressMonitor monitor) {
            try {
                JobHelpers.waitForWorkspaceJobsToComplete((IProgressMonitor)new NullProgressMonitor());
                SyntaxProjectsManager.this.registerWatchers();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return Status.OK_STATUS;
        }
    };

    public SyntaxProjectsManager(PreferenceManager preferenceManager) {
        super(preferenceManager);
    }

    @Override
    public void cleanInvalidProjects(Collection<IPath> rootPaths, IProgressMonitor monitor) {
        List syntaxProjects = rootPaths.stream().map(rootPath -> ProjectUtils.getWorkspaceInvisibleProjectName(rootPath)).collect(Collectors.toList());
        IProject[] iProjectArray = ProjectUtils.getAllProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (!project.equals((Object)SyntaxProjectsManager.getDefaultProject())) {
                if (project.exists() && syntaxProjects.contains(project.getName())) {
                    try {
                        project.getDescription();
                    }
                    catch (CoreException e) {
                        try {
                            project.delete(true, monitor);
                        }
                        catch (CoreException e1) {
                            JavaLanguageServerPlugin.logException(e1.getMessage(), e1);
                        }
                    }
                } else {
                    try {
                        project.delete(false, true, monitor);
                    }
                    catch (CoreException e1) {
                        JavaLanguageServerPlugin.logException(e1.getMessage(), e1);
                    }
                }
            }
            ++n2;
        }
    }

    @Override
    protected void importProjects(Collection<IPath> rootPaths, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
    }

    @Override
    public void registerWatchers(boolean runInJob) {
        if (runInJob) {
            this.registerWatcherJob.schedule();
        } else {
            this.registerWatchers();
        }
    }

    @Override
    public List<FileSystemWatcher> registerWatchers() {
        JavaLanguageServerPlugin.logInfo(">> registerFeature 'workspace/didChangeWatchedFiles'");
        if (JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences().isWorkspaceChangeWatchedFilesDynamicRegistered()) {
            IPath[] sources = new IPath[]{};
            try {
                sources = SyntaxProjectsManager.listAllSourcePaths();
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
            ArrayList<FileSystemWatcher> fileWatchers = new ArrayList<FileSystemWatcher>();
            LinkedHashSet<String> patterns = new LinkedHashSet<String>(basicWatchers);
            patterns.addAll(Stream.of(sources).map(ResourceUtils::toGlobPattern).collect(Collectors.toList()));
            for (String pattern : patterns) {
                FileSystemWatcher watcher = new FileSystemWatcher(Either.forLeft((Object)pattern));
                fileWatchers.add(watcher);
            }
            if (!patterns.equals(this.watchers)) {
                JavaLanguageServerPlugin.logInfo(">> registerFeature 'workspace/didChangeWatchedFiles'");
                DidChangeWatchedFilesRegistrationOptions didChangeWatchedFilesRegistrationOptions = new DidChangeWatchedFilesRegistrationOptions(fileWatchers);
                JavaLanguageServerPlugin.getInstance().unregisterCapability(Preferences.WORKSPACE_WATCHED_FILES_ID, "workspace/didChangeWatchedFiles");
                JavaLanguageServerPlugin.getInstance().registerCapability(Preferences.WORKSPACE_WATCHED_FILES_ID, "workspace/didChangeWatchedFiles", didChangeWatchedFilesRegistrationOptions);
                this.watchers.clear();
                this.watchers.addAll(patterns);
            }
            return fileWatchers;
        }
        return Collections.emptyList();
    }

    private static IPath[] listAllSourcePaths() throws JavaModelException {
        IProject[] projects;
        HashSet<IPath> classpaths = new HashSet<IPath>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject javaProject;
            IProject project = iProjectArray[n2];
            if (!"jdt.ls-java-project".equals(project.getName()) && (javaProject = JavaCore.create((IProject)project)) != null && javaProject.exists()) {
                IClasspathEntry[] classpath;
                IClasspathEntry[] iClasspathEntryArray = classpath = javaProject.getRawClasspath();
                int n3 = classpath.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPath location;
                    IFolder folder;
                    IPath path;
                    IClasspathEntry entry = iClasspathEntryArray[n4];
                    if (entry.getEntryKind() == 3 && (path = entry.getPath()) != null && (folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path)).exists() && !folder.isDerived() && (location = folder.getLocation()) != null && !ResourceUtils.isContainedIn(location, classpaths)) {
                        classpaths.add(location);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return classpaths.toArray(new IPath[classpaths.size()]);
    }

    @Override
    public void fileChanged(String uriString, ProjectsManager.CHANGE_TYPE changeType) {
        if (uriString == null) {
            return;
        }
        IResource resource = JDTUtils.getFileOrFolder(uriString);
        if (resource == null) {
            return;
        }
        try {
            Optional<IBuildSupport> bs = this.getBuildSupport(resource.getProject());
            if (bs.isPresent()) {
                IBuildSupport buildSupport = bs.get();
                buildSupport.fileChanged(resource, changeType, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Problem refreshing workspace", e);
        }
    }
}

