/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.markers;

public class SourceLocation {
    private final String resourcePath;
    private final String resourceId;
    private final int lineNumber;
    private final int columnStart;
    private final int columnEnd;
    private SourceLocation linkedLocation;

    public SourceLocation(int lineNumber, int columnStart, int columnEnd) {
        this(null, null, lineNumber, columnStart, columnEnd);
    }

    public SourceLocation(int lineNumber, int columnStart, int columnEnd, SourceLocation linkedLocation) {
        this(null, null, lineNumber, columnStart, columnEnd);
        this.linkedLocation = linkedLocation;
    }

    public SourceLocation(String resourcePath, String resourceId, int lineNumber, int columnStart, int columnEnd) {
        this.resourcePath = resourcePath;
        this.resourceId = resourceId;
        this.lineNumber = lineNumber;
        this.columnStart = columnStart;
        this.columnEnd = columnEnd;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnStart() {
        return this.columnStart;
    }

    public int getColumnEnd() {
        return this.columnEnd;
    }

    public SourceLocation getLinkedLocation() {
        return this.linkedLocation;
    }

    public String toString() {
        String s = String.valueOf(this.lineNumber) + "," + this.columnStart + "-" + this.columnEnd + ":" + this.resourcePath;
        if (this.linkedLocation != null) {
            s = String.valueOf(s) + "->" + this.linkedLocation;
        }
        return s;
    }
}

