/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ([
/* 0 */,
/* 1 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
const vscode = __webpack_require__(2);
const documentTracker_1 = __webpack_require__(3);
const codelensProvider_1 = __webpack_require__(7);
const commandHandler_1 = __webpack_require__(8);
const contentProvider_1 = __webpack_require__(9);
const mergeDecorator_1 = __webpack_require__(10);
const extension_telemetry_1 = __webpack_require__(11);
const ConfigurationSectionName = 'merge-conflict';
class ServiceWrapper {
    constructor(context) {
        this.context = context;
        this.services = [];
        const { aiKey } = context.extension.packageJSON;
        this.telemetryReporter = new extension_telemetry_1.default(aiKey);
        context.subscriptions.push(this.telemetryReporter);
    }
    begin() {
        const configuration = this.createExtensionConfiguration();
        const documentTracker = new documentTracker_1.default(this.telemetryReporter);
        this.services.push(documentTracker, new commandHandler_1.default(documentTracker), new codelensProvider_1.default(documentTracker), new contentProvider_1.default(this.context), new mergeDecorator_1.default(this.context, documentTracker));
        this.services.forEach((service) => {
            if (service.begin && service.begin instanceof Function) {
                service.begin(configuration);
            }
        });
        vscode.workspace.onDidChangeConfiguration(() => {
            this.services.forEach((service) => {
                if (service.configurationUpdated && service.configurationUpdated instanceof Function) {
                    service.configurationUpdated(this.createExtensionConfiguration());
                }
            });
        });
    }
    createExtensionConfiguration() {
        const workspaceConfiguration = vscode.workspace.getConfiguration(ConfigurationSectionName);
        const codeLensEnabled = workspaceConfiguration.get('codeLens.enabled', true);
        const decoratorsEnabled = workspaceConfiguration.get('decorators.enabled', true);
        return {
            enableCodeLens: codeLensEnabled,
            enableDecorations: decoratorsEnabled,
            enableEditorOverview: decoratorsEnabled
        };
    }
    dispose() {
        this.services.forEach(disposable => disposable.dispose());
        this.services = [];
    }
}
exports["default"] = ServiceWrapper;


/***/ }),
/* 2 */
/***/ ((module) => {

module.exports = require("vscode");

/***/ }),
/* 3 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", ({ value: true }));
const mergeConflictParser_1 = __webpack_require__(4);
const delayer_1 = __webpack_require__(6);
class ScanTask {
    constructor(delayTime, initialOrigin) {
        this.origins = new Set();
        this.origins.add(initialOrigin);
        this.delayTask = new delayer_1.Delayer(delayTime);
    }
    addOrigin(name) {
        this.origins.add(name);
    }
    hasOrigin(name) {
        return this.origins.has(name);
    }
}
class OriginDocumentMergeConflictTracker {
    constructor(parent, origin) {
        this.parent = parent;
        this.origin = origin;
    }
    getConflicts(document) {
        return this.parent.getConflicts(document, this.origin);
    }
    isPending(document) {
        return this.parent.isPending(document, this.origin);
    }
    forget(document) {
        this.parent.forget(document);
    }
}
class DocumentMergeConflictTracker {
    constructor(telemetryReporter) {
        this.telemetryReporter = telemetryReporter;
        this.cache = new Map();
        this.delayExpireTime = 0;
        this.seenDocumentsWithConflicts = new Set();
    }
    getConflicts(document, origin) {
        // Attempt from cache
        const key = this.getCacheKey(document);
        if (!key) {
            // Document doesn't have a uri, can't cache it, so return
            return Promise.resolve(this.getConflictsOrEmpty(document, [origin]));
        }
        let cacheItem = this.cache.get(key);
        if (!cacheItem) {
            cacheItem = new ScanTask(this.delayExpireTime, origin);
            this.cache.set(key, cacheItem);
        }
        else {
            cacheItem.addOrigin(origin);
        }
        return cacheItem.delayTask.trigger(() => {
            const conflicts = this.getConflictsOrEmpty(document, Array.from(cacheItem.origins));
            this.cache?.delete(key);
            return conflicts;
        });
    }
    isPending(document, origin) {
        if (!document) {
            return false;
        }
        const key = this.getCacheKey(document);
        if (!key) {
            return false;
        }
        const task = this.cache.get(key);
        if (!task) {
            return false;
        }
        return task.hasOrigin(origin);
    }
    createTracker(origin) {
        return new OriginDocumentMergeConflictTracker(this, origin);
    }
    forget(document) {
        const key = this.getCacheKey(document);
        if (key) {
            this.cache.delete(key);
        }
    }
    dispose() {
        this.cache.clear();
    }
    getConflictsOrEmpty(document, _origins) {
        const containsConflict = mergeConflictParser_1.MergeConflictParser.containsConflict(document);
        if (!containsConflict) {
            return [];
        }
        const conflicts = mergeConflictParser_1.MergeConflictParser.scanDocument(document, this.telemetryReporter);
        const key = document.uri.toString();
        // Don't report telemetry for the same document twice. This is an approximation, but good enough.
        // Otherwise redo/undo could trigger this event multiple times.
        if (!this.seenDocumentsWithConflicts.has(key)) {
            this.seenDocumentsWithConflicts.add(key);
            /* __GDPR__
                "mergeMarkers.documentWithConflictMarkersOpened" : {
                    "owner": "hediet",
                    "comment": "Used to determine how many documents with conflicts are opened.",
                    "conflictCount": { "classification": "SystemMetaData", "purpose": "FeatureInsight", "isMeasurement": true, "comment": "Total number of conflict counts" }
                }
            */
            this.telemetryReporter.sendTelemetryEvent('mergeMarkers.documentWithConflictMarkersOpened', {}, {
                conflictCount: conflicts.length,
            });
        }
        return conflicts;
    }
    getCacheKey(document) {
        if (document.uri) {
            return document.uri.toString();
        }
        return null;
    }
}
exports["default"] = DocumentMergeConflictTracker;


/***/ }),
/* 4 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MergeConflictParser = void 0;
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
const vscode = __webpack_require__(2);
const documentMergeConflict_1 = __webpack_require__(5);
const startHeaderMarker = '<<<<<<<';
const commonAncestorsMarker = '|||||||';
const splitterMarker = '=======';
const endFooterMarker = '>>>>>>>';
class MergeConflictParser {
    static scanDocument(document, telemetryReporter) {
        // Scan each line in the document, we already know there is at least a <<<<<<< and
        // >>>>>> marker within the document, we need to group these into conflict ranges.
        // We initially build a scan match, that references the lines of the header, splitter
        // and footer. This is then converted into a full descriptor containing all required
        // ranges.
        let currentConflict = null;
        const conflictDescriptors = [];
        for (let i = 0; i < document.lineCount; i++) {
            const line = document.lineAt(i);
            // Ignore empty lines
            if (!line || line.isEmptyOrWhitespace) {
                continue;
            }
            // Is this a start line? <<<<<<<
            if (line.text.startsWith(startHeaderMarker)) {
                if (currentConflict !== null) {
                    // Error, we should not see a startMarker before we've seen an endMarker
                    currentConflict = null;
                    // Give up parsing, anything matched up this to this point will be decorated
                    // anything after will not
                    break;
                }
                // Create a new conflict starting at this line
                currentConflict = { startHeader: line, commonAncestors: [] };
            }
            // Are we within a conflict block and is this a common ancestors marker? |||||||
            else if (currentConflict && !currentConflict.splitter && line.text.startsWith(commonAncestorsMarker)) {
                currentConflict.commonAncestors.push(line);
            }
            // Are we within a conflict block and is this a splitter? =======
            else if (currentConflict && !currentConflict.splitter && line.text === splitterMarker) {
                currentConflict.splitter = line;
            }
            // Are we within a conflict block and is this a footer? >>>>>>>
            else if (currentConflict && line.text.startsWith(endFooterMarker)) {
                currentConflict.endFooter = line;
                // Create a full descriptor from the lines that we matched. This can return
                // null if the descriptor could not be completed.
                const completeDescriptor = MergeConflictParser.scanItemTolMergeConflictDescriptor(document, currentConflict);
                if (completeDescriptor !== null) {
                    conflictDescriptors.push(completeDescriptor);
                }
                // Reset the current conflict to be empty, so we can match the next
                // starting header marker.
                currentConflict = null;
            }
        }
        return conflictDescriptors
            .filter(Boolean)
            .map(descriptor => new documentMergeConflict_1.DocumentMergeConflict(descriptor, telemetryReporter));
    }
    static scanItemTolMergeConflictDescriptor(document, scanned) {
        // Validate we have all the required lines within the scan item.
        if (!scanned.startHeader || !scanned.splitter || !scanned.endFooter) {
            return null;
        }
        const tokenAfterCurrentBlock = scanned.commonAncestors[0] || scanned.splitter;
        // Assume that descriptor.current.header, descriptor.incoming.header and descriptor.splitter
        // have valid ranges, fill in content and total ranges from these parts.
        // NOTE: We need to shift the decorator range back one character so the splitter does not end up with
        // two decoration colors (current and splitter), if we take the new line from the content into account
        // the decorator will wrap to the next line.
        return {
            current: {
                header: scanned.startHeader.range,
                decoratorContent: new vscode.Range(scanned.startHeader.rangeIncludingLineBreak.end, MergeConflictParser.shiftBackOneCharacter(document, tokenAfterCurrentBlock.range.start, scanned.startHeader.rangeIncludingLineBreak.end)),
                // Current content is range between header (shifted for linebreak) and splitter or common ancestors mark start
                content: new vscode.Range(scanned.startHeader.rangeIncludingLineBreak.end, tokenAfterCurrentBlock.range.start),
                name: scanned.startHeader.text.substring(startHeaderMarker.length + 1)
            },
            commonAncestors: scanned.commonAncestors.map((currentTokenLine, index, commonAncestors) => {
                const nextTokenLine = commonAncestors[index + 1] || scanned.splitter;
                return {
                    header: currentTokenLine.range,
                    decoratorContent: new vscode.Range(currentTokenLine.rangeIncludingLineBreak.end, MergeConflictParser.shiftBackOneCharacter(document, nextTokenLine.range.start, currentTokenLine.rangeIncludingLineBreak.end)),
                    // Each common ancestors block is range between one common ancestors token
                    // (shifted for linebreak) and start of next common ancestors token or splitter
                    content: new vscode.Range(currentTokenLine.rangeIncludingLineBreak.end, nextTokenLine.range.start),
                    name: currentTokenLine.text.substring(commonAncestorsMarker.length + 1)
                };
            }),
            splitter: scanned.splitter.range,
            incoming: {
                header: scanned.endFooter.range,
                decoratorContent: new vscode.Range(scanned.splitter.rangeIncludingLineBreak.end, MergeConflictParser.shiftBackOneCharacter(document, scanned.endFooter.range.start, scanned.splitter.rangeIncludingLineBreak.end)),
                // Incoming content is range between splitter (shifted for linebreak) and footer start
                content: new vscode.Range(scanned.splitter.rangeIncludingLineBreak.end, scanned.endFooter.range.start),
                name: scanned.endFooter.text.substring(endFooterMarker.length + 1)
            },
            // Entire range is between current header start and incoming header end (including line break)
            range: new vscode.Range(scanned.startHeader.range.start, scanned.endFooter.rangeIncludingLineBreak.end)
        };
    }
    static containsConflict(document) {
        if (!document) {
            return false;
        }
        const text = document.getText();
        return text.includes(startHeaderMarker) && text.includes(endFooterMarker);
    }
    static shiftBackOneCharacter(document, range, unlessEqual) {
        if (range.isEqual(unlessEqual)) {
            return range;
        }
        let line = range.line;
        let character = range.character - 1;
        if (character < 0) {
            line--;
            character = document.lineAt(line).range.end.character;
        }
        return new vscode.Position(line, character);
    }
}
exports.MergeConflictParser = MergeConflictParser;


/***/ }),
/* 5 */
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DocumentMergeConflict = void 0;
class DocumentMergeConflict {
    constructor(descriptor, telemetryReporter) {
        this.telemetryReporter = telemetryReporter;
        this.applied = false;
        this.range = descriptor.range;
        this.current = descriptor.current;
        this.incoming = descriptor.incoming;
        this.commonAncestors = descriptor.commonAncestors;
        this.splitter = descriptor.splitter;
    }
    commitEdit(type, editor, edit) {
        function commitTypeToString(type) {
            switch (type) {
                case 0 /* interfaces.CommitType.Current */:
                    return 'current';
                case 1 /* interfaces.CommitType.Incoming */:
                    return 'incoming';
                case 2 /* interfaces.CommitType.Both */:
                    return 'both';
            }
        }
        /* __GDPR__
            "mergeMarkers.accept" : {
                "owner": "hediet",
                "comment": "Used to understand how the inline merge editor experience is used.",
                "resolution": { "classification": "SystemMetaData", "purpose": "FeatureInsight", "comment": "Indicates how the merge conflict was resolved by the user" }
            }
        */
        this.telemetryReporter.sendTelemetryEvent('mergeMarkers.accept', { resolution: commitTypeToString(type) });
        if (edit) {
            this.applyEdit(type, editor.document, edit);
            return Promise.resolve(true);
        }
        return editor.edit((edit) => this.applyEdit(type, editor.document, edit));
    }
    applyEdit(type, document, edit) {
        if (this.applied) {
            return;
        }
        this.applied = true;
        // Each conflict is a set of ranges as follows, note placements or newlines
        // which may not in spans
        // [ Conflict Range             -- (Entire content below)
        //   [ Current Header ]\n       -- >>>>> Header
        //   [ Current Content ]        -- (content)
        //   [ Splitter ]\n             -- =====
        //   [ Incoming Content ]       -- (content)
        //   [ Incoming Header ]\n      -- <<<<< Incoming
        // ]
        if (type === 0 /* interfaces.CommitType.Current */) {
            // Replace [ Conflict Range ] with [ Current Content ]
            const content = document.getText(this.current.content);
            this.replaceRangeWithContent(content, edit);
        }
        else if (type === 1 /* interfaces.CommitType.Incoming */) {
            const content = document.getText(this.incoming.content);
            this.replaceRangeWithContent(content, edit);
        }
        else if (type === 2 /* interfaces.CommitType.Both */) {
            // Replace [ Conflict Range ] with [ Current Content ] + \n + [ Incoming Content ]
            const currentContent = document.getText(this.current.content);
            const incomingContent = document.getText(this.incoming.content);
            edit.replace(this.range, currentContent.concat(incomingContent));
        }
    }
    replaceRangeWithContent(content, edit) {
        if (this.isNewlineOnly(content)) {
            edit.replace(this.range, '');
            return;
        }
        // Replace [ Conflict Range ] with [ Current Content ]
        edit.replace(this.range, content);
    }
    isNewlineOnly(text) {
        return text === '\n' || text === '\r\n';
    }
}
exports.DocumentMergeConflict = DocumentMergeConflict;


/***/ }),
/* 6 */
/***/ ((__unused_webpack_module, exports) => {


/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Delayer = void 0;
class Delayer {
    constructor(defaultDelay) {
        this.defaultDelay = defaultDelay;
        this.timeout = null;
        this.completionPromise = null;
        this.onSuccess = null;
        this.task = null;
    }
    trigger(task, delay = this.defaultDelay) {
        this.task = task;
        if (delay >= 0) {
            this.cancelTimeout();
        }
        if (!this.completionPromise) {
            this.completionPromise = new Promise((resolve) => {
                this.onSuccess = resolve;
            }).then(() => {
                this.completionPromise = null;
                this.onSuccess = null;
                const result = this.task();
                this.task = null;
                return result;
            });
        }
        if (delay >= 0 || this.timeout === null) {
            this.timeout = setTimeout(() => {
                this.timeout = null;
                this.onSuccess(undefined);
            }, delay >= 0 ? delay : this.defaultDelay);
        }
        return this.completionPromise;
    }
    forceDelivery() {
        if (!this.completionPromise) {
            return null;
        }
        this.cancelTimeout();
        const result = this.completionPromise;
        this.onSuccess(undefined);
        return result;
    }
    isTriggered() {
        return this.timeout !== null;
    }
    cancel() {
        this.cancelTimeout();
        this.completionPromise = null;
    }
    cancelTimeout() {
        if (this.timeout !== null) {
            clearTimeout(this.timeout);
            this.timeout = null;
        }
    }
}
exports.Delayer = Delayer;


/***/ }),
/* 7 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", ({ value: true }));
const vscode = __webpack_require__(2);
class MergeConflictCodeLensProvider {
    constructor(trackerService) {
        this.tracker = trackerService.createTracker('codelens');
    }
    begin(config) {
        this.config = config;
        if (this.config.enableCodeLens) {
            this.registerCodeLensProvider();
        }
    }
    configurationUpdated(updatedConfig) {
        if (updatedConfig.enableCodeLens === false && this.codeLensRegistrationHandle) {
            this.codeLensRegistrationHandle.dispose();
            this.codeLensRegistrationHandle = null;
        }
        else if (updatedConfig.enableCodeLens === true && !this.codeLensRegistrationHandle) {
            this.registerCodeLensProvider();
        }
        this.config = updatedConfig;
    }
    dispose() {
        if (this.codeLensRegistrationHandle) {
            this.codeLensRegistrationHandle.dispose();
            this.codeLensRegistrationHandle = null;
        }
    }
    async provideCodeLenses(document, _token) {
        if (!this.config || !this.config.enableCodeLens) {
            return null;
        }
        const conflicts = await this.tracker.getConflicts(document);
        const conflictsCount = conflicts?.length ?? 0;
        vscode.commands.executeCommand('setContext', 'mergeConflictsCount', conflictsCount);
        if (!conflictsCount) {
            return null;
        }
        const items = [];
        conflicts.forEach(conflict => {
            const acceptCurrentCommand = {
                command: 'merge-conflict.accept.current',
                title: vscode.l10n.t("Accept Current Change"),
                arguments: ['known-conflict', conflict]
            };
            const acceptIncomingCommand = {
                command: 'merge-conflict.accept.incoming',
                title: vscode.l10n.t("Accept Incoming Change"),
                arguments: ['known-conflict', conflict]
            };
            const acceptBothCommand = {
                command: 'merge-conflict.accept.both',
                title: vscode.l10n.t("Accept Both Changes"),
                arguments: ['known-conflict', conflict]
            };
            const diffCommand = {
                command: 'merge-conflict.compare',
                title: vscode.l10n.t("Compare Changes"),
                arguments: [conflict]
            };
            const range = document.lineAt(conflict.range.start.line).range;
            items.push(new vscode.CodeLens(range, acceptCurrentCommand), new vscode.CodeLens(range, acceptIncomingCommand), new vscode.CodeLens(range, acceptBothCommand), new vscode.CodeLens(range, diffCommand));
        });
        return items;
    }
    registerCodeLensProvider() {
        this.codeLensRegistrationHandle = vscode.languages.registerCodeLensProvider([
            { scheme: 'file' },
            { scheme: 'vscode-vfs' },
            { scheme: 'untitled' },
            { scheme: 'vscode-userdata' },
        ], this);
    }
}
exports["default"] = MergeConflictCodeLensProvider;


/***/ }),
/* 8 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
const vscode = __webpack_require__(2);
const contentProvider_1 = __webpack_require__(9);
var NavigationDirection;
(function (NavigationDirection) {
    NavigationDirection[NavigationDirection["Forwards"] = 0] = "Forwards";
    NavigationDirection[NavigationDirection["Backwards"] = 1] = "Backwards";
})(NavigationDirection || (NavigationDirection = {}));
class CommandHandler {
    constructor(trackerService) {
        this.disposables = [];
        this.tracker = trackerService.createTracker('commands');
    }
    begin() {
        this.disposables.push(this.registerTextEditorCommand('merge-conflict.accept.current', this.acceptCurrent), this.registerTextEditorCommand('merge-conflict.accept.incoming', this.acceptIncoming), this.registerTextEditorCommand('merge-conflict.accept.selection', this.acceptSelection), this.registerTextEditorCommand('merge-conflict.accept.both', this.acceptBoth), this.registerTextEditorCommand('merge-conflict.accept.all-current', this.acceptAllCurrent, this.acceptAllCurrentResources), this.registerTextEditorCommand('merge-conflict.accept.all-incoming', this.acceptAllIncoming, this.acceptAllIncomingResources), this.registerTextEditorCommand('merge-conflict.accept.all-both', this.acceptAllBoth), this.registerTextEditorCommand('merge-conflict.next', this.navigateNext), this.registerTextEditorCommand('merge-conflict.previous', this.navigatePrevious), this.registerTextEditorCommand('merge-conflict.compare', this.compare));
    }
    registerTextEditorCommand(command, cb, resourceCB) {
        return vscode.commands.registerCommand(command, (...args) => {
            if (resourceCB && args.length && args.every(arg => arg && arg.resourceUri)) {
                return resourceCB.call(this, args.map(arg => arg.resourceUri));
            }
            const editor = vscode.window.activeTextEditor;
            return editor && cb.call(this, editor, ...args);
        });
    }
    acceptCurrent(editor, ...args) {
        return this.accept(0 /* interfaces.CommitType.Current */, editor, ...args);
    }
    acceptIncoming(editor, ...args) {
        return this.accept(1 /* interfaces.CommitType.Incoming */, editor, ...args);
    }
    acceptBoth(editor, ...args) {
        return this.accept(2 /* interfaces.CommitType.Both */, editor, ...args);
    }
    acceptAllCurrent(editor) {
        return this.acceptAll(0 /* interfaces.CommitType.Current */, editor);
    }
    acceptAllIncoming(editor) {
        return this.acceptAll(1 /* interfaces.CommitType.Incoming */, editor);
    }
    acceptAllCurrentResources(resources) {
        return this.acceptAllResources(0 /* interfaces.CommitType.Current */, resources);
    }
    acceptAllIncomingResources(resources) {
        return this.acceptAllResources(1 /* interfaces.CommitType.Incoming */, resources);
    }
    acceptAllBoth(editor) {
        return this.acceptAll(2 /* interfaces.CommitType.Both */, editor);
    }
    async compare(editor, conflict) {
        // No conflict, command executed from command palette
        if (!conflict) {
            conflict = await this.findConflictContainingSelection(editor);
            // Still failed to find conflict, warn the user and exit
            if (!conflict) {
                vscode.window.showWarningMessage(vscode.l10n.t("Editor cursor is not within a merge conflict"));
                return;
            }
        }
        const conflicts = await this.tracker.getConflicts(editor.document);
        // Still failed to find conflict, warn the user and exit
        if (!conflicts) {
            vscode.window.showWarningMessage(vscode.l10n.t("Editor cursor is not within a merge conflict"));
            return;
        }
        const scheme = editor.document.uri.scheme;
        let range = conflict.current.content;
        const leftRanges = conflicts.map(conflict => [conflict.current.content, conflict.range]);
        const rightRanges = conflicts.map(conflict => [conflict.incoming.content, conflict.range]);
        const leftUri = editor.document.uri.with({
            scheme: contentProvider_1.default.scheme,
            query: JSON.stringify({ scheme, range: range, ranges: leftRanges })
        });
        range = conflict.incoming.content;
        const rightUri = leftUri.with({ query: JSON.stringify({ scheme, ranges: rightRanges }) });
        let mergeConflictLineOffsets = 0;
        for (const nextconflict of conflicts) {
            if (nextconflict.range.isEqual(conflict.range)) {
                break;
            }
            else {
                mergeConflictLineOffsets += (nextconflict.range.end.line - nextconflict.range.start.line) - (nextconflict.incoming.content.end.line - nextconflict.incoming.content.start.line);
            }
        }
        const selection = new vscode.Range(conflict.range.start.line - mergeConflictLineOffsets, conflict.range.start.character, conflict.range.start.line - mergeConflictLineOffsets, conflict.range.start.character);
        const docPath = editor.document.uri.path;
        const fileName = docPath.substring(docPath.lastIndexOf('/') + 1); // avoid NodeJS path to keep browser webpack small
        const title = vscode.l10n.t("{0}: Current Changes ↔ Incoming Changes", fileName);
        const mergeConflictConfig = vscode.workspace.getConfiguration('merge-conflict');
        const openToTheSide = mergeConflictConfig.get('diffViewPosition');
        const opts = {
            viewColumn: openToTheSide === 'Beside' ? vscode.ViewColumn.Beside : vscode.ViewColumn.Active,
            selection
        };
        if (openToTheSide === 'Below') {
            await vscode.commands.executeCommand('workbench.action.newGroupBelow');
        }
        await vscode.commands.executeCommand('vscode.diff', leftUri, rightUri, title, opts);
    }
    navigateNext(editor) {
        return this.navigate(editor, NavigationDirection.Forwards);
    }
    navigatePrevious(editor) {
        return this.navigate(editor, NavigationDirection.Backwards);
    }
    async acceptSelection(editor) {
        const conflict = await this.findConflictContainingSelection(editor);
        if (!conflict) {
            vscode.window.showWarningMessage(vscode.l10n.t("Editor cursor is not within a merge conflict"));
            return;
        }
        let typeToAccept;
        let tokenAfterCurrentBlock = conflict.splitter;
        if (conflict.commonAncestors.length > 0) {
            tokenAfterCurrentBlock = conflict.commonAncestors[0].header;
        }
        // Figure out if the cursor is in current or incoming, we do this by seeing if
        // the active position is before or after the range of the splitter or common
        // ancestors marker. We can use this trick as the previous check in
        // findConflictByActiveSelection will ensure it's within the conflict range, so
        // we don't falsely identify "current" or "incoming" if outside of a conflict range.
        if (editor.selection.active.isBefore(tokenAfterCurrentBlock.start)) {
            typeToAccept = 0 /* interfaces.CommitType.Current */;
        }
        else if (editor.selection.active.isAfter(conflict.splitter.end)) {
            typeToAccept = 1 /* interfaces.CommitType.Incoming */;
        }
        else if (editor.selection.active.isBefore(conflict.splitter.start)) {
            vscode.window.showWarningMessage(vscode.l10n.t('Editor cursor is within the common ancestors block, please move it to either the "current" or "incoming" block'));
            return;
        }
        else {
            vscode.window.showWarningMessage(vscode.l10n.t('Editor cursor is within the merge conflict splitter, please move it to either the "current" or "incoming" block'));
            return;
        }
        this.tracker.forget(editor.document);
        conflict.commitEdit(typeToAccept, editor);
    }
    dispose() {
        this.disposables.forEach(disposable => disposable.dispose());
        this.disposables = [];
    }
    async navigate(editor, direction) {
        const navigationResult = await this.findConflictForNavigation(editor, direction);
        if (!navigationResult) {
            // Check for autoNavigateNextConflict, if it's enabled(which indicating no conflict remain), then do not show warning
            const mergeConflictConfig = vscode.workspace.getConfiguration('merge-conflict');
            if (mergeConflictConfig.get('autoNavigateNextConflict.enabled')) {
                return;
            }
            vscode.window.showWarningMessage(vscode.l10n.t("No merge conflicts found in this file"));
            return;
        }
        else if (!navigationResult.canNavigate) {
            vscode.window.showWarningMessage(vscode.l10n.t("No other merge conflicts within this file"));
            return;
        }
        else if (!navigationResult.conflict) {
            // TODO: Show error message?
            return;
        }
        // Move the selection to the first line of the conflict
        editor.selection = new vscode.Selection(navigationResult.conflict.range.start, navigationResult.conflict.range.start);
        editor.revealRange(navigationResult.conflict.range, vscode.TextEditorRevealType.Default);
    }
    async accept(type, editor, ...args) {
        let conflict;
        // If launched with known context, take the conflict from that
        if (args[0] === 'known-conflict') {
            conflict = args[1];
        }
        else {
            // Attempt to find a conflict that matches the current cursor position
            conflict = await this.findConflictContainingSelection(editor);
        }
        if (!conflict) {
            vscode.window.showWarningMessage(vscode.l10n.t("Editor cursor is not within a merge conflict"));
            return;
        }
        // Tracker can forget as we know we are going to do an edit
        this.tracker.forget(editor.document);
        conflict.commitEdit(type, editor);
        // navigate to the next merge conflict
        const mergeConflictConfig = vscode.workspace.getConfiguration('merge-conflict');
        if (mergeConflictConfig.get('autoNavigateNextConflict.enabled')) {
            this.navigateNext(editor);
        }
    }
    async acceptAll(type, editor) {
        const conflicts = await this.tracker.getConflicts(editor.document);
        if (!conflicts || conflicts.length === 0) {
            vscode.window.showWarningMessage(vscode.l10n.t("No merge conflicts found in this file"));
            return;
        }
        // For get the current state of the document, as we know we are doing to do a large edit
        this.tracker.forget(editor.document);
        // Apply all changes as one edit
        await editor.edit((edit) => conflicts.forEach(conflict => {
            conflict.applyEdit(type, editor.document, edit);
        }));
    }
    async acceptAllResources(type, resources) {
        const documents = await Promise.all(resources.map(resource => vscode.workspace.openTextDocument(resource)));
        const edit = new vscode.WorkspaceEdit();
        for (const document of documents) {
            const conflicts = await this.tracker.getConflicts(document);
            if (!conflicts || conflicts.length === 0) {
                continue;
            }
            // For get the current state of the document, as we know we are doing to do a large edit
            this.tracker.forget(document);
            // Apply all changes as one edit
            conflicts.forEach(conflict => {
                conflict.applyEdit(type, document, { replace: (range, newText) => edit.replace(document.uri, range, newText) });
            });
        }
        vscode.workspace.applyEdit(edit);
    }
    async findConflictContainingSelection(editor, conflicts) {
        if (!conflicts) {
            conflicts = await this.tracker.getConflicts(editor.document);
        }
        if (!conflicts || conflicts.length === 0) {
            return null;
        }
        for (const conflict of conflicts) {
            if (conflict.range.contains(editor.selection.active)) {
                return conflict;
            }
        }
        return null;
    }
    async findConflictForNavigation(editor, direction, conflicts) {
        if (!conflicts) {
            conflicts = await this.tracker.getConflicts(editor.document);
        }
        if (!conflicts || conflicts.length === 0) {
            return null;
        }
        const selection = editor.selection.active;
        if (conflicts.length === 1) {
            if (conflicts[0].range.contains(selection)) {
                return {
                    canNavigate: false
                };
            }
            return {
                canNavigate: true,
                conflict: conflicts[0]
            };
        }
        let predicate;
        let fallback;
        let scanOrder;
        if (direction === NavigationDirection.Forwards) {
            predicate = (conflict) => selection.isBefore(conflict.range.start);
            fallback = () => conflicts[0];
            scanOrder = conflicts;
        }
        else if (direction === NavigationDirection.Backwards) {
            predicate = (conflict) => selection.isAfter(conflict.range.start);
            fallback = () => conflicts[conflicts.length - 1];
            scanOrder = conflicts.slice().reverse();
        }
        else {
            throw new Error(`Unsupported direction ${direction}`);
        }
        for (const conflict of scanOrder) {
            if (predicate(conflict) && !conflict.range.contains(selection)) {
                return {
                    canNavigate: true,
                    conflict: conflict
                };
            }
        }
        // Went all the way to the end, return the head
        return {
            canNavigate: true,
            conflict: fallback()
        };
    }
}
exports["default"] = CommandHandler;


/***/ }),
/* 9 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", ({ value: true }));
const vscode = __webpack_require__(2);
class MergeConflictContentProvider {
    constructor(context) {
        this.context = context;
    }
    begin() {
        this.context.subscriptions.push(vscode.workspace.registerTextDocumentContentProvider(MergeConflictContentProvider.scheme, this));
    }
    dispose() {
    }
    async provideTextDocumentContent(uri) {
        try {
            const { scheme, ranges } = JSON.parse(uri.query);
            // complete diff
            const document = await vscode.workspace.openTextDocument(uri.with({ scheme, query: '' }));
            let text = '';
            let lastPosition = new vscode.Position(0, 0);
            ranges.forEach(rangeObj => {
                const [conflictRange, fullRange] = rangeObj;
                const [start, end] = conflictRange;
                const [fullStart, fullEnd] = fullRange;
                text += document.getText(new vscode.Range(lastPosition.line, lastPosition.character, fullStart.line, fullStart.character));
                text += document.getText(new vscode.Range(start.line, start.character, end.line, end.character));
                lastPosition = new vscode.Position(fullEnd.line, fullEnd.character);
            });
            const documentEnd = document.lineAt(document.lineCount - 1).range.end;
            text += document.getText(new vscode.Range(lastPosition.line, lastPosition.character, documentEnd.line, documentEnd.character));
            return text;
        }
        catch (ex) {
            await vscode.window.showErrorMessage('Unable to show comparison');
            return null;
        }
    }
}
MergeConflictContentProvider.scheme = 'merge-conflict.conflict-diff';
exports["default"] = MergeConflictContentProvider;


/***/ }),
/* 10 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
const vscode = __webpack_require__(2);
class MergeDecorator {
    constructor(context, trackerService) {
        this.context = context;
        this.decorations = {};
        this.decorationUsesWholeLine = true; // Useful for debugging, set to false to see exact match ranges
        this.updating = new Map();
        this.tracker = trackerService.createTracker('decorator');
    }
    begin(config) {
        this.config = config;
        this.registerDecorationTypes(config);
        // Check if we already have a set of active windows, attempt to track these.
        vscode.window.visibleTextEditors.forEach(e => this.applyDecorations(e));
        vscode.workspace.onDidOpenTextDocument(event => {
            this.applyDecorationsFromEvent(event);
        }, null, this.context.subscriptions);
        vscode.workspace.onDidChangeTextDocument(event => {
            this.applyDecorationsFromEvent(event.document);
        }, null, this.context.subscriptions);
        vscode.window.onDidChangeVisibleTextEditors((e) => {
            // Any of which could be new (not just the active one).
            e.forEach(e => this.applyDecorations(e));
        }, null, this.context.subscriptions);
    }
    configurationUpdated(config) {
        this.config = config;
        this.registerDecorationTypes(config);
        // Re-apply the decoration
        vscode.window.visibleTextEditors.forEach(e => {
            this.removeDecorations(e);
            this.applyDecorations(e);
        });
    }
    registerDecorationTypes(config) {
        // Dispose of existing decorations
        Object.keys(this.decorations).forEach(k => this.decorations[k].dispose());
        this.decorations = {};
        // None of our features are enabled
        if (!config.enableDecorations || !config.enableEditorOverview) {
            return;
        }
        // Create decorators
        if (config.enableDecorations || config.enableEditorOverview) {
            this.decorations['current.content'] = vscode.window.createTextEditorDecorationType(this.generateBlockRenderOptions('merge.currentContentBackground', 'editorOverviewRuler.currentContentForeground', config));
            this.decorations['incoming.content'] = vscode.window.createTextEditorDecorationType(this.generateBlockRenderOptions('merge.incomingContentBackground', 'editorOverviewRuler.incomingContentForeground', config));
            this.decorations['commonAncestors.content'] = vscode.window.createTextEditorDecorationType(this.generateBlockRenderOptions('merge.commonContentBackground', 'editorOverviewRuler.commonContentForeground', config));
        }
        if (config.enableDecorations) {
            this.decorations['current.header'] = vscode.window.createTextEditorDecorationType({
                isWholeLine: this.decorationUsesWholeLine,
                backgroundColor: new vscode.ThemeColor('merge.currentHeaderBackground'),
                color: new vscode.ThemeColor('editor.foreground'),
                outlineStyle: 'solid',
                outlineWidth: '1pt',
                outlineColor: new vscode.ThemeColor('merge.border'),
                after: {
                    contentText: ' ' + vscode.l10n.t("(Current Change)"),
                    color: new vscode.ThemeColor('descriptionForeground')
                }
            });
            this.decorations['commonAncestors.header'] = vscode.window.createTextEditorDecorationType({
                isWholeLine: this.decorationUsesWholeLine,
                backgroundColor: new vscode.ThemeColor('merge.commonHeaderBackground'),
                color: new vscode.ThemeColor('editor.foreground'),
                outlineStyle: 'solid',
                outlineWidth: '1pt',
                outlineColor: new vscode.ThemeColor('merge.border')
            });
            this.decorations['splitter'] = vscode.window.createTextEditorDecorationType({
                color: new vscode.ThemeColor('editor.foreground'),
                outlineStyle: 'solid',
                outlineWidth: '1pt',
                outlineColor: new vscode.ThemeColor('merge.border'),
                isWholeLine: this.decorationUsesWholeLine,
            });
            this.decorations['incoming.header'] = vscode.window.createTextEditorDecorationType({
                backgroundColor: new vscode.ThemeColor('merge.incomingHeaderBackground'),
                color: new vscode.ThemeColor('editor.foreground'),
                outlineStyle: 'solid',
                outlineWidth: '1pt',
                outlineColor: new vscode.ThemeColor('merge.border'),
                isWholeLine: this.decorationUsesWholeLine,
                after: {
                    contentText: ' ' + vscode.l10n.t("(Incoming Change)"),
                    color: new vscode.ThemeColor('descriptionForeground')
                }
            });
        }
    }
    dispose() {
        // TODO: Replace with Map<string, T>
        Object.keys(this.decorations).forEach(name => {
            this.decorations[name].dispose();
        });
        this.decorations = {};
    }
    generateBlockRenderOptions(backgroundColor, overviewRulerColor, config) {
        const renderOptions = {};
        if (config.enableDecorations) {
            renderOptions.backgroundColor = new vscode.ThemeColor(backgroundColor);
            renderOptions.isWholeLine = this.decorationUsesWholeLine;
        }
        if (config.enableEditorOverview) {
            renderOptions.overviewRulerColor = new vscode.ThemeColor(overviewRulerColor);
            renderOptions.overviewRulerLane = vscode.OverviewRulerLane.Full;
        }
        return renderOptions;
    }
    applyDecorationsFromEvent(eventDocument) {
        for (const editor of vscode.window.visibleTextEditors) {
            if (editor.document === eventDocument) {
                // Attempt to apply
                this.applyDecorations(editor);
            }
        }
    }
    async applyDecorations(editor) {
        if (!editor || !editor.document) {
            return;
        }
        if (!this.config || (!this.config.enableDecorations && !this.config.enableEditorOverview)) {
            return;
        }
        // If we have a pending scan from the same origin, exit early. (Cannot use this.tracker.isPending() because decorations are per editor.)
        if (this.updating.get(editor)) {
            return;
        }
        try {
            this.updating.set(editor, true);
            const conflicts = await this.tracker.getConflicts(editor.document);
            if (vscode.window.visibleTextEditors.indexOf(editor) === -1) {
                return;
            }
            if (conflicts.length === 0) {
                this.removeDecorations(editor);
                return;
            }
            // Store decorations keyed by the type of decoration, set decoration wants a "style"
            // to go with it, which will match this key (see constructor);
            const matchDecorations = {};
            const pushDecoration = (key, d) => {
                matchDecorations[key] = matchDecorations[key] || [];
                matchDecorations[key].push(d);
            };
            conflicts.forEach(conflict => {
                // TODO, this could be more effective, just call getMatchPositions once with a map of decoration to position
                if (!conflict.current.decoratorContent.isEmpty) {
                    pushDecoration('current.content', conflict.current.decoratorContent);
                }
                if (!conflict.incoming.decoratorContent.isEmpty) {
                    pushDecoration('incoming.content', conflict.incoming.decoratorContent);
                }
                conflict.commonAncestors.forEach(commonAncestorsRegion => {
                    if (!commonAncestorsRegion.decoratorContent.isEmpty) {
                        pushDecoration('commonAncestors.content', commonAncestorsRegion.decoratorContent);
                    }
                });
                if (this.config.enableDecorations) {
                    pushDecoration('current.header', conflict.current.header);
                    pushDecoration('splitter', conflict.splitter);
                    pushDecoration('incoming.header', conflict.incoming.header);
                    conflict.commonAncestors.forEach(commonAncestorsRegion => {
                        pushDecoration('commonAncestors.header', commonAncestorsRegion.header);
                    });
                }
            });
            // For each match we've generated, apply the generated decoration with the matching decoration type to the
            // editor instance. Keys in both matches and decorations should match.
            Object.keys(matchDecorations).forEach(decorationKey => {
                const decorationType = this.decorations[decorationKey];
                if (decorationType) {
                    editor.setDecorations(decorationType, matchDecorations[decorationKey]);
                }
            });
        }
        finally {
            this.updating.delete(editor);
        }
    }
    removeDecorations(editor) {
        // Remove all decorations, there might be none
        Object.keys(this.decorations).forEach(decorationKey => {
            // Race condition, while editing the settings, it's possible to
            // generate regions before the configuration has been refreshed
            const decorationType = this.decorations[decorationKey];
            if (decorationType) {
                editor.setDecorations(decorationType, []);
            }
        });
    }
}
exports["default"] = MergeDecorator;


/***/ }),
/* 11 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TelemetryReporter)
/* harmony export */ });
/* harmony import */ var vscode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2);
/* harmony import */ var vscode__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(vscode__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _common_1dsClientFactory__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(14);
/* harmony import */ var _common_baseTelemetrySender__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(70);
/* harmony import */ var _common_baseTelemetryReporter__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(13);
/* harmony import */ var _common_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(12);
/*---------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/





const webAppInsightsClientFactory = async (key, replacementOptions) => {
    let appInsightsClient;
    try {
        const web = await Promise.resolve(/* import() eager */).then(__webpack_require__.bind(__webpack_require__, 71));
        appInsightsClient = new web.ApplicationInsights({
            instrumentationKey: key,
            disableAjaxTracking: true,
            disableExceptionTracking: true,
            disableFetchTracking: true,
            disableCorrelationHeaders: true,
            disableCookiesUsage: true,
            autoTrackPageVisitTime: false,
            emitLineDelimitedJson: false,
            disableInstrumentationKeyValidation: true
        });
    }
    catch (e) {
        return Promise.reject(e);
    }
    // Sets the appinsights client into a standardized form
    const telemetryClient = {
        logEvent: (eventName, data) => {
            const properties = { ...data?.properties, ...data?.measurements };
            if (replacementOptions?.length) {
                _common_util__WEBPACK_IMPORTED_MODULE_1__.TelemetryUtil.applyReplacements(properties, replacementOptions);
            }
            appInsightsClient?.track({ name: eventName, data: properties });
        },
        flush: async () => {
            appInsightsClient?.flush(false);
        },
        dispose: async () => {
            const unloadPromise = new Promise((resolve) => {
                appInsightsClient?.unload(true, () => {
                    resolve();
                    appInsightsClient = undefined;
                }, 1000);
            });
            return unloadPromise;
        }
    };
    return telemetryClient;
};
function getBrowserRelease(navigator) {
    if (navigator.userAgentData) {
        const browser = navigator.userAgentData.brands[navigator.userAgentData.brands.length - 1];
        return `${navigator.userAgentData.platform} - ${browser?.brand} v${browser?.version}}`;
    }
    else {
        return navigator.appVersion;
    }
}
class TelemetryReporter extends _common_baseTelemetryReporter__WEBPACK_IMPORTED_MODULE_2__.BaseTelemetryReporter {
    constructor(key, replacementOptions) {
        let clientFactory = (key) => webAppInsightsClientFactory(key, replacementOptions);
        // If key is usable by 1DS use the 1DS SDk
        if (_common_util__WEBPACK_IMPORTED_MODULE_1__.TelemetryUtil.shouldUseOneDataSystemSDK(key)) {
            clientFactory = (key) => (0,_common_1dsClientFactory__WEBPACK_IMPORTED_MODULE_3__.oneDataSystemClientFactory)(key, vscode__WEBPACK_IMPORTED_MODULE_0__);
        }
        const osShim = {
            release: getBrowserRelease(navigator),
            platform: "web",
            architecture: "web",
        };
        const sender = new _common_baseTelemetrySender__WEBPACK_IMPORTED_MODULE_4__.BaseTelemetrySender(key, clientFactory);
        // AIF is no longer supported
        if (key && (key.indexOf("AIF") === 0)) {
            throw new Error("AIF keys are no longer supported. Please switch to 1DS keys for 1st party extensions");
        }
        super(sender, vscode__WEBPACK_IMPORTED_MODULE_0__, { additionalCommonProperties: _common_util__WEBPACK_IMPORTED_MODULE_1__.TelemetryUtil.getAdditionalCommonProperties(osShim) });
    }
}
//# sourceMappingURL=telemetryReporter.js.map

/***/ }),
/* 12 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TelemetryUtil": () => (/* binding */ TelemetryUtil)
/* harmony export */ });
/*---------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/
class TelemetryUtil {
    static applyReplacements(data, replacementOptions) {
        for (const key of Object.keys(data)) {
            for (const option of replacementOptions) {
                if (option.lookup.test(key)) {
                    if (option.replacementString !== undefined) {
                        data[key] = option.replacementString;
                    }
                    else {
                        delete data[key];
                    }
                }
            }
        }
    }
    /**
     * Given a key checks if it is a valid 1DS key
     * @param key The key to check if it's a valid 1DS key
     */
    static shouldUseOneDataSystemSDK(key) {
        // Simple to check to ensure the key is the right length and the dashes are in the right spot
        return (key.length === 74 &&
            key[32] === "-" &&
            key[41] === "-" &&
            key[46] === "-" &&
            key[51] === "-" &&
            key[56] === "-" &&
            key[69] === "-");
    }
    // This also includes the common properties which core mixes in
    // __GDPR__COMMON__ "common.os" : { "classification": "SystemMetaData", "purpose": "FeatureInsight" }
    // __GDPR__COMMON__ "common.nodeArch" : { "classification": "SystemMetaData", "purpose": "FeatureInsight" }
    // __GDPR__COMMON__ "common.platformversion" : { "classification": "SystemMetaData", "purpose": "FeatureInsight" }
    // __GDPR__COMMON__ "common.extname" : { "classification": "PublicNonPersonalData", "purpose": "FeatureInsight" }
    // __GDPR__COMMON__ "common.extversion" : { "classification": "PublicNonPersonalData", "purpose": "FeatureInsight" }
    // __GDPR__COMMON__ "common.vscodemachineid" : { "endPoint": "MacAddressHash", "classification": "EndUserPseudonymizedInformation", "purpose": "FeatureInsight" }
    // __GDPR__COMMON__ "common.vscodesessionid" : { "classification": "SystemMetaData", "purpose": "FeatureInsight" }
    // __GDPR__COMMON__ "common.vscodeversion" : { "classification": "SystemMetaData", "purpose": "FeatureInsight" }
    // __GDPR__COMMON__ "common.uikind" : { "classification": "SystemMetaData", "purpose": "FeatureInsight" }
    // __GDPR__COMMON__ "common.remotename" : { "classification": "SystemMetaData", "purpose": "FeatureInsight" }
    // __GDPR__COMMON__ "common.isnewappinstall" : { "classification": "SystemMetaData", "purpose": "FeatureInsight" }
    // __GDPR__COMMON__ "common.product" : { "classification": "SystemMetaData", "purpose": "FeatureInsight" }
    // __GDPR__COMMON__ "common.telemetryclientversion" : { "classification": "SystemMetaData", "purpose": "FeatureInsight" }
    static getAdditionalCommonProperties(osShim) {
        return {
            "common.os": osShim.platform,
            "common.nodeArch": osShim.architecture,
            "common.platformversion": (osShim.release || "").replace(/^(\d+)(\.\d+)?(\.\d+)?(.*)/, "$1$2$3"),
            // Do not change this string as it gets found and replaced upon packaging
            "common.telemetryclientversion": "0.8.5"
        };
    }
    // Get singleton instance of TelemetryUtil
    static getInstance() {
        if (!TelemetryUtil._instance) {
            TelemetryUtil._instance = new TelemetryUtil();
        }
        return TelemetryUtil._instance;
    }
}
//# sourceMappingURL=util.js.map

/***/ }),
/* 13 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BaseTelemetryReporter": () => (/* binding */ BaseTelemetryReporter)
/* harmony export */ });
/*---------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/
class BaseTelemetryReporter {
    constructor(telemetrySender, vscodeAPI, initializationOptions) {
        this.telemetrySender = telemetrySender;
        this.vscodeAPI = vscodeAPI;
        this.userOptIn = false;
        this.errorOptIn = false;
        this.disposables = [];
        this._onDidChangeTelemetryLevel = new this.vscodeAPI.EventEmitter();
        this.onDidChangeTelemetryLevel = this._onDidChangeTelemetryLevel.event;
        this.telemetryLogger = this.vscodeAPI.env.createTelemetryLogger(this.telemetrySender, initializationOptions);
        // Keep track of the user's opt-in status
        this.updateUserOptIn();
        this.telemetryLogger.onDidChangeEnableStates(() => {
            this.updateUserOptIn();
        });
    }
    /**
     * Updates the user's telemetry opt-in status
     */
    updateUserOptIn() {
        this.errorOptIn = this.telemetryLogger.isErrorsEnabled;
        this.userOptIn = this.telemetryLogger.isUsageEnabled;
        // The sender is lazy loaded so if telemetry is off it's not loaded in
        if (this.telemetryLogger.isErrorsEnabled || this.telemetryLogger.isUsageEnabled) {
            this.telemetrySender.instantiateSender();
        }
        this._onDidChangeTelemetryLevel.fire(this.telemetryLevel);
    }
    get telemetryLevel() {
        if (this.errorOptIn && this.userOptIn) {
            return "all";
        }
        else if (this.errorOptIn) {
            return "error";
        }
        else {
            return "off";
        }
    }
    /**
     * Internal function which logs telemetry events and takes extra options.
     * @param eventName The name of the event
     * @param properties The properties of the event
     * @param measurements The measurements (numeric values) to send with the event
     * @param sanitize Whether or not to sanitize to the properties and measures
     * @param dangerous Whether or not to ignore telemetry level
     */
    internalSendTelemetryEvent(eventName, properties, measurements, dangerous) {
        // If it's dangerous we skip going through the logger as the logger checks opt-in status, etc.
        if (dangerous) {
            this.telemetrySender.sendEventData(eventName, { properties, measurements });
        }
        else {
            this.telemetryLogger.logUsage(eventName, { properties, measurements });
        }
    }
    /**
     * Given an event name, some properties, and measurements sends a telemetry event.
     * Properties are sanitized on best-effort basis to remove sensitive data prior to sending.
     * @param eventName The name of the event
     * @param properties The properties to send with the event
     * @param measurements The measurements (numeric values) to send with the event
     */
    sendTelemetryEvent(eventName, properties, measurements) {
        this.internalSendTelemetryEvent(eventName, properties, measurements, false);
    }
    /**
     * Sends a raw (unsanitized) telemetry event with the given properties and measurements.
     * NOTE: This will not be logged to the output channel due to API limitations.
     * @param eventName The name of the event
     * @param properties The set of properties to add to the event in the form of a string key value pair
     * @param measurements The set of measurements to add to the event in the form of a string key  number value pair
     */
    sendRawTelemetryEvent(eventName, properties, measurements) {
        const modifiedProperties = { ...properties };
        for (const propertyKey of Object.keys(modifiedProperties ?? {})) {
            const propertyValue = modifiedProperties[propertyKey];
            if (typeof propertyKey === "string" && propertyValue !== undefined) {
                // Trusted values are not sanitized, which is what we want for raw telemetry
                modifiedProperties[propertyKey] = new this.vscodeAPI.TelemetryTrustedValue(typeof propertyValue === 'string' ? propertyValue : propertyValue.value);
            }
        }
        this.sendTelemetryEvent(eventName, modifiedProperties, measurements);
    }
    /**
     * **DANGEROUS** Given an event name, some properties, and measurements sends a telemetry event without checking telemetry setting
     * Do not use unless in a controlled environment i.e. sending telmetry from a CI pipeline or testing during development
     * @param eventName The name of the event
     * @param properties The properties to send with the event
     * @param measurements The measurements (numeric values) to send with the event
     * @param sanitize Whether or not to sanitize to the properties and measures, defaults to true
     */
    sendDangerousTelemetryEvent(eventName, properties, measurements) {
        // Since telemetry is probably off when sending dangerously, we must start the sender
        this.telemetrySender.instantiateSender();
        this.internalSendTelemetryEvent(eventName, properties, measurements, true);
    }
    /**
     * Internal function which logs telemetry error events and takes extra options.
     * @param eventName The name of the event
     * @param properties The properties of the event
     * @param measurements The measurements (numeric values) to send with the event
     * @param sanitize Whether or not to sanitize to the properties and measures
     * @param dangerous Whether or not to ignore telemetry level
     */
    internalSendTelemetryErrorEvent(eventName, properties, measurements, dangerous) {
        if (dangerous) {
            this.telemetrySender.sendEventData(eventName, { properties, measurements });
        }
        else {
            this.telemetryLogger.logError(eventName, { properties, measurements });
        }
    }
    /**
     * Given an event name, some properties, and measurements sends an error event
     * @param eventName The name of the event
     * @param properties The properties to send with the event
     * @param measurements The measurements (numeric values) to send with the event
     */
    sendTelemetryErrorEvent(eventName, properties, measurements) {
        this.internalSendTelemetryErrorEvent(eventName, properties, measurements, false);
    }
    /**
     * **DANGEROUS** Given an event name, some properties, and measurements sends a telemetry error event without checking telemetry setting
     * Do not use unless in a controlled environment i.e. sending telmetry from a CI pipeline or testing during development
     * @param eventName The name of the event
     * @param properties The properties to send with the event
     * @param measurements The measurements (numeric values) to send with the event
     * @param sanitize Whether or not to run the properties and measures through sanitiziation, defaults to true
     */
    sendDangerousTelemetryErrorEvent(eventName, properties, measurements) {
        // Since telemetry is probably off when sending dangerously, we must start the sender
        this.telemetrySender.instantiateSender();
        this.internalSendTelemetryErrorEvent(eventName, properties, measurements, true);
    }
    /**
     * Disposes of the telemetry reporter
     */
    async dispose() {
        await this.telemetrySender.dispose();
        this.telemetryLogger.dispose();
        return Promise.all(this.disposables.map(d => d.dispose()));
    }
}
//# sourceMappingURL=baseTelemetryReporter.js.map

/***/ }),
/* 14 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "oneDataSystemClientFactory": () => (/* binding */ oneDataSystemClientFactory)
/* harmony export */ });
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
/**
 * Configures 1DS properly and returns the core client object
 * @param key The ingestion key
 * @param xhrOverride An optional override to use for requests instead of the XHTMLRequest object. Useful for node environments
 * @returns The AI core object
 */
const getAICore = async (key, vscodeAPI, xhrOverride) => {
    const oneDs = await Promise.resolve(/* import() eager */).then(__webpack_require__.bind(__webpack_require__, 15));
    const postPlugin = await Promise.resolve(/* import() eager */).then(__webpack_require__.bind(__webpack_require__, 55));
    const appInsightsCore = new oneDs.AppInsightsCore();
    const collectorChannelPlugin = new postPlugin.PostChannel();
    // Configure the app insights core to send to collector++ and disable logging of debug info
    const coreConfig = {
        instrumentationKey: key,
        endpointUrl: "https://mobile.events.data.microsoft.com/OneCollector/1.0",
        loggingLevelTelemetry: 0,
        loggingLevelConsole: 0,
        disableCookiesUsage: true,
        disableDbgExt: true,
        disableInstrumentationKeyValidation: true,
        channels: [[
                collectorChannelPlugin
            ]]
    };
    if (xhrOverride) {
        coreConfig.extensionConfig = {};
        // Configure the channel to use a XHR Request override since it's not available in node
        const channelConfig = {
            alwaysUseXhrOverride: true,
            httpXHROverride: xhrOverride
        };
        coreConfig.extensionConfig[collectorChannelPlugin.identifier] = channelConfig;
    }
    const config = vscodeAPI.workspace.getConfiguration("telemetry");
    const internalTesting = config.get("internalTesting");
    appInsightsCore.initialize(coreConfig, []);
    appInsightsCore.addTelemetryInitializer((envelope) => {
        // Only add this flag when `telemetry.internalTesting` is enabled
        if (!internalTesting) {
            return;
        }
        envelope["ext"] = envelope["ext"] ?? {};
        envelope["ext"]["utc"] = envelope["ext"]["utc"] ?? {};
        // Sets it to be internal only based on Windows UTC flagging
        envelope["ext"]["utc"]["flags"] = 0x0000811ECD;
    });
    return appInsightsCore;
};
/**
 * Configures and creates a telemetry client using the 1DS sdk
 * @param key The ingestion key
 * @param xhrOverride An optional override to use for requests instead of the XHTMLRequest object. Useful for node environments
 */
const oneDataSystemClientFactory = async (key, vscodeAPI, xhrOverride) => {
    let appInsightsCore = await getAICore(key, vscodeAPI, xhrOverride);
    const flushOneDS = async () => {
        try {
            const flushPromise = new Promise((resolve, reject) => {
                if (!appInsightsCore) {
                    resolve();
                    return;
                }
                appInsightsCore.flush(true, (completedFlush) => {
                    if (!completedFlush) {
                        reject("Failed to flush app 1DS!");
                        return;
                    }
                });
            });
            return flushPromise;
        }
        catch (e) {
            throw new Error("Failed to flush 1DS!\n" + e.message);
        }
    };
    // Shape the app insights core from 1DS into a standard format
    const telemetryClient = {
        logEvent: (eventName, data) => {
            try {
                appInsightsCore?.track({
                    name: eventName,
                    baseData: { name: eventName, properties: data?.properties, measurements: data?.measurements }
                });
            }
            catch (e) {
                throw new Error("Failed to log event to app insights!\n" + e.message);
            }
        },
        flush: flushOneDS,
        dispose: async () => {
            const disposePromise = new Promise((resolve) => {
                if (!appInsightsCore) {
                    resolve();
                    return;
                }
                appInsightsCore.unload(false, () => {
                    resolve();
                    appInsightsCore = undefined;
                    return;
                }, 1000);
            });
            return disposePromise;
        }
    };
    return telemetryClient;
};
//# sourceMappingURL=1dsClientFactory.js.map

/***/ }),
/* 15 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AppInsightsCore": () => (/* reexport safe */ _AppInsightsCore__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   "BaseCore": () => (/* reexport safe */ _BaseCore__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   "BaseTelemetryPlugin": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_7__.BaseTelemetryPlugin),
/* harmony export */   "CoreUtils": () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_28__.CoreUtils),
/* harmony export */   "DiagnosticLogger": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_11__.DiagnosticLogger),
/* harmony export */   "ESPromise": () => (/* reexport safe */ _ESPromise__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   "ESPromiseScheduler": () => (/* reexport safe */ _ESPromiseScheduler__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   "EventHelper": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_14__.EventHelper),
/* harmony export */   "EventLatency": () => (/* reexport safe */ _Enums__WEBPACK_IMPORTED_MODULE_0__.EventLatency),
/* harmony export */   "EventPersistence": () => (/* reexport safe */ _Enums__WEBPACK_IMPORTED_MODULE_0__.EventPersistence),
/* harmony export */   "EventPropertyType": () => (/* reexport safe */ _Enums__WEBPACK_IMPORTED_MODULE_0__.EventPropertyType),
/* harmony export */   "EventsDiscardedReason": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_10__.EventsDiscardedReason),
/* harmony export */   "FullVersionString": () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_28__.FullVersionString),
/* harmony export */   "InternalAppInsightsCore": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_15__.AppInsightsCore),
/* harmony export */   "InternalBaseCore": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__.BaseCore),
/* harmony export */   "LoggingSeverity": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_12__.LoggingSeverity),
/* harmony export */   "MinChannelPriorty": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_9__.MinChannelPriorty),
/* harmony export */   "NotificationManager": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__.NotificationManager),
/* harmony export */   "PerfEvent": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_13__.PerfEvent),
/* harmony export */   "PerfManager": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_13__.PerfManager),
/* harmony export */   "ProcessTelemetryContext": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__.ProcessTelemetryContext),
/* harmony export */   "TraceLevel": () => (/* reexport safe */ _Enums__WEBPACK_IMPORTED_MODULE_0__.TraceLevel),
/* harmony export */   "Undefined": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_23__.strShimUndefined),
/* harmony export */   "Utils": () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_28__.Utils),
/* harmony export */   "ValueKind": () => (/* reexport safe */ _Enums__WEBPACK_IMPORTED_MODULE_0__.ValueKind),
/* harmony export */   "ValueSanitizer": () => (/* reexport safe */ _ValueSanitizer__WEBPACK_IMPORTED_MODULE_5__.ValueSanitizer),
/* harmony export */   "Version": () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_28__.Version),
/* harmony export */   "_ExtendedInternalMessageId": () => (/* reexport safe */ _Enums__WEBPACK_IMPORTED_MODULE_0__._ExtendedInternalMessageId),
/* harmony export */   "_InternalLogMessage": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_11__._InternalLogMessage),
/* harmony export */   "_InternalMessageId": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_12__._InternalMessageId),
/* harmony export */   "__getRegisteredEvents": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_19__.__getRegisteredEvents),
/* harmony export */   "_logInternalMessage": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_11__._logInternalMessage),
/* harmony export */   "_throwInternal": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_11__._throwInternal),
/* harmony export */   "_warnToConsole": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_11__._warnToConsole),
/* harmony export */   "addEventHandler": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_19__.addEventHandler),
/* harmony export */   "addEventListeners": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_19__.addEventListeners),
/* harmony export */   "addPageHideEventListener": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_19__.addPageHideEventListener),
/* harmony export */   "addPageShowEventListener": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_19__.addPageShowEventListener),
/* harmony export */   "addPageUnloadEventListener": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_19__.addPageUnloadEventListener),
/* harmony export */   "areCookiesSupported": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_24__.areCookiesSupported),
/* harmony export */   "arrForEach": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.arrForEach),
/* harmony export */   "arrIndexOf": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.arrIndexOf),
/* harmony export */   "arrMap": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.arrMap),
/* harmony export */   "arrReduce": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.arrReduce),
/* harmony export */   "attachEvent": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_19__.attachEvent),
/* harmony export */   "cookieAvailable": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_24__.areCookiesSupported),
/* harmony export */   "createCookieMgr": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_24__.createCookieMgr),
/* harmony export */   "createEnumStyle": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_17__.createEnumStyle),
/* harmony export */   "createGuid": () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_28__.createGuid),
/* harmony export */   "createProcessTelemetryContext": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__.createProcessTelemetryContext),
/* harmony export */   "createTraceParent": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_27__.createTraceParent),
/* harmony export */   "createUniqueNamespace": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_25__.createUniqueNamespace),
/* harmony export */   "createUnloadHandlerContainer": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_26__.createUnloadHandlerContainer),
/* harmony export */   "dateNow": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.dateNow),
/* harmony export */   "deleteCookie": () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_28__.deleteCookie),
/* harmony export */   "detachEvent": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_19__.detachEvent),
/* harmony export */   "disableCookies": () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_28__.disableCookies),
/* harmony export */   "disallowsSameSiteNone": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_24__.uaDisallowsSameSiteNone),
/* harmony export */   "doPerf": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_13__.doPerf),
/* harmony export */   "dumpObj": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_22__.dumpObj),
/* harmony export */   "eventOff": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_19__.eventOff),
/* harmony export */   "eventOn": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_19__.eventOn),
/* harmony export */   "extend": () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_28__.extend),
/* harmony export */   "findW3cTraceParent": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_27__.findW3cTraceParent),
/* harmony export */   "formatTraceParent": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_27__.formatTraceParent),
/* harmony export */   "generateW3CId": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_14__.generateW3CId),
/* harmony export */   "getCommonSchemaMetaData": () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_28__.getCommonSchemaMetaData),
/* harmony export */   "getConsole": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_22__.getConsole),
/* harmony export */   "getCookie": () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_28__.getCookie),
/* harmony export */   "getCookieValue": () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_28__.getCookieValue),
/* harmony export */   "getCrypto": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_22__.getCrypto),
/* harmony export */   "getDocument": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_22__.getDocument),
/* harmony export */   "getExceptionName": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.getExceptionName),
/* harmony export */   "getFieldValueType": () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_28__.getFieldValueType),
/* harmony export */   "getGlobal": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_20__.getGlobal),
/* harmony export */   "getGlobalInst": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_22__.getGlobalInst),
/* harmony export */   "getHistory": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_22__.getHistory),
/* harmony export */   "getIEVersion": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_22__.getIEVersion),
/* harmony export */   "getISOString": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.toISOString),
/* harmony export */   "getJSON": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_22__.getJSON),
/* harmony export */   "getLocation": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_22__.getLocation),
/* harmony export */   "getMsCrypto": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_22__.getMsCrypto),
/* harmony export */   "getNavigator": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_22__.getNavigator),
/* harmony export */   "getPerformance": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_22__.getPerformance),
/* harmony export */   "getSetValue": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.getSetValue),
/* harmony export */   "getTenantId": () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_28__.getTenantId),
/* harmony export */   "getTime": () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_28__.getTime),
/* harmony export */   "getWindow": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_22__.getWindow),
/* harmony export */   "hasDocument": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_22__.hasDocument),
/* harmony export */   "hasHistory": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_22__.hasHistory),
/* harmony export */   "hasJSON": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_22__.hasJSON),
/* harmony export */   "hasNavigator": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_22__.hasNavigator),
/* harmony export */   "hasOwnProperty": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.hasOwnProperty),
/* harmony export */   "hasWindow": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_22__.hasWindow),
/* harmony export */   "isArray": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.isArray),
/* harmony export */   "isArrayValid": () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_28__.isArrayValid),
/* harmony export */   "isBeaconsSupported": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_22__.isBeaconsSupported),
/* harmony export */   "isBoolean": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.isBoolean),
/* harmony export */   "isChromium": () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_28__.isChromium),
/* harmony export */   "isDate": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.isDate),
/* harmony export */   "isDocumentObjectAvailable": () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_28__.isDocumentObjectAvailable),
/* harmony export */   "isError": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.isError),
/* harmony export */   "isFetchSupported": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_22__.isFetchSupported),
/* harmony export */   "isFunction": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.isFunction),
/* harmony export */   "isIE": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_22__.isIE),
/* harmony export */   "isLatency": () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_28__.isLatency),
/* harmony export */   "isNotTruthy": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.isNotTruthy),
/* harmony export */   "isNullOrUndefined": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.isNullOrUndefined),
/* harmony export */   "isNumber": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.isNumber),
/* harmony export */   "isObject": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.isObject),
/* harmony export */   "isReactNative": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_22__.isReactNative),
/* harmony export */   "isSampledFlag": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_27__.isSampledFlag),
/* harmony export */   "isString": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.isString),
/* harmony export */   "isTruthy": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.isTruthy),
/* harmony export */   "isTypeof": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.isTypeof),
/* harmony export */   "isUint8ArrayAvailable": () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_28__.isUint8ArrayAvailable),
/* harmony export */   "isUndefined": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.isUndefined),
/* harmony export */   "isValidSpanId": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_27__.isValidSpanId),
/* harmony export */   "isValidTraceId": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_27__.isValidTraceId),
/* harmony export */   "isValidTraceParent": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_27__.isValidTraceParent),
/* harmony export */   "isValueAssigned": () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_28__.isValueAssigned),
/* harmony export */   "isValueKind": () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_28__.isValueKind),
/* harmony export */   "isWindowObjectAvailable": () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_28__.isWindowObjectAvailable),
/* harmony export */   "isXhrSupported": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_22__.isXhrSupported),
/* harmony export */   "mergeEvtNamespace": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_19__.mergeEvtNamespace),
/* harmony export */   "newGuid": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_14__.newGuid),
/* harmony export */   "newId": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_21__.newId),
/* harmony export */   "normalizeJsName": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.normalizeJsName),
/* harmony export */   "objCreate": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_20__.objCreateFn),
/* harmony export */   "objDefineAccessors": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.objDefineAccessors),
/* harmony export */   "objForEachKey": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.objForEachKey),
/* harmony export */   "objFreeze": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.objFreeze),
/* harmony export */   "objKeys": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.objKeys),
/* harmony export */   "objSeal": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.objSeal),
/* harmony export */   "openXhr": () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_28__.openXhr),
/* harmony export */   "optimizeObject": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.optimizeObject),
/* harmony export */   "parseTraceParent": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_27__.parseTraceParent),
/* harmony export */   "perfNow": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_14__.perfNow),
/* harmony export */   "proxyAssign": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.proxyAssign),
/* harmony export */   "proxyFunctionAs": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.proxyFunctionAs),
/* harmony export */   "proxyFunctions": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.proxyFunctions),
/* harmony export */   "random32": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_21__.random32),
/* harmony export */   "randomValue": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_21__.randomValue),
/* harmony export */   "removeEventHandler": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_19__.removeEventHandler),
/* harmony export */   "removeEventListeners": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_19__.removeEventListeners),
/* harmony export */   "removePageHideEventListener": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_19__.removePageHideEventListener),
/* harmony export */   "removePageShowEventListener": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_19__.removePageShowEventListener),
/* harmony export */   "removePageUnloadEventListener": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_19__.removePageUnloadEventListener),
/* harmony export */   "safeGetCookieMgr": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_24__.safeGetCookieMgr),
/* harmony export */   "safeGetLogger": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_11__.safeGetLogger),
/* harmony export */   "sanitizeProperty": () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_28__.sanitizeProperty),
/* harmony export */   "setCookie": () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_28__.setCookie),
/* harmony export */   "setEnableEnvMocks": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_22__.setEnableEnvMocks),
/* harmony export */   "setProcessTelemetryTimings": () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_28__.setProcessTelemetryTimings),
/* harmony export */   "setValue": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.setValue),
/* harmony export */   "strContains": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.strContains),
/* harmony export */   "strEndsWith": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.strEndsWith),
/* harmony export */   "strFunction": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_23__.strShimFunction),
/* harmony export */   "strObject": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_23__.strShimObject),
/* harmony export */   "strPrototype": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_23__.strShimPrototype),
/* harmony export */   "strStartsWith": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.strStartsWith),
/* harmony export */   "strTrim": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.strTrim),
/* harmony export */   "strUndefined": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_23__.strShimUndefined),
/* harmony export */   "throwError": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.throwError),
/* harmony export */   "toISOString": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.toISOString),
/* harmony export */   "useXDomainRequest": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_22__.useXDomainRequest)
/* harmony export */ });
/* harmony import */ var _Enums__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16);
/* harmony import */ var _AppInsightsCore__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(25);
/* harmony import */ var _BaseCore__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(49);
/* harmony import */ var _ESPromise__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(50);
/* harmony import */ var _ESPromiseScheduler__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(51);
/* harmony import */ var _ValueSanitizer__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(52);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(40);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(46);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(42);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(53);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(54);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(27);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(24);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(31);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(35);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(39);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(41);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(17);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(18);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(37);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(22);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(36);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(28);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(19);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(34);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(38);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(47);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(44);
/* harmony import */ var _Utils__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(33);
/*
 * 1DS JS SDK Core, 3.2.13
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */
/**
 * Index.ts
 * @author Abhilash Panwar (abpanwar)
 * @copyright Microsoft 2018
 * File to export public classes, interfaces and enums.
 */









//# sourceMappingURL=Index.js.map

/***/ }),
/* 16 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "EventLatency": () => (/* binding */ EventLatency),
/* harmony export */   "EventPersistence": () => (/* binding */ EventPersistence),
/* harmony export */   "EventPropertyType": () => (/* binding */ EventPropertyType),
/* harmony export */   "TraceLevel": () => (/* binding */ TraceLevel),
/* harmony export */   "ValueKind": () => (/* binding */ ValueKind),
/* harmony export */   "_ExtendedInternalMessageId": () => (/* binding */ _ExtendedInternalMessageId)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(23);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(18);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(24);
/*
 * 1DS JS SDK Core, 3.2.13
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */
/**
* Enums.ts
* @author Abhilash Panwar (abpanwar)
* @copyright Microsoft 2018
* File containing the enums as constants.
*/


/**
 * The ValueKind contains a set of values that specify value kind of the property.
 * Either PII (Personal Identifiable Information) or customer content.
 */
var ValueKind = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.createEnumStyle)({
    NotSet: 0 /* eValueKind.NotSet */,
    Pii_DistinguishedName: 1 /* eValueKind.Pii_DistinguishedName */,
    Pii_GenericData: 2 /* eValueKind.Pii_GenericData */,
    Pii_IPV4Address: 3 /* eValueKind.Pii_IPV4Address */,
    Pii_IPv6Address: 4 /* eValueKind.Pii_IPv6Address */,
    Pii_MailSubject: 5 /* eValueKind.Pii_MailSubject */,
    Pii_PhoneNumber: 6 /* eValueKind.Pii_PhoneNumber */,
    Pii_QueryString: 7 /* eValueKind.Pii_QueryString */,
    Pii_SipAddress: 8 /* eValueKind.Pii_SipAddress */,
    Pii_SmtpAddress: 9 /* eValueKind.Pii_SmtpAddress */,
    Pii_Identity: 10 /* eValueKind.Pii_Identity */,
    Pii_Uri: 11 /* eValueKind.Pii_Uri */,
    Pii_Fqdn: 12 /* eValueKind.Pii_Fqdn */,
    Pii_IPV4AddressLegacy: 13 /* eValueKind.Pii_IPV4AddressLegacy */,
    CustomerContent_GenericContent: 32 /* eValueKind.CustomerContent_GenericContent */
});
/**
 * The EventLatency contains a set of values that specify the latency with which an event is sent.
 */
var EventLatency = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.createEnumStyle)({
    /**
     * Normal latency.
     */
    Normal: 1 /* EventLatencyValue.Normal */,
    /**
     * Cost deferred latency. At the moment this latency is treated as Normal latency.
     */
    CostDeferred: 2 /* EventLatencyValue.CostDeferred */,
    /**
     * Real time latency.
     */
    RealTime: 3 /* EventLatencyValue.RealTime */,
    /**
     * Bypass normal batching/timing and send as soon as possible, this will still send asynchronously.
     * Added in v3.1.1
     */
    Immediate: 4 /* EventLatencyValue.Immediate */
});
/**
 * Enum for property types.
 */
var EventPropertyType = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.createEnumStyle)({
    Unspecified: 0 /* eEventPropertyType.Unspecified */,
    String: 1 /* eEventPropertyType.String */,
    Int32: 2 /* eEventPropertyType.Int32 */,
    UInt32: 3 /* eEventPropertyType.UInt32 */,
    Int64: 4 /* eEventPropertyType.Int64 */,
    UInt64: 5 /* eEventPropertyType.UInt64 */,
    Double: 6 /* eEventPropertyType.Double */,
    Bool: 7 /* eEventPropertyType.Bool */,
    Guid: 8 /* eEventPropertyType.Guid */,
    DateTime: 9 /* eEventPropertyType.DateTime */
});
/**
 * The EventPersistence contains a set of values that specify the event's persistence.
 */
var EventPersistence = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.createEnumStyle)({
    /**
     * Normal persistence.
     */
    Normal: 1 /* EventPersistenceValue.Normal */,
    /**
     * Critical persistence.
     */
    Critical: 2 /* EventPersistenceValue.Critical */
});
var TraceLevel = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.createEnumStyle)({
    NONE: 0 /* eTraceLevel.NONE */,
    ERROR: 1 /* eTraceLevel.ERROR */,
    WARNING: 2 /* eTraceLevel.WARNING */,
    INFORMATION: 3 /* eTraceLevel.INFORMATION */
});
var _ExtendedInternalMessageId = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.objFreeze)((0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_2__.__assignFn)((0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_2__.__assignFn)({}, _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__._InternalMessageId), (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.createEnumStyle)({
    AuthHandShakeError: 501 /* _eExtendedInternalMessageId.AuthHandShakeError */,
    AuthRedirectFail: 502 /* _eExtendedInternalMessageId.AuthRedirectFail */,
    BrowserCannotReadLocalStorage: 503 /* _eExtendedInternalMessageId.BrowserCannotReadLocalStorage */,
    BrowserCannotWriteLocalStorage: 504 /* _eExtendedInternalMessageId.BrowserCannotWriteLocalStorage */,
    BrowserDoesNotSupportLocalStorage: 505 /* _eExtendedInternalMessageId.BrowserDoesNotSupportLocalStorage */,
    CannotParseBiBlobValue: 506 /* _eExtendedInternalMessageId.CannotParseBiBlobValue */,
    CannotParseDataAttribute: 507 /* _eExtendedInternalMessageId.CannotParseDataAttribute */,
    CVPluginNotAvailable: 508 /* _eExtendedInternalMessageId.CVPluginNotAvailable */,
    DroppedEvent: 509 /* _eExtendedInternalMessageId.DroppedEvent */,
    ErrorParsingAISessionCookie: 510 /* _eExtendedInternalMessageId.ErrorParsingAISessionCookie */,
    ErrorProvidedChannels: 511 /* _eExtendedInternalMessageId.ErrorProvidedChannels */,
    FailedToGetCookies: 512 /* _eExtendedInternalMessageId.FailedToGetCookies */,
    FailedToInitializeCorrelationVector: 513 /* _eExtendedInternalMessageId.FailedToInitializeCorrelationVector */,
    FailedToInitializeSDK: 514 /* _eExtendedInternalMessageId.FailedToInitializeSDK */,
    InvalidContentBlob: 515 /* _eExtendedInternalMessageId.InvalidContentBlob */,
    InvalidCorrelationValue: 516 /* _eExtendedInternalMessageId.InvalidCorrelationValue */,
    SessionRenewalDateIsZero: 517 /* _eExtendedInternalMessageId.SessionRenewalDateIsZero */,
    SendPostOnCompleteFailure: 518 /* _eExtendedInternalMessageId.SendPostOnCompleteFailure */,
    PostResponseHandler: 519 /* _eExtendedInternalMessageId.PostResponseHandler */,
    SDKNotInitialized: 520 /* _eExtendedInternalMessageId.SDKNotInitialized */
})));
//# sourceMappingURL=Enums.js.map

/***/ }),
/* 17 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "createEnumMap": () => (/* binding */ createEnumMap),
/* harmony export */   "createEnumStyle": () => (/* binding */ createEnumStyle),
/* harmony export */   "createValueMap": () => (/* binding */ createValueMap)
/* harmony export */ });
/* harmony import */ var _JavaScriptSDK_HelperFuncs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(18);
/*
 * Application Insights JavaScript SDK - Core, 2.8.15
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */



/**
 * Create an enum style object which has both the key => value and value => key mappings
 * @param values - The values to populate on the new object
 * @returns
 */
function createEnumStyle(values) {
    var enumClass = {};
    (0,_JavaScriptSDK_HelperFuncs__WEBPACK_IMPORTED_MODULE_0__.objForEachKey)(values, function (field, value) {
        enumClass[field] = value;
        enumClass[value] = field;
    });
    return (0,_JavaScriptSDK_HelperFuncs__WEBPACK_IMPORTED_MODULE_0__.deepFreeze)(enumClass);
}
/**
 * Create a 2 index map that maps an enum's key as both the key and value, X["key"] => "key" and X[0] => "keyof 0".
 * @param values - The values to populate on the new object
 * @returns
 */
function createEnumMap(values) {
    var mapClass = {};
    (0,_JavaScriptSDK_HelperFuncs__WEBPACK_IMPORTED_MODULE_0__.objForEachKey)(values, function (field, value) {
        mapClass[field] = field;
        mapClass[value] = field;
    });
    return (0,_JavaScriptSDK_HelperFuncs__WEBPACK_IMPORTED_MODULE_0__.deepFreeze)(mapClass);
}
/**
 * Create a 2 index map that maps an enum's key and value to the defined map value, X["key"] => mapValue and X[0] => mapValue.
 * Generic values
 * - E = the const enum type (typeof eRequestHeaders);
 * - V = Identifies the valid values for the keys, this should include both the enum numeric and string key of the type. The
 * resulting "Value" of each entry identifies the valid values withing the assignments.
 * @param values - The values to populate on the new object
 * @returns
 */
function createValueMap(values) {
    var mapClass = {};
    (0,_JavaScriptSDK_HelperFuncs__WEBPACK_IMPORTED_MODULE_0__.objForEachKey)(values, function (field, value) {
        mapClass[field] = value[1];
        mapClass[value[0]] = value[1];
    });
    return (0,_JavaScriptSDK_HelperFuncs__WEBPACK_IMPORTED_MODULE_0__.deepFreeze)(mapClass);
}
//# sourceMappingURL=EnumHelperFuncs.js.map

/***/ }),
/* 18 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "_getObjProto": () => (/* binding */ _getObjProto),
/* harmony export */   "_strEndsWithPoly": () => (/* binding */ _strEndsWithPoly),
/* harmony export */   "_strStartsWithPoly": () => (/* binding */ _strStartsWithPoly),
/* harmony export */   "_toISOStringPoly": () => (/* binding */ _toISOStringPoly),
/* harmony export */   "arrForEach": () => (/* binding */ arrForEach),
/* harmony export */   "arrIndexOf": () => (/* binding */ arrIndexOf),
/* harmony export */   "arrMap": () => (/* binding */ arrMap),
/* harmony export */   "arrReduce": () => (/* binding */ arrReduce),
/* harmony export */   "createClassFromInterface": () => (/* binding */ createClassFromInterface),
/* harmony export */   "dateNow": () => (/* binding */ dateNow),
/* harmony export */   "deepFreeze": () => (/* binding */ deepFreeze),
/* harmony export */   "getCfgValue": () => (/* binding */ getCfgValue),
/* harmony export */   "getExceptionName": () => (/* binding */ getExceptionName),
/* harmony export */   "getSetValue": () => (/* binding */ getSetValue),
/* harmony export */   "hasOwnProperty": () => (/* binding */ hasOwnProperty),
/* harmony export */   "isArray": () => (/* binding */ isArray),
/* harmony export */   "isBoolean": () => (/* binding */ isBoolean),
/* harmony export */   "isDate": () => (/* binding */ isDate),
/* harmony export */   "isError": () => (/* binding */ isError),
/* harmony export */   "isFunction": () => (/* binding */ isFunction),
/* harmony export */   "isNotNullOrUndefined": () => (/* binding */ isNotNullOrUndefined),
/* harmony export */   "isNotTruthy": () => (/* binding */ isNotTruthy),
/* harmony export */   "isNotUndefined": () => (/* binding */ isNotUndefined),
/* harmony export */   "isNullOrUndefined": () => (/* binding */ isNullOrUndefined),
/* harmony export */   "isNumber": () => (/* binding */ isNumber),
/* harmony export */   "isObject": () => (/* binding */ isObject),
/* harmony export */   "isPlainObject": () => (/* binding */ isPlainObject),
/* harmony export */   "isPromiseLike": () => (/* binding */ isPromiseLike),
/* harmony export */   "isString": () => (/* binding */ isString),
/* harmony export */   "isSymbol": () => (/* binding */ isSymbol),
/* harmony export */   "isTruthy": () => (/* binding */ isTruthy),
/* harmony export */   "isTypeof": () => (/* binding */ isTypeof),
/* harmony export */   "isUndefined": () => (/* binding */ isUndefined),
/* harmony export */   "normalizeJsName": () => (/* binding */ normalizeJsName),
/* harmony export */   "objDefineAccessors": () => (/* binding */ objDefineAccessors),
/* harmony export */   "objExtend": () => (/* binding */ objExtend),
/* harmony export */   "objForEachKey": () => (/* binding */ objForEachKey),
/* harmony export */   "objFreeze": () => (/* binding */ objFreeze),
/* harmony export */   "objKeys": () => (/* binding */ objKeys),
/* harmony export */   "objSeal": () => (/* binding */ objSeal),
/* harmony export */   "objToString": () => (/* binding */ objToString),
/* harmony export */   "optimizeObject": () => (/* binding */ optimizeObject),
/* harmony export */   "proxyAssign": () => (/* binding */ proxyAssign),
/* harmony export */   "proxyFunctionAs": () => (/* binding */ proxyFunctionAs),
/* harmony export */   "proxyFunctions": () => (/* binding */ proxyFunctions),
/* harmony export */   "setValue": () => (/* binding */ setValue),
/* harmony export */   "strContains": () => (/* binding */ strContains),
/* harmony export */   "strEndsWith": () => (/* binding */ strEndsWith),
/* harmony export */   "strStartsWith": () => (/* binding */ strStartsWith),
/* harmony export */   "strTrim": () => (/* binding */ strTrim),
/* harmony export */   "throwError": () => (/* binding */ throwError),
/* harmony export */   "toISOString": () => (/* binding */ toISOString)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19);
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(22);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(20);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(21);
/*
 * Application Insights JavaScript SDK - Core, 2.8.15
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */





// RESTRICT and AVOID circular dependencies you should not import other contained modules or export the contents of this file directly
// Added to help with minfication
var strToISOString = "toISOString";
var cStrEndsWith = "endsWith";
var cStrStartsWith = "startsWith";
var strIndexOf = "indexOf";
var strMap = "map";
var strReduce = "reduce";
var cStrTrim = "trim";
var strToString = "toString";
/**
 * Constant string defined to support minimization
 * @ignore
 */
var str__Proto = "__proto__";
/**
  * Constant string defined to support minimization
  * @ignore
  */
var strConstructor = "constructor";
var _objDefineProperty = _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.ObjDefineProperty;
var _objFreeze = _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.ObjClass.freeze;
var _objSeal = _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.ObjClass.seal;
var _objKeys = _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.ObjClass.keys;
var StringProto = String[_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.strShimPrototype];
var _strTrim = StringProto[cStrTrim];
var _strEndsWith = StringProto[cStrEndsWith];
var _strStartsWith = StringProto[cStrStartsWith];
var DateProto = Date[_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.strShimPrototype];
var _dataToISOString = DateProto[strToISOString];
var _isArray = Array.isArray;
var _objToString = _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.ObjProto[strToString];
var _fnToString = _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.ObjHasOwnProperty[strToString];
// Cache what this browser reports as the object function constructor (as a string)
var _objFunctionString = _fnToString[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_CALL /* @min:%2ecall */](_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.ObjClass);
var rCamelCase = /-([a-z])/g;
var rNormalizeInvalid = /([^\w\d_$])/g;
var rLeadingNumeric = /^(\d+[\w\d_$])/;
/**
 * Pre-lookup to check if we are running on a modern browser (i.e. not IE8)
 * @ignore
 */
var _objGetPrototypeOf = Object["getPrototypeOf"];
/**
  * Helper used to get the prototype of the target object as getPrototypeOf is not available in an ES3 environment.
  * @ignore
  */
function _getObjProto(target) {
    if (target) {
        // This method doesn't existing in older browsers (e.g. IE8)
        if (_objGetPrototypeOf) {
            return _objGetPrototypeOf(target);
        }
        // target[Constructor] May break if the constructor has been changed or removed
        var newProto = target[str__Proto] || target[_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.strShimPrototype] || target[strConstructor];
        if (newProto) {
            return newProto;
        }
    }
    return null;
}
function objToString(obj) {
    return _objToString[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_CALL /* @min:%2ecall */](obj);
}
function isTypeof(value, theType) {
    return typeof value === theType;
}
function isUndefined(value) {
    return value === undefined || typeof value === _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.strShimUndefined;
}
function isNotUndefined(value) {
    return !isUndefined(value);
}
function isNullOrUndefined(value) {
    return (value === null || isUndefined(value));
}
function isNotNullOrUndefined(value) {
    return !isNullOrUndefined(value);
}
function hasOwnProperty(obj, prop) {
    return !!(obj && _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.ObjHasOwnProperty[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_CALL /* @min:%2ecall */](obj, prop));
}
function isObject(value) {
    // Changing to inline for performance
    return !!(value && typeof value === _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.strShimObject);
}
function isFunction(value) {
    // Changing to inline for performance
    return !!(value && typeof value === _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.strShimFunction);
}
function isPromiseLike(value) {
    return value && isFunction(value.then);
}
/**
 * Validates that the string name conforms to the JS IdentifierName specification and if not
 * normalizes the name so that it would. This method does not identify or change any keywords
 * meaning that if you pass in a known keyword the same value will be returned.
 * This is a simplified version
 * @param name The name to validate
 */
function normalizeJsName(name) {
    var value = name;
    if (value && isString(value)) {
        // CamelCase everything after the "-" and remove the dash
        value = value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_REPLACE /* @min:%2ereplace */](rCamelCase, function (_all, letter) {
            return letter.toUpperCase();
        });
        value = value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_REPLACE /* @min:%2ereplace */](rNormalizeInvalid, "_");
        value = value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_REPLACE /* @min:%2ereplace */](rLeadingNumeric, function (_all, match) {
            return "_" + match;
        });
    }
    return value;
}
/**
 * This is a helper function for the equivalent of arForEach(objKeys(target), callbackFn), this is a
 * performance optimization to avoid the creation of a new array for large objects
 * @param target The target object to find and process the keys
 * @param callbackfn The function to call with the details
 */
function objForEachKey(target, callbackfn) {
    if (target) {
        for (var prop in target) {
            if (_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.ObjHasOwnProperty[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_CALL /* @min:%2ecall */](target, prop)) {
                callbackfn[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_CALL /* @min:%2ecall */](target, prop, target[prop]);
            }
        }
    }
}
/**
 * The strEndsWith() method determines whether a string ends with the characters of a specified string, returning true or false as appropriate.
 * @param value - The value to check whether it ends with the search value.
 * @param search - The characters to be searched for at the end of the value.
 * @returns true if the given search value is found at the end of the string, otherwise false.
 */
function strEndsWith(value, search) {
    var result = false;
    if (value && search && !(result = value === search)) {
        // For Performance try and use the native instance, using string lookup of the function to easily pass the ES3 build checks and minification
        result = _strEndsWith ? value[cStrEndsWith](search) : _strEndsWithPoly(value, search);
    }
    return result;
}
/**
 * The _strEndsWith() method determines whether a string ends with the characters of a specified string, returning true or false as appropriate.
 * @param value - The value to check whether it ends with the search value.
 * @param search - The characters to be searched for at the end of the value.
 * @returns true if the given search value is found at the end of the string, otherwise false.
 */
function _strEndsWithPoly(value, search) {
    var result = false;
    var searchLen = search ? search[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] : 0;
    var valLen = value ? value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] : 0;
    if (searchLen && valLen && valLen >= searchLen && !(result = value === search)) {
        var pos = valLen - 1;
        for (var lp = searchLen - 1; lp >= 0; lp--) {
            if (value[pos] != search[lp]) {
                return false;
            }
            pos--;
        }
        result = true;
    }
    return result;
}
/**
 * The strStartsWith() method determines whether a string starts with the characters of the specified string, returning true or false as appropriate.
 * @param value - The value to check whether it ends with the search value.
 * @param checkValue - The characters to be searched for at the start of the value.
 * @returns true if the given search value is found at the start of the string, otherwise false.
 */
function strStartsWith(value, checkValue) {
    var result = false;
    if (value && checkValue && !(result = value === checkValue)) {
        // For Performance try and use the native instance, using string lookup of the function to easily pass the ES3 build checks and minification
        result = _strStartsWith ? value[cStrStartsWith](checkValue) : _strStartsWithPoly(value, checkValue);
    }
    return result;
}
/**
 * The strStartsWith() method determines whether a string starts with the characters of the specified string, returning true or false as appropriate.
 * @param value - The value to check whether it ends with the search value.
 * @param checkValue - The characters to be searched for at the start of the value.
 * @returns true if the given search value is found at the start of the string, otherwise false.
 */
function _strStartsWithPoly(value, checkValue) {
    // Using helper for performance and because string startsWith() is not available on IE
    var result = false;
    var chkLen = checkValue ? checkValue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] : 0;
    if (value && chkLen && value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] >= chkLen && !(result = value === checkValue)) {
        for (var lp = 0; lp < chkLen; lp++) {
            if (value[lp] !== checkValue[lp]) {
                return false;
            }
        }
        result = true;
    }
    return result;
}
/**
 * A simple wrapper (for minification support) to check if the value contains the search string.
 * @param value - The string value to check for the existence of the search value
 * @param search - The value search within the value
 */
function strContains(value, search) {
    if (value && search) {
        return value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_INDEX_OF /* @min:%2eindexOf */](search) !== -1;
    }
    return false;
}
/**
 * Check if an object is of type Date
 */
function isDate(obj) {
    return !!(obj && _objToString[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_CALL /* @min:%2ecall */](obj) === "[object Date]");
}
/**
 * Check if an object is of type Array with optional generic T, the generic type is not validated
 * and exists to help with TypeScript validation only.
 */
var isArray = _isArray || _isArrayPoly;
function _isArrayPoly(obj) {
    return !!(obj && _objToString[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_CALL /* @min:%2ecall */](obj) === "[object Array]");
}
/**
 * Check if an object is of type Error
 */
function isError(obj) {
    return !!(obj && _objToString[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_CALL /* @min:%2ecall */](obj) === "[object Error]");
}
/**
 * Checks if the type of value is a string.
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a string, false otherwise.
 */
function isString(value) {
    // Changing to inline for performance
    return typeof value === "string";
}
/**
 * Checks if the type of value is a number.
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a number, false otherwise.
 */
function isNumber(value) {
    // Changing to inline for performance
    return typeof value === "number";
}
/**
 * Checks if the type of value is a boolean.
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a boolean, false otherwise.
 */
function isBoolean(value) {
    // Changing to inline for performance
    return typeof value === "boolean";
}
/**
 * Checks if the type of value is a Symbol.
 * This only returns a boolean as returning value is Symbol will cause issues for older TypeScript consumers
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a Symbol, false otherwise.
 */
function isSymbol(value) {
    return typeof value === "symbol";
}
/**
 * Checks if the type of the value is a normal plain object (not a null or data)
 * @param value
 */
function isPlainObject(value) {
    var result = false;
    if (value && typeof value === "object") {
        // Inlining _objGetPrototypeOf for performance to avoid an additional function call
        var proto = _objGetPrototypeOf ? _objGetPrototypeOf(value) : _getObjProto(value);
        if (!proto) {
            // No prototype found so this is a plain Object eg. 'Object.create(null)'
            result = true;
        }
        else {
            // Objects that have a prototype are plain only if they were created using the Object global (native) function
            if (proto[strConstructor] && _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.ObjHasOwnProperty[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_CALL /* @min:%2ecall */](proto, strConstructor)) {
                proto = proto[strConstructor];
            }
            result = typeof proto === _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.strShimFunction && _fnToString[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_CALL /* @min:%2ecall */](proto) === _objFunctionString;
        }
    }
    return result;
}
/**
 * Convert a date to I.S.O. format in IE8
 */
function toISOString(date) {
    if (date) {
        // For Performance try and use the native instance, using string lookup of the function to easily pass the ES3 build checks and minification
        return _dataToISOString ? date[strToISOString]() : _toISOStringPoly(date);
    }
}
/**
 * Convert a date to I.S.O. format in IE8
 */
function _toISOStringPoly(date) {
    if (date && date.getUTCFullYear) {
        var pad = function (num) {
            var r = String(num);
            if (r[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] === 1) {
                r = "0" + r;
            }
            return r;
        };
        return date.getUTCFullYear()
            + "-" + pad(date.getUTCMonth() + 1)
            + "-" + pad(date.getUTCDate())
            + "T" + pad(date.getUTCHours())
            + ":" + pad(date.getUTCMinutes())
            + ":" + pad(date.getUTCSeconds())
            + "." + String((date.getUTCMilliseconds() / 1000).toFixed(3)).slice(2, 5)
            + "Z";
    }
}
/**
 * Performs the specified action for each element in an array. This helper exists to avoid adding a polyfil for older browsers
 * that do not define Array.prototype.xxxx (eg. ES3 only, IE8) just in case any page checks for presence/absence of the prototype
 * implementation. Note: For consistency this will not use the Array.prototype.xxxx implementation if it exists as this would
 * cause a testing requirement to test with and without the implementations
 * @param callbackfn  A function that accepts up to three arguments. forEach calls the callbackfn function one time for each element in the array. It can return -1 to break out of the loop
 * @param thisArg  [Optional] An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.
 */
function arrForEach(arr, callbackfn, thisArg) {
    var len = arr[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */];
    try {
        for (var idx = 0; idx < len; idx++) {
            if (idx in arr) {
                if (callbackfn[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_CALL /* @min:%2ecall */](thisArg || arr, arr[idx], idx, arr) === -1) {
                    break;
                }
            }
        }
    }
    catch (e) {
        // This can happen with some native browser objects, but should not happen for the type we are checking for
    }
}
/**
 * Returns the index of the first occurrence of a value in an array. This helper exists to avoid adding a polyfil for older browsers
 * that do not define Array.prototype.xxxx (eg. ES3 only, IE8) just in case any page checks for presence/absence of the prototype
 * implementation. Note: For consistency this will not use the Array.prototype.xxxx implementation if it exists as this would
 * cause a testing requirement to test with and without the implementations
 * @param searchElement The value to locate in the array.
 * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the search starts at index 0.
 */
function arrIndexOf(arr, searchElement, fromIndex) {
    if (arr) {
        // For Performance try and use the native instance, using string lookup of the function to easily pass the ES3 build checks and minification
        if (arr[strIndexOf]) {
            return arr[strIndexOf](searchElement, fromIndex);
        }
        var len = arr[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */];
        var from = fromIndex || 0;
        try {
            for (var lp = Math.max(from >= 0 ? from : len - Math.abs(from), 0); lp < len; lp++) {
                if (lp in arr && arr[lp] === searchElement) {
                    return lp;
                }
            }
        }
        catch (e) {
            // This can happen with some native browser objects, but should not happen for the type we are checking for
        }
    }
    return -1;
}
/**
 * Calls a defined callback function on each element of an array, and returns an array that contains the results. This helper exists
 * to avoid adding a polyfil for older browsers that do not define Array.prototype.xxxx (eg. ES3 only, IE8) just in case any page
 * checks for presence/absence of the prototype implementation. Note: For consistency this will not use the Array.prototype.xxxx
 * implementation if it exists as this would cause a testing requirement to test with and without the implementations
 * @param callbackfn A function that accepts up to three arguments. The map method calls the callbackfn function one time for each element in the array.
 * @param thisArg An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.
 */
function arrMap(arr, callbackfn, thisArg) {
    var results;
    if (arr) {
        // For Performance try and use the native instance, using string lookup of the function to easily pass the ES3 build checks and minification
        if (arr[strMap]) {
            return arr[strMap](callbackfn, thisArg);
        }
        var len = arr[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */];
        var _this = thisArg || arr;
        results = new Array(len);
        try {
            for (var lp = 0; lp < len; lp++) {
                if (lp in arr) {
                    results[lp] = callbackfn[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_CALL /* @min:%2ecall */](_this, arr[lp], arr);
                }
            }
        }
        catch (e) {
            // This can happen with some native browser objects, but should not happen for the type we are checking for
        }
    }
    return results;
}
/**
 * Calls the specified callback function for all the elements in an array. The return value of the callback function is the accumulated result, and is
 * provided as an argument in the next call to the callback function. This helper exists to avoid adding a polyfil for older browsers that do not define
 * Array.prototype.xxxx (eg. ES3 only, IE8) just in case any page checks for presence/absence of the prototype implementation. Note: For consistency
 * this will not use the Array.prototype.xxxx implementation if it exists as this would cause a testing requirement to test with and without the implementations
 * @param callbackfn A function that accepts up to four arguments. The reduce method calls the callbackfn function one time for each element in the array.
 * @param initialValue If initialValue is specified, it is used as the initial value to start the accumulation. The first call to the callbackfn function provides this value as an argument instead of an array value.
 */
function arrReduce(arr, callbackfn, initialValue) {
    var value;
    if (arr) {
        // For Performance try and use the native instance, using string lookup of the function to easily pass the ES3 build checks and minification
        if (arr[strReduce]) {
            return arr[strReduce](callbackfn, initialValue);
        }
        var len = arr[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */];
        var lp = 0;
        // Specifically checking the number of passed arguments as the value could be anything
        if (arguments[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] >= 3) {
            value = arguments[2];
        }
        else {
            while (lp < len && !(lp in arr)) {
                lp++;
            }
            value = arr[lp++];
        }
        while (lp < len) {
            if (lp in arr) {
                value = callbackfn(value, arr[lp], lp, arr);
            }
            lp++;
        }
    }
    return value;
}
/**
 * helper method to trim strings (IE8 does not implement String.prototype.trim)
 */
function strTrim(str) {
    if (str) {
        // For Performance try and use the native instance, using string lookup of the function to easily pass the ES3 build checks and minification
        str = (_strTrim && str[cStrTrim]) ? str[cStrTrim]() : (str[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_REPLACE /* @min:%2ereplace */] ? str[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_REPLACE /* @min:%2ereplace */](/^\s+|(?=\s)\s+$/g, _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY) : str);
    }
    return str;
}
var _objKeysHasDontEnumBug = !({ toString: null }).propertyIsEnumerable("toString");
var _objKeysDontEnums = [
    "toString",
    "toLocaleString",
    "valueOf",
    "hasOwnProperty",
    "isPrototypeOf",
    "propertyIsEnumerable",
    "constructor"
];
/**
 * Returns the names of the enumerable string properties and methods of an object. This helper exists to avoid adding a polyfil for older browsers
 * that do not define Object.keys eg. ES3 only, IE8 just in case any page checks for presence/absence of the prototype implementation.
 * Note: For consistency this will not use the Object.keys implementation if it exists as this would cause a testing requirement to test with and without the implementations
 * @param obj Object that contains the properties and methods. This can be an object that you created or an existing Document Object Model (DOM) object.
 */
function objKeys(obj) {
    var objType = typeof obj;
    if (objType !== _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.strShimFunction && (objType !== _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.strShimObject || obj === null)) {
        (0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_3__.throwTypeError)("objKeys called on non-object");
    }
    // For Performance try and use the native instance, using string lookup of the function to easily pass the ES3 build checks and minification
    if (!_objKeysHasDontEnumBug && _objKeys) {
        return _objKeys(obj);
    }
    var result = [];
    for (var prop in obj) {
        if (obj && _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.ObjHasOwnProperty[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_CALL /* @min:%2ecall */](obj, prop)) {
            result[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PUSH /* @min:%2epush */](prop);
        }
    }
    if (_objKeysHasDontEnumBug) {
        var dontEnumsLength = _objKeysDontEnums[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */];
        for (var lp = 0; lp < dontEnumsLength; lp++) {
            if (obj && _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.ObjHasOwnProperty[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_CALL /* @min:%2ecall */](obj, _objKeysDontEnums[lp])) {
                result[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PUSH /* @min:%2epush */](_objKeysDontEnums[lp]);
            }
        }
    }
    return result;
}
/**
 * Try to define get/set object property accessors for the target object/prototype, this will provide compatibility with
 * existing API definition when run within an ES5+ container that supports accessors but still enable the code to be loaded
 * and executed in an ES3 container, providing basic IE8 compatibility.
 * @param target The object on which to define the property.
 * @param prop The name of the property to be defined or modified.
 * @param getProp The getter function to wire against the getter.
 * @param setProp The setter function to wire against the setter.
 * @returns True if it was able to create the accessors otherwise false
 */
function objDefineAccessors(target, prop, getProp, setProp) {
    if (_objDefineProperty) {
        try {
            var descriptor = {
                enumerable: true,
                configurable: true
            };
            if (getProp) {
                descriptor.get = getProp;
            }
            if (setProp) {
                descriptor.set = setProp;
            }
            _objDefineProperty(target, prop, descriptor);
            return true;
        }
        catch (e) {
            // IE8 Defines a defineProperty on Object but it's only supported for DOM elements so it will throw
            // We will just ignore this here.
        }
    }
    return false;
}
function _doNothing(value) {
    return value;
}
function deepFreeze(obj) {
    if (_objFreeze) {
        objForEachKey(obj, function (name, value) {
            if (isArray(value) || isObject(value)) {
                _objFreeze(value);
            }
        });
    }
    return objFreeze(obj);
}
var objFreeze = _objFreeze || _doNothing;
var objSeal = _objSeal || _doNothing;
/**
 * Return the current time via the Date now() function (if available) and falls back to (new Date()).getTime() if now() is unavailable (IE8 or less)
 * https://caniuse.com/#search=Date.now
 */
function dateNow() {
    var dt = Date;
    return dt.now ? dt.now() : new dt().getTime();
}
/**
 * Returns the name of object if it's an Error. Otherwise, returns empty string.
 */
function getExceptionName(object) {
    if (isError(object)) {
        return object[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_NAME /* @min:%2ename */];
    }
    return _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY;
}
/**
 * Sets the provided value on the target instance using the field name when the provided chk function returns true, the chk
 * function will only be called if the new value is no equal to the original value.
 * @param target - The target object
 * @param field - The key of the target
 * @param value - The value to set
 * @param valChk - [Optional] Callback to check the value that if supplied will be called check if the new value can be set
 * @param srcChk - [Optional] Callback to check to original value that if supplied will be called if the new value should be set (if allowed)
 * @returns The existing or new value, depending what was set
 */
function setValue(target, field, value, valChk, srcChk) {
    var theValue = value;
    if (target) {
        theValue = target[field];
        if (theValue !== value && (!srcChk || srcChk(theValue)) && (!valChk || valChk(value))) {
            theValue = value;
            target[field] = theValue;
        }
    }
    return theValue;
}
/**
 * Returns the current value from the target object if not null or undefined otherwise sets the new value and returns it
 * @param target - The target object to return or set the default value
 * @param field - The key for the field to set on the target
 * @param defValue - [Optional] The value to set if not already present, when not provided a empty object will be added
 */
function getSetValue(target, field, defValue) {
    var theValue;
    if (target) {
        theValue = target[field];
        if (!theValue && isNullOrUndefined(theValue)) {
            // Supports having the default as null
            theValue = !isUndefined(defValue) ? defValue : {};
            target[field] = theValue;
        }
    }
    else {
        // Expanded for performance so we only check defValue if required
        theValue = !isUndefined(defValue) ? defValue : {};
    }
    return theValue;
}
/**
 * Get the mapped config value, if null or undefined any supplied defaultValue will be returned.
 * @param field - The name of the field as the named enum value (number) or the string name.
 * @param defaultValue - The default value to return if the config field is not present, null or undefined.
 */
function getCfgValue(theValue, defaultValue) {
    return !isNullOrUndefined(theValue) ? theValue : defaultValue;
}
function isNotTruthy(value) {
    return !value;
}
function isTruthy(value) {
    return !!value;
}
function throwError(message) {
    throw new Error(message);
}
function _createProxyFunction(source, funcName) {
    var srcFunc = null;
    var src = null;
    if (isFunction(source)) {
        srcFunc = source;
    }
    else {
        src = source;
    }
    return function () {
        // Capture the original arguments passed to the method
        var originalArguments = arguments;
        if (srcFunc) {
            src = srcFunc();
        }
        if (src) {
            return src[funcName][_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_APPLY /* @min:%2eapply */](src, originalArguments);
        }
    };
}
/**
 * Effectively assigns all enumerable properties (not just own properties) and functions (including inherited prototype) from
 * the source object to the target, it attempts to use proxy getters / setters (if possible) and proxy functions to avoid potential
 * implementation issues by assigning prototype functions as instance ones
 *
 * This method is the primary method used to "update" the snippet proxy with the ultimate implementations.
 *
 * Special ES3 Notes:
 * Updates (setting) of direct property values on the target or indirectly on the source object WILL NOT WORK PROPERLY, updates to the
 * properties of "referenced" object will work (target.context.newValue = 10 => will be reflected in the source.context as it's the
 * same object). ES3 Failures: assigning target.myProp = 3 -> Won't change source.myProp = 3, likewise the reverse would also fail.
 * @param target - The target object to be assigned with the source properties and functions
 * @param source - The source object which will be assigned / called by setting / calling the targets proxies
 * @param chkSet - An optional callback to determine whether a specific property/function should be proxied
 */
function proxyAssign(target, source, chkSet) {
    if (target && source && isObject(target) && isObject(source)) {
        var _loop_1 = function (field) {
            if (isString(field)) {
                var value = source[field];
                if (isFunction(value)) {
                    if (!chkSet || chkSet(field, true, source, target)) {
                        // Create a proxy function rather than just copying the (possible) prototype to the new object as an instance function
                        target[field] = _createProxyFunction(source, field);
                    }
                }
                else if (!chkSet || chkSet(field, false, source, target)) {
                    if (hasOwnProperty(target, field)) {
                        // Remove any previous instance property
                        delete target[field];
                    }
                    if (!objDefineAccessors(target, field, function () {
                        return source[field];
                    }, function (theValue) {
                        source[field] = theValue;
                    })) {
                        // Unable to create an accessor, so just assign the values as a fallback
                        // -- this will (mostly) work for objects
                        // -- but will fail for accessing primitives (if the source changes it) and all types of "setters" as the source won't be modified
                        target[field] = value;
                    }
                }
            }
        };
        // effectively apply/proxy full source to the target instance
        for (var field in source) {
            _loop_1(field);
        }
    }
    return target;
}
/**
 * Creates a proxy function on the target which internally will call the source version with all arguments passed to the target method.
 *
 * @param target - The target object to be assigned with the source properties and functions
 * @param name - The function name that will be added on the target
 * @param source - The source object which will be assigned / called by setting / calling the targets proxies
 * @param theFunc - The function name on the source that will be proxied on the target
 * @param overwriteTarget - If `false` this will not replace any pre-existing name otherwise (the default) it will overwrite any existing name
 */
function proxyFunctionAs(target, name, source, theFunc, overwriteTarget) {
    if (target && name && source) {
        if (overwriteTarget !== false || isUndefined(target[name])) {
            target[name] = _createProxyFunction(source, theFunc);
        }
    }
}
/**
 * Creates proxy functions on the target which internally will call the source version with all arguments passed to the target method.
 *
 * @param target - The target object to be assigned with the source properties and functions
 * @param source - The source object which will be assigned / called by setting / calling the targets proxies
 * @param functionsToProxy - An array of function names that will be proxied on the target
 * @param overwriteTarget - If false this will not replace any pre-existing name otherwise (the default) it will overwrite any existing name
 */
function proxyFunctions(target, source, functionsToProxy, overwriteTarget) {
    if (target && source && isObject(target) && isArray(functionsToProxy)) {
        arrForEach(functionsToProxy, function (theFuncName) {
            if (isString(theFuncName)) {
                proxyFunctionAs(target, theFuncName, source, theFuncName, overwriteTarget);
            }
        });
    }
    return target;
}
/**
 * Simpler helper to create a dynamic class that implements the interface and populates the values with the defaults.
 * Only instance properties (hasOwnProperty) values are copied from the defaults to the new instance
 * @param defaults Simple helper
 */
function createClassFromInterface(defaults) {
    return /** @class */ (function () {
        function class_1() {
            var _this_1 = this;
            if (defaults) {
                objForEachKey(defaults, function (field, value) {
                    _this_1[field] = value;
                });
            }
        }
        return class_1;
    }());
}
/**
 * A helper function to assist with JIT performance for objects that have properties added / removed dynamically
 * this is primarily for chromium based browsers and has limited effects on Firefox and none of IE. Only call this
 * function after you have finished "updating" the object, calling this within loops reduces or defeats the benefits.
 * This helps when iterating using for..in, objKeys() and objForEach()
 * @param theObject - The object to be optimized if possible
 */
function optimizeObject(theObject) {
    // V8 Optimization to cause the JIT compiler to create a new optimized object for looking up the own properties
    // primarily for object with <= 19 properties for >= 20 the effect is reduced or non-existent
    if (theObject && _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.ObjAssign) {
        theObject = (0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.ObjClass)((0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.ObjAssign)({}, theObject));
    }
    return theObject;
}
function objExtend(obj1, obj2, obj3, obj4, obj5, obj6) {
    // Variables
    var theArgs = arguments;
    var extended = theArgs[0] || {};
    var argLen = theArgs[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */];
    var deep = false;
    var idx = 1;
    // Check for "Deep" flag
    if (argLen > 0 && isBoolean(extended)) {
        deep = extended;
        extended = theArgs[idx] || {};
        idx++;
    }
    // Handle case when target is a string or something (possible in deep copy)
    if (!isObject(extended)) {
        extended = {};
    }
    // Loop through each remaining object and conduct a merge
    for (; idx < argLen; idx++) {
        var arg = theArgs[idx];
        var isArgArray = isArray(arg);
        var isArgObj = isObject(arg);
        for (var prop in arg) {
            var propOk = (isArgArray && (prop in arg)) || (isArgObj && (_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.ObjHasOwnProperty[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_CALL /* @min:%2ecall */](arg, prop)));
            if (!propOk) {
                continue;
            }
            var newValue = arg[prop];
            var isNewArray = void 0;
            // If deep merge and property is an object, merge properties
            if (deep && newValue && ((isNewArray = isArray(newValue)) || isPlainObject(newValue))) {
                // Grab the current value of the extended object
                var clone = extended[prop];
                if (isNewArray) {
                    if (!isArray(clone)) {
                        // We can't "merge" an array with a non-array so overwrite the original
                        clone = [];
                    }
                }
                else if (!isPlainObject(clone)) {
                    // We can't "merge" an object with a non-object
                    clone = {};
                }
                // Never move the original objects always clone them
                newValue = objExtend(deep, clone, newValue);
            }
            // Assign the new (or previous) value (unless undefined)
            if (newValue !== undefined) {
                extended[prop] = newValue;
            }
        }
    }
    return extended;
}
//# sourceMappingURL=HelperFuncs.js.map

/***/ }),
/* 19 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ObjAssign": () => (/* binding */ ObjAssign),
/* harmony export */   "ObjClass": () => (/* binding */ ObjClass),
/* harmony export */   "ObjCreate": () => (/* binding */ ObjCreate),
/* harmony export */   "ObjDefineProperty": () => (/* binding */ ObjDefineProperty),
/* harmony export */   "ObjHasOwnProperty": () => (/* binding */ ObjHasOwnProperty),
/* harmony export */   "ObjProto": () => (/* binding */ ObjProto),
/* harmony export */   "strDefault": () => (/* binding */ strDefault),
/* harmony export */   "strShimFunction": () => (/* binding */ strShimFunction),
/* harmony export */   "strShimHasOwnProperty": () => (/* binding */ strShimHasOwnProperty),
/* harmony export */   "strShimObject": () => (/* binding */ strShimObject),
/* harmony export */   "strShimPrototype": () => (/* binding */ strShimPrototype),
/* harmony export */   "strShimUndefined": () => (/* binding */ strShimUndefined)
/* harmony export */ });
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
var strShimFunction = "function";
var strShimObject = "object";
var strShimUndefined = "undefined";
var strShimPrototype = "prototype";
var strShimHasOwnProperty = "hasOwnProperty";
var strDefault = "default";
var ObjClass = Object;
var ObjProto = ObjClass[strShimPrototype];
var ObjAssign = ObjClass["assign"];
var ObjCreate = ObjClass["create"];
var ObjDefineProperty = ObjClass["defineProperty"];
var ObjHasOwnProperty = ObjProto[strShimHasOwnProperty];
//# sourceMappingURL=Constants.js.map

/***/ }),
/* 20 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "_DYN_ADD_NOTIFICATION_LIS1": () => (/* binding */ _DYN_ADD_NOTIFICATION_LIS1),
/* harmony export */   "_DYN_APPLY": () => (/* binding */ _DYN_APPLY),
/* harmony export */   "_DYN_CALL": () => (/* binding */ _DYN_CALL),
/* harmony export */   "_DYN_COMPLETE": () => (/* binding */ _DYN_COMPLETE),
/* harmony export */   "_DYN_CONFIG": () => (/* binding */ _DYN_CONFIG),
/* harmony export */   "_DYN_COOKIE_CFG": () => (/* binding */ _DYN_COOKIE_CFG),
/* harmony export */   "_DYN_CREATE_NEW": () => (/* binding */ _DYN_CREATE_NEW),
/* harmony export */   "_DYN_DIAG_LOG": () => (/* binding */ _DYN_DIAG_LOG),
/* harmony export */   "_DYN_ENABLE_DEBUG_EXCEPTI4": () => (/* binding */ _DYN_ENABLE_DEBUG_EXCEPTI4),
/* harmony export */   "_DYN_FLUSH": () => (/* binding */ _DYN_FLUSH),
/* harmony export */   "_DYN_GET_CTX": () => (/* binding */ _DYN_GET_CTX),
/* harmony export */   "_DYN_GET_NEXT": () => (/* binding */ _DYN_GET_NEXT),
/* harmony export */   "_DYN_GET_NOTIFY_MGR": () => (/* binding */ _DYN_GET_NOTIFY_MGR),
/* harmony export */   "_DYN_GET_PLUGIN": () => (/* binding */ _DYN_GET_PLUGIN),
/* harmony export */   "_DYN_GET_PROCESS_TEL_CONT0": () => (/* binding */ _DYN_GET_PROCESS_TEL_CONT0),
/* harmony export */   "_DYN_HANDLER": () => (/* binding */ _DYN_HANDLER),
/* harmony export */   "_DYN_IDENTIFIER": () => (/* binding */ _DYN_IDENTIFIER),
/* harmony export */   "_DYN_INDEX_OF": () => (/* binding */ _DYN_INDEX_OF),
/* harmony export */   "_DYN_INITIALIZE": () => (/* binding */ _DYN_INITIALIZE),
/* harmony export */   "_DYN_INSTRUMENTATION_KEY": () => (/* binding */ _DYN_INSTRUMENTATION_KEY),
/* harmony export */   "_DYN_IS_ASYNC": () => (/* binding */ _DYN_IS_ASYNC),
/* harmony export */   "_DYN_IS_CHILD_EVT": () => (/* binding */ _DYN_IS_CHILD_EVT),
/* harmony export */   "_DYN_IS_INITIALIZED": () => (/* binding */ _DYN_IS_INITIALIZED),
/* harmony export */   "_DYN_LENGTH": () => (/* binding */ _DYN_LENGTH),
/* harmony export */   "_DYN_LISTENERS": () => (/* binding */ _DYN_LISTENERS),
/* harmony export */   "_DYN_LOGGER": () => (/* binding */ _DYN_LOGGER),
/* harmony export */   "_DYN_LOG_INTERNAL_MESSAGE": () => (/* binding */ _DYN_LOG_INTERNAL_MESSAGE),
/* harmony export */   "_DYN_MESSAGE": () => (/* binding */ _DYN_MESSAGE),
/* harmony export */   "_DYN_MESSAGE_ID": () => (/* binding */ _DYN_MESSAGE_ID),
/* harmony export */   "_DYN_NAME": () => (/* binding */ _DYN_NAME),
/* harmony export */   "_DYN_NODE_TYPE": () => (/* binding */ _DYN_NODE_TYPE),
/* harmony export */   "_DYN_ON_COMPLETE": () => (/* binding */ _DYN_ON_COMPLETE),
/* harmony export */   "_DYN_PROCESS_NEXT": () => (/* binding */ _DYN_PROCESS_NEXT),
/* harmony export */   "_DYN_PUSH": () => (/* binding */ _DYN_PUSH),
/* harmony export */   "_DYN_REMOVE_NOTIFICATION_2": () => (/* binding */ _DYN_REMOVE_NOTIFICATION_2),
/* harmony export */   "_DYN_REPLACE": () => (/* binding */ _DYN_REPLACE),
/* harmony export */   "_DYN_SET_CTX": () => (/* binding */ _DYN_SET_CTX),
/* harmony export */   "_DYN_SET_ENABLED": () => (/* binding */ _DYN_SET_ENABLED),
/* harmony export */   "_DYN_SET_NEXT_PLUGIN": () => (/* binding */ _DYN_SET_NEXT_PLUGIN),
/* harmony export */   "_DYN_SPAN_ID": () => (/* binding */ _DYN_SPAN_ID),
/* harmony export */   "_DYN_SPLICE": () => (/* binding */ _DYN_SPLICE),
/* harmony export */   "_DYN_SPLIT": () => (/* binding */ _DYN_SPLIT),
/* harmony export */   "_DYN_STOP_POLLING_INTERNA3": () => (/* binding */ _DYN_STOP_POLLING_INTERNA3),
/* harmony export */   "_DYN_SUBSTR": () => (/* binding */ _DYN_SUBSTR),
/* harmony export */   "_DYN_SUBSTRING": () => (/* binding */ _DYN_SUBSTRING),
/* harmony export */   "_DYN_TEARDOWN": () => (/* binding */ _DYN_TEARDOWN),
/* harmony export */   "_DYN_TIME": () => (/* binding */ _DYN_TIME),
/* harmony export */   "_DYN_TO_LOWER_CASE": () => (/* binding */ _DYN_TO_LOWER_CASE),
/* harmony export */   "_DYN_TRACE_FLAGS": () => (/* binding */ _DYN_TRACE_FLAGS),
/* harmony export */   "_DYN_TRACE_ID": () => (/* binding */ _DYN_TRACE_ID),
/* harmony export */   "_DYN_TYPE": () => (/* binding */ _DYN_TYPE),
/* harmony export */   "_DYN_UPDATE": () => (/* binding */ _DYN_UPDATE),
/* harmony export */   "_DYN_USER_AGENT": () => (/* binding */ _DYN_USER_AGENT),
/* harmony export */   "_DYN_VERSION": () => (/* binding */ _DYN_VERSION),
/* harmony export */   "_DYN__DO_TEARDOWN": () => (/* binding */ _DYN__DO_TEARDOWN),
/* harmony export */   "_DYN__EXTENSIONS": () => (/* binding */ _DYN__EXTENSIONS)
/* harmony export */ });
/*
 * Application Insights JavaScript SDK - Core, 2.8.15
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */


// @skip-file-minify
// ##############################################################
// AUTO GENERATED FILE: This file is Auto Generated during build.
// ##############################################################
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// Note: DON'T Export these const from the package as we are still targeting ES3 this will export a mutable variables that someone could change!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
var _DYN_INITIALIZE = "initialize"; // Count: 8
var _DYN_NAME = "name"; // Count: 11
var _DYN_GET_NOTIFY_MGR = "getNotifyMgr"; // Count: 3
var _DYN_IDENTIFIER = "identifier"; // Count: 8
var _DYN_PUSH = "push"; // Count: 30
var _DYN_IS_INITIALIZED = "isInitialized"; // Count: 10
var _DYN_CONFIG = "config"; // Count: 7
var _DYN_INSTRUMENTATION_KEY = "instrumentationKey"; // Count: 3
var _DYN_LOGGER = "logger"; // Count: 10
var _DYN_LENGTH = "length"; // Count: 44
var _DYN_TIME = "time"; // Count: 5
var _DYN_PROCESS_NEXT = "processNext"; // Count: 21
var _DYN_GET_PROCESS_TEL_CONT0 = "getProcessTelContext"; // Count: 2
var _DYN_ADD_NOTIFICATION_LIS1 = "addNotificationListener"; // Count: 5
var _DYN_REMOVE_NOTIFICATION_2 = "removeNotificationListener"; // Count: 5
var _DYN_STOP_POLLING_INTERNA3 = "stopPollingInternalLogs"; // Count: 2
var _DYN_ON_COMPLETE = "onComplete"; // Count: 6
var _DYN_GET_PLUGIN = "getPlugin"; // Count: 5
var _DYN_FLUSH = "flush"; // Count: 5
var _DYN__EXTENSIONS = "_extensions"; // Count: 4
var _DYN_SPLICE = "splice"; // Count: 6
var _DYN_TEARDOWN = "teardown"; // Count: 10
var _DYN_MESSAGE_ID = "messageId"; // Count: 4
var _DYN_MESSAGE = "message"; // Count: 7
var _DYN_IS_ASYNC = "isAsync"; // Count: 7
var _DYN__DO_TEARDOWN = "_doTeardown"; // Count: 4
var _DYN_UPDATE = "update"; // Count: 7
var _DYN_GET_NEXT = "getNext"; // Count: 12
var _DYN_DIAG_LOG = "diagLog"; // Count: 8
var _DYN_SET_NEXT_PLUGIN = "setNextPlugin"; // Count: 5
var _DYN_CREATE_NEW = "createNew"; // Count: 6
var _DYN_COOKIE_CFG = "cookieCfg"; // Count: 3
var _DYN_INDEX_OF = "indexOf"; // Count: 6
var _DYN_SUBSTRING = "substring"; // Count: 10
var _DYN_USER_AGENT = "userAgent"; // Count: 5
var _DYN_SPLIT = "split"; // Count: 5
var _DYN_SET_ENABLED = "setEnabled"; // Count: 5
var _DYN_SUBSTR = "substr"; // Count: 6
var _DYN_NODE_TYPE = "nodeType"; // Count: 3
var _DYN_APPLY = "apply"; // Count: 6
var _DYN_REPLACE = "replace"; // Count: 10
var _DYN_ENABLE_DEBUG_EXCEPTI4 = "enableDebugExceptions"; // Count: 2
var _DYN_LOG_INTERNAL_MESSAGE = "logInternalMessage"; // Count: 2
var _DYN_TO_LOWER_CASE = "toLowerCase"; // Count: 5
var _DYN_CALL = "call"; // Count: 18
var _DYN_TYPE = "type"; // Count: 14
var _DYN_HANDLER = "handler"; // Count: 5
var _DYN_LISTENERS = "listeners"; // Count: 6
var _DYN_IS_CHILD_EVT = "isChildEvt"; // Count: 3
var _DYN_GET_CTX = "getCtx"; // Count: 6
var _DYN_SET_CTX = "setCtx"; // Count: 10
var _DYN_COMPLETE = "complete"; // Count: 3
var _DYN_TRACE_ID = "traceId"; // Count: 5
var _DYN_SPAN_ID = "spanId"; // Count: 5
var _DYN_TRACE_FLAGS = "traceFlags"; // Count: 6
var _DYN_VERSION = "version"; // Count: 4
//# sourceMappingURL=__DynamicConstants.js.map

/***/ }),
/* 21 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "STR_CHANNELS": () => (/* binding */ STR_CHANNELS),
/* harmony export */   "STR_CORE": () => (/* binding */ STR_CORE),
/* harmony export */   "STR_CREATE_PERF_MGR": () => (/* binding */ STR_CREATE_PERF_MGR),
/* harmony export */   "STR_DISABLED": () => (/* binding */ STR_DISABLED),
/* harmony export */   "STR_EMPTY": () => (/* binding */ STR_EMPTY),
/* harmony export */   "STR_ERROR_TO_CONSOLE": () => (/* binding */ STR_ERROR_TO_CONSOLE),
/* harmony export */   "STR_EVENTS_DISCARDED": () => (/* binding */ STR_EVENTS_DISCARDED),
/* harmony export */   "STR_EVENTS_SEND_REQUEST": () => (/* binding */ STR_EVENTS_SEND_REQUEST),
/* harmony export */   "STR_EVENTS_SENT": () => (/* binding */ STR_EVENTS_SENT),
/* harmony export */   "STR_EXTENSIONS": () => (/* binding */ STR_EXTENSIONS),
/* harmony export */   "STR_EXTENSION_CONFIG": () => (/* binding */ STR_EXTENSION_CONFIG),
/* harmony export */   "STR_GET_PERF_MGR": () => (/* binding */ STR_GET_PERF_MGR),
/* harmony export */   "STR_PERF_EVENT": () => (/* binding */ STR_PERF_EVENT),
/* harmony export */   "STR_PRIORITY": () => (/* binding */ STR_PRIORITY),
/* harmony export */   "STR_PROCESS_TELEMETRY": () => (/* binding */ STR_PROCESS_TELEMETRY),
/* harmony export */   "STR_WARN_TO_CONSOLE": () => (/* binding */ STR_WARN_TO_CONSOLE)
/* harmony export */ });
/*
 * Application Insights JavaScript SDK - Core, 2.8.15
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */


// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// Note: DON'T Export these const from the package as we are still targeting ES3 this will export a mutable variables that someone could change!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
var STR_EMPTY = "";
var STR_CHANNELS = "channels";
var STR_CORE = "core";
var STR_CREATE_PERF_MGR = "createPerfMgr";
var STR_DISABLED = "disabled";
var STR_EXTENSION_CONFIG = "extensionConfig";
var STR_EXTENSIONS = "extensions";
var STR_PROCESS_TELEMETRY = "processTelemetry";
var STR_PRIORITY = "priority";
var STR_EVENTS_SENT = "eventsSent";
var STR_EVENTS_DISCARDED = "eventsDiscarded";
var STR_EVENTS_SEND_REQUEST = "eventsSendRequest";
var STR_PERF_EVENT = "perfEvent";
var STR_ERROR_TO_CONSOLE = "errorToConsole";
var STR_WARN_TO_CONSOLE = "warnToConsole";
var STR_GET_PERF_MGR = "getPerfMgr";
//# sourceMappingURL=InternalConstants.js.map

/***/ }),
/* 22 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getGlobal": () => (/* binding */ getGlobal),
/* harmony export */   "objCreateFn": () => (/* binding */ objCreateFn),
/* harmony export */   "throwTypeError": () => (/* binding */ throwTypeError)
/* harmony export */ });
/* harmony import */ var _Constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19);
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

var _cachedGlobal = null;
/**
 * Returns the current global scope object, for a normal web page this will be the current
 * window, for a Web Worker this will be current worker global scope via "self". The internal
 * implementation returns the first available instance object in the following order
 * - globalThis (New standard)
 * - self (Will return the current window instance for supported browsers)
 * - window (fallback for older browser implementations)
 * - global (NodeJS standard)
 * - <null> (When all else fails)
 * While the return type is a Window for the normal case, not all environments will support all
 * of the properties or functions.
 */
function getGlobal(useCached) {
    if (useCached === void 0) { useCached = true; }
    var result = useCached === false ? null : _cachedGlobal;
    if (!result) {
        if (typeof globalThis !== _Constants__WEBPACK_IMPORTED_MODULE_0__.strShimUndefined) {
            result = globalThis;
        }
        if (!result && typeof self !== _Constants__WEBPACK_IMPORTED_MODULE_0__.strShimUndefined) {
            result = self;
        }
        if (!result && typeof window !== _Constants__WEBPACK_IMPORTED_MODULE_0__.strShimUndefined) {
            result = window;
        }
        if (!result && typeof __webpack_require__.g !== _Constants__WEBPACK_IMPORTED_MODULE_0__.strShimUndefined) {
            result = __webpack_require__.g;
        }
        _cachedGlobal = result;
    }
    return result;
}
function throwTypeError(message) {
    throw new TypeError(message);
}
/**
 * Creates an object that has the specified prototype, and that optionally contains specified properties. This helper exists to avoid adding a polyfil
 * for older browsers that do not define Object.create eg. ES3 only, IE8 just in case any page checks for presence/absence of the prototype implementation.
 * Note: For consistency this will not use the Object.create implementation if it exists as this would cause a testing requirement to test with and without the implementations
 * @param obj Object to use as a prototype. May be null
 */
function objCreateFn(obj) {
    var func = _Constants__WEBPACK_IMPORTED_MODULE_0__.ObjCreate;
    // Use build in Object.create
    if (func) {
        // Use Object create method if it exists
        return func(obj);
    }
    if (obj == null) {
        return {};
    }
    var type = typeof obj;
    if (type !== _Constants__WEBPACK_IMPORTED_MODULE_0__.strShimObject && type !== _Constants__WEBPACK_IMPORTED_MODULE_0__.strShimFunction) {
        throwTypeError("Object prototype may only be an Object:" + obj);
    }
    function tmpFunc() { }
    tmpFunc[_Constants__WEBPACK_IMPORTED_MODULE_0__.strShimPrototype] = obj;
    return new tmpFunc();
}
//# sourceMappingURL=Helpers.js.map

/***/ }),
/* 23 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ReflectObj": () => (/* binding */ ReflectObj),
/* harmony export */   "SymbolObj": () => (/* binding */ SymbolObj),
/* harmony export */   "__assignFn": () => (/* binding */ __assignFn),
/* harmony export */   "__createBindingFn": () => (/* binding */ __createBindingFn),
/* harmony export */   "__decorateFn": () => (/* binding */ __decorateFn),
/* harmony export */   "__exportStarFn": () => (/* binding */ __exportStarFn),
/* harmony export */   "__extendsFn": () => (/* binding */ __extendsFn),
/* harmony export */   "__hasReflect": () => (/* binding */ __hasReflect),
/* harmony export */   "__hasSymbol": () => (/* binding */ __hasSymbol),
/* harmony export */   "__importDefaultFn": () => (/* binding */ __importDefaultFn),
/* harmony export */   "__importStarFn": () => (/* binding */ __importStarFn),
/* harmony export */   "__makeTemplateObjectFn": () => (/* binding */ __makeTemplateObjectFn),
/* harmony export */   "__metadataFn": () => (/* binding */ __metadataFn),
/* harmony export */   "__objAssignFnImpl": () => (/* binding */ __objAssignFnImpl),
/* harmony export */   "__paramFn": () => (/* binding */ __paramFn),
/* harmony export */   "__readFn": () => (/* binding */ __readFn),
/* harmony export */   "__restFn": () => (/* binding */ __restFn),
/* harmony export */   "__spreadArrayFn": () => (/* binding */ __spreadArrayFn),
/* harmony export */   "__spreadArraysFn": () => (/* binding */ __spreadArraysFn),
/* harmony export */   "__valuesFn": () => (/* binding */ __valuesFn)
/* harmony export */ });
/* harmony import */ var _Constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(19);
/* harmony import */ var _Helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22);
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.


// Most of these functions have been directly shamelessly "lifted" from the https://github.com/@microsoft/tslib and
// modified to be ES3 compatible and applying several minification and tree-shaking techniques so that Application Insights
// can successfully use TypeScript "importHelpers" which imports tslib during compilation but it will use these at runtime
// Which is also why all of the functions have not been included as Application Insights currently doesn't use or require
// them.
var SymbolObj = ((0,_Helpers__WEBPACK_IMPORTED_MODULE_0__.getGlobal)() || {})["Symbol"];
var ReflectObj = ((0,_Helpers__WEBPACK_IMPORTED_MODULE_0__.getGlobal)() || {})["Reflect"];
var __hasSymbol = !!SymbolObj;
var __hasReflect = !!ReflectObj;
var strDecorate = "decorate";
var strMetadata = "metadata";
var strGetOwnPropertySymbols = "getOwnPropertySymbols";
var strIterator = "iterator";
var __objAssignFnImpl = function (t) {
    // tslint:disable-next-line: ban-comma-operator
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) {
            if (_Constants__WEBPACK_IMPORTED_MODULE_1__.ObjProto[_Constants__WEBPACK_IMPORTED_MODULE_1__.strShimHasOwnProperty].call(s, p)) {
                t[p] = s[p];
            }
        }
    }
    return t;
};
var __assignFn = _Constants__WEBPACK_IMPORTED_MODULE_1__.ObjAssign || __objAssignFnImpl;
// tslint:disable-next-line: only-arrow-functions
var extendStaticsFn = function (d, b) {
    extendStaticsFn = _Constants__WEBPACK_IMPORTED_MODULE_1__.ObjClass.setPrototypeOf ||
        // tslint:disable-next-line: only-arrow-functions
        ({ __proto__: [] } instanceof Array && function (d, b) {
            d.__proto__ = b;
        }) ||
        // tslint:disable-next-line: only-arrow-functions
        function (d, b) {
            for (var p in b) {
                if (b[_Constants__WEBPACK_IMPORTED_MODULE_1__.strShimHasOwnProperty](p)) {
                    d[p] = b[p];
                }
            }
        };
    return extendStaticsFn(d, b);
};
function __extendsFn(d, b) {
    if (typeof b !== _Constants__WEBPACK_IMPORTED_MODULE_1__.strShimFunction && b !== null) {
        (0,_Helpers__WEBPACK_IMPORTED_MODULE_0__.throwTypeError)("Class extends value " + String(b) + " is not a constructor or null");
    }
    extendStaticsFn(d, b);
    function __() {
        this.constructor = d;
    }
    // tslint:disable-next-line: ban-comma-operator
    d[_Constants__WEBPACK_IMPORTED_MODULE_1__.strShimPrototype] = b === null ? (0,_Helpers__WEBPACK_IMPORTED_MODULE_0__.objCreateFn)(b) : (__[_Constants__WEBPACK_IMPORTED_MODULE_1__.strShimPrototype] = b[_Constants__WEBPACK_IMPORTED_MODULE_1__.strShimPrototype], new __());
}
function __restFn(s, e) {
    var t = {};
    for (var k in s) {
        if (_Constants__WEBPACK_IMPORTED_MODULE_1__.ObjHasOwnProperty.call(s, k) && e.indexOf(k) < 0) {
            t[k] = s[k];
        }
    }
    if (s != null && typeof _Constants__WEBPACK_IMPORTED_MODULE_1__.ObjClass[strGetOwnPropertySymbols] === _Constants__WEBPACK_IMPORTED_MODULE_1__.strShimFunction) {
        for (var i = 0, p = _Constants__WEBPACK_IMPORTED_MODULE_1__.ObjClass[strGetOwnPropertySymbols](s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && _Constants__WEBPACK_IMPORTED_MODULE_1__.ObjProto.propertyIsEnumerable.call(s, p[i])) {
                t[p[i]] = s[p[i]];
            }
        }
    }
    return t;
}
function __decorateFn(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = _Constants__WEBPACK_IMPORTED_MODULE_1__.ObjClass.getOwnPropertyDescriptor(target, key) : desc, d;
    if (__hasReflect && typeof ReflectObj[strDecorate] === _Constants__WEBPACK_IMPORTED_MODULE_1__.strShimFunction) {
        r = ReflectObj[strDecorate](decorators, target, key, desc);
    }
    else {
        for (var i = decorators.length - 1; i >= 0; i--) {
            // eslint-disable-next-line no-cond-assign
            if (d = decorators[i]) {
                r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
            }
        }
    }
    // tslint:disable-next-line:ban-comma-operator
    return c > 3 && r && (0,_Constants__WEBPACK_IMPORTED_MODULE_1__.ObjDefineProperty)(target, key, r), r;
}
function __paramFn(paramIndex, decorator) {
    return function (target, key) {
        decorator(target, key, paramIndex);
    };
}
function __metadataFn(metadataKey, metadataValue) {
    if (__hasReflect && ReflectObj[strMetadata] === _Constants__WEBPACK_IMPORTED_MODULE_1__.strShimFunction) {
        return ReflectObj[strMetadata](metadataKey, metadataValue);
    }
}
function __exportStarFn(m, o) {
    for (var p in m) {
        if (p !== _Constants__WEBPACK_IMPORTED_MODULE_1__.strDefault && !_Constants__WEBPACK_IMPORTED_MODULE_1__.ObjHasOwnProperty.call(o, p)) {
            __createBindingFn(o, m, p);
        }
    }
}
function __createBindingFn(o, m, k, k2) {
    if (k2 === undefined) {
        k2 = k;
    }
    if (!!_Constants__WEBPACK_IMPORTED_MODULE_1__.ObjCreate) {
        (0,_Constants__WEBPACK_IMPORTED_MODULE_1__.ObjDefineProperty)(o, k2, {
            enumerable: true,
            get: function () {
                return m[k];
            }
        });
    }
    else {
        o[k2] = m[k];
    }
}
function __valuesFn(o) {
    var s = typeof SymbolObj === _Constants__WEBPACK_IMPORTED_MODULE_1__.strShimFunction && SymbolObj[strIterator], m = s && o[s], i = 0;
    if (m) {
        return m.call(o);
    }
    if (o && typeof o.length === "number") {
        return {
            next: function () {
                if (o && i >= o.length) {
                    o = void 0;
                }
                return { value: o && o[i++], done: !o };
            }
        };
    }
    (0,_Helpers__WEBPACK_IMPORTED_MODULE_0__.throwTypeError)(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}
function __readFn(o, n) {
    var m = typeof SymbolObj === _Constants__WEBPACK_IMPORTED_MODULE_1__.strShimFunction && o[SymbolObj[strIterator]];
    if (!m) {
        return o;
    }
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) {
            ar.push(r.value);
        }
    }
    catch (error) {
        e = {
            error: error
        };
    }
    finally {
        try {
            // tslint:disable-next-line:no-conditional-assignment
            if (r && !r.done && (m = i["return"])) {
                m.call(i);
            }
        }
        finally {
            if (e) {
                // eslint-disable-next-line no-unsafe-finally
                throw e.error;
            }
        }
    }
    return ar;
}
/** @deprecated */
function __spreadArraysFn() {
    var theArgs = arguments;
    // Calculate new total size
    for (var s = 0, i = 0, il = theArgs.length; i < il; i++) {
        s += theArgs[i].length;
    }
    // Create new full array
    for (var r = Array(s), k = 0, i = 0; i < il; i++) {
        for (var a = theArgs[i], j = 0, jl = a.length; j < jl; j++, k++) {
            r[k] = a[j];
        }
    }
    return r;
}
function __spreadArrayFn(to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++) {
        to[j] = from[i];
    }
    return to;
}
function __makeTemplateObjectFn(cooked, raw) {
    if (_Constants__WEBPACK_IMPORTED_MODULE_1__.ObjDefineProperty) {
        (0,_Constants__WEBPACK_IMPORTED_MODULE_1__.ObjDefineProperty)(cooked, "raw", { value: raw });
    }
    else {
        cooked.raw = raw;
    }
    return cooked;
}
function __importStarFn(mod) {
    if (mod && mod.__esModule) {
        return mod;
    }
    var result = {};
    if (mod != null) {
        for (var k in mod) {
            if (k !== _Constants__WEBPACK_IMPORTED_MODULE_1__.strDefault && Object.prototype.hasOwnProperty.call(mod, k)) {
                __createBindingFn(result, mod, k);
            }
        }
    }
    // Set default module
    if (!!_Constants__WEBPACK_IMPORTED_MODULE_1__.ObjCreate) {
        (0,_Constants__WEBPACK_IMPORTED_MODULE_1__.ObjDefineProperty)(result, _Constants__WEBPACK_IMPORTED_MODULE_1__.strDefault, { enumerable: true, value: mod });
    }
    else {
        result[_Constants__WEBPACK_IMPORTED_MODULE_1__.strDefault] = mod;
    }
    return result;
}
function __importDefaultFn(mod) {
    return (mod && mod.__esModule) ? mod : { strDefault: mod };
}
//# sourceMappingURL=TsLibShims.js.map

/***/ }),
/* 24 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LoggingSeverity": () => (/* binding */ LoggingSeverity),
/* harmony export */   "_InternalMessageId": () => (/* binding */ _InternalMessageId)
/* harmony export */ });
/* harmony import */ var _JavaScriptSDK_Enums_EnumHelperFuncs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17);
/*
 * Application Insights JavaScript SDK - Core, 2.8.15
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */


//  @skip-file-minify
var _a;

var FAILED = "Failed";
var FAILED_MONITOR_AJAX = FAILED + "MonitorAjax";
var TRACK = "Track";
var START = "Start";
var STOP = "Stop";
var EVENT = "Event";
var AUTH_CONTEXT = "AuthContext";
var EXCEPTION = "Exception";
var LOCAL = "Local";
var SESSION = "Session";
var STORAGE = "Storage";
var BROWSER = "Browser";
var CANNOT = "Cannot";
var BUFFER = "Buffer";
var INSTRUMENTATION_KEY = "InstrumentationKey";
var LoggingSeverity = (0,_JavaScriptSDK_Enums_EnumHelperFuncs__WEBPACK_IMPORTED_MODULE_0__.createEnumStyle)({
    CRITICAL: 1 /* eLoggingSeverity.CRITICAL */,
    WARNING: 2 /* eLoggingSeverity.WARNING */
});
/**
 * Internal message ID. Please create a new one for every conceptually different message. Please keep alphabetically ordered
 */
var _InternalMessageId = (0,_JavaScriptSDK_Enums_EnumHelperFuncs__WEBPACK_IMPORTED_MODULE_0__.createEnumStyle)((_a = {},
    // Non user actionable
    _a[BROWSER + "DoesNotSupport" + LOCAL + STORAGE] = 0 /* _eInternalMessageId.BrowserDoesNotSupportLocalStorage */,
    _a[BROWSER + CANNOT + "Read" + LOCAL + STORAGE] = 1 /* _eInternalMessageId.BrowserCannotReadLocalStorage */,
    _a[BROWSER + CANNOT + "Read" + SESSION + STORAGE] = 2 /* _eInternalMessageId.BrowserCannotReadSessionStorage */,
    _a[BROWSER + CANNOT + "Write" + LOCAL + STORAGE] = 3 /* _eInternalMessageId.BrowserCannotWriteLocalStorage */,
    _a[BROWSER + CANNOT + "Write" + SESSION + STORAGE] = 4 /* _eInternalMessageId.BrowserCannotWriteSessionStorage */,
    _a[BROWSER + FAILED + "RemovalFrom" + LOCAL + STORAGE] = 5 /* _eInternalMessageId.BrowserFailedRemovalFromLocalStorage */,
    _a[BROWSER + FAILED + "RemovalFrom" + SESSION + STORAGE] = 6 /* _eInternalMessageId.BrowserFailedRemovalFromSessionStorage */,
    _a[CANNOT + "SendEmptyTelemetry"] = 7 /* _eInternalMessageId.CannotSendEmptyTelemetry */,
    _a.ClientPerformanceMathError = 8 /* _eInternalMessageId.ClientPerformanceMathError */,
    _a["ErrorParsingAI" + SESSION + "Cookie"] = 9 /* _eInternalMessageId.ErrorParsingAISessionCookie */,
    _a.ErrorPVCalc = 10 /* _eInternalMessageId.ErrorPVCalc */,
    _a[EXCEPTION + "WhileLoggingError"] = 11 /* _eInternalMessageId.ExceptionWhileLoggingError */,
    _a[FAILED + "AddingTelemetryTo" + BUFFER] = 12 /* _eInternalMessageId.FailedAddingTelemetryToBuffer */,
    _a[FAILED_MONITOR_AJAX + "Abort"] = 13 /* _eInternalMessageId.FailedMonitorAjaxAbort */,
    _a[FAILED_MONITOR_AJAX + "Dur"] = 14 /* _eInternalMessageId.FailedMonitorAjaxDur */,
    _a[FAILED_MONITOR_AJAX + "Open"] = 15 /* _eInternalMessageId.FailedMonitorAjaxOpen */,
    _a[FAILED_MONITOR_AJAX + "RSC"] = 16 /* _eInternalMessageId.FailedMonitorAjaxRSC */,
    _a[FAILED_MONITOR_AJAX + "Send"] = 17 /* _eInternalMessageId.FailedMonitorAjaxSend */,
    _a[FAILED_MONITOR_AJAX + "GetCorrelationHeader"] = 18 /* _eInternalMessageId.FailedMonitorAjaxGetCorrelationHeader */,
    _a[FAILED + "ToAddHandlerForOnBeforeUnload"] = 19 /* _eInternalMessageId.FailedToAddHandlerForOnBeforeUnload */,
    _a[FAILED + "ToSendQueuedTelemetry"] = 20 /* _eInternalMessageId.FailedToSendQueuedTelemetry */,
    _a[FAILED + "ToReportDataLoss"] = 21 /* _eInternalMessageId.FailedToReportDataLoss */,
    _a["Flush" + FAILED] = 22 /* _eInternalMessageId.FlushFailed */,
    _a.MessageLimitPerPVExceeded = 23 /* _eInternalMessageId.MessageLimitPerPVExceeded */,
    _a.MissingRequiredFieldSpecification = 24 /* _eInternalMessageId.MissingRequiredFieldSpecification */,
    _a.NavigationTimingNotSupported = 25 /* _eInternalMessageId.NavigationTimingNotSupported */,
    _a.OnError = 26 /* _eInternalMessageId.OnError */,
    _a[SESSION + "RenewalDateIsZero"] = 27 /* _eInternalMessageId.SessionRenewalDateIsZero */,
    _a.SenderNotInitialized = 28 /* _eInternalMessageId.SenderNotInitialized */,
    _a[START + TRACK + EVENT + FAILED] = 29 /* _eInternalMessageId.StartTrackEventFailed */,
    _a[STOP + TRACK + EVENT + FAILED] = 30 /* _eInternalMessageId.StopTrackEventFailed */,
    _a[START + TRACK + FAILED] = 31 /* _eInternalMessageId.StartTrackFailed */,
    _a[STOP + TRACK + FAILED] = 32 /* _eInternalMessageId.StopTrackFailed */,
    _a.TelemetrySampledAndNotSent = 33 /* _eInternalMessageId.TelemetrySampledAndNotSent */,
    _a[TRACK + EVENT + FAILED] = 34 /* _eInternalMessageId.TrackEventFailed */,
    _a[TRACK + EXCEPTION + FAILED] = 35 /* _eInternalMessageId.TrackExceptionFailed */,
    _a[TRACK + "Metric" + FAILED] = 36 /* _eInternalMessageId.TrackMetricFailed */,
    _a[TRACK + "PV" + FAILED] = 37 /* _eInternalMessageId.TrackPVFailed */,
    _a[TRACK + "PV" + FAILED + "Calc"] = 38 /* _eInternalMessageId.TrackPVFailedCalc */,
    _a[TRACK + "Trace" + FAILED] = 39 /* _eInternalMessageId.TrackTraceFailed */,
    _a["Transmission" + FAILED] = 40 /* _eInternalMessageId.TransmissionFailed */,
    _a[FAILED + "ToSet" + STORAGE + BUFFER] = 41 /* _eInternalMessageId.FailedToSetStorageBuffer */,
    _a[FAILED + "ToRestore" + STORAGE + BUFFER] = 42 /* _eInternalMessageId.FailedToRestoreStorageBuffer */,
    _a.InvalidBackendResponse = 43 /* _eInternalMessageId.InvalidBackendResponse */,
    _a[FAILED + "ToFixDepricatedValues"] = 44 /* _eInternalMessageId.FailedToFixDepricatedValues */,
    _a.InvalidDurationValue = 45 /* _eInternalMessageId.InvalidDurationValue */,
    _a.TelemetryEnvelopeInvalid = 46 /* _eInternalMessageId.TelemetryEnvelopeInvalid */,
    _a.CreateEnvelopeError = 47 /* _eInternalMessageId.CreateEnvelopeError */,
    // User actionable
    _a[CANNOT + "SerializeObject"] = 48 /* _eInternalMessageId.CannotSerializeObject */,
    _a[CANNOT + "SerializeObjectNonSerializable"] = 49 /* _eInternalMessageId.CannotSerializeObjectNonSerializable */,
    _a.CircularReferenceDetected = 50 /* _eInternalMessageId.CircularReferenceDetected */,
    _a["Clear" + AUTH_CONTEXT + FAILED] = 51 /* _eInternalMessageId.ClearAuthContextFailed */,
    _a[EXCEPTION + "Truncated"] = 52 /* _eInternalMessageId.ExceptionTruncated */,
    _a.IllegalCharsInName = 53 /* _eInternalMessageId.IllegalCharsInName */,
    _a.ItemNotInArray = 54 /* _eInternalMessageId.ItemNotInArray */,
    _a.MaxAjaxPerPVExceeded = 55 /* _eInternalMessageId.MaxAjaxPerPVExceeded */,
    _a.MessageTruncated = 56 /* _eInternalMessageId.MessageTruncated */,
    _a.NameTooLong = 57 /* _eInternalMessageId.NameTooLong */,
    _a.SampleRateOutOfRange = 58 /* _eInternalMessageId.SampleRateOutOfRange */,
    _a["Set" + AUTH_CONTEXT + FAILED] = 59 /* _eInternalMessageId.SetAuthContextFailed */,
    _a["Set" + AUTH_CONTEXT + FAILED + "AccountName"] = 60 /* _eInternalMessageId.SetAuthContextFailedAccountName */,
    _a.StringValueTooLong = 61 /* _eInternalMessageId.StringValueTooLong */,
    _a.StartCalledMoreThanOnce = 62 /* _eInternalMessageId.StartCalledMoreThanOnce */,
    _a.StopCalledWithoutStart = 63 /* _eInternalMessageId.StopCalledWithoutStart */,
    _a["TelemetryInitializer" + FAILED] = 64 /* _eInternalMessageId.TelemetryInitializerFailed */,
    _a.TrackArgumentsNotSpecified = 65 /* _eInternalMessageId.TrackArgumentsNotSpecified */,
    _a.UrlTooLong = 66 /* _eInternalMessageId.UrlTooLong */,
    _a[SESSION + STORAGE + BUFFER + "Full"] = 67 /* _eInternalMessageId.SessionStorageBufferFull */,
    _a[CANNOT + "AccessCookie"] = 68 /* _eInternalMessageId.CannotAccessCookie */,
    _a.IdTooLong = 69 /* _eInternalMessageId.IdTooLong */,
    _a.InvalidEvent = 70 /* _eInternalMessageId.InvalidEvent */,
    _a[FAILED_MONITOR_AJAX + "SetRequestHeader"] = 71 /* _eInternalMessageId.FailedMonitorAjaxSetRequestHeader */,
    _a["Send" + BROWSER + "InfoOnUserInit"] = 72 /* _eInternalMessageId.SendBrowserInfoOnUserInit */,
    _a["Plugin" + EXCEPTION] = 73 /* _eInternalMessageId.PluginException */,
    _a["Notification" + EXCEPTION] = 74 /* _eInternalMessageId.NotificationException */,
    _a.SnippetScriptLoadFailure = 99 /* _eInternalMessageId.SnippetScriptLoadFailure */,
    _a["Invalid" + INSTRUMENTATION_KEY] = 100 /* _eInternalMessageId.InvalidInstrumentationKey */,
    _a[CANNOT + "ParseAiBlobValue"] = 101 /* _eInternalMessageId.CannotParseAiBlobValue */,
    _a.InvalidContentBlob = 102 /* _eInternalMessageId.InvalidContentBlob */,
    _a[TRACK + "PageAction" + EVENT + FAILED] = 103 /* _eInternalMessageId.TrackPageActionEventFailed */,
    _a[FAILED + "AddingCustomDefinedRequestContext"] = 104 /* _eInternalMessageId.FailedAddingCustomDefinedRequestContext */,
    _a["InMemory" + STORAGE + BUFFER + "Full"] = 105 /* _eInternalMessageId.InMemoryStorageBufferFull */,
    _a[INSTRUMENTATION_KEY + "Deprecation"] = 106 /* _eInternalMessageId.InstrumentationKeyDeprecation */,
    _a));
//# sourceMappingURL=LoggingEnums.js.map

/***/ }),
/* 25 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23);
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(26);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(27);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(18);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(28);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(39);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(32);
/* harmony import */ var _Utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(33);
/*
 * 1DS JS SDK Core, 3.2.13
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */

/**
* AppInsightsCore.ts
* @author Abhilash Panwar (abpanwar) Hector Hernandez (hectorh)
* @copyright Microsoft 2018
*/




var AppInsightsCore = /** @class */ (function (_super) {
    (0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.__extendsFn)(AppInsightsCore, _super);
    function AppInsightsCore() {
        var _this = _super.call(this) || this;
        _this.pluginVersionStringArr = [];
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_1__["default"])(AppInsightsCore, _this, function (_self, _base) {
            if (!_self.logger || !_self.logger.queue) {
                // The AI Base can inject a No-Op logger so if not defined or the No-Op, change to use a default logger so initialization errors
                // are not dropped on the floor if one is not already defined
                _self.logger = new _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.DiagnosticLogger({ loggingLevelConsole: 1 /* eLoggingSeverity.CRITICAL */ });
            }
            _self.initialize = function (config, extensions, logger, notificationManager) {
                (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__.doPerf)(_self, function () { return "AppInsightsCore.initialize"; }, function () {
                    var _pluginVersionStringArr = _self.pluginVersionStringArr;
                    // Add default collector url
                    if (config) {
                        if (!config.endpointUrl) {
                            config.endpointUrl = _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_DEFAULT_ENDPOINT_URL;
                        }
                        var propertyStorageOverride = config.propertyStorageOverride;
                        // Validate property storage override
                        if (propertyStorageOverride && (!propertyStorageOverride.getProperty || !propertyStorageOverride.setProperty)) {
                            (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__.throwError)("Invalid property storage override passed.");
                        }
                        if (config.channels) {
                            (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__.arrForEach)(config.channels, function (channels) {
                                if (channels) {
                                    (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__.arrForEach)(channels, function (channel) {
                                        if (channel.identifier && channel.version) {
                                            var ver = channel.identifier + "=" + channel.version;
                                            _pluginVersionStringArr.push(ver);
                                        }
                                    });
                                }
                            });
                        }
                    }
                    _self.getWParam = function () {
                        return (typeof document !== "undefined" || !!config.enableWParam) ? 0 : -1;
                    };
                    if (extensions) {
                        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__.arrForEach)(extensions, function (ext) {
                            if (ext && ext.identifier && ext.version) {
                                var ver = ext.identifier + "=" + ext.version;
                                _pluginVersionStringArr.push(ver);
                            }
                        });
                    }
                    _self.pluginVersionString = _pluginVersionStringArr.join(";");
                    _self.pluginVersionStringArr = _pluginVersionStringArr;
                    try {
                        _base.initialize(config, extensions, logger, notificationManager);
                        _self.pollInternalLogs("InternalLog");
                    }
                    catch (e) {
                        var logger_1 = _self.logger;
                        var message = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__.dumpObj)(e);
                        if (message.indexOf("channels") !== -1) {
                            // Add some additional context to the underlying reported error
                            message += "\n - Channels must be provided through config.channels only!";
                        }
                        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__._throwInternal)(logger_1, 1 /* eLoggingSeverity.CRITICAL */, 514 /* _eExtendedInternalMessageId.FailedToInitializeSDK */, "SDK Initialization Failed - no telemetry will be sent: " + message);
                    }
                }, function () { return ({ config: config, extensions: extensions, logger: logger, notificationManager: notificationManager }); });
            };
            _self.track = function (item) {
                (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__.doPerf)(_self, function () { return "AppInsightsCore.track"; }, function () {
                    var telemetryItem = item;
                    if (telemetryItem) {
                        telemetryItem.timings = telemetryItem.timings || {};
                        telemetryItem.timings.trackStart = (0,_Utils__WEBPACK_IMPORTED_MODULE_7__.getTime)();
                        if (!(0,_Utils__WEBPACK_IMPORTED_MODULE_7__.isLatency)(telemetryItem.latency)) {
                            telemetryItem.latency = 1 /* EventLatencyValue.Normal */;
                        }
                        var itemExt = telemetryItem.ext = telemetryItem.ext || {};
                        itemExt.sdk = itemExt.sdk || {};
                        itemExt.sdk.ver = _Utils__WEBPACK_IMPORTED_MODULE_7__.FullVersionString;
                        var baseData = telemetryItem.baseData = telemetryItem.baseData || {};
                        baseData[_InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_PROPERTIES] = baseData[_InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_PROPERTIES] || {};
                        var itemProperties = baseData[_InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_PROPERTIES];
                        itemProperties[_InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_VERSION] = itemProperties[_InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_VERSION] || _self.pluginVersionString || _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EMPTY;
                    }
                    _base.track(telemetryItem);
                }, function () { return ({ item: item }); }, !(item.sync));
            };
        });
        return _this;
    }
// Removed Stub for AppInsightsCore.prototype.initialize.
// Removed Stub for AppInsightsCore.prototype.track.
    // This is a workaround for an IE8 bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    // this will be removed when ES3 support is dropped.
    AppInsightsCore.__ieDyn=1;

    return AppInsightsCore;
}(_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__.AppInsightsCore));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AppInsightsCore);
//# sourceMappingURL=AppInsightsCore.js.map

/***/ }),
/* 26 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ dynamicProto)
/* harmony export */ });
/*!
 * Microsoft Dynamic Proto Utility, 1.1.7
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */
var _a;
var UNDEFINED = "undefined";
/**
 * Constant string defined to support minimization
 * @ignore
 */
var Constructor = 'constructor';
/**
 * Constant string defined to support minimization
 * @ignore
 */
var Prototype = 'prototype';
/**
 * Constant string defined to support minimization
 * @ignore
 */
var strFunction = 'function';
/**
 * Used to define the name of the instance function lookup table
 * @ignore
 */
var DynInstFuncTable = '_dynInstFuncs';
/**
 * Name used to tag the dynamic prototype function
 * @ignore
 */
var DynProxyTag = '_isDynProxy';
/**
 * Name added to a prototype to define the dynamic prototype "class" name used to lookup the function table
 * @ignore
 */
var DynClassName = '_dynClass';
/**
 * Prefix added to the classname to avoid any name clashes with other instance level properties
 * @ignore
 */
var DynClassNamePrefix = '_dynCls$';
/**
 * A tag which is used to check if we have already to attempted to set the instance function if one is not present
 * @ignore
 */
var DynInstChkTag = '_dynInstChk';
/**
 * A tag which is used to check if we are allows to try and set an instance function is one is not present. Using the same
 * tag name as the function level but a different const name for readability only.
 */
var DynAllowInstChkTag = DynInstChkTag;
/**
 * The global (imported) instances where the global performance options are stored
 */
var DynProtoDefaultOptions = '_dfOpts';
/**
 * Value used as the name of a class when it cannot be determined
 * @ignore
 */
var UnknownValue = '_unknown_';
/**
 * Constant string defined to support minimization
 * @ignore
 */
var str__Proto = "__proto__";
/**
 * The polyfill version of __proto__ so that it doesn't cause issues for anyone not expecting it to exist
 */
var DynProtoBaseProto = "_dyn" + str__Proto;
/**
 * Runtime Global holder for dynamicProto settings
 */
var DynProtoGlobalSettings = "__dynProto$Gbl";
/**
 * Track the current prototype for IE8 as you can't look back to get the prototype
 */
var DynProtoCurrent = "_dynInstProto";
/**
 * Constant string defined to support minimization
 * @ignore
 */
var strUseBaseInst = 'useBaseInst';
/**
 * Constant string defined to support minimization
 * @ignore
 */
var strSetInstFuncs = 'setInstFuncs';
var Obj = Object;
/**
 * Pre-lookup to check if we are running on a modern browser (i.e. not IE8)
 * @ignore
 */
var _objGetPrototypeOf = Obj["getPrototypeOf"];
/**
 * Pre-lookup to check for the existence of this function
 */
var _objGetOwnProps = Obj["getOwnPropertyNames"];
/**
 * Gets the runtime global reference
 * @returns
 */
function _getGlobal() {
    var result;
    if (typeof globalThis !== UNDEFINED) {
        result = globalThis;
    }
    if (!result && typeof self !== UNDEFINED) {
        result = self;
    }
    if (!result && typeof window !== UNDEFINED) {
        result = window;
    }
    if (!result && typeof __webpack_require__.g !== UNDEFINED) {
        result = __webpack_require__.g;
    }
    return result || {};
}
// Since 1.1.7 moving these to the runtime global to work around mixed version and module issues
// See Issue https://github.com/microsoft/DynamicProto-JS/issues/57 for details
var _gbl = _getGlobal();
var _gblInst = _gbl[DynProtoGlobalSettings] || (_gbl[DynProtoGlobalSettings] = {
    o: (_a = {},
        _a[strSetInstFuncs] = true,
        _a[strUseBaseInst] = true,
        _a),
    n: 1000 // Start new global index @ 1000 so we "fix" some cases when mixed with 1.1.6 or earlier
});
/**
 * Helper to check if the object contains a property of the name
 * @ignore
 */
function _hasOwnProperty(obj, prop) {
    return obj && Obj[Prototype].hasOwnProperty.call(obj, prop);
}
/**
 * Helper used to check whether the target is an Object prototype or Array prototype
 * @ignore
 */
function _isObjectOrArrayPrototype(target) {
    return target && (target === Obj[Prototype] || target === Array[Prototype]);
}
/**
 * Helper used to check whether the target is an Object prototype, Array prototype or Function prototype
 * @ignore
 */
function _isObjectArrayOrFunctionPrototype(target) {
    return _isObjectOrArrayPrototype(target) || target === Function[Prototype];
}
/**
 * Helper used to get the prototype of the target object as getPrototypeOf is not available in an ES3 environment.
 * @ignore
 */
function _getObjProto(target) {
    var newProto;
    if (target) {
        // This method doesn't exist in older browsers (e.g. IE8)
        if (_objGetPrototypeOf) {
            return _objGetPrototypeOf(target);
        }
        var curProto = target[str__Proto] || target[Prototype] || (target[Constructor] ? target[Constructor][Prototype] : null);
        // Using the pre-calculated value as IE8 doesn't support looking up the prototype of a prototype and thus fails for more than 1 base class
        newProto = target[DynProtoBaseProto] || curProto;
        if (!_hasOwnProperty(target, DynProtoBaseProto)) {
            // As this prototype doesn't have this property then this is from an inherited class so newProto is the base to return so save it
            // so we can look it up value (which for a multiple hierarchy dynamicProto will be the base class)
            delete target[DynProtoCurrent]; // Delete any current value allocated to this instance so we pick up the value from prototype hierarchy
            newProto = target[DynProtoBaseProto] = target[DynProtoCurrent] || target[DynProtoBaseProto];
            target[DynProtoCurrent] = curProto;
        }
    }
    return newProto;
}
/**
 * Helper to get the properties of an object, including none enumerable ones as functions on a prototype in ES6
 * are not enumerable.
 * @param target
 */
function _forEachProp(target, func) {
    var props = [];
    if (_objGetOwnProps) {
        props = _objGetOwnProps(target);
    }
    else {
        for (var name_1 in target) {
            if (typeof name_1 === "string" && _hasOwnProperty(target, name_1)) {
                props.push(name_1);
            }
        }
    }
    if (props && props.length > 0) {
        for (var lp = 0; lp < props.length; lp++) {
            func(props[lp]);
        }
    }
}
/**
 * Helper function to check whether the provided function name is a potential candidate for dynamic
 * callback and prototype generation.
 * @param target The target object, may be a prototype or class object
 * @param funcName The function name
 * @param skipOwn Skips the check for own property
 * @ignore
 */
function _isDynamicCandidate(target, funcName, skipOwn) {
    return (funcName !== Constructor && typeof target[funcName] === strFunction && (skipOwn || _hasOwnProperty(target, funcName)));
}
/**
 * Helper to throw a TypeError exception
 * @param message the message
 * @ignore
 */
function _throwTypeError(message) {
    throw new TypeError("DynamicProto: " + message);
}
/**
 * Returns a collection of the instance functions that are defined directly on the thisTarget object, it does
 * not return any inherited functions
 * @param thisTarget The object to get the instance functions from
 * @ignore
 */
function _getInstanceFuncs(thisTarget) {
    // Get the base proto
    var instFuncs = {};
    // Save any existing instance functions
    _forEachProp(thisTarget, function (name) {
        // Don't include any dynamic prototype instances - as we only want the real functions
        if (!instFuncs[name] && _isDynamicCandidate(thisTarget, name, false)) {
            // Create an instance callback for passing the base function to the caller
            instFuncs[name] = thisTarget[name];
        }
    });
    return instFuncs;
}
/**
 * Returns whether the value is included in the array
 * @param values The array of values
 * @param value  The value
 */
function _hasVisited(values, value) {
    for (var lp = values.length - 1; lp >= 0; lp--) {
        if (values[lp] === value) {
            return true;
        }
    }
    return false;
}
/**
 * Returns an object that contains callback functions for all "base/super" functions, this is used to "save"
 * enabling calling super.xxx() functions without requiring that the base "class" has defined a prototype references
 * @param target The current instance
 * @ignore
 */
function _getBaseFuncs(classProto, thisTarget, instFuncs, useBaseInst) {
    function _instFuncProxy(target, funcHost, funcName) {
        var theFunc = funcHost[funcName];
        if (theFunc[DynProxyTag] && useBaseInst) {
            // grab and reuse the hosted looking function (if available) otherwise the original passed function
            var instFuncTable = target[DynInstFuncTable] || {};
            if (instFuncTable[DynAllowInstChkTag] !== false) {
                theFunc = (instFuncTable[funcHost[DynClassName]] || {})[funcName] || theFunc;
            }
        }
        return function () {
            // eslint-disable-next-line prefer-rest-params
            return theFunc.apply(target, arguments);
        };
    }
    // Start creating a new baseFuncs by creating proxies for the instance functions (as they may get replaced)
    var baseFuncs = {};
    _forEachProp(instFuncs, function (name) {
        // Create an instance callback for passing the base function to the caller
        baseFuncs[name] = _instFuncProxy(thisTarget, instFuncs, name);
    });
    // Get the base prototype functions
    var baseProto = _getObjProto(classProto);
    var visited = [];
    // Don't include base object functions for Object, Array or Function
    while (baseProto && !_isObjectArrayOrFunctionPrototype(baseProto) && !_hasVisited(visited, baseProto)) {
        // look for prototype functions
        _forEachProp(baseProto, function (name) {
            // Don't include any dynamic prototype instances - as we only want the real functions
            // For IE 7/8 the prototype lookup doesn't provide the full chain so we need to bypass the 
            // hasOwnProperty check we get all of the methods, main difference is that IE7/8 doesn't return
            // the Object prototype methods while bypassing the check
            if (!baseFuncs[name] && _isDynamicCandidate(baseProto, name, !_objGetPrototypeOf)) {
                // Create an instance callback for passing the base function to the caller
                baseFuncs[name] = _instFuncProxy(thisTarget, baseProto, name);
            }
        });
        // We need to find all possible functions that might be overloaded by walking the entire prototype chain
        // This avoids the caller from needing to check whether it's direct base class implements the function or not
        // by walking the entire chain it simplifies the usage and issues from upgrading any of the base classes.
        visited.push(baseProto);
        baseProto = _getObjProto(baseProto);
    }
    return baseFuncs;
}
function _getInstFunc(target, funcName, proto, currentDynProtoProxy) {
    var instFunc = null;
    // We need to check whether the class name is defined directly on this prototype otherwise
    // it will walk the proto chain and return any parent proto classname.
    if (target && _hasOwnProperty(proto, DynClassName)) {
        var instFuncTable = target[DynInstFuncTable] || {};
        instFunc = (instFuncTable[proto[DynClassName]] || {})[funcName];
        if (!instFunc) {
            // Avoid stack overflow from recursive calling the same function
            _throwTypeError("Missing [" + funcName + "] " + strFunction);
        }
        // We have the instance function, lets check it we can speed up further calls
        // by adding the instance function back directly on the instance (avoiding the dynamic func lookup)
        if (!instFunc[DynInstChkTag] && instFuncTable[DynAllowInstChkTag] !== false) {
            // If the instance already has an instance function we can't replace it
            var canAddInst = !_hasOwnProperty(target, funcName);
            // Get current prototype
            var objProto = _getObjProto(target);
            var visited = [];
            // Lookup the function starting at the top (instance level prototype) and traverse down, if the first matching function
            // if nothing is found or if the first hit is a dynamic proto instance then we can safely add an instance shortcut
            while (canAddInst && objProto && !_isObjectArrayOrFunctionPrototype(objProto) && !_hasVisited(visited, objProto)) {
                var protoFunc = objProto[funcName];
                if (protoFunc) {
                    canAddInst = (protoFunc === currentDynProtoProxy);
                    break;
                }
                // We need to find all possible initial functions to ensure that we don't bypass a valid override function
                visited.push(objProto);
                objProto = _getObjProto(objProto);
            }
            try {
                if (canAddInst) {
                    // This instance doesn't have an instance func and the class hierarchy does have a higher level prototype version
                    // so it's safe to directly assign for any subsequent calls (for better performance)
                    target[funcName] = instFunc;
                }
                // Block further attempts to set the instance function for any
                instFunc[DynInstChkTag] = 1;
            }
            catch (e) {
                // Don't crash if the object is readonly or the runtime doesn't allow changing this
                // And set a flag so we don't try again for any function
                instFuncTable[DynAllowInstChkTag] = false;
            }
        }
    }
    return instFunc;
}
function _getProtoFunc(funcName, proto, currentDynProtoProxy) {
    var protoFunc = proto[funcName];
    // Check that the prototype function is not a self reference -- try to avoid stack overflow!
    if (protoFunc === currentDynProtoProxy) {
        // It is so lookup the base prototype
        protoFunc = _getObjProto(proto)[funcName];
    }
    if (typeof protoFunc !== strFunction) {
        _throwTypeError("[" + funcName + "] is not a " + strFunction);
    }
    return protoFunc;
}
/**
 * Add the required dynamic prototype methods to the the class prototype
 * @param proto - The class prototype
 * @param className - The instance classname
 * @param target - The target instance
 * @param baseInstFuncs - The base instance functions
 * @param setInstanceFunc - Flag to allow prototype function to reset the instance function if one does not exist
 * @ignore
 */
function _populatePrototype(proto, className, target, baseInstFuncs, setInstanceFunc) {
    function _createDynamicPrototype(proto, funcName) {
        var dynProtoProxy = function () {
            // Use the instance or prototype function
            var instFunc = _getInstFunc(this, funcName, proto, dynProtoProxy) || _getProtoFunc(funcName, proto, dynProtoProxy);
            // eslint-disable-next-line prefer-rest-params
            return instFunc.apply(this, arguments);
        };
        // Tag this function as a proxy to support replacing dynamic proxy elements (primary use case is for unit testing
        // via which can dynamically replace the prototype function reference)
        dynProtoProxy[DynProxyTag] = 1;
        return dynProtoProxy;
    }
    if (!_isObjectOrArrayPrototype(proto)) {
        var instFuncTable = target[DynInstFuncTable] = target[DynInstFuncTable] || {};
        var instFuncs_1 = instFuncTable[className] = (instFuncTable[className] || {}); // fetch and assign if as it may not exist yet
        // Set whether we are allow to lookup instances, if someone has set to false then do not re-enable
        if (instFuncTable[DynAllowInstChkTag] !== false) {
            instFuncTable[DynAllowInstChkTag] = !!setInstanceFunc;
        }
        _forEachProp(target, function (name) {
            // Only add overridden functions
            if (_isDynamicCandidate(target, name, false) && target[name] !== baseInstFuncs[name]) {
                // Save the instance Function to the lookup table and remove it from the instance as it's not a dynamic proto function
                instFuncs_1[name] = target[name];
                delete target[name];
                // Add a dynamic proto if one doesn't exist or if a prototype function exists and it's not a dynamic one
                if (!_hasOwnProperty(proto, name) || (proto[name] && !proto[name][DynProxyTag])) {
                    proto[name] = _createDynamicPrototype(proto, name);
                }
            }
        });
    }
}
/**
 * Checks whether the passed prototype object appears to be correct by walking the prototype hierarchy of the instance
 * @param classProto The class prototype instance
 * @param thisTarget The current instance that will be checked whether the passed prototype instance is in the hierarchy
 * @ignore
 */
function _checkPrototype(classProto, thisTarget) {
    // This method doesn't existing in older browsers (e.g. IE8)
    if (_objGetPrototypeOf) {
        // As this is primarily a coding time check, don't bother checking if running in IE8 or lower
        var visited = [];
        var thisProto = _getObjProto(thisTarget);
        while (thisProto && !_isObjectArrayOrFunctionPrototype(thisProto) && !_hasVisited(visited, thisProto)) {
            if (thisProto === classProto) {
                return true;
            }
            // This avoids the caller from needing to check whether it's direct base class implements the function or not
            // by walking the entire chain it simplifies the usage and issues from upgrading any of the base classes.
            visited.push(thisProto);
            thisProto = _getObjProto(thisProto);
        }
        return false;
    }
    // If objGetPrototypeOf doesn't exist then just assume everything is ok.
    return true;
}
/**
 * Gets the current prototype name using the ES6 name if available otherwise falling back to a use unknown as the name.
 * It's not critical for this to return a name, it's used to decorate the generated unique name for easier debugging only.
 * @param target
 * @param unknownValue
 * @ignore
 */
function _getObjName(target, unknownValue) {
    if (_hasOwnProperty(target, Prototype)) {
        // Look like a prototype
        return target.name || unknownValue || UnknownValue;
    }
    return (((target || {})[Constructor]) || {}).name || unknownValue || UnknownValue;
}
/**
 * Helper function when creating dynamic (inline) functions for classes, this helper performs the following tasks :-
 * - Saves references to all defined base class functions
 * - Calls the delegateFunc with the current target (this) and a base object reference that can be used to call all "super" functions.
 * - Will populate the class prototype for all overridden functions to support class extension that call the prototype instance.
 * Callers should use this helper when declaring all function within the constructor of a class, as mentioned above the delegateFunc is
 * passed both the target "this" and an object that can be used to call any base (super) functions, using this based object in place of
 * super.XXX() (which gets expanded to _super.prototype.XXX()) provides a better minification outcome and also ensures the correct "this"
 * context is maintained as TypeScript creates incorrect references using super.XXXX() for dynamically defined functions i.e. Functions
 * defined in the constructor or some other function (rather than declared as complete typescript functions).
 * ### Usage
 * ```typescript
 * import dynamicProto from "@microsoft/dynamicproto-js";
 * class ExampleClass extends BaseClass {
 *     constructor() {
 *         dynamicProto(ExampleClass, this, (_self, base) => {
 *             // This will define a function that will be converted to a prototype function
 *             _self.newFunc = () => {
 *                 // Access any "this" instance property
 *                 if (_self.someProperty) {
 *                     ...
 *                 }
 *             }
 *             // This will define a function that will be converted to a prototype function
 *             _self.myFunction = () => {
 *                 // Access any "this" instance property
 *                 if (_self.someProperty) {
 *                     // Call the base version of the function that we are overriding
 *                     base.myFunction();
 *                 }
 *                 ...
 *             }
 *             _self.initialize = () => {
 *                 ...
 *             }
 *             // Warnings: While the following will work as _self is simply a reference to
 *             // this, if anyone overrides myFunction() the overridden will be called first
 *             // as the normal JavaScript method resolution will occur and the defined
 *             // _self.initialize() function is actually gets removed from the instance and
 *             // a proxy prototype version is created to reference the created method.
 *             _self.initialize();
 *         });
 *     }
 * }
 * ```
 * @typeparam DPType This is the generic type of the class, used to keep intellisense valid
 * @typeparam DPCls The type that contains the prototype of the current class
 * @param theClass - This is the current class instance which contains the prototype for the current class
 * @param target - The current "this" (target) reference, when the class has been extended this.prototype will not be the 'theClass' value.
 * @param delegateFunc - The callback function (closure) that will create the dynamic function
 * @param options - Additional options to configure how the dynamic prototype operates
 */
function dynamicProto(theClass, target, delegateFunc, options) {
    // Make sure that the passed theClass argument looks correct
    if (!_hasOwnProperty(theClass, Prototype)) {
        _throwTypeError("theClass is an invalid class definition.");
    }
    // Quick check to make sure that the passed theClass argument looks correct (this is a common copy/paste error)
    var classProto = theClass[Prototype];
    if (!_checkPrototype(classProto, target)) {
        _throwTypeError("[" + _getObjName(theClass) + "] not in hierarchy of [" + _getObjName(target) + "]");
    }
    var className = null;
    if (_hasOwnProperty(classProto, DynClassName)) {
        // Only grab the class name if it's defined on this prototype (i.e. don't walk the prototype chain)
        className = classProto[DynClassName];
    }
    else {
        // As not all browser support name on the prototype creating a unique dynamic one if we have not already
        // assigned one, so we can use a simple string as the lookup rather than an object for the dynamic instance
        // function table lookup.
        className = DynClassNamePrefix + _getObjName(theClass, "_") + "$" + _gblInst.n;
        _gblInst.n++;
        classProto[DynClassName] = className;
    }
    var perfOptions = dynamicProto[DynProtoDefaultOptions];
    var useBaseInst = !!perfOptions[strUseBaseInst];
    if (useBaseInst && options && options[strUseBaseInst] !== undefined) {
        useBaseInst = !!options[strUseBaseInst];
    }
    // Get the current instance functions
    var instFuncs = _getInstanceFuncs(target);
    // Get all of the functions for any base instance (before they are potentially overridden)
    var baseFuncs = _getBaseFuncs(classProto, target, instFuncs, useBaseInst);
    // Execute the delegate passing in both the current target "this" and "base" function references
    // Note casting the same type as we don't actually have the base class here and this will provide some intellisense support
    delegateFunc(target, baseFuncs);
    // Don't allow setting instance functions for older IE instances
    var setInstanceFunc = !!_objGetPrototypeOf && !!perfOptions[strSetInstFuncs];
    if (setInstanceFunc && options) {
        setInstanceFunc = !!options[strSetInstFuncs];
    }
    // Populate the Prototype for any overridden instance functions
    _populatePrototype(classProto, className, target, instFuncs, setInstanceFunc !== false);
}
/**
 * Exposes the default global options to allow global configuration, if the global values are disabled these will override
 * any passed values. This is primarily exposed to support unit-testing without the need for individual classes to expose
 * their internal usage of dynamic proto.
 */
dynamicProto[DynProtoDefaultOptions] = _gblInst.o;


//# sourceMappingURL=dynamicproto-js.js.map


/***/ }),
/* 27 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DiagnosticLogger": () => (/* binding */ DiagnosticLogger),
/* harmony export */   "_InternalLogMessage": () => (/* binding */ _InternalLogMessage),
/* harmony export */   "_logInternalMessage": () => (/* binding */ _logInternalMessage),
/* harmony export */   "_throwInternal": () => (/* binding */ _throwInternal),
/* harmony export */   "_warnToConsole": () => (/* binding */ _warnToConsole),
/* harmony export */   "safeGetLogger": () => (/* binding */ safeGetLogger)
/* harmony export */ });
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(29);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20);
/* harmony import */ var _DbgExtensionUtils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(30);
/* harmony import */ var _EnvUtils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(28);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(18);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(21);
/*
 * Application Insights JavaScript SDK - Core, 2.8.15
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */









/**
 * For user non actionable traces use AI Internal prefix.
 */
var AiNonUserActionablePrefix = "AI (Internal): ";
/**
 * Prefix of the traces in portal.
 */
var AiUserActionablePrefix = "AI: ";
/**
 *  Session storage key for the prefix for the key indicating message type already logged
 */
var AIInternalMessagePrefix = "AITR_";
function _sanitizeDiagnosticText(text) {
    if (text) {
        return "\"" + text[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_REPLACE /* @min:%2ereplace */](/\"/g, _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY) + "\"";
    }
    return _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY;
}
function _logToConsole(func, message) {
    var theConsole = (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_2__.getConsole)();
    if (!!theConsole) {
        var logFunc = "log";
        if (theConsole[func]) {
            logFunc = func;
        }
        if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.isFunction)(theConsole[logFunc])) {
            theConsole[logFunc](message);
        }
    }
}
var _InternalLogMessage = /** @class */ (function () {
    function _InternalLogMessage(msgId, msg, isUserAct, properties) {
        if (isUserAct === void 0) { isUserAct = false; }
        var _self = this;
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_MESSAGE_ID /* @min:%2emessageId */] = msgId;
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_MESSAGE /* @min:%2emessage */] =
            (isUserAct ? AiUserActionablePrefix : AiNonUserActionablePrefix) +
                msgId;
        var strProps = _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY;
        if ((0,_EnvUtils__WEBPACK_IMPORTED_MODULE_2__.hasJSON)()) {
            strProps = (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_2__.getJSON)().stringify(properties);
        }
        var diagnosticText = (msg ? " message:" + _sanitizeDiagnosticText(msg) : _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY) +
            (properties ? " props:" + _sanitizeDiagnosticText(strProps) : _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY);
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_MESSAGE /* @min:%2emessage */] += diagnosticText;
    }
    _InternalLogMessage.dataType = "MessageData";
    return _InternalLogMessage;
}());

function safeGetLogger(core, config) {
    return (core || {})[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LOGGER /* @min:%2elogger */] || new DiagnosticLogger(config);
}
var DiagnosticLogger = /** @class */ (function () {
    function DiagnosticLogger(config) {
        this.identifier = "DiagnosticLogger";
        /**
         * The internal logging queue
         */
        this.queue = [];
        /**
         * Count of internal messages sent
         */
        var _messageCount = 0;
        /**
         * Holds information about what message types were already logged to console or sent to server.
         */
        var _messageLogged = {};
        var _loggingLevelConsole;
        var _loggingLevelTelemetry;
        var _maxInternalMessageLimit;
        var _enableDebug;
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_4__["default"])(DiagnosticLogger, this, function (_self) {
            _setDefaultsFromConfig(config || {});
            _self.consoleLoggingLevel = function () { return _loggingLevelConsole; };
            _self.telemetryLoggingLevel = function () { return _loggingLevelTelemetry; };
            _self.maxInternalMessageLimit = function () { return _maxInternalMessageLimit; };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_ENABLE_DEBUG_EXCEPTI4 /* @min:%2eenableDebugExceptions */] = function () { return _enableDebug; };
            /**
             * This method will throw exceptions in debug mode or attempt to log the error as a console warning.
             * @param severity {LoggingSeverity} - The severity of the log message
             * @param message {_InternalLogMessage} - The log message.
             */
            _self.throwInternal = function (severity, msgId, msg, properties, isUserAct) {
                if (isUserAct === void 0) { isUserAct = false; }
                var message = new _InternalLogMessage(msgId, msg, isUserAct, properties);
                if (_enableDebug) {
                    throw (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_2__.dumpObj)(message);
                }
                else {
                    // Get the logging function and fallback to warnToConsole of for some reason errorToConsole doesn't exist
                    var logFunc = severity === 1 /* eLoggingSeverity.CRITICAL */ ? _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_ERROR_TO_CONSOLE : _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_WARN_TO_CONSOLE;
                    if (!(0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.isUndefined)(message[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_MESSAGE /* @min:%2emessage */])) {
                        if (isUserAct) {
                            // check if this message type was already logged to console for this page view and if so, don't log it again
                            var messageKey = +message[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_MESSAGE_ID /* @min:%2emessageId */];
                            if (!_messageLogged[messageKey] && _loggingLevelConsole >= severity) {
                                _self[logFunc](message[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_MESSAGE /* @min:%2emessage */]);
                                _messageLogged[messageKey] = true;
                            }
                        }
                        else {
                            // Only log traces if the console Logging Level is >= the throwInternal severity level
                            if (_loggingLevelConsole >= severity) {
                                _self[logFunc](message[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_MESSAGE /* @min:%2emessage */]);
                            }
                        }
                        _logInternalMessage(severity, message);
                    }
                    else {
                        _debugExtMsg("throw" + (severity === 1 /* eLoggingSeverity.CRITICAL */ ? "Critical" : "Warning"), message);
                    }
                }
            };
            /**
             * This will write a warning to the console if possible
             * @param message {string} - The warning message
             */
            _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_WARN_TO_CONSOLE /* @min:%2ewarnToConsole */] = function (message) {
                _logToConsole("warn", message);
                _debugExtMsg("warning", message);
            };
            /**
             * This will write an error to the console if possible
             * @param message {string} - The error message
             */
            _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_ERROR_TO_CONSOLE /* @min:%2eerrorToConsole */] = function (message) {
                _logToConsole("error", message);
                _debugExtMsg("error", message);
            };
            /**
             * Resets the internal message count
             */
            _self.resetInternalMessageCount = function () {
                _messageCount = 0;
                _messageLogged = {};
            };
            /**
             * Logs a message to the internal queue.
             * @param severity {LoggingSeverity} - The severity of the log message
             * @param message {_InternalLogMessage} - The message to log.
             */
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LOG_INTERNAL_MESSAGE /* @min:%2elogInternalMessage */] = _logInternalMessage;
            function _logInternalMessage(severity, message) {
                if (_areInternalMessagesThrottled()) {
                    return;
                }
                // check if this message type was already logged for this session and if so, don't log it again
                var logMessage = true;
                var messageKey = AIInternalMessagePrefix + message[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_MESSAGE_ID /* @min:%2emessageId */];
                // if the session storage is not available, limit to only one message type per page view
                if (_messageLogged[messageKey]) {
                    logMessage = false;
                }
                else {
                    _messageLogged[messageKey] = true;
                }
                if (logMessage) {
                    // Push the event in the internal queue
                    if (severity <= _loggingLevelTelemetry) {
                        _self.queue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PUSH /* @min:%2epush */](message);
                        _messageCount++;
                        _debugExtMsg((severity === 1 /* eLoggingSeverity.CRITICAL */ ? "error" : "warn"), message);
                    }
                    // When throttle limit reached, send a special event
                    if (_messageCount === _maxInternalMessageLimit) {
                        var throttleLimitMessage = "Internal events throttle limit per PageView reached for this app.";
                        var throttleMessage = new _InternalLogMessage(23 /* _eInternalMessageId.MessageLimitPerPVExceeded */, throttleLimitMessage, false);
                        _self.queue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PUSH /* @min:%2epush */](throttleMessage);
                        if (severity === 1 /* eLoggingSeverity.CRITICAL */) {
                            _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_ERROR_TO_CONSOLE /* @min:%2eerrorToConsole */](throttleLimitMessage);
                        }
                        else {
                            _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_WARN_TO_CONSOLE /* @min:%2ewarnToConsole */](throttleLimitMessage);
                        }
                    }
                }
            }
            function _setDefaultsFromConfig(config) {
                _loggingLevelConsole = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.getCfgValue)(config.loggingLevelConsole, 0);
                _loggingLevelTelemetry = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.getCfgValue)(config.loggingLevelTelemetry, 1);
                _maxInternalMessageLimit = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.getCfgValue)(config.maxMessageLimit, 25);
                _enableDebug = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.getCfgValue)(config.enableDebug, (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.getCfgValue)(config[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_ENABLE_DEBUG_EXCEPTI4 /* @min:%2eenableDebugExceptions */], false));
            }
            function _areInternalMessagesThrottled() {
                return _messageCount >= _maxInternalMessageLimit;
            }
            function _debugExtMsg(name, data) {
                var dbgExt = (0,_DbgExtensionUtils__WEBPACK_IMPORTED_MODULE_5__.getDebugExt)(config || {});
                if (dbgExt && dbgExt[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DIAG_LOG /* @min:%2ediagLog */]) {
                    dbgExt[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DIAG_LOG /* @min:%2ediagLog */](name, data);
                }
            }
        });
    }
// Removed Stub for DiagnosticLogger.prototype.enableDebugExceptions.
// Removed Stub for DiagnosticLogger.prototype.consoleLoggingLevel.
// Removed Stub for DiagnosticLogger.prototype.telemetryLoggingLevel.
// Removed Stub for DiagnosticLogger.prototype.maxInternalMessageLimit.
// Removed Stub for DiagnosticLogger.prototype.throwInternal.
// Removed Stub for DiagnosticLogger.prototype.warnToConsole.
// Removed Stub for DiagnosticLogger.prototype.errorToConsole.
// Removed Stub for DiagnosticLogger.prototype.resetInternalMessageCount.
// Removed Stub for DiagnosticLogger.prototype.logInternalMessage.
    // This is a workaround for an IE8 bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    // this will be removed when ES3 support is dropped.
    DiagnosticLogger.__ieDyn=1;

    return DiagnosticLogger;
}());

function _getLogger(logger) {
    return (logger || new DiagnosticLogger());
}
/**
 * This is a helper method which will call throwInternal on the passed logger, will throw exceptions in
 * debug mode or attempt to log the error as a console warning. This helper is provided mostly to better
 * support minification as logger.throwInternal() will not compress the publish "throwInternal" used throughout
 * the code.
 * @param logger - The Diagnostic Logger instance to use.
 * @param severity {LoggingSeverity} - The severity of the log message
 * @param message {_InternalLogMessage} - The log message.
 */
function _throwInternal(logger, severity, msgId, msg, properties, isUserAct) {
    if (isUserAct === void 0) { isUserAct = false; }
    _getLogger(logger).throwInternal(severity, msgId, msg, properties, isUserAct);
}
/**
 * This is a helper method which will call warnToConsole on the passed logger with the provided message.
 * @param logger - The Diagnostic Logger instance to use.
 * @param message {_InternalLogMessage} - The log message.
 */
function _warnToConsole(logger, message) {
    _getLogger(logger)[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_WARN_TO_CONSOLE /* @min:%2ewarnToConsole */](message);
}
/**
 * Logs a message to the internal queue.
 * @param logger - The Diagnostic Logger instance to use.
 * @param severity {LoggingSeverity} - The severity of the log message
 * @param message {_InternalLogMessage} - The message to log.
 */
function _logInternalMessage(logger, severity, message) {
    _getLogger(logger)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LOG_INTERNAL_MESSAGE /* @min:%2elogInternalMessage */](severity, message);
}
//# sourceMappingURL=DiagnosticLogger.js.map

/***/ }),
/* 28 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "createCustomDomEvent": () => (/* binding */ createCustomDomEvent),
/* harmony export */   "dispatchEvent": () => (/* binding */ dispatchEvent),
/* harmony export */   "dumpObj": () => (/* binding */ dumpObj),
/* harmony export */   "findMetaTag": () => (/* binding */ findMetaTag),
/* harmony export */   "findNamedServerTiming": () => (/* binding */ findNamedServerTiming),
/* harmony export */   "getConsole": () => (/* binding */ getConsole),
/* harmony export */   "getCrypto": () => (/* binding */ getCrypto),
/* harmony export */   "getDocument": () => (/* binding */ getDocument),
/* harmony export */   "getGlobalInst": () => (/* binding */ getGlobalInst),
/* harmony export */   "getHistory": () => (/* binding */ getHistory),
/* harmony export */   "getIEVersion": () => (/* binding */ getIEVersion),
/* harmony export */   "getJSON": () => (/* binding */ getJSON),
/* harmony export */   "getLocation": () => (/* binding */ getLocation),
/* harmony export */   "getMsCrypto": () => (/* binding */ getMsCrypto),
/* harmony export */   "getNavigator": () => (/* binding */ getNavigator),
/* harmony export */   "getPerformance": () => (/* binding */ getPerformance),
/* harmony export */   "getWindow": () => (/* binding */ getWindow),
/* harmony export */   "hasDocument": () => (/* binding */ hasDocument),
/* harmony export */   "hasHistory": () => (/* binding */ hasHistory),
/* harmony export */   "hasJSON": () => (/* binding */ hasJSON),
/* harmony export */   "hasNavigator": () => (/* binding */ hasNavigator),
/* harmony export */   "hasWindow": () => (/* binding */ hasWindow),
/* harmony export */   "isBeaconsSupported": () => (/* binding */ isBeaconsSupported),
/* harmony export */   "isFetchSupported": () => (/* binding */ isFetchSupported),
/* harmony export */   "isIE": () => (/* binding */ isIE),
/* harmony export */   "isReactNative": () => (/* binding */ isReactNative),
/* harmony export */   "isSafari": () => (/* binding */ isSafari),
/* harmony export */   "isXhrSupported": () => (/* binding */ isXhrSupported),
/* harmony export */   "sendCustomEvent": () => (/* binding */ sendCustomEvent),
/* harmony export */   "setEnableEnvMocks": () => (/* binding */ setEnableEnvMocks),
/* harmony export */   "useXDomainRequest": () => (/* binding */ useXDomainRequest)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19);
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(22);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(20);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(18);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(21);
/*
 * Application Insights JavaScript SDK - Core, 2.8.15
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */







/**
 * This file exists to hold environment utilities that are required to check and
 * validate the current operating environment. Unless otherwise required, please
 * only use defined methods (functions) in this class so that users of these
 * functions/properties only need to include those that are used within their own modules.
 */
var strWindow = "window";
var strDocument = "document";
var strDocumentMode = "documentMode";
var strNavigator = "navigator";
var strHistory = "history";
var strLocation = "location";
var strConsole = "console";
var strPerformance = "performance";
var strJSON = "JSON";
var strCrypto = "crypto";
var strMsCrypto = "msCrypto";
var strReactNative = "ReactNative";
var strMsie = "msie";
var strTrident = "trident/";
var strXMLHttpRequest = "XMLHttpRequest";
var _isTrident = null;
var _navUserAgentCheck = null;
var _enableMocks = false;
var _useXDomainRequest = null;
var _beaconsSupported = null;
function _hasProperty(theClass, property) {
    var supported = false;
    if (theClass) {
        try {
            supported = property in theClass;
            if (!supported) {
                var proto = theClass[_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.strShimPrototype];
                if (proto) {
                    supported = property in proto;
                }
            }
        }
        catch (e) {
            // Do Nothing
        }
        if (!supported) {
            try {
                var tmp = new theClass();
                supported = !(0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.isUndefined)(tmp[property]);
            }
            catch (e) {
                // Do Nothing
            }
        }
    }
    return supported;
}
/**
 * Enable the lookup of test mock objects if requested
 * @param enabled
 */
function setEnableEnvMocks(enabled) {
    _enableMocks = enabled;
}
/**
 * Return the named global object if available, will return null if the object is not available.
 * @param name The globally named object
 */
function getGlobalInst(name) {
    var gbl = (0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_2__.getGlobal)();
    if (gbl && gbl[name]) {
        return gbl[name];
    }
    // Test workaround, for environments where <global>.window (when global == window) doesn't return the base window
    if (name === strWindow && hasWindow()) {
        // tslint:disable-next-line: no-angle-bracket-type-assertion
        return window;
    }
    return null;
}
/**
 * Checks if window object is available, this is required as we support the API running without a
 * window /document (eg. Node server, electron webworkers) and if we attempt to assign a window
 * object to a local variable or pass as an argument an "Uncaught ReferenceError: window is not defined"
 * exception will be thrown.
 * Defined as a function to support lazy / late binding environments.
 */
function hasWindow() {
    return Boolean(typeof window === _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.strShimObject && window);
}
/**
 * Returns the global window object if it is present otherwise null.
 * This helper is used to access the window object without causing an exception
 * "Uncaught ReferenceError: window is not defined"
 */
function getWindow() {
    if (hasWindow()) {
        return window;
    }
    // Return the global instance or null
    return getGlobalInst(strWindow);
}
/**
 * Checks if document object is available, this is required as we support the API running without a
 * window /document (eg. Node server, electron webworkers) and if we attempt to assign a document
 * object to a local variable or pass as an argument an "Uncaught ReferenceError: document is not defined"
 * exception will be thrown.
 * Defined as a function to support lazy / late binding environments.
 */
function hasDocument() {
    return Boolean(typeof document === _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.strShimObject && document);
}
/**
 * Returns the global document object if it is present otherwise null.
 * This helper is used to access the document object without causing an exception
 * "Uncaught ReferenceError: document is not defined"
 */
function getDocument() {
    if (hasDocument()) {
        return document;
    }
    return getGlobalInst(strDocument);
}
/**
 * Checks if navigator object is available, this is required as we support the API running without a
 * window /document (eg. Node server, electron webworkers) and if we attempt to assign a navigator
 * object to a local variable or pass as an argument an "Uncaught ReferenceError: navigator is not defined"
 * exception will be thrown.
 * Defined as a function to support lazy / late binding environments.
 */
function hasNavigator() {
    return Boolean(typeof navigator === _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.strShimObject && navigator);
}
/**
 * Returns the global navigator object if it is present otherwise null.
 * This helper is used to access the navigator object without causing an exception
 * "Uncaught ReferenceError: navigator is not defined"
 */
function getNavigator() {
    if (hasNavigator()) {
        return navigator;
    }
    return getGlobalInst(strNavigator);
}
/**
 * Checks if history object is available, this is required as we support the API running without a
 * window /document (eg. Node server, electron webworkers) and if we attempt to assign a history
 * object to a local variable or pass as an argument an "Uncaught ReferenceError: history is not defined"
 * exception will be thrown.
 * Defined as a function to support lazy / late binding environments.
 */
function hasHistory() {
    return Boolean(typeof history === _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.strShimObject && history);
}
/**
 * Returns the global history object if it is present otherwise null.
 * This helper is used to access the history object without causing an exception
 * "Uncaught ReferenceError: history is not defined"
 */
function getHistory() {
    if (hasHistory()) {
        return history;
    }
    return getGlobalInst(strHistory);
}
/**
 * Returns the global location object if it is present otherwise null.
 * This helper is used to access the location object without causing an exception
 * "Uncaught ReferenceError: location is not defined"
 */
function getLocation(checkForMock) {
    if (checkForMock && _enableMocks) {
        var mockLocation = getGlobalInst("__mockLocation");
        if (mockLocation) {
            return mockLocation;
        }
    }
    if (typeof location === _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.strShimObject && location) {
        return location;
    }
    return getGlobalInst(strLocation);
}
/**
 * Returns the global console object
 */
function getConsole() {
    if (typeof console !== _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.strShimUndefined) {
        return console;
    }
    return getGlobalInst(strConsole);
}
/**
 * Returns the performance object if it is present otherwise null.
 * This helper is used to access the performance object from the current
 * global instance which could be window or globalThis for a web worker
 */
function getPerformance() {
    return getGlobalInst(strPerformance);
}
/**
 * Checks if JSON object is available, this is required as we support the API running without a
 * window /document (eg. Node server, electron webworkers) and if we attempt to assign a history
 * object to a local variable or pass as an argument an "Uncaught ReferenceError: JSON is not defined"
 * exception will be thrown.
 * Defined as a function to support lazy / late binding environments.
 */
function hasJSON() {
    return Boolean((typeof JSON === _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.strShimObject && JSON) || getGlobalInst(strJSON) !== null);
}
/**
 * Returns the global JSON object if it is present otherwise null.
 * This helper is used to access the JSON object without causing an exception
 * "Uncaught ReferenceError: JSON is not defined"
 */
function getJSON() {
    if (hasJSON()) {
        return JSON || getGlobalInst(strJSON);
    }
    return null;
}
/**
 * Returns the crypto object if it is present otherwise null.
 * This helper is used to access the crypto object from the current
 * global instance which could be window or globalThis for a web worker
 */
function getCrypto() {
    return getGlobalInst(strCrypto);
}
/**
 * Returns the crypto object if it is present otherwise null.
 * This helper is used to access the crypto object from the current
 * global instance which could be window or globalThis for a web worker
 */
function getMsCrypto() {
    return getGlobalInst(strMsCrypto);
}
/**
 * Returns whether the environment is reporting that we are running in a React Native Environment
 */
function isReactNative() {
    // If running in React Native, navigator.product will be populated
    var nav = getNavigator();
    if (nav && nav.product) {
        return nav.product === strReactNative;
    }
    return false;
}
/**
 * Identifies whether the current environment appears to be IE
 */
function isIE() {
    var nav = getNavigator();
    if (nav && (nav[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_USER_AGENT /* @min:%2euserAgent */] !== _navUserAgentCheck || _isTrident === null)) {
        // Added to support test mocking of the user agent
        _navUserAgentCheck = nav[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_USER_AGENT /* @min:%2euserAgent */];
        var userAgent = (_navUserAgentCheck || _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EMPTY)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */]();
        _isTrident = ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.strContains)(userAgent, strMsie) || (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.strContains)(userAgent, strTrident));
    }
    return _isTrident;
}
/**
 * Gets IE version returning the document emulation mode if we are running on IE, or null otherwise
 */
function getIEVersion(userAgentStr) {
    if (userAgentStr === void 0) { userAgentStr = null; }
    if (!userAgentStr) {
        var navigator_1 = getNavigator() || {};
        userAgentStr = navigator_1 ? (navigator_1[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_USER_AGENT /* @min:%2euserAgent */] || _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EMPTY)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */]() : _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EMPTY;
    }
    var ua = (userAgentStr || _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EMPTY)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */]();
    // Also check for documentMode in case X-UA-Compatible meta tag was included in HTML.
    if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.strContains)(ua, strMsie)) {
        var doc = getDocument() || {};
        return Math.max(parseInt(ua[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_SPLIT /* @min:%2esplit */](strMsie)[1]), (doc[strDocumentMode] || 0));
    }
    else if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.strContains)(ua, strTrident)) {
        var tridentVer = parseInt(ua[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_SPLIT /* @min:%2esplit */](strTrident)[1]);
        if (tridentVer) {
            return tridentVer + 4;
        }
    }
    return null;
}
/**
 * Returns string representation of an object suitable for diagnostics logging.
 */
function dumpObj(object) {
    var objectTypeDump = Object[_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.strShimPrototype].toString[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_CALL /* @min:%2ecall */](object);
    var propertyValueDump = _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EMPTY;
    if (objectTypeDump === "[object Error]") {
        propertyValueDump = "{ stack: '" + object.stack + "', message: '" + object.message + "', name: '" + object[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_NAME /* @min:%2ename */] + "'";
    }
    else if (hasJSON()) {
        propertyValueDump = getJSON().stringify(object);
    }
    return objectTypeDump + propertyValueDump;
}
function isSafari(userAgentStr) {
    if (!userAgentStr || !(0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.isString)(userAgentStr)) {
        var navigator_2 = getNavigator() || {};
        userAgentStr = navigator_2 ? (navigator_2[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_USER_AGENT /* @min:%2euserAgent */] || _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EMPTY)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */]() : _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EMPTY;
    }
    var ua = (userAgentStr || _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EMPTY)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */]();
    return (ua[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_INDEX_OF /* @min:%2eindexOf */]("safari") >= 0);
}
/**
 * Checks if HTML5 Beacons are supported in the current environment.
 * @returns True if supported, false otherwise.
 */
function isBeaconsSupported() {
    if (_beaconsSupported === null) {
        _beaconsSupported = hasNavigator() && Boolean(getNavigator().sendBeacon);
    }
    return _beaconsSupported;
}
/**
 * Checks if the Fetch API is supported in the current environment.
 * @param withKeepAlive - [Optional] If True, check if fetch is available and it supports the keepalive feature, otherwise only check if fetch is supported
 * @returns True if supported, otherwise false
 */
function isFetchSupported(withKeepAlive) {
    var isSupported = false;
    try {
        isSupported = !!getGlobalInst("fetch");
        var request = getGlobalInst("Request");
        if (isSupported && withKeepAlive && request) {
            isSupported = _hasProperty(request, "keepalive");
        }
    }
    catch (e) {
        // Just Swallow any failure during availability checks
    }
    return isSupported;
}
function useXDomainRequest() {
    if (_useXDomainRequest === null) {
        _useXDomainRequest = (typeof XDomainRequest !== _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.strShimUndefined);
        if (_useXDomainRequest && isXhrSupported()) {
            _useXDomainRequest = _useXDomainRequest && !_hasProperty(getGlobalInst(strXMLHttpRequest), "withCredentials");
        }
    }
    return _useXDomainRequest;
}
/**
 * Checks if XMLHttpRequest is supported
 * @returns True if supported, otherwise false
 */
function isXhrSupported() {
    var isSupported = false;
    try {
        var xmlHttpRequest = getGlobalInst(strXMLHttpRequest);
        isSupported = !!xmlHttpRequest;
    }
    catch (e) {
        // Just Swallow any failure during availability checks
    }
    return isSupported;
}
function _getNamedValue(values, name) {
    if (values) {
        for (var i = 0; i < values[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_LENGTH /* @min:%2elength */]; i++) {
            var value = values[i];
            if (value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_NAME /* @min:%2ename */]) {
                if (value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_NAME /* @min:%2ename */] === name) {
                    return value;
                }
            }
        }
    }
    return {};
}
/**
 * Helper function to fetch the named meta-tag from the page.
 * @param name
 */
function findMetaTag(name) {
    var doc = getDocument();
    if (doc && name) {
        // Look for a meta-tag
        return _getNamedValue(doc.querySelectorAll("meta"), name).content;
    }
    return null;
}
/**
 * Helper function to fetch the named server timing value from the page response (first navigation event).
 * @param name
 */
function findNamedServerTiming(name) {
    var value;
    var perf = getPerformance();
    if (perf) {
        // Try looking for a server-timing header
        var navPerf = perf.getEntriesByType("navigation") || [];
        value = _getNamedValue((navPerf[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_LENGTH /* @min:%2elength */] > 0 ? navPerf[0] : {}).serverTiming, name).description;
    }
    return value;
}
// TODO: should reuse this method for analytics plugin
function dispatchEvent(target, evnt) {
    if (target && target.dispatchEvent && evnt) {
        target.dispatchEvent(evnt);
        return true;
    }
    return false;
}
function createCustomDomEvent(eventName, details) {
    var event = null;
    var detail = { detail: details || null };
    if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.isFunction)(CustomEvent)) { // Use CustomEvent constructor when available
        event = new CustomEvent(eventName, detail);
    }
    else { // CustomEvent has no constructor in IE
        var doc = getDocument();
        if (doc && doc.createEvent) {
            event = doc.createEvent("CustomEvent");
            event.initCustomEvent(eventName, true, true, detail);
        }
    }
    return event;
}
function sendCustomEvent(evtName, cfg, customDetails) {
    var global = (0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_2__.getGlobal)();
    if (global && global.CustomEvent) {
        try {
            var details = { cfg: cfg || null, customDetails: customDetails || null };
            return dispatchEvent(global, createCustomDomEvent(evtName, details));
        }
        catch (e) {
            // eslint-disable-next-line no-empty
        }
    }
    return false;
}
//# sourceMappingURL=EnvUtils.js.map

/***/ }),
/* 29 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ dynamicProto)
/* harmony export */ });
/*!
 * Microsoft Dynamic Proto Utility, 1.1.9
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */
var _a;
var UNDEFINED = "undefined";
/**
 * Constant string defined to support minimization
 * @ignore
 */
var Constructor = 'constructor';
/**
 * Constant string defined to support minimization
 * @ignore
 */
var Prototype = 'prototype';
/**
 * Constant string defined to support minimization
 * @ignore
 */
var strFunction = 'function';
/**
 * Used to define the name of the instance function lookup table
 * @ignore
 */
var DynInstFuncTable = '_dynInstFuncs';
/**
 * Name used to tag the dynamic prototype function
 * @ignore
 */
var DynProxyTag = '_isDynProxy';
/**
 * Name added to a prototype to define the dynamic prototype "class" name used to lookup the function table
 * @ignore
 */
var DynClassName = '_dynClass';
/**
 * Prefix added to the classname to avoid any name clashes with other instance level properties
 * @ignore
 */
var DynClassNamePrefix = '_dynCls$';
/**
 * A tag which is used to check if we have already to attempted to set the instance function if one is not present
 * @ignore
 */
var DynInstChkTag = '_dynInstChk';
/**
 * A tag which is used to check if we are allows to try and set an instance function is one is not present. Using the same
 * tag name as the function level but a different const name for readability only.
 */
var DynAllowInstChkTag = DynInstChkTag;
/**
 * The global (imported) instances where the global performance options are stored
 */
var DynProtoDefaultOptions = '_dfOpts';
/**
 * Value used as the name of a class when it cannot be determined
 * @ignore
 */
var UnknownValue = '_unknown_';
/**
 * Constant string defined to support minimization
 * @ignore
 */
var str__Proto = "__proto__";
/**
 * The polyfill version of __proto__ so that it doesn't cause issues for anyone not expecting it to exist
 */
var DynProtoBaseProto = "_dyn" + str__Proto;
/**
 * Runtime Global holder for dynamicProto settings
 */
var DynProtoGlobalSettings = "__dynProto$Gbl";
/**
 * Track the current prototype for IE8 as you can't look back to get the prototype
 */
var DynProtoCurrent = "_dynInstProto";
/**
 * Constant string defined to support minimization
 * @ignore
 */
var strUseBaseInst = 'useBaseInst';
/**
 * Constant string defined to support minimization
 * @ignore
 */
var strSetInstFuncs = 'setInstFuncs';
var Obj = Object;
/**
 * Pre-lookup to check if we are running on a modern browser (i.e. not IE8)
 * @ignore
 */
var _objGetPrototypeOf = Obj["getPrototypeOf"];
/**
 * Pre-lookup to check for the existence of this function
 */
var _objGetOwnProps = Obj["getOwnPropertyNames"];
/**
 * Gets the runtime global reference
 * @returns
 */
function _getGlobal() {
    var result;
    if (typeof globalThis !== UNDEFINED) {
        result = globalThis;
    }
    if (!result && typeof self !== UNDEFINED) {
        result = self;
    }
    if (!result && typeof window !== UNDEFINED) {
        result = window;
    }
    if (!result && typeof __webpack_require__.g !== UNDEFINED) {
        result = __webpack_require__.g;
    }
    return result || {};
}
// Since 1.1.7 moving these to the runtime global to work around mixed version and module issues
// See Issue https://github.com/microsoft/DynamicProto-JS/issues/57 for details
var _gbl = _getGlobal();
var _gblInst = _gbl[DynProtoGlobalSettings] || (_gbl[DynProtoGlobalSettings] = {
    o: (_a = {},
        _a[strSetInstFuncs] = true,
        _a[strUseBaseInst] = true,
        _a),
    n: 1000 // Start new global index @ 1000 so we "fix" some cases when mixed with 1.1.6 or earlier
});
/**
 * Helper to check if the object contains a property of the name
 * @ignore
 */
function _hasOwnProperty(obj, prop) {
    return obj && Obj[Prototype].hasOwnProperty.call(obj, prop);
}
/**
 * Helper used to check whether the target is an Object prototype or Array prototype
 * @ignore
 */
function _isObjectOrArrayPrototype(target) {
    return target && (target === Obj[Prototype] || target === Array[Prototype]);
}
/**
 * Helper used to check whether the target is an Object prototype, Array prototype or Function prototype
 * @ignore
 */
function _isObjectArrayOrFunctionPrototype(target) {
    return _isObjectOrArrayPrototype(target) || target === Function[Prototype];
}
/**
 * Helper used to get the prototype of the target object as getPrototypeOf is not available in an ES3 environment.
 * @ignore
 */
function _getObjProto(target) {
    var newProto;
    if (target) {
        // This method doesn't exist in older browsers (e.g. IE8)
        if (_objGetPrototypeOf) {
            return _objGetPrototypeOf(target);
        }
        var curProto = target[str__Proto] || target[Prototype] || (target[Constructor] ? target[Constructor][Prototype] : null);
        // Using the pre-calculated value as IE8 doesn't support looking up the prototype of a prototype and thus fails for more than 1 base class
        newProto = target[DynProtoBaseProto] || curProto;
        if (!_hasOwnProperty(target, DynProtoBaseProto)) {
            // As this prototype doesn't have this property then this is from an inherited class so newProto is the base to return so save it
            // so we can look it up value (which for a multiple hierarchy dynamicProto will be the base class)
            delete target[DynProtoCurrent]; // Delete any current value allocated to this instance so we pick up the value from prototype hierarchy
            newProto = target[DynProtoBaseProto] = target[DynProtoCurrent] || target[DynProtoBaseProto];
            target[DynProtoCurrent] = curProto;
        }
    }
    return newProto;
}
/**
 * Helper to get the properties of an object, including none enumerable ones as functions on a prototype in ES6
 * are not enumerable.
 * @param target
 */
function _forEachProp(target, func) {
    var props = [];
    if (_objGetOwnProps) {
        props = _objGetOwnProps(target);
    }
    else {
        for (var name_1 in target) {
            if (typeof name_1 === "string" && _hasOwnProperty(target, name_1)) {
                props.push(name_1);
            }
        }
    }
    if (props && props.length > 0) {
        for (var lp = 0; lp < props.length; lp++) {
            func(props[lp]);
        }
    }
}
/**
 * Helper function to check whether the provided function name is a potential candidate for dynamic
 * callback and prototype generation.
 * @param target The target object, may be a prototype or class object
 * @param funcName The function name
 * @param skipOwn Skips the check for own property
 * @ignore
 */
function _isDynamicCandidate(target, funcName, skipOwn) {
    return (funcName !== Constructor && typeof target[funcName] === strFunction && (skipOwn || _hasOwnProperty(target, funcName)));
}
/**
 * Helper to throw a TypeError exception
 * @param message the message
 * @ignore
 */
function _throwTypeError(message) {
    throw new TypeError("DynamicProto: " + message);
}
/**
 * Returns a collection of the instance functions that are defined directly on the thisTarget object, it does
 * not return any inherited functions
 * @param thisTarget The object to get the instance functions from
 * @ignore
 */
function _getInstanceFuncs(thisTarget) {
    // Get the base proto
    var instFuncs = {};
    // Save any existing instance functions
    _forEachProp(thisTarget, function (name) {
        // Don't include any dynamic prototype instances - as we only want the real functions
        if (!instFuncs[name] && _isDynamicCandidate(thisTarget, name, false)) {
            // Create an instance callback for passing the base function to the caller
            instFuncs[name] = thisTarget[name];
        }
    });
    return instFuncs;
}
/**
 * Returns whether the value is included in the array
 * @param values The array of values
 * @param value  The value
 */
function _hasVisited(values, value) {
    for (var lp = values.length - 1; lp >= 0; lp--) {
        if (values[lp] === value) {
            return true;
        }
    }
    return false;
}
/**
 * Returns an object that contains callback functions for all "base/super" functions, this is used to "save"
 * enabling calling super.xxx() functions without requiring that the base "class" has defined a prototype references
 * @param target The current instance
 * @ignore
 */
function _getBaseFuncs(classProto, thisTarget, instFuncs, useBaseInst) {
    function _instFuncProxy(target, funcHost, funcName) {
        var theFunc = funcHost[funcName];
        if (theFunc[DynProxyTag] && useBaseInst) {
            // grab and reuse the hosted looking function (if available) otherwise the original passed function
            var instFuncTable = target[DynInstFuncTable] || {};
            if (instFuncTable[DynAllowInstChkTag] !== false) {
                theFunc = (instFuncTable[funcHost[DynClassName]] || {})[funcName] || theFunc;
            }
        }
        return function () {
            // eslint-disable-next-line prefer-rest-params
            return theFunc.apply(target, arguments);
        };
    }
    // Start creating a new baseFuncs by creating proxies for the instance functions (as they may get replaced)
    var baseFuncs = {};
    _forEachProp(instFuncs, function (name) {
        // Create an instance callback for passing the base function to the caller
        baseFuncs[name] = _instFuncProxy(thisTarget, instFuncs, name);
    });
    // Get the base prototype functions
    var baseProto = _getObjProto(classProto);
    var visited = [];
    // Don't include base object functions for Object, Array or Function
    while (baseProto && !_isObjectArrayOrFunctionPrototype(baseProto) && !_hasVisited(visited, baseProto)) {
        // look for prototype functions
        _forEachProp(baseProto, function (name) {
            // Don't include any dynamic prototype instances - as we only want the real functions
            // For IE 7/8 the prototype lookup doesn't provide the full chain so we need to bypass the 
            // hasOwnProperty check we get all of the methods, main difference is that IE7/8 doesn't return
            // the Object prototype methods while bypassing the check
            if (!baseFuncs[name] && _isDynamicCandidate(baseProto, name, !_objGetPrototypeOf)) {
                // Create an instance callback for passing the base function to the caller
                baseFuncs[name] = _instFuncProxy(thisTarget, baseProto, name);
            }
        });
        // We need to find all possible functions that might be overloaded by walking the entire prototype chain
        // This avoids the caller from needing to check whether it's direct base class implements the function or not
        // by walking the entire chain it simplifies the usage and issues from upgrading any of the base classes.
        visited.push(baseProto);
        baseProto = _getObjProto(baseProto);
    }
    return baseFuncs;
}
function _getInstFunc(target, funcName, proto, currentDynProtoProxy) {
    var instFunc = null;
    // We need to check whether the class name is defined directly on this prototype otherwise
    // it will walk the proto chain and return any parent proto classname.
    if (target && _hasOwnProperty(proto, DynClassName)) {
        var instFuncTable = target[DynInstFuncTable] || {};
        instFunc = (instFuncTable[proto[DynClassName]] || {})[funcName];
        if (!instFunc) {
            // Avoid stack overflow from recursive calling the same function
            _throwTypeError("Missing [" + funcName + "] " + strFunction);
        }
        // We have the instance function, lets check it we can speed up further calls
        // by adding the instance function back directly on the instance (avoiding the dynamic func lookup)
        if (!instFunc[DynInstChkTag] && instFuncTable[DynAllowInstChkTag] !== false) {
            // If the instance already has an instance function we can't replace it
            var canAddInst = !_hasOwnProperty(target, funcName);
            // Get current prototype
            var objProto = _getObjProto(target);
            var visited = [];
            // Lookup the function starting at the top (instance level prototype) and traverse down, if the first matching function
            // if nothing is found or if the first hit is a dynamic proto instance then we can safely add an instance shortcut
            while (canAddInst && objProto && !_isObjectArrayOrFunctionPrototype(objProto) && !_hasVisited(visited, objProto)) {
                var protoFunc = objProto[funcName];
                if (protoFunc) {
                    canAddInst = (protoFunc === currentDynProtoProxy);
                    break;
                }
                // We need to find all possible initial functions to ensure that we don't bypass a valid override function
                visited.push(objProto);
                objProto = _getObjProto(objProto);
            }
            try {
                if (canAddInst) {
                    // This instance doesn't have an instance func and the class hierarchy does have a higher level prototype version
                    // so it's safe to directly assign for any subsequent calls (for better performance)
                    target[funcName] = instFunc;
                }
                // Block further attempts to set the instance function for any
                instFunc[DynInstChkTag] = 1;
            }
            catch (e) {
                // Don't crash if the object is readonly or the runtime doesn't allow changing this
                // And set a flag so we don't try again for any function
                instFuncTable[DynAllowInstChkTag] = false;
            }
        }
    }
    return instFunc;
}
function _getProtoFunc(funcName, proto, currentDynProtoProxy) {
    var protoFunc = proto[funcName];
    // Check that the prototype function is not a self reference -- try to avoid stack overflow!
    if (protoFunc === currentDynProtoProxy) {
        // It is so lookup the base prototype
        protoFunc = _getObjProto(proto)[funcName];
    }
    if (typeof protoFunc !== strFunction) {
        _throwTypeError("[" + funcName + "] is not a " + strFunction);
    }
    return protoFunc;
}
/**
 * Add the required dynamic prototype methods to the the class prototype
 * @param proto - The class prototype
 * @param className - The instance classname
 * @param target - The target instance
 * @param baseInstFuncs - The base instance functions
 * @param setInstanceFunc - Flag to allow prototype function to reset the instance function if one does not exist
 * @ignore
 */
function _populatePrototype(proto, className, target, baseInstFuncs, setInstanceFunc) {
    function _createDynamicPrototype(proto, funcName) {
        var dynProtoProxy = function () {
            // Use the instance or prototype function
            var instFunc = _getInstFunc(this, funcName, proto, dynProtoProxy) || _getProtoFunc(funcName, proto, dynProtoProxy);
            // eslint-disable-next-line prefer-rest-params
            return instFunc.apply(this, arguments);
        };
        // Tag this function as a proxy to support replacing dynamic proxy elements (primary use case is for unit testing
        // via which can dynamically replace the prototype function reference)
        dynProtoProxy[DynProxyTag] = 1;
        return dynProtoProxy;
    }
    if (!_isObjectOrArrayPrototype(proto)) {
        var instFuncTable = target[DynInstFuncTable] = target[DynInstFuncTable] || {};
        var instFuncs_1 = instFuncTable[className] = (instFuncTable[className] || {}); // fetch and assign if as it may not exist yet
        // Set whether we are allow to lookup instances, if someone has set to false then do not re-enable
        if (instFuncTable[DynAllowInstChkTag] !== false) {
            instFuncTable[DynAllowInstChkTag] = !!setInstanceFunc;
        }
        _forEachProp(target, function (name) {
            // Only add overridden functions
            if (_isDynamicCandidate(target, name, false) && target[name] !== baseInstFuncs[name]) {
                // Save the instance Function to the lookup table and remove it from the instance as it's not a dynamic proto function
                instFuncs_1[name] = target[name];
                delete target[name];
                // Add a dynamic proto if one doesn't exist or if a prototype function exists and it's not a dynamic one
                if (!_hasOwnProperty(proto, name) || (proto[name] && !proto[name][DynProxyTag])) {
                    proto[name] = _createDynamicPrototype(proto, name);
                }
            }
        });
    }
}
/**
 * Checks whether the passed prototype object appears to be correct by walking the prototype hierarchy of the instance
 * @param classProto The class prototype instance
 * @param thisTarget The current instance that will be checked whether the passed prototype instance is in the hierarchy
 * @ignore
 */
function _checkPrototype(classProto, thisTarget) {
    // This method doesn't existing in older browsers (e.g. IE8)
    if (_objGetPrototypeOf) {
        // As this is primarily a coding time check, don't bother checking if running in IE8 or lower
        var visited = [];
        var thisProto = _getObjProto(thisTarget);
        while (thisProto && !_isObjectArrayOrFunctionPrototype(thisProto) && !_hasVisited(visited, thisProto)) {
            if (thisProto === classProto) {
                return true;
            }
            // This avoids the caller from needing to check whether it's direct base class implements the function or not
            // by walking the entire chain it simplifies the usage and issues from upgrading any of the base classes.
            visited.push(thisProto);
            thisProto = _getObjProto(thisProto);
        }
        return false;
    }
    // If objGetPrototypeOf doesn't exist then just assume everything is ok.
    return true;
}
/**
 * Gets the current prototype name using the ES6 name if available otherwise falling back to a use unknown as the name.
 * It's not critical for this to return a name, it's used to decorate the generated unique name for easier debugging only.
 * @param target
 * @param unknownValue
 * @ignore
 */
function _getObjName(target, unknownValue) {
    if (_hasOwnProperty(target, Prototype)) {
        // Look like a prototype
        return target.name || unknownValue || UnknownValue;
    }
    return (((target || {})[Constructor]) || {}).name || unknownValue || UnknownValue;
}
/**
 * Helper function when creating dynamic (inline) functions for classes, this helper performs the following tasks :-
 * - Saves references to all defined base class functions
 * - Calls the delegateFunc with the current target (this) and a base object reference that can be used to call all "super" functions.
 * - Will populate the class prototype for all overridden functions to support class extension that call the prototype instance.
 * Callers should use this helper when declaring all function within the constructor of a class, as mentioned above the delegateFunc is
 * passed both the target "this" and an object that can be used to call any base (super) functions, using this based object in place of
 * super.XXX() (which gets expanded to _super.prototype.XXX()) provides a better minification outcome and also ensures the correct "this"
 * context is maintained as TypeScript creates incorrect references using super.XXXX() for dynamically defined functions i.e. Functions
 * defined in the constructor or some other function (rather than declared as complete typescript functions).
 * ### Usage
 * ```typescript
 * import dynamicProto from "@microsoft/dynamicproto-js";
 * class ExampleClass extends BaseClass {
 *     constructor() {
 *         dynamicProto(ExampleClass, this, (_self, base) => {
 *             // This will define a function that will be converted to a prototype function
 *             _self.newFunc = () => {
 *                 // Access any "this" instance property
 *                 if (_self.someProperty) {
 *                     ...
 *                 }
 *             }
 *             // This will define a function that will be converted to a prototype function
 *             _self.myFunction = () => {
 *                 // Access any "this" instance property
 *                 if (_self.someProperty) {
 *                     // Call the base version of the function that we are overriding
 *                     base.myFunction();
 *                 }
 *                 ...
 *             }
 *             _self.initialize = () => {
 *                 ...
 *             }
 *             // Warnings: While the following will work as _self is simply a reference to
 *             // this, if anyone overrides myFunction() the overridden will be called first
 *             // as the normal JavaScript method resolution will occur and the defined
 *             // _self.initialize() function is actually gets removed from the instance and
 *             // a proxy prototype version is created to reference the created method.
 *             _self.initialize();
 *         });
 *     }
 * }
 * ```
 * @typeparam DPType This is the generic type of the class, used to keep intellisense valid
 * @typeparam DPCls The type that contains the prototype of the current class
 * @param theClass - This is the current class instance which contains the prototype for the current class
 * @param target - The current "this" (target) reference, when the class has been extended this.prototype will not be the 'theClass' value.
 * @param delegateFunc - The callback function (closure) that will create the dynamic function
 * @param options - Additional options to configure how the dynamic prototype operates
 */
function dynamicProto(theClass, target, delegateFunc, options) {
    // Make sure that the passed theClass argument looks correct
    if (!_hasOwnProperty(theClass, Prototype)) {
        _throwTypeError("theClass is an invalid class definition.");
    }
    // Quick check to make sure that the passed theClass argument looks correct (this is a common copy/paste error)
    var classProto = theClass[Prototype];
    if (!_checkPrototype(classProto, target)) {
        _throwTypeError("[" + _getObjName(theClass) + "] not in hierarchy of [" + _getObjName(target) + "]");
    }
    var className = null;
    if (_hasOwnProperty(classProto, DynClassName)) {
        // Only grab the class name if it's defined on this prototype (i.e. don't walk the prototype chain)
        className = classProto[DynClassName];
    }
    else {
        // As not all browser support name on the prototype creating a unique dynamic one if we have not already
        // assigned one, so we can use a simple string as the lookup rather than an object for the dynamic instance
        // function table lookup.
        className = DynClassNamePrefix + _getObjName(theClass, "_") + "$" + _gblInst.n;
        _gblInst.n++;
        classProto[DynClassName] = className;
    }
    var perfOptions = dynamicProto[DynProtoDefaultOptions];
    var useBaseInst = !!perfOptions[strUseBaseInst];
    if (useBaseInst && options && options[strUseBaseInst] !== undefined) {
        useBaseInst = !!options[strUseBaseInst];
    }
    // Get the current instance functions
    var instFuncs = _getInstanceFuncs(target);
    // Get all of the functions for any base instance (before they are potentially overridden)
    var baseFuncs = _getBaseFuncs(classProto, target, instFuncs, useBaseInst);
    // Execute the delegate passing in both the current target "this" and "base" function references
    // Note casting the same type as we don't actually have the base class here and this will provide some intellisense support
    delegateFunc(target, baseFuncs);
    // Don't allow setting instance functions for older IE instances
    var setInstanceFunc = !!_objGetPrototypeOf && !!perfOptions[strSetInstFuncs];
    if (setInstanceFunc && options) {
        setInstanceFunc = !!options[strSetInstFuncs];
    }
    // Populate the Prototype for any overridden instance functions
    _populatePrototype(classProto, className, target, instFuncs, setInstanceFunc !== false);
}
/**
 * Exposes the default global options to allow global configuration, if the global values are disabled these will override
 * any passed values. This is primarily exposed to support unit-testing without the need for individual classes to expose
 * their internal usage of dynamic proto.
 */
dynamicProto[DynProtoDefaultOptions] = _gblInst.o;


//# sourceMappingURL=dynamicproto-js.js.map


/***/ }),
/* 30 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getDebugExt": () => (/* binding */ getDebugExt),
/* harmony export */   "getDebugListener": () => (/* binding */ getDebugListener)
/* harmony export */ });
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20);
/* harmony import */ var _EnvUtils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28);
/*
 * Application Insights JavaScript SDK - Core, 2.8.15
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */




var listenerFuncs = ["eventsSent", "eventsDiscarded", "eventsSendRequest", "perfEvent"];
var _aiNamespace = null;
var _debugListener;
function _listenerProxyFunc(name, config) {
    return function () {
        var args = arguments;
        var dbgExt = getDebugExt(config);
        if (dbgExt) {
            var listener = dbgExt.listener;
            if (listener && listener[name]) {
                listener[name][_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_APPLY /* @min:%2eapply */](listener, args);
            }
        }
    };
}
function _getExtensionNamespace() {
    // Cache the lookup of the global namespace object
    var target = (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_1__.getGlobalInst)("Microsoft");
    if (target) {
        _aiNamespace = target["ApplicationInsights"];
    }
    return _aiNamespace;
}
function getDebugExt(config) {
    var ns = _aiNamespace;
    if (!ns && config.disableDbgExt !== true) {
        ns = _aiNamespace || _getExtensionNamespace();
    }
    return ns ? ns["ChromeDbgExt"] : null;
}
function getDebugListener(config) {
    if (!_debugListener) {
        _debugListener = {};
        for (var lp = 0; lp < listenerFuncs[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */]; lp++) {
            _debugListener[listenerFuncs[lp]] = _listenerProxyFunc(listenerFuncs[lp], config);
        }
    }
    return _debugListener;
}
//# sourceMappingURL=DbgExtensionUtils.js.map

/***/ }),
/* 31 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PerfEvent": () => (/* binding */ PerfEvent),
/* harmony export */   "PerfManager": () => (/* binding */ PerfManager),
/* harmony export */   "doPerf": () => (/* binding */ doPerf),
/* harmony export */   "getGblPerfMgr": () => (/* binding */ getGblPerfMgr),
/* harmony export */   "setGblPerfMgr": () => (/* binding */ setGblPerfMgr)
/* harmony export */ });
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(29);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(20);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(18);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(21);
/*
 * Application Insights JavaScript SDK - Core, 2.8.15
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */






var strExecutionContextKey = "ctx";
var strParentContextKey = "ParentContextKey";
var strChildrenContextKey = "ChildrenContextKey";
var _defaultPerfManager = null;
var PerfEvent = /** @class */ (function () {
    function PerfEvent(name, payloadDetails, isAsync) {
        var _self = this;
        var accessorDefined = false;
        _self.start = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_0__.dateNow)();
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_NAME /* @min:%2ename */] = name;
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_ASYNC /* @min:%2eisAsync */] = isAsync;
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_CHILD_EVT /* @min:%2eisChildEvt */] = function () { return false; };
        if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_0__.isFunction)(payloadDetails)) {
            // Create an accessor to minimize the potential performance impact of executing the payloadDetails callback
            var theDetails_1;
            accessorDefined = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_0__.objDefineAccessors)(_self, "payload", function () {
                // Delay the execution of the payloadDetails until needed
                if (!theDetails_1 && (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_0__.isFunction)(payloadDetails)) {
                    theDetails_1 = payloadDetails();
                    // clear it out now so the referenced objects can be garbage collected
                    payloadDetails = null;
                }
                return theDetails_1;
            });
        }
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_CTX /* @min:%2egetCtx */] = function (key) {
            if (key) {
                // The parent and child links are located directly on the object (for better viewing in the DebugPlugin)
                if (key === PerfEvent[strParentContextKey] || key === PerfEvent[strChildrenContextKey]) {
                    return _self[key];
                }
                return (_self[strExecutionContextKey] || {})[key];
            }
            return null;
        };
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */] = function (key, value) {
            if (key) {
                // Put the parent and child links directly on the object (for better viewing in the DebugPlugin)
                if (key === PerfEvent[strParentContextKey]) {
                    // Simple assumption, if we are setting a parent then we must be a child
                    if (!_self[key]) {
                        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_CHILD_EVT /* @min:%2eisChildEvt */] = function () { return true; };
                    }
                    _self[key] = value;
                }
                else if (key === PerfEvent[strChildrenContextKey]) {
                    _self[key] = value;
                }
                else {
                    var ctx = _self[strExecutionContextKey] = _self[strExecutionContextKey] || {};
                    ctx[key] = value;
                }
            }
        };
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_COMPLETE /* @min:%2ecomplete */] = function () {
            var childTime = 0;
            var childEvts = _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_CTX /* @min:%2egetCtx */](PerfEvent[strChildrenContextKey]);
            if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_0__.isArray)(childEvts)) {
                for (var lp = 0; lp < childEvts[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */]; lp++) {
                    var childEvt = childEvts[lp];
                    if (childEvt) {
                        childTime += childEvt[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TIME /* @min:%2etime */];
                    }
                }
            }
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TIME /* @min:%2etime */] = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_0__.dateNow)() - _self.start;
            _self.exTime = _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TIME /* @min:%2etime */] - childTime;
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_COMPLETE /* @min:%2ecomplete */] = function () { };
            if (!accessorDefined && (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_0__.isFunction)(payloadDetails)) {
                // If we couldn't define the property set during complete -- to minimize the perf impact until after the time
                _self.payload = payloadDetails();
            }
        };
    }
    PerfEvent.ParentContextKey = "parent";
    PerfEvent.ChildrenContextKey = "childEvts";
    return PerfEvent;
}());

var PerfManager = /** @class */ (function () {
    function PerfManager(manager) {
        /**
         * General bucket used for execution context set and retrieved via setCtx() and getCtx.
         * Defined as private so it can be visualized via the DebugPlugin
         */
        this.ctx = {};
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_2__["default"])(PerfManager, this, function (_self) {
            _self.create = function (src, payloadDetails, isAsync) {
                // TODO (@MSNev): at some point we will want to add additional configuration to "select" which events to instrument
                // for now this is just a simple do everything.
                return new PerfEvent(src, payloadDetails, isAsync);
            };
            _self.fire = function (perfEvent) {
                if (perfEvent) {
                    perfEvent[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_COMPLETE /* @min:%2ecomplete */]();
                    if (manager && (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_0__.isFunction)(manager[_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_PERF_EVENT /* @min:%2eperfEvent */])) {
                        manager[_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_PERF_EVENT /* @min:%2eperfEvent */](perfEvent);
                    }
                }
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */] = function (key, value) {
                if (key) {
                    var ctx = _self[strExecutionContextKey] = _self[strExecutionContextKey] || {};
                    ctx[key] = value;
                }
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_CTX /* @min:%2egetCtx */] = function (key) {
                return (_self[strExecutionContextKey] || {})[key];
            };
        });
    }
// Removed Stub for PerfManager.prototype.create.
// Removed Stub for PerfManager.prototype.fire.
// Removed Stub for PerfManager.prototype.setCtx.
// Removed Stub for PerfManager.prototype.getCtx.
    // This is a workaround for an IE8 bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    // this will be removed when ES3 support is dropped.
    PerfManager.__ieDyn=1;

    return PerfManager;
}());

var doPerfActiveKey = "CoreUtils.doPerf";
/**
 * Helper function to wrap a function with a perf event
 * @param mgrSource - The Performance Manager or a Performance provider source (may be null)
 * @param getSource - The callback to create the source name for the event (if perf monitoring is enabled)
 * @param func - The function to call and measure
 * @param details - A function to return the payload details
 * @param isAsync - Is the event / function being call asynchronously or synchronously
 */
function doPerf(mgrSource, getSource, func, details, isAsync) {
    if (mgrSource) {
        var perfMgr = mgrSource;
        if (perfMgr[_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_GET_PERF_MGR]) {
            // Looks like a perf manager provider object
            perfMgr = perfMgr[_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_GET_PERF_MGR]();
        }
        if (perfMgr) {
            var perfEvt = void 0;
            var currentActive = perfMgr[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_CTX /* @min:%2egetCtx */](doPerfActiveKey);
            try {
                perfEvt = perfMgr.create(getSource(), details, isAsync);
                if (perfEvt) {
                    if (currentActive && perfEvt[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */]) {
                        perfEvt[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */](PerfEvent[strParentContextKey], currentActive);
                        if (currentActive[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_CTX /* @min:%2egetCtx */] && currentActive[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */]) {
                            var children = currentActive[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_CTX /* @min:%2egetCtx */](PerfEvent[strChildrenContextKey]);
                            if (!children) {
                                children = [];
                                currentActive[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */](PerfEvent[strChildrenContextKey], children);
                            }
                            children[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PUSH /* @min:%2epush */](perfEvt);
                        }
                    }
                    // Set this event as the active event now
                    perfMgr[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */](doPerfActiveKey, perfEvt);
                    return func(perfEvt);
                }
            }
            catch (ex) {
                if (perfEvt && perfEvt[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */]) {
                    perfEvt[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */]("exception", ex);
                }
            }
            finally {
                // fire the perf event
                if (perfEvt) {
                    perfMgr.fire(perfEvt);
                }
                // Reset the active event to the previous value
                perfMgr[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */](doPerfActiveKey, currentActive);
            }
        }
    }
    return func();
}
/**
 * Set the global performance manager to use when there is no core instance or it has not been initialized yet.
 * @param perfManager - The IPerfManager instance to use when no performance manager is supplied.
 */
function setGblPerfMgr(perfManager) {
    _defaultPerfManager = perfManager;
}
/**
 * Get the current global performance manager that will be used with no performance manager is supplied.
 * @returns - The current default manager
 */
function getGblPerfMgr() {
    return _defaultPerfManager;
}
//# sourceMappingURL=PerfManager.js.map

/***/ }),
/* 32 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "STR_DEFAULT_ENDPOINT_URL": () => (/* binding */ STR_DEFAULT_ENDPOINT_URL),
/* harmony export */   "STR_EMPTY": () => (/* binding */ STR_EMPTY),
/* harmony export */   "STR_PLUGIN_VERSION_STRING": () => (/* binding */ STR_PLUGIN_VERSION_STRING),
/* harmony export */   "STR_PLUGIN_VERSION_STRING_ARR": () => (/* binding */ STR_PLUGIN_VERSION_STRING_ARR),
/* harmony export */   "STR_PROPERTIES": () => (/* binding */ STR_PROPERTIES),
/* harmony export */   "STR_VERSION": () => (/* binding */ STR_VERSION)
/* harmony export */ });
/*
 * 1DS JS SDK Core, 3.2.13
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */

// Licensed under the MIT License.
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// Note: DON'T Export these const from the package as we are still targeting ES3 this will export a mutable variables that someone could change!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// Generally you should only put values that are used more than 2 times and then only if not already exposed as a constant (such as SdkCoreNames)
// as when using "short" named values from here they will be will be minified smaller than the SdkCoreNames[eSdkCoreNames.xxxx] value.
var STR_EMPTY = "";
var STR_DEFAULT_ENDPOINT_URL = "https://browser.events.data.microsoft.com/OneCollector/1.0/";
var STR_PLUGIN_VERSION_STRING = "pluginVersionString";
var STR_PLUGIN_VERSION_STRING_ARR = STR_PLUGIN_VERSION_STRING + "Arr";
var STR_VERSION = "version";
var STR_PROPERTIES = "properties";
//# sourceMappingURL=InternalConstants.js.map

/***/ }),
/* 33 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CoreUtils": () => (/* binding */ CoreUtils),
/* harmony export */   "FullVersionString": () => (/* binding */ FullVersionString),
/* harmony export */   "Utils": () => (/* binding */ Utils),
/* harmony export */   "Version": () => (/* binding */ Version),
/* harmony export */   "createGuid": () => (/* binding */ createGuid),
/* harmony export */   "deleteCookie": () => (/* binding */ deleteCookie),
/* harmony export */   "disableCookies": () => (/* binding */ disableCookies),
/* harmony export */   "extend": () => (/* binding */ extend),
/* harmony export */   "getCommonSchemaMetaData": () => (/* binding */ getCommonSchemaMetaData),
/* harmony export */   "getCookie": () => (/* binding */ getCookie),
/* harmony export */   "getCookieValue": () => (/* binding */ getCookieValue),
/* harmony export */   "getFieldValueType": () => (/* binding */ getFieldValueType),
/* harmony export */   "getTenantId": () => (/* binding */ getTenantId),
/* harmony export */   "getTime": () => (/* binding */ getTime),
/* harmony export */   "isArrayValid": () => (/* binding */ isArrayValid),
/* harmony export */   "isChromium": () => (/* binding */ isChromium),
/* harmony export */   "isDocumentObjectAvailable": () => (/* binding */ isDocumentObjectAvailable),
/* harmony export */   "isLatency": () => (/* binding */ isLatency),
/* harmony export */   "isUint8ArrayAvailable": () => (/* binding */ isUint8ArrayAvailable),
/* harmony export */   "isValueAssigned": () => (/* binding */ isValueAssigned),
/* harmony export */   "isValueKind": () => (/* binding */ isValueKind),
/* harmony export */   "isWindowObjectAvailable": () => (/* binding */ isWindowObjectAvailable),
/* harmony export */   "openXhr": () => (/* binding */ openXhr),
/* harmony export */   "sanitizeProperty": () => (/* binding */ sanitizeProperty),
/* harmony export */   "setCookie": () => (/* binding */ setCookie),
/* harmony export */   "setProcessTelemetryTimings": () => (/* binding */ setProcessTelemetryTimings)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(18);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(34);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(35);
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(19);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(37);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(36);
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(22);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(32);
/*
 * 1DS JS SDK Core, 3.2.13
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */
var _a;
/**
* Utils.ts
* @author  Abhilash Panwar (abpanwar) Hector Hernandez (hectorh)
* @copyright Microsoft 2018
* File containing utility functions.
*/



var Version = '3.2.13';
var FullVersionString = "1DS-Web-JS-" + Version;
// Defining here so we don't need to take (import) the ApplicationInsights Common module
var strDisabledPropertyName = "Microsoft_ApplicationInsights_BypassAjaxInstrumentation";
var strWithCredentials = "withCredentials";
var strTimeout = "timeout";
// If value is array just get the type for the first element
var _fieldTypeEventPropMap = (_a = {},
    _a[0 /* FieldValueSanitizerType.NotSet */] = 0 /* eEventPropertyType.Unspecified */,
    _a[2 /* FieldValueSanitizerType.Number */] = 6 /* eEventPropertyType.Double */,
    _a[1 /* FieldValueSanitizerType.String */] = 1 /* eEventPropertyType.String */,
    _a[3 /* FieldValueSanitizerType.Boolean */] = 7 /* eEventPropertyType.Bool */,
    _a[4096 /* FieldValueSanitizerType.Array */ | 2 /* FieldValueSanitizerType.Number */] = 6 /* eEventPropertyType.Double */,
    _a[4096 /* FieldValueSanitizerType.Array */ | 1 /* FieldValueSanitizerType.String */] = 1 /* eEventPropertyType.String */,
    _a[4096 /* FieldValueSanitizerType.Array */ | 3 /* FieldValueSanitizerType.Boolean */] = 7 /* eEventPropertyType.Bool */,
    _a);
/**
 * @ignore
 */
// let _uaDisallowsSameSiteNone = null;
var uInt8ArraySupported = null;
// var _areCookiesAvailable: boolean | undefined;
/**
 * Checks if document object is available
 */
var isDocumentObjectAvailable = Boolean((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.getDocument)());
/**
 * Checks if window object is available
 */
var isWindowObjectAvailable = Boolean((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.getWindow)());
/**
 * Checks if value is assigned to the given param.
 * @param value - The token from which the tenant id is to be extracted.
 * @returns True/false denoting if value is assigned to the param.
 */
function isValueAssigned(value) {
    /// <summary> takes a value and checks for undefined, null and empty string </summary>
    /// <param type="any"> value to be tested </param>
    /// <returns> true if value is null undefined or emptyString </returns>
    return !(value === _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY || (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isNullOrUndefined)(value));
}
/**
 * Gets the tenant id from the tenant token.
 * @param apiKey - The token from which the tenant id is to be extracted.
 * @returns The tenant id.
 */
function getTenantId(apiKey) {
    if (apiKey) {
        var indexTenantId = apiKey.indexOf("-");
        if (indexTenantId > -1) {
            return apiKey.substring(0, indexTenantId);
        }
    }
    return _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY;
}
/**
 * Checks if Uint8Array are available in the current environment. Safari and Firefox along with
 * ReactNative are known to not support Uint8Array properly.
 * @returns True if available, false otherwise.
 */
function isUint8ArrayAvailable() {
    if (uInt8ArraySupported === null) {
        uInt8ArraySupported = !(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isUndefined)(Uint8Array) && !isSafariOrFirefox() && !(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isReactNative)();
    }
    return uInt8ArraySupported;
}
/**
 * Checks if the value is a valid EventLatency.
 * @param value - The value that needs to be checked.
 * @returns True if the value is in AWTEventLatency, false otherwise.
 */
function isLatency(value) {
    if (value && (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isNumber)(value) && value >= 1 /* EventLatencyValue.Normal */ && value <= 4 /* EventLatencyValue.Immediate */) {
        return true;
    }
    return false;
}
/**
 * Sanitizes the Property. It checks the that the property name and value are valid. It also
 * checks/populates the correct type and pii of the property value.
 * @param name - property name                          - The property name.
 * @param property - The property value or an IEventProperty containing value,
 * type ,pii and customer content.
 * @returns IEventProperty containing valid name, value, pii and type or null if invalid.
 */
function sanitizeProperty(name, property, stringifyObjects) {
    // Check that property is valid
    if ((!property && !isValueAssigned(property)) || typeof name !== "string") {
        return null;
    }
    // Perf optimization -- only need to get the type once not multiple times
    var propType = typeof property;
    // If the property isn't IEventProperty (and is either string, number, boolean or array), convert it into one.
    if (propType === "string" || propType === "number" || propType === "boolean" || (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isArray)(property)) {
        property = { value: property };
    }
    else if (propType === "object" && !_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_3__.ObjHasOwnProperty.call(property, "value")) {
        property = { value: stringifyObjects ? JSON.stringify(property) : property };
    }
    else if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isNullOrUndefined)(property.value)
        || property.value === _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY || (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isString)(property.value)
        && !(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isNumber)(property.value) && !(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isBoolean)(property.value)
        && !(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isArray)(property.value))) {
        // Since property is IEventProperty, we need to validate its value
        return null;
    }
    // We need to check that if the property value is an array, it is valid
    if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isArray)(property.value) &&
        !isArrayValid(property.value)) {
        return null;
    }
    // If either pii or cc is set convert value to string (since only string pii/cc is allowed).
    // If the value is a complex type like an array that can't be converted to string we will drop
    // the property.
    if (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isNullOrUndefined)(property.kind)) {
        if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isArray)(property.value) || !isValueKind(property.kind)) {
            return null;
        }
        property.value = property.value.toString();
    }
    return property;
}
function getCommonSchemaMetaData(value, kind, type) {
    var encodedTypeValue = -1;
    if (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isUndefined)(value)) {
        if (kind > 0) {
            if (kind === 32) {
                // encode customer content. Value can only be string. bit 13-16 are for cc
                encodedTypeValue = (1 << 13);
            }
            else if (kind <= 13) {
                // encode PII. Value can only be string. bits 5-12 are for Pii
                encodedTypeValue = (kind << 5);
            }
        }
        // isDataType checks that the "type" is a number so we don't need to check for undefined
        if (isDataType(type)) {
            // Data Type is provided and valid, so use that
            if (encodedTypeValue === -1) {
                // Don't return -1
                encodedTypeValue = 0;
            }
            encodedTypeValue |= type;
        }
        else {
            var propType = _fieldTypeEventPropMap[getFieldValueType(value)] || -1;
            if (encodedTypeValue !== -1 && propType !== -1) {
                // pii exists so we must return correct type
                encodedTypeValue |= propType;
            }
            else if (propType === 6 /* eEventPropertyType.Double */) {
                encodedTypeValue = propType;
            }
        }
    }
    return encodedTypeValue;
}
/**
 * @deprecated - Use the core.getCookieMgr().disable()
 * Force the SDK not to store and read any data from cookies.
 * Overriding the applicationinsights-core version for tree-shaking
 */
function disableCookies() {
    (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__.safeGetCookieMgr)(null).setEnabled(false);
}
/**
 * @deprecated - Use the oneDs.getCookieMgr().set()
 * Sets the value of a cookie.
 * @param name - Cookie name.
 * @param value - Cookie value.
 * @param days - Expiration days.
 */
function setCookie(name, value, days) {
    if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__.areCookiesSupported)(null)) {
        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__.safeGetCookieMgr)(null).set(name, value, days * 86400, null, "/");
    }
}
/**
 * @deprecated - Use the oneDs.getCookieMgr().del()
 * Deletes a cookie, by setting its expiration to -1.
 * @param name - Cookie name to delete.
 */
function deleteCookie(name) {
    if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__.areCookiesSupported)(null)) {
        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__.safeGetCookieMgr)(null).del(name);
    }
}
/**
 * @deprecated - Use the oneDs.getCookieMgr().get()
 * Gets the cookie value for the specified cookie.
 * if value is k1=v1&k2==v2 then will return 'v1' for key 'k1'
 * @param cookieName - Cookie name.
 */
function getCookie(name) {
    if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__.areCookiesSupported)(null)) {
        return getCookieValue((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__.safeGetCookieMgr)(null), name);
    }
    return _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY;
}
/**
 * Helper to get and decode the cookie value using decodeURIComponent, this is for historical
 * backward compatibility where the document.cookie value was decoded before parsing.
 * @param cookieMgr - The cookie manager to use
 * @param name - The name of the cookie to get
 * @param decode - A flag to indicate whether the cookie value should be decoded
 * @returns The decoded cookie value (if available) otherwise an empty string.
 */
function getCookieValue(cookieMgr, name, decode) {
    if (decode === void 0) { decode = true; }
    var cookieValue;
    if (cookieMgr) {
        cookieValue = cookieMgr.get(name);
        if (decode && cookieValue && decodeURIComponent) {
            cookieValue = decodeURIComponent(cookieValue);
        }
    }
    return cookieValue || _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY;
}
/**
 * Create a new guid.
 * @param style - The style of guid to generated, defaults to Digits
 * Digits (Default) : 32 digits separated by hyphens: 00000000-0000-0000-0000-000000000000
 * Braces - 32 digits separated by hyphens, enclosed in braces: {00000000-0000-0000-0000-000000000000}
 * Parentheses - 32 digits separated by hyphens, enclosed in parentheses: (00000000-0000-0000-0000-000000000000)
 * Numeric - 32 digits: 00000000000000000000000000000000
 * @returns The formatted guid.
 */
function createGuid(style) {
    if (style === void 0) { style = "D" /* GuidStyle.Digits */; }
    var theGuid = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__.newGuid)();
    if (style === "B" /* GuidStyle.Braces */) {
        theGuid = "{" + theGuid + "}";
    }
    else if (style === "P" /* GuidStyle.Parentheses */) {
        theGuid = "(" + theGuid + ")";
    }
    else if (style === "N" /* GuidStyle.Numeric */) {
        theGuid = theGuid.replace(/-/g, _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY);
    }
    return theGuid;
}
/**
 * Pass in the objects to merge as arguments.
 * @param obj1 - object to merge.  Set this argument to 'true' for a deep extend.
 * @param obj2 - object to merge.
 * @param obj3 - object to merge.
 * @param obj4 - object to merge.
 * @param obj5 - object to merge.
 * @returns The extended object.
 */
function extend(obj, obj2, obj3, obj4, obj5) {
    // Variables
    var extended = {};
    var deep = false;
    var i = 0;
    var length = arguments.length;
    var objProto = Object[_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_3__.strShimPrototype];
    var theArgs = arguments;
    // Check if a deep merge
    if (objProto.toString.call(theArgs[0]) === "[object Boolean]") {
        deep = theArgs[0];
        i++;
    }
    // Loop through each object and conduct a merge
    for (; i < length; i++) {
        var obj = theArgs[i];
        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.objForEachKey)(obj, function (prop, value) {
            // If deep merge and property is an object, merge properties
            if (deep && value && (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isObject)(value)) {
                if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isArray)(value)) {
                    extended[prop] = extended[prop] || [];
                    (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.arrForEach)(value, function (arrayValue, arrayIndex) {
                        if (arrayValue && (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isObject)(arrayValue)) {
                            extended[prop][arrayIndex] = extend(true, extended[prop][arrayIndex], arrayValue);
                        }
                        else {
                            extended[prop][arrayIndex] = arrayValue;
                        }
                    });
                }
                else {
                    extended[prop] = extend(true, extended[prop], value);
                }
            }
            else {
                extended[prop] = value;
            }
        });
    }
    return extended;
}
var getTime = _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__.perfNow;
function isValueKind(value) {
    // Always assume that it's a number (no type checking) for performance as this is used during the JSON serialization
    if (value === 0 /* eValueKind.NotSet */ || ((value > 0 /* eValueKind.NotSet */ && value <= 13 /* eValueKind.Pii_IPV4AddressLegacy */) || value === 32 /* eValueKind.CustomerContent_GenericContent */)) {
        return true;
    }
    return false;
}
function isDataType(value) {
    // Remark: 0 returns false, but it doesn't affect encoding anyways
    // Always assume that it's a number (no type checking) for performance as this is used during the JSON serialization
    if (value >= 0 && value <= 9) {
        return true;
    }
    return false;
}
function isSafariOrFirefox() {
    var nav = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.getNavigator)();
    // If non-browser navigator will be undefined
    if (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isUndefined)(nav) && nav.userAgent) {
        var ua = nav.userAgent.toLowerCase();
        if ((ua.indexOf("safari") >= 0 || ua.indexOf("firefox") >= 0) && ua.indexOf("chrome") < 0) {
            return true;
        }
    }
    return false;
}
function isArrayValid(value) {
    return value.length > 0;
}
function setProcessTelemetryTimings(event, identifier) {
    var evt = event;
    evt.timings = evt.timings || {};
    evt.timings.processTelemetryStart = evt.timings.processTelemetryStart || {};
    evt.timings.processTelemetryStart[identifier] = getTime();
}
/**
 * Returns a bitwise value for the FieldValueSanitizerType enum representing the decoded type of the passed value
 * @param value The value to determine the type
 */
function getFieldValueType(value) {
    var theType = 0 /* FieldValueSanitizerType.NotSet */;
    if (value !== null && value !== undefined) {
        var objType = typeof value;
        if (objType === "string") {
            theType = 1 /* FieldValueSanitizerType.String */;
        }
        else if (objType === "number") {
            theType = 2 /* FieldValueSanitizerType.Number */;
        }
        else if (objType === "boolean") {
            theType = 3 /* FieldValueSanitizerType.Boolean */;
        }
        else if (objType === _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_3__.strShimObject) {
            theType = 4 /* FieldValueSanitizerType.Object */;
            if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isArray)(value)) {
                theType = 4096 /* FieldValueSanitizerType.Array */;
                if (value.length > 0) {
                    // Empty arrays are not supported and are considered to be the same as null
                    theType |= getFieldValueType(value[0]);
                }
            }
            else if (_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_3__.ObjHasOwnProperty.call(value, "value")) {
                // Looks like an IEventProperty
                theType = 8192 /* FieldValueSanitizerType.EventProperty */ | getFieldValueType(value.value);
            }
        }
    }
    return theType;
}
var Utils = {
    Version: Version,
    FullVersionString: FullVersionString,
    strUndefined: _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_3__.strShimUndefined,
    strObject: _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_3__.strShimObject,
    Undefined: _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_3__.strShimUndefined,
    arrForEach: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.arrForEach,
    arrIndexOf: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.arrIndexOf,
    arrMap: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.arrMap,
    arrReduce: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.arrReduce,
    objKeys: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.objKeys,
    toISOString: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.toISOString,
    isReactNative: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isReactNative,
    isString: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isString,
    isNumber: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isNumber,
    isBoolean: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isBoolean,
    isFunction: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isFunction,
    isArray: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isArray,
    isObject: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isObject,
    strTrim: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.strTrim,
    isDocumentObjectAvailable: isDocumentObjectAvailable,
    isWindowObjectAvailable: isWindowObjectAvailable,
    isValueAssigned: isValueAssigned,
    getTenantId: getTenantId,
    isBeaconsSupported: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isBeaconsSupported,
    isUint8ArrayAvailable: isUint8ArrayAvailable,
    isLatency: isLatency,
    sanitizeProperty: sanitizeProperty,
    getISOString: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.toISOString,
    useXDomainRequest: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.useXDomainRequest,
    getCommonSchemaMetaData: getCommonSchemaMetaData,
    cookieAvailable: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__.areCookiesSupported,
    disallowsSameSiteNone: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__.uaDisallowsSameSiteNone,
    setCookie: setCookie,
    deleteCookie: deleteCookie,
    getCookie: getCookie,
    createGuid: createGuid,
    extend: extend,
    getTime: getTime,
    isValueKind: isValueKind,
    isArrayValid: isArrayValid,
    objDefineAccessors: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.objDefineAccessors,
    addPageUnloadEventListener: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__.addPageUnloadEventListener,
    setProcessTelemetryTimings: setProcessTelemetryTimings,
    addEventHandler: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__.addEventHandler,
    getFieldValueType: getFieldValueType,
    strEndsWith: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.strEndsWith,
    objForEachKey: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.objForEachKey
};
/**
 * Provides a collection of utility functions, included for backward compatibility with previous releases.
 * @deprecated Marking this instance as deprecated in favor of direct usage of the helper functions
 * as direct usage provides better tree-shaking and minification by avoiding the inclusion of the unused items
 * in your resulting code.
 * Overriding the applicationinsights-core version for tree-shaking
 */
var CoreUtils = {
    _canUseCookies: undefined,
    isTypeof: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isTypeof,
    isUndefined: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isUndefined,
    isNullOrUndefined: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isNullOrUndefined,
    hasOwnProperty: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.hasOwnProperty,
    isFunction: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isFunction,
    isObject: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isObject,
    isDate: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isDate,
    isArray: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isArray,
    isError: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isError,
    isString: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isString,
    isNumber: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isNumber,
    isBoolean: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.isBoolean,
    toISOString: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.toISOString,
    arrForEach: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.arrForEach,
    arrIndexOf: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.arrIndexOf,
    arrMap: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.arrMap,
    arrReduce: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.arrReduce,
    strTrim: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.strTrim,
    objCreate: _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_7__.objCreateFn,
    objKeys: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.objKeys,
    objDefineAccessors: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.objDefineAccessors,
    addEventHandler: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__.addEventHandler,
    dateNow: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.dateNow,
    isIE: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isIE,
    disableCookies: disableCookies,
    newGuid: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__.newGuid,
    perfNow: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__.perfNow,
    newId: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__.newId,
    randomValue: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__.randomValue,
    random32: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__.random32,
    mwcRandomSeed: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__.mwcRandomSeed,
    mwcRandom32: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__.mwcRandom32,
    generateW3CId: _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__.generateW3CId
};
/**
 * Helper to identify whether we are running in a chromium based browser environment
 */
function isChromium() {
    return !!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.getGlobalInst)("chrome");
}
/**
 * Create and open an XMLHttpRequest object
 * @param method - The request method
 * @param urlString - The url
 * @param withCredentials - Option flag indicating that credentials should be sent
 * @param disabled - Optional flag indicating that the XHR object should be marked as disabled and not tracked (default is false)
 * @param isSync - Optional flag indicating if the instance should be a synchronous request (defaults to false)
 * @param timeout - Optional value identifying the timeout value that should be assigned to the XHR request
 * @returns A new opened XHR request
 */
function openXhr(method, urlString, withCredentials, disabled, isSync, timeout) {
    if (disabled === void 0) { disabled = false; }
    if (isSync === void 0) { isSync = false; }
    function _wrapSetXhrProp(xhr, prop, value) {
        try {
            xhr[prop] = value;
        }
        catch (e) {
            // - Wrapping as depending on the environment setting the property may fail (non-terminally)
        }
    }
    var xhr = new XMLHttpRequest();
    if (disabled) {
        // Tag the instance so it's not tracked (trackDependency)
        // If the environment has locked down the XMLHttpRequest (preventExtensions and/or freeze), this would
        // cause the request to fail and we no telemetry would be sent
        _wrapSetXhrProp(xhr, strDisabledPropertyName, disabled);
    }
    if (withCredentials) {
        // Some libraries require that the withCredentials flag is set "before" open and
        // - Wrapping as IE 10 has started throwing when setting before open
        _wrapSetXhrProp(xhr, strWithCredentials, withCredentials);
    }
    xhr.open(method, urlString, !isSync);
    if (withCredentials) {
        // withCredentials should be set AFTER open (https://xhr.spec.whatwg.org/#the-withcredentials-attribute)
        // And older firefox instances from 11+ will throw for sync events (current versions don't) which happens during unload processing
        _wrapSetXhrProp(xhr, strWithCredentials, withCredentials);
    }
    // Only set the timeout for asynchronous requests as
    // "Timeout shouldn't be used for synchronous XMLHttpRequests requests used in a document environment or it will throw an InvalidAccessError exception.""
    // https://developer.mozilla.org/en-US/docs/Web/API/XMLHttpRequest/timeout
    if (!isSync && timeout) {
        _wrapSetXhrProp(xhr, strTimeout, timeout);
    }
    return xhr;
}
//# sourceMappingURL=Utils.js.map

/***/ }),
/* 34 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "_gblCookieMgr": () => (/* binding */ _gblCookieMgr),
/* harmony export */   "areCookiesSupported": () => (/* binding */ areCookiesSupported),
/* harmony export */   "createCookieMgr": () => (/* binding */ createCookieMgr),
/* harmony export */   "safeGetCookieMgr": () => (/* binding */ safeGetCookieMgr),
/* harmony export */   "uaDisallowsSameSiteNone": () => (/* binding */ uaDisallowsSameSiteNone)
/* harmony export */ });
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(20);
/* harmony import */ var _DiagnosticLogger__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(27);
/* harmony import */ var _EnvUtils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(18);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(21);
/*
 * Application Insights JavaScript SDK - Core, 2.8.15
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */





var strToGMTString = "toGMTString";
var strToUTCString = "toUTCString";
var strCookie = "cookie";
var strExpires = "expires";
var strEnabled = "enabled";
var strIsCookieUseDisabled = "isCookieUseDisabled";
var strDisableCookiesUsage = "disableCookiesUsage";
var strConfigCookieMgr = "_ckMgr";
var _supportsCookies = null;
var _allowUaSameSite = null;
var _parsedCookieValue = null;
var _doc = (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_0__.getDocument)();
var _cookieCache = {};
var _globalCookieConfig = {};
/**
 * @ignore
 * DO NOT USE or export from the module, this is exposed as public to support backward compatibility of previous static utility methods only.
 * If you want to manager cookies either use the ICookieMgr available from the core instance via getCookieMgr() or create
 * your own instance of the CookieMgr and use that.
 * Using this directly for enabling / disabling cookie handling will not only affect your usage but EVERY user of cookies.
 * Example, if you are using a shared component that is also using Application Insights you will affect their cookie handling.
 * @param logger - The DiagnosticLogger to use for reporting errors.
 */
function _gblCookieMgr(config, logger) {
    // Stash the global instance against the BaseCookieMgr class
    var inst = createCookieMgr[strConfigCookieMgr] || _globalCookieConfig[strConfigCookieMgr];
    if (!inst) {
        // Note: not using the getSetValue() helper as that would require always creating a temporary cookieMgr
        // that ultimately is never used
        inst = createCookieMgr[strConfigCookieMgr] = createCookieMgr(config, logger);
        _globalCookieConfig[strConfigCookieMgr] = inst;
    }
    return inst;
}
function _isMgrEnabled(cookieMgr) {
    if (cookieMgr) {
        return cookieMgr.isEnabled();
    }
    return true;
}
function _createCookieMgrConfig(rootConfig) {
    var cookieMgrCfg = rootConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_COOKIE_CFG /* @min:%2ecookieCfg */] = rootConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_COOKIE_CFG /* @min:%2ecookieCfg */] || {};
    // Sets the values from the root config if not already present on the cookieMgrCfg
    (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.setValue)(cookieMgrCfg, "domain", rootConfig.cookieDomain, _HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isNotNullOrUndefined, _HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isNullOrUndefined);
    (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.setValue)(cookieMgrCfg, "path", rootConfig.cookiePath || "/", null, _HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isNullOrUndefined);
    if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isNullOrUndefined)(cookieMgrCfg[strEnabled])) {
        // Set the enabled from the provided setting or the legacy root values
        var cookieEnabled = void 0;
        if (!(0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isUndefined)(rootConfig[strIsCookieUseDisabled])) {
            cookieEnabled = !rootConfig[strIsCookieUseDisabled];
        }
        if (!(0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isUndefined)(rootConfig[strDisableCookiesUsage])) {
            cookieEnabled = !rootConfig[strDisableCookiesUsage];
        }
        cookieMgrCfg[strEnabled] = cookieEnabled;
    }
    return cookieMgrCfg;
}
function _isIgnoredCookie(cookieMgrCfg, name) {
    if (name && cookieMgrCfg && (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isArray)(cookieMgrCfg.ignoreCookies)) {
        return cookieMgrCfg.ignoreCookies[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_INDEX_OF /* @min:%2eindexOf */](name) !== -1;
    }
    return false;
}
function _isBlockedCookie(cookieMgrCfg, name) {
    if (name && cookieMgrCfg && (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isArray)(cookieMgrCfg.blockedCookies)) {
        if (cookieMgrCfg.blockedCookies[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_INDEX_OF /* @min:%2eindexOf */](name) !== -1) {
            return true;
        }
    }
    return _isIgnoredCookie(cookieMgrCfg, name);
}
/**
 * Helper to return the ICookieMgr from the core (if not null/undefined) or a default implementation
 * associated with the configuration or a legacy default.
 * @param core
 * @param config
 * @returns
 */
function safeGetCookieMgr(core, config) {
    var cookieMgr;
    if (core) {
        // Always returns an instance
        cookieMgr = core.getCookieMgr();
    }
    else if (config) {
        var cookieCfg = config[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_COOKIE_CFG /* @min:%2ecookieCfg */];
        if (cookieCfg[strConfigCookieMgr]) {
            cookieMgr = cookieCfg[strConfigCookieMgr];
        }
        else {
            cookieMgr = createCookieMgr(config);
        }
    }
    if (!cookieMgr) {
        // Get or initialize the default global (legacy) cookie manager if we couldn't find one
        cookieMgr = _gblCookieMgr(config, (core || {})[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LOGGER /* @min:%2elogger */]);
    }
    return cookieMgr;
}
function createCookieMgr(rootConfig, logger) {
    var _a;
    var cookieMgrConfig = _createCookieMgrConfig(rootConfig || _globalCookieConfig);
    var _path = cookieMgrConfig.path || "/";
    var _domain = cookieMgrConfig.domain;
    // Explicitly checking against false, so that setting to undefined will === true
    var _enabled = cookieMgrConfig[strEnabled] !== false;
    var cookieMgr = (_a = {
            isEnabled: function () {
                var enabled = _enabled && areCookiesSupported(logger);
                // Using an indirect lookup for any global cookie manager to support tree shaking for SDK's
                // that don't use the "applicationinsights-core" version of the default cookie function
                var gblManager = _globalCookieConfig[strConfigCookieMgr];
                if (enabled && gblManager && cookieMgr !== gblManager) {
                    // Make sure the GlobalCookie Manager instance (if not this instance) is also enabled.
                    // As the global (deprecated) functions may have been called (for backward compatibility)
                    enabled = _isMgrEnabled(gblManager);
                }
                return enabled;
            }
        },
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_ENABLED /* @min:setEnabled */] = function (value) {
            // Explicitly checking against false, so that setting to undefined will === true
            _enabled = value !== false;
        },
        _a.set = function (name, value, maxAgeSec, domain, path) {
            var result = false;
            if (_isMgrEnabled(cookieMgr) && !_isBlockedCookie(cookieMgrConfig, name)) {
                var values = {};
                var theValue = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strTrim)(value || _InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_EMPTY);
                var idx = theValue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_INDEX_OF /* @min:%2eindexOf */](";");
                if (idx !== -1) {
                    theValue = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strTrim)(value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SUBSTRING /* @min:%2esubstring */](0, idx));
                    values = _extractParts(value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SUBSTRING /* @min:%2esubstring */](idx + 1));
                }
                // Only update domain if not already present (isUndefined) and the value is truthy (not null, undefined or empty string)
                (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.setValue)(values, "domain", domain || _domain, _HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isTruthy, _HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isUndefined);
                if (!(0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isNullOrUndefined)(maxAgeSec)) {
                    var _isIE = (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_0__.isIE)();
                    if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isUndefined)(values[strExpires])) {
                        var nowMs = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.dateNow)();
                        // Only add expires if not already present
                        var expireMs = nowMs + (maxAgeSec * 1000);
                        // Sanity check, if zero or -ve then ignore
                        if (expireMs > 0) {
                            var expiry = new Date();
                            expiry.setTime(expireMs);
                            (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.setValue)(values, strExpires, _formatDate(expiry, !_isIE ? strToUTCString : strToGMTString) || _formatDate(expiry, _isIE ? strToGMTString : strToUTCString) || _InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_EMPTY, _HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isTruthy);
                        }
                    }
                    if (!_isIE) {
                        // Only replace if not already present
                        (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.setValue)(values, "max-age", _InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_EMPTY + maxAgeSec, null, _HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isUndefined);
                    }
                }
                var location_1 = (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_0__.getLocation)();
                if (location_1 && location_1.protocol === "https:") {
                    (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.setValue)(values, "secure", null, null, _HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isUndefined);
                    // Only set same site if not also secure
                    if (_allowUaSameSite === null) {
                        _allowUaSameSite = !uaDisallowsSameSiteNone(((0,_EnvUtils__WEBPACK_IMPORTED_MODULE_0__.getNavigator)() || {})[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_USER_AGENT /* @min:%2euserAgent */]);
                    }
                    if (_allowUaSameSite) {
                        (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.setValue)(values, "SameSite", "None", null, _HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isUndefined);
                    }
                }
                (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.setValue)(values, "path", path || _path, null, _HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isUndefined);
                var setCookieFn = cookieMgrConfig.setCookie || _setCookieValue;
                setCookieFn(name, _formatCookieValue(theValue, values));
                result = true;
            }
            return result;
        },
        _a.get = function (name) {
            var value = _InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_EMPTY;
            if (_isMgrEnabled(cookieMgr) && !_isIgnoredCookie(cookieMgrConfig, name)) {
                value = (cookieMgrConfig.getCookie || _getCookieValue)(name);
            }
            return value;
        },
        _a.del = function (name, path) {
            var result = false;
            if (_isMgrEnabled(cookieMgr)) {
                // Only remove the cookie if the manager and cookie support has not been disabled
                result = cookieMgr.purge(name, path);
            }
            return result;
        },
        _a.purge = function (name, path) {
            var _a;
            var result = false;
            if (areCookiesSupported(logger)) {
                // Setting the expiration date in the past immediately removes the cookie
                var values = (_a = {},
                    _a["path"] = path ? path : "/",
                    _a[strExpires] = "Thu, 01 Jan 1970 00:00:01 GMT",
                    _a);
                if (!(0,_EnvUtils__WEBPACK_IMPORTED_MODULE_0__.isIE)()) {
                    // Set max age to expire now
                    values["max-age"] = "0";
                }
                var delCookie = cookieMgrConfig.delCookie || _setCookieValue;
                delCookie(name, _formatCookieValue(_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_EMPTY, values));
                result = true;
            }
            return result;
        },
        _a);
    // Associated this cookie manager with the config
    cookieMgr[strConfigCookieMgr] = cookieMgr;
    return cookieMgr;
}
/*
* Helper method to tell if document.cookie object is supported by the runtime
*/
function areCookiesSupported(logger) {
    if (_supportsCookies === null) {
        _supportsCookies = false;
        try {
            var doc = _doc || {};
            _supportsCookies = doc[strCookie] !== undefined;
        }
        catch (e) {
            (0,_DiagnosticLogger__WEBPACK_IMPORTED_MODULE_4__._throwInternal)(logger, 2 /* eLoggingSeverity.WARNING */, 68 /* _eInternalMessageId.CannotAccessCookie */, "Cannot access document.cookie - " + (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.getExceptionName)(e), { exception: (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_0__.dumpObj)(e) });
        }
    }
    return _supportsCookies;
}
function _extractParts(theValue) {
    var values = {};
    if (theValue && theValue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */]) {
        var parts = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strTrim)(theValue)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SPLIT /* @min:%2esplit */](";");
        (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.arrForEach)(parts, function (thePart) {
            thePart = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strTrim)(thePart || _InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_EMPTY);
            if (thePart) {
                var idx = thePart[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_INDEX_OF /* @min:%2eindexOf */]("=");
                if (idx === -1) {
                    values[thePart] = null;
                }
                else {
                    values[(0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strTrim)(thePart[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SUBSTRING /* @min:%2esubstring */](0, idx))] = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strTrim)(thePart[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SUBSTRING /* @min:%2esubstring */](idx + 1));
                }
            }
        });
    }
    return values;
}
function _formatDate(theDate, func) {
    if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isFunction)(theDate[func])) {
        return theDate[func]();
    }
    return null;
}
function _formatCookieValue(value, values) {
    var cookieValue = value || _InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_EMPTY;
    (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.objForEachKey)(values, function (name, theValue) {
        cookieValue += "; " + name + (!(0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isNullOrUndefined)(theValue) ? "=" + theValue : _InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_EMPTY);
    });
    return cookieValue;
}
function _getCookieValue(name) {
    var cookieValue = _InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_EMPTY;
    if (_doc) {
        var theCookie = _doc[strCookie] || _InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_EMPTY;
        if (_parsedCookieValue !== theCookie) {
            _cookieCache = _extractParts(theCookie);
            _parsedCookieValue = theCookie;
        }
        cookieValue = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strTrim)(_cookieCache[name] || _InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_EMPTY);
    }
    return cookieValue;
}
function _setCookieValue(name, cookieValue) {
    if (_doc) {
        _doc[strCookie] = name + "=" + cookieValue;
    }
}
function uaDisallowsSameSiteNone(userAgent) {
    if (!(0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isString)(userAgent)) {
        return false;
    }
    // Cover all iOS based browsers here. This includes:
    // - Safari on iOS 12 for iPhone, iPod Touch, iPad
    // - WkWebview on iOS 12 for iPhone, iPod Touch, iPad
    // - Chrome on iOS 12 for iPhone, iPod Touch, iPad
    // All of which are broken by SameSite=None, because they use the iOS networking stack
    if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "CPU iPhone OS 12") || (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "iPad; CPU OS 12")) {
        return true;
    }
    // Cover Mac OS X based browsers that use the Mac OS networking stack. This includes:
    // - Safari on Mac OS X
    // This does not include:
    // - Internal browser on Mac OS X
    // - Chrome on Mac OS X
    // - Chromium on Mac OS X
    // Because they do not use the Mac OS networking stack.
    if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "Macintosh; Intel Mac OS X 10_14") && (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "Version/") && (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "Safari")) {
        return true;
    }
    // Cover Mac OS X internal browsers that use the Mac OS networking stack. This includes:
    // - Internal browser on Mac OS X
    // This does not include:
    // - Safari on Mac OS X
    // - Chrome on Mac OS X
    // - Chromium on Mac OS X
    // Because they do not use the Mac OS networking stack.
    if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "Macintosh; Intel Mac OS X 10_14") && (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strEndsWith)(userAgent, "AppleWebKit/605.1.15 (KHTML, like Gecko)")) {
        return true;
    }
    // Cover Chrome 50-69, because some versions are broken by SameSite=None, and none in this range require it.
    // Note: this covers some pre-Chromium Edge versions, but pre-Chromim Edge does not require SameSite=None, so this is fine.
    // Note: this regex applies to Windows, Mac OS X, and Linux, deliberately.
    if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "Chrome/5") || (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "Chrome/6")) {
        return true;
    }
    // Unreal Engine runs Chromium 59, but does not advertise as Chrome until 4.23. Treat versions of Unreal
    // that don't specify their Chrome version as lacking support for SameSite=None.
    if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "UnrealEngine") && !(0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "Chrome")) {
        return true;
    }
    // UCBrowser < 12.13.2 ignores Set-Cookie headers with SameSite=None
    // NB: this rule isn't complete - you need regex to make a complete rule.
    // See: https://www.chromium.org/updates/same-site/incompatible-clients
    if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "UCBrowser/12") || (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "UCBrowser/11")) {
        return true;
    }
    return false;
}
//# sourceMappingURL=CookieMgr.js.map

/***/ }),
/* 35 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CoreUtils": () => (/* binding */ CoreUtils),
/* harmony export */   "EventHelper": () => (/* binding */ EventHelper),
/* harmony export */   "Undefined": () => (/* binding */ Undefined),
/* harmony export */   "_legacyCookieMgr": () => (/* binding */ _legacyCookieMgr),
/* harmony export */   "canUseCookies": () => (/* binding */ canUseCookies),
/* harmony export */   "deleteCookie": () => (/* binding */ deleteCookie),
/* harmony export */   "disableCookies": () => (/* binding */ disableCookies),
/* harmony export */   "generateW3CId": () => (/* binding */ generateW3CId),
/* harmony export */   "getCookie": () => (/* binding */ getCookie),
/* harmony export */   "newGuid": () => (/* binding */ newGuid),
/* harmony export */   "perfNow": () => (/* binding */ perfNow),
/* harmony export */   "setCookie": () => (/* binding */ setCookie),
/* harmony export */   "strEndsWith": () => (/* binding */ strEndsWith)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19);
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(22);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(20);
/* harmony import */ var _CookieMgr__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(34);
/* harmony import */ var _EnvUtils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(28);
/* harmony import */ var _EventHelpers__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(37);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(18);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(21);
/* harmony import */ var _RandomHelper__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(36);
/*
 * Application Insights JavaScript SDK - Core, 2.8.15
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */











var _cookieMgrs = null;
var _canUseCookies; // legacy supported config
// Added to help with minfication
var Undefined = _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.strShimUndefined;
function newGuid() {
    var uuid = generateW3CId();
    return uuid[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SUBSTRING /* @min:%2esubstring */](0, 8) + "-" + uuid[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SUBSTRING /* @min:%2esubstring */](8, 12) + "-" + uuid[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SUBSTRING /* @min:%2esubstring */](12, 16) + "-" + uuid[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SUBSTRING /* @min:%2esubstring */](16, 20) + "-" + uuid[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SUBSTRING /* @min:%2esubstring */](20);
}
/**
 * Return the current value of the Performance Api now() function (if available) and fallback to dateNow() if it is unavailable (IE9 or less)
 * https://caniuse.com/#search=performance.now
 */
function perfNow() {
    var perf = (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_2__.getPerformance)();
    if (perf && perf.now) {
        return perf.now();
    }
    return (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.dateNow)();
}
/**
 * The strEndsWith() method determines whether a string ends with the characters of a specified string, returning true or false as appropriate.
 * @param value - The value to check whether it ends with the search value.
 * @param search - The characters to be searched for at the end of the value.
 * @returns true if the given search value is found at the end of the string, otherwise false.
 */
function strEndsWith(value, search) {
    if (value && search) {
        var len = value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */];
        var start = len - search[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */];
        return value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SUBSTRING /* @min:%2esubstring */](start >= 0 ? start : 0, len) === search;
    }
    return false;
}
/**
 * generate W3C trace id
 */
function generateW3CId() {
    var hexValues = ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"];
    // rfc4122 version 4 UUID without dashes and with lowercase letters
    var oct = _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EMPTY, tmp;
    for (var a = 0; a < 4; a++) {
        tmp = (0,_RandomHelper__WEBPACK_IMPORTED_MODULE_5__.random32)();
        oct +=
            hexValues[tmp & 0xF] +
                hexValues[tmp >> 4 & 0xF] +
                hexValues[tmp >> 8 & 0xF] +
                hexValues[tmp >> 12 & 0xF] +
                hexValues[tmp >> 16 & 0xF] +
                hexValues[tmp >> 20 & 0xF] +
                hexValues[tmp >> 24 & 0xF] +
                hexValues[tmp >> 28 & 0xF];
    }
    // "Set the two most significant bits (bits 6 and 7) of the clock_seq_hi_and_reserved to zero and one, respectively"
    var clockSequenceHi = hexValues[8 + ((0,_RandomHelper__WEBPACK_IMPORTED_MODULE_5__.random32)() & 0x03) | 0];
    return oct[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SUBSTR /* @min:%2esubstr */](0, 8) + oct[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SUBSTR /* @min:%2esubstr */](9, 4) + "4" + oct[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SUBSTR /* @min:%2esubstr */](13, 3) + clockSequenceHi + oct[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SUBSTR /* @min:%2esubstr */](16, 3) + oct[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SUBSTR /* @min:%2esubstr */](19, 12);
}
/**
 * Provides a collection of utility functions, included for backward compatibility with previous releases.
 * @deprecated Marking this instance as deprecated in favor of direct usage of the helper functions
 * as direct usage provides better tree-shaking and minification by avoiding the inclusion of the unused items
 * in your resulting code.
 */
var CoreUtils = {
    _canUseCookies: undefined,
    isTypeof: _HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.isTypeof,
    isUndefined: _HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.isUndefined,
    isNullOrUndefined: _HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.isNullOrUndefined,
    hasOwnProperty: _HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.hasOwnProperty,
    isFunction: _HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.isFunction,
    isObject: _HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.isObject,
    isDate: _HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.isDate,
    isArray: _HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.isArray,
    isError: _HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.isError,
    isString: _HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.isString,
    isNumber: _HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.isNumber,
    isBoolean: _HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.isBoolean,
    toISOString: _HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.toISOString,
    arrForEach: _HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.arrForEach,
    arrIndexOf: _HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.arrIndexOf,
    arrMap: _HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.arrMap,
    arrReduce: _HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.arrReduce,
    strTrim: _HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.strTrim,
    objCreate: _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_6__.objCreateFn,
    objKeys: _HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.objKeys,
    objDefineAccessors: _HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.objDefineAccessors,
    addEventHandler: _EventHelpers__WEBPACK_IMPORTED_MODULE_7__.addEventHandler,
    dateNow: _HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.dateNow,
    isIE: _EnvUtils__WEBPACK_IMPORTED_MODULE_2__.isIE,
    disableCookies: disableCookies,
    newGuid: newGuid,
    perfNow: perfNow,
    newId: _RandomHelper__WEBPACK_IMPORTED_MODULE_5__.newId,
    randomValue: _RandomHelper__WEBPACK_IMPORTED_MODULE_5__.randomValue,
    random32: _RandomHelper__WEBPACK_IMPORTED_MODULE_5__.random32,
    mwcRandomSeed: _RandomHelper__WEBPACK_IMPORTED_MODULE_5__.mwcRandomSeed,
    mwcRandom32: _RandomHelper__WEBPACK_IMPORTED_MODULE_5__.mwcRandom32,
    generateW3CId: generateW3CId
};
var GuidRegex = /[xy]/g;
var EventHelper = {
    Attach: _EventHelpers__WEBPACK_IMPORTED_MODULE_7__.attachEvent,
    AttachEvent: _EventHelpers__WEBPACK_IMPORTED_MODULE_7__.attachEvent,
    Detach: _EventHelpers__WEBPACK_IMPORTED_MODULE_7__.detachEvent,
    DetachEvent: _EventHelpers__WEBPACK_IMPORTED_MODULE_7__.detachEvent
};
/**
 * Helper to support backward compatibility for users that use the legacy cookie handling functions and the use the internal
 * CoreUtils._canUseCookies global flag to enable/disable cookies usage.
 * Note: This has the following deliberate side-effects
 * - Creates the global (legacy) cookie manager if it does not already exist
 * - Attempts to add "listeners" to the CoreUtils._canUseCookies property to support the legacy usage
 * @param config
 * @param logger
 * @returns
 */
function _legacyCookieMgr(config, logger) {
    var cookieMgr = (0,_CookieMgr__WEBPACK_IMPORTED_MODULE_8__._gblCookieMgr)(config, logger);
    var legacyCanUseCookies = CoreUtils._canUseCookies;
    if (_cookieMgrs === null) {
        _cookieMgrs = [];
        _canUseCookies = legacyCanUseCookies;
        // Dynamically create get/set property accessors for backward compatibility for enabling / disabling cookies
        // this WILL NOT work for ES3 browsers (< IE8)
        (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.objDefineAccessors)(CoreUtils, "_canUseCookies", function () {
            return _canUseCookies;
        }, function (value) {
            _canUseCookies = value;
            (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(_cookieMgrs, function (mgr) {
                mgr[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_ENABLED /* @min:%2esetEnabled */](value);
            });
        });
    }
    if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.arrIndexOf)(_cookieMgrs, cookieMgr) === -1) {
        _cookieMgrs[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PUSH /* @min:%2epush */](cookieMgr);
    }
    if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.isBoolean)(legacyCanUseCookies)) {
        cookieMgr[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_ENABLED /* @min:%2esetEnabled */](legacyCanUseCookies);
    }
    if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.isBoolean)(_canUseCookies)) {
        cookieMgr[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_ENABLED /* @min:%2esetEnabled */](_canUseCookies);
    }
    return cookieMgr;
}
/**
 * @deprecated - Use the core.getCookieMgr().disable()
 * Force the SDK not to store and read any data from cookies.
 */
function disableCookies() {
    _legacyCookieMgr()[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_ENABLED /* @min:%2esetEnabled */](false);
}
/**
 * @deprecated - Use the core.getCookieMgr().isEnabled()
 * Helper method to tell if document.cookie object is available and whether it can be used.
 */
function canUseCookies(logger) {
    return _legacyCookieMgr(null, logger).isEnabled();
}
/**
 * @deprecated - Use the core.getCookieMgr().get()
 * helper method to access userId and sessionId cookie
 */
function getCookie(logger, name) {
    return _legacyCookieMgr(null, logger).get(name);
}
/**
 * @deprecated - Use the core.getCookieMgr().set()
 * helper method to set userId and sessionId cookie
 */
function setCookie(logger, name, value, domain) {
    _legacyCookieMgr(null, logger).set(name, value, null, domain);
}
/**
 * @deprecated - Use the core.getCookieMgr().del()
 * Deletes a cookie by setting it's expiration time in the past.
 * @param name - The name of the cookie to delete.
 */
function deleteCookie(logger, name) {
    return _legacyCookieMgr(null, logger).del(name);
}
//# sourceMappingURL=CoreUtils.js.map

/***/ }),
/* 36 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "mwcRandom32": () => (/* binding */ mwcRandom32),
/* harmony export */   "mwcRandomSeed": () => (/* binding */ mwcRandomSeed),
/* harmony export */   "newId": () => (/* binding */ newId),
/* harmony export */   "random32": () => (/* binding */ random32),
/* harmony export */   "randomValue": () => (/* binding */ randomValue)
/* harmony export */ });
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(20);
/* harmony import */ var _EnvUtils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(18);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(21);
/*
 * Application Insights JavaScript SDK - Core, 2.8.15
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */






var UInt32Mask = 0x100000000;
var MaxUInt32 = 0xffffffff;
// MWC based Random generator (for IE)
var _mwcSeeded = false;
var _mwcW = 123456789;
var _mwcZ = 987654321;
// Takes any integer
function _mwcSeed(seedValue) {
    if (seedValue < 0) {
        // Make sure we end up with a positive number and not -ve one.
        seedValue >>>= 0;
    }
    _mwcW = (123456789 + seedValue) & MaxUInt32;
    _mwcZ = (987654321 - seedValue) & MaxUInt32;
    _mwcSeeded = true;
}
function _autoSeedMwc() {
    // Simple initialization using default Math.random() - So we inherit any entropy from the browser
    // and bitwise XOR with the current milliseconds
    try {
        var now = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_0__.dateNow)() & 0x7fffffff;
        _mwcSeed(((Math.random() * UInt32Mask) ^ now) + now);
    }
    catch (e) {
        // Don't crash if something goes wrong
    }
}
/**
 * Generate a random value between 0 and maxValue, max value should be limited to a 32-bit maximum.
 * So maxValue(16) will produce a number from 0..16 (range of 17)
 * @param maxValue
 */
function randomValue(maxValue) {
    if (maxValue > 0) {
        return Math.floor((random32() / MaxUInt32) * (maxValue + 1)) >>> 0;
    }
    return 0;
}
/**
 * generate a random 32-bit number (0x000000..0xFFFFFFFF) or (-0x80000000..0x7FFFFFFF), defaults un-unsigned.
 * @param signed - True to return a signed 32-bit number (-0x80000000..0x7FFFFFFF) otherwise an unsigned one (0x000000..0xFFFFFFFF)
 */
function random32(signed) {
    var value = 0;
    var c = (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_1__.getCrypto)() || (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_1__.getMsCrypto)();
    if (c && c.getRandomValues) {
        // Make sure the number is converted into the specified range (-0x80000000..0x7FFFFFFF)
        value = c.getRandomValues(new Uint32Array(1))[0] & MaxUInt32;
    }
    if (value === 0 && (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_1__.isIE)()) {
        // For IE 6, 7, 8 (especially on XP) Math.random is not very random
        if (!_mwcSeeded) {
            // Set the seed for the Mwc algorithm
            _autoSeedMwc();
        }
        // Don't use Math.random for IE
        // Make sure the number is converted into the specified range (-0x80000000..0x7FFFFFFF)
        value = mwcRandom32() & MaxUInt32;
    }
    if (value === 0) {
        // Make sure the number is converted into the specified range (-0x80000000..0x7FFFFFFF)
        value = Math.floor((UInt32Mask * Math.random()) | 0);
    }
    if (!signed) {
        // Make sure we end up with a positive number and not -ve one.
        value >>>= 0;
    }
    return value;
}
/**
 * Seed the MWC random number generator with the specified seed or a random value
 * @param value - optional the number to used as the seed, if undefined, null or zero a random value will be chosen
 */
function mwcRandomSeed(value) {
    if (!value) {
        _autoSeedMwc();
    }
    else {
        _mwcSeed(value);
    }
}
/**
 * Generate a random 32-bit number between (0x000000..0xFFFFFFFF) or (-0x80000000..0x7FFFFFFF), using MWC (Multiply with carry)
 * instead of Math.random() defaults to un-signed.
 * Used as a replacement random generator for IE to avoid issues with older IE instances.
 * @param signed - True to return a signed 32-bit number (-0x80000000..0x7FFFFFFF) otherwise an unsigned one (0x000000..0xFFFFFFFF)
 */
function mwcRandom32(signed) {
    _mwcZ = (36969 * (_mwcZ & 0xFFFF) + (_mwcZ >> 16)) & MaxUInt32;
    _mwcW = (18000 * (_mwcW & 0xFFFF) + (_mwcW >> 16)) & MaxUInt32;
    var value = (((_mwcZ << 16) + (_mwcW & 0xFFFF)) >>> 0) & MaxUInt32 | 0;
    if (!signed) {
        // Make sure we end up with a positive number and not -ve one.
        value >>>= 0;
    }
    return value;
}
/**
 * Generate random base64 id string.
 * The default length is 22 which is 132-bits so almost the same as a GUID but as base64 (the previous default was 5)
 * @param maxLength - Optional value to specify the length of the id to be generated, defaults to 22
 */
function newId(maxLength) {
    if (maxLength === void 0) { maxLength = 22; }
    var base64chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    // Start with an initial random number, consuming the value in reverse byte order
    var number = random32() >>> 0; // Make sure it's a +ve number
    var chars = 0;
    var result = _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY;
    while (result[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_LENGTH /* @min:%2elength */] < maxLength) {
        chars++;
        result += base64chars.charAt(number & 0x3F);
        number >>>= 6; // Zero fill with right shift
        if (chars === 5) {
            // 5 base64 characters === 30 bits so we don't have enough bits for another base64 char
            // So add on another 30 bits and make sure it's +ve
            number = (((random32() << 2) & 0xFFFFFFFF) | (number & 0x03)) >>> 0;
            chars = 0; // We need to reset the number every 5 chars (30 bits)
        }
    }
    return result;
}
//# sourceMappingURL=RandomHelper.js.map

/***/ }),
/* 37 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "__getRegisteredEvents": () => (/* binding */ __getRegisteredEvents),
/* harmony export */   "addEventHandler": () => (/* binding */ addEventHandler),
/* harmony export */   "addEventListeners": () => (/* binding */ addEventListeners),
/* harmony export */   "addPageHideEventListener": () => (/* binding */ addPageHideEventListener),
/* harmony export */   "addPageShowEventListener": () => (/* binding */ addPageShowEventListener),
/* harmony export */   "addPageUnloadEventListener": () => (/* binding */ addPageUnloadEventListener),
/* harmony export */   "attachEvent": () => (/* binding */ attachEvent),
/* harmony export */   "detachEvent": () => (/* binding */ detachEvent),
/* harmony export */   "eventOff": () => (/* binding */ eventOff),
/* harmony export */   "eventOn": () => (/* binding */ eventOn),
/* harmony export */   "mergeEvtNamespace": () => (/* binding */ mergeEvtNamespace),
/* harmony export */   "removeEventHandler": () => (/* binding */ removeEventHandler),
/* harmony export */   "removeEventListeners": () => (/* binding */ removeEventListeners),
/* harmony export */   "removePageHideEventListener": () => (/* binding */ removePageHideEventListener),
/* harmony export */   "removePageShowEventListener": () => (/* binding */ removePageShowEventListener),
/* harmony export */   "removePageUnloadEventListener": () => (/* binding */ removePageUnloadEventListener)
/* harmony export */ });
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(20);
/* harmony import */ var _DataCacheHelper__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38);
/* harmony import */ var _EnvUtils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(28);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(18);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(21);
/*
 * Application Insights JavaScript SDK - Core, 2.8.15
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */







// Added to help with minfication
var strOnPrefix = "on";
var strAttachEvent = "attachEvent";
var strAddEventHelper = "addEventListener";
var strDetachEvent = "detachEvent";
var strRemoveEventListener = "removeEventListener";
var strEvents = "events";
var strVisibilityChangeEvt = "visibilitychange";
var strPageHide = "pagehide";
var strPageShow = "pageshow";
var strUnload = "unload";
var strBeforeUnload = "beforeunload";
var strPageHideNamespace = (0,_DataCacheHelper__WEBPACK_IMPORTED_MODULE_0__.createUniqueNamespace)("aiEvtPageHide");
var strPageShowNamespace = (0,_DataCacheHelper__WEBPACK_IMPORTED_MODULE_0__.createUniqueNamespace)("aiEvtPageShow");
var rRemoveEmptyNs = /\.[\.]+/g;
var rRemoveTrailingEmptyNs = /[\.]+$/;
var _guid = 1;
var elmNodeData = (0,_DataCacheHelper__WEBPACK_IMPORTED_MODULE_0__.createElmNodeData)("events");
var eventNamespace = /^([^.]*)(?:\.(.+)|)/;
function _normalizeNamespace(name) {
    if (name && name[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_REPLACE /* @min:%2ereplace */]) {
        return name[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_REPLACE /* @min:%2ereplace */](/^[\s\.]+|(?=[\s\.])[\.\s]+$/g, _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY);
    }
    return name;
}
function _getEvtNamespace(eventName, evtNamespace) {
    var _a;
    if (evtNamespace) {
        var theNamespace_1 = _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY;
        if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.isArray)(evtNamespace)) {
            theNamespace_1 = _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY;
            (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(evtNamespace, function (name) {
                name = _normalizeNamespace(name);
                if (name) {
                    if (name[0] !== ".") {
                        name = "." + name;
                    }
                    theNamespace_1 += name;
                }
            });
        }
        else {
            theNamespace_1 = _normalizeNamespace(evtNamespace);
        }
        if (theNamespace_1) {
            if (theNamespace_1[0] !== ".") {
                theNamespace_1 = "." + theNamespace_1;
            }
            // We may only have the namespace and not an eventName
            eventName = (eventName || _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY) + theNamespace_1;
        }
    }
    var parsedEvent = (eventNamespace.exec(eventName || _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY) || []);
    return _a = {},
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:type */] = parsedEvent[1],
        _a.ns = ((parsedEvent[2] || _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY).replace(rRemoveEmptyNs, ".").replace(rRemoveTrailingEmptyNs, _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SPLIT /* @min:%2esplit */](".").sort()).join("."),
        _a;
}
/**
 * Get all of the registered events on the target object, this is primarily used for testing cleanup but may also be used by
 * applications to remove their own events
 * @param target - The EventTarget that has registered events
 * @param eventName - [Optional] The name of the event to return the registered handlers and full name (with namespaces)
 * @param evtNamespace - [Optional] Additional namespace(s) to append to the event listeners so they can be uniquely identified and removed based on this namespace,
 * if the eventName also includes a namespace the namespace(s) are merged into a single namespace
 */
function __getRegisteredEvents(target, eventName, evtNamespace) {
    var theEvents = [];
    var eventCache = elmNodeData.get(target, strEvents, {}, false);
    var evtName = _getEvtNamespace(eventName, evtNamespace);
    (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.objForEachKey)(eventCache, function (evtType, registeredEvents) {
        (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(registeredEvents, function (value) {
            var _a;
            if (!evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */] || evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */] === value.evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */]) {
                if (!evtName.ns || evtName.ns === evtName.ns) {
                    theEvents[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PUSH /* @min:%2epush */]((_a = {},
                        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_NAME /* @min:name */] = value.evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */] + (value.evtName.ns ? "." + value.evtName.ns : _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY),
                        _a.handler = value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_HANDLER /* @min:%2ehandler */],
                        _a));
                }
            }
        });
    });
    return theEvents;
}
// Exported for internal unit testing only
function _getRegisteredEvents(target, evtName, addDefault) {
    if (addDefault === void 0) { addDefault = true; }
    var aiEvts = elmNodeData.get(target, strEvents, {}, addDefault);
    var registeredEvents = aiEvts[evtName];
    if (!registeredEvents) {
        registeredEvents = aiEvts[evtName] = [];
    }
    return registeredEvents;
}
function _doDetach(obj, evtName, handlerRef, useCapture) {
    if (obj && evtName && evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */]) {
        if (obj[strRemoveEventListener]) {
            obj[strRemoveEventListener](evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */], handlerRef, useCapture);
        }
        else if (obj[strDetachEvent]) {
            obj[strDetachEvent](strOnPrefix + evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */], handlerRef);
        }
    }
}
function _doAttach(obj, evtName, handlerRef, useCapture) {
    var result = false;
    if (obj && evtName && evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */] && handlerRef) {
        if (obj[strAddEventHelper]) {
            // all browsers except IE before version 9
            obj[strAddEventHelper](evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */], handlerRef, useCapture);
            result = true;
        }
        else if (obj[strAttachEvent]) {
            // IE before version 9
            obj[strAttachEvent](strOnPrefix + evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */], handlerRef);
            result = true;
        }
    }
    return result;
}
function _doUnregister(target, events, evtName, unRegFn) {
    var idx = events[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */];
    while (idx--) {
        var theEvent = events[idx];
        if (theEvent) {
            if (!evtName.ns || evtName.ns === theEvent.evtName.ns) {
                if (!unRegFn || unRegFn(theEvent)) {
                    _doDetach(target, theEvent.evtName, theEvent[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_HANDLER /* @min:%2ehandler */], theEvent.capture);
                    // Remove the registered event
                    events[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SPLICE /* @min:%2esplice */](idx, 1);
                }
            }
        }
    }
}
function _unregisterEvents(target, evtName, unRegFn) {
    if (evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */]) {
        _doUnregister(target, _getRegisteredEvents(target, evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */]), evtName, unRegFn);
    }
    else {
        var eventCache = elmNodeData.get(target, strEvents, {});
        (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.objForEachKey)(eventCache, function (evtType, events) {
            _doUnregister(target, events, evtName, unRegFn);
        });
        // Cleanup
        if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.objKeys)(eventCache)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] === 0) {
            elmNodeData.kill(target, strEvents);
        }
    }
}
function mergeEvtNamespace(theNamespace, namespaces) {
    var newNamespaces;
    if (namespaces) {
        if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.isArray)(namespaces)) {
            newNamespaces = [theNamespace].concat(namespaces);
        }
        else {
            newNamespaces = [theNamespace, namespaces];
        }
        // resort the namespaces so they are always in order
        newNamespaces = (_getEvtNamespace("xx", newNamespaces).ns)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SPLIT /* @min:%2esplit */](".");
    }
    else {
        newNamespaces = theNamespace;
    }
    return newNamespaces;
}
/**
 * Binds the specified function to an event, so that the function gets called whenever the event fires on the object
 * @param obj Object to add the event too.
 * @param eventName String that specifies any of the standard DHTML Events without "on" prefix, if may also include an optional (dot "." prefixed)
 * namespaces "click" "click.mynamespace" in addition to specific namespaces.
 * @param handlerRef Pointer that specifies the function to call when event fires
 * @param evtNamespace - [Optional] Additional namespace(s) to append to the event listeners so they can be uniquely identified and removed based on this namespace,
 * if the eventName also includes a namespace the namespace(s) are merged into a single namespace
 * @param useCapture [Optional] Defaults to false
 * @returns True if the function was bound successfully to the event, otherwise false
 */
function eventOn(target, eventName, handlerRef, evtNamespace, useCapture) {
    var _a;
    if (useCapture === void 0) { useCapture = false; }
    var result = false;
    if (target) {
        try {
            var evtName = _getEvtNamespace(eventName, evtNamespace);
            result = _doAttach(target, evtName, handlerRef, useCapture);
            if (result && elmNodeData.accept(target)) {
                var registeredEvent = (_a = {
                        guid: _guid++,
                        evtName: evtName
                    },
                    _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_HANDLER /* @min:handler */] = handlerRef,
                    _a.capture = useCapture,
                    _a);
                _getRegisteredEvents(target, evtName.type)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PUSH /* @min:%2epush */](registeredEvent);
            }
        }
        catch (e) {
            // Just Ignore any error so that we don't break any execution path
        }
    }
    return result;
}
/**
 * Removes an event handler for the specified event
 * @param Object to remove the event from
 * @param eventName {string} - The name of the event, with optional namespaces or just the namespaces,
 * such as "click", "click.mynamespace" or ".mynamespace"
 * @param handlerRef {any} - The callback function that needs to be removed from the given event, when using a
 * namespace (with or without a qualifying event) this may be null to remove all previously attached event handlers
 * otherwise this will only remove events with this specific handler.
 * @param evtNamespace - [Optional] Additional namespace(s) to append to the event listeners so they can be uniquely identified and removed based on this namespace,
 * if the eventName also includes a namespace the namespace(s) are merged into a single namespace
 * @param useCapture [Optional] Defaults to false
 */
function eventOff(target, eventName, handlerRef, evtNamespace, useCapture) {
    if (useCapture === void 0) { useCapture = false; }
    if (target) {
        try {
            var evtName_1 = _getEvtNamespace(eventName, evtNamespace);
            var found_1 = false;
            _unregisterEvents(target, evtName_1, function (regEvent) {
                if ((evtName_1.ns && !handlerRef) || regEvent[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_HANDLER /* @min:%2ehandler */] === handlerRef) {
                    found_1 = true;
                    return true;
                }
                return false;
            });
            if (!found_1) {
                // fallback to try and remove as requested
                _doDetach(target, evtName_1, handlerRef, useCapture);
            }
        }
        catch (e) {
            // Just Ignore any error so that we don't break any execution path
        }
    }
}
/**
 * Binds the specified function to an event, so that the function gets called whenever the event fires on the object
 * @param obj Object to add the event too.
 * @param eventNameWithoutOn String that specifies any of the standard DHTML Events without "on" prefix and optional (dot "." prefixed) namespaces "click" "click.mynamespace".
 * @param handlerRef Pointer that specifies the function to call when event fires
 * @param useCapture [Optional] Defaults to false
 * @returns True if the function was bound successfully to the event, otherwise false
 */
function attachEvent(obj, eventNameWithoutOn, handlerRef, useCapture) {
    if (useCapture === void 0) { useCapture = false; }
    return eventOn(obj, eventNameWithoutOn, handlerRef, null, useCapture);
}
/**
 * Removes an event handler for the specified event
 * @param Object to remove the event from
 * @param eventNameWithoutOn {string} - The name of the event, with optional namespaces or just the namespaces,
 * such as "click", "click.mynamespace" or ".mynamespace"
 * @param handlerRef {any} - The callback function that needs to be removed from the given event, when using a
 * namespace (with or without a qualifying event) this may be null to remove all previously attached event handlers
 * otherwise this will only remove events with this specific handler.
 * @param useCapture [Optional] Defaults to false
 */
function detachEvent(obj, eventNameWithoutOn, handlerRef, useCapture) {
    if (useCapture === void 0) { useCapture = false; }
    eventOff(obj, eventNameWithoutOn, handlerRef, null, useCapture);
}
/**
 * Trys to add an event handler for the specified event to the window, body and document
 * @param eventName {string} - The name of the event
 * @param callback {any} - The callback function that needs to be executed for the given event
 * @param evtNamespace - [Optional] Namespace(s) to append to the event listeners so they can be uniquely identified and removed based on this namespace.
 * @return {boolean} - true if the handler was successfully added
 */
function addEventHandler(eventName, callback, evtNamespace) {
    var result = false;
    var w = (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_4__.getWindow)();
    if (w) {
        result = eventOn(w, eventName, callback, evtNamespace);
        result = eventOn(w["body"], eventName, callback, evtNamespace) || result;
    }
    var doc = (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_4__.getDocument)();
    if (doc) {
        result = eventOn(doc, eventName, callback, evtNamespace) || result;
    }
    return result;
}
/**
 * Trys to remove event handler(s) for the specified event/namespace to the window, body and document
 * @param eventName {string} - The name of the event, with optional namespaces or just the namespaces,
 * such as "click", "click.mynamespace" or ".mynamespace"
 * @param callback {any} - - The callback function that needs to be removed from the given event, when using a
 * namespace (with or without a qualifying event) this may be null to remove all previously attached event handlers
 * otherwise this will only remove events with this specific handler.
 * @param evtNamespace - [Optional] Namespace(s) to append to the event listeners so they can be uniquely identified and removed based on this namespace.
 */
function removeEventHandler(eventName, callback, evtNamespace) {
    var w = (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_4__.getWindow)();
    if (w) {
        eventOff(w, eventName, callback, evtNamespace);
        eventOff(w["body"], eventName, callback, evtNamespace);
    }
    var doc = (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_4__.getDocument)();
    if (doc) {
        eventOff(doc, eventName, callback, evtNamespace);
    }
}
/**
 * Bind the listener to the array of events
 * @param events An string array of event names to bind the listener to
 * @param listener The event callback to call when the event is triggered
 * @param excludeEvents - [Optional] An array of events that should not be hooked (if possible), unless no other events can be.
 * @param evtNamespace - [Optional] Namespace(s) to append to the event listeners so they can be uniquely identified and removed based on this namespace.
 * @returns true - when at least one of the events was registered otherwise false
 */
function _addEventListeners(events, listener, excludeEvents, evtNamespace) {
    var added = false;
    if (listener && events && events[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] > 0) {
        (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(events, function (name) {
            if (name) {
                if (!excludeEvents || (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.arrIndexOf)(excludeEvents, name) === -1) {
                    added = addEventHandler(name, listener, evtNamespace) || added;
                }
            }
        });
    }
    return added;
}
/**
 * Bind the listener to the array of events
 * @param events An string array of event names to bind the listener to
 * @param listener The event callback to call when the event is triggered
 * @param excludeEvents - [Optional] An array of events that should not be hooked (if possible), unless no other events can be.
 * @param evtNamespace - [Optional] Namespace(s) to append to the event listeners so they can be uniquely identified and removed based on this namespace.
 * @returns true - when at least one of the events was registered otherwise false
 */
function addEventListeners(events, listener, excludeEvents, evtNamespace) {
    var added = false;
    if (listener && events && (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.isArray)(events)) {
        added = _addEventListeners(events, listener, excludeEvents, evtNamespace);
        if (!added && excludeEvents && excludeEvents[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] > 0) {
            // Failed to add any listeners and we excluded some, so just attempt to add the excluded events
            added = _addEventListeners(events, listener, null, evtNamespace);
        }
    }
    return added;
}
/**
 * Remove the listener from the array of events
 * @param events An string array of event names to bind the listener to
 * @param listener The event callback to call when the event is triggered
 * @param evtNamespace - [Optional] Namespace(s) to append to the event listeners so they can be uniquely identified and removed based on this namespace.
 */
function removeEventListeners(events, listener, evtNamespace) {
    if (events && (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.isArray)(events)) {
        (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(events, function (name) {
            if (name) {
                removeEventHandler(name, listener, evtNamespace);
            }
        });
    }
}
/**
 * Listen to the 'beforeunload', 'unload' and 'pagehide' events which indicates a page unload is occurring,
 * this does NOT listen to the 'visibilitychange' event as while it does indicate that the page is being hidden
 * it does not *necessarily* mean that the page is being completely unloaded, it can mean that the user is
 * just navigating to a different Tab and may come back (without unloading the page). As such you may also
 * need to listen to the 'addPageHideEventListener' and 'addPageShowEventListener' events.
 * @param listener - The event callback to call when a page unload event is triggered
 * @param excludeEvents - [Optional] An array of events that should not be hooked, unless no other events can be.
 * @param evtNamespace - [Optional] Namespace(s) to append to the event listeners so they can be uniquely identified and removed based on this namespace.
 * @returns true - when at least one of the events was registered otherwise false
 */
function addPageUnloadEventListener(listener, excludeEvents, evtNamespace) {
    // Hook the unload event for the document, window and body to ensure that the client events are flushed to the server
    // As just hooking the window does not always fire (on chrome) for page navigation's.
    return addEventListeners([strBeforeUnload, strUnload, strPageHide], listener, excludeEvents, evtNamespace);
}
/**
 * Remove any matching 'beforeunload', 'unload' and 'pagehide' events that may have been added via addEventListener,
 * addEventListeners, addPageUnloadEventListener or addPageHideEventListener.
 * @param listener - The specific event callback to to be removed
 * @param evtNamespace - [Optional] Namespace(s) uniquely identified and removed based on this namespace.
 * @returns true - when at least one of the events was registered otherwise false
 */
function removePageUnloadEventListener(listener, evtNamespace) {
    removeEventListeners([strBeforeUnload, strUnload, strPageHide], listener, evtNamespace);
}
/**
 * Listen to the pagehide and visibility changing to 'hidden' events, because the 'visibilitychange' uses
 * an internal proxy to detect the visibility state you SHOULD use a unique namespace when if you plan to call
 * removePageShowEventListener as the remove ignores the listener argument for the 'visibilitychange' event.
 * @param listener - The event callback to call when a page hide event is triggered
 * @param excludeEvents - [Optional] An array of events that should not be hooked (if possible), unless no other events can be.
 * @param evtNamespace - [Optional] A Namespace to append to the event listeners so they can be uniquely identified and removed
 * based on this namespace. This call also adds an additional unique "pageshow" namespace to the events
 * so that only the matching "removePageHideEventListener" can remove these events.
 * Suggestion: pass as true if you are also calling addPageUnloadEventListener as that also hooks pagehide
 * @returns true - when at least one of the events was registered otherwise false
 */
function addPageHideEventListener(listener, excludeEvents, evtNamespace) {
    function _handlePageVisibility(evt) {
        var doc = (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_4__.getDocument)();
        if (listener && doc && doc.visibilityState === "hidden") {
            listener(evt);
        }
    }
    // add the unique page show namespace to any provided namespace so we can only remove the ones added by "pagehide"
    var newNamespaces = mergeEvtNamespace(strPageHideNamespace, evtNamespace);
    var pageUnloadAdded = _addEventListeners([strPageHide], listener, excludeEvents, newNamespaces);
    if (!excludeEvents || (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.arrIndexOf)(excludeEvents, strVisibilityChangeEvt) === -1) {
        pageUnloadAdded = _addEventListeners([strVisibilityChangeEvt], _handlePageVisibility, excludeEvents, newNamespaces) || pageUnloadAdded;
    }
    if (!pageUnloadAdded && excludeEvents) {
        // Failed to add any listeners and we where requested to exclude some, so just call again without excluding anything
        pageUnloadAdded = addPageHideEventListener(listener, null, evtNamespace);
    }
    return pageUnloadAdded;
}
/**
 * Removes the pageHide event listeners added by addPageHideEventListener, because the 'visibilitychange' uses
 * an internal proxy to detect the visibility state you SHOULD use a unique namespace when calling addPageHideEventListener
 * as the remove ignores the listener argument for the 'visibilitychange' event.
 * @param listener - The specific listener to remove for the 'pageshow' event only (ignored for 'visibilitychange')
 * @param evtNamespace - The unique namespace used when calling addPageShowEventListener
 */
function removePageHideEventListener(listener, evtNamespace) {
    // add the unique page show namespace to any provided namespace so we only remove the ones added by "pagehide"
    var newNamespaces = mergeEvtNamespace(strPageHideNamespace, evtNamespace);
    removeEventListeners([strPageHide], listener, newNamespaces);
    removeEventListeners([strVisibilityChangeEvt], null, newNamespaces);
}
/**
 * Listen to the pageshow and visibility changing to 'visible' events, because the 'visibilitychange' uses
 * an internal proxy to detect the visibility state you SHOULD use a unique namespace when if you plan to call
 * removePageShowEventListener as the remove ignores the listener argument for the 'visibilitychange' event.
 * @param listener - The event callback to call when a page is show event is triggered
 * @param excludeEvents - [Optional] An array of events that should not be hooked (if possible), unless no other events can be.
 * @param evtNamespace - [Optional/Recommended] A Namespace to append to the event listeners so they can be uniquely
 * identified and removed based on this namespace. This call also adds an additional unique "pageshow" namespace to the events
 * so that only the matching "removePageShowEventListener" can remove these events.
 * @returns true - when at least one of the events was registered otherwise false
 */
function addPageShowEventListener(listener, excludeEvents, evtNamespace) {
    function _handlePageVisibility(evt) {
        var doc = (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_4__.getDocument)();
        if (listener && doc && doc.visibilityState === "visible") {
            listener(evt);
        }
    }
    // add the unique page show namespace to any provided namespace so we can only remove the ones added by "pageshow"
    var newNamespaces = mergeEvtNamespace(strPageShowNamespace, evtNamespace);
    var pageShowAdded = _addEventListeners([strPageShow], listener, excludeEvents, newNamespaces);
    pageShowAdded = _addEventListeners([strVisibilityChangeEvt], _handlePageVisibility, excludeEvents, newNamespaces) || pageShowAdded;
    if (!pageShowAdded && excludeEvents) {
        // Failed to add any listeners and we where requested to exclude some, so just call again without excluding anything
        pageShowAdded = addPageShowEventListener(listener, null, evtNamespace);
    }
    return pageShowAdded;
}
/**
 * Removes the pageShow event listeners added by addPageShowEventListener, because the 'visibilitychange' uses
 * an internal proxy to detect the visibility state you SHOULD use a unique namespace when calling addPageShowEventListener
 * as the remove ignores the listener argument for the 'visibilitychange' event.
 * @param listener - The specific listener to remove for the 'pageshow' event only (ignored for 'visibilitychange')
 * @param evtNamespace - The unique namespace used when calling addPageShowEventListener
 */
function removePageShowEventListener(listener, evtNamespace) {
    // add the unique page show namespace to any provided namespace so we only remove the ones added by "pageshow"
    var newNamespaces = mergeEvtNamespace(strPageShowNamespace, evtNamespace);
    removeEventListeners([strPageShow], listener, newNamespaces);
    removeEventListeners([strVisibilityChangeEvt], null, newNamespaces);
}
//# sourceMappingURL=EventHelpers.js.map

/***/ }),
/* 38 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "createElmNodeData": () => (/* binding */ createElmNodeData),
/* harmony export */   "createUniqueNamespace": () => (/* binding */ createUniqueNamespace)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(20);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(18);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(21);
/* harmony import */ var _RandomHelper__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(36);
/*
 * Application Insights JavaScript SDK - Core, 2.8.15
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */







var _objDefineProperty = _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.ObjDefineProperty;
var version = '2.8.15';
var instanceName = "." + (0,_RandomHelper__WEBPACK_IMPORTED_MODULE_1__.newId)(6);
var _dataUid = 0;
function _createAccessor(target, prop, value) {
    if (_objDefineProperty) {
        try {
            _objDefineProperty(target, prop, {
                value: value,
                enumerable: false,
                configurable: true
            });
            return true;
        }
        catch (e) {
            // IE8 Defines a defineProperty on Object but it's only supported for DOM elements so it will throw
            // We will just ignore this here.
        }
    }
    return false;
}
// Accepts only:
//  - Node
//    - Node.ELEMENT_NODE
//    - Node.DOCUMENT_NODE
//  - Object
//    - Any
function _canAcceptData(target) {
    return target[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_NODE_TYPE /* @min:%2enodeType */] === 1 || target[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_NODE_TYPE /* @min:%2enodeType */] === 9 || !(+target[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_NODE_TYPE /* @min:%2enodeType */]);
}
function _getCache(data, target) {
    var theCache = target[data.id];
    if (!theCache) {
        theCache = {};
        try {
            if (_canAcceptData(target)) {
                if (!_createAccessor(target, data.id, theCache)) {
                    // Environment doesn't support accessor, so just use direct assignment
                    target[data.id] = theCache;
                }
            }
        }
        catch (e) {
            // Not all environments allow extending all objects, so just ignore the cache in those cases
        }
    }
    return theCache;
}
function createUniqueNamespace(name, includeVersion) {
    if (includeVersion === void 0) { includeVersion = false; }
    return (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.normalizeJsName)(name + (_dataUid++) + (includeVersion ? "." + version : _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EMPTY) + instanceName);
}
function createElmNodeData(name) {
    var data = {
        id: createUniqueNamespace("_aiData-" + (name || _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EMPTY) + "." + version),
        accept: function (target) {
            return _canAcceptData(target);
        },
        get: function (target, name, defValue, addDefault) {
            var theCache = target[data.id];
            if (!theCache) {
                if (addDefault) {
                    // Side effect is adds the cache
                    theCache = _getCache(data, target);
                    theCache[(0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.normalizeJsName)(name)] = defValue;
                }
                return defValue;
            }
            return theCache[(0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.normalizeJsName)(name)];
        },
        kill: function (target, name) {
            if (target && target[name]) {
                try {
                    delete target[name];
                }
                catch (e) {
                    // Just cleaning up, so if this fails -- ignore
                }
            }
        }
    };
    return data;
}
//# sourceMappingURL=DataCacheHelper.js.map

/***/ }),
/* 39 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AppInsightsCore": () => (/* binding */ AppInsightsCore)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23);
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(29);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(20);
/* harmony import */ var _BaseCore__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(41);
/* harmony import */ var _DiagnosticLogger__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(27);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(18);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(21);
/* harmony import */ var _NotificationManager__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(40);
/* harmony import */ var _PerfManager__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(31);
/*
 * Application Insights JavaScript SDK - Core, 2.8.15
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */











var AppInsightsCore = /** @class */ (function (_super) {
    (0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.__extendsFn)(AppInsightsCore, _super);
    function AppInsightsCore() {
        var _this = _super.call(this) || this;
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_1__["default"])(AppInsightsCore, _this, function (_self, _base) {
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_INITIALIZE /* @min:%2einitialize */] = function (config, extensions, logger, notificationManager) {
                _base[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_INITIALIZE /* @min:%2einitialize */](config, extensions, logger || new _DiagnosticLogger__WEBPACK_IMPORTED_MODULE_3__.DiagnosticLogger(config), notificationManager || new _NotificationManager__WEBPACK_IMPORTED_MODULE_4__.NotificationManager(config));
            };
            _self.track = function (telemetryItem) {
                (0,_PerfManager__WEBPACK_IMPORTED_MODULE_5__.doPerf)(_self[_InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_GET_PERF_MGR /* @min:%2egetPerfMgr */](), function () { return "AppInsightsCore:track"; }, function () {
                    if (telemetryItem === null) {
                        _notifyInvalidEvent(telemetryItem);
                        // throw error
                        (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_7__.throwError)("Invalid telemetry item");
                    }
                    // do basic validation before sending it through the pipeline
                    _validateTelemetryItem(telemetryItem);
                    _base.track(telemetryItem);
                }, function () { return ({ item: telemetryItem }); }, !(telemetryItem.sync));
            };
            function _validateTelemetryItem(telemetryItem) {
                if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_7__.isNullOrUndefined)(telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_NAME /* @min:%2ename */])) {
                    _notifyInvalidEvent(telemetryItem);
                    (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_7__.throwError)("telemetry name required");
                }
            }
            function _notifyInvalidEvent(telemetryItem) {
                var manager = _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_GET_NOTIFY_MGR /* @min:%2egetNotifyMgr */]();
                if (manager) {
                    manager[_InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_EVENTS_DISCARDED /* @min:%2eeventsDiscarded */]([telemetryItem], 2 /* eEventsDiscardedReason.InvalidEvent */);
                }
            }
        });
        return _this;
    }
// Removed Stub for AppInsightsCore.prototype.initialize.
// Removed Stub for AppInsightsCore.prototype.track.
    // This is a workaround for an IE8 bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    // this will be removed when ES3 support is dropped.
    AppInsightsCore.__ieDyn=1;

    return AppInsightsCore;
}(_BaseCore__WEBPACK_IMPORTED_MODULE_8__.BaseCore));

//# sourceMappingURL=AppInsightsCore.js.map

/***/ }),
/* 40 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "NotificationManager": () => (/* binding */ NotificationManager)
/* harmony export */ });
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(29);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(20);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(18);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(21);
/*
 * Application Insights JavaScript SDK - Core, 2.8.15
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */






function _runListeners(listeners, name, isAsync, callback) {
    (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_0__.arrForEach)(listeners, function (listener) {
        if (listener && listener[name]) {
            if (isAsync) {
                setTimeout(function () { return callback(listener); }, 0);
            }
            else {
                try {
                    callback(listener);
                }
                catch (e) {
                    // Catch errors to ensure we don't block sending the requests
                }
            }
        }
    });
}
/**
 * Class to manage sending notifications to all the listeners.
 */
var NotificationManager = /** @class */ (function () {
    function NotificationManager(config) {
        this.listeners = [];
        var perfEvtsSendAll = !!(config || {}).perfEvtsSendAll;
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_1__["default"])(NotificationManager, this, function (_self) {
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_ADD_NOTIFICATION_LIS1 /* @min:%2eaddNotificationListener */] = function (listener) {
                _self.listeners[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PUSH /* @min:%2epush */](listener);
            };
            /**
             * Removes all instances of the listener.
             * @param {INotificationListener} listener - AWTNotificationListener to remove.
             */
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_REMOVE_NOTIFICATION_2 /* @min:%2eremoveNotificationListener */] = function (listener) {
                var index = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_0__.arrIndexOf)(_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LISTENERS /* @min:%2elisteners */], listener);
                while (index > -1) {
                    _self.listeners[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_SPLICE /* @min:%2esplice */](index, 1);
                    index = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_0__.arrIndexOf)(_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LISTENERS /* @min:%2elisteners */], listener);
                }
            };
            /**
             * Notification for events sent.
             * @param {ITelemetryItem[]} events - The array of events that have been sent.
             */
            _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_EVENTS_SENT /* @min:%2eeventsSent */] = function (events) {
                _runListeners(_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LISTENERS /* @min:%2elisteners */], _InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_EVENTS_SENT, true, function (listener) {
                    listener[_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_EVENTS_SENT /* @min:%2eeventsSent */](events);
                });
            };
            /**
             * Notification for events being discarded.
             * @param {ITelemetryItem[]} events - The array of events that have been discarded by the SDK.
             * @param {number} reason           - The reason for which the SDK discarded the events. The EventsDiscardedReason
             * constant should be used to check the different values.
             */
            _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_EVENTS_DISCARDED /* @min:%2eeventsDiscarded */] = function (events, reason) {
                _runListeners(_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LISTENERS /* @min:%2elisteners */], _InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_EVENTS_DISCARDED, true, function (listener) {
                    listener[_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_EVENTS_DISCARDED /* @min:%2eeventsDiscarded */](events, reason);
                });
            };
            /**
             * [Optional] A function called when the events have been requested to be sent to the sever.
             * @param {number} sendReason - The reason why the event batch is being sent.
             * @param {boolean} isAsync   - A flag which identifies whether the requests are being sent in an async or sync manner.
             */
            _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_EVENTS_SEND_REQUEST /* @min:%2eeventsSendRequest */] = function (sendReason, isAsync) {
                _runListeners(_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LISTENERS /* @min:%2elisteners */], _InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_EVENTS_SEND_REQUEST, isAsync, function (listener) {
                    listener[_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_EVENTS_SEND_REQUEST /* @min:%2eeventsSendRequest */](sendReason, isAsync);
                });
            };
            _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_PERF_EVENT /* @min:%2eperfEvent */] = function (perfEvent) {
                if (perfEvent) {
                    // Send all events or only parent events
                    if (perfEvtsSendAll || !perfEvent[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_IS_CHILD_EVT /* @min:%2eisChildEvt */]()) {
                        _runListeners(_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LISTENERS /* @min:%2elisteners */], _InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_PERF_EVENT, false, function (listener) {
                            if (perfEvent[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_IS_ASYNC /* @min:%2eisAsync */]) {
                                setTimeout(function () { return listener[_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_PERF_EVENT /* @min:%2eperfEvent */](perfEvent); }, 0);
                            }
                            else {
                                listener[_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_PERF_EVENT /* @min:%2eperfEvent */](perfEvent);
                            }
                        });
                    }
                }
            };
        });
    }
// Removed Stub for NotificationManager.prototype.addNotificationListener.
// Removed Stub for NotificationManager.prototype.removeNotificationListener.
// Removed Stub for NotificationManager.prototype.eventsSent.
// Removed Stub for NotificationManager.prototype.eventsDiscarded.
// Removed Stub for NotificationManager.prototype.eventsSendRequest.
    // This is a workaround for an IE8 bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    // this will be removed when ES3 support is dropped.
    NotificationManager.__ieDyn=1;

    return NotificationManager;
}());

//# sourceMappingURL=NotificationManager.js.map

/***/ }),
/* 41 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BaseCore": () => (/* binding */ BaseCore)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(23);
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(29);
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(22);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(20);
/* harmony import */ var _ChannelController__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(48);
/* harmony import */ var _CookieMgr__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(34);
/* harmony import */ var _DataCacheHelper__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(38);
/* harmony import */ var _DbgExtensionUtils__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(30);
/* harmony import */ var _DiagnosticLogger__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(27);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(18);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(21);
/* harmony import */ var _PerfManager__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(31);
/* harmony import */ var _ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(42);
/* harmony import */ var _TelemetryHelpers__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(43);
/* harmony import */ var _TelemetryInitializerPlugin__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(45);
/* harmony import */ var _UnloadHandlerContainer__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(47);
/*
 * Application Insights JavaScript SDK - Core, 2.8.15
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */



















var strValidationError = "Plugins must provide initialize method";
var strNotificationManager = "_notificationManager";
var strSdkUnloadingError = "SDK is still unloading...";
var strSdkNotInitialized = "SDK is not initialized";
// const strPluginUnloadFailed = "Failed to unload plugin";
var defaultInitConfig = {
    // Have the Diagnostic Logger default to log critical errors to the console
    loggingLevelConsole: 1 /* eLoggingSeverity.CRITICAL */
};
/**
 * Helper to create the default performance manager
 * @param core
 * @param notificationMgr
 */
function _createPerfManager(core, notificationMgr) {
    return new _PerfManager__WEBPACK_IMPORTED_MODULE_0__.PerfManager(notificationMgr);
}
function _validateExtensions(logger, channelPriority, allExtensions) {
    var _a;
    // Concat all available extensions
    var coreExtensions = [];
    // Check if any two extensions have the same priority, then warn to console
    // And extract the local extensions from the
    var extPriorities = {};
    // Extension validation
    (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.arrForEach)(allExtensions, function (ext) {
        // Check for ext.initialize
        if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.isNullOrUndefined)(ext) || (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.isNullOrUndefined)(ext[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_INITIALIZE /* @min:%2einitialize */])) {
            (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.throwError)(strValidationError);
        }
        var extPriority = ext[_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_PRIORITY /* @min:%2epriority */];
        var identifier = ext[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_IDENTIFIER /* @min:%2eidentifier */];
        if (ext && extPriority) {
            if (!(0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.isNullOrUndefined)(extPriorities[extPriority])) {
                (0,_DiagnosticLogger__WEBPACK_IMPORTED_MODULE_4__._warnToConsole)(logger, "Two extensions have same priority #" + extPriority + " - " + extPriorities[extPriority] + ", " + identifier);
            }
            else {
                // set a value
                extPriorities[extPriority] = identifier;
            }
        }
        // Split extensions to core and channelController
        if (!extPriority || extPriority < channelPriority) {
            // Add to core extension that will be managed by BaseCore
            coreExtensions[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PUSH /* @min:%2epush */](ext);
        }
    });
    return _a = {
            all: allExtensions
        },
        _a[_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_CORE /* @min:core */] = coreExtensions,
        _a;
}
function _isPluginPresent(thePlugin, plugins) {
    var exists = false;
    (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.arrForEach)(plugins, function (plugin) {
        if (plugin === thePlugin) {
            exists = true;
            return -1;
        }
    });
    return exists;
}
function _createDummyNotificationManager() {
    var _a;
    return (0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_5__.objCreateFn)((_a = {},
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_ADD_NOTIFICATION_LIS1 /* @min:addNotificationListener */] = function (listener) { },
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_REMOVE_NOTIFICATION_2 /* @min:removeNotificationListener */] = function (listener) { },
        _a[_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_EVENTS_SENT /* @min:eventsSent */] = function (events) { },
        _a[_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_EVENTS_DISCARDED /* @min:eventsDiscarded */] = function (events, reason) { },
        _a[_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_EVENTS_SEND_REQUEST /* @min:eventsSendRequest */] = function (sendReason, isAsync) { },
        _a));
}
var BaseCore = /** @class */ (function () {
    function BaseCore() {
        // NOTE!: DON'T set default values here, instead set them in the _initDefaults() function as it is also called during teardown()
        var _config;
        var _isInitialized;
        var _eventQueue;
        var _notificationManager;
        var _perfManager;
        var _cfgPerfManager;
        var _cookieManager;
        var _pluginChain;
        var _configExtensions;
        var _coreExtensions;
        var _channelControl;
        var _channelConfig;
        var _channelQueue;
        var _isUnloading;
        var _telemetryInitializerPlugin;
        var _internalLogsEventName;
        var _evtNamespace;
        var _unloadHandlers;
        var _debugListener;
        var _traceCtx;
        /**
         * Internal log poller
         */
        var _internalLogPoller = 0;
        var _forceStopInternalLogPoller = false;
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_6__["default"])(BaseCore, this, function (_self) {
            // Set the default values (also called during teardown)
            _initDefaults();
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_IS_INITIALIZED /* @min:%2eisInitialized */] = function () { return _isInitialized; };
            // Creating the self.initialize = ()
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_INITIALIZE /* @min:%2einitialize */] = function (config, extensions, logger, notificationManager) {
                if (_isUnloading) {
                    (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.throwError)(strSdkUnloadingError);
                }
                // Make sure core is only initialized once
                if (_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_IS_INITIALIZED /* @min:%2eisInitialized */]()) {
                    (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.throwError)("Core should not be initialized more than once");
                }
                _config = config || {};
                _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_CONFIG /* @min:%2econfig */] = _config;
                if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.isNullOrUndefined)(config[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_INSTRUMENTATION_KEY /* @min:%2einstrumentationKey */])) {
                    (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.throwError)("Please provide instrumentation key");
                }
                _notificationManager = notificationManager;
                // For backward compatibility only
                _self[strNotificationManager] = notificationManager;
                _initDebugListener();
                _initPerfManager();
                // add notification to the extensions in the config so other plugins can access it
                _initExtConfig();
                if (logger) {
                    _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LOGGER /* @min:%2elogger */] = logger;
                }
                var cfgExtensions = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.getSetValue)(_config, _InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_EXTENSIONS, []);
                // Extension validation
                _configExtensions = [];
                _configExtensions[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PUSH /* @min:%2epush */].apply(_configExtensions, (0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_7__.__spreadArrayFn)((0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_7__.__spreadArrayFn)([], extensions, false), cfgExtensions, false));
                _channelConfig = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.getSetValue)(_config, _InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_CHANNELS, []);
                _initPluginChain(null);
                if (!_channelQueue || _channelQueue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */] === 0) {
                    (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.throwError)("No " + _InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_CHANNELS + " available");
                }
                _isInitialized = true;
                _self.releaseQueue();
            };
            _self.getTransmissionControls = function () {
                var controls = [];
                if (_channelQueue) {
                    (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.arrForEach)(_channelQueue, function (channels) {
                        controls[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PUSH /* @min:%2epush */](channels.queue);
                    });
                }
                return (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.objFreeze)(controls);
            };
            _self.track = function (telemetryItem) {
                // setup default iKey if not passed in
                telemetryItem.iKey = telemetryItem.iKey || _config[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_INSTRUMENTATION_KEY /* @min:%2einstrumentationKey */];
                // add default timestamp if not passed in
                telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_TIME /* @min:%2etime */] = telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_TIME /* @min:%2etime */] || (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.toISOString)(new Date());
                // Common Schema 4.0
                telemetryItem.ver = telemetryItem.ver || "4.0";
                if (!_isUnloading && _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_IS_INITIALIZED /* @min:%2eisInitialized */]()) {
                    // Process the telemetry plugin chain
                    _createTelCtx()[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](telemetryItem);
                }
                else {
                    // Queue events until all extensions are initialized
                    _eventQueue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PUSH /* @min:%2epush */](telemetryItem);
                }
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_GET_PROCESS_TEL_CONT0 /* @min:%2egetProcessTelContext */] = _createTelCtx;
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_GET_NOTIFY_MGR /* @min:%2egetNotifyMgr */] = function () {
                if (!_notificationManager) {
                    // Create Dummy notification manager
                    _notificationManager = _createDummyNotificationManager();
                    // For backward compatibility only
                    _self[strNotificationManager] = _notificationManager;
                }
                return _notificationManager;
            };
            /**
             * Adds a notification listener. The SDK calls methods on the listener when an appropriate notification is raised.
             * The added plugins must raise notifications. If the plugins do not implement the notifications, then no methods will be
             * called.
             * @param {INotificationListener} listener - An INotificationListener object.
             */
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_ADD_NOTIFICATION_LIS1 /* @min:%2eaddNotificationListener */] = function (listener) {
                if (_notificationManager) {
                    _notificationManager[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_ADD_NOTIFICATION_LIS1 /* @min:%2eaddNotificationListener */](listener);
                }
            };
            /**
             * Removes all instances of the listener.
             * @param {INotificationListener} listener - INotificationListener to remove.
             */
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_REMOVE_NOTIFICATION_2 /* @min:%2eremoveNotificationListener */] = function (listener) {
                if (_notificationManager) {
                    _notificationManager[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_REMOVE_NOTIFICATION_2 /* @min:%2eremoveNotificationListener */](listener);
                }
            };
            _self.getCookieMgr = function () {
                if (!_cookieManager) {
                    _cookieManager = (0,_CookieMgr__WEBPACK_IMPORTED_MODULE_8__.createCookieMgr)(_config, _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LOGGER /* @min:%2elogger */]);
                }
                return _cookieManager;
            };
            _self.setCookieMgr = function (cookieMgr) {
                _cookieManager = cookieMgr;
            };
            _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_GET_PERF_MGR /* @min:%2egetPerfMgr */] = function () {
                if (!_perfManager && !_cfgPerfManager) {
                    if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.getCfgValue)(_config.enablePerfMgr)) {
                        var createPerfMgr = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.getCfgValue)(_config[_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_CREATE_PERF_MGR /* @min:%2ecreatePerfMgr */]);
                        if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.isFunction)(createPerfMgr)) {
                            _cfgPerfManager = createPerfMgr(_self, _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_GET_NOTIFY_MGR /* @min:%2egetNotifyMgr */]());
                        }
                    }
                }
                return _perfManager || _cfgPerfManager || (0,_PerfManager__WEBPACK_IMPORTED_MODULE_0__.getGblPerfMgr)();
            };
            _self.setPerfMgr = function (perfMgr) {
                _perfManager = perfMgr;
            };
            _self.eventCnt = function () {
                return _eventQueue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */];
            };
            _self.releaseQueue = function () {
                if (_isInitialized && _eventQueue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    var eventQueue = _eventQueue;
                    _eventQueue = [];
                    (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.arrForEach)(eventQueue, function (event) {
                        _createTelCtx()[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](event);
                    });
                }
            };
            _self.pollInternalLogs = function (eventName) {
                _internalLogsEventName = eventName || null;
                _forceStopInternalLogPoller = false;
                if (_internalLogPoller) {
                    clearInterval(_internalLogPoller);
                    _internalLogPoller = null;
                }
                return _startInternalLogTimer(true);
            };
            function _startInternalLogTimer(alwaysStart) {
                if (!_internalLogPoller && !_forceStopInternalLogPoller) {
                    var shouldStart = alwaysStart || (_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LOGGER /* @min:%2elogger */] && _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LOGGER /* @min:%2elogger */].queue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */] > 0);
                    if (shouldStart) {
                        var interval = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.getCfgValue)(_config.diagnosticLogInterval);
                        if (!interval || !(interval > 0)) {
                            interval = 10000;
                        }
                        // Keeping as an interval timer for backward compatibility as it returns the result
                        _internalLogPoller = setInterval(function () {
                            clearInterval(_internalLogPoller);
                            _internalLogPoller = 0;
                            _flushInternalLogs();
                        }, interval);
                    }
                }
                return _internalLogPoller;
            }
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_STOP_POLLING_INTERNA3 /* @min:%2estopPollingInternalLogs */] = function () {
                _forceStopInternalLogPoller = true;
                if (_internalLogPoller) {
                    clearInterval(_internalLogPoller);
                    _internalLogPoller = 0;
                    _flushInternalLogs();
                }
            };
            // Add addTelemetryInitializer
            (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.proxyFunctions)(_self, function () { return _telemetryInitializerPlugin; }, ["addTelemetryInitializer"]);
            _self.unload = function (isAsync, unloadComplete, cbTimeout) {
                var _a;
                if (isAsync === void 0) { isAsync = true; }
                if (!_isInitialized) {
                    // The SDK is not initialized
                    (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.throwError)(strSdkNotInitialized);
                }
                // Check if the SDK still unloading so throw
                if (_isUnloading) {
                    // The SDK is already unloading
                    (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.throwError)(strSdkUnloadingError);
                }
                var unloadState = (_a = {
                        reason: 50 /* TelemetryUnloadReason.SdkUnload */
                    },
                    _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_IS_ASYNC /* @min:isAsync */] = isAsync,
                    _a.flushComplete = false,
                    _a);
                var processUnloadCtx = (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_9__.createProcessTelemetryUnloadContext)(_getPluginChain(), _self);
                processUnloadCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_ON_COMPLETE /* @min:%2eonComplete */](function () {
                    _initDefaults();
                    unloadComplete && unloadComplete(unloadState);
                }, _self);
                function _doUnload(flushComplete) {
                    unloadState.flushComplete = flushComplete;
                    _isUnloading = true;
                    // Run all of the unload handlers first (before unloading the plugins)
                    _unloadHandlers.run(processUnloadCtx, unloadState);
                    // Stop polling the internal logs
                    _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_STOP_POLLING_INTERNA3 /* @min:%2estopPollingInternalLogs */]();
                    // Start unloading the components, from this point onwards the SDK should be considered to be in an unstable state
                    processUnloadCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](unloadState);
                }
                _flushInternalLogs();
                if (!_flushChannels(isAsync, _doUnload, 6 /* SendRequestReason.SdkUnload */, cbTimeout)) {
                    _doUnload(false);
                }
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_GET_PLUGIN /* @min:%2egetPlugin */] = _getPlugin;
            _self.addPlugin = function (plugin, replaceExisting, isAsync, addCb) {
                if (!plugin) {
                    addCb && addCb(false);
                    _logOrThrowError(strValidationError);
                    return;
                }
                var existingPlugin = _getPlugin(plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_IDENTIFIER /* @min:%2eidentifier */]);
                if (existingPlugin && !replaceExisting) {
                    addCb && addCb(false);
                    _logOrThrowError("Plugin [" + plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_IDENTIFIER /* @min:%2eidentifier */] + "] is already loaded!");
                    return;
                }
                var updateState = {
                    reason: 16 /* TelemetryUpdateReason.PluginAdded */
                };
                function _addPlugin(removed) {
                    _configExtensions[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PUSH /* @min:%2epush */](plugin);
                    updateState.added = [plugin];
                    // Re-Initialize the plugin chain
                    _initPluginChain(updateState);
                    addCb && addCb(true);
                }
                if (existingPlugin) {
                    var removedPlugins_1 = [existingPlugin.plugin];
                    var unloadState = {
                        reason: 2 /* TelemetryUnloadReason.PluginReplace */,
                        isAsync: !!isAsync
                    };
                    _removePlugins(removedPlugins_1, unloadState, function (removed) {
                        if (!removed) {
                            // Previous plugin was successfully removed or was not installed
                            addCb && addCb(false);
                        }
                        else {
                            updateState.removed = removedPlugins_1;
                            updateState.reason |= 32 /* TelemetryUpdateReason.PluginRemoved */;
                            _addPlugin(true);
                        }
                    });
                }
                else {
                    _addPlugin(false);
                }
            };
            _self.evtNamespace = function () {
                return _evtNamespace;
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_FLUSH /* @min:%2eflush */] = _flushChannels;
            _self.getTraceCtx = function (createNew) {
                if (!_traceCtx) {
                    _traceCtx = (0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_10__.createDistributedTraceContext)();
                }
                return _traceCtx;
            };
            _self.setTraceCtx = function (traceCtx) {
                _traceCtx = traceCtx || null;
            };
            // Create the addUnloadCb
            (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.proxyFunctionAs)(_self, "addUnloadCb", function () { return _unloadHandlers; }, "add");
            function _initDefaults() {
                _isInitialized = false;
                // Use a default logger so initialization errors are not dropped on the floor with full logging
                _config = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.objExtend)(true, {}, defaultInitConfig);
                _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_CONFIG /* @min:%2econfig */] = _config;
                _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LOGGER /* @min:%2elogger */] = new _DiagnosticLogger__WEBPACK_IMPORTED_MODULE_4__.DiagnosticLogger(_config);
                _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN__EXTENSIONS /* @min:%2e_extensions */] = [];
                _telemetryInitializerPlugin = new _TelemetryInitializerPlugin__WEBPACK_IMPORTED_MODULE_11__.TelemetryInitializerPlugin();
                _eventQueue = [];
                _notificationManager = null;
                _perfManager = null;
                _cfgPerfManager = null;
                _cookieManager = null;
                _pluginChain = null;
                _coreExtensions = null;
                _configExtensions = [];
                _channelControl = null;
                _channelConfig = null;
                _channelQueue = null;
                _isUnloading = false;
                _internalLogsEventName = null;
                _evtNamespace = (0,_DataCacheHelper__WEBPACK_IMPORTED_MODULE_12__.createUniqueNamespace)("AIBaseCore", true);
                _unloadHandlers = (0,_UnloadHandlerContainer__WEBPACK_IMPORTED_MODULE_13__.createUnloadHandlerContainer)();
                _traceCtx = null;
            }
            function _createTelCtx() {
                var theCtx = (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_9__.createProcessTelemetryContext)(_getPluginChain(), _config, _self);
                theCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_ON_COMPLETE /* @min:%2eonComplete */](_startInternalLogTimer);
                return theCtx;
            }
            // Initialize or Re-initialize the plugins
            function _initPluginChain(updateState) {
                // Extension validation
                var theExtensions = _validateExtensions(_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LOGGER /* @min:%2elogger */], _ChannelController__WEBPACK_IMPORTED_MODULE_14__.ChannelControllerPriority, _configExtensions);
                _coreExtensions = theExtensions[_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_CORE /* @min:%2ecore */];
                _pluginChain = null;
                // Sort the complete set of extensions by priority
                var allExtensions = theExtensions.all;
                // Initialize the Channel Queues and the channel plugins first
                _channelQueue = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.objFreeze)((0,_ChannelController__WEBPACK_IMPORTED_MODULE_14__.createChannelQueues)(_channelConfig, allExtensions, _self));
                if (_channelControl) {
                    // During add / remove of a plugin this may get called again, so don't re-add if already present
                    // But we also want the controller as the last, so remove if already present
                    // And reusing the existing instance, just in case an installed plugin has a reference and
                    // is using it.
                    var idx = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.arrIndexOf)(allExtensions, _channelControl);
                    if (idx !== -1) {
                        allExtensions[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_SPLICE /* @min:%2esplice */](idx, 1);
                    }
                    idx = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.arrIndexOf)(_coreExtensions, _channelControl);
                    if (idx !== -1) {
                        _coreExtensions[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_SPLICE /* @min:%2esplice */](idx, 1);
                    }
                    _channelControl._setQueue(_channelQueue);
                }
                else {
                    _channelControl = (0,_ChannelController__WEBPACK_IMPORTED_MODULE_14__.createChannelControllerPlugin)(_channelQueue, _self);
                }
                // Add on "channelController" as the last "plugin"
                allExtensions[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PUSH /* @min:%2epush */](_channelControl);
                _coreExtensions[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PUSH /* @min:%2epush */](_channelControl);
                // Required to allow plugins to call core.getPlugin() during their own initialization
                _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN__EXTENSIONS /* @min:%2e_extensions */] = (0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_10__.sortPlugins)(allExtensions);
                // Initialize the controls
                _channelControl[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_INITIALIZE /* @min:%2einitialize */](_config, _self, allExtensions);
                var initCtx = _createTelCtx();
                (0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_10__.initializePlugins)(initCtx, allExtensions);
                // Now reset the extensions to just those being managed by Basecore
                _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN__EXTENSIONS /* @min:%2e_extensions */] = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.objFreeze)((0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_10__.sortPlugins)(_coreExtensions || [])).slice();
                if (updateState) {
                    _doUpdate(updateState);
                }
            }
            function _getPlugin(pluginIdentifier) {
                var _a;
                var theExt = null;
                var thePlugin = null;
                (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.arrForEach)(_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN__EXTENSIONS /* @min:%2e_extensions */], function (ext) {
                    if (ext[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_IDENTIFIER /* @min:%2eidentifier */] === pluginIdentifier && ext !== _channelControl && ext !== _telemetryInitializerPlugin) {
                        thePlugin = ext;
                        return -1;
                    }
                });
                if (!thePlugin && _channelControl) {
                    // Check the channel Controller
                    thePlugin = _channelControl.getChannel(pluginIdentifier);
                }
                if (thePlugin) {
                    theExt = (_a = {
                            plugin: thePlugin
                        },
                        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_SET_ENABLED /* @min:setEnabled */] = function (enabled) {
                            (0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_10__._getPluginState)(thePlugin)[_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_DISABLED] = !enabled;
                        },
                        _a.isEnabled = function () {
                            var pluginState = (0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_10__._getPluginState)(thePlugin);
                            return !pluginState[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_TEARDOWN /* @min:%2eteardown */] && !pluginState[_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_DISABLED];
                        },
                        _a.remove = function (isAsync, removeCb) {
                            var _a;
                            if (isAsync === void 0) { isAsync = true; }
                            var pluginsToRemove = [thePlugin];
                            var unloadState = (_a = {
                                    reason: 1 /* TelemetryUnloadReason.PluginUnload */
                                },
                                _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_IS_ASYNC /* @min:isAsync */] = isAsync,
                                _a);
                            _removePlugins(pluginsToRemove, unloadState, function (removed) {
                                if (removed) {
                                    // Re-Initialize the plugin chain
                                    _initPluginChain({
                                        reason: 32 /* TelemetryUpdateReason.PluginRemoved */,
                                        removed: pluginsToRemove
                                    });
                                }
                                removeCb && removeCb(removed);
                            });
                        },
                        _a);
                }
                return theExt;
            }
            function _getPluginChain() {
                if (!_pluginChain) {
                    // copy the collection of extensions
                    var extensions = (_coreExtensions || []).slice();
                    // During add / remove this may get called again, so don't readd if already present
                    if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.arrIndexOf)(extensions, _telemetryInitializerPlugin) === -1) {
                        extensions[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PUSH /* @min:%2epush */](_telemetryInitializerPlugin);
                    }
                    _pluginChain = (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_9__.createTelemetryProxyChain)((0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_10__.sortPlugins)(extensions), _config, _self);
                }
                return _pluginChain;
            }
            function _removePlugins(thePlugins, unloadState, removeComplete) {
                if (thePlugins && thePlugins[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    var unloadChain = (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_9__.createTelemetryProxyChain)(thePlugins, _config, _self);
                    var unloadCtx = (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_9__.createProcessTelemetryUnloadContext)(unloadChain, _self);
                    unloadCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_ON_COMPLETE /* @min:%2eonComplete */](function () {
                        var removed = false;
                        // Remove the listed config extensions
                        var newConfigExtensions = [];
                        (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.arrForEach)(_configExtensions, function (plugin, idx) {
                            if (!_isPluginPresent(plugin, thePlugins)) {
                                newConfigExtensions[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PUSH /* @min:%2epush */](plugin);
                            }
                            else {
                                removed = true;
                            }
                        });
                        _configExtensions = newConfigExtensions;
                        // Re-Create the channel config
                        var newChannelConfig = [];
                        if (_channelConfig) {
                            (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.arrForEach)(_channelConfig, function (queue, idx) {
                                var newQueue = [];
                                (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.arrForEach)(queue, function (channel) {
                                    if (!_isPluginPresent(channel, thePlugins)) {
                                        newQueue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PUSH /* @min:%2epush */](channel);
                                    }
                                    else {
                                        removed = true;
                                    }
                                });
                                newChannelConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PUSH /* @min:%2epush */](newQueue);
                            });
                            _channelConfig = newChannelConfig;
                        }
                        removeComplete && removeComplete(removed);
                        _startInternalLogTimer();
                    });
                    unloadCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](unloadState);
                }
                else {
                    removeComplete(false);
                }
            }
            function _flushInternalLogs() {
                if (_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LOGGER /* @min:%2elogger */] && _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LOGGER /* @min:%2elogger */].queue) {
                    var queue = _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LOGGER /* @min:%2elogger */].queue.slice(0);
                    _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LOGGER /* @min:%2elogger */].queue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */] = 0;
                    (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.arrForEach)(queue, function (logMessage) {
                        var _a;
                        var item = (_a = {},
                            _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_NAME /* @min:name */] = _internalLogsEventName ? _internalLogsEventName : "InternalMessageId: " + logMessage[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_MESSAGE_ID /* @min:%2emessageId */],
                            _a.iKey = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.getCfgValue)(_config[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_INSTRUMENTATION_KEY /* @min:%2einstrumentationKey */]),
                            _a.time = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.toISOString)(new Date()),
                            _a.baseType = _DiagnosticLogger__WEBPACK_IMPORTED_MODULE_4__._InternalLogMessage.dataType,
                            _a.baseData = { message: logMessage[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_MESSAGE /* @min:%2emessage */] },
                            _a);
                        _self.track(item);
                    });
                }
            }
            function _flushChannels(isAsync, callBack, sendReason, cbTimeout) {
                if (_channelControl) {
                    return _channelControl[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_FLUSH /* @min:%2eflush */](isAsync, callBack, sendReason || 6 /* SendRequestReason.SdkUnload */, cbTimeout);
                }
                callBack && callBack(false);
                return true;
            }
            function _initDebugListener() {
                var disableDbgExt = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.getCfgValue)(_config.disableDbgExt);
                if (disableDbgExt === true && _debugListener) {
                    // Remove any previously loaded debug listener
                    _notificationManager[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_REMOVE_NOTIFICATION_2 /* @min:%2eremoveNotificationListener */](_debugListener);
                    _debugListener = null;
                }
                if (_notificationManager && !_debugListener && disableDbgExt !== true) {
                    _debugListener = (0,_DbgExtensionUtils__WEBPACK_IMPORTED_MODULE_15__.getDebugListener)(_config);
                    _notificationManager[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_ADD_NOTIFICATION_LIS1 /* @min:%2eaddNotificationListener */](_debugListener);
                }
            }
            function _initPerfManager() {
                var enablePerfMgr = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.getCfgValue)(_config.enablePerfMgr);
                if (!enablePerfMgr && _cfgPerfManager) {
                    // Remove any existing config based performance manager
                    _cfgPerfManager = null;
                }
                if (enablePerfMgr) {
                    // Set the performance manager creation function if not defined
                    (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.getSetValue)(_config, _InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_CREATE_PERF_MGR, _createPerfManager);
                }
            }
            function _initExtConfig() {
                var extConfig = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.getSetValue)(_config, _InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_EXTENSION_CONFIG, {});
                extConfig.NotificationManager = _notificationManager;
            }
            function _doUpdate(updateState) {
                var updateCtx = (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_9__.createProcessTelemetryUpdateContext)(_getPluginChain(), _self);
                updateCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_ON_COMPLETE /* @min:%2eonComplete */](_startInternalLogTimer);
                if (!_self._updateHook || _self._updateHook(updateCtx, updateState) !== true) {
                    updateCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](updateState);
                }
            }
            function _logOrThrowError(message) {
                var logger = _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LOGGER /* @min:%2elogger */];
                if (logger) {
                    // there should always be a logger
                    (0,_DiagnosticLogger__WEBPACK_IMPORTED_MODULE_4__._throwInternal)(logger, 2 /* eLoggingSeverity.WARNING */, 73 /* _eInternalMessageId.PluginException */, message);
                    _startInternalLogTimer();
                }
                else {
                    (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.throwError)(message);
                }
            }
        });
    }
// Removed Stub for BaseCore.prototype.initialize.
// Removed Stub for BaseCore.prototype.getTransmissionControls.
// Removed Stub for BaseCore.prototype.track.
// Removed Stub for BaseCore.prototype.getProcessTelContext.
// Removed Stub for BaseCore.prototype.getNotifyMgr.
// Removed Stub for BaseCore.prototype.addNotificationListener.
// Removed Stub for BaseCore.prototype.removeNotificationListener.
// Removed Stub for BaseCore.prototype.getCookieMgr.
// Removed Stub for BaseCore.prototype.setCookieMgr.
// Removed Stub for BaseCore.prototype.getPerfMgr.
// Removed Stub for BaseCore.prototype.setPerfMgr.
// Removed Stub for BaseCore.prototype.eventCnt.
// Removed Stub for BaseCore.prototype.pollInternalLogs.
// Removed Stub for BaseCore.prototype.stopPollingInternalLogs.
// Removed Stub for BaseCore.prototype.addTelemetryInitializer.
// Removed Stub for BaseCore.prototype.unload.
// Removed Stub for BaseCore.prototype.getPlugin.
// Removed Stub for BaseCore.prototype.addPlugin.
// Removed Stub for BaseCore.prototype.evtNamespace.
// Removed Stub for BaseCore.prototype.addUnloadCb.
// Removed Stub for BaseCore.prototype.flush.
// Removed Stub for BaseCore.prototype.getTraceCtx.
// Removed Stub for BaseCore.prototype.setTraceCtx.
// Removed Stub for BaseCore.prototype.releaseQueue.
// Removed Stub for BaseCore.prototype._updateHook.
    // This is a workaround for an IE8 bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    // this will be removed when ES3 support is dropped.
    BaseCore.__ieDyn=1;

    return BaseCore;
}());

//# sourceMappingURL=BaseCore.js.map

/***/ }),
/* 42 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ProcessTelemetryContext": () => (/* binding */ ProcessTelemetryContext),
/* harmony export */   "createProcessTelemetryContext": () => (/* binding */ createProcessTelemetryContext),
/* harmony export */   "createProcessTelemetryUnloadContext": () => (/* binding */ createProcessTelemetryUnloadContext),
/* harmony export */   "createProcessTelemetryUpdateContext": () => (/* binding */ createProcessTelemetryUpdateContext),
/* harmony export */   "createTelemetryPluginProxy": () => (/* binding */ createTelemetryPluginProxy),
/* harmony export */   "createTelemetryProxyChain": () => (/* binding */ createTelemetryProxyChain)
/* harmony export */ });
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20);
/* harmony import */ var _DiagnosticLogger__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(27);
/* harmony import */ var _EnvUtils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(28);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(18);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(21);
/* harmony import */ var _PerfManager__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(31);
/* harmony import */ var _TelemetryHelpers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(43);
/*
 * Application Insights JavaScript SDK - Core, 2.8.15
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */










var strTelemetryPluginChain = "TelemetryPluginChain";
var strHasRunFlags = "_hasRun";
var strGetTelCtx = "_getTelCtx";
var _chainId = 0;
function _getNextProxyStart(proxy, core, startAt) {
    while (proxy) {
        if (proxy[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_GET_PLUGIN /* @min:%2egetPlugin */]() === startAt) {
            return proxy;
        }
        proxy = proxy[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_GET_NEXT /* @min:%2egetNext */]();
    }
    // This wasn't found in the existing chain so create an isolated one with just this plugin
    return createTelemetryProxyChain([startAt], core[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_CONFIG /* @min:%2econfig */] || {}, core);
}
/**
 * @ignore
 * @param telemetryChain
 * @param config
 * @param core
 * @param startAt - Identifies the next plugin to execute, if null there is no "next" plugin and if undefined it should assume the start of the chain
 * @returns
 */
function _createInternalContext(telemetryChain, config, core, startAt) {
    // We have a special case where we want to start execution from this specific plugin
    // or we simply reuse the existing telemetry plugin chain (normal execution case)
    var _nextProxy = null; // By Default set as no next plugin
    var _onComplete = [];
    if (startAt !== null) {
        // There is no next element (null) vs not defined (undefined) so use the full chain
        _nextProxy = startAt ? _getNextProxyStart(telemetryChain, core, startAt) : telemetryChain;
    }
    var context = {
        _next: _moveNext,
        ctx: {
            core: function () {
                return core;
            },
            diagLog: function () {
                return (0,_DiagnosticLogger__WEBPACK_IMPORTED_MODULE_1__.safeGetLogger)(core, config);
            },
            getCfg: function () {
                return config;
            },
            getExtCfg: _getExtCfg,
            getConfig: _getConfig,
            hasNext: function () {
                return !!_nextProxy;
            },
            getNext: function () {
                return _nextProxy;
            },
            setNext: function (nextPlugin) {
                _nextProxy = nextPlugin;
            },
            iterate: _iterateChain,
            onComplete: _addOnComplete
        }
    };
    function _addOnComplete(onComplete, that) {
        var args = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            args[_i - 2] = arguments[_i];
        }
        if (onComplete) {
            _onComplete[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PUSH /* @min:%2epush */]({
                func: onComplete,
                self: !(0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isUndefined)(that) ? that : context.ctx,
                args: args
            });
        }
    }
    function _moveNext() {
        var nextProxy = _nextProxy;
        // Automatically move to the next plugin
        _nextProxy = nextProxy ? nextProxy[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_GET_NEXT /* @min:%2egetNext */]() : null;
        if (!nextProxy) {
            var onComplete = _onComplete;
            if (onComplete && onComplete[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] > 0) {
                (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.arrForEach)(onComplete, function (completeDetails) {
                    try {
                        completeDetails.func[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_CALL /* @min:%2ecall */](completeDetails.self, completeDetails.args);
                    }
                    catch (e) {
                        (0,_DiagnosticLogger__WEBPACK_IMPORTED_MODULE_1__._throwInternal)(core[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LOGGER /* @min:%2elogger */], 2 /* eLoggingSeverity.WARNING */, 73 /* _eInternalMessageId.PluginException */, "Unexpected Exception during onComplete - " + (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_3__.dumpObj)(e));
                    }
                });
                _onComplete = [];
            }
        }
        return nextProxy;
    }
    function _getExtCfg(identifier, defaultValue, mergeDefault) {
        if (defaultValue === void 0) { defaultValue = {}; }
        if (mergeDefault === void 0) { mergeDefault = 0 /* GetExtCfgMergeType.None */; }
        var theConfig;
        if (config) {
            var extConfig = config[_InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EXTENSION_CONFIG /* @min:%2eextensionConfig */];
            if (extConfig && identifier) {
                theConfig = extConfig[identifier];
            }
        }
        if (!theConfig) {
            // Just use the defaults
            theConfig = defaultValue;
        }
        else if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isObject)(defaultValue)) {
            if (mergeDefault !== 0 /* GetExtCfgMergeType.None */) {
                // Merge the defaults and configured values
                var newConfig_1 = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.objExtend)(true, defaultValue, theConfig);
                if (config && mergeDefault === 2 /* GetExtCfgMergeType.MergeDefaultFromRootOrDefault */) {
                    // Enumerate over the defaultValues and if not already populated attempt to
                    // find a value from the root config
                    (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.objForEachKey)(defaultValue, function (field) {
                        // for each unspecified field, set the default value
                        if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isNullOrUndefined)(newConfig_1[field])) {
                            var cfgValue = config[field];
                            if (!(0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isNullOrUndefined)(cfgValue)) {
                                newConfig_1[field] = cfgValue;
                            }
                        }
                    });
                }
                theConfig = newConfig_1;
            }
        }
        return theConfig;
    }
    function _getConfig(identifier, field, defaultValue) {
        if (defaultValue === void 0) { defaultValue = false; }
        var theValue;
        var extConfig = _getExtCfg(identifier, null);
        if (extConfig && !(0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isNullOrUndefined)(extConfig[field])) {
            theValue = extConfig[field];
        }
        else if (config && !(0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isNullOrUndefined)(config[field])) {
            theValue = config[field];
        }
        return !(0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isNullOrUndefined)(theValue) ? theValue : defaultValue;
    }
    function _iterateChain(cb) {
        // Keep processing until we reach the end of the chain
        var nextPlugin;
        while (!!(nextPlugin = context._next())) {
            var plugin = nextPlugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_GET_PLUGIN /* @min:%2egetPlugin */]();
            if (plugin) {
                // callback with the current on
                cb(plugin);
            }
        }
    }
    return context;
}
/**
 * Creates a new Telemetry Item context with the current config, core and plugin execution chain
 * @param plugins - The plugin instances that will be executed
 * @param config - The current config
 * @param core - The current core instance
 * @param startAt - Identifies the next plugin to execute, if null there is no "next" plugin and if undefined it should assume the start of the chain
 */
function createProcessTelemetryContext(telemetryChain, config, core, startAt) {
    var internalContext = _createInternalContext(telemetryChain, config, core, startAt);
    var context = internalContext.ctx;
    function _processNext(env) {
        var nextPlugin = internalContext._next();
        // Run the next plugin which will call "processNext()"
        nextPlugin && nextPlugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_PROCESS_TELEMETRY /* @min:%2eprocessTelemetry */](env, context);
        return !nextPlugin;
    }
    function _createNew(plugins, startAt) {
        if (plugins === void 0) { plugins = null; }
        if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isArray)(plugins)) {
            plugins = createTelemetryProxyChain(plugins, config, core, startAt);
        }
        return createProcessTelemetryContext(plugins || context[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_GET_NEXT /* @min:%2egetNext */](), config, core, startAt);
    }
    context[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */] = _processNext;
    context[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_CREATE_NEW /* @min:%2ecreateNew */] = _createNew;
    return context;
}
/**
 * Creates a new Telemetry Item context with the current config, core and plugin execution chain for handling the unloading of the chain
 * @param plugins - The plugin instances that will be executed
 * @param config - The current config
 * @param core - The current core instance
 * @param startAt - Identifies the next plugin to execute, if null there is no "next" plugin and if undefined it should assume the start of the chain
 */
function createProcessTelemetryUnloadContext(telemetryChain, core, startAt) {
    var config = core[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_CONFIG /* @min:%2econfig */] || {};
    var internalContext = _createInternalContext(telemetryChain, config, core, startAt);
    var context = internalContext.ctx;
    function _processNext(unloadState) {
        var nextPlugin = internalContext._next();
        nextPlugin && nextPlugin.unload(context, unloadState);
        return !nextPlugin;
    }
    function _createNew(plugins, startAt) {
        if (plugins === void 0) { plugins = null; }
        if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isArray)(plugins)) {
            plugins = createTelemetryProxyChain(plugins, config, core, startAt);
        }
        return createProcessTelemetryUnloadContext(plugins || context[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_GET_NEXT /* @min:%2egetNext */](), core, startAt);
    }
    context[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */] = _processNext;
    context[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_CREATE_NEW /* @min:%2ecreateNew */] = _createNew;
    return context;
}
/**
 * Creates a new Telemetry Item context with the current config, core and plugin execution chain for updating the configuration
 * @param plugins - The plugin instances that will be executed
 * @param config - The current config
 * @param core - The current core instance
 * @param startAt - Identifies the next plugin to execute, if null there is no "next" plugin and if undefined it should assume the start of the chain
 */
function createProcessTelemetryUpdateContext(telemetryChain, core, startAt) {
    var config = core[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_CONFIG /* @min:%2econfig */] || {};
    var internalContext = _createInternalContext(telemetryChain, config, core, startAt);
    var context = internalContext.ctx;
    function _processNext(updateState) {
        return context.iterate(function (plugin) {
            if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isFunction)(plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_UPDATE /* @min:%2eupdate */])) {
                plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_UPDATE /* @min:%2eupdate */](context, updateState);
            }
        });
    }
    function _createNew(plugins, startAt) {
        if (plugins === void 0) { plugins = null; }
        if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isArray)(plugins)) {
            plugins = createTelemetryProxyChain(plugins, config, core, startAt);
        }
        return createProcessTelemetryUpdateContext(plugins || context[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_GET_NEXT /* @min:%2egetNext */](), core, startAt);
    }
    context[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */] = _processNext;
    context[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_CREATE_NEW /* @min:%2ecreateNew */] = _createNew;
    return context;
}
/**
 * Creates an execution chain from the array of plugins
 * @param plugins - The array of plugins that will be executed in this order
 * @param defItemCtx - The default execution context to use when no telemetry context is passed to processTelemetry(), this
 * should be for legacy plugins only. Currently, only used for passing the current core instance and to provide better error
 * reporting (hasRun) when errors occur.
 */
function createTelemetryProxyChain(plugins, config, core, startAt) {
    var firstProxy = null;
    var add = startAt ? false : true;
    if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isArray)(plugins) && plugins[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] > 0) {
        // Create the proxies and wire up the next plugin chain
        var lastProxy_1 = null;
        (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.arrForEach)(plugins, function (thePlugin) {
            if (!add && startAt === thePlugin) {
                add = true;
            }
            if (add && thePlugin && (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isFunction)(thePlugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_PROCESS_TELEMETRY /* @min:%2eprocessTelemetry */])) {
                // Only add plugins that are processors
                var newProxy = createTelemetryPluginProxy(thePlugin, config, core);
                if (!firstProxy) {
                    firstProxy = newProxy;
                }
                if (lastProxy_1) {
                    // Set this new proxy as the next for the previous one
                    lastProxy_1._setNext(newProxy);
                }
                lastProxy_1 = newProxy;
            }
        });
    }
    if (startAt && !firstProxy) {
        // Special case where the "startAt" was not in the original list of plugins
        return createTelemetryProxyChain([startAt], config, core);
    }
    return firstProxy;
}
/**
 * Create the processing telemetry proxy instance, the proxy is used to abstract the current plugin to allow monitoring and
 * execution plugins while passing around the dynamic execution state (IProcessTelemetryContext), the proxy instance no longer
 * contains any execution state and can be reused between requests (this was not the case for 2.7.2 and earlier with the
 * TelemetryPluginChain class).
 * @param plugin - The plugin instance to proxy
 * @param config - The default execution context to use when no telemetry context is passed to processTelemetry(), this
 * should be for legacy plugins only. Currently, only used for passing the current core instance and to provide better error
 * reporting (hasRun) when errors occur.
 * @returns
 */
function createTelemetryPluginProxy(plugin, config, core) {
    var nextProxy = null;
    var hasProcessTelemetry = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isFunction)(plugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_PROCESS_TELEMETRY /* @min:%2eprocessTelemetry */]);
    var hasSetNext = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isFunction)(plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_SET_NEXT_PLUGIN /* @min:%2esetNextPlugin */]);
    var chainId;
    if (plugin) {
        chainId = plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_IDENTIFIER /* @min:%2eidentifier */] + "-" + plugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_PRIORITY /* @min:%2epriority */] + "-" + _chainId++;
    }
    else {
        chainId = "Unknown-0-" + _chainId++;
    }
    var proxyChain = {
        getPlugin: function () {
            return plugin;
        },
        getNext: function () {
            return nextProxy;
        },
        processTelemetry: _processTelemetry,
        unload: _unloadPlugin,
        update: _updatePlugin,
        _id: chainId,
        _setNext: function (nextPlugin) {
            nextProxy = nextPlugin;
        }
    };
    function _getTelCtx() {
        var itemCtx;
        // Looks like a plugin didn't pass the (optional) context, so create a new one
        if (plugin && (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isFunction)(plugin[strGetTelCtx])) {
            // This plugin extends from the BaseTelemetryPlugin so lets use it
            itemCtx = plugin[strGetTelCtx]();
        }
        if (!itemCtx) {
            // Create a temporary one
            itemCtx = createProcessTelemetryContext(proxyChain, config, core);
        }
        return itemCtx;
    }
    function _processChain(itemCtx, processPluginFn, name, details, isAsync) {
        var hasRun = false;
        var identifier = plugin ? plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_IDENTIFIER /* @min:%2eidentifier */] : strTelemetryPluginChain;
        var hasRunContext = itemCtx[strHasRunFlags];
        if (!hasRunContext) {
            // Assign and populate
            hasRunContext = itemCtx[strHasRunFlags] = {};
        }
        // Ensure that we keep the context in sync
        itemCtx.setNext(nextProxy);
        if (plugin) {
            (0,_PerfManager__WEBPACK_IMPORTED_MODULE_5__.doPerf)(itemCtx[_InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_CORE /* @min:%2ecore */](), function () { return identifier + ":" + name; }, function () {
                // Mark this component as having run
                hasRunContext[chainId] = true;
                try {
                    // Set a flag on the next plugin so we know if it was attempted to be executed
                    var nextId = nextProxy ? nextProxy._id : _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EMPTY;
                    if (nextId) {
                        hasRunContext[nextId] = false;
                    }
                    hasRun = processPluginFn(itemCtx);
                }
                catch (error) {
                    var hasNextRun = nextProxy ? hasRunContext[nextProxy._id] : true;
                    if (hasNextRun) {
                        // The next plugin after us has already run so set this one as complete
                        hasRun = true;
                    }
                    if (!nextProxy || !hasNextRun) {
                        // Either we have no next plugin or the current one did not attempt to call the next plugin
                        // Which means the current one is the root of the failure so log/report this failure
                        (0,_DiagnosticLogger__WEBPACK_IMPORTED_MODULE_1__._throwInternal)(itemCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DIAG_LOG /* @min:%2ediagLog */](), 1 /* eLoggingSeverity.CRITICAL */, 73 /* _eInternalMessageId.PluginException */, "Plugin [" + identifier + "] failed during " + name + " - " + (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_3__.dumpObj)(error) + ", run flags: " + (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_3__.dumpObj)(hasRunContext));
                    }
                }
            }, details, isAsync);
        }
        return hasRun;
    }
    function _processTelemetry(env, itemCtx) {
        itemCtx = itemCtx || _getTelCtx();
        function _callProcessTelemetry(itemCtx) {
            if (!plugin || !hasProcessTelemetry) {
                return false;
            }
            var pluginState = (0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_6__._getPluginState)(plugin);
            if (pluginState[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TEARDOWN /* @min:%2eteardown */] || pluginState[_InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_DISABLED]) {
                return false;
            }
            // Ensure that we keep the context in sync (for processNext()), just in case a plugin
            // doesn't calls processTelemetry() instead of itemContext.processNext() or some
            // other form of error occurred
            if (hasSetNext) {
                // Backward compatibility setting the next plugin on the instance
                plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_SET_NEXT_PLUGIN /* @min:%2esetNextPlugin */](nextProxy);
            }
            plugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_PROCESS_TELEMETRY /* @min:%2eprocessTelemetry */](env, itemCtx);
            // Process Telemetry is expected to call itemCtx.processNext() or nextPlugin.processTelemetry()
            return true;
        }
        if (!_processChain(itemCtx, _callProcessTelemetry, "processTelemetry", function () { return ({ item: env }); }, !(env.sync))) {
            // The underlying plugin is either not defined, not enabled or does not have a processTelemetry implementation
            // so we still want the next plugin to be executed.
            itemCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](env);
        }
    }
    function _unloadPlugin(unloadCtx, unloadState) {
        function _callTeardown() {
            // Setting default of hasRun as false so the proxyProcessFn() is called as teardown() doesn't have to exist or call unloadNext().
            var hasRun = false;
            if (plugin) {
                var pluginState = (0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_6__._getPluginState)(plugin);
                var pluginCore = plugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_CORE] || pluginState[_InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_CORE /* @min:%2ecore */];
                // Only teardown the plugin if it was initialized by the current core (i.e. It's not a shared plugin)
                if (plugin && (!pluginCore || pluginCore === unloadCtx.core()) && !pluginState[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TEARDOWN /* @min:%2eteardown */]) {
                    // Handle plugins that don't extend from the BaseTelemetryPlugin
                    pluginState[_InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_CORE /* @min:%2ecore */] = null;
                    pluginState[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TEARDOWN /* @min:%2eteardown */] = true;
                    pluginState[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_IS_INITIALIZED /* @min:%2eisInitialized */] = false;
                    if (plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TEARDOWN /* @min:%2eteardown */] && plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TEARDOWN /* @min:%2eteardown */](unloadCtx, unloadState) === true) {
                        // plugin told us that it was going to (or has) call unloadCtx.processNext()
                        hasRun = true;
                    }
                }
            }
            return hasRun;
        }
        if (!_processChain(unloadCtx, _callTeardown, "unload", function () { }, unloadState[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_IS_ASYNC /* @min:%2eisAsync */])) {
            // Only called if we hasRun was not true
            unloadCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](unloadState);
        }
    }
    function _updatePlugin(updateCtx, updateState) {
        function _callUpdate() {
            // Setting default of hasRun as false so the proxyProcessFn() is called as teardown() doesn't have to exist or call unloadNext().
            var hasRun = false;
            if (plugin) {
                var pluginState = (0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_6__._getPluginState)(plugin);
                var pluginCore = plugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_CORE] || pluginState[_InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_CORE /* @min:%2ecore */];
                // Only update the plugin if it was initialized by the current core (i.e. It's not a shared plugin)
                if (plugin && (!pluginCore || pluginCore === updateCtx.core()) && !pluginState[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TEARDOWN /* @min:%2eteardown */]) {
                    if (plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_UPDATE /* @min:%2eupdate */] && plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_UPDATE /* @min:%2eupdate */](updateCtx, updateState) === true) {
                        // plugin told us that it was going to (or has) call unloadCtx.processNext()
                        hasRun = true;
                    }
                }
            }
            return hasRun;
        }
        if (!_processChain(updateCtx, _callUpdate, "update", function () { }, false)) {
            // Only called if we hasRun was not true
            updateCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](updateState);
        }
    }
    return (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.objFreeze)(proxyChain);
}
/**
 * This class will be removed!
 * @deprecated use createProcessTelemetryContext() instead
 */
var ProcessTelemetryContext = /** @class */ (function () {
    /**
     * Creates a new Telemetry Item context with the current config, core and plugin execution chain
     * @param plugins - The plugin instances that will be executed
     * @param config - The current config
     * @param core - The current core instance
     */
    function ProcessTelemetryContext(pluginChain, config, core, startAt) {
        var _self = this;
        var context = createProcessTelemetryContext(pluginChain, config, core, startAt);
        // Proxy all functions of the context to this object
        (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.proxyFunctions)(_self, context, (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.objKeys)(context));
    }
    return ProcessTelemetryContext;
}());

//# sourceMappingURL=ProcessTelemetryContext.js.map

/***/ }),
/* 43 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "_getPluginState": () => (/* binding */ _getPluginState),
/* harmony export */   "createDistributedTraceContext": () => (/* binding */ createDistributedTraceContext),
/* harmony export */   "initializePlugins": () => (/* binding */ initializePlugins),
/* harmony export */   "sortPlugins": () => (/* binding */ sortPlugins),
/* harmony export */   "unloadComponents": () => (/* binding */ unloadComponents)
/* harmony export */ });
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(20);
/* harmony import */ var _DataCacheHelper__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(18);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(21);
/* harmony import */ var _W3cTraceParent__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(44);
/*
 * Application Insights JavaScript SDK - Core, 2.8.15
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */








var pluginStateData = (0,_DataCacheHelper__WEBPACK_IMPORTED_MODULE_0__.createElmNodeData)("plugin");
function _getPluginState(plugin) {
    return pluginStateData.get(plugin, "state", {}, true);
}
/**
 * Initialize the queue of plugins
 * @param plugins - The array of plugins to initialize and setting of the next plugin
 * @param config The current config for the instance
 * @param core THe current core instance
 * @param extensions The extensions
 */
function initializePlugins(processContext, extensions) {
    // Set the next plugin and identified the uninitialized plugins
    var initPlugins = [];
    var lastPlugin = null;
    var proxy = processContext[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_NEXT /* @min:%2egetNext */]();
    var pluginState;
    while (proxy) {
        var thePlugin = proxy[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_PLUGIN /* @min:%2egetPlugin */]();
        if (thePlugin) {
            if (lastPlugin &&
                (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isFunction)(lastPlugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_NEXT_PLUGIN /* @min:%2esetNextPlugin */]) &&
                (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isFunction)(thePlugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_PROCESS_TELEMETRY /* @min:%2eprocessTelemetry */])) {
                // Set this plugin as the next for the previous one
                lastPlugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_NEXT_PLUGIN /* @min:%2esetNextPlugin */](thePlugin);
            }
            var isInitialized = false;
            if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isFunction)(thePlugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_INITIALIZED /* @min:%2eisInitialized */])) {
                isInitialized = thePlugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_INITIALIZED /* @min:%2eisInitialized */]();
            }
            else {
                pluginState = _getPluginState(thePlugin);
                isInitialized = pluginState[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_INITIALIZED /* @min:%2eisInitialized */];
            }
            if (!isInitialized) {
                initPlugins[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PUSH /* @min:%2epush */](thePlugin);
            }
            lastPlugin = thePlugin;
            proxy = proxy[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_NEXT /* @min:%2egetNext */]();
        }
    }
    // Now initialize the plugins
    (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.arrForEach)(initPlugins, function (thePlugin) {
        var core = processContext[_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_CORE]();
        thePlugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_INITIALIZE /* @min:%2einitialize */](processContext.getCfg(), core, extensions, processContext[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_NEXT /* @min:%2egetNext */]());
        pluginState = _getPluginState(thePlugin);
        // Only add the core to the state if the plugin didn't set it (doesn't extent from BaseTelemetryPlugin)
        if (!thePlugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_CORE] && !pluginState[_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_CORE]) {
            pluginState[_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_CORE] = core;
        }
        pluginState[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_INITIALIZED /* @min:%2eisInitialized */] = true;
        delete pluginState[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TEARDOWN /* @min:%2eteardown */];
    });
}
function sortPlugins(plugins) {
    // Sort by priority
    return plugins.sort(function (extA, extB) {
        var result = 0;
        if (extB) {
            var bHasProcess = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isFunction)(extB[_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_PROCESS_TELEMETRY]);
            if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isFunction)(extA[_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_PROCESS_TELEMETRY])) {
                result = bHasProcess ? extA[_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_PRIORITY] - extB[_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_PRIORITY] : 1;
            }
            else if (bHasProcess) {
                result = -1;
            }
        }
        else {
            result = extA ? 1 : -1;
        }
        return result;
    });
    // sort complete
}
/**
 * Teardown / Unload helper to perform teardown/unloading operations for the provided components synchronously or asynchronously, this will call any
 * _doTeardown() or _doUnload() functions on the provided components to allow them to finish removal.
 * @param components - The components you want to unload
 * @param unloadCtx - This is the context that should be used during unloading.
 * @param unloadState - The details / state of the unload process, it holds details like whether it should be unloaded synchronously or asynchronously and the reason for the unload.
 * @param asyncCallback - An optional callback that the plugin must call if it returns true to inform the caller that it has completed any async unload/teardown operations.
 * @returns boolean - true if the plugin has or will call asyncCallback, this allows the plugin to perform any asynchronous operations.
 */
function unloadComponents(components, unloadCtx, unloadState, asyncCallback) {
    var idx = 0;
    function _doUnload() {
        while (idx < components[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */]) {
            var component = components[idx++];
            if (component) {
                var func = component._doUnload || component[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN__DO_TEARDOWN /* @min:%2e_doTeardown */];
                if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isFunction)(func)) {
                    if (func[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_CALL /* @min:%2ecall */](component, unloadCtx, unloadState, _doUnload) === true) {
                        return true;
                    }
                }
            }
        }
    }
    return _doUnload();
}
/**
 * Creates a IDistributedTraceContext which optionally also "sets" the value on a parent
 * @param parentCtx - An optional parent distributed trace instance
 * @returns A new IDistributedTraceContext instance that uses an internal temporary object
 */
function createDistributedTraceContext(parentCtx) {
    var trace = {};
    return {
        getName: function () {
            return trace[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_NAME /* @min:%2ename */];
        },
        setName: function (newValue) {
            parentCtx && parentCtx.setName(newValue);
            trace[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_NAME /* @min:%2ename */] = newValue;
        },
        getTraceId: function () {
            return trace[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TRACE_ID /* @min:%2etraceId */];
        },
        setTraceId: function (newValue) {
            parentCtx && parentCtx.setTraceId(newValue);
            if ((0,_W3cTraceParent__WEBPACK_IMPORTED_MODULE_4__.isValidTraceId)(newValue)) {
                trace[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TRACE_ID /* @min:%2etraceId */] = newValue;
            }
        },
        getSpanId: function () {
            return trace[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SPAN_ID /* @min:%2espanId */];
        },
        setSpanId: function (newValue) {
            parentCtx && parentCtx.setSpanId(newValue);
            if ((0,_W3cTraceParent__WEBPACK_IMPORTED_MODULE_4__.isValidSpanId)(newValue)) {
                trace[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SPAN_ID /* @min:%2espanId */] = newValue;
            }
        },
        getTraceFlags: function () {
            return trace[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TRACE_FLAGS /* @min:%2etraceFlags */];
        },
        setTraceFlags: function (newTraceFlags) {
            parentCtx && parentCtx.setTraceFlags(newTraceFlags);
            trace[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TRACE_FLAGS /* @min:%2etraceFlags */] = newTraceFlags;
        }
    };
}
//# sourceMappingURL=TelemetryHelpers.js.map

/***/ }),
/* 44 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "createTraceParent": () => (/* binding */ createTraceParent),
/* harmony export */   "findW3cTraceParent": () => (/* binding */ findW3cTraceParent),
/* harmony export */   "formatTraceParent": () => (/* binding */ formatTraceParent),
/* harmony export */   "isSampledFlag": () => (/* binding */ isSampledFlag),
/* harmony export */   "isValidSpanId": () => (/* binding */ isValidSpanId),
/* harmony export */   "isValidTraceId": () => (/* binding */ isValidTraceId),
/* harmony export */   "isValidTraceParent": () => (/* binding */ isValidTraceParent),
/* harmony export */   "parseTraceParent": () => (/* binding */ parseTraceParent)
/* harmony export */ });
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20);
/* harmony import */ var _CoreUtils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(35);
/* harmony import */ var _EnvUtils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(28);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(18);
/*
 * Application Insights JavaScript SDK - Core, 2.8.15
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */




// using {0,16} for leading and trailing whitespace just to constrain the possible runtime of a random string
var TRACE_PARENT_REGEX = /^([\da-f]{2})-([\da-f]{32})-([\da-f]{16})-([\da-f]{2})(-[^\s]*)?$/;
var DEFAULT_VERSION = "00";
var INVALID_VERSION = "ff";
var INVALID_TRACE_ID = "00000000000000000000000000000000";
var INVALID_SPAN_ID = "0000000000000000";
var SAMPLED_FLAG = 0x01;
function _isValid(value, len, invalidValue) {
    if (value && value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] === len && value !== invalidValue) {
        return !!value.match(/^[\da-f]*$/);
    }
    return false;
}
function _formatValue(value, len, defValue) {
    if (_isValid(value, len)) {
        return value;
    }
    return defValue;
}
function _formatFlags(value) {
    if (isNaN(value) || value < 0 || value > 255) {
        value = 0x01;
    }
    var result = value.toString(16);
    while (result[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] < 2) {
        result = "0" + result;
    }
    return result;
}
/**
 * Create a new ITraceParent instance using the provided values.
 * @param traceId - The traceId to use, when invalid a new random W3C id will be generated.
 * @param spanId - The parent/span id to use, a new random value will be generated if it is invalid.
 * @param flags - The traceFlags to use, defaults to zero (0) if not supplied or invalid
 * @param version - The version to used, defaults to version "01" if not supplied or invalid.
 * @returns
 */
function createTraceParent(traceId, spanId, flags, version) {
    var _a;
    return _a = {},
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_VERSION /* @min:version */] = _isValid(version, 2, INVALID_VERSION) ? version : DEFAULT_VERSION,
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TRACE_ID /* @min:traceId */] = isValidTraceId(traceId) ? traceId : (0,_CoreUtils__WEBPACK_IMPORTED_MODULE_1__.generateW3CId)(),
        _a.spanId = isValidSpanId(spanId) ? spanId : (0,_CoreUtils__WEBPACK_IMPORTED_MODULE_1__.generateW3CId)()[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_SUBSTR /* @min:%2esubstr */](0, 16),
        _a.traceFlags = flags >= 0 && flags <= 0xFF ? flags : 1,
        _a;
}
/**
 * Attempt to parse the provided string as a W3C TraceParent header value (https://www.w3.org/TR/trace-context/#traceparent-header)
 *
 * @param value
 * @returns
 */
function parseTraceParent(value) {
    var _a;
    if (!value) {
        // Don't pass a null/undefined or empty string
        return null;
    }
    if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isArray)(value)) {
        // The value may have been encoded on the page into an array so handle this automatically
        value = value[0] || "";
    }
    if (!value || !(0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isString)(value) || value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] > 8192) {
        // limit potential processing based on total length
        return null;
    }
    // See https://www.w3.org/TR/trace-context/#versioning-of-traceparent
    var match = TRACE_PARENT_REGEX.exec((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strTrim)(value));
    if (!match || // No match
        match[1] === INVALID_VERSION || // version ff is forbidden
        match[2] === INVALID_TRACE_ID || // All zeros is considered to be invalid
        match[3] === INVALID_SPAN_ID) { // All zeros is considered to be invalid
        return null;
    }
    return _a = {},
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_VERSION /* @min:version */] = match[1],
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TRACE_ID /* @min:traceId */] = match[2],
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_SPAN_ID /* @min:spanId */] = match[3],
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TRACE_FLAGS /* @min:traceFlags */] = parseInt(match[4], 16),
        _a;
}
/**
 * Is the provided W3c Trace Id a valid string representation, it must be a 32-character string
 * of lowercase hexadecimal characters for example, 4bf92f3577b34da6a3ce929d0e0e4736.
 * If all characters as zero (00000000000000000000000000000000) it will be considered an invalid value.
 * @param value - The W3c trace Id to be validated
 * @returns true if valid otherwise false
 */
function isValidTraceId(value) {
    return _isValid(value, 32, INVALID_TRACE_ID);
}
/**
 * Is the provided W3c span id (aka. parent id) a valid string representation, it must be a 16-character
 * string of lowercase hexadecimal characters, for example, 00f067aa0ba902b7.
 * If all characters are zero (0000000000000000) this is considered an invalid value.
 * @param value - The W3c span id to be validated
 * @returns true if valid otherwise false
 */
function isValidSpanId(value) {
    return _isValid(value, 16, INVALID_SPAN_ID);
}
/**
 * Validates that the provided ITraceParent instance conforms to the currently supported specifications
 * @param value
 * @returns
 */
function isValidTraceParent(value) {
    if (!value ||
        !_isValid(value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_VERSION /* @min:%2eversion */], 2, INVALID_VERSION) ||
        !_isValid(value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TRACE_ID /* @min:%2etraceId */], 32, INVALID_TRACE_ID) ||
        !_isValid(value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_SPAN_ID /* @min:%2espanId */], 16, INVALID_SPAN_ID) ||
        !_isValid(_formatFlags(value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TRACE_FLAGS /* @min:%2etraceFlags */]), 2)) {
        // Each known field must contain a valid value
        return false;
    }
    return true;
}
/**
 * Is the parsed traceParent indicating that the trace is currently sampled.
 * @param value - The parsed traceParent value
 * @returns
 */
function isSampledFlag(value) {
    if (isValidTraceParent(value)) {
        return (value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TRACE_FLAGS /* @min:%2etraceFlags */] & SAMPLED_FLAG) === SAMPLED_FLAG;
    }
    return false;
}
/**
 * Format the ITraceParent value as a string using the supported and know version formats.
 * So even if the passed traceParent is a later version the string value returned from this
 * function will convert it to only the known version formats.
 * This currently only supports version "00" and invalid "ff"
 * @param value - The parsed traceParent value
 * @returns
 */
function formatTraceParent(value) {
    if (value) {
        // Special Note: This only supports formatting as version 00, future versions should encode any known supported version
        // So parsing a future version will populate the correct version value but reformatting will reduce it to version 00.
        var flags = _formatFlags(value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TRACE_FLAGS /* @min:%2etraceFlags */]);
        if (!_isValid(flags, 2)) {
            flags = "01";
        }
        var version = value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_VERSION /* @min:%2eversion */] || DEFAULT_VERSION;
        if (version !== "00" && version !== "ff") {
            // Reduce version to "00"
            version = DEFAULT_VERSION;
        }
        // Format as version 00
        return "".concat(version, "-").concat(_formatValue(value.traceId, 32, INVALID_TRACE_ID), "-").concat(_formatValue(value.spanId, 16, INVALID_SPAN_ID), "-").concat(flags);
    }
    return "";
}
/**
 * Helper function to fetch the passed traceparent from the page, looking for it as a meta-tag or a Server-Timing header.
 * @returns
 */
function findW3cTraceParent() {
    var name = "traceparent";
    var traceParent = parseTraceParent((0,_EnvUtils__WEBPACK_IMPORTED_MODULE_3__.findMetaTag)(name));
    if (!traceParent) {
        traceParent = parseTraceParent((0,_EnvUtils__WEBPACK_IMPORTED_MODULE_3__.findNamedServerTiming)(name));
    }
    return traceParent;
}
//# sourceMappingURL=W3cTraceParent.js.map

/***/ }),
/* 45 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TelemetryInitializerPlugin": () => (/* binding */ TelemetryInitializerPlugin)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23);
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(29);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(20);
/* harmony import */ var _BaseTelemetryPlugin__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(46);
/* harmony import */ var _DiagnosticLogger__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(27);
/* harmony import */ var _EnvUtils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(28);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(18);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(21);
/*
 * Application Insights JavaScript SDK - Core, 2.8.15
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */
// 
// 








var TelemetryInitializerPlugin = /** @class */ (function (_super) {
    (0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.__extendsFn)(TelemetryInitializerPlugin, _super);
    function TelemetryInitializerPlugin() {
        var _this = _super.call(this) || this;
        _this.identifier = "TelemetryInitializerPlugin";
        _this.priority = 199;
        // NOTE!: DON'T set default values here, instead set them in the _initDefaults() function as it is also called during teardown()
        var _id;
        var _initializers;
        _initDefaults();
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_1__["default"])(TelemetryInitializerPlugin, _this, function (_self, _base) {
            _self.addTelemetryInitializer = function (telemetryInitializer) {
                var theInitializer = {
                    id: _id++,
                    fn: telemetryInitializer
                };
                _initializers[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PUSH /* @min:%2epush */](theInitializer);
                var handler = {
                    remove: function () {
                        (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(_initializers, function (initializer, idx) {
                            if (initializer.id === theInitializer.id) {
                                _initializers[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_SPLICE /* @min:%2esplice */](idx, 1);
                                return -1;
                            }
                        });
                    }
                };
                return handler;
            };
            _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_PROCESS_TELEMETRY /* @min:%2eprocessTelemetry */] = function (item, itemCtx) {
                var doNotSendItem = false;
                var telemetryInitializersCount = _initializers[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */];
                for (var i = 0; i < telemetryInitializersCount; ++i) {
                    var telemetryInitializer = _initializers[i];
                    if (telemetryInitializer) {
                        try {
                            if (telemetryInitializer.fn[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_APPLY /* @min:%2eapply */](null, [item]) === false) {
                                doNotSendItem = true;
                                break;
                            }
                        }
                        catch (e) {
                            // log error but dont stop executing rest of the telemetry initializers
                            // doNotSendItem = true;
                            (0,_DiagnosticLogger__WEBPACK_IMPORTED_MODULE_5__._throwInternal)(itemCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_DIAG_LOG /* @min:%2ediagLog */](), 1 /* eLoggingSeverity.CRITICAL */, 64 /* _eInternalMessageId.TelemetryInitializerFailed */, "One of telemetry initializers failed, telemetry item will not be sent: " + (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.getExceptionName)(e), { exception: (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_6__.dumpObj)(e) }, true);
                        }
                    }
                }
                if (!doNotSendItem) {
                    _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](item, itemCtx);
                }
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN__DO_TEARDOWN /* @min:%2e_doTeardown */] = function () {
                _initDefaults();
            };
        });
        function _initDefaults() {
            _id = 0;
            _initializers = [];
        }
        return _this;
    }
// Removed Stub for TelemetryInitializerPlugin.prototype.addTelemetryInitializer.
// Removed Stub for TelemetryInitializerPlugin.prototype.processTelemetry.
    // This is a workaround for an IE8 bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    // this will be removed when ES3 support is dropped.
    TelemetryInitializerPlugin.__ieDyn=1;

    return TelemetryInitializerPlugin;
}(_BaseTelemetryPlugin__WEBPACK_IMPORTED_MODULE_7__.BaseTelemetryPlugin));

//# sourceMappingURL=TelemetryInitializerPlugin.js.map

/***/ }),
/* 46 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BaseTelemetryPlugin": () => (/* binding */ BaseTelemetryPlugin)
/* harmony export */ });
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(29);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(20);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(18);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(21);
/* harmony import */ var _ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(42);
/* harmony import */ var _UnloadHandlerContainer__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(47);
/*
 * Application Insights JavaScript SDK - Core, 2.8.15
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */









var strGetPlugin = "getPlugin";
/**
 * BaseTelemetryPlugin provides a basic implementation of the ITelemetryPlugin interface so that plugins
 * can avoid implementation the same set of boiler plate code as well as provide a base
 * implementation so that new default implementations can be added without breaking all plugins.
 */
var BaseTelemetryPlugin = /** @class */ (function () {
    function BaseTelemetryPlugin() {
        var _self = this; // Setting _self here as it's used outside of the dynamicProto as well
        // NOTE!: DON'T set default values here, instead set them in the _initDefaults() function as it is also called during teardown()
        var _isinitialized;
        var _rootCtx; // Used as the root context, holding the current config and initialized core
        var _nextPlugin; // Used for backward compatibility where plugins don't call the main pipeline
        var _unloadHandlerContainer;
        var _hooks;
        _initDefaults();
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_0__["default"])(BaseTelemetryPlugin, _self, function (_self) {
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_INITIALIZE /* @min:%2einitialize */] = function (config, core, extensions, pluginChain) {
                _setDefaults(config, core, pluginChain);
                _isinitialized = true;
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TEARDOWN /* @min:%2eteardown */] = function (unloadCtx, unloadState) {
                var _a;
                // If this plugin has already been torn down (not operational) or is not initialized (core is not set)
                // or the core being used for unload was not the same core used for initialization.
                var core = _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_CORE /* @min:%2ecore */];
                if (!core || (unloadCtx && core !== unloadCtx[_InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_CORE /* @min:%2ecore */]())) {
                    // Do Nothing as either the plugin is not initialized or was not initialized by the current core
                    return;
                }
                var result;
                var unloadDone = false;
                var theUnloadCtx = unloadCtx || (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_3__.createProcessTelemetryUnloadContext)(null, core, _nextPlugin && _nextPlugin[strGetPlugin] ? _nextPlugin[strGetPlugin]() : _nextPlugin);
                var theUnloadState = unloadState || (_a = {
                        reason: 0 /* TelemetryUnloadReason.ManualTeardown */
                    },
                    _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_ASYNC /* @min:isAsync */] = false,
                    _a);
                function _unloadCallback() {
                    if (!unloadDone) {
                        unloadDone = true;
                        _unloadHandlerContainer.run(theUnloadCtx, unloadState);
                        var oldHooks = _hooks;
                        _hooks = [];
                        // Remove all instrumentation hooks
                        (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_4__.arrForEach)(oldHooks, function (fn) {
                            fn.rm();
                        });
                        if (result === true) {
                            theUnloadCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](theUnloadState);
                        }
                        _initDefaults();
                    }
                }
                if (!_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN__DO_TEARDOWN /* @min:%2e_doTeardown */] || _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN__DO_TEARDOWN /* @min:%2e_doTeardown */](theUnloadCtx, theUnloadState, _unloadCallback) !== true) {
                    _unloadCallback();
                }
                else {
                    // Tell the caller that we will be calling processNext()
                    result = true;
                }
                return result;
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_UPDATE /* @min:%2eupdate */] = function (updateCtx, updateState) {
                // If this plugin has already been torn down (not operational) or is not initialized (core is not set)
                // or the core being used for unload was not the same core used for initialization.
                var core = _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_CORE /* @min:%2ecore */];
                if (!core || (updateCtx && core !== updateCtx[_InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_CORE /* @min:%2ecore */]())) {
                    // Do Nothing
                    return;
                }
                var result;
                var updateDone = false;
                var theUpdateCtx = updateCtx || (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_3__.createProcessTelemetryUpdateContext)(null, core, _nextPlugin && _nextPlugin[strGetPlugin] ? _nextPlugin[strGetPlugin]() : _nextPlugin);
                var theUpdateState = updateState || {
                    reason: 0 /* TelemetryUpdateReason.Unknown */
                };
                function _updateCallback() {
                    if (!updateDone) {
                        updateDone = true;
                        _setDefaults(theUpdateCtx.getCfg(), theUpdateCtx.core(), theUpdateCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_NEXT /* @min:%2egetNext */]());
                    }
                }
                if (!_self._doUpdate || _self._doUpdate(theUpdateCtx, theUpdateState, _updateCallback) !== true) {
                    _updateCallback();
                }
                else {
                    result = true;
                }
                return result;
            };
            _self._addHook = function (hooks) {
                if (hooks) {
                    if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_4__.isArray)(hooks)) {
                        _hooks = _hooks.concat(hooks);
                    }
                    else {
                        _hooks[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PUSH /* @min:%2epush */](hooks);
                    }
                }
            };
            (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_4__.proxyFunctionAs)(_self, "_addUnloadCb", function () { return _unloadHandlerContainer; }, "add");
        });
        // These are added after the dynamicProto so that are not moved to the prototype
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_DIAG_LOG /* @min:%2ediagLog */] = function (itemCtx) {
            return _getTelCtx(itemCtx)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_DIAG_LOG /* @min:%2ediagLog */]();
        };
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_INITIALIZED /* @min:%2eisInitialized */] = function () {
            return _isinitialized;
        };
        _self.setInitialized = function (isInitialized) {
            _isinitialized = isInitialized;
        };
        // _self.getNextPlugin = () => DO NOT IMPLEMENT
        // Sub-classes of this base class *should* not be relying on this value and instead
        // should use processNext() function. If you require access to the plugin use the
        // IProcessTelemetryContext.getNext().getPlugin() while in the pipeline, Note getNext() may return null.
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_NEXT_PLUGIN /* @min:%2esetNextPlugin */] = function (next) {
            _nextPlugin = next;
        };
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */] = function (env, itemCtx) {
            if (itemCtx) {
                // Normal core execution sequence
                itemCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](env);
            }
            else if (_nextPlugin && (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_4__.isFunction)(_nextPlugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_PROCESS_TELEMETRY /* @min:%2eprocessTelemetry */])) {
                // Looks like backward compatibility or out of band processing. And as it looks
                // like a ITelemetryPlugin or ITelemetryPluginChain, just call processTelemetry
                _nextPlugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_PROCESS_TELEMETRY /* @min:%2eprocessTelemetry */](env, null);
            }
        };
        _self._getTelCtx = _getTelCtx;
        function _getTelCtx(currentCtx) {
            if (currentCtx === void 0) { currentCtx = null; }
            var itemCtx = currentCtx;
            if (!itemCtx) {
                var rootCtx = _rootCtx || (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_3__.createProcessTelemetryContext)(null, {}, _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_CORE /* @min:%2ecore */]);
                // tslint:disable-next-line: prefer-conditional-expression
                if (_nextPlugin && _nextPlugin[strGetPlugin]) {
                    // Looks like a chain object
                    itemCtx = rootCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_CREATE_NEW /* @min:%2ecreateNew */](null, _nextPlugin[strGetPlugin]);
                }
                else {
                    itemCtx = rootCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_CREATE_NEW /* @min:%2ecreateNew */](null, _nextPlugin);
                }
            }
            return itemCtx;
        }
        function _setDefaults(config, core, pluginChain) {
            if (config) {
                // Make sure the extensionConfig exists
                (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_4__.setValue)(config, _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EXTENSION_CONFIG, [], null, _HelperFuncs__WEBPACK_IMPORTED_MODULE_4__.isNullOrUndefined);
            }
            if (!pluginChain && core) {
                // Get the first plugin from the core
                pluginChain = core[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_PROCESS_TEL_CONT0 /* @min:%2egetProcessTelContext */]()[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_NEXT /* @min:%2egetNext */]();
            }
            var nextPlugin = _nextPlugin;
            if (_nextPlugin && _nextPlugin[strGetPlugin]) {
                // If it looks like a proxy/chain then get the plugin
                nextPlugin = _nextPlugin[strGetPlugin]();
            }
            // Support legacy plugins where core was defined as a property
            _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_CORE /* @min:%2ecore */] = core;
            _rootCtx = (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_3__.createProcessTelemetryContext)(pluginChain, config, core, nextPlugin);
        }
        function _initDefaults() {
            _isinitialized = false;
            _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_CORE /* @min:%2ecore */] = null;
            _rootCtx = null;
            _nextPlugin = null;
            _hooks = [];
            _unloadHandlerContainer = (0,_UnloadHandlerContainer__WEBPACK_IMPORTED_MODULE_5__.createUnloadHandlerContainer)();
        }
    }
// Removed Stub for BaseTelemetryPlugin.prototype.initialize.
// Removed Stub for BaseTelemetryPlugin.prototype.teardown.
// Removed Stub for BaseTelemetryPlugin.prototype.update.
// Removed Stub for BaseTelemetryPlugin.prototype._addUnloadCb.
// Removed Stub for BaseTelemetryPlugin.prototype._addHook.
    // This is a workaround for an IE8 bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    // this will be removed when ES3 support is dropped.
    BaseTelemetryPlugin.__ieDyn=1;

    return BaseTelemetryPlugin;
}());

//# sourceMappingURL=BaseTelemetryPlugin.js.map

/***/ }),
/* 47 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "createUnloadHandlerContainer": () => (/* binding */ createUnloadHandlerContainer)
/* harmony export */ });
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20);
/* harmony import */ var _DiagnosticLogger__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(27);
/* harmony import */ var _EnvUtils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(28);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(18);
/*
 * Application Insights JavaScript SDK - Core, 2.8.15
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */






function createUnloadHandlerContainer() {
    var handlers = [];
    function _addHandler(handler) {
        if (handler) {
            handlers[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PUSH /* @min:%2epush */](handler);
        }
    }
    function _runHandlers(unloadCtx, unloadState) {
        (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.arrForEach)(handlers, function (handler) {
            try {
                handler(unloadCtx, unloadState);
            }
            catch (e) {
                (0,_DiagnosticLogger__WEBPACK_IMPORTED_MODULE_2__._throwInternal)(unloadCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DIAG_LOG /* @min:%2ediagLog */](), 2 /* eLoggingSeverity.WARNING */, 73 /* _eInternalMessageId.PluginException */, "Unexpected error calling unload handler - " + (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_3__.dumpObj)(e));
            }
        });
        handlers = [];
    }
    return {
        add: _addHandler,
        run: _runHandlers
    };
}
//# sourceMappingURL=UnloadHandlerContainer.js.map

/***/ }),
/* 48 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ChannelControllerPriority": () => (/* binding */ ChannelControllerPriority),
/* harmony export */   "createChannelControllerPlugin": () => (/* binding */ createChannelControllerPlugin),
/* harmony export */   "createChannelQueues": () => (/* binding */ createChannelQueues)
/* harmony export */ });
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(20);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(18);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(21);
/* harmony import */ var _ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(42);
/* harmony import */ var _TelemetryHelpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(43);
/*
 * Application Insights JavaScript SDK - Core, 2.8.15
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */

// 





var ChannelControllerPriority = 500;
var ChannelValidationMessage = "Channel has invalid priority - ";
function _addChannelQueue(channelQueue, queue, core) {
    if (queue && (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_0__.isArray)(queue) && queue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] > 0) {
        queue = queue.sort(function (a, b) {
            return a[_InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_PRIORITY /* @min:%2epriority */] - b[_InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_PRIORITY /* @min:%2epriority */];
        });
        (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_0__.arrForEach)(queue, function (queueItem) {
            if (queueItem[_InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_PRIORITY /* @min:%2epriority */] < ChannelControllerPriority) {
                (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_0__.throwError)(ChannelValidationMessage + queueItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IDENTIFIER /* @min:%2eidentifier */]);
            }
        });
        channelQueue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PUSH /* @min:%2epush */]({
            queue: (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_0__.objFreeze)(queue),
            chain: (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_3__.createTelemetryProxyChain)(queue, core[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_CONFIG /* @min:%2econfig */], core)
        });
    }
}
function createChannelControllerPlugin(channelQueue, core) {
    function _getTelCtx() {
        return (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_3__.createProcessTelemetryContext)(null, core[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_CONFIG /* @min:%2econfig */], core, null);
    }
    function _processChannelQueue(theChannels, itemCtx, processFn, onComplete) {
        var waiting = theChannels ? (theChannels[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] + 1) : 1;
        function _runChainOnComplete() {
            waiting--;
            if (waiting === 0) {
                onComplete && onComplete();
                onComplete = null;
            }
        }
        if (waiting > 0) {
            (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_0__.arrForEach)(theChannels, function (channels) {
                // pass on to first item in queue
                if (channels && channels.queue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    var channelChain = channels.chain;
                    var chainCtx = itemCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_CREATE_NEW /* @min:%2ecreateNew */](channelChain);
                    chainCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_ON_COMPLETE /* @min:%2eonComplete */](_runChainOnComplete);
                    // Cause this chain to start processing
                    processFn(chainCtx);
                }
                else {
                    waiting--;
                }
            });
        }
        _runChainOnComplete();
    }
    function _doUpdate(updateCtx, updateState) {
        var theUpdateState = updateState || {
            reason: 0 /* TelemetryUpdateReason.Unknown */
        };
        _processChannelQueue(channelQueue, updateCtx, function (chainCtx) {
            chainCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](theUpdateState);
        }, function () {
            updateCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](theUpdateState);
        });
        return true;
    }
    function _doTeardown(unloadCtx, unloadState) {
        var theUnloadState = unloadState || {
            reason: 0 /* TelemetryUnloadReason.ManualTeardown */,
            isAsync: false
        };
        _processChannelQueue(channelQueue, unloadCtx, function (chainCtx) {
            chainCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](theUnloadState);
        }, function () {
            unloadCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](theUnloadState);
            isInitialized = false;
        });
        return true;
    }
    function _getChannel(pluginIdentifier) {
        var thePlugin = null;
        if (channelQueue && channelQueue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] > 0) {
            (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_0__.arrForEach)(channelQueue, function (channels) {
                // pass on to first item in queue
                if (channels && channels.queue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_0__.arrForEach)(channels.queue, function (ext) {
                        if (ext[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IDENTIFIER /* @min:%2eidentifier */] === pluginIdentifier) {
                            thePlugin = ext;
                            // Cause arrForEach to stop iterating
                            return -1;
                        }
                    });
                    if (thePlugin) {
                        // Cause arrForEach to stop iterating
                        return -1;
                    }
                }
            });
        }
        return thePlugin;
    }
    var isInitialized = false;
    var channelController = {
        identifier: "ChannelControllerPlugin",
        priority: ChannelControllerPriority,
        initialize: function (config, core, extensions, pluginChain) {
            isInitialized = true;
            (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_0__.arrForEach)(channelQueue, function (channels) {
                if (channels && channels.queue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    (0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_4__.initializePlugins)((0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_3__.createProcessTelemetryContext)(channels.chain, config, core), extensions);
                }
            });
        },
        isInitialized: function () {
            return isInitialized;
        },
        processTelemetry: function (item, itemCtx) {
            _processChannelQueue(channelQueue, itemCtx || _getTelCtx(), function (chainCtx) {
                chainCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](item);
            }, function () {
                itemCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](item);
            });
        },
        update: _doUpdate,
        pause: function () {
            _processChannelQueue(channelQueue, _getTelCtx(), function (chainCtx) {
                chainCtx.iterate(function (plugin) {
                    plugin.pause && plugin.pause();
                });
            }, null);
        },
        resume: function () {
            _processChannelQueue(channelQueue, _getTelCtx(), function (chainCtx) {
                chainCtx.iterate(function (plugin) {
                    plugin.resume && plugin.resume();
                });
            }, null);
        },
        teardown: _doTeardown,
        getChannel: _getChannel,
        flush: function (isAsync, callBack, sendReason, cbTimeout) {
            // Setting waiting to one so that we don't call the callBack until we finish iterating
            var waiting = 1;
            var doneIterating = false;
            var cbTimer = null;
            cbTimeout = cbTimeout || 5000;
            function doCallback() {
                waiting--;
                if (doneIterating && waiting === 0) {
                    if (cbTimer) {
                        clearTimeout(cbTimer);
                        cbTimer = null;
                    }
                    callBack && callBack(doneIterating);
                    callBack = null;
                }
            }
            _processChannelQueue(channelQueue, _getTelCtx(), function (chainCtx) {
                chainCtx.iterate(function (plugin) {
                    if (plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_FLUSH /* @min:%2eflush */]) {
                        waiting++;
                        var handled_1 = false;
                        // Not all channels will call this callback for every scenario
                        if (!plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_FLUSH /* @min:%2eflush */](isAsync, function () {
                            handled_1 = true;
                            doCallback();
                        }, sendReason)) {
                            if (!handled_1) {
                                // If any channel doesn't return true and it didn't call the callback, then we should assume that the callback
                                // will never be called, so use a timeout to allow the channel(s) some time to "finish" before triggering any
                                // followup function (such as unloading)
                                if (isAsync && cbTimer == null) {
                                    cbTimer = setTimeout(function () {
                                        cbTimer = null;
                                        doCallback();
                                    }, cbTimeout);
                                }
                                else {
                                    doCallback();
                                }
                            }
                        }
                    }
                });
            }, function () {
                doneIterating = true;
                doCallback();
            });
            return true;
        },
        _setQueue: function (queue) {
            channelQueue = queue;
        }
    };
    return channelController;
}
function createChannelQueues(channels, extensions, core) {
    var channelQueue = [];
    if (channels) {
        // Add and sort the configuration channel queues
        (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_0__.arrForEach)(channels, function (queue) { return _addChannelQueue(channelQueue, queue, core); });
    }
    if (extensions) {
        // Create a new channel queue for any extensions with a priority > the ChannelControllerPriority
        var extensionQueue_1 = [];
        (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_0__.arrForEach)(extensions, function (plugin) {
            if (plugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_PRIORITY /* @min:%2epriority */] > ChannelControllerPriority) {
                extensionQueue_1[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PUSH /* @min:%2epush */](plugin);
            }
        });
        _addChannelQueue(channelQueue, extensionQueue_1, core);
    }
    return channelQueue;
}
//# sourceMappingURL=ChannelController.js.map

/***/ }),
/* 49 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23);
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(26);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(27);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(28);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(41);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(32);
/* harmony import */ var _Utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(33);
/*
 * 1DS JS SDK Core, 3.2.13
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */

/**
* BaseCore.ts
* Base Core is a subset of 1DS Web SDK Core. The purpose of Base Core is to generate a smaller bundle size while providing essential features of Core. Features that are not included in Base Core are:
* 1. Internal logging
* 2. Sending notifications on telemetry sent/discarded
* @author Abhilash Panwar (abpanwar) Hector Hernandez (hectorh)
* @copyright Microsoft 2018
*/




var BaseCore = /** @class */ (function (_super) {
    (0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.__extendsFn)(BaseCore, _super);
    function BaseCore() {
        var _this = _super.call(this) || this;
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_1__["default"])(BaseCore, _this, function (_self, _base) {
            _self.initialize = function (config, extensions, logger, notificationManager) {
                if (config && !config.endpointUrl) {
                    config.endpointUrl = _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_DEFAULT_ENDPOINT_URL;
                }
                _self.getWParam = function () {
                    return (_Utils__WEBPACK_IMPORTED_MODULE_3__.isDocumentObjectAvailable || !!config.enableWParam) ? 0 : -1;
                };
                try {
                    _base.initialize(config, extensions, logger, notificationManager);
                }
                catch (e) {
                    (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__._throwInternal)(_self.logger, 1 /* eLoggingSeverity.CRITICAL */, 514 /* _eExtendedInternalMessageId.FailedToInitializeSDK */, "Initialization Failed: " + (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__.dumpObj)(e) + "\n - Note: Channels must be provided through config.channels only");
                }
            };
            _self.track = function (item) {
                var telemetryItem = item;
                if (telemetryItem) {
                    var ext = telemetryItem.ext = telemetryItem.ext || {};
                    ext.sdk = ext.sdk || {};
                    ext.sdk.ver = _Utils__WEBPACK_IMPORTED_MODULE_3__.FullVersionString;
                }
                _base.track(telemetryItem);
            };
        });
        return _this;
    }
// Removed Stub for BaseCore.prototype.initialize.
// Removed Stub for BaseCore.prototype.track.
    // This is a workaround for an IE8 bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    // this will be removed when ES3 support is dropped.
    BaseCore.__ieDyn=1;

    return BaseCore;
}(_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__.BaseCore));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BaseCore);
//# sourceMappingURL=BaseCore.js.map

/***/ }),
/* 50 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(26);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(18);
/*
 * 1DS JS SDK Core, 3.2.13
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */
/**
* ESPromise.ts
* @author  Nev Wylie (newylie))
* @copyright Microsoft 2019
* Simplified wrapper to provide ES6 style Promise callback handling for older browsers
*/


/**
 * @ignore -- Don't include in the generated documentation
 * Using a local variable to assist with minfication
 */
var _isFunction = _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isFunction;
/**
 * @ignore -- Don't include in the generated documentation
 * This function will be used as onFulfilled handler for any Promise found in the iterable passed to Promise.all.
 * The goal here is to capture in a closure the index of the current item from the iterable. If we did not create
 * this closure, the captured index variable would be the same one that the for loop updates and thus would always
 * be pointing to the last index in the iterable by the time that the onFulfilled handler is called.
 * However, note that for the resolvedCallback callback we want the opposite. For this one we do want to capture
 * the same variable that the for loop updates so that we have the full count of pending promises by the time
 * the onFulfilled handlers start getting called.
 * @param values The resolving promise values
 * @param index The index of this callback function
 * @param resolvedCallback THe callback function used to check if the "all" promise is complete
 */
function _createPromiseAllOnResolvedFunction(values, index, resolvedCallback) {
    return function (value) {
        values[index] = value;
        resolvedCallback();
    };
}
/**
 * Simplified wrapper to provide ES6 style Promise callback handling for older browsers
 */
var ESPromise = /** @class */ (function () {
    /**
     * The Promise object represents the eventual completion (or failure) of an asynchronous operation, and its resulting value.
     * @param resolverFunc A function that is passed with the arguments resolve and reject. The executor function is executed
     * immediately by the Promise implementation, passing resolve and reject functions (the executor is called before the Promise
     * constructor even returns the created object). The resolve and reject functions, when called, resolve or reject the promise,
     * respectively. The executor normally initiates some asynchronous work, and then, once that completes, either calls the resolve
     * function to resolve the promise or else rejects it if an error occurred. If an error is thrown in the executor function, the
     * promise is rejected. The return value of the executor is ignored.
     */
    function ESPromise(resolverFunc) {
        var _state = 0 /* PromiseState.Pending */;
        var _settledValue = null;
        var _queue = [];
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_1__["default"])(ESPromise, this, function (_this) {
            _this.then = function (onResolved, onRejected) {
                return new ESPromise(function (resolve, reject) {
                    // Queue the new promise returned to be resolved or rejected
                    // when this promise settles.
                    _enqueue(onResolved, onRejected, resolve, reject);
                });
            };
            _this["catch"] = function (onRejected) {
                return _this.then(null, onRejected);
            };
        });
        function _enqueue(onResolved, onRejected, resolve, reject) {
            _queue.push(function () {
                var value;
                try {
                    // First call the onFulfilled or onRejected handler, on the settled value
                    // of this promise. If the corresponding handler does not exist, simply
                    // pass through the settled value.
                    if (_state === 1 /* PromiseState.Resolved */) {
                        value = _isFunction(onResolved) ? onResolved(_settledValue) : _settledValue;
                    }
                    else {
                        value = _isFunction(onRejected) ? onRejected(_settledValue) : _settledValue;
                    }
                    if (value instanceof ESPromise) {
                        // The called handlers returned a new promise, so the chained promise
                        // will follow the state of this promise.
                        value.then(resolve, reject);
                    }
                    else if (_state === 2 /* PromiseState.Rejected */ && !_isFunction(onRejected)) {
                        // If there wasn't an onRejected handler and this promise is rejected, then
                        // the chained promise also rejects with the same reason.
                        reject(value);
                    }
                    else {
                        // If this promise is fulfilled, then the chained promise is also fulfilled
                        // with either the settled value of this promise (if no onFulfilled handler
                        // was available) or the return value of the handler. If this promise is
                        // rejected and there was an onRejected handler, then the chained promise is
                        // fulfilled with the return value of the handler.
                        resolve(value);
                    }
                }
                catch (error) {
                    // The chained promise will reject if there is any exception thrown while
                    // calling the onFulfilled or onRejected handlers.
                    reject(error);
                    return;
                }
            });
            // If this promise is already settled, then immediately process the callback we
            // just added to the queue.
            if (_state !== 0 /* PromiseState.Pending */) {
                _processQueue();
            }
        }
        function _processQueue() {
            if (_queue.length > 0) {
                // The onFulfilled and onRejected handlers must be called asynchronously. Thus,
                // we make a copy of the queue and work on it once the current call stack unwinds.
                var pending_1 = _queue.slice();
                _queue = [];
                setTimeout(function () {
                    for (var i = 0, len = pending_1.length; i < len; ++i) {
                        try {
                            pending_1[i]();
                        }
                        catch (e) {
                            // Don't let 1 failing handler break all others
                            // TODO (newylie): Add some form of error reporting (i.e. Call any registered JS error handler so the error is reported)
                        }
                    }
                }, 0);
            }
        }
        function _resolve(value) {
            if (_state === 0 /* PromiseState.Pending */) {
                _settledValue = value;
                _state = 1 /* PromiseState.Resolved */;
                _processQueue();
            }
        }
        function _reject(reason) {
            if (_state === 0 /* PromiseState.Pending */) {
                _settledValue = reason;
                _state = 2 /* PromiseState.Rejected */;
                _processQueue();
            }
        }
        (function _initialize() {
            if (!_isFunction(resolverFunc)) {
                throw new TypeError("ESPromise: resolvedFunc argument is not a Function");
            }
            try {
                resolverFunc(_resolve, _reject);
            }
            catch (error) {
                // This promise will immediately reject if any exception is thrown
                // from within the executor function.
                _reject(error);
            }
        })();
    }
    /**
     * The Promise.resolve() method returns a Promise object that is resolved with a given value. If the value is a promise, that promise is returned;
     * if the value is a thenable (i.e. has a "then" method), the returned promise will "follow" that thenable, adopting its eventual state; otherwise
     * the returned promise will be fulfilled with the value. This function flattens nested layers of promise-like objects (e.g. a promise that resolves
     * to a promise that resolves to something) into a single layer.
     * @param value Argument to be resolved by this Promise. Can also be a Promise or a thenable to resolve.
     */
    ESPromise.resolve = function (value) {
        if (value instanceof ESPromise) {
            // Value is a Promise so just return it
            return value;
        }
        else if (value && _isFunction(value.then)) {
            // Value looks like a promise or thenable (has a then function)
            return new ESPromise(function (resolve, reject) {
                try {
                    value.then(resolve, reject);
                }
                catch (error) {
                    reject(error);
                }
            });
        }
        return new ESPromise(function (resolve) {
            resolve(value);
        });
    };
    /**
     * The Promise.reject() method returns a Promise object that is rejected with a given reason.
     * @param reason The reason why this Promise rejected.
     */
    ESPromise.reject = function (reason) {
        return new ESPromise(function (resolve, reject) {
            reject(reason);
        });
    };
    /**
     * The Promise.all() method returns a single Promise that resolves when all of the promises passed as an iterable
     * have resolved or when the iterable contains no promises. It rejects with the reason of the first promise that
     * rejects. There is no implied ordering in the execution of the array of Promises given. On some computers, they
     * may be executed in parallel, or in some sense concurrently, while on others they may be executed serially. For
     * this reason, there must be no dependency in any Promise on the order of execution of the Promises.
     * This method can be useful for aggregating the results of multiple promises.
     * FulfillmentSection - The returned promise is fulfilled with an array containing all the values of the iterable
     * passed as argument (also non-promise values).
     * If an empty iterable is passed, then this method returns (synchronously) an already resolved promise.
     * If all of the passed-in promises fulfill, or are not promises, the promise returned by Promise.all is fulfilled
     * asynchronously.
     * RejectionSection - If any of the passed-in promises reject, Promise.all asynchronously rejects with the value of
     * the promise that rejected, whether or not the other promises have resolved.
     * @param iterable
     */
    ESPromise.all = function (iterable) {
        if (!iterable || !iterable.length) {
            return;
        }
        return new ESPromise(function (resolve, reject) {
            try {
                var values_1 = [];
                var pending_2 = 0;
                for (var lp = 0; lp < iterable.length; lp++) {
                    var item = iterable[lp];
                    // Quick and direct check for a Promise (will also catch a thenable)
                    if (item && _isFunction(item.then)) {
                        pending_2++;
                        item.then(_createPromiseAllOnResolvedFunction(values_1, lp, function () {
                            if (--pending_2 === 0) {
                                resolve(values_1);
                            }
                        }), reject);
                    }
                    else {
                        values_1[lp] = item;
                    }
                }
                if (pending_2 === 0) {
                    // All promises were either resolved or where not a promise
                    setTimeout(function () {
                        resolve(values_1);
                    }, 0);
                }
            }
            catch (error) {
                reject(error);
            }
        });
    };
    /**
     * The race function returns a Promise that is settled the same way (and takes the same value) as the first promise
     * that settles amongst the promises of the iterable passed as an argument.
     * If the iterable passed is empty, the promise returned will be forever pending.
     * If the iterable contains one or more non-promise value and/or an already settled promise, then Promise.race will
     * resolve to the first of these values found in the iterable.
     * @param iterable
     */
    ESPromise.race = function (iterable) {
        return new ESPromise(function (resolve, reject) {
            if (!iterable || !iterable.length) {
                return;
            }
            try {
                var _loop_1 = function (lp) {
                    var item = iterable[lp];
                    // Quick and direct check for a Promise (will also catch a thenable)
                    if (item && _isFunction(item.then)) {
                        item.then(resolve, reject);
                    }
                    else {
                        setTimeout(function () {
                            resolve(item);
                        }, 0);
                    }
                };
                for (var lp = 0; lp < iterable.length; lp++) {
                    _loop_1(lp);
                }
            }
            catch (error) {
                reject(error);
            }
        });
    };
// Removed Stub for ESPromise.prototype.then.
// Removed Stub for ESPromise.prototype["catch"].
    return ESPromise;
}());
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ESPromise);
//# sourceMappingURL=ESPromise.js.map

/***/ }),
/* 51 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(26);
/* harmony import */ var _ESPromise__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(50);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(22);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(27);
/*
 * 1DS JS SDK Core, 3.2.13
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */
/**
* ESPromiseScheduler.ts
* @author Nev Wylie (newylie)
* @copyright Microsoft 2019
*/



/** This is a default timeout that will cause outstanding running promises to be removed/rejected to avoid filling up memory with blocked events */
var LazyRejectPeriod = 600000; // 10 Minutes
// These are global variables that are shared across ALL instances of the scheduler
/**
 * @ignore
 */
var _schedulerId = 0;
/**
 * @ignore
 */
var _running = [];
/**
 * @ignore
 */
var _waiting = [];
/**
 * @ignore
 */
var _timedOut = [];
/**
 * @ignore
 */
function _getTime() {
    return new Date().getTime();
}
/**
 * Provides a simple mechanism queueing mechanism for scheduling events based on the ESPromise callbacks, this is used to ensure
 * order of async operations that are required to be executed in a specific order.
 */
var ESPromiseScheduler = /** @class */ (function () {
    function ESPromiseScheduler(name, diagLog) {
        var _promiseId = 0;
        var _scheduledName = (name || "<unnamed>") + "." + _schedulerId;
        _schedulerId++;
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_0__["default"])(ESPromiseScheduler, this, function (_this) {
            var _lastEvent = null;
            var _eventCount = 0;
            _this.scheduleEvent = function (startEventAction, eventName, timeout) {
                var uniqueId = _scheduledName + "." + _eventCount;
                _eventCount++;
                if (eventName) {
                    uniqueId += "-(" + eventName + ")";
                }
                var uniqueEventId = uniqueId + "{" + _promiseId + "}";
                _promiseId++;
                // Create the next scheduled event details
                var newScheduledEvent = {
                    evt: null,
                    tm: _getTime(),
                    id: uniqueEventId,
                    isRunning: false,
                    isAborted: false
                };
                if (!_lastEvent) {
                    // We don't have any currently running event, so just start the next event
                    newScheduledEvent.evt = _startWaitingEvent(newScheduledEvent);
                }
                else {
                    // Start a new promise which will wait until all current active events are complete before starting
                    // the new event, it does not resolve this scheduled event until after the new event is resolve to
                    // ensure that all scheduled events are completed in the correct order
                    newScheduledEvent.evt = _waitForPreviousEvent(newScheduledEvent, _lastEvent);
                }
                // Set this new event as the last one, so that any future events will wait for this one
                _lastEvent = newScheduledEvent;
                _lastEvent.evt._schId = uniqueEventId;
                return newScheduledEvent.evt;
                function _abortAndRemoveOldEvents(eventQueue) {
                    var now = _getTime();
                    var expired = now - LazyRejectPeriod;
                    var len = eventQueue.length;
                    var lp = 0;
                    while (lp < len) {
                        var evt = eventQueue[lp];
                        if (evt && evt.tm < expired) {
                            var message = null;
                            if (evt.abort) {
                                message = "Aborting [" + evt.id + "] due to Excessive runtime (" + (now - evt.tm) + " ms)";
                                evt.abort(message);
                            }
                            else {
                                message = "Removing [" + evt.id + "] due to Excessive runtime (" + (now - evt.tm) + " ms)";
                            }
                            _warnLog(message);
                            eventQueue.splice(lp, 1);
                            len--;
                        }
                        else {
                            lp++;
                        }
                    }
                }
                function _cleanup(eventId, completed) {
                    var toQueue = false;
                    var removed = _removeQueuedEvent(_running, eventId);
                    if (!removed) {
                        removed = _removeQueuedEvent(_timedOut, eventId);
                        toQueue = true;
                    }
                    if (removed) {
                        if (removed.to) {
                            // If there was a timeout stop it
                            clearTimeout(removed.to);
                            removed.to = null;
                        }
                        // TODO (newylie): Convert this into reportable metrics
                        var tm = _getTime() - removed.tm;
                        if (completed) {
                            if (!toQueue) {
                                _debugLog("Promise [" + eventId + "] Complete -- " + tm + " ms");
                            }
                            else {
                                _warnLog("Timed out event [" + eventId + "] finally complete -- " + tm + " ms");
                            }
                        }
                        else {
                            _timedOut.push(removed);
                            _warnLog("Event [" + eventId + "] Timed out and removed -- " + tm + " ms");
                        }
                    }
                    else {
                        _debugLog("Failed to remove [" + eventId + "] from running queue");
                    }
                    // Also if the last scheduled event was this event then clear it as we are now finished
                    if (_lastEvent && _lastEvent.id === eventId) {
                        _lastEvent = null;
                    }
                    _abortAndRemoveOldEvents(_running);
                    _abortAndRemoveOldEvents(_waiting);
                    _abortAndRemoveOldEvents(_timedOut);
                }
                // Return a callback function that will be called when the waiting promise is resolved or rejected to ensure
                // that any outer promise is also resolved or rejected
                function _removeScheduledEvent(eventId, callback) {
                    return function (value) {
                        _cleanup(eventId, true);
                        callback && callback(value);
                        return value;
                    };
                }
                function _waitForFinalResult(eventId, startResult, schEventResolve, schEventReject) {
                    startResult.then(function (value) {
                        if (value instanceof _ESPromise__WEBPACK_IMPORTED_MODULE_1__["default"]) {
                            // If the result is a promise then this appears to be a chained result, so wait for this promise to complete
                            _debugLog("Event [" + eventId + "] returned a promise -- waiting");
                            _waitForFinalResult(eventId, value, schEventResolve, schEventReject);
                            return value;
                        }
                        else {
                            return _removeScheduledEvent(eventId, schEventResolve)(value);
                        }
                    }, _removeScheduledEvent(eventId, schEventReject));
                }
                // Add the passed event to the active event list with resolve and reject callbacks that will remove
                // it from the active event list
                function _createScheduledEvent(eventDetails, startEvent) {
                    var eventId = eventDetails.id;
                    return new _ESPromise__WEBPACK_IMPORTED_MODULE_1__["default"](function (schEventResolve, schEventReject) {
                        _debugLog("Event [" + eventId + "] Starting -- waited for " + (eventDetails.wTm || "--") + " ms");
                        eventDetails.isRunning = true;
                        eventDetails.abort = function (message) {
                            eventDetails.abort = null;
                            eventDetails.isAborted = true;
                            _cleanup(eventId, false);
                            schEventReject(new Error(message));
                        };
                        var startResult = startEvent(eventId);
                        if (startResult instanceof _ESPromise__WEBPACK_IMPORTED_MODULE_1__["default"]) {
                            if (timeout) {
                                // Note: Only starting a timer if a timeout was specified
                                eventDetails.to = setTimeout(function () {
                                    _cleanup(eventId, false);
                                    // Cause the listeners to reject (Note: We can't actually reject the waiting event)
                                    schEventReject(new Error("Timed out after [" + timeout + "] ms"));
                                }, timeout);
                            }
                            _waitForFinalResult(eventId, startResult, function (theResult) {
                                _debugLog("Event [" + eventId + "] Resolving after " + (_getTime() - eventDetails.tm) + " ms");
                                schEventResolve(theResult);
                            }, schEventReject);
                        }
                        else {
                            // The startEvent didn't return a promise so just return a resolved promise
                            _debugLog("Promise [" + eventId + "] Auto completed as the start action did not return a promise");
                            schEventResolve();
                        }
                    });
                }
                function _startWaitingEvent(eventDetails) {
                    var now = _getTime();
                    eventDetails.wTm = now - eventDetails.tm;
                    eventDetails.tm = now;
                    if (eventDetails.isAborted) {
                        return _ESPromise__WEBPACK_IMPORTED_MODULE_1__["default"].reject(new Error("[" + uniqueId + "] was aborted"));
                    }
                    _running.push(eventDetails);
                    return _createScheduledEvent(eventDetails, startEventAction);
                }
                // Start a new promise which will wait until all current active events are complete before starting
                // the new event, it does not resolve this scheduled event until after the new event is resolve to
                // ensure that all scheduled events are completed in the correct order
                function _waitForPreviousEvent(eventDetails, waitForEvent) {
                    var waitEvent = new _ESPromise__WEBPACK_IMPORTED_MODULE_1__["default"](function (waitResolve, waitReject) {
                        var runTime = _getTime() - waitForEvent.tm;
                        var prevId = waitForEvent.id;
                        _debugLog("[" + uniqueId + "] is waiting for [" + prevId + ":" + runTime + " ms] to complete before starting -- [" + _waiting.length + "] waiting and [" + _running.length + "] running");
                        eventDetails.abort = function (message) {
                            eventDetails.abort = null;
                            _removeQueuedEvent(_waiting, uniqueId);
                            eventDetails.isAborted = true;
                            waitReject(new Error(message));
                        };
                        // Wait for the previous event to complete
                        waitForEvent.evt.then(function (value) {
                            _removeQueuedEvent(_waiting, uniqueId);
                            // Wait for the last event to complete before starting the new one, this ensures the execution
                            // order so that we don't try and remove events that havn't been committed yet
                            _startWaitingEvent(eventDetails).then(waitResolve, waitReject);
                        }, function (reason) {
                            _removeQueuedEvent(_waiting, uniqueId);
                            // Wait for the last event to complete before starting the new one, this ensures the execution
                            // order so that we don't try and remove events that havn't been committed yet
                            _startWaitingEvent(eventDetails).then(waitResolve, waitReject);
                        });
                    });
                    _waiting.push(eventDetails);
                    return waitEvent;
                }
            };
            function _removeQueuedEvent(queue, eventId) {
                for (var lp = 0; lp < queue.length; lp++) {
                    if (queue[lp].id === eventId) {
                        return queue.splice(lp, 1)[0];
                    }
                }
                return null;
            }
        });
        function _debugLog(message) {
            // Only log if running within test harness
            var global = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.getGlobal)();
            if (global && global["QUnit"]) {
                // tslint:disable-next-line:no-console
                console && console.log("ESPromiseScheduler[" + _scheduledName + "] " + message);
            }
        }
        function _warnLog(message) {
            (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__._warnToConsole)(diagLog, "ESPromiseScheduler[" + _scheduledName + "] " + message);
        }
    }
    ESPromiseScheduler.incomplete = function () {
        return _running;
    };
    ESPromiseScheduler.waitingToStart = function () {
        return _waiting;
    };
// Removed Stub for ESPromiseScheduler.prototype.scheduleEvent.
    return ESPromiseScheduler;
}());
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ESPromiseScheduler);
//# sourceMappingURL=ESPromiseScheduler.js.map

/***/ }),
/* 52 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ValueSanitizer": () => (/* binding */ ValueSanitizer)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(18);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(32);
/* harmony import */ var _Utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(33);
/*
 * 1DS JS SDK Core, 3.2.13
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */



var ValueSanitizer = /** @class */ (function () {
    function ValueSanitizer(fieldSanitizerProvider) {
        var _self = this;
        // To aid with performance this is a lookup map to check if the field value sanitizer supports this field
        var _sanitizerMap = {};
        var _sanitizers = [];
        var _fieldSanitizers = [];
        if (fieldSanitizerProvider) {
            _fieldSanitizers.push(fieldSanitizerProvider);
        }
        function _getFieldSanitizer(path, name) {
            var result;
            var fieldLookup = _sanitizerMap[path];
            if (fieldLookup) {
                result = fieldLookup[name];
            }
            if (!result && result !== null) {
                // Null is a valid result indicating that the value sanitizer does not support this field
                if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isString)(path) && (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isString)(name)) {
                    if (_fieldSanitizers.length > 0) {
                        for (var lp = 0; lp < _fieldSanitizers.length; lp++) {
                            if (_fieldSanitizers[lp].handleField(path, name)) {
                                result = {
                                    canHandle: true,
                                    fieldHandler: _fieldSanitizers[lp]
                                };
                                break;
                            }
                        }
                    }
                    else if (_sanitizers.length === 0) {
                        // Special use-case where there is no sanitizer to pass on to, so just resolving the field
                        // and returning the resulting value (same as sanitizeProperty())
                        result = {
                            canHandle: true
                        };
                    }
                }
                // We still don't have a handler so lets lookup the providers
                if (!result && result !== null) {
                    // Setting the result to null -- which means we and any contained sanitizers can't handle this field
                    result = null;
                    for (var lp = 0; lp < _sanitizers.length; lp++) {
                        if (_sanitizers[lp].handleField(path, name)) {
                            result = {
                                canHandle: true,
                                handler: _sanitizers[lp],
                                fieldHandler: null
                            };
                            break;
                        }
                    }
                }
                if (!fieldLookup) {
                    fieldLookup = _sanitizerMap[path] = {};
                }
                fieldLookup[name] = result;
            }
            return result;
        }
        _self.addSanitizer = function (newSanitizer) {
            if (newSanitizer) {
                _sanitizers.push(newSanitizer);
                // Invalidate any previously mapped fields
                _sanitizerMap = {};
            }
        };
        _self.addFieldSanitizer = function (fieldSanitizer) {
            if (fieldSanitizer) {
                _fieldSanitizers.push(fieldSanitizer);
                // Invalidate any previously mapped fields
                _sanitizerMap = {};
            }
        };
        _self.handleField = function (path, name) {
            var mapValue = _getFieldSanitizer(path, name);
            return mapValue ? mapValue.canHandle : false;
        };
        _self.value = function (path, name, value, stringifyObjects) {
            var mapValue = _getFieldSanitizer(path, name);
            if (mapValue && mapValue.canHandle) {
                if (!mapValue || !mapValue.canHandle) {
                    return null;
                }
                if (mapValue.handler) {
                    // This value sanitizer can't handle this field so pass it only the next one
                    return mapValue.handler.value(path, name, value, stringifyObjects);
                }
                // Check that property is valid
                if (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isString)(name) || (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isNullOrUndefined)(value) || value === _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY) {
                    return null;
                }
                var property = null;
                var fieldType = (0,_Utils__WEBPACK_IMPORTED_MODULE_2__.getFieldValueType)(value);
                if ((fieldType & 8192 /* FieldValueSanitizerType.EventProperty */) === 8192 /* FieldValueSanitizerType.EventProperty */) {
                    var subType = fieldType & ~8192 /* FieldValueSanitizerType.EventProperty */;
                    property = value;
                    if (!(0,_Utils__WEBPACK_IMPORTED_MODULE_2__.isValueAssigned)(property.value) ||
                        (subType !== 1 /* FieldValueSanitizerType.String */ &&
                            subType !== 2 /* FieldValueSanitizerType.Number */ &&
                            subType !== 3 /* FieldValueSanitizerType.Boolean */ &&
                            (subType & 4096 /* FieldValueSanitizerType.Array */) !== 4096 /* FieldValueSanitizerType.Array */)) {
                        // Not a supported IEventProperty type to be able to sanitize
                        return null;
                    }
                }
                else if (fieldType === 1 /* FieldValueSanitizerType.String */ ||
                    fieldType === 2 /* FieldValueSanitizerType.Number */ ||
                    fieldType === 3 /* FieldValueSanitizerType.Boolean */ ||
                    (fieldType & 4096 /* FieldValueSanitizerType.Array */) === 4096 /* FieldValueSanitizerType.Array */) {
                    // If the property isn't IEventProperty (and is either string, number, boolean or array), convert it into one.
                    property = _convertToProperty(path, name, value);
                }
                else if (fieldType === 4 /* FieldValueSanitizerType.Object */) {
                    property = _convertToProperty(path, name, !!stringifyObjects ? JSON.stringify(value) : value);
                }
                if (property) {
                    return _handleProperty(mapValue, path, name, fieldType, property, stringifyObjects);
                }
            }
            return null;
        };
        _self.property = function (path, name, property, stringifyObjects) {
            var mapValue = _getFieldSanitizer(path, name);
            if (!mapValue || !mapValue.canHandle) {
                return null;
            }
            // Check that property is valid
            if (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isString)(name) || (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isNullOrUndefined)(property) || !(0,_Utils__WEBPACK_IMPORTED_MODULE_2__.isValueAssigned)(property.value)) {
                return null;
            }
            var fieldType = (0,_Utils__WEBPACK_IMPORTED_MODULE_2__.getFieldValueType)(property.value);
            if (fieldType === 0 /* FieldValueSanitizerType.NotSet */) {
                // Not a supported field that we can sanitize or serialize
                return null;
            }
            return _handleProperty(mapValue, path, name, fieldType, property, stringifyObjects);
        };
        function _handleProperty(mapValue, path, name, fieldType, property, stringifyObjects) {
            if (mapValue.handler) {
                // This value sanitizer can't handle this field so pass it only the next one
                return mapValue.handler.property(path, name, property, stringifyObjects);
            }
            // If either pii or cc is set convert value to string (since only string pii/cc is allowed).
            // If the value is a complex type like an array that can't be converted to string we will drop
            // the property.
            if (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isNullOrUndefined)(property.kind)) {
                if ((fieldType & 4096 /* FieldValueSanitizerType.Array */) === 4096 /* FieldValueSanitizerType.Array */ || !(0,_Utils__WEBPACK_IMPORTED_MODULE_2__.isValueKind)(property.kind)) {
                    return null;
                }
                // Convert the value to a string and assign back to the original value
                property.value = property.value.toString();
            }
            return _callFieldSanitizer(mapValue.fieldHandler, path, name, fieldType, property);
        }
        function _convertToProperty(path, name, value) {
            if ((0,_Utils__WEBPACK_IMPORTED_MODULE_2__.isValueAssigned)(value)) {
                return { value: value };
            }
            return null;
        }
        function _callFieldSanitizer(fieldProvider, path, name, theType, property) {
            if (property && fieldProvider) {
                var sanitizer = fieldProvider.getSanitizer(path, name, theType, property.kind, property.propertyType);
                if (sanitizer) {
                    // This is where we the field will call the handler to "scrub" the value. This the primary hook for the ClientHashing Plugin to
                    // be able to apply the hashFunc() / Sha256 conversion of the properties value
                    if (theType === 4 /* FieldValueSanitizerType.Object */) {
                        // Special case of an embedded object (ext.metadata, data.properties)
                        var newValue_1 = {};
                        var propValue = property.value;
                        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.objForEachKey)(propValue, function (propKey, theValue) {
                            var newPath = path + "." + name;
                            if ((0,_Utils__WEBPACK_IMPORTED_MODULE_2__.isValueAssigned)(theValue)) {
                                var newProp = _convertToProperty(newPath, propKey, theValue);
                                newProp = _callFieldSanitizer(fieldProvider, newPath, propKey, (0,_Utils__WEBPACK_IMPORTED_MODULE_2__.getFieldValueType)(theValue), newProp);
                                if (newProp) {
                                    newValue_1[propKey] = newProp.value;
                                }
                            }
                        });
                        property.value = newValue_1;
                    }
                    else {
                        var details = {
                            path: path,
                            name: name,
                            type: theType,
                            prop: property,
                            sanitizer: _self
                        };
                        property = sanitizer.call(_self, details);
                    }
                }
            }
            return property;
        }
    }
    ValueSanitizer.getFieldType = _Utils__WEBPACK_IMPORTED_MODULE_2__.getFieldValueType;
    return ValueSanitizer;
}());

//# sourceMappingURL=ValueSanitizer.js.map

/***/ }),
/* 53 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MinChannelPriorty": () => (/* binding */ MinChannelPriorty)
/* harmony export */ });
/*
 * Application Insights JavaScript SDK - Core, 2.8.15
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */

var MinChannelPriorty = 100;
//# sourceMappingURL=IChannelControls.js.map

/***/ }),
/* 54 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "EventsDiscardedReason": () => (/* binding */ EventsDiscardedReason)
/* harmony export */ });
/* harmony import */ var _JavaScriptSDK_Enums_EnumHelperFuncs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17);
/*
 * Application Insights JavaScript SDK - Core, 2.8.15
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */



/**
 * The EventsDiscardedReason enumeration contains a set of values that specify the reason for discarding an event.
 */
var EventsDiscardedReason = (0,_JavaScriptSDK_Enums_EnumHelperFuncs__WEBPACK_IMPORTED_MODULE_0__.createEnumStyle)({
    /**
     * Unknown.
     */
    Unknown: 0 /* eEventsDiscardedReason.Unknown */,
    /**
     * Status set to non-retryable.
     */
    NonRetryableStatus: 1 /* eEventsDiscardedReason.NonRetryableStatus */,
    /**
     * The event is invalid.
     */
    InvalidEvent: 2 /* eEventsDiscardedReason.InvalidEvent */,
    /**
     * The size of the event is too large.
     */
    SizeLimitExceeded: 3 /* eEventsDiscardedReason.SizeLimitExceeded */,
    /**
     * The server is not accepting events from this instrumentation key.
     */
    KillSwitch: 4 /* eEventsDiscardedReason.KillSwitch */,
    /**
     * The event queue is full.
     */
    QueueFull: 5 /* eEventsDiscardedReason.QueueFull */
});
//# sourceMappingURL=EventsDiscardedReason.js.map

/***/ }),
/* 55 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BE_PROFILE": () => (/* reexport safe */ _DataModels__WEBPACK_IMPORTED_MODULE_1__.BE_PROFILE),
/* harmony export */   "NRT_PROFILE": () => (/* reexport safe */ _DataModels__WEBPACK_IMPORTED_MODULE_1__.NRT_PROFILE),
/* harmony export */   "PostChannel": () => (/* reexport safe */ _PostChannel__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   "RT_PROFILE": () => (/* reexport safe */ _DataModels__WEBPACK_IMPORTED_MODULE_1__.RT_PROFILE)
/* harmony export */ });
/* harmony import */ var _PostChannel__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(56);
/* harmony import */ var _DataModels__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(60);
/*
 * 1DS JS SDK POST plugin, 3.2.13
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */
/**
* @name Index.ts
* @author Abhilash Panwar (abpanwar)
* @copyright Microsoft 2018
* File to export public classes.
*/



//# sourceMappingURL=Index.js.map

/***/ }),
/* 56 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(57);
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(61);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(37);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(38);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(33);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(18);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(28);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(54);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(27);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(46);
/* harmony import */ var _DataModels__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(60);
/* harmony import */ var _EventBatch__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(64);
/* harmony import */ var _HttpManager__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(65);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(63);
/* harmony import */ var _RetryPolicy__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(69);
/* harmony import */ var _TimeoutOverrideWrapper__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(62);
/*
 * 1DS JS SDK POST plugin, 3.2.13
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */

/**
* PostManager.ts
* @author Abhilash Panwar (abpanwar); Hector Hernandez (hectorh); Nev Wylie (newylie)
* @copyright Microsoft 2018-2020
*/








var FlushCheckTimer = 0.250; // This needs to be in seconds, so this is 250ms
var MaxNumberEventPerBatch = 500;
var EventsDroppedAtOneTime = 20;
var MaxSendAttempts = 6;
var MaxSyncUnloadSendAttempts = 2; // Assuming 2 based on beforeunload and unload
var MaxBackoffCount = 4;
var MaxConnections = 2;
var MaxRequestRetriesBeforeBackoff = 1;
var strEventsDiscarded = "eventsDiscarded";
var strOverrideInstrumentationKey = "overrideInstrumentationKey";
var strMaxEventRetryAttempts = "maxEventRetryAttempts";
var strMaxUnloadEventRetryAttempts = "maxUnloadEventRetryAttempts";
var strAddUnloadCb = "addUnloadCb";
/**
 * Class that manages adding events to inbound queues and batching of events
 * into requests.
 */
var PostChannel = /** @class */ (function (_super) {
    (0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.__extendsFn)(PostChannel, _super);
    function PostChannel() {
        var _this = _super.call(this) || this;
        _this.identifier = "PostChannel";
        _this.priority = 1011;
        _this.version = '3.2.13';
        var _config;
        var _isTeardownCalled = false;
        var _flushCallbackQueue = [];
        var _flushCallbackTimerId = null;
        var _paused = false;
        var _immediateQueueSize = 0;
        var _immediateQueueSizeLimit = 500;
        var _queueSize = 0;
        var _queueSizeLimit = 10000;
        var _profiles = {};
        var _currentProfile = _DataModels__WEBPACK_IMPORTED_MODULE_1__.RT_PROFILE;
        var _scheduledTimerId = null;
        var _immediateTimerId = null;
        var _currentBackoffCount = 0;
        var _timerCount = 0;
        var _xhrOverride;
        var _httpManager;
        var _batchQueues = {};
        var _autoFlushEventsLimit;
        // either MaxBatchSize * (1+ Max Connections) or _queueLimit / 6 (where 3 latency Queues [normal, realtime, cost deferred] * 2 [allow half full -- allow for retry])
        var _autoFlushBatchLimit;
        var _delayedBatchSendLatency = -1;
        var _delayedBatchReason;
        var _optimizeObject = true;
        var _isPageUnloadTriggered = false;
        var _maxEventSendAttempts = MaxSendAttempts;
        var _maxUnloadEventSendAttempts = MaxSyncUnloadSendAttempts;
        var _evtNamespace;
        var _timeoutWrapper;
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_2__["default"])(PostChannel, _this, function (_self, _base) {
            _initDefaults();
            // Special internal method to allow the DebugPlugin to hook embedded objects
            _self["_getDbgPlgTargets"] = function () {
                return [_httpManager];
            };
            _self.initialize = function (coreConfig, core, extensions) {
                (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_3__.doPerf)(core, function () { return "PostChannel:initialize"; }, function () {
                    var extendedCore = core;
                    _base.initialize(coreConfig, core, extensions);
                    try {
                        var hasAddUnloadCb = !!core[strAddUnloadCb];
                        _evtNamespace = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_4__.mergeEvtNamespace)((0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_5__.createUniqueNamespace)(_self.identifier), core.evtNamespace && core.evtNamespace());
                        var ctx = _self._getTelCtx();
                        coreConfig.extensionConfig[_self.identifier] = coreConfig.extensionConfig[_self.identifier] || {};
                        _config = ctx.getExtCfg(_self.identifier);
                        _timeoutWrapper = (0,_TimeoutOverrideWrapper__WEBPACK_IMPORTED_MODULE_6__.createTimeoutWrapper)(_config.setTimeoutOverride, _config.clearTimeoutOverride);
                        // Only try and use the optimizeObject() if this appears to be a chromium based browser and it has not been explicitly disabled
                        _optimizeObject = !_config.disableOptimizeObj && (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_7__.isChromium)();
                        _hookWParam(extendedCore);
                        if (_config.eventsLimitInMem > 0) {
                            _queueSizeLimit = _config.eventsLimitInMem;
                        }
                        if (_config.immediateEventLimit > 0) {
                            _immediateQueueSizeLimit = _config.immediateEventLimit;
                        }
                        if (_config.autoFlushEventsLimit > 0) {
                            _autoFlushEventsLimit = _config.autoFlushEventsLimit;
                        }
                        if ((0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.isNumber)(_config[strMaxEventRetryAttempts])) {
                            _maxEventSendAttempts = _config[strMaxEventRetryAttempts];
                        }
                        if ((0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.isNumber)(_config[strMaxUnloadEventRetryAttempts])) {
                            _maxUnloadEventSendAttempts = _config[strMaxUnloadEventRetryAttempts];
                        }
                        _setAutoLimits();
                        if (_config.httpXHROverride && _config.httpXHROverride.sendPOST) {
                            _xhrOverride = _config.httpXHROverride;
                        }
                        if ((0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_7__.isValueAssigned)(coreConfig.anonCookieName)) {
                            _httpManager.addQueryStringParameter("anoncknm", coreConfig.anonCookieName);
                        }
                        _httpManager.sendHook = _config.payloadPreprocessor;
                        _httpManager.sendListener = _config.payloadListener;
                        // Override endpointUrl if provided in Post config
                        var endpointUrl = _config.overrideEndpointUrl ? _config.overrideEndpointUrl : coreConfig.endpointUrl;
                        _self._notificationManager = core.getNotifyMgr();
                        _httpManager.initialize(endpointUrl, _self.core, _self, _xhrOverride, _config);
                        var excludePageUnloadEvents = coreConfig.disablePageUnloadEvents || [];
                        // When running in Web browsers try to send all telemetry if page is unloaded
                        (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_4__.addPageUnloadEventListener)(_handleUnloadEvents, excludePageUnloadEvents, _evtNamespace);
                        (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_4__.addPageHideEventListener)(_handleUnloadEvents, excludePageUnloadEvents, _evtNamespace);
                        (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_4__.addPageShowEventListener)(_handleShowEvents, coreConfig.disablePageShowEvents, _evtNamespace);
                    }
                    catch (e) {
                        // resetting the initialized state because of failure
                        _self.setInitialized(false);
                        throw e;
                    }
                }, function () { return ({ coreConfig: coreConfig, core: core, extensions: extensions }); });
            };
            _self.processTelemetry = function (ev, itemCtx) {
                (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_7__.setProcessTelemetryTimings)(ev, _self.identifier);
                itemCtx = _self._getTelCtx(itemCtx);
                // Get the channel instance from the current request/instance
                var channelConfig = itemCtx.getExtCfg(_self.identifier);
                // DisableTelemetry was defined in the config provided during initialization
                var disableTelemetry = !!_config.disableTelemetry;
                if (channelConfig) {
                    // DisableTelemetry is defined in the config for this request/instance
                    disableTelemetry = disableTelemetry || !!channelConfig.disableTelemetry;
                }
                var event = ev;
                if (!disableTelemetry && !_isTeardownCalled) {
                    // Override iKey if provided in Post config if provided for during initialization
                    if (_config[strOverrideInstrumentationKey]) {
                        event.iKey = _config[strOverrideInstrumentationKey];
                    }
                    // Override iKey if provided in Post config if provided for this instance
                    if (channelConfig && channelConfig[strOverrideInstrumentationKey]) {
                        event.iKey = channelConfig[strOverrideInstrumentationKey];
                    }
                    _addEventToQueues(event, true);
                    if (_isPageUnloadTriggered) {
                        // Unload event has been received so we need to try and flush new events
                        _releaseAllQueues(2 /* EventSendType.SendBeacon */, 2 /* SendRequestReason.Unload */);
                    }
                    else {
                        _scheduleTimer();
                    }
                }
                _self.processNext(event, itemCtx);
            };
            _self._doTeardown = function (unloadCtx, unloadState) {
                _releaseAllQueues(2 /* EventSendType.SendBeacon */, 2 /* SendRequestReason.Unload */);
                _isTeardownCalled = true;
                _httpManager.teardown();
                (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_4__.removePageUnloadEventListener)(null, _evtNamespace);
                (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_4__.removePageHideEventListener)(null, _evtNamespace);
                (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_4__.removePageShowEventListener)(null, _evtNamespace);
                // Just register to remove all events associated with this namespace
                _initDefaults();
            };
            function _hookWParam(extendedCore) {
                var existingGetWParamMethod = extendedCore.getWParam;
                extendedCore.getWParam = function () {
                    var wparam = 0;
                    if (_config.ignoreMc1Ms0CookieProcessing) {
                        wparam = wparam | 2;
                    }
                    return wparam | existingGetWParamMethod();
                };
            }
            // Moving event handlers out from the initialize closure so that any local variables can be garbage collected
            function _handleUnloadEvents(evt) {
                var theEvt = evt || (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_9__.getWindow)().event; // IE 8 does not pass the event
                if (theEvt.type !== "beforeunload") {
                    // Only set the unload trigger if not beforeunload event as beforeunload can be cancelled while the other events can't
                    _isPageUnloadTriggered = true;
                    _httpManager.setUnloading(_isPageUnloadTriggered);
                }
                _releaseAllQueues(2 /* EventSendType.SendBeacon */, 2 /* SendRequestReason.Unload */);
            }
            function _handleShowEvents(evt) {
                // Handle the page becoming visible again
                _isPageUnloadTriggered = false;
                _httpManager.setUnloading(_isPageUnloadTriggered);
            }
            function _addEventToQueues(event, append) {
                // If send attempt field is undefined we should set it to 0.
                if (!event.sendAttempt) {
                    event.sendAttempt = 0;
                }
                // Add default latency
                if (!event.latency) {
                    event.latency = 1 /* EventLatencyValue.Normal */;
                }
                // Remove extra AI properties if present
                if (event.ext && event.ext[_InternalConstants__WEBPACK_IMPORTED_MODULE_10__.STR_TRACE]) {
                    delete (event.ext[_InternalConstants__WEBPACK_IMPORTED_MODULE_10__.STR_TRACE]);
                }
                if (event.ext && event.ext[_InternalConstants__WEBPACK_IMPORTED_MODULE_10__.STR_USER] && event.ext[_InternalConstants__WEBPACK_IMPORTED_MODULE_10__.STR_USER]["id"]) {
                    delete (event.ext[_InternalConstants__WEBPACK_IMPORTED_MODULE_10__.STR_USER]["id"]);
                }
                // v8 performance optimization for iterating over the keys
                if (_optimizeObject) {
                    _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_7__.setProcessTelemetryTimings;
                    event.ext = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.optimizeObject)(event.ext);
                    if (event.baseData) {
                        event.baseData = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.optimizeObject)(event.baseData);
                    }
                    if (event.data) {
                        event.data = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.optimizeObject)(event.data);
                    }
                }
                if (event.sync) {
                    // If the transmission is backed off then do not send synchronous events.
                    // We will convert these events to Real time latency instead.
                    if (_currentBackoffCount || _paused) {
                        event.latency = 3 /* EventLatencyValue.RealTime */;
                        event.sync = false;
                    }
                    else {
                        // Log the event synchronously
                        if (_httpManager) {
                            // v8 performance optimization for iterating over the keys
                            if (_optimizeObject) {
                                event = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.optimizeObject)(event);
                            }
                            _httpManager.sendSynchronousBatch(_EventBatch__WEBPACK_IMPORTED_MODULE_11__.EventBatch.create(event.iKey, [event]), event.sync === true ? 1 /* EventSendType.Synchronous */ : event.sync, 3 /* SendRequestReason.SyncEvent */);
                            return;
                        }
                    }
                }
                var evtLatency = event.latency;
                var queueSize = _queueSize;
                var queueLimit = _queueSizeLimit;
                if (evtLatency === 4 /* EventLatencyValue.Immediate */) {
                    queueSize = _immediateQueueSize;
                    queueLimit = _immediateQueueSizeLimit;
                }
                var eventDropped = false;
                // Only add the event if the queue isn't full or it's a direct event (which don't add to the queue sizes)
                if (queueSize < queueLimit) {
                    eventDropped = !_addEventToProperQueue(event, append);
                }
                else {
                    var dropLatency = 1 /* EventLatencyValue.Normal */;
                    var dropNumber = EventsDroppedAtOneTime;
                    if (evtLatency === 4 /* EventLatencyValue.Immediate */) {
                        // Only drop other immediate events as they are not technically sharing the general queue
                        dropLatency = 4 /* EventLatencyValue.Immediate */;
                        dropNumber = 1;
                    }
                    // Drop old event from lower or equal latency
                    eventDropped = true;
                    if (_dropEventWithLatencyOrLess(event.iKey, event.latency, dropLatency, dropNumber)) {
                        eventDropped = !_addEventToProperQueue(event, append);
                    }
                }
                if (eventDropped) {
                    // Can't drop events from current queues because the all the slots are taken by queues that are being flushed.
                    _notifyEvents(strEventsDiscarded, [event], _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_12__.EventsDiscardedReason.QueueFull);
                }
            }
            _self.setEventQueueLimits = function (eventLimit, autoFlushLimit) {
                _queueSizeLimit = eventLimit > 0 ? eventLimit : 10000;
                _autoFlushEventsLimit = autoFlushLimit > 0 ? autoFlushLimit : 0;
                _setAutoLimits();
                // We only do this check here as during normal event addition if the queue is > then events start getting dropped
                var doFlush = _queueSize > eventLimit;
                if (!doFlush && _autoFlushBatchLimit > 0) {
                    // Check the auto flush max batch size
                    for (var latency = 1 /* EventLatencyValue.Normal */; !doFlush && latency <= 3 /* EventLatencyValue.RealTime */; latency++) {
                        var batchQueue = _batchQueues[latency];
                        if (batchQueue && batchQueue.batches) {
                            (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.arrForEach)(batchQueue.batches, function (theBatch) {
                                if (theBatch && theBatch.count() >= _autoFlushBatchLimit) {
                                    // If any 1 batch is > than the limit then trigger an auto flush
                                    doFlush = true;
                                }
                            });
                        }
                    }
                }
                _performAutoFlush(true, doFlush);
            };
            _self.pause = function () {
                _clearScheduledTimer();
                _paused = true;
                _httpManager.pause();
            };
            _self.resume = function () {
                _paused = false;
                _httpManager.resume();
                _scheduleTimer();
            };
            _self.addResponseHandler = function (responseHandler) {
                _httpManager._responseHandlers.push(responseHandler);
            };
            _self._loadTransmitProfiles = function (profiles) {
                _resetTransmitProfiles();
                (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.objForEachKey)(profiles, function (profileName, profileValue) {
                    var profLen = profileValue.length;
                    if (profLen >= 2) {
                        var directValue = (profLen > 2 ? profileValue[2] : 0);
                        profileValue.splice(0, profLen - 2);
                        // Make sure if a higher latency is set to not send then don't send lower latency
                        if (profileValue[1] < 0) {
                            profileValue[0] = -1;
                        }
                        // Make sure each latency is multiple of the latency higher then it. If not a multiple
                        // we round up so that it becomes a multiple.
                        if (profileValue[1] > 0 && profileValue[0] > 0) {
                            var timerMultiplier = profileValue[0] / profileValue[1];
                            profileValue[0] = Math.ceil(timerMultiplier) * profileValue[1];
                        }
                        // Add back the direct profile timeout
                        if (directValue >= 0 && profileValue[1] >= 0 && directValue > profileValue[1]) {
                            // Make sure if it's not disabled (< 0) then make sure it's not larger than RealTime
                            directValue = profileValue[1];
                        }
                        profileValue.push(directValue);
                        _profiles[profileName] = profileValue;
                    }
                });
            };
            _self.flush = function (async, callback, sendReason) {
                if (async === void 0) { async = true; }
                if (!_paused) {
                    sendReason = sendReason || 1 /* SendRequestReason.ManualFlush */;
                    if (async) {
                        if (_flushCallbackTimerId == null) {
                            // Clear the normal schedule timer as we are going to try and flush ASAP
                            _clearScheduledTimer();
                            // Move all queued events to the HttpManager so that we don't discard new events (Auto flush scenario)
                            _queueBatches(1 /* EventLatencyValue.Normal */, 0 /* EventSendType.Batched */, sendReason);
                            _flushCallbackTimerId = _createTimer(function () {
                                _flushCallbackTimerId = null;
                                _flushImpl(callback, sendReason);
                            }, 0);
                        }
                        else {
                            // Even if null (no callback) this will ensure after the flushImpl finishes waiting
                            // for a completely idle connection it will attempt to re-flush any queued events on the next cycle
                            _flushCallbackQueue.push(callback);
                        }
                    }
                    else {
                        // Clear the normal schedule timer as we are going to try and flush ASAP
                        var cleared = _clearScheduledTimer();
                        // Now cause all queued events to be sent synchronously
                        _sendEventsForLatencyAndAbove(1 /* EventLatencyValue.Normal */, 1 /* EventSendType.Synchronous */, sendReason);
                        if (callback !== null && callback !== undefined) {
                            callback();
                        }
                        if (cleared) {
                            // restart the normal event timer if it was cleared
                            _scheduleTimer();
                        }
                    }
                }
            };
            _self.setMsaAuthTicket = function (ticket) {
                _httpManager.addHeader(_InternalConstants__WEBPACK_IMPORTED_MODULE_10__.STR_MSA_DEVICE_TICKET, ticket);
            };
            _self.hasEvents = _hasEvents;
            _self._setTransmitProfile = function (profileName) {
                if (_currentProfile !== profileName && _profiles[profileName] !== undefined) {
                    _clearScheduledTimer();
                    _currentProfile = profileName;
                    _scheduleTimer();
                }
            };
            /**
             * Batch and send events currently in the queue for the given latency.
             * @param latency - Latency for which to send events.
             */
            function _sendEventsForLatencyAndAbove(latency, sendType, sendReason) {
                var queued = _queueBatches(latency, sendType, sendReason);
                // Always trigger the request as while the post channel may not have queued additional events, the httpManager may already have waiting events
                _httpManager.sendQueuedRequests(sendType, sendReason);
                return queued;
            }
            function _hasEvents() {
                return _queueSize > 0;
            }
            /**
             * Try to schedule the timer after which events will be sent. If there are
             * no events to be sent, or there is already a timer scheduled, or the
             * http manager doesn't have any idle connections this method is no-op.
             */
            function _scheduleTimer() {
                // If we had previously attempted to send requests, but the http manager didn't have any idle connections then the requests where delayed
                // so try and requeue then again now
                if (_delayedBatchSendLatency >= 0 && _queueBatches(_delayedBatchSendLatency, 0 /* EventSendType.Batched */, _delayedBatchReason)) {
                    _httpManager.sendQueuedRequests(0 /* EventSendType.Batched */, _delayedBatchReason);
                }
                if (_immediateQueueSize > 0 && !_immediateTimerId && !_paused) {
                    // During initialization _profiles enforce that the direct [2] is less than real time [1] timer value
                    // If the immediateTimeout is disabled the immediate events will be sent with Real Time events
                    var immediateTimeOut = _profiles[_currentProfile][2];
                    if (immediateTimeOut >= 0) {
                        _immediateTimerId = _createTimer(function () {
                            _immediateTimerId = null;
                            // Only try to send direct events
                            _sendEventsForLatencyAndAbove(4 /* EventLatencyValue.Immediate */, 0 /* EventSendType.Batched */, 1 /* SendRequestReason.NormalSchedule */);
                            _scheduleTimer();
                        }, immediateTimeOut);
                    }
                }
                // During initialization the _profiles enforce that the normal [0] is a multiple of the real time [1] timer value
                var timeOut = _profiles[_currentProfile][1];
                if (!_scheduledTimerId && !_flushCallbackTimerId && timeOut >= 0 && !_paused) {
                    if (_hasEvents()) {
                        _scheduledTimerId = _createTimer(function () {
                            _scheduledTimerId = null;
                            _sendEventsForLatencyAndAbove(_timerCount === 0 ? 3 /* EventLatencyValue.RealTime */ : 1 /* EventLatencyValue.Normal */, 0 /* EventSendType.Batched */, 1 /* SendRequestReason.NormalSchedule */);
                            // Increment the count for next cycle
                            _timerCount++;
                            _timerCount %= 2;
                            _scheduleTimer();
                        }, timeOut);
                    }
                    else {
                        _timerCount = 0;
                    }
                }
            }
            _self._backOffTransmission = function () {
                if (_currentBackoffCount < MaxBackoffCount) {
                    _currentBackoffCount++;
                    _clearScheduledTimer();
                    _scheduleTimer();
                }
            };
            _self._clearBackOff = function () {
                if (_currentBackoffCount) {
                    _currentBackoffCount = 0;
                    _clearScheduledTimer();
                    _scheduleTimer();
                }
            };
            function _initDefaults() {
                _config = null;
                _isTeardownCalled = false;
                _flushCallbackQueue = [];
                _flushCallbackTimerId = null;
                _paused = false;
                _immediateQueueSize = 0;
                _immediateQueueSizeLimit = 500;
                _queueSize = 0;
                _queueSizeLimit = 10000;
                _profiles = {};
                _currentProfile = _DataModels__WEBPACK_IMPORTED_MODULE_1__.RT_PROFILE;
                _scheduledTimerId = null;
                _immediateTimerId = null;
                _currentBackoffCount = 0;
                _timerCount = 0;
                _xhrOverride = null;
                _batchQueues = {};
                _autoFlushEventsLimit = undefined;
                // either MaxBatchSize * (1+ Max Connections) or _queueLimit / 6 (where 3 latency Queues [normal, realtime, cost deferred] * 2 [allow half full -- allow for retry])
                _autoFlushBatchLimit = 0;
                _delayedBatchSendLatency = -1;
                _delayedBatchReason = null;
                _optimizeObject = true;
                _isPageUnloadTriggered = false;
                _maxEventSendAttempts = MaxSendAttempts;
                _maxUnloadEventSendAttempts = MaxSyncUnloadSendAttempts;
                _evtNamespace = null;
                _timeoutWrapper = (0,_TimeoutOverrideWrapper__WEBPACK_IMPORTED_MODULE_6__.createTimeoutWrapper)();
                _httpManager = new _HttpManager__WEBPACK_IMPORTED_MODULE_13__.HttpManager(MaxNumberEventPerBatch, MaxConnections, MaxRequestRetriesBeforeBackoff, {
                    requeue: _requeueEvents,
                    send: _sendingEvent,
                    sent: _eventsSentEvent,
                    drop: _eventsDropped,
                    rspFail: _eventsResponseFail,
                    oth: _otherEvent
                }, _timeoutWrapper);
                _initializeProfiles();
                _clearQueues();
                _setAutoLimits();
            }
            function _createTimer(theTimerFunc, timeOut) {
                // If the transmission is backed off make the timer at least 1 sec to allow for back off.
                if (timeOut === 0 && _currentBackoffCount) {
                    timeOut = 1;
                }
                var timerMultiplier = 1000;
                if (_currentBackoffCount) {
                    timerMultiplier = (0,_RetryPolicy__WEBPACK_IMPORTED_MODULE_14__.retryPolicyGetMillisToBackoffForRetry)(_currentBackoffCount - 1);
                }
                return _timeoutWrapper.set(theTimerFunc, timeOut * timerMultiplier);
            }
            function _clearScheduledTimer() {
                if (_scheduledTimerId !== null) {
                    _timeoutWrapper.clear(_scheduledTimerId);
                    _scheduledTimerId = null;
                    _timerCount = 0;
                    return true;
                }
                return false;
            }
            // Try to send all queued events using beacons if available
            function _releaseAllQueues(sendType, sendReason) {
                _clearScheduledTimer();
                // Cancel all flush callbacks
                if (_flushCallbackTimerId) {
                    _timeoutWrapper.clear(_flushCallbackTimerId);
                    _flushCallbackTimerId = null;
                }
                if (!_paused) {
                    // Queue all the remaining requests to be sent. The requests will be sent using HTML5 Beacons if they are available.
                    _sendEventsForLatencyAndAbove(1 /* EventLatencyValue.Normal */, sendType, sendReason);
                }
            }
            /**
             * Add empty queues for all latencies in the inbound queues map. This is called
             * when Transmission Manager is being flushed. This ensures that new events added
             * after flush are stored separately till we flush the current events.
             */
            function _clearQueues() {
                _batchQueues[4 /* EventLatencyValue.Immediate */] = {
                    batches: [],
                    iKeyMap: {}
                };
                _batchQueues[3 /* EventLatencyValue.RealTime */] = {
                    batches: [],
                    iKeyMap: {}
                };
                _batchQueues[2 /* EventLatencyValue.CostDeferred */] = {
                    batches: [],
                    iKeyMap: {}
                };
                _batchQueues[1 /* EventLatencyValue.Normal */] = {
                    batches: [],
                    iKeyMap: {}
                };
            }
            function _getEventBatch(iKey, latency, create) {
                var batchQueue = _batchQueues[latency];
                if (!batchQueue) {
                    latency = 1 /* EventLatencyValue.Normal */;
                    batchQueue = _batchQueues[latency];
                }
                var eventBatch = batchQueue.iKeyMap[iKey];
                if (!eventBatch && create) {
                    eventBatch = _EventBatch__WEBPACK_IMPORTED_MODULE_11__.EventBatch.create(iKey);
                    batchQueue.batches.push(eventBatch);
                    batchQueue.iKeyMap[iKey] = eventBatch;
                }
                return eventBatch;
            }
            function _performAutoFlush(isAsync, doFlush) {
                // Only perform the auto flush check if the httpManager has an idle connection and we are not in a backoff situation
                if (_httpManager.canSendRequest() && !_currentBackoffCount) {
                    if (_autoFlushEventsLimit > 0 && _queueSize > _autoFlushEventsLimit) {
                        // Force flushing
                        doFlush = true;
                    }
                    if (doFlush && _flushCallbackTimerId == null) {
                        // Auto flush the queue
                        _self.flush(isAsync, null, 20 /* SendRequestReason.MaxQueuedEvents */);
                    }
                }
            }
            function _addEventToProperQueue(event, append) {
                // v8 performance optimization for iterating over the keys
                if (_optimizeObject) {
                    event = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.optimizeObject)(event);
                }
                var latency = event.latency;
                var eventBatch = _getEventBatch(event.iKey, latency, true);
                if (eventBatch.addEvent(event)) {
                    if (latency !== 4 /* EventLatencyValue.Immediate */) {
                        _queueSize++;
                        // Check for auto flushing based on total events in the queue, but not for requeued or retry events
                        if (append && event.sendAttempt === 0) {
                            // Force the flushing of the batch if the batch (specific iKey / latency combination) reaches it's auto flush limit
                            _performAutoFlush(!event.sync, _autoFlushBatchLimit > 0 && eventBatch.count() >= _autoFlushBatchLimit);
                        }
                    }
                    else {
                        // Direct events don't need auto flushing as they are scheduled (by default) for immediate delivery
                        _immediateQueueSize++;
                    }
                    return true;
                }
                return false;
            }
            function _dropEventWithLatencyOrLess(iKey, latency, currentLatency, dropNumber) {
                while (currentLatency <= latency) {
                    var eventBatch = _getEventBatch(iKey, latency, true);
                    if (eventBatch && eventBatch.count() > 0) {
                        // Dropped oldest events from lowest possible latency
                        var droppedEvents = eventBatch.split(0, dropNumber);
                        var droppedCount = droppedEvents.count();
                        if (droppedCount > 0) {
                            if (currentLatency === 4 /* EventLatencyValue.Immediate */) {
                                _immediateQueueSize -= droppedCount;
                            }
                            else {
                                _queueSize -= droppedCount;
                            }
                            _notifyBatchEvents(strEventsDiscarded, [droppedEvents], _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_12__.EventsDiscardedReason.QueueFull);
                            return true;
                        }
                    }
                    currentLatency++;
                }
                // Unable to drop any events -- lets just make sure the queue counts are correct to avoid exhaustion
                _resetQueueCounts();
                return false;
            }
            /**
             * Internal helper to reset the queue counts, used as a backstop to avoid future queue exhaustion errors
             * that might occur because of counting issues.
             */
            function _resetQueueCounts() {
                var immediateQueue = 0;
                var normalQueue = 0;
                var _loop_1 = function (latency) {
                    var batchQueue = _batchQueues[latency];
                    if (batchQueue && batchQueue.batches) {
                        (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.arrForEach)(batchQueue.batches, function (theBatch) {
                            if (latency === 4 /* EventLatencyValue.Immediate */) {
                                immediateQueue += theBatch.count();
                            }
                            else {
                                normalQueue += theBatch.count();
                            }
                        });
                    }
                };
                for (var latency = 1 /* EventLatencyValue.Normal */; latency <= 4 /* EventLatencyValue.Immediate */; latency++) {
                    _loop_1(latency);
                }
                _queueSize = normalQueue;
                _immediateQueueSize = immediateQueue;
            }
            function _queueBatches(latency, sendType, sendReason) {
                var eventsQueued = false;
                var isAsync = sendType === 0 /* EventSendType.Batched */;
                // Only queue batches (to the HttpManager) if this is a sync request or the httpManager has an idle connection
                // Thus keeping the events within the PostChannel until the HttpManager has a connection available
                // This is so we can drop "old" events if the queue is getting full because we can't successfully send events
                if (!isAsync || _httpManager.canSendRequest()) {
                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_3__.doPerf)(_self.core, function () { return "PostChannel._queueBatches"; }, function () {
                        var droppedEvents = [];
                        var latencyToProcess = 4 /* EventLatencyValue.Immediate */;
                        while (latencyToProcess >= latency) {
                            var batchQueue = _batchQueues[latencyToProcess];
                            if (batchQueue && batchQueue.batches && batchQueue.batches.length > 0) {
                                (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.arrForEach)(batchQueue.batches, function (theBatch) {
                                    // Add the batch to the http manager to send the requests
                                    if (!_httpManager.addBatch(theBatch)) {
                                        // The events from this iKey are being dropped (killed)
                                        droppedEvents = droppedEvents.concat(theBatch.events());
                                    }
                                    else {
                                        eventsQueued = eventsQueued || (theBatch && theBatch.count() > 0);
                                    }
                                    if (latencyToProcess === 4 /* EventLatencyValue.Immediate */) {
                                        _immediateQueueSize -= theBatch.count();
                                    }
                                    else {
                                        _queueSize -= theBatch.count();
                                    }
                                });
                                // Remove all batches from this Queue
                                batchQueue.batches = [];
                                batchQueue.iKeyMap = {};
                            }
                            latencyToProcess--;
                        }
                        if (droppedEvents.length > 0) {
                            _notifyEvents(strEventsDiscarded, droppedEvents, _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_12__.EventsDiscardedReason.KillSwitch);
                        }
                        if (eventsQueued && _delayedBatchSendLatency >= latency) {
                            // We have queued events at the same level as the delayed values so clear the setting
                            _delayedBatchSendLatency = -1;
                            _delayedBatchReason = 0 /* SendRequestReason.Undefined */;
                        }
                    }, function () { return ({ latency: latency, sendType: sendType, sendReason: sendReason }); }, !isAsync);
                }
                else {
                    // remember the min latency so that we can re-trigger later
                    _delayedBatchSendLatency = _delayedBatchSendLatency >= 0 ? Math.min(_delayedBatchSendLatency, latency) : latency;
                    _delayedBatchReason = Math.max(_delayedBatchReason, sendReason);
                }
                return eventsQueued;
            }
            /**
             * This is the callback method is called as part of the manual flushing process.
             * @param callback
             * @param sendReason
             */
            function _flushImpl(callback, sendReason) {
                // Add any additional queued events and cause all queued events to be sent asynchronously
                _sendEventsForLatencyAndAbove(1 /* EventLatencyValue.Normal */, 0 /* EventSendType.Batched */, sendReason);
                // All events (should) have been queue -- lets just make sure the queue counts are correct to avoid queue exhaustion (previous bug #9685112)
                _resetQueueCounts();
                _waitForIdleManager(function () {
                    // Only called AFTER the httpManager does not have any outstanding requests
                    if (callback) {
                        callback();
                    }
                    if (_flushCallbackQueue.length > 0) {
                        _flushCallbackTimerId = _createTimer(function () {
                            _flushCallbackTimerId = null;
                            _flushImpl(_flushCallbackQueue.shift(), sendReason);
                        }, 0);
                    }
                    else {
                        // No more flush requests
                        _flushCallbackTimerId = null;
                        // Restart the normal timer schedule
                        _scheduleTimer();
                    }
                });
            }
            function _waitForIdleManager(callback) {
                if (_httpManager.isCompletelyIdle()) {
                    callback();
                }
                else {
                    _flushCallbackTimerId = _createTimer(function () {
                        _flushCallbackTimerId = null;
                        _waitForIdleManager(callback);
                    }, FlushCheckTimer);
                }
            }
            /**
             * Resets the transmit profiles to the default profiles of Real Time, Near Real Time
             * and Best Effort. This removes all the custom profiles that were loaded.
             */
            function _resetTransmitProfiles() {
                _clearScheduledTimer();
                _initializeProfiles();
                _currentProfile = _DataModels__WEBPACK_IMPORTED_MODULE_1__.RT_PROFILE;
                _scheduleTimer();
            }
            function _initializeProfiles() {
                _profiles = {};
                _profiles[_DataModels__WEBPACK_IMPORTED_MODULE_1__.RT_PROFILE] = [2, 1, 0];
                _profiles[_DataModels__WEBPACK_IMPORTED_MODULE_1__.NRT_PROFILE] = [6, 3, 0];
                _profiles[_DataModels__WEBPACK_IMPORTED_MODULE_1__.BE_PROFILE] = [18, 9, 0];
            }
            /**
             * The notification handler for requeue events
             * @ignore
             */
            function _requeueEvents(batches, reason) {
                var droppedEvents = [];
                var maxSendAttempts = _maxEventSendAttempts;
                if (_isPageUnloadTriggered) {
                    // If a page unlaod has been triggered reduce the number of times we try to "retry"
                    maxSendAttempts = _maxUnloadEventSendAttempts;
                }
                (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.arrForEach)(batches, function (theBatch) {
                    if (theBatch && theBatch.count() > 0) {
                        (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.arrForEach)(theBatch.events(), function (theEvent) {
                            if (theEvent) {
                                // Check if the request being added back is for a sync event in which case mark it no longer a sync event
                                if (theEvent.sync) {
                                    theEvent.latency = 4 /* EventLatencyValue.Immediate */;
                                    theEvent.sync = false;
                                }
                                if (theEvent.sendAttempt < maxSendAttempts) {
                                    // Reset the event timings
                                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_7__.setProcessTelemetryTimings)(theEvent, _self.identifier);
                                    _addEventToQueues(theEvent, false);
                                }
                                else {
                                    droppedEvents.push(theEvent);
                                }
                            }
                        });
                    }
                });
                if (droppedEvents.length > 0) {
                    _notifyEvents(strEventsDiscarded, droppedEvents, _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_12__.EventsDiscardedReason.NonRetryableStatus);
                }
                if (_isPageUnloadTriggered) {
                    // Unload event has been received so we need to try and flush new events
                    _releaseAllQueues(2 /* EventSendType.SendBeacon */, 2 /* SendRequestReason.Unload */);
                }
            }
            function _callNotification(evtName, theArgs) {
                var manager = (_self._notificationManager || {});
                var notifyFunc = manager[evtName];
                if (notifyFunc) {
                    try {
                        notifyFunc.apply(manager, theArgs);
                    }
                    catch (e) {
                        (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_15__._throwInternal)(_self.diagLog(), 1 /* eLoggingSeverity.CRITICAL */, 74 /* _eInternalMessageId.NotificationException */, evtName + " notification failed: " + e);
                    }
                }
            }
            function _notifyEvents(evtName, theEvents) {
                var extraArgs = [];
                for (var _i = 2; _i < arguments.length; _i++) {
                    extraArgs[_i - 2] = arguments[_i];
                }
                if (theEvents && theEvents.length > 0) {
                    _callNotification(evtName, [theEvents].concat(extraArgs));
                }
            }
            function _notifyBatchEvents(evtName, batches) {
                var extraArgs = [];
                for (var _i = 2; _i < arguments.length; _i++) {
                    extraArgs[_i - 2] = arguments[_i];
                }
                if (batches && batches.length > 0) {
                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.arrForEach)(batches, function (theBatch) {
                        if (theBatch && theBatch.count() > 0) {
                            _callNotification(evtName, [theBatch.events()].concat(extraArgs));
                        }
                    });
                }
            }
            /**
             * The notification handler for when batches are about to be sent
             * @ignore
             */
            function _sendingEvent(batches, reason, isSyncRequest) {
                if (batches && batches.length > 0) {
                    _callNotification("eventsSendRequest", [(reason >= 1000 /* EventBatchNotificationReason.SendingUndefined */ && reason <= 1999 /* EventBatchNotificationReason.SendingEventMax */ ?
                            reason - 1000 /* EventBatchNotificationReason.SendingUndefined */ :
                            0 /* SendRequestReason.Undefined */), isSyncRequest !== true]);
                }
            }
            /**
             * This event represents that a batch of events have been successfully sent and a response received
             * @param batches The notification handler for when the batches have been successfully sent
             * @param reason For this event the reason will always be EventBatchNotificationReason.Complete
             */
            function _eventsSentEvent(batches, reason) {
                _notifyBatchEvents("eventsSent", batches, reason);
                // Try and schedule the processing timer if we have events
                _scheduleTimer();
            }
            function _eventsDropped(batches, reason) {
                _notifyBatchEvents(strEventsDiscarded, batches, (reason >= 8000 /* EventBatchNotificationReason.EventsDropped */ && reason <= 8999 /* EventBatchNotificationReason.EventsDroppedMax */ ?
                    reason - 8000 /* EventBatchNotificationReason.EventsDropped */ :
                    _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_12__.EventsDiscardedReason.Unknown));
            }
            function _eventsResponseFail(batches) {
                _notifyBatchEvents(strEventsDiscarded, batches, _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_12__.EventsDiscardedReason.NonRetryableStatus);
                // Try and schedule the processing timer if we have events
                _scheduleTimer();
            }
            function _otherEvent(batches, reason) {
                _notifyBatchEvents(strEventsDiscarded, batches, _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_12__.EventsDiscardedReason.Unknown);
                // Try and schedule the processing timer if we have events
                _scheduleTimer();
            }
            function _setAutoLimits() {
                if (!_config || !_config.disableAutoBatchFlushLimit) {
                    _autoFlushBatchLimit = Math.max(MaxNumberEventPerBatch * (MaxConnections + 1), _queueSizeLimit / 6);
                }
                else {
                    _autoFlushBatchLimit = 0;
                }
            }
            // Provided for backward compatibility they are not "expected" to be in current use but they are public
            (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.objDefineAccessors)(_self, "_setTimeoutOverride", function () { return _timeoutWrapper.set; }, function (value) {
                // Recreate the timeout wrapper
                _timeoutWrapper = (0,_TimeoutOverrideWrapper__WEBPACK_IMPORTED_MODULE_6__.createTimeoutWrapper)(value, _timeoutWrapper.clear);
            });
            (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.objDefineAccessors)(_self, "_clearTimeoutOverride", function () { return _timeoutWrapper.clear; }, function (value) {
                // Recreate the timeout wrapper
                _timeoutWrapper = (0,_TimeoutOverrideWrapper__WEBPACK_IMPORTED_MODULE_6__.createTimeoutWrapper)(_timeoutWrapper.set, value);
            });
        });
        return _this;
    }
// Removed Stub for PostChannel.prototype.initialize.
// Removed Stub for PostChannel.prototype.processTelemetry.
// Removed Stub for PostChannel.prototype.setEventQueueLimits.
// Removed Stub for PostChannel.prototype.pause.
// Removed Stub for PostChannel.prototype.resume.
// Removed Stub for PostChannel.prototype.addResponseHandler.
// Removed Stub for PostChannel.prototype.flush.
// Removed Stub for PostChannel.prototype.setMsaAuthTicket.
// Removed Stub for PostChannel.prototype.hasEvents.
// Removed Stub for PostChannel.prototype._loadTransmitProfiles.
// Removed Stub for PostChannel.prototype._setTransmitProfile.
// Removed Stub for PostChannel.prototype._backOffTransmission.
// Removed Stub for PostChannel.prototype._clearBackOff.
    // This is a workaround for an IE8 bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    // this will be removed when ES3 support is dropped.
    PostChannel.__ieDyn=1;

    return PostChannel;
}(_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_16__.BaseTelemetryPlugin));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PostChannel);
//# sourceMappingURL=PostChannel.js.map

/***/ }),
/* 57 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ReflectObj": () => (/* binding */ ReflectObj),
/* harmony export */   "SymbolObj": () => (/* binding */ SymbolObj),
/* harmony export */   "__assignFn": () => (/* binding */ __assignFn),
/* harmony export */   "__createBindingFn": () => (/* binding */ __createBindingFn),
/* harmony export */   "__decorateFn": () => (/* binding */ __decorateFn),
/* harmony export */   "__exportStarFn": () => (/* binding */ __exportStarFn),
/* harmony export */   "__extendsFn": () => (/* binding */ __extendsFn),
/* harmony export */   "__hasReflect": () => (/* binding */ __hasReflect),
/* harmony export */   "__hasSymbol": () => (/* binding */ __hasSymbol),
/* harmony export */   "__importDefaultFn": () => (/* binding */ __importDefaultFn),
/* harmony export */   "__importStarFn": () => (/* binding */ __importStarFn),
/* harmony export */   "__makeTemplateObjectFn": () => (/* binding */ __makeTemplateObjectFn),
/* harmony export */   "__metadataFn": () => (/* binding */ __metadataFn),
/* harmony export */   "__objAssignFnImpl": () => (/* binding */ __objAssignFnImpl),
/* harmony export */   "__paramFn": () => (/* binding */ __paramFn),
/* harmony export */   "__readFn": () => (/* binding */ __readFn),
/* harmony export */   "__restFn": () => (/* binding */ __restFn),
/* harmony export */   "__spreadArrayFn": () => (/* binding */ __spreadArrayFn),
/* harmony export */   "__spreadArraysFn": () => (/* binding */ __spreadArraysFn),
/* harmony export */   "__valuesFn": () => (/* binding */ __valuesFn)
/* harmony export */ });
/* harmony import */ var _Constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(59);
/* harmony import */ var _Helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(58);
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.


// Most of these functions have been directly shamelessly "lifted" from the https://github.com/@microsoft/tslib and
// modified to be ES3 compatible and applying several minification and tree-shaking techniques so that Application Insights
// can successfully use TypeScript "importHelpers" which imports tslib during compilation but it will use these at runtime
// Which is also why all of the functions have not been included as Application Insights currently doesn't use or require
// them.
var SymbolObj = ((0,_Helpers__WEBPACK_IMPORTED_MODULE_0__.getGlobal)() || {})["Symbol"];
var ReflectObj = ((0,_Helpers__WEBPACK_IMPORTED_MODULE_0__.getGlobal)() || {})["Reflect"];
var __hasSymbol = !!SymbolObj;
var __hasReflect = !!ReflectObj;
var strDecorate = "decorate";
var strMetadata = "metadata";
var strGetOwnPropertySymbols = "getOwnPropertySymbols";
var strIterator = "iterator";
var __objAssignFnImpl = function (t) {
    // tslint:disable-next-line: ban-comma-operator
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) {
            if (_Constants__WEBPACK_IMPORTED_MODULE_1__.ObjProto[_Constants__WEBPACK_IMPORTED_MODULE_1__.strShimHasOwnProperty].call(s, p)) {
                t[p] = s[p];
            }
        }
    }
    return t;
};
var __assignFn = _Constants__WEBPACK_IMPORTED_MODULE_1__.ObjAssign || __objAssignFnImpl;
// tslint:disable-next-line: only-arrow-functions
var extendStaticsFn = function (d, b) {
    extendStaticsFn = _Constants__WEBPACK_IMPORTED_MODULE_1__.ObjClass.setPrototypeOf ||
        // tslint:disable-next-line: only-arrow-functions
        ({ __proto__: [] } instanceof Array && function (d, b) {
            d.__proto__ = b;
        }) ||
        // tslint:disable-next-line: only-arrow-functions
        function (d, b) {
            for (var p in b) {
                if (b[_Constants__WEBPACK_IMPORTED_MODULE_1__.strShimHasOwnProperty](p)) {
                    d[p] = b[p];
                }
            }
        };
    return extendStaticsFn(d, b);
};
function __extendsFn(d, b) {
    if (typeof b !== _Constants__WEBPACK_IMPORTED_MODULE_1__.strShimFunction && b !== null) {
        (0,_Helpers__WEBPACK_IMPORTED_MODULE_0__.throwTypeError)("Class extends value " + String(b) + " is not a constructor or null");
    }
    extendStaticsFn(d, b);
    function __() {
        this.constructor = d;
    }
    // tslint:disable-next-line: ban-comma-operator
    d[_Constants__WEBPACK_IMPORTED_MODULE_1__.strShimPrototype] = b === null ? (0,_Helpers__WEBPACK_IMPORTED_MODULE_0__.objCreateFn)(b) : (__[_Constants__WEBPACK_IMPORTED_MODULE_1__.strShimPrototype] = b[_Constants__WEBPACK_IMPORTED_MODULE_1__.strShimPrototype], new __());
}
function __restFn(s, e) {
    var t = {};
    for (var k in s) {
        if (_Constants__WEBPACK_IMPORTED_MODULE_1__.ObjHasOwnProperty.call(s, k) && e.indexOf(k) < 0) {
            t[k] = s[k];
        }
    }
    if (s != null && typeof _Constants__WEBPACK_IMPORTED_MODULE_1__.ObjClass[strGetOwnPropertySymbols] === _Constants__WEBPACK_IMPORTED_MODULE_1__.strShimFunction) {
        for (var i = 0, p = _Constants__WEBPACK_IMPORTED_MODULE_1__.ObjClass[strGetOwnPropertySymbols](s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && _Constants__WEBPACK_IMPORTED_MODULE_1__.ObjProto.propertyIsEnumerable.call(s, p[i])) {
                t[p[i]] = s[p[i]];
            }
        }
    }
    return t;
}
function __decorateFn(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = _Constants__WEBPACK_IMPORTED_MODULE_1__.ObjClass.getOwnPropertyDescriptor(target, key) : desc, d;
    if (__hasReflect && typeof ReflectObj[strDecorate] === _Constants__WEBPACK_IMPORTED_MODULE_1__.strShimFunction) {
        r = ReflectObj[strDecorate](decorators, target, key, desc);
    }
    else {
        for (var i = decorators.length - 1; i >= 0; i--) {
            // eslint-disable-next-line no-cond-assign
            if (d = decorators[i]) {
                r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
            }
        }
    }
    // tslint:disable-next-line:ban-comma-operator
    return c > 3 && r && (0,_Constants__WEBPACK_IMPORTED_MODULE_1__.ObjDefineProperty)(target, key, r), r;
}
function __paramFn(paramIndex, decorator) {
    return function (target, key) {
        decorator(target, key, paramIndex);
    };
}
function __metadataFn(metadataKey, metadataValue) {
    if (__hasReflect && ReflectObj[strMetadata] === _Constants__WEBPACK_IMPORTED_MODULE_1__.strShimFunction) {
        return ReflectObj[strMetadata](metadataKey, metadataValue);
    }
}
function __exportStarFn(m, o) {
    for (var p in m) {
        if (p !== _Constants__WEBPACK_IMPORTED_MODULE_1__.strDefault && !_Constants__WEBPACK_IMPORTED_MODULE_1__.ObjHasOwnProperty.call(o, p)) {
            __createBindingFn(o, m, p);
        }
    }
}
function __createBindingFn(o, m, k, k2) {
    if (k2 === undefined) {
        k2 = k;
    }
    if (!!_Constants__WEBPACK_IMPORTED_MODULE_1__.ObjCreate) {
        (0,_Constants__WEBPACK_IMPORTED_MODULE_1__.ObjDefineProperty)(o, k2, {
            enumerable: true,
            get: function () {
                return m[k];
            }
        });
    }
    else {
        o[k2] = m[k];
    }
}
function __valuesFn(o) {
    var s = typeof SymbolObj === _Constants__WEBPACK_IMPORTED_MODULE_1__.strShimFunction && SymbolObj[strIterator], m = s && o[s], i = 0;
    if (m) {
        return m.call(o);
    }
    if (o && typeof o.length === "number") {
        return {
            next: function () {
                if (o && i >= o.length) {
                    o = void 0;
                }
                return { value: o && o[i++], done: !o };
            }
        };
    }
    (0,_Helpers__WEBPACK_IMPORTED_MODULE_0__.throwTypeError)(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}
function __readFn(o, n) {
    var m = typeof SymbolObj === _Constants__WEBPACK_IMPORTED_MODULE_1__.strShimFunction && o[SymbolObj[strIterator]];
    if (!m) {
        return o;
    }
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) {
            ar.push(r.value);
        }
    }
    catch (error) {
        e = {
            error: error
        };
    }
    finally {
        try {
            // tslint:disable-next-line:no-conditional-assignment
            if (r && !r.done && (m = i["return"])) {
                m.call(i);
            }
        }
        finally {
            if (e) {
                // eslint-disable-next-line no-unsafe-finally
                throw e.error;
            }
        }
    }
    return ar;
}
/** @deprecated */
function __spreadArraysFn() {
    var theArgs = arguments;
    // Calculate new total size
    for (var s = 0, i = 0, il = theArgs.length; i < il; i++) {
        s += theArgs[i].length;
    }
    // Create new full array
    for (var r = Array(s), k = 0, i = 0; i < il; i++) {
        for (var a = theArgs[i], j = 0, jl = a.length; j < jl; j++, k++) {
            r[k] = a[j];
        }
    }
    return r;
}
function __spreadArrayFn(to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++) {
        to[j] = from[i];
    }
    return to;
}
function __makeTemplateObjectFn(cooked, raw) {
    if (_Constants__WEBPACK_IMPORTED_MODULE_1__.ObjDefineProperty) {
        (0,_Constants__WEBPACK_IMPORTED_MODULE_1__.ObjDefineProperty)(cooked, "raw", { value: raw });
    }
    else {
        cooked.raw = raw;
    }
    return cooked;
}
function __importStarFn(mod) {
    if (mod && mod.__esModule) {
        return mod;
    }
    var result = {};
    if (mod != null) {
        for (var k in mod) {
            if (k !== _Constants__WEBPACK_IMPORTED_MODULE_1__.strDefault && Object.prototype.hasOwnProperty.call(mod, k)) {
                __createBindingFn(result, mod, k);
            }
        }
    }
    // Set default module
    if (!!_Constants__WEBPACK_IMPORTED_MODULE_1__.ObjCreate) {
        (0,_Constants__WEBPACK_IMPORTED_MODULE_1__.ObjDefineProperty)(result, _Constants__WEBPACK_IMPORTED_MODULE_1__.strDefault, { enumerable: true, value: mod });
    }
    else {
        result[_Constants__WEBPACK_IMPORTED_MODULE_1__.strDefault] = mod;
    }
    return result;
}
function __importDefaultFn(mod) {
    return (mod && mod.__esModule) ? mod : { strDefault: mod };
}
//# sourceMappingURL=TsLibShims.js.map

/***/ }),
/* 58 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getGlobal": () => (/* binding */ getGlobal),
/* harmony export */   "objCreateFn": () => (/* binding */ objCreateFn),
/* harmony export */   "throwTypeError": () => (/* binding */ throwTypeError)
/* harmony export */ });
/* harmony import */ var _Constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(59);
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

var _cachedGlobal = null;
/**
 * Returns the current global scope object, for a normal web page this will be the current
 * window, for a Web Worker this will be current worker global scope via "self". The internal
 * implementation returns the first available instance object in the following order
 * - globalThis (New standard)
 * - self (Will return the current window instance for supported browsers)
 * - window (fallback for older browser implementations)
 * - global (NodeJS standard)
 * - <null> (When all else fails)
 * While the return type is a Window for the normal case, not all environments will support all
 * of the properties or functions.
 */
function getGlobal(useCached) {
    if (useCached === void 0) { useCached = true; }
    var result = useCached === false ? null : _cachedGlobal;
    if (!result) {
        if (typeof globalThis !== _Constants__WEBPACK_IMPORTED_MODULE_0__.strShimUndefined) {
            result = globalThis;
        }
        if (!result && typeof self !== _Constants__WEBPACK_IMPORTED_MODULE_0__.strShimUndefined) {
            result = self;
        }
        if (!result && typeof window !== _Constants__WEBPACK_IMPORTED_MODULE_0__.strShimUndefined) {
            result = window;
        }
        if (!result && typeof __webpack_require__.g !== _Constants__WEBPACK_IMPORTED_MODULE_0__.strShimUndefined) {
            result = __webpack_require__.g;
        }
        _cachedGlobal = result;
    }
    return result;
}
function throwTypeError(message) {
    throw new TypeError(message);
}
/**
 * Creates an object that has the specified prototype, and that optionally contains specified properties. This helper exists to avoid adding a polyfil
 * for older browsers that do not define Object.create eg. ES3 only, IE8 just in case any page checks for presence/absence of the prototype implementation.
 * Note: For consistency this will not use the Object.create implementation if it exists as this would cause a testing requirement to test with and without the implementations
 * @param obj Object to use as a prototype. May be null
 */
function objCreateFn(obj) {
    var func = _Constants__WEBPACK_IMPORTED_MODULE_0__.ObjCreate;
    // Use build in Object.create
    if (func) {
        // Use Object create method if it exists
        return func(obj);
    }
    if (obj == null) {
        return {};
    }
    var type = typeof obj;
    if (type !== _Constants__WEBPACK_IMPORTED_MODULE_0__.strShimObject && type !== _Constants__WEBPACK_IMPORTED_MODULE_0__.strShimFunction) {
        throwTypeError("Object prototype may only be an Object:" + obj);
    }
    function tmpFunc() { }
    tmpFunc[_Constants__WEBPACK_IMPORTED_MODULE_0__.strShimPrototype] = obj;
    return new tmpFunc();
}
//# sourceMappingURL=Helpers.js.map

/***/ }),
/* 59 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ObjAssign": () => (/* binding */ ObjAssign),
/* harmony export */   "ObjClass": () => (/* binding */ ObjClass),
/* harmony export */   "ObjCreate": () => (/* binding */ ObjCreate),
/* harmony export */   "ObjDefineProperty": () => (/* binding */ ObjDefineProperty),
/* harmony export */   "ObjHasOwnProperty": () => (/* binding */ ObjHasOwnProperty),
/* harmony export */   "ObjProto": () => (/* binding */ ObjProto),
/* harmony export */   "strDefault": () => (/* binding */ strDefault),
/* harmony export */   "strShimFunction": () => (/* binding */ strShimFunction),
/* harmony export */   "strShimHasOwnProperty": () => (/* binding */ strShimHasOwnProperty),
/* harmony export */   "strShimObject": () => (/* binding */ strShimObject),
/* harmony export */   "strShimPrototype": () => (/* binding */ strShimPrototype),
/* harmony export */   "strShimUndefined": () => (/* binding */ strShimUndefined)
/* harmony export */ });
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
var strShimFunction = "function";
var strShimObject = "object";
var strShimUndefined = "undefined";
var strShimPrototype = "prototype";
var strShimHasOwnProperty = "hasOwnProperty";
var strDefault = "default";
var ObjClass = Object;
var ObjProto = ObjClass[strShimPrototype];
var ObjAssign = ObjClass["assign"];
var ObjCreate = ObjClass["create"];
var ObjDefineProperty = ObjClass["defineProperty"];
var ObjHasOwnProperty = ObjProto[strShimHasOwnProperty];
//# sourceMappingURL=Constants.js.map

/***/ }),
/* 60 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BE_PROFILE": () => (/* binding */ BE_PROFILE),
/* harmony export */   "NRT_PROFILE": () => (/* binding */ NRT_PROFILE),
/* harmony export */   "RT_PROFILE": () => (/* binding */ RT_PROFILE)
/* harmony export */ });
/*
 * 1DS JS SDK POST plugin, 3.2.13
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */
/**
 * Real Time profile (default profile). RealTime Latency events are sent every 1 sec and
 * Normal Latency events are sent every 2 sec.
 */
var RT_PROFILE = "REAL_TIME";
/**
 * Near Real Time profile. RealTime Latency events are sent every 3 sec and
 * Normal Latency events are sent every 6 sec.
 */
var NRT_PROFILE = "NEAR_REAL_TIME";
/**
 * Best Effort. RealTime Latency events are sent every 9 sec and
 * Normal Latency events are sent every 18 sec.
 */
var BE_PROFILE = "BEST_EFFORT";
//# sourceMappingURL=DataModels.js.map

/***/ }),
/* 61 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ dynamicProto)
/* harmony export */ });
/*!
 * Microsoft Dynamic Proto Utility, 1.1.7
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */
var _a;
var UNDEFINED = "undefined";
/**
 * Constant string defined to support minimization
 * @ignore
 */
var Constructor = 'constructor';
/**
 * Constant string defined to support minimization
 * @ignore
 */
var Prototype = 'prototype';
/**
 * Constant string defined to support minimization
 * @ignore
 */
var strFunction = 'function';
/**
 * Used to define the name of the instance function lookup table
 * @ignore
 */
var DynInstFuncTable = '_dynInstFuncs';
/**
 * Name used to tag the dynamic prototype function
 * @ignore
 */
var DynProxyTag = '_isDynProxy';
/**
 * Name added to a prototype to define the dynamic prototype "class" name used to lookup the function table
 * @ignore
 */
var DynClassName = '_dynClass';
/**
 * Prefix added to the classname to avoid any name clashes with other instance level properties
 * @ignore
 */
var DynClassNamePrefix = '_dynCls$';
/**
 * A tag which is used to check if we have already to attempted to set the instance function if one is not present
 * @ignore
 */
var DynInstChkTag = '_dynInstChk';
/**
 * A tag which is used to check if we are allows to try and set an instance function is one is not present. Using the same
 * tag name as the function level but a different const name for readability only.
 */
var DynAllowInstChkTag = DynInstChkTag;
/**
 * The global (imported) instances where the global performance options are stored
 */
var DynProtoDefaultOptions = '_dfOpts';
/**
 * Value used as the name of a class when it cannot be determined
 * @ignore
 */
var UnknownValue = '_unknown_';
/**
 * Constant string defined to support minimization
 * @ignore
 */
var str__Proto = "__proto__";
/**
 * The polyfill version of __proto__ so that it doesn't cause issues for anyone not expecting it to exist
 */
var DynProtoBaseProto = "_dyn" + str__Proto;
/**
 * Runtime Global holder for dynamicProto settings
 */
var DynProtoGlobalSettings = "__dynProto$Gbl";
/**
 * Track the current prototype for IE8 as you can't look back to get the prototype
 */
var DynProtoCurrent = "_dynInstProto";
/**
 * Constant string defined to support minimization
 * @ignore
 */
var strUseBaseInst = 'useBaseInst';
/**
 * Constant string defined to support minimization
 * @ignore
 */
var strSetInstFuncs = 'setInstFuncs';
var Obj = Object;
/**
 * Pre-lookup to check if we are running on a modern browser (i.e. not IE8)
 * @ignore
 */
var _objGetPrototypeOf = Obj["getPrototypeOf"];
/**
 * Pre-lookup to check for the existence of this function
 */
var _objGetOwnProps = Obj["getOwnPropertyNames"];
/**
 * Gets the runtime global reference
 * @returns
 */
function _getGlobal() {
    var result;
    if (typeof globalThis !== UNDEFINED) {
        result = globalThis;
    }
    if (!result && typeof self !== UNDEFINED) {
        result = self;
    }
    if (!result && typeof window !== UNDEFINED) {
        result = window;
    }
    if (!result && typeof __webpack_require__.g !== UNDEFINED) {
        result = __webpack_require__.g;
    }
    return result || {};
}
// Since 1.1.7 moving these to the runtime global to work around mixed version and module issues
// See Issue https://github.com/microsoft/DynamicProto-JS/issues/57 for details
var _gbl = _getGlobal();
var _gblInst = _gbl[DynProtoGlobalSettings] || (_gbl[DynProtoGlobalSettings] = {
    o: (_a = {},
        _a[strSetInstFuncs] = true,
        _a[strUseBaseInst] = true,
        _a),
    n: 1000 // Start new global index @ 1000 so we "fix" some cases when mixed with 1.1.6 or earlier
});
/**
 * Helper to check if the object contains a property of the name
 * @ignore
 */
function _hasOwnProperty(obj, prop) {
    return obj && Obj[Prototype].hasOwnProperty.call(obj, prop);
}
/**
 * Helper used to check whether the target is an Object prototype or Array prototype
 * @ignore
 */
function _isObjectOrArrayPrototype(target) {
    return target && (target === Obj[Prototype] || target === Array[Prototype]);
}
/**
 * Helper used to check whether the target is an Object prototype, Array prototype or Function prototype
 * @ignore
 */
function _isObjectArrayOrFunctionPrototype(target) {
    return _isObjectOrArrayPrototype(target) || target === Function[Prototype];
}
/**
 * Helper used to get the prototype of the target object as getPrototypeOf is not available in an ES3 environment.
 * @ignore
 */
function _getObjProto(target) {
    var newProto;
    if (target) {
        // This method doesn't exist in older browsers (e.g. IE8)
        if (_objGetPrototypeOf) {
            return _objGetPrototypeOf(target);
        }
        var curProto = target[str__Proto] || target[Prototype] || (target[Constructor] ? target[Constructor][Prototype] : null);
        // Using the pre-calculated value as IE8 doesn't support looking up the prototype of a prototype and thus fails for more than 1 base class
        newProto = target[DynProtoBaseProto] || curProto;
        if (!_hasOwnProperty(target, DynProtoBaseProto)) {
            // As this prototype doesn't have this property then this is from an inherited class so newProto is the base to return so save it
            // so we can look it up value (which for a multiple hierarchy dynamicProto will be the base class)
            delete target[DynProtoCurrent]; // Delete any current value allocated to this instance so we pick up the value from prototype hierarchy
            newProto = target[DynProtoBaseProto] = target[DynProtoCurrent] || target[DynProtoBaseProto];
            target[DynProtoCurrent] = curProto;
        }
    }
    return newProto;
}
/**
 * Helper to get the properties of an object, including none enumerable ones as functions on a prototype in ES6
 * are not enumerable.
 * @param target
 */
function _forEachProp(target, func) {
    var props = [];
    if (_objGetOwnProps) {
        props = _objGetOwnProps(target);
    }
    else {
        for (var name_1 in target) {
            if (typeof name_1 === "string" && _hasOwnProperty(target, name_1)) {
                props.push(name_1);
            }
        }
    }
    if (props && props.length > 0) {
        for (var lp = 0; lp < props.length; lp++) {
            func(props[lp]);
        }
    }
}
/**
 * Helper function to check whether the provided function name is a potential candidate for dynamic
 * callback and prototype generation.
 * @param target The target object, may be a prototype or class object
 * @param funcName The function name
 * @param skipOwn Skips the check for own property
 * @ignore
 */
function _isDynamicCandidate(target, funcName, skipOwn) {
    return (funcName !== Constructor && typeof target[funcName] === strFunction && (skipOwn || _hasOwnProperty(target, funcName)));
}
/**
 * Helper to throw a TypeError exception
 * @param message the message
 * @ignore
 */
function _throwTypeError(message) {
    throw new TypeError("DynamicProto: " + message);
}
/**
 * Returns a collection of the instance functions that are defined directly on the thisTarget object, it does
 * not return any inherited functions
 * @param thisTarget The object to get the instance functions from
 * @ignore
 */
function _getInstanceFuncs(thisTarget) {
    // Get the base proto
    var instFuncs = {};
    // Save any existing instance functions
    _forEachProp(thisTarget, function (name) {
        // Don't include any dynamic prototype instances - as we only want the real functions
        if (!instFuncs[name] && _isDynamicCandidate(thisTarget, name, false)) {
            // Create an instance callback for passing the base function to the caller
            instFuncs[name] = thisTarget[name];
        }
    });
    return instFuncs;
}
/**
 * Returns whether the value is included in the array
 * @param values The array of values
 * @param value  The value
 */
function _hasVisited(values, value) {
    for (var lp = values.length - 1; lp >= 0; lp--) {
        if (values[lp] === value) {
            return true;
        }
    }
    return false;
}
/**
 * Returns an object that contains callback functions for all "base/super" functions, this is used to "save"
 * enabling calling super.xxx() functions without requiring that the base "class" has defined a prototype references
 * @param target The current instance
 * @ignore
 */
function _getBaseFuncs(classProto, thisTarget, instFuncs, useBaseInst) {
    function _instFuncProxy(target, funcHost, funcName) {
        var theFunc = funcHost[funcName];
        if (theFunc[DynProxyTag] && useBaseInst) {
            // grab and reuse the hosted looking function (if available) otherwise the original passed function
            var instFuncTable = target[DynInstFuncTable] || {};
            if (instFuncTable[DynAllowInstChkTag] !== false) {
                theFunc = (instFuncTable[funcHost[DynClassName]] || {})[funcName] || theFunc;
            }
        }
        return function () {
            // eslint-disable-next-line prefer-rest-params
            return theFunc.apply(target, arguments);
        };
    }
    // Start creating a new baseFuncs by creating proxies for the instance functions (as they may get replaced)
    var baseFuncs = {};
    _forEachProp(instFuncs, function (name) {
        // Create an instance callback for passing the base function to the caller
        baseFuncs[name] = _instFuncProxy(thisTarget, instFuncs, name);
    });
    // Get the base prototype functions
    var baseProto = _getObjProto(classProto);
    var visited = [];
    // Don't include base object functions for Object, Array or Function
    while (baseProto && !_isObjectArrayOrFunctionPrototype(baseProto) && !_hasVisited(visited, baseProto)) {
        // look for prototype functions
        _forEachProp(baseProto, function (name) {
            // Don't include any dynamic prototype instances - as we only want the real functions
            // For IE 7/8 the prototype lookup doesn't provide the full chain so we need to bypass the 
            // hasOwnProperty check we get all of the methods, main difference is that IE7/8 doesn't return
            // the Object prototype methods while bypassing the check
            if (!baseFuncs[name] && _isDynamicCandidate(baseProto, name, !_objGetPrototypeOf)) {
                // Create an instance callback for passing the base function to the caller
                baseFuncs[name] = _instFuncProxy(thisTarget, baseProto, name);
            }
        });
        // We need to find all possible functions that might be overloaded by walking the entire prototype chain
        // This avoids the caller from needing to check whether it's direct base class implements the function or not
        // by walking the entire chain it simplifies the usage and issues from upgrading any of the base classes.
        visited.push(baseProto);
        baseProto = _getObjProto(baseProto);
    }
    return baseFuncs;
}
function _getInstFunc(target, funcName, proto, currentDynProtoProxy) {
    var instFunc = null;
    // We need to check whether the class name is defined directly on this prototype otherwise
    // it will walk the proto chain and return any parent proto classname.
    if (target && _hasOwnProperty(proto, DynClassName)) {
        var instFuncTable = target[DynInstFuncTable] || {};
        instFunc = (instFuncTable[proto[DynClassName]] || {})[funcName];
        if (!instFunc) {
            // Avoid stack overflow from recursive calling the same function
            _throwTypeError("Missing [" + funcName + "] " + strFunction);
        }
        // We have the instance function, lets check it we can speed up further calls
        // by adding the instance function back directly on the instance (avoiding the dynamic func lookup)
        if (!instFunc[DynInstChkTag] && instFuncTable[DynAllowInstChkTag] !== false) {
            // If the instance already has an instance function we can't replace it
            var canAddInst = !_hasOwnProperty(target, funcName);
            // Get current prototype
            var objProto = _getObjProto(target);
            var visited = [];
            // Lookup the function starting at the top (instance level prototype) and traverse down, if the first matching function
            // if nothing is found or if the first hit is a dynamic proto instance then we can safely add an instance shortcut
            while (canAddInst && objProto && !_isObjectArrayOrFunctionPrototype(objProto) && !_hasVisited(visited, objProto)) {
                var protoFunc = objProto[funcName];
                if (protoFunc) {
                    canAddInst = (protoFunc === currentDynProtoProxy);
                    break;
                }
                // We need to find all possible initial functions to ensure that we don't bypass a valid override function
                visited.push(objProto);
                objProto = _getObjProto(objProto);
            }
            try {
                if (canAddInst) {
                    // This instance doesn't have an instance func and the class hierarchy does have a higher level prototype version
                    // so it's safe to directly assign for any subsequent calls (for better performance)
                    target[funcName] = instFunc;
                }
                // Block further attempts to set the instance function for any
                instFunc[DynInstChkTag] = 1;
            }
            catch (e) {
                // Don't crash if the object is readonly or the runtime doesn't allow changing this
                // And set a flag so we don't try again for any function
                instFuncTable[DynAllowInstChkTag] = false;
            }
        }
    }
    return instFunc;
}
function _getProtoFunc(funcName, proto, currentDynProtoProxy) {
    var protoFunc = proto[funcName];
    // Check that the prototype function is not a self reference -- try to avoid stack overflow!
    if (protoFunc === currentDynProtoProxy) {
        // It is so lookup the base prototype
        protoFunc = _getObjProto(proto)[funcName];
    }
    if (typeof protoFunc !== strFunction) {
        _throwTypeError("[" + funcName + "] is not a " + strFunction);
    }
    return protoFunc;
}
/**
 * Add the required dynamic prototype methods to the the class prototype
 * @param proto - The class prototype
 * @param className - The instance classname
 * @param target - The target instance
 * @param baseInstFuncs - The base instance functions
 * @param setInstanceFunc - Flag to allow prototype function to reset the instance function if one does not exist
 * @ignore
 */
function _populatePrototype(proto, className, target, baseInstFuncs, setInstanceFunc) {
    function _createDynamicPrototype(proto, funcName) {
        var dynProtoProxy = function () {
            // Use the instance or prototype function
            var instFunc = _getInstFunc(this, funcName, proto, dynProtoProxy) || _getProtoFunc(funcName, proto, dynProtoProxy);
            // eslint-disable-next-line prefer-rest-params
            return instFunc.apply(this, arguments);
        };
        // Tag this function as a proxy to support replacing dynamic proxy elements (primary use case is for unit testing
        // via which can dynamically replace the prototype function reference)
        dynProtoProxy[DynProxyTag] = 1;
        return dynProtoProxy;
    }
    if (!_isObjectOrArrayPrototype(proto)) {
        var instFuncTable = target[DynInstFuncTable] = target[DynInstFuncTable] || {};
        var instFuncs_1 = instFuncTable[className] = (instFuncTable[className] || {}); // fetch and assign if as it may not exist yet
        // Set whether we are allow to lookup instances, if someone has set to false then do not re-enable
        if (instFuncTable[DynAllowInstChkTag] !== false) {
            instFuncTable[DynAllowInstChkTag] = !!setInstanceFunc;
        }
        _forEachProp(target, function (name) {
            // Only add overridden functions
            if (_isDynamicCandidate(target, name, false) && target[name] !== baseInstFuncs[name]) {
                // Save the instance Function to the lookup table and remove it from the instance as it's not a dynamic proto function
                instFuncs_1[name] = target[name];
                delete target[name];
                // Add a dynamic proto if one doesn't exist or if a prototype function exists and it's not a dynamic one
                if (!_hasOwnProperty(proto, name) || (proto[name] && !proto[name][DynProxyTag])) {
                    proto[name] = _createDynamicPrototype(proto, name);
                }
            }
        });
    }
}
/**
 * Checks whether the passed prototype object appears to be correct by walking the prototype hierarchy of the instance
 * @param classProto The class prototype instance
 * @param thisTarget The current instance that will be checked whether the passed prototype instance is in the hierarchy
 * @ignore
 */
function _checkPrototype(classProto, thisTarget) {
    // This method doesn't existing in older browsers (e.g. IE8)
    if (_objGetPrototypeOf) {
        // As this is primarily a coding time check, don't bother checking if running in IE8 or lower
        var visited = [];
        var thisProto = _getObjProto(thisTarget);
        while (thisProto && !_isObjectArrayOrFunctionPrototype(thisProto) && !_hasVisited(visited, thisProto)) {
            if (thisProto === classProto) {
                return true;
            }
            // This avoids the caller from needing to check whether it's direct base class implements the function or not
            // by walking the entire chain it simplifies the usage and issues from upgrading any of the base classes.
            visited.push(thisProto);
            thisProto = _getObjProto(thisProto);
        }
        return false;
    }
    // If objGetPrototypeOf doesn't exist then just assume everything is ok.
    return true;
}
/**
 * Gets the current prototype name using the ES6 name if available otherwise falling back to a use unknown as the name.
 * It's not critical for this to return a name, it's used to decorate the generated unique name for easier debugging only.
 * @param target
 * @param unknownValue
 * @ignore
 */
function _getObjName(target, unknownValue) {
    if (_hasOwnProperty(target, Prototype)) {
        // Look like a prototype
        return target.name || unknownValue || UnknownValue;
    }
    return (((target || {})[Constructor]) || {}).name || unknownValue || UnknownValue;
}
/**
 * Helper function when creating dynamic (inline) functions for classes, this helper performs the following tasks :-
 * - Saves references to all defined base class functions
 * - Calls the delegateFunc with the current target (this) and a base object reference that can be used to call all "super" functions.
 * - Will populate the class prototype for all overridden functions to support class extension that call the prototype instance.
 * Callers should use this helper when declaring all function within the constructor of a class, as mentioned above the delegateFunc is
 * passed both the target "this" and an object that can be used to call any base (super) functions, using this based object in place of
 * super.XXX() (which gets expanded to _super.prototype.XXX()) provides a better minification outcome and also ensures the correct "this"
 * context is maintained as TypeScript creates incorrect references using super.XXXX() for dynamically defined functions i.e. Functions
 * defined in the constructor or some other function (rather than declared as complete typescript functions).
 * ### Usage
 * ```typescript
 * import dynamicProto from "@microsoft/dynamicproto-js";
 * class ExampleClass extends BaseClass {
 *     constructor() {
 *         dynamicProto(ExampleClass, this, (_self, base) => {
 *             // This will define a function that will be converted to a prototype function
 *             _self.newFunc = () => {
 *                 // Access any "this" instance property
 *                 if (_self.someProperty) {
 *                     ...
 *                 }
 *             }
 *             // This will define a function that will be converted to a prototype function
 *             _self.myFunction = () => {
 *                 // Access any "this" instance property
 *                 if (_self.someProperty) {
 *                     // Call the base version of the function that we are overriding
 *                     base.myFunction();
 *                 }
 *                 ...
 *             }
 *             _self.initialize = () => {
 *                 ...
 *             }
 *             // Warnings: While the following will work as _self is simply a reference to
 *             // this, if anyone overrides myFunction() the overridden will be called first
 *             // as the normal JavaScript method resolution will occur and the defined
 *             // _self.initialize() function is actually gets removed from the instance and
 *             // a proxy prototype version is created to reference the created method.
 *             _self.initialize();
 *         });
 *     }
 * }
 * ```
 * @typeparam DPType This is the generic type of the class, used to keep intellisense valid
 * @typeparam DPCls The type that contains the prototype of the current class
 * @param theClass - This is the current class instance which contains the prototype for the current class
 * @param target - The current "this" (target) reference, when the class has been extended this.prototype will not be the 'theClass' value.
 * @param delegateFunc - The callback function (closure) that will create the dynamic function
 * @param options - Additional options to configure how the dynamic prototype operates
 */
function dynamicProto(theClass, target, delegateFunc, options) {
    // Make sure that the passed theClass argument looks correct
    if (!_hasOwnProperty(theClass, Prototype)) {
        _throwTypeError("theClass is an invalid class definition.");
    }
    // Quick check to make sure that the passed theClass argument looks correct (this is a common copy/paste error)
    var classProto = theClass[Prototype];
    if (!_checkPrototype(classProto, target)) {
        _throwTypeError("[" + _getObjName(theClass) + "] not in hierarchy of [" + _getObjName(target) + "]");
    }
    var className = null;
    if (_hasOwnProperty(classProto, DynClassName)) {
        // Only grab the class name if it's defined on this prototype (i.e. don't walk the prototype chain)
        className = classProto[DynClassName];
    }
    else {
        // As not all browser support name on the prototype creating a unique dynamic one if we have not already
        // assigned one, so we can use a simple string as the lookup rather than an object for the dynamic instance
        // function table lookup.
        className = DynClassNamePrefix + _getObjName(theClass, "_") + "$" + _gblInst.n;
        _gblInst.n++;
        classProto[DynClassName] = className;
    }
    var perfOptions = dynamicProto[DynProtoDefaultOptions];
    var useBaseInst = !!perfOptions[strUseBaseInst];
    if (useBaseInst && options && options[strUseBaseInst] !== undefined) {
        useBaseInst = !!options[strUseBaseInst];
    }
    // Get the current instance functions
    var instFuncs = _getInstanceFuncs(target);
    // Get all of the functions for any base instance (before they are potentially overridden)
    var baseFuncs = _getBaseFuncs(classProto, target, instFuncs, useBaseInst);
    // Execute the delegate passing in both the current target "this" and "base" function references
    // Note casting the same type as we don't actually have the base class here and this will provide some intellisense support
    delegateFunc(target, baseFuncs);
    // Don't allow setting instance functions for older IE instances
    var setInstanceFunc = !!_objGetPrototypeOf && !!perfOptions[strSetInstFuncs];
    if (setInstanceFunc && options) {
        setInstanceFunc = !!options[strSetInstFuncs];
    }
    // Populate the Prototype for any overridden instance functions
    _populatePrototype(classProto, className, target, instFuncs, setInstanceFunc !== false);
}
/**
 * Exposes the default global options to allow global configuration, if the global values are disabled these will override
 * any passed values. This is primarily exposed to support unit-testing without the need for individual classes to expose
 * their internal usage of dynamic proto.
 */
dynamicProto[DynProtoDefaultOptions] = _gblInst.o;


//# sourceMappingURL=dynamicproto-js.js.map


/***/ }),
/* 62 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "createTimeoutWrapper": () => (/* binding */ createTimeoutWrapper),
/* harmony export */   "defaultClearTimeout": () => (/* binding */ defaultClearTimeout),
/* harmony export */   "defaultSetTimeout": () => (/* binding */ defaultSetTimeout)
/* harmony export */ });
/*
 * 1DS JS SDK POST plugin, 3.2.13
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */
/**
* TimeoutOverrideWrapper.ts
* @author  Nev Wylie (newylie)
* @copyright Microsoft 2022
* Simple internal timeout wrapper
*/
function defaultSetTimeout(callback, ms) {
    var args = [];
    for (var _i = 2; _i < arguments.length; _i++) {
        args[_i - 2] = arguments[_i];
    }
    return setTimeout(callback, ms, args);
}
function defaultClearTimeout(timeoutId) {
    clearTimeout(timeoutId);
}
function createTimeoutWrapper(argSetTimeout, argClearTimeout) {
    return {
        set: argSetTimeout || defaultSetTimeout,
        clear: argClearTimeout || defaultClearTimeout
    };
}
//# sourceMappingURL=TimeoutOverrideWrapper.js.map

/***/ }),
/* 63 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DEFAULT_CACHE_CONTROL": () => (/* binding */ DEFAULT_CACHE_CONTROL),
/* harmony export */   "DEFAULT_CONTENT_TYPE": () => (/* binding */ DEFAULT_CONTENT_TYPE),
/* harmony export */   "STR_API_KEY": () => (/* binding */ STR_API_KEY),
/* harmony export */   "STR_AUTH_XTOKEN": () => (/* binding */ STR_AUTH_XTOKEN),
/* harmony export */   "STR_CACHE_CONTROL": () => (/* binding */ STR_CACHE_CONTROL),
/* harmony export */   "STR_CLIENT_ID": () => (/* binding */ STR_CLIENT_ID),
/* harmony export */   "STR_CLIENT_VERSION": () => (/* binding */ STR_CLIENT_VERSION),
/* harmony export */   "STR_CONTENT_TYPE_HEADER": () => (/* binding */ STR_CONTENT_TYPE_HEADER),
/* harmony export */   "STR_DISABLED_PROPERTY_NAME": () => (/* binding */ STR_DISABLED_PROPERTY_NAME),
/* harmony export */   "STR_DROPPED": () => (/* binding */ STR_DROPPED),
/* harmony export */   "STR_EMPTY": () => (/* binding */ STR_EMPTY),
/* harmony export */   "STR_KILL_DURATION_HEADER": () => (/* binding */ STR_KILL_DURATION_HEADER),
/* harmony export */   "STR_KILL_DURATION_SECONDS_HEADER": () => (/* binding */ STR_KILL_DURATION_SECONDS_HEADER),
/* harmony export */   "STR_KILL_TOKENS_HEADER": () => (/* binding */ STR_KILL_TOKENS_HEADER),
/* harmony export */   "STR_MSA_DEVICE_TICKET": () => (/* binding */ STR_MSA_DEVICE_TICKET),
/* harmony export */   "STR_MSFPC": () => (/* binding */ STR_MSFPC),
/* harmony export */   "STR_NO_RESPONSE_BODY": () => (/* binding */ STR_NO_RESPONSE_BODY),
/* harmony export */   "STR_OTHER": () => (/* binding */ STR_OTHER),
/* harmony export */   "STR_POST_METHOD": () => (/* binding */ STR_POST_METHOD),
/* harmony export */   "STR_REQUEUE": () => (/* binding */ STR_REQUEUE),
/* harmony export */   "STR_RESPONSE_FAIL": () => (/* binding */ STR_RESPONSE_FAIL),
/* harmony export */   "STR_SDK_VERSION": () => (/* binding */ STR_SDK_VERSION),
/* harmony export */   "STR_SENDING": () => (/* binding */ STR_SENDING),
/* harmony export */   "STR_TIME_DELTA_HEADER": () => (/* binding */ STR_TIME_DELTA_HEADER),
/* harmony export */   "STR_TIME_DELTA_TO_APPLY": () => (/* binding */ STR_TIME_DELTA_TO_APPLY),
/* harmony export */   "STR_TRACE": () => (/* binding */ STR_TRACE),
/* harmony export */   "STR_UPLOAD_TIME": () => (/* binding */ STR_UPLOAD_TIME),
/* harmony export */   "STR_USER": () => (/* binding */ STR_USER)
/* harmony export */ });
/*
 * 1DS JS SDK POST plugin, 3.2.13
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */

// Licensed under the MIT License.
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// Note: DON'T Export these const from the package as we are still targeting ES3 this will export a mutable variables that someone could change!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// Generally you should only put values that are used more than 2 times and then only if not already exposed as a constant (such as SdkCoreNames)
// as when using "short" named values from here they will be will be minified smaller than the SdkCoreNames[eSdkCoreNames.xxxx] value.
var STR_EMPTY = "";
var STR_POST_METHOD = "POST";
var STR_DISABLED_PROPERTY_NAME = "Microsoft_ApplicationInsights_BypassAjaxInstrumentation";
var STR_DROPPED = "drop";
var STR_SENDING = "send";
var STR_REQUEUE = "requeue";
var STR_RESPONSE_FAIL = "rspFail";
var STR_OTHER = "oth";
var DEFAULT_CACHE_CONTROL = "no-cache, no-store";
var DEFAULT_CONTENT_TYPE = "application/x-json-stream";
var STR_CACHE_CONTROL = "cache-control";
var STR_CONTENT_TYPE_HEADER = "content-type";
var STR_KILL_TOKENS_HEADER = "kill-tokens";
var STR_KILL_DURATION_HEADER = "kill-duration";
var STR_KILL_DURATION_SECONDS_HEADER = "kill-duration-seconds";
var STR_TIME_DELTA_HEADER = "time-delta-millis";
var STR_CLIENT_VERSION = "client-version";
var STR_CLIENT_ID = "client-id";
var STR_TIME_DELTA_TO_APPLY = "time-delta-to-apply-millis";
var STR_UPLOAD_TIME = "upload-time";
var STR_API_KEY = "apikey";
var STR_MSA_DEVICE_TICKET = "AuthMsaDeviceTicket";
var STR_AUTH_XTOKEN = "AuthXToken";
var STR_SDK_VERSION = "sdk-version";
var STR_NO_RESPONSE_BODY = "NoResponseBody";
var STR_MSFPC = "msfpc";
var STR_TRACE = "trace";
var STR_USER = "user";
//# sourceMappingURL=InternalConstants.js.map

/***/ }),
/* 64 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "EventBatch": () => (/* binding */ EventBatch)
/* harmony export */ });
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(33);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(18);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(63);
/*
 * 1DS JS SDK POST plugin, 3.2.13
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */
/**
* EventBatch.ts
* @author Nev Wylie (newylie)
* @copyright Microsoft 2020
*/


function _getEventMsfpc(theEvent) {
    var intWeb = ((theEvent.ext || {})["intweb"]);
    if (intWeb && (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_0__.isValueAssigned)(intWeb[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_MSFPC])) {
        return intWeb[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_MSFPC];
    }
    return null;
}
function _getMsfpc(theEvents) {
    var msfpc = null;
    for (var lp = 0; msfpc === null && lp < theEvents.length; lp++) {
        msfpc = _getEventMsfpc(theEvents[lp]);
    }
    return msfpc;
}
/**
* This class defines a "batch" events related to a specific iKey, it is used by the PostChannel and HttpManager
* to collect and transfer ownership of events without duplicating them in-memory. This reduces the previous
* array duplication and shared ownership issues that occurred due to race conditions caused by the async nature
* of sending requests.
*/
var EventBatch = /** @class */ (function () {
    /**
     * Private constructor so that caller is forced to use the static create method.
     * @param iKey - The iKey to associate with the events (not validated)
     * @param addEvents - The optional collection of events to assign to this batch - defaults to an empty array.
     */
    function EventBatch(iKey, addEvents) {
        var events = addEvents ? [].concat(addEvents) : [];
        var _self = this;
        var _msfpc = _getMsfpc(events);
        _self.iKey = function () {
            return iKey;
        };
        _self.Msfpc = function () {
            // return the cached value unless it's undefined -- used to avoid cpu
            return _msfpc || _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY;
        };
        _self.count = function () {
            return events.length;
        };
        _self.events = function () {
            return events;
        };
        _self.addEvent = function (theEvent) {
            if (theEvent) {
                events.push(theEvent);
                if (!_msfpc) {
                    // Not found so try and find one
                    _msfpc = _getEventMsfpc(theEvent);
                }
                return true;
            }
            return false;
        };
        _self.split = function (fromEvent, numEvents) {
            // Create a new batch with the same iKey
            var theEvents;
            if (fromEvent < events.length) {
                var cnt = events.length - fromEvent;
                if (!(0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_2__.isNullOrUndefined)(numEvents)) {
                    cnt = numEvents < cnt ? numEvents : cnt;
                }
                theEvents = events.splice(fromEvent, cnt);
                // reset the fetched msfpc value
                _msfpc = _getMsfpc(events);
            }
            return new EventBatch(iKey, theEvents);
        };
    }
    /**
     * Creates a new Event Batch object
     * @param iKey The iKey associated with this batch of events
     */
    EventBatch.create = function (iKey, theEvents) {
        return new EventBatch(iKey, theEvents);
    };
    return EventBatch;
}());

//# sourceMappingURL=EventBatch.js.map

/***/ }),
/* 65 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "HttpManager": () => (/* binding */ HttpManager)
/* harmony export */ });
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(61);
/* harmony import */ var _ClockSkewManager__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(67);
/* harmony import */ var _KillSwitch__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(66);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(18);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(28);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(27);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(33);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(31);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(19);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(63);
/* harmony import */ var _RetryPolicy__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(69);
/* harmony import */ var _Serializer__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(68);
/*
 * 1DS JS SDK POST plugin, 3.2.13
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */
var _a;
/**
* HttpManager.ts
* @author Abhilash Panwar (abpanwar); Hector Hernandez (hectorh); Nev Wylie (newylie)
* @copyright Microsoft 2018-2020
*/







var strSendAttempt = "sendAttempt";
var _noResponseQs = "&" + _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_NO_RESPONSE_BODY + "=true";
/**
 * Identifies the default notification reason to the action names
 */
var _eventActionMap = (_a = {},
    _a[1 /* EventBatchNotificationReason.Paused */] = _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_REQUEUE,
    _a[100 /* EventBatchNotificationReason.RequeueEvents */] = _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_REQUEUE,
    _a[200 /* EventBatchNotificationReason.Complete */] = "sent",
    _a[8004 /* EventBatchNotificationReason.KillSwitch */] = _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_DROPPED,
    _a[8003 /* EventBatchNotificationReason.SizeLimitExceeded */] = _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_DROPPED,
    _a);
var _collectorQsHeaders = {};
var _collectorHeaderToQs = {};
function _addCollectorHeaderQsMapping(qsName, headerName, allowQs) {
    _collectorQsHeaders[qsName] = headerName;
    if (allowQs !== false) {
        _collectorHeaderToQs[headerName] = qsName;
    }
}
_addCollectorHeaderQsMapping(_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_MSA_DEVICE_TICKET, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_MSA_DEVICE_TICKET, false);
_addCollectorHeaderQsMapping(_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CLIENT_VERSION, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CLIENT_VERSION);
_addCollectorHeaderQsMapping(_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CLIENT_ID, "Client-Id");
_addCollectorHeaderQsMapping(_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_API_KEY, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_API_KEY);
_addCollectorHeaderQsMapping(_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_TIME_DELTA_TO_APPLY, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_TIME_DELTA_TO_APPLY);
_addCollectorHeaderQsMapping(_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_UPLOAD_TIME, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_UPLOAD_TIME);
_addCollectorHeaderQsMapping(_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_AUTH_XTOKEN, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_AUTH_XTOKEN);
function _getResponseText(xhr) {
    try {
        return xhr.responseText;
    }
    catch (e) {
        // Best effort, as XHR may throw while XDR wont so just ignore
    }
    return _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_EMPTY;
}
function _hasHeader(headers, header) {
    var hasHeader = false;
    if (headers && header) {
        var keys = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.objKeys)(headers);
        if (keys && keys.length > 0) {
            var lowerHeader = header.toLowerCase();
            for (var lp = 0; lp < keys.length; lp++) {
                var value = keys[lp];
                if (value && (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.hasOwnProperty)(header, value) &&
                    value.toLowerCase() === lowerHeader) {
                    hasHeader = true;
                    break;
                }
            }
        }
    }
    return hasHeader;
}
function _addRequestDetails(details, name, value, useHeaders) {
    if (name && value && value.length > 0) {
        if (useHeaders && _collectorQsHeaders[name]) {
            details.hdrs[_collectorQsHeaders[name]] = value;
            details.useHdrs = true;
        }
        else {
            details.url += "&" + name + "=" + value;
        }
    }
}
function _prependTransports(theTransports, newTransports) {
    if (newTransports) {
        if ((0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.isNumber)(newTransports)) {
            theTransports = [newTransports].concat(theTransports);
        }
        else if ((0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.isArray)(newTransports)) {
            theTransports = newTransports.concat(theTransports);
        }
    }
    return theTransports;
}
/**
 * Class managing the sending of requests.
 */
var HttpManager = /** @class */ (function () {
    /**
     * @constructor
     * @param requestQueue   - The queue that contains the requests to be sent.
     */
    function HttpManager(maxEventsPerBatch, maxConnections, maxRequestRetriesBeforeBackoff, actions, timeoutOverride) {
        this._responseHandlers = [];
        var _urlString = "?cors=true&" + _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CONTENT_TYPE_HEADER.toLowerCase() + "=" + _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.DEFAULT_CONTENT_TYPE;
        var _killSwitch = new _KillSwitch__WEBPACK_IMPORTED_MODULE_2__["default"]();
        var _paused = false;
        var _clockSkewManager = new _ClockSkewManager__WEBPACK_IMPORTED_MODULE_3__["default"]();
        var _useBeacons = false;
        var _outstandingRequests = 0; // Holds the number of outstanding async requests that have not returned a response yet
        var _postManager;
        var _logger;
        var _sendInterfaces;
        var _core;
        var _customHttpInterface = true;
        var _queryStringParameters = [];
        var _headers = {};
        var _batchQueue = [];
        var _serializer = null;
        var _enableEventTimings = false;
        var _cookieMgr;
        var _isUnloading = false;
        var _useHeaders = false;
        var _xhrTimeout;
        var _disableXhrSync;
        var _disableFetchKeepAlive;
        var _canHaveReducedPayload;
        var _addNoResponse;
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_4__["default"])(HttpManager, this, function (_self) {
            var _sendCredentials = true;
            _self.initialize = function (endpointUrl, core, postChannel, httpInterface, channelConfig) {
                var _a;
                if (!channelConfig) {
                    channelConfig = {};
                }
                _urlString = endpointUrl + _urlString;
                _useHeaders = !(0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.isUndefined)(channelConfig.avoidOptions) ? !channelConfig.avoidOptions : true;
                _core = core;
                _cookieMgr = core.getCookieMgr();
                _enableEventTimings = !_core.config.disableEventTimings;
                var enableCompoundKey = !!_core.config.enableCompoundKey;
                _postManager = postChannel;
                _logger = _postManager.diagLog();
                var valueSanitizer = channelConfig.valueSanitizer;
                var stringifyObjects = channelConfig.stringifyObjects;
                if (!(0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.isUndefined)(channelConfig.enableCompoundKey)) {
                    enableCompoundKey = !!channelConfig.enableCompoundKey;
                }
                _xhrTimeout = channelConfig.xhrTimeout;
                _disableXhrSync = !!channelConfig.disableXhrSync;
                _disableFetchKeepAlive = !!channelConfig.disableFetchKeepAlive;
                _addNoResponse = channelConfig.addNoResponse !== false;
                _useBeacons = !(0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_5__.isReactNative)(); // Only use beacons if not running in React Native
                _serializer = new _Serializer__WEBPACK_IMPORTED_MODULE_6__.Serializer(_core, valueSanitizer, stringifyObjects, enableCompoundKey);
                if (!(0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.isNullOrUndefined)(channelConfig.useSendBeacon)) {
                    _useBeacons = !!channelConfig.useSendBeacon;
                }
                var syncHttpInterface = httpInterface;
                var beaconHttpInterface = channelConfig.alwaysUseXhrOverride ? httpInterface : null;
                var fetchSyncHttpInterface = channelConfig.alwaysUseXhrOverride ? httpInterface : null;
                var beaconUnloadTransports = [3 /* TransportType.Beacon */, 2 /* TransportType.Fetch */];
                if (!httpInterface) {
                    _customHttpInterface = false;
                    var location_1 = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_5__.getLocation)();
                    if (location_1 && location_1.protocol && location_1.protocol.toLowerCase() === "file:") {
                        // Special case where a local html file fails with a CORS error on Chromium browsers
                        _sendCredentials = false;
                    }
                    var theTransports = [];
                    if ((0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_5__.isReactNative)()) {
                        // Use Fetch or XDR/XHR
                        theTransports = [2 /* TransportType.Fetch */, 1 /* TransportType.Xhr */];
                        beaconUnloadTransports = [2 /* TransportType.Fetch */, 1 /* TransportType.Xhr */, 3 /* TransportType.Beacon */];
                    }
                    else {
                        // Use XDR/XHR, Fetch or beacons
                        theTransports = [1 /* TransportType.Xhr */, 2 /* TransportType.Fetch */, 3 /* TransportType.Beacon */];
                    }
                    // Prefix any user requested transport(s) values
                    theTransports = _prependTransports(theTransports, channelConfig.transports);
                    httpInterface = _getSenderInterface(theTransports, false);
                    if (!httpInterface) {
                        (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_7__._warnToConsole)(_logger, "No available transport to send events");
                    }
                    syncHttpInterface = _getSenderInterface(theTransports, true);
                }
                if (!beaconHttpInterface) {
                    // Allow overriding the usage of sendBeacon
                    beaconUnloadTransports = _prependTransports(beaconUnloadTransports, channelConfig.unloadTransports);
                    beaconHttpInterface = _getSenderInterface(beaconUnloadTransports, true);
                }
                _canHaveReducedPayload = !_customHttpInterface && ((_useBeacons && (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_5__.isBeaconsSupported)()) || (!_disableFetchKeepAlive && (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_5__.isFetchSupported)(true)));
                _sendInterfaces = (_a = {},
                    _a[0 /* EventSendType.Batched */] = httpInterface,
                    _a[1 /* EventSendType.Synchronous */] = syncHttpInterface || _getSenderInterface([1 /* TransportType.Xhr */, 2 /* TransportType.Fetch */, 3 /* TransportType.Beacon */], true),
                    _a[2 /* EventSendType.SendBeacon */] = beaconHttpInterface || syncHttpInterface || _getSenderInterface([1 /* TransportType.Xhr */], true),
                    _a[3 /* EventSendType.SyncFetch */] = fetchSyncHttpInterface || _getSenderInterface([2 /* TransportType.Fetch */, 3 /* TransportType.Beacon */], true) || syncHttpInterface || _getSenderInterface([1 /* TransportType.Xhr */], true),
                    _a);
            };
            // Special internal method to allow the DebugPlugin to hook embedded objects
            function _getSenderInterface(transports, syncSupport) {
                var transportType = 0 /* TransportType.NotSet */;
                var sendPostFunc = null;
                var lp = 0;
                while (sendPostFunc == null && lp < transports.length) {
                    transportType = transports[lp];
                    if (transportType === 1 /* TransportType.Xhr */) {
                        if ((0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_5__.useXDomainRequest)()) {
                            sendPostFunc = _xdrSendPost;
                        }
                        else if ((0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_5__.isXhrSupported)()) {
                            sendPostFunc = _xhrSendPost;
                        }
                    }
                    else if (transportType === 2 /* TransportType.Fetch */ && (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_5__.isFetchSupported)(syncSupport) && (!syncSupport || (syncSupport && !_disableFetchKeepAlive))) {
                        sendPostFunc = _fetchSendPost;
                    }
                    else if (_useBeacons && transportType === 3 /* TransportType.Beacon */ && (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_5__.isBeaconsSupported)()) {
                        sendPostFunc = _beaconSendPost;
                    }
                    lp++;
                }
                if (sendPostFunc) {
                    return {
                        _transport: transportType,
                        _isSync: syncSupport,
                        sendPOST: sendPostFunc
                    };
                }
                return null;
            }
            _self["_getDbgPlgTargets"] = function () {
                return [_sendInterfaces[0 /* EventSendType.Batched */], _killSwitch, _serializer, _sendInterfaces];
            };
            function _xdrSendPost(payload, oncomplete, sync) {
                // It doesn't support custom headers, so no action is taken with current requestHeaders
                var xdr = new XDomainRequest();
                xdr.open(_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_POST_METHOD, payload.urlString);
                if (payload.timeout) {
                    xdr.timeout = payload.timeout;
                }
                // can't get the status code in xdr.
                xdr.onload = function () {
                    // we will assume onload means the request succeeded.
                    var response = _getResponseText(xdr);
                    _doOnComplete(oncomplete, 200, {}, response);
                    _handleCollectorResponse(response);
                };
                // we will assume onerror means we need to drop the events.
                xdr.onerror = function () {
                    _doOnComplete(oncomplete, 400, {});
                };
                // we will assume ontimeout means we need to retry the events.
                xdr.ontimeout = function () {
                    _doOnComplete(oncomplete, 500, {});
                };
                // https://cypressnorth.com/web-programming-and-development/internet-explorer-aborting-ajax-requests-fixed/
                // tslint:disable-next-line:no-empty
                xdr.onprogress = function () { };
                if (sync) {
                    xdr.send(payload.data);
                }
                else {
                    timeoutOverride.set(function () {
                        xdr.send(payload.data);
                    }, 0);
                }
            }
            function _fetchSendPost(payload, oncomplete, sync) {
                var _a;
                var theUrl = payload.urlString;
                var ignoreResponse = false;
                var responseHandled = false;
                var requestInit = (_a = {
                        body: payload.data,
                        method: _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_POST_METHOD
                    },
                    _a[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_DISABLED_PROPERTY_NAME] = true,
                    _a);
                if (sync) {
                    requestInit.keepalive = true;
                    if (payload._sendReason === 2 /* SendRequestReason.Unload */) {
                        // As a sync request (during unload), it is unlikely that we will get a chance to process the response so
                        // just like beacon send assume that the events have been accepted and processed
                        ignoreResponse = true;
                        if (_addNoResponse) {
                            theUrl += _noResponseQs;
                        }
                    }
                }
                if (_sendCredentials) {
                    // Don't send credentials when URL is file://
                    requestInit.credentials = "include";
                }
                // Only add headers if there are headers to add, due to issue with some polyfills
                if (payload.headers && (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.objKeys)(payload.headers).length > 0) {
                    requestInit.headers = payload.headers;
                }
                fetch(theUrl, requestInit).then(function (response) {
                    var headerMap = {};
                    var responseText = _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_EMPTY;
                    var headers = response.headers;
                    if (headers) {
                        headers["forEach"](function (value, name) {
                            headerMap[name] = value;
                        });
                    }
                    if (response.body) {
                        response.text().then(function (text) {
                            responseText = text;
                        });
                    }
                    if (!responseHandled) {
                        responseHandled = true;
                        _doOnComplete(oncomplete, response.status, headerMap, responseText);
                        _handleCollectorResponse(responseText);
                    }
                })["catch"](function (error) {
                    // In case there is an error in the request. Set the status to 0
                    // so that the events can be retried later.
                    if (!responseHandled) {
                        responseHandled = true;
                        _doOnComplete(oncomplete, 0, {});
                    }
                });
                if (ignoreResponse && !responseHandled) {
                    // Assume success during unload processing
                    responseHandled = true;
                    _doOnComplete(oncomplete, 200, {});
                }
                if (!responseHandled && payload.timeout > 0) {
                    // Simulate timeout
                    timeoutOverride.set(function () {
                        if (!responseHandled) {
                            // Assume a 500 response (which will cause a retry)
                            responseHandled = true;
                            _doOnComplete(oncomplete, 500, {});
                        }
                    }, payload.timeout);
                }
            }
            function _xhrSendPost(payload, oncomplete, sync) {
                var theUrl = payload.urlString;
                function _appendHeader(theHeaders, xhr, name) {
                    if (!theHeaders[name] && xhr && xhr.getResponseHeader) {
                        var value = xhr.getResponseHeader(name);
                        if (value) {
                            theHeaders[name] = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.strTrim)(value);
                        }
                    }
                    return theHeaders;
                }
                function _getAllResponseHeaders(xhr) {
                    var theHeaders = {};
                    if (!xhr.getAllResponseHeaders) {
                        // Firefox 2-63 doesn't have getAllResponseHeaders function but it does have getResponseHeader
                        // Only call these if getAllResponseHeaders doesn't exist, otherwise we can get invalid response errors
                        // as collector is not currently returning the correct header to allow JS to access these headers
                        theHeaders = _appendHeader(theHeaders, xhr, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_TIME_DELTA_HEADER);
                        theHeaders = _appendHeader(theHeaders, xhr, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_KILL_DURATION_HEADER);
                        theHeaders = _appendHeader(theHeaders, xhr, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_KILL_DURATION_SECONDS_HEADER);
                    }
                    else {
                        theHeaders = _convertAllHeadersToMap(xhr.getAllResponseHeaders());
                    }
                    return theHeaders;
                }
                function xhrComplete(xhr, responseTxt) {
                    _doOnComplete(oncomplete, xhr.status, _getAllResponseHeaders(xhr), responseTxt);
                }
                if (sync && payload.disableXhrSync) {
                    sync = false;
                }
                var xhrRequest = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.openXhr)(_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_POST_METHOD, theUrl, _sendCredentials, true, sync, payload.timeout);
                // Set custom headers (e.g. gzip) here (after open())
                (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.objForEachKey)(payload.headers, function (name, value) {
                    xhrRequest.setRequestHeader(name, value);
                });
                xhrRequest.onload = function () {
                    var response = _getResponseText(xhrRequest);
                    xhrComplete(xhrRequest, response);
                    _handleCollectorResponse(response);
                };
                xhrRequest.onerror = function () {
                    xhrComplete(xhrRequest);
                };
                xhrRequest.ontimeout = function () {
                    xhrComplete(xhrRequest);
                };
                xhrRequest.send(payload.data);
            }
            function _doOnComplete(oncomplete, status, headers, response) {
                try {
                    oncomplete(status, headers, response);
                }
                catch (e) {
                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_7__._throwInternal)(_logger, 2 /* eLoggingSeverity.WARNING */, 518 /* _eExtendedInternalMessageId.SendPostOnCompleteFailure */, (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_5__.dumpObj)(e));
                }
            }
            function _beaconSendPost(payload, oncomplete, sync) {
                // Custom headers not supported in sendBeacon payload.headers would be ignored
                var internalPayloadData = payload;
                var status = 200;
                var thePayload = internalPayloadData._thePayload;
                var theUrl = payload.urlString + (_addNoResponse ? _noResponseQs : _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_EMPTY);
                try {
                    var nav_1 = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_5__.getNavigator)();
                    if (!nav_1.sendBeacon(theUrl, payload.data)) {
                        if (thePayload) {
                            // Failed to send entire payload so try and split data and try to send as much events as possible
                            var droppedBatches_1 = [];
                            (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.arrForEach)(thePayload.batches, function (theBatch) {
                                if (droppedBatches_1 && theBatch && theBatch.count() > 0) {
                                    var theEvents = theBatch.events();
                                    for (var lp = 0; lp < theEvents.length; lp++) {
                                        if (!nav_1.sendBeacon(theUrl, _serializer.getEventBlob(theEvents[lp]))) {
                                            // Can't send anymore, so split the batch and drop the rest
                                            droppedBatches_1.push(theBatch.split(lp));
                                            break;
                                        }
                                    }
                                }
                                else {
                                    // Remove all of the events from the existing batch in the payload as the copy includes the original
                                    droppedBatches_1.push(theBatch.split(0));
                                }
                            });
                            _sendBatchesNotification(droppedBatches_1, 8003 /* EventBatchNotificationReason.SizeLimitExceeded */, thePayload.sendType, true);
                        }
                        else {
                            status = 0;
                        }
                    }
                }
                catch (ex) {
                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_7__._warnToConsole)(_logger, "Failed to send telemetry using sendBeacon API. Ex:" + (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_5__.dumpObj)(ex));
                    status = 0;
                }
                finally {
                    _doOnComplete(oncomplete, status, {}, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_EMPTY);
                }
            }
            function _isBeaconPayload(sendType) {
                // Sync Fetch has the same payload limitation as sendBeacon -- 64kb limit, so treat both as a beacon send
                return sendType === 2 /* EventSendType.SendBeacon */ || sendType === 3 /* EventSendType.SyncFetch */;
            }
            function _adjustSendType(sendType) {
                if (_isUnloading && _isBeaconPayload(sendType)) {
                    sendType = 2 /* EventSendType.SendBeacon */;
                }
                return sendType;
            }
            _self.addQueryStringParameter = function (name, value) {
                for (var i = 0; i < _queryStringParameters.length; i++) {
                    if (_queryStringParameters[i].name === name) {
                        _queryStringParameters[i].value = value;
                        return;
                    }
                }
                _queryStringParameters.push({ name: name, value: value });
            };
            _self.addHeader = function (name, value) {
                _headers[name] = value;
            };
            _self.canSendRequest = function () {
                return _hasIdleConnection() && _clockSkewManager.allowRequestSending();
            };
            _self.sendQueuedRequests = function (sendType, sendReason) {
                if ((0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.isUndefined)(sendType)) {
                    sendType = 0 /* EventSendType.Batched */;
                }
                if (_isUnloading) {
                    sendType = _adjustSendType(sendType);
                    sendReason = 2 /* SendRequestReason.Unload */;
                }
                if (_canSendPayload(_batchQueue, sendType, 0)) {
                    _sendBatches(_clearQueue(), 0, false, sendType, sendReason || 0 /* SendRequestReason.Undefined */);
                }
            };
            _self.isCompletelyIdle = function () {
                return !_paused && _outstandingRequests === 0 && _batchQueue.length === 0;
            };
            _self.setUnloading = function (value) {
                _isUnloading = value;
            };
            _self.addBatch = function (theBatch) {
                if (theBatch && theBatch.count() > 0) {
                    // Try and kill the event faster
                    if (_killSwitch.isTenantKilled(theBatch.iKey())) {
                        return false;
                    }
                    _batchQueue.push(theBatch);
                }
                return true;
            };
            /**
             * Queue all the remaining requests to be sent. The requests will be
             * sent using HTML5 Beacons if they are available.
             */
            _self.teardown = function () {
                if (_batchQueue.length > 0) {
                    _sendBatches(_clearQueue(), 0, true, 2 /* EventSendType.SendBeacon */, 2 /* SendRequestReason.Unload */);
                }
            };
            /**
             * Pause the sending of requests. No new requests will be sent.
             */
            _self.pause = function () {
                _paused = true;
            };
            /**
             * Resume the sending of requests.
             */
            _self.resume = function () {
                _paused = false;
                _self.sendQueuedRequests(0 /* EventSendType.Batched */, 4 /* SendRequestReason.Resumed */);
            };
            /**
             * Sends a request synchronously to the Aria collector. This api is used to send
             * a request containing a single immediate event.
             *
             * @param batch - The request to be sent.
             * @param sendReason   - The token used to send the request.
             */
            _self.sendSynchronousBatch = function (batch, sendType, sendReason) {
                // This will not take into account the max connections restriction. Since this is sync, we can
                // only send one of this request at a time and thus should not worry about multiple connections
                // being used to send synchronous events.
                // Increment active connection since we are still going to use a connection to send the request.
                if (batch && batch.count() > 0) {
                    if ((0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.isNullOrUndefined)(sendType)) {
                        sendType = 1 /* EventSendType.Synchronous */;
                    }
                    if (_isUnloading) {
                        sendType = _adjustSendType(sendType);
                        sendReason = 2 /* SendRequestReason.Unload */;
                    }
                    // For sync requests we will not wait for the clock skew.
                    _sendBatches([batch], 0, false, sendType, sendReason || 0 /* SendRequestReason.Undefined */);
                }
            };
            function _hasIdleConnection() {
                return !_paused && _outstandingRequests < maxConnections;
            }
            function _clearQueue() {
                var theQueue = _batchQueue;
                _batchQueue = [];
                return theQueue;
            }
            function _canSendPayload(theBatches, sendType, retryCnt) {
                var result = false;
                if (theBatches && theBatches.length > 0 && !_paused && _sendInterfaces[sendType] && _serializer) {
                    // Always attempt to send synchronous events don't wait for idle or clockSkew
                    // and don't block retry requests if clockSkew is not yet set
                    result = (sendType !== 0 /* EventSendType.Batched */) || (_hasIdleConnection() && (retryCnt > 0 || _clockSkewManager.allowRequestSending()));
                }
                return result;
            }
            function _createDebugBatches(theBatches) {
                var values = {};
                if (theBatches) {
                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.arrForEach)(theBatches, function (theBatch, idx) {
                        values[idx] = {
                            iKey: theBatch.iKey(),
                            evts: theBatch.events()
                        };
                    });
                }
                return values;
            }
            function _sendBatches(theBatches, retryCount, isTeardown, sendType, sendReason) {
                if (!theBatches || theBatches.length === 0) {
                    // Nothing to do
                    return;
                }
                if (_paused) {
                    _sendBatchesNotification(theBatches, 1 /* EventBatchNotificationReason.Paused */, sendType);
                    return;
                }
                // Make sure that if we are unloading the sendType is a supported version
                sendType = _adjustSendType(sendType);
                try {
                    var orgBatches_1 = theBatches;
                    var isSynchronous_1 = sendType !== 0 /* EventSendType.Batched */;
                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_9__.doPerf)(_core, function () { return "HttpManager:_sendBatches"; }, function (perfEvt) {
                        if (perfEvt) {
                            // Perf Monitoring is enabled, so create a "Quick" copy of the original batches so we still report
                            // the original values as part of the perfEvent. This is because theBatches uses .shift() to remove each
                            // batch as they are processed - removing from the original array, so by the time the _createDebugBatches()
                            // function is called the passed in value has changed and therefore the reported value for the perfEvent is incorrect
                            theBatches = theBatches.slice(0);
                        }
                        var droppedBatches = [];
                        var thePayload = null;
                        var serializationStart = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.getTime)();
                        var sendInterface = _sendInterfaces[sendType] || (isSynchronous_1 ? _sendInterfaces[1 /* EventSendType.Synchronous */] : _sendInterfaces[0 /* EventSendType.Batched */]);
                        var sendTransport = sendInterface && sendInterface._transport;
                        // Sync Fetch has the same payload limitation as sendBeacon -- 64kb limit
                        var isReducedPayload = _canHaveReducedPayload && (_isUnloading || _isBeaconPayload(sendType) || (sendTransport === 3 /* TransportType.Beacon */ || (sendInterface._isSync && sendTransport === 2 /* TransportType.Fetch */)));
                        while (_canSendPayload(theBatches, sendType, retryCount)) {
                            var theBatch = theBatches.shift();
                            if (theBatch && theBatch.count() > 0) {
                                if (!_killSwitch.isTenantKilled(theBatch.iKey())) {
                                    // Make sure we have a payload object
                                    thePayload = thePayload || _serializer.createPayload(retryCount, isTeardown, isSynchronous_1, isReducedPayload, sendReason, sendType);
                                    // Add the batch to the current payload
                                    if (!_serializer.appendPayload(thePayload, theBatch, maxEventsPerBatch)) {
                                        // Entire batch was not added so send the payload and retry adding this batch
                                        _doPayloadSend(thePayload, serializationStart, (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.getTime)(), sendReason);
                                        serializationStart = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.getTime)();
                                        theBatches = [theBatch].concat(theBatches);
                                        thePayload = null;
                                    }
                                    else if (thePayload.overflow !== null) {
                                        // Total Payload size was exceeded so send the payload and add the unsent as the next batch to send
                                        theBatches = [thePayload.overflow].concat(theBatches);
                                        thePayload.overflow = null;
                                        _doPayloadSend(thePayload, serializationStart, (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.getTime)(), sendReason);
                                        serializationStart = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.getTime)();
                                        thePayload = null;
                                    }
                                }
                                else {
                                    droppedBatches.push(theBatch);
                                }
                            }
                        }
                        // Make sure to flush any remaining payload
                        if (thePayload) {
                            _doPayloadSend(thePayload, serializationStart, (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.getTime)(), sendReason);
                        }
                        if (theBatches.length > 0) {
                            // Add any unsent batches back to the head of the queue
                            _batchQueue = theBatches.concat(_batchQueue);
                        }
                        // Now send notification about any dropped events
                        _sendBatchesNotification(droppedBatches, 8004 /* EventBatchNotificationReason.KillSwitch */, sendType);
                    }, function () { return ({ batches: _createDebugBatches(orgBatches_1), retryCount: retryCount, isTeardown: isTeardown, isSynchronous: isSynchronous_1, sendReason: sendReason, useSendBeacon: _isBeaconPayload(sendType), sendType: sendType }); }, !isSynchronous_1);
                }
                catch (ex) {
                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_7__._throwInternal)(_logger, 2 /* eLoggingSeverity.WARNING */, 48 /* _eInternalMessageId.CannotSerializeObject */, "Unexpected Exception sending batch: " + (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_5__.dumpObj)(ex));
                }
            }
            function _buildRequestDetails(thePayload, useHeaders) {
                var requestDetails = {
                    url: _urlString,
                    hdrs: {},
                    useHdrs: false // Assume no headers
                };
                if (!useHeaders) {
                    // Attempt to map headers to a query string if possible
                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.objForEachKey)(_headers, function (name, value) {
                        if (_collectorHeaderToQs[name]) {
                            _addRequestDetails(requestDetails, _collectorHeaderToQs[name], value, false);
                        }
                        else {
                            // No mapping, so just include in the headers anyway (may not get sent if using sendBeacon())
                            requestDetails.hdrs[name] = value;
                            requestDetails.useHdrs = true;
                        }
                    });
                }
                else {
                    // Copy the pre-defined headers into the payload headers
                    requestDetails.hdrs = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.extend)(requestDetails.hdrs, _headers);
                    requestDetails.useHdrs = ((0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.objKeys)(requestDetails.hdrs).length > 0);
                }
                _addRequestDetails(requestDetails, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CLIENT_ID, "NO_AUTH", useHeaders);
                _addRequestDetails(requestDetails, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CLIENT_VERSION, _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.FullVersionString, useHeaders);
                var apiQsKeys = _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_EMPTY;
                (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.arrForEach)(thePayload.apiKeys, function (apiKey) {
                    if (apiQsKeys.length > 0) {
                        apiQsKeys += ",";
                    }
                    apiQsKeys += apiKey;
                });
                _addRequestDetails(requestDetails, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_API_KEY, apiQsKeys, useHeaders);
                _addRequestDetails(requestDetails, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_UPLOAD_TIME, (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.dateNow)().toString(), useHeaders);
                var msfpc = _getMsfpc(thePayload);
                if ((0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.isValueAssigned)(msfpc)) {
                    requestDetails.url += "&ext.intweb.msfpc=" + msfpc;
                }
                if (_clockSkewManager.shouldAddClockSkewHeaders()) {
                    _addRequestDetails(requestDetails, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_TIME_DELTA_TO_APPLY, _clockSkewManager.getClockSkewHeaderValue(), useHeaders);
                }
                if (_core.getWParam) {
                    var wParam = _core.getWParam();
                    if (wParam >= 0) {
                        requestDetails.url += "&w=" + wParam;
                    }
                }
                for (var i = 0; i < _queryStringParameters.length; i++) {
                    requestDetails.url += "&" + _queryStringParameters[i].name + "=" + _queryStringParameters[i].value;
                }
                return requestDetails;
            }
            function _setTimingValue(timings, name, value) {
                timings[name] = timings[name] || {};
                timings[name][_postManager.identifier] = value;
            }
            function _doPayloadSend(thePayload, serializationStart, serializationCompleted, sendReason) {
                if (thePayload && thePayload.payloadBlob && thePayload.payloadBlob.length > 0) {
                    var useSendHook_1 = !!_self.sendHook;
                    var sendInterface_1 = _sendInterfaces[thePayload.sendType];
                    // Send all data using a beacon style transport if closing mode is on or channel was teared down
                    if (!_isBeaconPayload(thePayload.sendType) && thePayload.isBeacon && thePayload.sendReason === 2 /* SendRequestReason.Unload */) {
                        sendInterface_1 = _sendInterfaces[2 /* EventSendType.SendBeacon */] || _sendInterfaces[3 /* EventSendType.SyncFetch */] || sendInterface_1;
                    }
                    var useHeaders_1 = _useHeaders;
                    // Disable header usage if we know we are using sendBeacon as additional headers are not supported
                    if (thePayload.isBeacon || sendInterface_1._transport === 3 /* TransportType.Beacon */) {
                        useHeaders_1 = false;
                    }
                    var requestDetails_1 = _buildRequestDetails(thePayload, useHeaders_1);
                    useHeaders_1 = useHeaders_1 || requestDetails_1.useHdrs;
                    var sendEventStart_1 = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.getTime)();
                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_9__.doPerf)(_core, function () { return "HttpManager:_doPayloadSend"; }, function () {
                        // Increment the send attempt count and add timings after packaging (So it's not serialized in the 1st attempt)
                        for (var batchLp = 0; batchLp < thePayload.batches.length; batchLp++) {
                            var theBatch = thePayload.batches[batchLp];
                            var theEvents = theBatch.events();
                            for (var evtLp = 0; evtLp < theEvents.length; evtLp++) {
                                var telemetryItem = theEvents[evtLp];
                                if (_enableEventTimings) {
                                    var timings = telemetryItem.timings = telemetryItem.timings || {};
                                    _setTimingValue(timings, "sendEventStart", sendEventStart_1);
                                    _setTimingValue(timings, "serializationStart", serializationStart);
                                    _setTimingValue(timings, "serializationCompleted", serializationCompleted);
                                }
                                telemetryItem[strSendAttempt] > 0 ? telemetryItem[strSendAttempt]++ : telemetryItem[strSendAttempt] = 1;
                            }
                        }
                        // Note: always sending this notification in a synchronous manner.
                        _sendBatchesNotification(thePayload.batches, (1000 /* EventBatchNotificationReason.SendingUndefined */ + (sendReason || 0 /* SendRequestReason.Undefined */)), thePayload.sendType, true);
                        // Disabling the use of const because of Issue: 
                        // - Task 9227844: [1DS] Some environments and packagers automatically "freeze" objects which are defined as const which causes any mutations to throw
                        // eslint-disable-next-line prefer-const
                        var orgPayloadData = {
                            data: thePayload.payloadBlob,
                            urlString: requestDetails_1.url,
                            headers: requestDetails_1.hdrs,
                            _thePayload: thePayload,
                            _sendReason: sendReason,
                            timeout: _xhrTimeout,
                            disableXhrSync: _disableXhrSync,
                            disableFetchKeepAlive: _disableFetchKeepAlive
                        };
                        // Only automatically add the following headers if already sending headers and we are not attempting to avoid an options call
                        if (useHeaders_1) {
                            if (!_hasHeader(orgPayloadData.headers, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CACHE_CONTROL)) {
                                orgPayloadData.headers[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CACHE_CONTROL] = _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.DEFAULT_CACHE_CONTROL;
                            }
                            if (!_hasHeader(orgPayloadData.headers, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CONTENT_TYPE_HEADER)) {
                                orgPayloadData.headers[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CONTENT_TYPE_HEADER] = _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.DEFAULT_CONTENT_TYPE;
                            }
                        }
                        var sender = null;
                        if (sendInterface_1) {
                            // Send sync requests if the request is immediate or we are tearing down telemetry.
                            sender = function (payload) {
                                // Notify the clock skew manager that we are sending the first request (Potentially blocking all further requests)
                                _clockSkewManager.firstRequestSent();
                                var onComplete = function (status, headers) {
                                    _retryRequestIfNeeded(status, headers, thePayload, sendReason);
                                };
                                var isSync = thePayload.isTeardown || thePayload.isSync;
                                try {
                                    sendInterface_1.sendPOST(payload, onComplete, isSync);
                                    if (_self.sendListener) {
                                        // Send the original payload to the listener
                                        _self.sendListener(orgPayloadData, payload, isSync, thePayload.isBeacon);
                                    }
                                }
                                catch (ex) {
                                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_7__._warnToConsole)(_logger, "Unexpected exception sending payload. Ex:" + (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_5__.dumpObj)(ex));
                                    _doOnComplete(onComplete, 0, {});
                                }
                            };
                        }
                        (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_9__.doPerf)(_core, function () { return "HttpManager:_doPayloadSend.sender"; }, function () {
                            if (sender) {
                                if (thePayload.sendType === 0 /* EventSendType.Batched */) {
                                    _outstandingRequests++;
                                }
                                // Only call the hook if it's defined and we are not using sendBeacon as additional headers are not supported
                                if (useSendHook_1 && !thePayload.isBeacon && sendInterface_1._transport !== 3 /* TransportType.Beacon */) {
                                    // Create a new IPayloadData that is sent into the hook method, so that the hook method
                                    // can't change the object references to the orgPayloadData (it can still change the content -- mainly the headers)
                                    // Disabling the use of const because of Issue: 
                                    // - Task 9227844: [1DS] Some environments and packagers automatically "freeze" objects which are defined as const which causes any mutations to throw
                                    // eslint-disable-next-line prefer-const
                                    var hookData_1 = {
                                        data: orgPayloadData.data,
                                        urlString: orgPayloadData.urlString,
                                        headers: (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.extend)({}, orgPayloadData.headers),
                                        timeout: orgPayloadData.timeout,
                                        disableXhrSync: orgPayloadData.disableXhrSync,
                                        disableFetchKeepAlive: orgPayloadData.disableFetchKeepAlive
                                    };
                                    var senderCalled_1 = false;
                                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_9__.doPerf)(_core, function () { return "HttpManager:_doPayloadSend.sendHook"; }, function () {
                                        try {
                                            _self.sendHook(hookData_1, function (payload) {
                                                senderCalled_1 = true;
                                                // Add back the internal properties
                                                if (!_customHttpInterface && !payload._thePayload) {
                                                    payload._thePayload = payload._thePayload || orgPayloadData._thePayload;
                                                    payload._sendReason = payload._sendReason || orgPayloadData._sendReason;
                                                }
                                                sender(payload);
                                            }, thePayload.isSync || thePayload.isTeardown);
                                        }
                                        catch (ex) {
                                            if (!senderCalled_1) {
                                                // The hook never called the sender -- assume that it never will
                                                sender(orgPayloadData);
                                            }
                                        }
                                    });
                                }
                                else {
                                    sender(orgPayloadData);
                                }
                            }
                        });
                    }, function () { return ({ thePayload: thePayload, serializationStart: serializationStart, serializationCompleted: serializationCompleted, sendReason: sendReason }); }, thePayload.isSync);
                }
                if (thePayload.sizeExceed && thePayload.sizeExceed.length > 0) {
                    // Ensure that we send any discard events for oversize events even when there was no payload to send
                    _sendBatchesNotification(thePayload.sizeExceed, 8003 /* EventBatchNotificationReason.SizeLimitExceeded */, thePayload.sendType);
                }
                if (thePayload.failedEvts && thePayload.failedEvts.length > 0) {
                    // Ensure that we send any discard events for events that could not be serialized even when there was no payload to send
                    _sendBatchesNotification(thePayload.failedEvts, 8002 /* EventBatchNotificationReason.InvalidEvent */, thePayload.sendType);
                }
            }
            function _addEventCompletedTimings(theEvents, sendEventCompleted) {
                if (_enableEventTimings) {
                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.arrForEach)(theEvents, function (theEvent) {
                        var timings = theEvent.timings = theEvent.timings || {};
                        _setTimingValue(timings, "sendEventCompleted", sendEventCompleted);
                    });
                }
            }
            function _retryRequestIfNeeded(status, headers, thePayload, sendReason) {
                var reason = 9000 /* EventBatchNotificationReason.ResponseFailure */;
                var droppedBatches = null;
                var isRetrying = false;
                var backOffTrans = false;
                try {
                    var shouldRetry = true;
                    if (typeof status !== _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_10__.strShimUndefined) {
                        if (headers) {
                            _clockSkewManager.setClockSkew(headers[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_TIME_DELTA_HEADER]);
                            var killDuration = headers[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_KILL_DURATION_HEADER] || headers["kill-duration-seconds"];
                            (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.arrForEach)(_killSwitch.setKillSwitchTenants(headers[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_KILL_TOKENS_HEADER], killDuration), function (killToken) {
                                (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.arrForEach)(thePayload.batches, function (theBatch) {
                                    if (theBatch.iKey() === killToken) {
                                        // Make sure we have initialized the array
                                        droppedBatches = droppedBatches || [];
                                        // Create a copy of the batch with all of the events (and more importantly the action functions)
                                        var removedEvents = theBatch.split(0);
                                        // And then remove the events for the payload batch and reduce the actual number of processed
                                        thePayload.numEvents -= removedEvents.count();
                                        droppedBatches.push(removedEvents);
                                    }
                                });
                            });
                        }
                        // Disabling triple-equals rule to avoid httpOverrides from failing because they are returning a string value
                        // tslint:disable-next-line:triple-equals
                        if (status == 200 || status == 204) {
                            // Response was successfully sent
                            reason = 200 /* EventBatchNotificationReason.Complete */;
                            return;
                        }
                        if (!(0,_RetryPolicy__WEBPACK_IMPORTED_MODULE_11__.retryPolicyShouldRetryForStatus)(status) || thePayload.numEvents <= 0) {
                            // Only retry for specific response codes and if there is still events after kill switch processing
                            shouldRetry = false;
                        }
                        // Derive the notification response from the HttpStatus Code
                        reason = 9000 /* EventBatchNotificationReason.ResponseFailure */ + (status % 1000);
                    }
                    if (shouldRetry) {
                        // The events should be retried -- so change notification to requeue them
                        reason = 100 /* EventBatchNotificationReason.RequeueEvents */;
                        var retryCount_1 = thePayload.retryCnt;
                        if (thePayload.sendType === 0 /* EventSendType.Batched */) {
                            // attempt to resend the entire batch
                            if (retryCount_1 < maxRequestRetriesBeforeBackoff) {
                                isRetrying = true;
                                _doAction(function () {
                                    // try to resend the same batches
                                    if (thePayload.sendType === 0 /* EventSendType.Batched */) {
                                        // Reduce the outstanding request count (if this was an async request) as we didn't reduce the count
                                        // previously and we are about to reschedule our retry attempt and we want an attempt to send
                                        // to occur, it's also required to ensure that a follow up handleRequestFinished() call occurs
                                        _outstandingRequests--;
                                    }
                                    _sendBatches(thePayload.batches, retryCount_1 + 1, thePayload.isTeardown, _isUnloading ? 2 /* EventSendType.SendBeacon */ : thePayload.sendType, 5 /* SendRequestReason.Retry */);
                                }, _isUnloading, (0,_RetryPolicy__WEBPACK_IMPORTED_MODULE_11__.retryPolicyGetMillisToBackoffForRetry)(retryCount_1));
                            }
                            else {
                                backOffTrans = true;
                                if (_isUnloading) {
                                    // we are unloading so don't try and requeue the events otherwise let the events get requeued and resent during the backoff sending
                                    // This will also cause the events to be purged based on the priority (if necessary)
                                    reason = 8001 /* EventBatchNotificationReason.NonRetryableStatus */;
                                }
                            }
                        }
                    }
                }
                finally {
                    if (!isRetrying) {
                        // Make sure the clockSkewManager doesn't blocking further sending of requests once we have a proper response
                        // This won't override any previously sent clock Skew value
                        _clockSkewManager.setClockSkew();
                        _handleRequestFinished(thePayload, reason, sendReason, backOffTrans);
                    }
                    _sendBatchesNotification(droppedBatches, 8004 /* EventBatchNotificationReason.KillSwitch */, thePayload.sendType);
                }
            }
            function _handleRequestFinished(thePayload, batchReason, sendReason, backOffTrans) {
                try {
                    if (backOffTrans) {
                        // Slow down the transmission requests
                        _postManager._backOffTransmission();
                    }
                    if (batchReason === 200 /* EventBatchNotificationReason.Complete */) {
                        if (!backOffTrans && !thePayload.isSync) {
                            // We have a successful async response, so the lets open the floodgates
                            // The reason for checking isSync is to avoid unblocking if beacon send occurred as it
                            // doesn't wait for a response.
                            _postManager._clearBackOff();
                        }
                        _addCompleteTimings(thePayload.batches);
                    }
                    // Send the notifications synchronously
                    _sendBatchesNotification(thePayload.batches, batchReason, thePayload.sendType, true);
                }
                finally {
                    if (thePayload.sendType === 0 /* EventSendType.Batched */) {
                        // we always need to decrement this value otherwise the httpmanager locks up and won't send any more events
                        _outstandingRequests--;
                        // Don't try to send additional queued events if this is a retry operation as the retried
                        // response will eventually call _handleRequestFinished for the retried event
                        if (sendReason !== 5 /* SendRequestReason.Retry */) {
                            // Try and send any other queued batched events
                            _self.sendQueuedRequests(thePayload.sendType, sendReason);
                        }
                    }
                }
            }
            function _addCompleteTimings(theBatches) {
                if (_enableEventTimings) {
                    var sendEventCompleted_1 = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.getTime)();
                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.arrForEach)(theBatches, function (theBatch) {
                        if (theBatch && theBatch.count() > 0) {
                            _addEventCompletedTimings(theBatch.events(), sendEventCompleted_1);
                        }
                    });
                }
            }
            function _doAction(cb, isSync, interval) {
                if (isSync) {
                    cb();
                }
                else {
                    timeoutOverride.set(cb, interval);
                }
            }
            /**
            * Converts the XHR getAllResponseHeaders to a map containing the header key and value.
            */
            // tslint:disable-next-line: align
            function _convertAllHeadersToMap(headersString) {
                var headers = {};
                if ((0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.isString)(headersString)) {
                    var headersArray = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.strTrim)(headersString).split(/[\r\n]+/);
                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.arrForEach)(headersArray, function (headerEntry) {
                        if (headerEntry) {
                            var idx = headerEntry.indexOf(": ");
                            if (idx !== -1) {
                                // The new spec has the headers returning all as lowercase -- but not all browsers do this yet
                                var header = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.strTrim)(headerEntry.substring(0, idx)).toLowerCase();
                                var value = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.strTrim)(headerEntry.substring(idx + 1));
                                headers[header] = value;
                            }
                            else {
                                headers[(0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.strTrim)(headerEntry)] = 1;
                            }
                        }
                    });
                }
                return headers;
            }
            function _getMsfpc(thePayload) {
                for (var lp = 0; lp < thePayload.batches.length; lp++) {
                    var msfpc = thePayload.batches[lp].Msfpc();
                    if (msfpc) {
                        return encodeURIComponent(msfpc);
                    }
                }
                return _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_EMPTY;
            }
            function _handleCollectorResponse(responseText) {
                var responseHandlers = _self._responseHandlers;
                try {
                    for (var i = 0; i < responseHandlers.length; i++) {
                        try {
                            responseHandlers[i](responseText);
                        }
                        catch (e) {
                            (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_7__._throwInternal)(_logger, 1 /* eLoggingSeverity.CRITICAL */, 519 /* _eExtendedInternalMessageId.PostResponseHandler */, "Response handler failed: " + e);
                        }
                    }
                    if (responseText) {
                        var response = JSON.parse(responseText);
                        if ((0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.isValueAssigned)(response.webResult) && (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.isValueAssigned)(response.webResult[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_MSFPC])) {
                            // Set cookie
                            _cookieMgr.set("MSFPC", response.webResult[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_MSFPC], 365 * 86400);
                        }
                    }
                }
                catch (ex) {
                    // Doing nothing
                }
            }
            function _sendBatchesNotification(theBatches, batchReason, sendType, sendSync) {
                if (theBatches && theBatches.length > 0 && actions) {
                    var theAction_1 = actions[_getNotificationAction(batchReason)];
                    if (theAction_1) {
                        var isSyncRequest_1 = sendType !== 0 /* EventSendType.Batched */;
                        (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_9__.doPerf)(_core, function () { return "HttpManager:_sendBatchesNotification"; }, function () {
                            _doAction(function () {
                                try {
                                    theAction_1.call(actions, theBatches, batchReason, isSyncRequest_1, sendType);
                                }
                                catch (e) {
                                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_7__._throwInternal)(_logger, 1 /* eLoggingSeverity.CRITICAL */, 74 /* _eInternalMessageId.NotificationException */, "send request notification failed: " + e);
                                }
                            }, sendSync || isSyncRequest_1, 0);
                        }, function () { return ({ batches: _createDebugBatches(theBatches), reason: batchReason, isSync: isSyncRequest_1, sendSync: sendSync, sendType: sendType }); }, !isSyncRequest_1);
                    }
                }
            }
            function _getNotificationAction(reason) {
                var action = _eventActionMap[reason];
                if (!(0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.isValueAssigned)(action)) {
                    action = _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_OTHER;
                    if (reason >= 9000 /* EventBatchNotificationReason.ResponseFailure */ && reason <= 9999 /* EventBatchNotificationReason.ResponseFailureMax */) {
                        action = _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_RESPONSE_FAIL;
                    }
                    else if (reason >= 8000 /* EventBatchNotificationReason.EventsDropped */ && reason <= 8999 /* EventBatchNotificationReason.EventsDroppedMax */) {
                        action = _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_DROPPED;
                    }
                    else if (reason >= 1000 /* EventBatchNotificationReason.SendingUndefined */ && reason <= 1999 /* EventBatchNotificationReason.SendingEventMax */) {
                        action = _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_SENDING;
                    }
                }
                return action;
            }
        });
    }
// Removed Stub for HttpManager.prototype.initialize.
// Removed Stub for HttpManager.prototype.addQueryStringParameter.
// Removed Stub for HttpManager.prototype.addHeader.
// Removed Stub for HttpManager.prototype.addBatch.
// Removed Stub for HttpManager.prototype.canSendRequest.
// Removed Stub for HttpManager.prototype.sendQueuedRequests.
// Removed Stub for HttpManager.prototype.isCompletelyIdle.
// Removed Stub for HttpManager.prototype.setUnloading.
// Removed Stub for HttpManager.prototype.teardown.
// Removed Stub for HttpManager.prototype.pause.
// Removed Stub for HttpManager.prototype.resume.
// Removed Stub for HttpManager.prototype.sendSynchronousBatch.
    // This is a workaround for an IE8 bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    // this will be removed when ES3 support is dropped.
    HttpManager.__ieDyn=1;

    return HttpManager;
}());

//# sourceMappingURL=HttpManager.js.map

/***/ }),
/* 66 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(18);
/*
 * 1DS JS SDK POST plugin, 3.2.13
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */
/**
* KillSwitch.ts
* @author Abhilash Panwar (abpanwar)
* @copyright Microsoft 2018
*/


var SecToMsMultiplier = 1000;
/**
* Class to stop certain tenants sending events.
*/
var KillSwitch = /** @class */ (function () {
    function KillSwitch() {
        var _killedTokenDictionary = {};
        function _normalizeTenants(values) {
            var result = [];
            if (values) {
                (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_0__.arrForEach)(values, function (value) {
                    result.push((0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_0__.strTrim)(value));
                });
            }
            return result;
        }
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_1__["default"])(KillSwitch, this, function (_self) {
            _self.setKillSwitchTenants = function (killTokens, killDuration) {
                if (killTokens && killDuration) {
                    try {
                        var killedTokens = _normalizeTenants(killTokens.split(","));
                        if (killDuration === "this-request-only") {
                            return killedTokens;
                        }
                        var durationMs = parseInt(killDuration, 10) * SecToMsMultiplier;
                        for (var i = 0; i < killedTokens.length; ++i) {
                            _killedTokenDictionary[killedTokens[i]] = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_0__.dateNow)() + durationMs;
                        }
                    }
                    catch (ex) {
                        return [];
                    }
                }
                return [];
            };
            _self.isTenantKilled = function (tenantToken) {
                var killDictionary = _killedTokenDictionary;
                var name = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_0__.strTrim)(tenantToken);
                if (killDictionary[name] !== undefined && killDictionary[name] > (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_0__.dateNow)()) {
                    return true;
                }
                delete killDictionary[name];
                return false;
            };
        });
    }
// Removed Stub for KillSwitch.prototype.setKillSwitchTenants.
// Removed Stub for KillSwitch.prototype.isTenantKilled.
    // This is a workaround for an IE8 bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    // this will be removed when ES3 support is dropped.
    KillSwitch.__ieDyn=1;

    return KillSwitch;
}());
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (KillSwitch);
//# sourceMappingURL=KillSwitch.js.map

/***/ }),
/* 67 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61);
/*
 * 1DS JS SDK POST plugin, 3.2.13
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */
/**
* ClockSkewManager.ts
* @author Abhilash Panwar (abpanwar)
* @copyright Microsoft 2018
*/

/**
* Class to manage clock skew correction.
*/
var ClockSkewManager = /** @class */ (function () {
    function ClockSkewManager() {
        var _allowRequestSending = true;
        var _shouldAddClockSkewHeaders = true;
        var _isFirstRequest = true;
        var _clockSkewHeaderValue = "use-collector-delta";
        var _clockSkewSet = false;
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_0__["default"])(ClockSkewManager, this, function (_self) {
            /**
             * Determine if requests can be sent.
             * @returns True if requests can be sent, false otherwise.
             */
            _self.allowRequestSending = function () {
                return _allowRequestSending;
            };
            /**
             * Tells the ClockSkewManager that it should assume that the first request has now been sent,
             * If this method had not yet been called AND the clock Skew had not been set this will set
             * allowRequestSending to false until setClockSet() is called.
             */
            _self.firstRequestSent = function () {
                if (_isFirstRequest) {
                    _isFirstRequest = false;
                    if (!_clockSkewSet) {
                        // Block sending until we get the first clock Skew
                        _allowRequestSending = false;
                    }
                }
            };
            /**
             * Determine if clock skew headers should be added to the request.
             * @returns True if clock skew headers should be added, false otherwise.
             */
            _self.shouldAddClockSkewHeaders = function () {
                return _shouldAddClockSkewHeaders;
            };
            /**
             * Gets the clock skew header value.
             * @returns The clock skew header value.
             */
            _self.getClockSkewHeaderValue = function () {
                return _clockSkewHeaderValue;
            };
            /**
             * Sets the clock skew header value. Once clock skew is set this method
             * is no-op.
             * @param timeDeltaInMillis - Time delta to be saved as the clock skew header value.
             */
            _self.setClockSkew = function (timeDeltaInMillis) {
                if (!_clockSkewSet) {
                    if (timeDeltaInMillis) {
                        _clockSkewHeaderValue = timeDeltaInMillis;
                        _shouldAddClockSkewHeaders = true;
                        _clockSkewSet = true;
                    }
                    else {
                        _shouldAddClockSkewHeaders = false;
                    }
                    // Unblock sending
                    _allowRequestSending = true;
                }
            };
        });
    }
// Removed Stub for ClockSkewManager.prototype.allowRequestSending.
// Removed Stub for ClockSkewManager.prototype.firstRequestSent.
// Removed Stub for ClockSkewManager.prototype.shouldAddClockSkewHeaders.
// Removed Stub for ClockSkewManager.prototype.getClockSkewHeaderValue.
// Removed Stub for ClockSkewManager.prototype.setClockSkew.
    // This is a workaround for an IE8 bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    // this will be removed when ES3 support is dropped.
    ClockSkewManager.__ieDyn=1;

    return ClockSkewManager;
}());
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ClockSkewManager);
//# sourceMappingURL=ClockSkewManager.js.map

/***/ }),
/* 68 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Serializer": () => (/* binding */ Serializer)
/* harmony export */ });
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(31);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(18);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(33);
/* harmony import */ var _EventBatch__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(64);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(63);
/*
 * 1DS JS SDK POST plugin, 3.2.13
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */
/**
* Serializer.ts
* @author Abhilash Panwar (abpanwar); Hector Hernandez (hectorh); Nev Wylie (newylie)
* @copyright Microsoft 2018-2020
*/
// @skip-file-minify




/**
 * Note: This is an optimization for V8-based browsers. When V8 concatenates a string,
 * the strings are only joined logically using a "cons string" or "constructed/concatenated
 * string". These containers keep references to one another and can result in very large
 * memory usage. For example, if a 2MB string is constructed by concatenating 4 bytes
 * together at a time, the memory usage will be ~44MB; so ~22x increase. The strings are
 * only joined together when an operation requiring their joining takes place, such as
 * substr(). This function is called when adding data to this buffer to ensure these
 * types of strings are periodically joined to reduce the memory footprint.
 * Setting to every 20 events as the JSON.stringify() may have joined many strings
 * and calling this too much causes a minor delay while processing.
 */
var _MAX_STRING_JOINS = 20;
var RequestSizeLimitBytes = 3984588; // approx 3.8 Mb
var BeaconRequestSizeLimitBytes = 65000; // approx 64kb (the current Edge, Firefox and Chrome max limit)
var MaxRecordSize = 2000000; // approx 2 Mb
var MaxBeaconRecordSize = Math.min(MaxRecordSize, BeaconRequestSizeLimitBytes);
var metadata = "metadata";
var f = "f";
var rCheckDot = /\./;
/**
* Class to handle serialization of event and request.
* Currently uses Bond for serialization. Please note that this may be subject to change.
*/
var Serializer = /** @class */ (function () {
    function Serializer(perfManager, valueSanitizer, stringifyObjects, enableCompoundKey) {
        var strData = "data";
        var strBaseData = "baseData";
        var strExt = "ext";
        var _checkForCompoundkey = !!enableCompoundKey;
        var _processSubMetaData = true;
        var _theSanitizer = valueSanitizer;
        var _isReservedCache = {};
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_0__["default"])(Serializer, this, function (_self) {
            _self.createPayload = function (retryCnt, isTeardown, isSync, isReducedPayload, sendReason, sendType) {
                return {
                    apiKeys: [],
                    payloadBlob: _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY,
                    overflow: null,
                    sizeExceed: [],
                    failedEvts: [],
                    batches: [],
                    numEvents: 0,
                    retryCnt: retryCnt,
                    isTeardown: isTeardown,
                    isSync: isSync,
                    isBeacon: isReducedPayload,
                    sendType: sendType,
                    sendReason: sendReason
                };
            };
            _self.appendPayload = function (payload, theBatch, maxEventsPerBatch) {
                var canAddEvents = payload && theBatch && !payload.overflow;
                if (canAddEvents) {
                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_2__.doPerf)(perfManager, function () { return "Serializer:appendPayload"; }, function () {
                        var theEvents = theBatch.events();
                        var payloadBlob = payload.payloadBlob;
                        var payloadEvents = payload.numEvents;
                        var eventsAdded = false;
                        var sizeExceeded = [];
                        var failedEvts = [];
                        var isBeaconPayload = payload.isBeacon;
                        var requestMaxSize = isBeaconPayload ? BeaconRequestSizeLimitBytes : RequestSizeLimitBytes;
                        var recordMaxSize = isBeaconPayload ? MaxBeaconRecordSize : MaxRecordSize;
                        var lp = 0;
                        var joinCount = 0;
                        while (lp < theEvents.length) {
                            var theEvent = theEvents[lp];
                            if (theEvent) {
                                if (payloadEvents >= maxEventsPerBatch) {
                                    // Maximum events per payload reached, so don't add any more
                                    payload.overflow = theBatch.split(lp);
                                    break;
                                }
                                var eventBlob = _self.getEventBlob(theEvent);
                                if (eventBlob && eventBlob.length <= recordMaxSize) {
                                    // This event will fit into the payload
                                    var blobLength = eventBlob.length;
                                    var currentSize = payloadBlob.length;
                                    if (currentSize + blobLength > requestMaxSize) {
                                        // Request or batch size exceeded, so don't add any more to the payload
                                        payload.overflow = theBatch.split(lp);
                                        break;
                                    }
                                    if (payloadBlob) {
                                        payloadBlob += "\n";
                                    }
                                    payloadBlob += eventBlob;
                                    joinCount++;
                                    // v8 memory optimization only
                                    if (joinCount > _MAX_STRING_JOINS) {
                                        // this substr() should cause the constructed string to join
                                        payloadBlob.substr(0, 1);
                                        joinCount = 0;
                                    }
                                    eventsAdded = true;
                                    payloadEvents++;
                                }
                                else {
                                    if (eventBlob) {
                                        // Single event size exceeded so remove from the batch
                                        sizeExceeded.push(theEvent);
                                    }
                                    else {
                                        failedEvts.push(theEvent);
                                    }
                                    // We also need to remove this event from the existing array, otherwise a notification will be sent
                                    // indicating that it was successfully sent
                                    theEvents.splice(lp, 1);
                                    lp--;
                                }
                            }
                            lp++;
                        }
                        if (sizeExceeded && sizeExceeded.length > 0) {
                            payload.sizeExceed.push(_EventBatch__WEBPACK_IMPORTED_MODULE_3__.EventBatch.create(theBatch.iKey(), sizeExceeded));
                            // Remove the exceeded events from the batch
                        }
                        if (failedEvts && failedEvts.length > 0) {
                            payload.failedEvts.push(_EventBatch__WEBPACK_IMPORTED_MODULE_3__.EventBatch.create(theBatch.iKey(), failedEvts));
                            // Remove the failed events from the batch
                        }
                        if (eventsAdded) {
                            payload.batches.push(theBatch);
                            payload.payloadBlob = payloadBlob;
                            payload.numEvents = payloadEvents;
                            var apiKey = theBatch.iKey();
                            if ((0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_4__.arrIndexOf)(payload.apiKeys, apiKey) === -1) {
                                payload.apiKeys.push(apiKey);
                            }
                        }
                    }, function () { return ({ payload: payload, theBatch: { iKey: theBatch.iKey(), evts: theBatch.events() }, max: maxEventsPerBatch }); });
                }
                return canAddEvents;
            };
            _self.getEventBlob = function (eventData) {
                try {
                    return (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_2__.doPerf)(perfManager, function () { return "Serializer.getEventBlob"; }, function () {
                        var serializedEvent = {};
                        // Adding as dynamic keys for v8 performance
                        serializedEvent.name = eventData.name;
                        serializedEvent.time = eventData.time;
                        serializedEvent.ver = eventData.ver;
                        serializedEvent.iKey = "o:" + (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_5__.getTenantId)(eventData.iKey);
                        // Assigning local var so usage in part b/c don't throw if there is no ext
                        var serializedExt = {};
                        // Part A
                        var eventExt = eventData[strExt];
                        if (eventExt) {
                            // Only assign ext if the event had one (There are tests covering this use case)
                            serializedEvent[strExt] = serializedExt;
                            (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_4__.objForEachKey)(eventExt, function (key, value) {
                                var data = serializedExt[key] = {};
                                // Don't include a metadata callback as we don't currently set metadata Part A fields
                                _processPathKeys(value, data, "ext." + key, true, null, null, true);
                            });
                        }
                        var serializedData = serializedEvent[strData] = {};
                        serializedData.baseType = eventData.baseType;
                        var serializedBaseData = serializedData[strBaseData] = {};
                        // Part B
                        _processPathKeys(eventData.baseData, serializedBaseData, strBaseData, false, [strBaseData], function (pathKeys, name, value) {
                            _addJSONPropertyMetaData(serializedExt, pathKeys, name, value);
                        }, _processSubMetaData);
                        // Part C
                        _processPathKeys(eventData.data, serializedData, strData, false, [], function (pathKeys, name, value) {
                            _addJSONPropertyMetaData(serializedExt, pathKeys, name, value);
                        }, _processSubMetaData);
                        return JSON.stringify(serializedEvent);
                    }, function () { return ({ item: eventData }); });
                }
                catch (e) {
                    return null;
                }
            };
            function _isReservedField(path, name) {
                var result = _isReservedCache[path];
                if (result === undefined) {
                    if (path.length >= 7) {
                        // Do not allow the changing of fields located in the ext.metadata or ext.web extension
                        result = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_4__.strStartsWith)(path, "ext.metadata") || (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_4__.strStartsWith)(path, "ext.web");
                    }
                    _isReservedCache[path] = result;
                }
                return result;
            }
            function _processPathKeys(srcObj, target, thePath, checkReserved, metadataPathKeys, metadataCallback, processSubKeys) {
                (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_4__.objForEachKey)(srcObj, function (key, srcValue) {
                    var prop = null;
                    if (srcValue || (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_5__.isValueAssigned)(srcValue)) {
                        var path = thePath;
                        var name_1 = key;
                        var theMetaPathKeys = metadataPathKeys;
                        var destObj = target;
                        // Handle keys with embedded '.', like "TestObject.testProperty"
                        if (_checkForCompoundkey && !checkReserved && rCheckDot.test(key)) {
                            var subKeys = key.split(".");
                            var keyLen = subKeys.length;
                            if (keyLen > 1) {
                                if (theMetaPathKeys) {
                                    // Create a copy of the meta path keys so we can add the extra ones
                                    theMetaPathKeys = theMetaPathKeys.slice();
                                }
                                for (var lp = 0; lp < keyLen - 1; lp++) {
                                    var subKey = subKeys[lp];
                                    // Add/reuse the sub key object
                                    destObj = destObj[subKey] = destObj[subKey] || {};
                                    path += "." + subKey;
                                    if (theMetaPathKeys) {
                                        theMetaPathKeys.push(subKey);
                                    }
                                }
                                name_1 = subKeys[keyLen - 1];
                            }
                        }
                        var isReserved = checkReserved && _isReservedField(path, name_1);
                        if (!isReserved && _theSanitizer && _theSanitizer.handleField(path, name_1)) {
                            prop = _theSanitizer.value(path, name_1, srcValue, stringifyObjects);
                        }
                        else {
                            prop = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_5__.sanitizeProperty)(name_1, srcValue, stringifyObjects);
                        }
                        if (prop) {
                            // Set the value
                            var newValue = prop.value;
                            destObj[name_1] = newValue;
                            if (metadataCallback) {
                                metadataCallback(theMetaPathKeys, name_1, prop);
                            }
                            if (processSubKeys && typeof newValue === "object" && !(0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_4__.isArray)(newValue)) {
                                var newPath = theMetaPathKeys;
                                if (newPath) {
                                    newPath = newPath.slice();
                                    newPath.push(name_1);
                                }
                                // Make sure we process sub objects as well (for value sanitization and metadata)
                                _processPathKeys(srcValue, newValue, path + "." + name_1, checkReserved, newPath, metadataCallback, processSubKeys);
                            }
                        }
                    }
                });
            }
        });
    }
// Removed Stub for Serializer.prototype.createPayload.
// Removed Stub for Serializer.prototype.appendPayload.
// Removed Stub for Serializer.prototype.getEventBlob.
// Removed Stub for Serializer.prototype.handleField.
// Removed Stub for Serializer.prototype.getSanitizer.
    // This is a workaround for an IE8 bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    // this will be removed when ES3 support is dropped.
    Serializer.__ieDyn=1;

    return Serializer;
}());

/**
 * @ignore
 */
function _addJSONPropertyMetaData(json, propKeys, name, propertyValue) {
    if (propertyValue && json) {
        var encodedTypeValue = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_5__.getCommonSchemaMetaData)(propertyValue.value, propertyValue.kind, propertyValue.propertyType);
        if (encodedTypeValue > -1) {
            // Add the root metadata
            var metaData = json[metadata];
            if (!metaData) {
                // Sets the root 'f'
                metaData = json[metadata] = { f: {} };
            }
            var metaTarget = metaData[f];
            if (!metaTarget) {
                // This can occur if someone has manually added an ext.metadata object
                // Such as ext.metadata.privLevel and ext.metadata.privTags
                metaTarget = metaData[f] = {};
            }
            // Traverse the metadata path and build each object (contains an 'f' key) -- if required
            if (propKeys) {
                for (var lp = 0; lp < propKeys.length; lp++) {
                    var key = propKeys[lp];
                    if (!metaTarget[key]) {
                        metaTarget[key] = { f: {} };
                    }
                    var newTarget = metaTarget[key][f];
                    if (!newTarget) {
                        // Not expected, but can occur if the metadata context was pre-created as part of the event
                        newTarget = metaTarget[key][f] = {};
                    }
                    metaTarget = newTarget;
                }
            }
            metaTarget = metaTarget[name] = {};
            if ((0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_4__.isArray)(propertyValue.value)) {
                metaTarget["a"] = {
                    t: encodedTypeValue
                };
            }
            else {
                metaTarget["t"] = encodedTypeValue;
            }
        }
    }
}
//# sourceMappingURL=Serializer.js.map

/***/ }),
/* 69 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "retryPolicyGetMillisToBackoffForRetry": () => (/* binding */ retryPolicyGetMillisToBackoffForRetry),
/* harmony export */   "retryPolicyShouldRetryForStatus": () => (/* binding */ retryPolicyShouldRetryForStatus)
/* harmony export */ });
/*
 * 1DS JS SDK POST plugin, 3.2.13
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */
/**
* RetryPolicy.ts
* @author Abhilash Panwar (abpanwar)
* @copyright Microsoft 2018
*/
var RandomizationLowerThreshold = 0.8;
var RandomizationUpperThreshold = 1.2;
var BaseBackoff = 3000;
var MaxBackoff = 600000;
/**
 * Determine if the request should be retried for the given status code.
 * The below expression reads that we should only retry for:
 *      - HttpStatusCodes that are smaller than 300.
 *      - HttpStatusCodes greater or equal to 500 (except for 501-NotImplement
 *        and 505-HttpVersionNotSupport).
 *      - HttpStatusCode 408-RequestTimeout.
 *      - HttpStatusCode 429.
 * This is based on Microsoft.WindowsAzure.Storage.RetryPolicies.ExponentialRetry class
 * @param httpStatusCode - The status code returned for the request.
 * @returns True if request should be retried, false otherwise.
 */
function retryPolicyShouldRetryForStatus(httpStatusCode) {
    /* tslint:disable:triple-equals */
    // Disabling triple-equals rule to avoid httpOverrides from failing because they are returning a string value
    return !((httpStatusCode >= 300 && httpStatusCode < 500 && httpStatusCode != 408 && httpStatusCode != 429)
        || (httpStatusCode == 501)
        || (httpStatusCode == 505));
    /* tslint:enable:triple-equals */
}
/**
 * Gets the number of milliseconds to back off before retrying the request. The
 * back off duration is exponentially scaled based on the number of retries already
 * done for the request.
 * @param retriesSoFar - The number of times the request has already been retried.
 * @returns The back off duration for the request before it can be retried.
 */
function retryPolicyGetMillisToBackoffForRetry(retriesSoFar) {
    var waitDuration = 0;
    var minBackoff = BaseBackoff * RandomizationLowerThreshold;
    var maxBackoff = BaseBackoff * RandomizationUpperThreshold;
    var randomBackoff = Math.floor(Math.random() * (maxBackoff - minBackoff)) + minBackoff;
    waitDuration = Math.pow(2, retriesSoFar) * randomBackoff;
    return Math.min(waitDuration, MaxBackoff);
}
//# sourceMappingURL=RetryPolicy.js.map

/***/ }),
/* 70 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BaseTelemetrySender": () => (/* binding */ BaseTelemetrySender)
/* harmony export */ });
/*---------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/
var InstantiationStatus;
(function (InstantiationStatus) {
    InstantiationStatus[InstantiationStatus["NOT_INSTANTIATED"] = 0] = "NOT_INSTANTIATED";
    InstantiationStatus[InstantiationStatus["INSTANTIATING"] = 1] = "INSTANTIATING";
    InstantiationStatus[InstantiationStatus["INSTANTIATED"] = 2] = "INSTANTIATED";
})(InstantiationStatus || (InstantiationStatus = {}));
class BaseTelemetrySender {
    constructor(key, clientFactory) {
        // Whether or not the client has been instantiated
        this._instantiationStatus = InstantiationStatus.NOT_INSTANTIATED;
        // Queues used to store events until the sender is ready
        this._eventQueue = [];
        this._exceptionQueue = [];
        this._clientFactory = clientFactory;
        this._key = key;
    }
    /**
     * Sends the event to the passed in telemetry client
     * The sender does no telemetry level checks as those are done by the reporter.
     * @param eventName The name of the event to log
     * @param data The data contanied in the event
     */
    sendEventData(eventName, data) {
        if (!this._telemetryClient) {
            if (this._instantiationStatus !== InstantiationStatus.INSTANTIATED) {
                this._eventQueue.push({ eventName, data });
            }
            return;
        }
        this._telemetryClient.logEvent(eventName, data);
    }
    /**
     * Sends an exception to the passed in telemetry client
     * The sender does no telemetry level checks as those are done by the reporter.
     * @param exception The exception to collect
     * @param data Data associated with the exception
     */
    sendErrorData(exception, data) {
        if (!this._telemetryClient) {
            if (this._instantiationStatus !== InstantiationStatus.INSTANTIATED) {
                this._exceptionQueue.push({ exception, data });
            }
            return;
        }
        const errorData = { stack: exception.stack, message: exception.message, name: exception.name };
        if (data) {
            data.properties = { ...data.properties, ...errorData };
        }
        else {
            data = { properties: errorData };
        }
        this._telemetryClient.logEvent("unhandlederror", data);
    }
    /**
     * Flushes the buffered telemetry data
     */
    async flush() {
        return this._telemetryClient?.flush();
    }
    async dispose() {
        if (this._telemetryClient) {
            await this._telemetryClient.dispose();
            this._telemetryClient = undefined;
        }
        return;
    }
    /**
     * Flushes the queued events that existed before the client was instantiated
     */
    _flushQueues() {
        this._eventQueue.forEach(({ eventName, data }) => this.sendEventData(eventName, data));
        this._eventQueue = [];
        this._exceptionQueue.forEach(({ exception, data }) => this.sendErrorData(exception, data));
        this._exceptionQueue = [];
    }
    /**
     * Instantiates the telemetry client to make the sender "active"
     */
    instantiateSender() {
        if (this._instantiationStatus !== InstantiationStatus.NOT_INSTANTIATED) {
            return;
        }
        this._instantiationStatus = InstantiationStatus.INSTANTIATING;
        // Call the client factory to get the client and then let it know it's instatntiated
        this._clientFactory(this._key).then(client => {
            this._telemetryClient = client;
            this._instantiationStatus = InstantiationStatus.INSTANTIATED;
            this._flushQueues();
        }).catch(err => {
            console.error(err);
            // If it failed to instntiate, then we don't want to try again.
            // So we mark it as instantiated. See #94
            this._instantiationStatus = InstantiationStatus.INSTANTIATED;
        });
    }
}
//# sourceMappingURL=baseTelemetrySender.js.map

/***/ }),
/* 71 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AppInsightsCore": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.AppInsightsCore),
/* harmony export */   "ApplicationInsights": () => (/* binding */ ApplicationInsights),
/* harmony export */   "Sender": () => (/* reexport safe */ _microsoft_applicationinsights_channel_js__WEBPACK_IMPORTED_MODULE_11__.Sender),
/* harmony export */   "SeverityLevel": () => (/* reexport safe */ _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_13__.SeverityLevel),
/* harmony export */   "arrForEach": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_12__.arrForEach),
/* harmony export */   "isNullOrUndefined": () => (/* reexport safe */ _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.isNullOrUndefined),
/* harmony export */   "proxyFunctions": () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_7__.proxyFunctions),
/* harmony export */   "throwError": () => (/* reexport safe */ _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.throwError)
/* harmony export */ });
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(90);
/* harmony import */ var _microsoft_applicationinsights_channel_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(170);
/* harmony import */ var _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(166);
/* harmony import */ var _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(169);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(72);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(79);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(99);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(106);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(73);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(81);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(89);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(165);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(95);
/* harmony import */ var _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(197);
/*
 * Application Insights JavaScript Web SDK - Basic, 3.0.2
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */








var defaultConfigValues = {
    diagnosticLogInterval: (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.cfgDfValidate)(_chkDiagLevel, 10000)
};
function _chkDiagLevel(value) {
    // Make sure we have a value > 0
    return value && value > 0;
}
/**
 * @export
 * @class ApplicationInsights
 */
var ApplicationInsights = /** @class */ (function () {
    /**
     * Creates an instance of ApplicationInsights.
     * @param config
     * @memberof ApplicationInsights
     */
    function ApplicationInsights(config) {
        var core = new _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.AppInsightsCore();
        var _config;
        // initialize the queue and config in case they are undefined
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.isNullOrUndefined)(config) ||
            ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.isNullOrUndefined)(config[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_INSTRUMENTATION_KEY /* @min:%2einstrumentationKey */]) && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.isNullOrUndefined)(config[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_CONNECTION_STRING /* @min:%2econnectionString */]))) {
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.throwError)("Invalid input configuration");
        }
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_5__["default"])(ApplicationInsights, this, function (_self) {
            // Define _self.config
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.objDefine)(_self, "config", {
                g: function () { return _config; }
            });
            _initialize();
            _self.initialize = _initialize;
            (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_7__.proxyFunctions)(_self, core, [
                "track",
                "flush",
                "pollInternalLogs",
                "stopPollingInternalLogs",
                "unload",
                "getPlugin",
                "addPlugin",
                "evtNamespace",
                "addUnloadCb",
                "onCfgChange"
            ]);
            function _initialize() {
                var cfgHandler = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__.createDynamicConfig)(config || {}, defaultConfigValues);
                _config = cfgHandler.cfg;
                core.addUnloadHook((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__.onConfigChange)(cfgHandler, function () {
                    if (_config[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_CONNECTION_STRING /* @min:%2econnectionString */]) {
                        var cs = (0,_microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_9__.parseConnectionString)(_config[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_CONNECTION_STRING /* @min:%2econnectionString */]);
                        var ingest = cs.ingestionendpoint;
                        _config.endpointUrl = ingest ? (ingest + _microsoft_applicationinsights_common__WEBPACK_IMPORTED_MODULE_10__.DEFAULT_BREEZE_PATH) : _config.endpointUrl; // only add /v2/track when from connectionstring
                        _config[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_INSTRUMENTATION_KEY /* @min:%2einstrumentationKey */] = cs.instrumentationkey || _config[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_INSTRUMENTATION_KEY /* @min:%2einstrumentationKey */];
                    }
                }));
                // initialize core
                core.initialize(_config, [new _microsoft_applicationinsights_channel_js__WEBPACK_IMPORTED_MODULE_11__.Sender()]);
            }
        });
    }
// Removed Stub for ApplicationInsights.prototype.initialize.
// Removed Stub for ApplicationInsights.prototype.track.
// Removed Stub for ApplicationInsights.prototype.flush.
// Removed Stub for ApplicationInsights.prototype.pollInternalLogs.
// Removed Stub for ApplicationInsights.prototype.stopPollingInternalLogs.
// Removed Stub for ApplicationInsights.prototype.unload.
// Removed Stub for ApplicationInsights.prototype.getPlugin.
// Removed Stub for ApplicationInsights.prototype.addPlugin.
// Removed Stub for ApplicationInsights.prototype.evtNamespace.
// Removed Stub for ApplicationInsights.prototype.addUnloadCb.
// Removed Stub for ApplicationInsights.prototype.onCfgChange.
    // This is a workaround for an IE bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    ApplicationInsights.__ieDyn=1;

    return ApplicationInsights;
}());




//# sourceMappingURL=index.js.map

/***/ }),
/* 72 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "cfgDfBlockPropValue": () => (/* binding */ cfgDfBlockPropValue),
/* harmony export */   "cfgDfBoolean": () => (/* binding */ cfgDfBoolean),
/* harmony export */   "cfgDfFunc": () => (/* binding */ cfgDfFunc),
/* harmony export */   "cfgDfMerge": () => (/* binding */ cfgDfMerge),
/* harmony export */   "cfgDfSet": () => (/* binding */ cfgDfSet),
/* harmony export */   "cfgDfString": () => (/* binding */ cfgDfString),
/* harmony export */   "cfgDfValidate": () => (/* binding */ cfgDfValidate)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(73);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(76);
/* harmony import */ var _JavaScriptSDK_InternalConstants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(78);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(77);
/*
 * Application Insights JavaScript SDK - Core, 3.0.2
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */





/**
 * @internal
 * @ignore
 * @param str
 * @param defaultValue
 * @returns
 */
function _stringToBoolOrDefault(theValue, defaultValue, theConfig) {
    if (!theValue && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isNullOrUndefined)(theValue)) {
        return defaultValue;
    }
    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isBoolean)(theValue)) {
        return theValue;
    }
    return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.asString)(theValue)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */]() === "true";
}
/**
 * Helper which returns an IConfigDefaultCheck instance with the field defined as an object
 * that should be merged
 * @param defaultValue - The default value to apply it not provided or it's not valid
 * @returns a new IConfigDefaultCheck structure
 */
function cfgDfMerge(defaultValue) {
    return {
        mrg: true,
        v: defaultValue
    };
}
/**
 * Helper which returns an IConfigDefaultCheck instance with the provided field set function
 * @param setter - The IConfigCheckFn function to validate the user provided value
 * @param defaultValue - The default value to apply it not provided or it's not valid
 * @returns a new IConfigDefaultCheck structure
 */
function cfgDfSet(setter, defaultValue) {
    return {
        set: setter,
        v: defaultValue
    };
}
/**
 * Helper which returns an IConfigDefaultCheck instance with the provided field validator
 * @param validator - The IConfigCheckFn function to validate the user provided value
 * @param defaultValue - The default value to apply it not provided or it's not valid
 * @param fallBackName - The fallback configuration name if the current value is not available
 * @returns a new IConfigDefaultCheck structure
 */
function cfgDfValidate(validator, defaultValue, fallBackName) {
    return {
        fb: fallBackName,
        isVal: validator,
        v: defaultValue
    };
}
/**
 * Helper which returns an IConfigDefaultCheck instance that will validate and convert the user
 * provided value to a boolean from a string or boolean value
 * @param defaultValue - The default value to apply it not provided or it's not valid
 * @param fallBackName - The fallback configuration name if the current value is not available
 * @returns a new IConfigDefaultCheck structure
 */
function cfgDfBoolean(defaultValue, fallBackName) {
    return {
        fb: fallBackName,
        set: _stringToBoolOrDefault,
        v: !!defaultValue
    };
}
/**
 * Helper which returns an IConfigDefaultCheck instance that will validate that the user
 * provided value is a function.
 * @param defaultValue - The default value to apply it not provided or it's not valid
 * @returns a new IConfigDefaultCheck structure
 */
function cfgDfFunc(defaultValue) {
    return {
        isVal: _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isFunction,
        v: defaultValue || null
    };
}
/**
 * Helper which returns an IConfigDefaultCheck instance that will validate that the user
 * provided value is a function.
 * @param defaultValue - The default string value to apply it not provided or it's not valid, defaults to an empty string
 * @returns a new IConfigDefaultCheck structure
 */
function cfgDfString(defaultValue) {
    return {
        isVal: _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isString,
        v: (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.asString)(defaultValue || _JavaScriptSDK_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_EMPTY)
    };
}
/**
 * Helper which returns an IConfigDefaultCheck instance identifying that value associated with this property
 * should not have it's properties converted into a dynamic config properties.
 * @param defaultValue - The default value to apply it not provided or it's not valid
 * @returns a new IConfigDefaultCheck structure
 */
function cfgDfBlockPropValue(defaultValue) {
    var _a;
    return _a = {},
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_BLK_VAL /* @min:blkVal */] = true,
        _a.v = defaultValue,
        _a;
}
//# sourceMappingURL=ConfigDefaultHelpers.js.map

/***/ }),
/* 73 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "_createIs": () => (/* binding */ _createIs),
/* harmony export */   "_createObjIs": () => (/* binding */ _createObjIs),
/* harmony export */   "isArray": () => (/* binding */ isArray),
/* harmony export */   "isArrayBuffer": () => (/* binding */ isArrayBuffer),
/* harmony export */   "isBlob": () => (/* binding */ isBlob),
/* harmony export */   "isBoolean": () => (/* binding */ isBoolean),
/* harmony export */   "isDate": () => (/* binding */ isDate),
/* harmony export */   "isDefined": () => (/* binding */ isDefined),
/* harmony export */   "isError": () => (/* binding */ isError),
/* harmony export */   "isFile": () => (/* binding */ isFile),
/* harmony export */   "isFormData": () => (/* binding */ isFormData),
/* harmony export */   "isFunction": () => (/* binding */ isFunction),
/* harmony export */   "isNotTruthy": () => (/* binding */ isNotTruthy),
/* harmony export */   "isNullOrUndefined": () => (/* binding */ isNullOrUndefined),
/* harmony export */   "isNumber": () => (/* binding */ isNumber),
/* harmony export */   "isObject": () => (/* binding */ isObject),
/* harmony export */   "isPrimitive": () => (/* binding */ isPrimitive),
/* harmony export */   "isPrimitiveType": () => (/* binding */ isPrimitiveType),
/* harmony export */   "isPromise": () => (/* binding */ isPromise),
/* harmony export */   "isPromiseLike": () => (/* binding */ isPromiseLike),
/* harmony export */   "isRegExp": () => (/* binding */ isRegExp),
/* harmony export */   "isStrictNullOrUndefined": () => (/* binding */ isStrictNullOrUndefined),
/* harmony export */   "isStrictUndefined": () => (/* binding */ isStrictUndefined),
/* harmony export */   "isString": () => (/* binding */ isString),
/* harmony export */   "isThenable": () => (/* binding */ isThenable),
/* harmony export */   "isTruthy": () => (/* binding */ isTruthy),
/* harmony export */   "isTypeof": () => (/* binding */ isTypeof),
/* harmony export */   "isUndefined": () => (/* binding */ isUndefined),
/* harmony export */   "objToString": () => (/* binding */ objToString)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(74);
/* harmony import */ var _safe_get__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(75);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */


var PRIMITIVE_TYPES = [_internal_constants__WEBPACK_IMPORTED_MODULE_0__.STRING, _internal_constants__WEBPACK_IMPORTED_MODULE_0__.NUMBER, _internal_constants__WEBPACK_IMPORTED_MODULE_0__.BOOLEAN, _internal_constants__WEBPACK_IMPORTED_MODULE_0__.UNDEFINED, "symbol", "bigint"];
/**
 * @ignore
 * @internal
 * Create and returns a function that will return `true` if the argument passed
 * to it matches the provided type.
 * @param theType - The type to match against the `typeof value`
 * @returns A function which takes a single argument and returns a boolean
 */
function _createIs(theType) {
    return function (value) {
        return typeof value === theType;
    };
}
/**
 * @ignore
 * @internal
 * Create and returns a function that will return `true` if the argument passed
 * to it matches the object type specified based on {@link objToString}.
 * @param - The object name to match for the `objToString(value)`
 * @returns A function which takes a single argument and returns a boolean
 */
function _createObjIs(theName) {
    var theType = "[object " + theName + "]";
    return function (value) {
        return !!(value && objToString(value) === theType);
    };
}
/**
 * The `objToString()` method returns a string representing the object. This explicitly
 * always calls the `Object.prototype.toString()` method.
 *
 * An object's toString() method is most commonly invoked when that object undergoes:
 * - explicit type conversion to a string (for example, String(myObject))
 * - implicit type coercion into a string (for example, myObject + "hello world")
 *
 * @group Object
 * @param value - The object to be converted into a string
 * @returns A string representation of the object
 * @example
 * ```ts
 * objToString(new Date()); // [object Date]
 * objToString(new String()); // [object String]
 *
 * // Math has its Symbol.toStringTag
 * objToString(Math); // [object Math]
 *
 * objToString(undefined); // [object Undefined]
 * objToString(null); // [object Null]
 * ```
 */
function objToString(value) {
    return _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjProto.toString.call(value);
}
/**
 * Validate if the provided value object is of the expected type
 * @group Type Identity
 * @param value - The value to check
 * @param theType - The expected type name as a string
 * @returns `true` if the value matches the provided type
 */
function isTypeof(value, theType) {
    return typeof value === theType;
}
/**
 * Checks if the provided value is undefined or contains the string value "undefined",
 * if you want to consider the string value as undefined see {@link isStrictUndefined}
 * @group Type Identity
 * @group Value Check
 * @param value - The value to check
 * @returns true if the value is undefined or "undefined", otherwise false
 * @example
 * ```ts
 * isUndefined(undefined);              // true
 * isUndefined("undefined");            // true
 *
 * isUndefined(null);                   // false
 * isUndefined("null");                 // false
 * isUndefined("1");                    // false
 * isUndefined("aa");                   // false
 * isUndefined(new Date());             // false
 * isUndefined(1);                      // false
 * isUndefined("");                     // false
 * isUndefined(_dummyFunction);         // false
 * isUndefined([]);                     // false
 * isUndefined(new Array(1));           // false
 * isUndefined(true);                   // false
 * isUndefined(false);                  // false
 * isUndefined("true");                 // false
 * isUndefined("false");                // false
 * isUndefined(new Boolean(true));      // false
 * isUndefined(new Boolean(false));     // false
 * isUndefined(new Boolean("true"));    // false
 * isUndefined(new Boolean("false"));   // false
 * isUndefined(Boolean(true));          // false
 * isUndefined(Boolean(false));         // false
 * isUndefined(Boolean("true"));        // false
 * isUndefined(Boolean("false"));       // false
 * isUndefined(new RegExp(""));         // false
 * isUndefined(new ArrayBuffer(0));     // false
 * isUndefined(new Error("Test Error"));// false
 * isUndefined(new TypeError("Test TypeError"));    // false
 * isUndefined(new TestError("Test TestError"));    // false
 * isUndefined(_dummyError());          // false
 * isUndefined(Promise.reject());       // false
 * isUndefined(Promise.resolve());      // false
 * isUndefined(new Promise(() => {}));  // false
 * isUndefined(_simplePromise());       // false
 * isUndefined(_simplePromiseLike());   // false
 * isUndefined(Object.create(null));    // false
 * isUndefined(polyObjCreate(null));    // false
 * ```
 */
function isUndefined(value) {
    return typeof value === _internal_constants__WEBPACK_IMPORTED_MODULE_0__.UNDEFINED || value === _internal_constants__WEBPACK_IMPORTED_MODULE_0__.UNDEFINED;
}
/**
 * Checks if the provided value is undefined, a string value of "undefined" is NOT considered
 * to be undefined.
 * @group Type Identity
 * @group Value Check
 * @param value - The value to check
 * @returns true if the typeof value === UNDEFINED
 * @example
 * ```ts
 * isStrictUndefined(undefined);    // true
 *
 * isStrictUndefined(null);         // false
 * isStrictUndefined("null");       // false
 * isStrictUndefined("undefined");  // false
 * isStrictUndefined("1");          // false
 * isStrictUndefined("aa");         // false
 * isStrictUndefined(new Date());   // false
 * isStrictUndefined(0);            // false
 * isStrictUndefined(1);            // false
 * isStrictUndefined("");           // false
 * ```
 */
function isStrictUndefined(arg) {
    return !isDefined(arg);
}
/**
 * Checks if the provided value is null, undefined or contains the string value of "undefined".
 * @group Type Identity
 * @group Value Check
 * @param value - The value to check
 * @returns `true` if the value is `null` or `undefined`
 * @example
 * ```ts
 * isNullOrUndefined(null);         // true
 * isNullOrUndefined(undefined);    // true
 * isNullOrUndefined("undefined");  // true
 *
 * let value = null;
 * isNullOrUndefined(value);        // true
 * let value = undefined;
 * isNullOrUndefined(value);        // true
 *
 * isNullOrUndefined("");           // false
 * isNullOrUndefined(0);            // false
 * isNullOrUndefined(new Date());   // false
 * isNullOrUndefined(true);         // false
 * isNullOrUndefined(false);        // false
 * ```
 */
function isNullOrUndefined(value) {
    return value === _internal_constants__WEBPACK_IMPORTED_MODULE_0__.NULL_VALUE || isUndefined(value);
}
/**
 * Checks if the provided value is null, undefined only, a string value of "undefined" is NOT considered
 * to be undefined.
 * @group Type Identity
 * @group Value Check
 * @param value - The value to check
 * @returns
 * @example
 * ```ts
 * isStrictNullOrUndefined(null);         // true
 * isStrictNullOrUndefined(undefined);    // true
 * isStrictNullOrUndefined("undefined");  // false
 *
 * let value = null;
 * isStrictNullOrUndefined(value);        // true
 * let value = undefined;
 * isStrictNullOrUndefined(value);        // true
 *
 * isStrictNullOrUndefined("");           // false
 * isStrictNullOrUndefined(0);            // false
 * isStrictNullOrUndefined(new Date());   // false
 * isStrictNullOrUndefined(true);         // false
 * isStrictNullOrUndefined(false);        // false
 * ```
 */
function isStrictNullOrUndefined(value) {
    return value === _internal_constants__WEBPACK_IMPORTED_MODULE_0__.NULL_VALUE || !isDefined(value);
}
/**
 * Checks if the passed value is defined, which means it has any value and is not undefined.
 * A string value of "undefined" is considered to be defined.
 * @group Value Check
 * @param arg - The value to check
 * @returns true if arg has a value (is not === undefined)
 * @example
 * ```ts
 * isDefined(null);         // false
 * isDefined(undefined);    // false
 * isDefined("undefined");  // true
 *
 * let value = null;
 * isDefined(value);        // false
 * let value = undefined;
 * isDefined(value);        // false
 *
 * isDefined("");           // true
 * isDefined(0);            // true
 * isDefined(new Date());   // true
 * isDefined(true);         // true
 * isDefined(false);        // true
 * ```
 */
function isDefined(arg) {
    return !!arg || arg !== _internal_constants__WEBPACK_IMPORTED_MODULE_0__.UNDEF_VALUE;
}
/**
 * Identifies whether the provided value is a JavaScript [primitive](https://developer.mozilla.org/en-US/docs/Glossary/Primitive)
 * which is when is it not an object and has no methods or properties. There are 7 primitive data types:
 * - string
 * - number
 * - bigint
 * - boolean
 * - undefined
 * - null
 * - symbol
 *
 * Most of the time, a primitive value is represented directly at the lowest level of the language implementation.
 *
 * All primitives are immutable; that is, they cannot be altered. It is important not to confuse a primitive itself
 * with a variable assigned a primitive value. The variable may be reassigned to a new value, but the existing value
 * can not be changed in the ways that objects, arrays, and functions can be altered. The language does not offer
 * utilities to mutate primitive values.
 * @since 0.4.4
 * @group Type Identity
 * @param value - The value to check whether it's a primitive value
 * @example
 * ```ts
 * isPrimitive(null);                   // true
 * isPrimitive(undefined);              // true
 * isPrimitive("null");                 // true
 * isPrimitive("undefined");            // true
 * isPrimitive("1");                    // true
 * isPrimitive("aa");                   // true
 * isPrimitive(1);                      // true
 * isPrimitive(Number(2));              // true
 * isPrimitive("");                     // true
 * isPrimitive(String(""));             // true
 * isPrimitive(true);                   // true
 * isPrimitive(false);                  // true
 * isPrimitive("true");                 // true
 * isPrimitive("false");                // true
 * isPrimitive(BigInt(42));             // true
 * isPrimitive(Symbol.for("Hello"));    // true
 *
 * isPrimitive(new String("aa"));       // false
 * isPrimitive(new Date());             // false
 * isPrimitive(_dummyFunction);         // false
 * isPrimitive([]);                     // false
 * isPrimitive(new Array(1));           // false
 * isPrimitive(new Boolean(true));      // false
 * isPrimitive(new Boolean(false));     // false
 * isPrimitive(new Boolean("true"));    // false
 * isPrimitive(new Boolean("false"));   // false
 * ```
 */
var isPrimitive = function (value) {
    return value === _internal_constants__WEBPACK_IMPORTED_MODULE_0__.NULL_VALUE || isPrimitiveType(typeof value);
};
/**
 * Identifies whether the provided value is a JavaScript [primitive](https://developer.mozilla.org/en-US/docs/Glossary/Primitive)
 * which is when is it not an object and has no methods or properties. There are 6 primitive data types:
 * - string
 * - number
 * - bigint
 * - boolean
 * - undefined
 * - symbol
 *
 * Most of the time, a primitive value is represented directly at the lowest level of the language implementation.
 *
 * All primitives are immutable; that is, they cannot be altered. It is important not to confuse a primitive itself
 * with a variable assigned a primitive value. The variable may be reassigned to a new value, but the existing value
 * can not be changed in the ways that objects, arrays, and functions can be altered. The language does not offer
 * utilities to mutate primitive values.
 * @since 0.9.6
 * @group Type Identity
 * @param theType - The type as a string value to be checked whther it's a primitive type, this should be the value
 * returned from `typeof value`.
 * @example
 * ```ts
 * isPrimitiveType(null);                   // false
 * isPrimitiveType(undefined);              // false
 * isPrimitiveType("null");                 // false
 * isPrimitiveType("undefined");            // false
 * isPrimitiveType("1");                    // false
 * isPrimitiveType("aa");                   // false
 * isPrimitiveType(1);                      // false
 * isPrimitiveType(Number(2));              // false
 * isPrimitiveType("");                     // false
 * isPrimitiveType(String(""));             // false
 * isPrimitiveType(true);                   // false
 * isPrimitiveType(false);                  // false
 * isPrimitiveType("true");                 // false
 * isPrimitiveType("false");                // false
 * isPrimitiveType(BigInt(42));             // false
 * isPrimitiveType(Symbol.for("Hello"));    // false
 *
 * isPrimitiveType("string");               // true
 * isPrimitiveType("number");               // true
 * isPrimitiveType("boolean");              // true
 * isPrimitiveType("undefined");            // true
 * isPrimitiveType("symbol");               // true
 * isPrimitiveType("bigint");               // true
 * ```
 */
var isPrimitiveType = function (theType) {
    return theType !== _internal_constants__WEBPACK_IMPORTED_MODULE_0__.OBJECT && PRIMITIVE_TYPES.indexOf(theType) !== -1;
};
/**
 * Checks to see if the past value is a string value
 * @group Type Identity
 * @group String
 * @param value - The value to check
 * @returns
 * @example
 * ```ts
 * isString("");            // true
 * isString("null");        // true
 * isString("undefined");   // true
 * isString(String(""));    // true
 *
 * isString(null);          // false
 * isString(undefined);     // false
 * isString(0);             // false
 * ```
 */
var isString = _createIs(_internal_constants__WEBPACK_IMPORTED_MODULE_0__.STRING);
/**
 * Checks to see if the past value is a function value
 * @group Type Identity
 * @param value - The value to check
 * @returns
 * @example
 * ```ts
 * function myFunction() { }
 * isFunction(null);            // false
 * isFunction(undefined);       // false
 * isFunction("null");          // false
 * isFunction("undefined");     // false
 * isFunction("1");             // false
 * isFunction("aa");            // false
 * isFunction(new Date());      // false
 * isFunction(1);               // false
 * isFunction("");              // false
 * isFunction(myFunction);      // true
 * isFunction([]);              // false
 * isFunction(new Array(1));    // false
 * ```
 */
var isFunction = _createIs(_internal_constants__WEBPACK_IMPORTED_MODULE_0__.FUNCTION);
/**
 * Checks to see if the past value is an object value
 * @group Type Identity
 * @group Object
 * @typeParam T - The object type, defaults to any
 * @param value - The value to check
 * @returns
 */
function isObject(value) {
    if (!value && isNullOrUndefined(value)) {
        return false;
    }
    return !!value && typeof value === _internal_constants__WEBPACK_IMPORTED_MODULE_0__.OBJECT;
}
/**
 * Checks if the type of value is an Array.
 *
 * @group Type Identity
 * @group Array
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a Array, false otherwise.
 * @example
 * ```ts
 * import { isArray, isObject } from "@nevware21/ts-utils";
 *
 * function performAction(value: any) {
 *     if (isArray(value) || isObject(value)) {
 *         // Do something
 *     } else {
 *         // Do something else
 *     }
 * }
 * ```
 */
var isArray = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ArrCls.isArray;
/**
 * Check if an object is of type Date
 * @group Type Identity
 * @example
 * ```ts
 * import { isDate } from "@nevware21/ts-utils";
 *
 * let _theDate = null;
 *
 * function getSetDate(newDate?: any) {
 *     _theDate = isDate(newDate) ? newDate : new Date();
 *
 *     return _theDate;
 * }
 * ```
 */
var isDate = _createObjIs("Date");
/**
 * Checks if the type of value is a number.
 * @group Type Identity
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a number, false otherwise.
 */
var isNumber = _createIs(_internal_constants__WEBPACK_IMPORTED_MODULE_0__.NUMBER);
/**
 * Checks if the type of value is a boolean.
 * @group Type Identity
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a boolean, false otherwise.
 */
var isBoolean = _createIs(_internal_constants__WEBPACK_IMPORTED_MODULE_0__.BOOLEAN);
/**
 * Determines if a value is a regular expression object.
 * @group Type Identity
 * @param {*} value Reference to check.
 * @returns {boolean} True if `value` is a `RegExp`.
 */
var isRegExp = _createObjIs("RegExp");
/**
 * Checks if the type of value is a File object.
 * @group Type Identity
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a File, false otherwise.
 */
var isFile = _createObjIs("File");
/**
 * Checks if the type of value is a FormData object.
 * @group Type Identity
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a FormData, false otherwise.
 */
var isFormData = _createObjIs("FormData");
/**
 * Checks if the type of value is a Blob object.
 * @group Type Identity
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a Blob, false otherwise.
 */
var isBlob = _createObjIs("Blob");
/**
 * Checks if the type of value is a ArrayBuffer object.
 * @group Type Identity
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a ArrayBuffer, false otherwise.
 */
var isArrayBuffer = _createObjIs("ArrayBuffer");
/**
 * Checks if the type of value is a Error object.
 * @group Type Identity
 * @group Error
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a Error, false otherwise.
 */
var isError = _createObjIs("Error");
/**
 * Checks if the type of value is a PromiseLike instance (contains a then function).
 * @group Type Identity
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a PromiseLike, false otherwise.
 */
function isPromiseLike(value) {
    return !!value && isFunction(value.then);
}
/**
 * Checks if the type of value is a PromiseLike instance (contains a then function).
 * This is an alias for {@link isPromiseLike}.
 * @group Type Identity
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a PromiseLike, false otherwise.
 */
var isThenable = isPromiseLike;
/**
 * Checks if the type of value is a Promise instance (contains then and catch functions).
 * @group Type Identity
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a Promise, false otherwise.
 */
function isPromise(value) {
    return isPromiseLike(value) && isFunction(value.catch);
}
/**
 * Checks if the type of value does not evaluate to true value, handling some special
 * case usages of Boolean(true/false) and new Boolean(true/false).
 * @group Value Check
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is not truthy, false otherwise.
 */
function isNotTruthy(value) {
    return !value || !(0,_safe_get__WEBPACK_IMPORTED_MODULE_1__.safeGet)(function () { return (value && (0 + value)); }, value);
}
/**
 * Checks if the type of value evaluates to true value, handling some special
 * case usages of Boolean(true/false) and new Boolean(true/false).
 * @group Value Check
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is not truthy, false otherwise.
 */
function isTruthy(value) {
    // Objects created with no prototype (Object.create(null)) cannot be converted to primitives
    // Which causes this code to throw, additionally just using !! also fails for Boolean objects
    // !!(new Boolean(false)) evaluates to true
    return !(!value || (0,_safe_get__WEBPACK_IMPORTED_MODULE_1__.safeGet)(function () { return !(value && (0 + value)); }, !value));
    //return !(!value || !(value && (0 + value)));
}
//# sourceMappingURL=base.js.map

/***/ }),
/* 74 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ArrCls": () => (/* binding */ ArrCls),
/* harmony export */   "ArrProto": () => (/* binding */ ArrProto),
/* harmony export */   "BOOLEAN": () => (/* binding */ BOOLEAN),
/* harmony export */   "CONSTRUCTOR": () => (/* binding */ CONSTRUCTOR),
/* harmony export */   "DONE": () => (/* binding */ DONE),
/* harmony export */   "EMPTY": () => (/* binding */ EMPTY),
/* harmony export */   "FUNCTION": () => (/* binding */ FUNCTION),
/* harmony export */   "INDEX_OF": () => (/* binding */ INDEX_OF),
/* harmony export */   "LAST_INDEX_OF": () => (/* binding */ LAST_INDEX_OF),
/* harmony export */   "LENGTH": () => (/* binding */ LENGTH),
/* harmony export */   "MathCls": () => (/* binding */ MathCls),
/* harmony export */   "NAME": () => (/* binding */ NAME),
/* harmony export */   "NULL_VALUE": () => (/* binding */ NULL_VALUE),
/* harmony export */   "NUMBER": () => (/* binding */ NUMBER),
/* harmony export */   "OBJECT": () => (/* binding */ OBJECT),
/* harmony export */   "ObjClass": () => (/* binding */ ObjClass),
/* harmony export */   "ObjProto": () => (/* binding */ ObjProto),
/* harmony export */   "POLYFILL_TAG": () => (/* binding */ POLYFILL_TAG),
/* harmony export */   "PROTOTYPE": () => (/* binding */ PROTOTYPE),
/* harmony export */   "SLICE": () => (/* binding */ SLICE),
/* harmony export */   "STRING": () => (/* binding */ STRING),
/* harmony export */   "SYMBOL": () => (/* binding */ SYMBOL),
/* harmony export */   "StrCls": () => (/* binding */ StrCls),
/* harmony export */   "StrProto": () => (/* binding */ StrProto),
/* harmony export */   "UNDEFINED": () => (/* binding */ UNDEFINED),
/* harmony export */   "UNDEF_VALUE": () => (/* binding */ UNDEF_VALUE),
/* harmony export */   "VALUE": () => (/* binding */ VALUE),
/* harmony export */   "__PROTO__": () => (/* binding */ __PROTO__)
/* harmony export */ });
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */
// These constants are currently NOT exported directly, we may export them later associated with a frozen namespace (maybe)
// For now do NOT expect that we will export these values.
var UNDEF_VALUE = undefined;
var NULL_VALUE = null;
var EMPTY = "";
var BOOLEAN = "boolean";
var FUNCTION = "function";
var NUMBER = "number";
var OBJECT = "object";
var PROTOTYPE = "prototype";
var __PROTO__ = "__proto__";
var STRING = "string";
var UNDEFINED = "undefined";
var CONSTRUCTOR = "constructor";
var SYMBOL = "Symbol";
var POLYFILL_TAG = "_polyfill";
var INDEX_OF = "indexOf";
var LAST_INDEX_OF = "lastIndexOf";
var LENGTH = "length";
var DONE = "done";
var VALUE = "value";
var NAME = "name";
var SLICE = "slice";
/**
 * @ignore
 */
var ObjClass = Object;
/**
 * @ignore
 */
var ObjProto = ObjClass[PROTOTYPE];
/**
 * @ignore
 */
var StrCls = String;
/**
 * @ignore
 */
var StrProto = StrCls[PROTOTYPE];
/**
 * @ignore
 */
var MathCls = Math;
/**
 * @ignore
 */
var ArrCls = Array;
/**
 * @ignore
 */
var ArrProto = ArrCls[PROTOTYPE];
//# sourceMappingURL=constants.js.map

/***/ }),
/* 75 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "safeGet": () => (/* binding */ safeGet)
/* harmony export */ });
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */
/**
 * Function to safely execute a callback function, if the function throws the provided default
 * value will be returned.
 * @since 0.9.5
 * @group Safe
 * @param cb - Callback function be wrapped with an exception
 * @param defValue - The default value to return when an exception is thrown
 * @returns The result of the callback function or the default if an exception occurred calling the callback
 * function.
 * @example
 * ```ts
 * let theExpression = "{ invalid: json value";
 *
 * let result = safeGet(() => {
 *     return JSON.parse(theExpression);
 * }, {});
 *
 * // result === {};
 * ```
 */
function safeGet(cb, defValue) {
    var result = defValue;
    try {
        result = cb();
    }
    catch (e) {
        // Do nothing
    }
    return result;
}
//# sourceMappingURL=safe_get.js.map

/***/ }),
/* 76 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "asString": () => (/* binding */ asString)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(74);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */

/**
 * The asString() method returns a string representing the value by
 * explicitly using `String(`value`)`.
 *
 * @since 0.4.3
 * @group String
 * @group Conversion
 * @group Value
 * @param value - The value to get a string representation of
 * @example
 * ```ts
 * const arr = [ 1, 2, 3];
 * asString(arr);       // "1,2,3"
 * asString(null);      // "null"
 * asString(undefined); // "undefined"
 * asString(42);        // "42"
 * asString(Symbol.for("Hello"));   // "Symbol(Hello)"
 * ```
 */
var asString = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.StrCls;
//# sourceMappingURL=as_string.js.map

/***/ }),
/* 77 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "_DYN_ADD_NOTIFICATION_LIS1": () => (/* binding */ _DYN_ADD_NOTIFICATION_LIS1),
/* harmony export */   "_DYN_APPLY": () => (/* binding */ _DYN_APPLY),
/* harmony export */   "_DYN_BLK_VAL": () => (/* binding */ _DYN_BLK_VAL),
/* harmony export */   "_DYN_CANCEL": () => (/* binding */ _DYN_CANCEL),
/* harmony export */   "_DYN_COMPLETE": () => (/* binding */ _DYN_COMPLETE),
/* harmony export */   "_DYN_CREATE_NEW": () => (/* binding */ _DYN_CREATE_NEW),
/* harmony export */   "_DYN_DIAG_LOG": () => (/* binding */ _DYN_DIAG_LOG),
/* harmony export */   "_DYN_ENABLED": () => (/* binding */ _DYN_ENABLED),
/* harmony export */   "_DYN_GET_CTX": () => (/* binding */ _DYN_GET_CTX),
/* harmony export */   "_DYN_GET_NEXT": () => (/* binding */ _DYN_GET_NEXT),
/* harmony export */   "_DYN_GET_NOTIFY_MGR": () => (/* binding */ _DYN_GET_NOTIFY_MGR),
/* harmony export */   "_DYN_GET_PLUGIN": () => (/* binding */ _DYN_GET_PLUGIN),
/* harmony export */   "_DYN_GET_PROCESS_TEL_CONT0": () => (/* binding */ _DYN_GET_PROCESS_TEL_CONT0),
/* harmony export */   "_DYN_HANDLER": () => (/* binding */ _DYN_HANDLER),
/* harmony export */   "_DYN_HDLR": () => (/* binding */ _DYN_HDLR),
/* harmony export */   "_DYN_IDENTIFIER": () => (/* binding */ _DYN_IDENTIFIER),
/* harmony export */   "_DYN_INITIALIZE": () => (/* binding */ _DYN_INITIALIZE),
/* harmony export */   "_DYN_IS_ASYNC": () => (/* binding */ _DYN_IS_ASYNC),
/* harmony export */   "_DYN_IS_CHILD_EVT": () => (/* binding */ _DYN_IS_CHILD_EVT),
/* harmony export */   "_DYN_IS_INITIALIZED": () => (/* binding */ _DYN_IS_INITIALIZED),
/* harmony export */   "_DYN_LENGTH": () => (/* binding */ _DYN_LENGTH),
/* harmony export */   "_DYN_LOGGER": () => (/* binding */ _DYN_LOGGER),
/* harmony export */   "_DYN_LOGGING_LEVEL_CONSOL4": () => (/* binding */ _DYN_LOGGING_LEVEL_CONSOL4),
/* harmony export */   "_DYN_LOG_INTERNAL_MESSAGE": () => (/* binding */ _DYN_LOG_INTERNAL_MESSAGE),
/* harmony export */   "_DYN_MESSAGE": () => (/* binding */ _DYN_MESSAGE),
/* harmony export */   "_DYN_MESSAGE_ID": () => (/* binding */ _DYN_MESSAGE_ID),
/* harmony export */   "_DYN_NAME": () => (/* binding */ _DYN_NAME),
/* harmony export */   "_DYN_NODE_TYPE": () => (/* binding */ _DYN_NODE_TYPE),
/* harmony export */   "_DYN_NOTIFY": () => (/* binding */ _DYN_NOTIFY),
/* harmony export */   "_DYN_ON_COMPLETE": () => (/* binding */ _DYN_ON_COMPLETE),
/* harmony export */   "_DYN_POLL_INTERNAL_LOGS": () => (/* binding */ _DYN_POLL_INTERNAL_LOGS),
/* harmony export */   "_DYN_PROCESS_NEXT": () => (/* binding */ _DYN_PROCESS_NEXT),
/* harmony export */   "_DYN_PUSH": () => (/* binding */ _DYN_PUSH),
/* harmony export */   "_DYN_RD_ONLY": () => (/* binding */ _DYN_RD_ONLY),
/* harmony export */   "_DYN_REMOVE_NOTIFICATION_2": () => (/* binding */ _DYN_REMOVE_NOTIFICATION_2),
/* harmony export */   "_DYN_REPLACE": () => (/* binding */ _DYN_REPLACE),
/* harmony export */   "_DYN_SET_CTX": () => (/* binding */ _DYN_SET_CTX),
/* harmony export */   "_DYN_SET_DF": () => (/* binding */ _DYN_SET_DF),
/* harmony export */   "_DYN_SET_NEXT_PLUGIN": () => (/* binding */ _DYN_SET_NEXT_PLUGIN),
/* harmony export */   "_DYN_SPAN_ID": () => (/* binding */ _DYN_SPAN_ID),
/* harmony export */   "_DYN_SPLICE": () => (/* binding */ _DYN_SPLICE),
/* harmony export */   "_DYN_SPLIT": () => (/* binding */ _DYN_SPLIT),
/* harmony export */   "_DYN_STOP_POLLING_INTERNA3": () => (/* binding */ _DYN_STOP_POLLING_INTERNA3),
/* harmony export */   "_DYN_TEARDOWN": () => (/* binding */ _DYN_TEARDOWN),
/* harmony export */   "_DYN_THROW_INTERNAL": () => (/* binding */ _DYN_THROW_INTERNAL),
/* harmony export */   "_DYN_TIME": () => (/* binding */ _DYN_TIME),
/* harmony export */   "_DYN_TO_LOWER_CASE": () => (/* binding */ _DYN_TO_LOWER_CASE),
/* harmony export */   "_DYN_TRACE_FLAGS": () => (/* binding */ _DYN_TRACE_FLAGS),
/* harmony export */   "_DYN_TRACE_ID": () => (/* binding */ _DYN_TRACE_ID),
/* harmony export */   "_DYN_TYPE": () => (/* binding */ _DYN_TYPE),
/* harmony export */   "_DYN_UNLOAD": () => (/* binding */ _DYN_UNLOAD),
/* harmony export */   "_DYN_UPDATE": () => (/* binding */ _DYN_UPDATE),
/* harmony export */   "_DYN_USER_AGENT": () => (/* binding */ _DYN_USER_AGENT),
/* harmony export */   "_DYN_VERSION": () => (/* binding */ _DYN_VERSION),
/* harmony export */   "_DYN_WARN_TO_CONSOLE": () => (/* binding */ _DYN_WARN_TO_CONSOLE),
/* harmony export */   "_DYN_WATCH": () => (/* binding */ _DYN_WATCH),
/* harmony export */   "_DYN__DO_TEARDOWN": () => (/* binding */ _DYN__DO_TEARDOWN)
/* harmony export */ });
/*
 * Application Insights JavaScript SDK - Core, 3.0.2
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */


// @skip-file-minify
// ##############################################################
// AUTO GENERATED FILE: This file is Auto Generated during build.
// ##############################################################
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// Note: DON'T Export these const from the package as we are still targeting ES3 this will export a mutable variables that someone could change!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
var _DYN_TO_LOWER_CASE = "toLowerCase"; // Count: 9
var _DYN_BLK_VAL = "blkVal"; // Count: 5
var _DYN_LENGTH = "length"; // Count: 42
var _DYN_RD_ONLY = "rdOnly"; // Count: 4
var _DYN_NOTIFY = "notify"; // Count: 4
var _DYN_WARN_TO_CONSOLE = "warnToConsole"; // Count: 4
var _DYN_THROW_INTERNAL = "throwInternal"; // Count: 5
var _DYN_SET_DF = "setDf"; // Count: 6
var _DYN_WATCH = "watch"; // Count: 9
var _DYN_LOGGER = "logger"; // Count: 21
var _DYN_APPLY = "apply"; // Count: 7
var _DYN_PUSH = "push"; // Count: 31
var _DYN_SPLICE = "splice"; // Count: 8
var _DYN_HDLR = "hdlr"; // Count: 6
var _DYN_CANCEL = "cancel"; // Count: 5
var _DYN_INITIALIZE = "initialize"; // Count: 4
var _DYN_IDENTIFIER = "identifier"; // Count: 8
var _DYN_IS_INITIALIZED = "isInitialized"; // Count: 10
var _DYN_GET_PLUGIN = "getPlugin"; // Count: 6
var _DYN_POLL_INTERNAL_LOGS = "pollInternalLogs"; // Count: 2
var _DYN_NAME = "name"; // Count: 11
var _DYN_TIME = "time"; // Count: 6
var _DYN_PROCESS_NEXT = "processNext"; // Count: 15
var _DYN_GET_PROCESS_TEL_CONT0 = "getProcessTelContext"; // Count: 2
var _DYN_GET_NOTIFY_MGR = "getNotifyMgr"; // Count: 5
var _DYN_ADD_NOTIFICATION_LIS1 = "addNotificationListener"; // Count: 4
var _DYN_REMOVE_NOTIFICATION_2 = "removeNotificationListener"; // Count: 4
var _DYN_ENABLED = "enabled"; // Count: 6
var _DYN_STOP_POLLING_INTERNA3 = "stopPollingInternalLogs"; // Count: 2
var _DYN_UNLOAD = "unload"; // Count: 9
var _DYN_ON_COMPLETE = "onComplete"; // Count: 5
var _DYN_VERSION = "version"; // Count: 6
var _DYN_LOGGING_LEVEL_CONSOL4 = "loggingLevelConsole"; // Count: 2
var _DYN_CREATE_NEW = "createNew"; // Count: 7
var _DYN_TEARDOWN = "teardown"; // Count: 9
var _DYN_MESSAGE_ID = "messageId"; // Count: 4
var _DYN_MESSAGE = "message"; // Count: 6
var _DYN_IS_ASYNC = "isAsync"; // Count: 6
var _DYN_DIAG_LOG = "diagLog"; // Count: 10
var _DYN__DO_TEARDOWN = "_doTeardown"; // Count: 4
var _DYN_UPDATE = "update"; // Count: 6
var _DYN_GET_NEXT = "getNext"; // Count: 12
var _DYN_SET_NEXT_PLUGIN = "setNextPlugin"; // Count: 5
var _DYN_USER_AGENT = "userAgent"; // Count: 5
var _DYN_SPLIT = "split"; // Count: 5
var _DYN_NODE_TYPE = "nodeType"; // Count: 3
var _DYN_REPLACE = "replace"; // Count: 8
var _DYN_LOG_INTERNAL_MESSAGE = "logInternalMessage"; // Count: 2
var _DYN_TYPE = "type"; // Count: 14
var _DYN_HANDLER = "handler"; // Count: 5
var _DYN_IS_CHILD_EVT = "isChildEvt"; // Count: 3
var _DYN_GET_CTX = "getCtx"; // Count: 6
var _DYN_SET_CTX = "setCtx"; // Count: 10
var _DYN_COMPLETE = "complete"; // Count: 3
var _DYN_TRACE_ID = "traceId"; // Count: 5
var _DYN_SPAN_ID = "spanId"; // Count: 5
var _DYN_TRACE_FLAGS = "traceFlags"; // Count: 6
//# sourceMappingURL=__DynamicConstants.js.map

/***/ }),
/* 78 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "STR_CHANNELS": () => (/* binding */ STR_CHANNELS),
/* harmony export */   "STR_CORE": () => (/* binding */ STR_CORE),
/* harmony export */   "STR_CREATE_PERF_MGR": () => (/* binding */ STR_CREATE_PERF_MGR),
/* harmony export */   "STR_DISABLED": () => (/* binding */ STR_DISABLED),
/* harmony export */   "STR_DOMAIN": () => (/* binding */ STR_DOMAIN),
/* harmony export */   "STR_EMPTY": () => (/* binding */ STR_EMPTY),
/* harmony export */   "STR_EVENTS_DISCARDED": () => (/* binding */ STR_EVENTS_DISCARDED),
/* harmony export */   "STR_EVENTS_SEND_REQUEST": () => (/* binding */ STR_EVENTS_SEND_REQUEST),
/* harmony export */   "STR_EVENTS_SENT": () => (/* binding */ STR_EVENTS_SENT),
/* harmony export */   "STR_EXTENSIONS": () => (/* binding */ STR_EXTENSIONS),
/* harmony export */   "STR_EXTENSION_CONFIG": () => (/* binding */ STR_EXTENSION_CONFIG),
/* harmony export */   "STR_GET_PERF_MGR": () => (/* binding */ STR_GET_PERF_MGR),
/* harmony export */   "STR_NOT_DYNAMIC_ERROR": () => (/* binding */ STR_NOT_DYNAMIC_ERROR),
/* harmony export */   "STR_PATH": () => (/* binding */ STR_PATH),
/* harmony export */   "STR_PERF_EVENT": () => (/* binding */ STR_PERF_EVENT),
/* harmony export */   "STR_PRIORITY": () => (/* binding */ STR_PRIORITY),
/* harmony export */   "STR_PROCESS_TELEMETRY": () => (/* binding */ STR_PROCESS_TELEMETRY),
/* harmony export */   "UNDEFINED_VALUE": () => (/* binding */ UNDEFINED_VALUE)
/* harmony export */ });
/*
 * Application Insights JavaScript SDK - Core, 3.0.2
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */


// ###################################################################################################################################################
// Note: DON'T Export these const from the package as we are still targeting IE/ES5 this will export a mutable variables that someone could change ###
// ###################################################################################################################################################
var UNDEFINED_VALUE = undefined;
var STR_EMPTY = "";
var STR_CHANNELS = "channels";
var STR_CORE = "core";
var STR_CREATE_PERF_MGR = "createPerfMgr";
var STR_DISABLED = "disabled";
var STR_EXTENSION_CONFIG = "extensionConfig";
var STR_EXTENSIONS = "extensions";
var STR_PROCESS_TELEMETRY = "processTelemetry";
var STR_PRIORITY = "priority";
var STR_EVENTS_SENT = "eventsSent";
var STR_EVENTS_DISCARDED = "eventsDiscarded";
var STR_EVENTS_SEND_REQUEST = "eventsSendRequest";
var STR_PERF_EVENT = "perfEvent";
var STR_GET_PERF_MGR = "getPerfMgr";
var STR_DOMAIN = "domain";
var STR_PATH = "path";
var STR_NOT_DYNAMIC_ERROR = "Not dynamic - ";
//# sourceMappingURL=InternalConstants.js.map

/***/ }),
/* 79 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AppInsightsCore": () => (/* binding */ AppInsightsCore)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(132);
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(90);
/* harmony import */ var _nevware21_ts_async__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(134);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(80);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(95);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(73);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(81);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(82);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(103);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(129);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(155);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(83);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(91);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(89);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(157);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(120);
/* harmony import */ var _Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(106);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(77);
/* harmony import */ var _AsyncUtils__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(149);
/* harmony import */ var _Constants__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(164);
/* harmony import */ var _CookieMgr__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(145);
/* harmony import */ var _DataCacheHelper__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(117);
/* harmony import */ var _DbgExtensionUtils__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(131);
/* harmony import */ var _DiagnosticLogger__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(96);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(99);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(78);
/* harmony import */ var _NotificationManager__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(133);
/* harmony import */ var _PerfManager__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(87);
/* harmony import */ var _ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(151);
/* harmony import */ var _TelemetryHelpers__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(152);
/* harmony import */ var _TelemetryInitializerPlugin__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(160);
/* harmony import */ var _UnloadHandlerContainer__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(163);
/* harmony import */ var _UnloadHookContainer__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(162);
/*
 * Application Insights JavaScript SDK - Core, 3.0.2
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */



var _a;





















var strValidationError = "Plugins must provide initialize method";
var strNotificationManager = "_notificationManager";
var strSdkUnloadingError = "SDK is still unloading...";
var strSdkNotInitialized = "SDK is not initialized";
// const strPluginUnloadFailed = "Failed to unload plugin";
/**
 * The default settings for the config.
 * WE MUST include all defaults here to ensure that the config is created with all of the properties
 * defined as dynamic.
 */
var defaultConfig = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.objDeepFreeze)((_a = {
        cookieCfg: {}
    },
    _a[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EXTENSIONS] = { rdOnly: true, ref: true, v: [] },
    _a[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CHANNELS] = { rdOnly: true, ref: true, v: [] },
    _a[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EXTENSION_CONFIG] = { ref: true, v: {} },
    _a[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CREATE_PERF_MGR] = _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.UNDEFINED_VALUE,
    _a.loggingLevelConsole = 0 /* eLoggingSeverity.DISABLED */,
    _a.diagnosticLogInterval = _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.UNDEFINED_VALUE,
    _a));
/**
 * Helper to create the default performance manager
 * @param core
 * @param notificationMgr
 */
function _createPerfManager(core, notificationMgr) {
    return new _PerfManager__WEBPACK_IMPORTED_MODULE_2__.PerfManager(notificationMgr);
}
function _validateExtensions(logger, channelPriority, allExtensions) {
    var _a;
    // Concat all available extensions
    var coreExtensions = [];
    var channels = [];
    // Check if any two extensions have the same priority, then warn to console
    // And extract the local extensions from the
    var extPriorities = {};
    // Extension validation
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(allExtensions, function (ext) {
        // Check for ext.initialize
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.isNullOrUndefined)(ext) || (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.isNullOrUndefined)(ext[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_INITIALIZE /* @min:%2einitialize */])) {
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.throwError)(strValidationError);
        }
        var extPriority = ext[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_PRIORITY /* @min:%2epriority */];
        var identifier = ext[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IDENTIFIER /* @min:%2eidentifier */];
        if (ext && extPriority) {
            if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.isNullOrUndefined)(extPriorities[extPriority])) {
                (0,_DiagnosticLogger__WEBPACK_IMPORTED_MODULE_7__._warnToConsole)(logger, "Two extensions have same priority #" + extPriority + " - " + extPriorities[extPriority] + ", " + identifier);
            }
            else {
                // set a value
                extPriorities[extPriority] = identifier;
            }
        }
        // Split extensions to core and channels
        if (!extPriority || extPriority < channelPriority) {
            // Add to core extension that will be managed by AppInsightsCore
            coreExtensions[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](ext);
        }
        else {
            channels[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](ext);
        }
    });
    return _a = {},
        _a[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CORE /* @min:core */] = coreExtensions,
        _a[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CHANNELS /* @min:channels */] = channels,
        _a;
}
function _isPluginPresent(thePlugin, plugins) {
    var exists = false;
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(plugins, function (plugin) {
        if (plugin === thePlugin) {
            exists = true;
            return -1;
        }
    });
    return exists;
}
function _deepMergeConfig(details, target, newValues, merge) {
    // Lets assign the new values to the existing config
    if (newValues) {
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_8__.objForEachKey)(newValues, function (key, value) {
            if (merge) {
                if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__.isPlainObject)(value) && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__.isPlainObject)(target[key])) {
                    // The target is an object and it has a value
                    _deepMergeConfig(details, target[key], value, merge);
                }
            }
            if (merge && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__.isPlainObject)(value) && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__.isPlainObject)(target[key])) {
                // The target is an object and it has a value
                _deepMergeConfig(details, target[key], value, merge);
            }
            else {
                // Just Assign (replace) and/or make the property dynamic
                details.set(target, key, value);
            }
        });
    }
}
function _findWatcher(listeners, newWatcher) {
    var theListener = null;
    var idx = -1;
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(listeners, function (listener, lp) {
        if (listener.w === newWatcher) {
            theListener = listener;
            idx = lp;
            return -1;
        }
    });
    return { i: idx, l: theListener };
}
function _addDelayedCfgListener(listeners, newWatcher) {
    var theListener = _findWatcher(listeners, newWatcher).l;
    if (!theListener) {
        theListener = {
            w: newWatcher,
            rm: function () {
                var fnd = _findWatcher(listeners, newWatcher);
                if (fnd.i !== -1) {
                    listeners[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_SPLICE /* @min:%2esplice */](fnd.i, 1);
                }
            }
        };
        listeners[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](theListener);
    }
    return theListener;
}
function _registerDelayedCfgListener(config, listeners, logger) {
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(listeners, function (listener) {
        var unloadHdl = (0,_Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_10__.onConfigChange)(config, listener.w, logger);
        delete listener.w; // Clear the listener reference so it will get garbage collected.
        // replace the remove function
        listener.rm = function () {
            unloadHdl.rm();
        };
    });
}
var AppInsightsCore = /** @class */ (function () {
    function AppInsightsCore() {
        // NOTE!: DON'T set default values here, instead set them in the _initDefaults() function as it is also called during teardown()
        var _configHandler;
        var _isInitialized;
        var _logger;
        var _eventQueue;
        var _notificationManager;
        var _perfManager;
        var _cfgPerfManager;
        var _cookieManager;
        var _pluginChain;
        var _configExtensions;
        var _channelConfig;
        var _channels;
        var _isUnloading;
        var _telemetryInitializerPlugin;
        var _internalLogsEventName;
        var _evtNamespace;
        var _unloadHandlers;
        var _hookContainer;
        var _debugListener;
        var _traceCtx;
        var _instrumentationKey;
        var _cfgListeners;
        var _extensions;
        var _pluginVersionStringArr;
        var _pluginVersionString;
        /**
         * Internal log poller
         */
        var _internalLogPoller;
        var _internalLogPollerListening;
        var _forceStopInternalLogPoller;
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_11__["default"])(AppInsightsCore, this, function (_self) {
            // Set the default values (also called during teardown)
            _initDefaults();
            // Special internal method to allow the unit tests and DebugPlugin to hook embedded objects
            _self["_getDbgPlgTargets"] = function () {
                return [_extensions];
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IS_INITIALIZED /* @min:%2eisInitialized */] = function () { return _isInitialized; };
            // Creating the self.initialize = ()
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_INITIALIZE /* @min:%2einitialize */] = function (config, extensions, logger, notificationManager) {
                if (_isUnloading) {
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.throwError)(strSdkUnloadingError);
                }
                // Make sure core is only initialized once
                if (_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IS_INITIALIZED /* @min:%2eisInitialized */]()) {
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.throwError)("Core cannot be initialized more than once");
                }
                _configHandler = (0,_Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_10__.createDynamicConfig)(config, defaultConfig, logger || _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */], false);
                // Re-assigning the local config property so we don't have any references to the passed value and it can be garbage collected
                config = _configHandler.cfg;
                // This will be "re-run" if the referenced config properties are changed
                _addUnloadHook(_configHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_WATCH /* @min:%2ewatch */](function (details) {
                    _instrumentationKey = details.cfg.instrumentationKey;
                    // Mark the extensionConfig and all first level keys as referenced
                    // This is so that calls to getExtCfg() will always return the same object
                    // Even when a user may "re-assign" the plugin properties (or it's unloaded/reloaded)
                    var extCfg = details.ref(details.cfg, _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EXTENSION_CONFIG);
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_8__.objForEachKey)(extCfg, function (key) {
                        details.ref(extCfg, key);
                    });
                    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.isNullOrUndefined)(_instrumentationKey)) {
                        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.throwError)("Please provide instrumentation key");
                    }
                }));
                _notificationManager = notificationManager;
                _initDebugListener();
                _initPerfManager();
                _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */] = logger;
                var cfgExtensions = config[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EXTENSIONS /* @min:%2eextensions */];
                // Extension validation
                _configExtensions = [];
                _configExtensions[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */].apply(_configExtensions, (0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_12__.__spreadArrayFn)((0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_12__.__spreadArrayFn)([], extensions, false), cfgExtensions, false));
                _channelConfig = config[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CHANNELS /* @min:%2echannels */];
                _initPluginChain(null);
                if (!_channels || _channels[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */] === 0) {
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.throwError)("No " + _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CHANNELS + " available");
                }
                if (_channelConfig && _channelConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */] > 1) {
                    var teeController = _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_GET_PLUGIN /* @min:%2egetPlugin */]("TeeChannelController");
                    if (!teeController || !teeController.plugin) {
                        (0,_DiagnosticLogger__WEBPACK_IMPORTED_MODULE_7__._throwInternal)(_logger, 1 /* eLoggingSeverity.CRITICAL */, 28 /* _eInternalMessageId.SenderNotInitialized */, "TeeChannel required");
                    }
                }
                _registerDelayedCfgListener(config, _cfgListeners, _logger);
                _cfgListeners = null;
                _isInitialized = true;
                _self.releaseQueue();
                _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_POLL_INTERNAL_LOGS /* @min:%2epollInternalLogs */]();
            };
            _self.getChannels = function () {
                var controls = [];
                if (_channels) {
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(_channels, function (channel) {
                        controls[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](channel);
                    });
                }
                return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.objFreeze)(controls);
            };
            _self.track = function (telemetryItem) {
                (0,_PerfManager__WEBPACK_IMPORTED_MODULE_2__.doPerf)(_self[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_GET_PERF_MGR /* @min:%2egetPerfMgr */](), function () { return "AppInsightsCore:track"; }, function () {
                    if (telemetryItem === null) {
                        _notifyInvalidEvent(telemetryItem);
                        // throw error
                        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.throwError)("Invalid telemetry item");
                    }
                    // do basic validation before sending it through the pipeline
                    if (!telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_NAME /* @min:%2ename */] && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.isNullOrUndefined)(telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_NAME /* @min:%2ename */])) {
                        _notifyInvalidEvent(telemetryItem);
                        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.throwError)("telemetry name required");
                    }
                    // setup default iKey if not passed in
                    telemetryItem.iKey = telemetryItem.iKey || _instrumentationKey;
                    // add default timestamp if not passed in
                    telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_TIME /* @min:%2etime */] = telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_TIME /* @min:%2etime */] || (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_13__.toISOString)(new Date());
                    // Common Schema 4.0
                    telemetryItem.ver = telemetryItem.ver || "4.0";
                    if (!_isUnloading && _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IS_INITIALIZED /* @min:%2eisInitialized */]()) {
                        // Process the telemetry plugin chain
                        _createTelCtx()[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](telemetryItem);
                    }
                    else {
                        // Queue events until all extensions are initialized
                        _eventQueue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](telemetryItem);
                    }
                }, function () { return ({ item: telemetryItem }); }, !(telemetryItem.sync));
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_GET_PROCESS_TEL_CONT0 /* @min:%2egetProcessTelContext */] = _createTelCtx;
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_GET_NOTIFY_MGR /* @min:%2egetNotifyMgr */] = function () {
                if (!_notificationManager) {
                    _notificationManager = new _NotificationManager__WEBPACK_IMPORTED_MODULE_14__.NotificationManager(_configHandler.cfg);
                    // For backward compatibility only
                    _self[strNotificationManager] = _notificationManager;
                }
                return _notificationManager;
            };
            /**
             * Adds a notification listener. The SDK calls methods on the listener when an appropriate notification is raised.
             * The added plugins must raise notifications. If the plugins do not implement the notifications, then no methods will be
             * called.
             * @param listener - An INotificationListener object.
             */
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_ADD_NOTIFICATION_LIS1 /* @min:%2eaddNotificationListener */] = function (listener) {
                _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_GET_NOTIFY_MGR /* @min:%2egetNotifyMgr */]()[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_ADD_NOTIFICATION_LIS1 /* @min:%2eaddNotificationListener */](listener);
            };
            /**
             * Removes all instances of the listener.
             * @param listener - INotificationListener to remove.
             */
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_REMOVE_NOTIFICATION_2 /* @min:%2eremoveNotificationListener */] = function (listener) {
                if (_notificationManager) {
                    _notificationManager[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_REMOVE_NOTIFICATION_2 /* @min:%2eremoveNotificationListener */](listener);
                }
            };
            _self.getCookieMgr = function () {
                if (!_cookieManager) {
                    _cookieManager = (0,_CookieMgr__WEBPACK_IMPORTED_MODULE_15__.createCookieMgr)(_configHandler.cfg, _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */]);
                }
                return _cookieManager;
            };
            _self.setCookieMgr = function (cookieMgr) {
                if (_cookieManager !== cookieMgr) {
                    (0,_AsyncUtils__WEBPACK_IMPORTED_MODULE_16__.runTargetUnload)(_cookieManager, false);
                    _cookieManager = cookieMgr;
                }
            };
            _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_GET_PERF_MGR /* @min:%2egetPerfMgr */] = function () {
                if (!_perfManager && !_cfgPerfManager) {
                    _addUnloadHook(_configHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_WATCH /* @min:%2ewatch */](function (details) {
                        if (details.cfg.enablePerfMgr) {
                            var createPerfMgr = details.cfg[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CREATE_PERF_MGR /* @min:%2ecreatePerfMgr */];
                            if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.isFunction)(createPerfMgr)) {
                                _cfgPerfManager = createPerfMgr(_self, _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_GET_NOTIFY_MGR /* @min:%2egetNotifyMgr */]());
                            }
                        }
                    }));
                }
                return _perfManager || _cfgPerfManager || (0,_PerfManager__WEBPACK_IMPORTED_MODULE_2__.getGblPerfMgr)();
            };
            _self.setPerfMgr = function (perfMgr) {
                _perfManager = perfMgr;
            };
            _self.eventCnt = function () {
                return _eventQueue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */];
            };
            _self.releaseQueue = function () {
                if (_isInitialized && _eventQueue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    var eventQueue = _eventQueue;
                    _eventQueue = [];
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(eventQueue, function (event) {
                        _createTelCtx()[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](event);
                    });
                }
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_POLL_INTERNAL_LOGS /* @min:%2epollInternalLogs */] = function (eventName) {
                _internalLogsEventName = eventName || null;
                _forceStopInternalLogPoller = false;
                _internalLogPoller && _internalLogPoller[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_CANCEL /* @min:%2ecancel */]();
                return _startLogPoller(true);
            };
            function _startLogPoller(alwaysStart) {
                if ((!_internalLogPoller || !_internalLogPoller[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_ENABLED /* @min:%2eenabled */]) && !_forceStopInternalLogPoller) {
                    var shouldStart = alwaysStart || (_logger && _logger.queue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */] > 0);
                    if (shouldStart) {
                        if (!_internalLogPollerListening) {
                            _internalLogPollerListening = true;
                            // listen for any configuration changes so that changes to the
                            // interval will cause the timer to be re-initialized
                            _addUnloadHook(_configHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_WATCH /* @min:%2ewatch */](function (details) {
                                var interval = details.cfg.diagnosticLogInterval;
                                if (!interval || !(interval > 0)) {
                                    interval = 10000;
                                }
                                var isRunning = false;
                                if (_internalLogPoller) {
                                    // It was already created so remember it's running and cancel
                                    isRunning = _internalLogPoller[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_ENABLED /* @min:%2eenabled */];
                                    _internalLogPoller[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_CANCEL /* @min:%2ecancel */]();
                                }
                                // Create / reconfigure
                                _internalLogPoller = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_17__.createTimeout)(_flushInternalLogs, interval);
                                _internalLogPoller.unref();
                                // Restart if previously running
                                _internalLogPoller[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_ENABLED /* @min:%2eenabled */] = isRunning;
                            }));
                        }
                        _internalLogPoller[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_ENABLED /* @min:%2eenabled */] = true;
                    }
                }
                return _internalLogPoller;
            }
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_STOP_POLLING_INTERNA3 /* @min:%2estopPollingInternalLogs */] = function () {
                _forceStopInternalLogPoller = true;
                _internalLogPoller && _internalLogPoller[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_CANCEL /* @min:%2ecancel */]();
                _flushInternalLogs();
            };
            // Add addTelemetryInitializer
            (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_13__.proxyFunctions)(_self, function () { return _telemetryInitializerPlugin; }, ["addTelemetryInitializer"]);
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_UNLOAD /* @min:%2eunload */] = function (isAsync, unloadComplete, cbTimeout) {
                var _a;
                if (isAsync === void 0) { isAsync = true; }
                if (!_isInitialized) {
                    // The SDK is not initialized
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.throwError)(strSdkNotInitialized);
                }
                // Check if the SDK still unloading so throw
                if (_isUnloading) {
                    // The SDK is already unloading
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.throwError)(strSdkUnloadingError);
                }
                var unloadState = (_a = {
                        reason: 50 /* TelemetryUnloadReason.SdkUnload */
                    },
                    _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IS_ASYNC /* @min:isAsync */] = isAsync,
                    _a.flushComplete = false,
                    _a);
                var result;
                if (isAsync && !unloadComplete) {
                    result = (0,_nevware21_ts_async__WEBPACK_IMPORTED_MODULE_18__.createPromise)(function (resolve) {
                        // Set the callback to the promise resolve callback
                        unloadComplete = resolve;
                    });
                }
                var processUnloadCtx = (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_19__.createProcessTelemetryUnloadContext)(_getPluginChain(), _self);
                processUnloadCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_ON_COMPLETE /* @min:%2eonComplete */](function () {
                    _hookContainer.run(_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */]);
                    // Run any "unload" functions for the _cookieManager, _notificationManager and _logger
                    (0,_AsyncUtils__WEBPACK_IMPORTED_MODULE_16__.doUnloadAll)([_cookieManager, _notificationManager, _logger], isAsync, function () {
                        _initDefaults();
                        unloadComplete && unloadComplete(unloadState);
                    });
                }, _self);
                function _doUnload(flushComplete) {
                    unloadState.flushComplete = flushComplete;
                    _isUnloading = true;
                    // Run all of the unload handlers first (before unloading the plugins)
                    _unloadHandlers.run(processUnloadCtx, unloadState);
                    // Stop polling the internal logs
                    _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_STOP_POLLING_INTERNA3 /* @min:%2estopPollingInternalLogs */]();
                    // Start unloading the components, from this point onwards the SDK should be considered to be in an unstable state
                    processUnloadCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](unloadState);
                }
                _flushInternalLogs();
                if (!_flushChannels(isAsync, _doUnload, 6 /* SendRequestReason.SdkUnload */, cbTimeout)) {
                    _doUnload(false);
                }
                return result;
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_GET_PLUGIN /* @min:%2egetPlugin */] = _getPlugin;
            _self.addPlugin = function (plugin, replaceExisting, isAsync, addCb) {
                if (!plugin) {
                    addCb && addCb(false);
                    _logOrThrowError(strValidationError);
                    return;
                }
                var existingPlugin = _getPlugin(plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IDENTIFIER /* @min:%2eidentifier */]);
                if (existingPlugin && !replaceExisting) {
                    addCb && addCb(false);
                    _logOrThrowError("Plugin [" + plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IDENTIFIER /* @min:%2eidentifier */] + "] is already loaded!");
                    return;
                }
                var updateState = {
                    reason: 16 /* TelemetryUpdateReason.PluginAdded */
                };
                function _addPlugin(removed) {
                    _configExtensions[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](plugin);
                    updateState.added = [plugin];
                    // Re-Initialize the plugin chain
                    _initPluginChain(updateState);
                    addCb && addCb(true);
                }
                if (existingPlugin) {
                    var removedPlugins_1 = [existingPlugin.plugin];
                    var unloadState = {
                        reason: 2 /* TelemetryUnloadReason.PluginReplace */,
                        isAsync: !!isAsync
                    };
                    _removePlugins(removedPlugins_1, unloadState, function (removed) {
                        if (!removed) {
                            // Previous plugin was successfully removed or was not installed
                            addCb && addCb(false);
                        }
                        else {
                            updateState.removed = removedPlugins_1;
                            updateState.reason |= 32 /* TelemetryUpdateReason.PluginRemoved */;
                            _addPlugin(true);
                        }
                    });
                }
                else {
                    _addPlugin(false);
                }
            };
            _self.updateCfg = function (newConfig, mergeExisting) {
                if (mergeExisting === void 0) { mergeExisting = true; }
                var updateState;
                if (_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IS_INITIALIZED /* @min:%2eisInitialized */]()) {
                    updateState = {
                        reason: 1 /* TelemetryUpdateReason.ConfigurationChanged */,
                        cfg: _configHandler.cfg,
                        oldCfg: (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_20__.deepExtend)({}, _configHandler.cfg),
                        newConfig: (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_20__.deepExtend)({}, newConfig),
                        merge: mergeExisting
                    };
                    newConfig = updateState.newConfig;
                    var cfg = _configHandler.cfg;
                    // replace the immutable (if initialized) values
                    // We don't currently allow updating the extensions and channels via the update config
                    // So overwriting any user provided values to reuse the existing values
                    newConfig[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EXTENSIONS /* @min:%2eextensions */] = cfg[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EXTENSIONS /* @min:%2eextensions */];
                    newConfig[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CHANNELS /* @min:%2echannels */] = cfg[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CHANNELS /* @min:%2echannels */];
                }
                // Explicitly blocking any previous config watchers so that they don't get called because
                // of this bulk update (Probably not necessary)
                _configHandler._block(function (details) {
                    // Lets assign the new values to the existing config either overwriting or re-assigning
                    var theConfig = details.cfg;
                    _deepMergeConfig(details, theConfig, newConfig, mergeExisting);
                    if (!mergeExisting) {
                        // Remove (unassign) the values "missing" from the newConfig and also not in the default config
                        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_8__.objForEachKey)(theConfig, function (key) {
                            if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_21__.objHasOwn)(newConfig, key)) {
                                // Set the value to undefined
                                details.set(theConfig, key, _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.UNDEFINED_VALUE);
                            }
                        });
                    }
                    // Apply defaults to the new config
                    details[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_SET_DF /* @min:%2esetDf */](theConfig, defaultConfig);
                }, true);
                // Now execute all of the listeners (synchronously) so they update their values immediately
                _configHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_NOTIFY /* @min:%2enotify */]();
                if (updateState) {
                    _doUpdate(updateState);
                }
            };
            _self.evtNamespace = function () {
                return _evtNamespace;
            };
            _self.flush = _flushChannels;
            _self.getTraceCtx = function (createNew) {
                if (!_traceCtx) {
                    _traceCtx = (0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_22__.createDistributedTraceContext)();
                }
                return _traceCtx;
            };
            _self.setTraceCtx = function (traceCtx) {
                _traceCtx = traceCtx || null;
            };
            _self.addUnloadHook = _addUnloadHook;
            // Create the addUnloadCb
            (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_13__.proxyFunctionAs)(_self, "addUnloadCb", function () { return _unloadHandlers; }, "add");
            _self.onCfgChange = function (handler) {
                var unloadHook;
                if (!_isInitialized) {
                    unloadHook = _addDelayedCfgListener(_cfgListeners, handler);
                }
                else {
                    unloadHook = (0,_Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_10__.onConfigChange)(_configHandler.cfg, handler, _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */]);
                }
                return {
                    rm: function () {
                        unloadHook.rm();
                    }
                };
            };
            _self.getWParam = function () {
                return ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_23__.hasDocument)() || !!_configHandler.cfg.enableWParam) ? 0 : -1;
            };
            function _setPluginVersions() {
                var thePlugins = {};
                _pluginVersionStringArr = [];
                var _addPluginVersions = function (plugins) {
                    if (plugins) {
                        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(plugins, function (plugin) {
                            if (plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IDENTIFIER /* @min:%2eidentifier */] && plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_VERSION /* @min:%2eversion */] && !thePlugins[plugin.identifier]) {
                                var ver = plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IDENTIFIER /* @min:%2eidentifier */] + "=" + plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_VERSION /* @min:%2eversion */];
                                _pluginVersionStringArr[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](ver);
                                thePlugins[plugin.identifier] = plugin;
                            }
                        });
                    }
                };
                _addPluginVersions(_channels);
                if (_channelConfig) {
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(_channelConfig, function (channels) {
                        _addPluginVersions(channels);
                    });
                }
                _addPluginVersions(_configExtensions);
            }
            function _initDefaults() {
                _isInitialized = false;
                // Use a default logger so initialization errors are not dropped on the floor with full logging
                _configHandler = (0,_Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_10__.createDynamicConfig)({}, defaultConfig, _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */]);
                // Set the logging level to critical so that any critical initialization failures are displayed on the console
                _configHandler.cfg[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGING_LEVEL_CONSOL4 /* @min:%2eloggingLevelConsole */] = 1 /* eLoggingSeverity.CRITICAL */;
                // Define _self.config
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_24__.objDefine)(_self, "config", {
                    g: function () { return _configHandler.cfg; },
                    s: function (newValue) {
                        _self.updateCfg(newValue, false);
                    }
                });
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_24__.objDefine)(_self, "pluginVersionStringArr", {
                    g: function () {
                        if (!_pluginVersionStringArr) {
                            _setPluginVersions();
                        }
                        return _pluginVersionStringArr;
                    }
                });
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_24__.objDefine)(_self, "pluginVersionString", {
                    g: function () {
                        if (!_pluginVersionString) {
                            if (!_pluginVersionStringArr) {
                                _setPluginVersions();
                            }
                            _pluginVersionString = _pluginVersionStringArr.join(";");
                        }
                        return _pluginVersionString || _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY;
                    }
                });
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_24__.objDefine)(_self, "logger", {
                    g: function () {
                        if (!_logger) {
                            _logger = new _DiagnosticLogger__WEBPACK_IMPORTED_MODULE_7__.DiagnosticLogger(_configHandler.cfg);
                            _configHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */] = _logger;
                        }
                        return _logger;
                    },
                    s: function (newLogger) {
                        _configHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */] = newLogger;
                        if (_logger !== newLogger) {
                            (0,_AsyncUtils__WEBPACK_IMPORTED_MODULE_16__.runTargetUnload)(_logger, false);
                            _logger = newLogger;
                        }
                    }
                });
                _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */] = new _DiagnosticLogger__WEBPACK_IMPORTED_MODULE_7__.DiagnosticLogger(_configHandler.cfg);
                _extensions = [];
                var cfgExtensions = _self.config[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EXTENSIONS /* @min:%2eextensions */] || [];
                cfgExtensions.splice(0, cfgExtensions[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */]);
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_25__.arrAppend)(cfgExtensions, _extensions);
                _telemetryInitializerPlugin = new _TelemetryInitializerPlugin__WEBPACK_IMPORTED_MODULE_26__.TelemetryInitializerPlugin();
                _eventQueue = [];
                (0,_AsyncUtils__WEBPACK_IMPORTED_MODULE_16__.runTargetUnload)(_notificationManager, false);
                _notificationManager = null;
                _perfManager = null;
                _cfgPerfManager = null;
                (0,_AsyncUtils__WEBPACK_IMPORTED_MODULE_16__.runTargetUnload)(_cookieManager, false);
                _cookieManager = null;
                _pluginChain = null;
                _configExtensions = [];
                _channelConfig = null;
                _channels = null;
                _isUnloading = false;
                _internalLogsEventName = null;
                _evtNamespace = (0,_DataCacheHelper__WEBPACK_IMPORTED_MODULE_27__.createUniqueNamespace)("AIBaseCore", true);
                _unloadHandlers = (0,_UnloadHandlerContainer__WEBPACK_IMPORTED_MODULE_28__.createUnloadHandlerContainer)();
                _traceCtx = null;
                _instrumentationKey = null;
                _hookContainer = (0,_UnloadHookContainer__WEBPACK_IMPORTED_MODULE_29__.createUnloadHookContainer)();
                _cfgListeners = [];
                _pluginVersionString = null;
                _pluginVersionStringArr = null;
                _forceStopInternalLogPoller = false;
            }
            function _createTelCtx() {
                var theCtx = (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_19__.createProcessTelemetryContext)(_getPluginChain(), _configHandler.cfg, _self);
                theCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_ON_COMPLETE /* @min:%2eonComplete */](_startLogPoller);
                return theCtx;
            }
            // Initialize or Re-initialize the plugins
            function _initPluginChain(updateState) {
                // Extension validation
                var theExtensions = _validateExtensions(_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */], _Constants__WEBPACK_IMPORTED_MODULE_30__.ChannelControllerPriority, _configExtensions);
                _pluginChain = null;
                _pluginVersionString = null;
                _pluginVersionStringArr = null;
                // Get the primary channel queue and include as part of the normal extensions
                _channels = (_channelConfig || [])[0] || [];
                // Add any channels provided in the extensions and sort them
                _channels = (0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_22__.sortPlugins)((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_25__.arrAppend)(_channels, theExtensions[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CHANNELS /* @min:%2echannels */]));
                // Create an array of all extensions, including the _channels
                var allExtensions = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_25__.arrAppend)((0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_22__.sortPlugins)(theExtensions[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CORE /* @min:%2ecore */]), _channels);
                // Required to allow plugins to call core.getPlugin() during their own initialization
                _extensions = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.objFreeze)(allExtensions);
                // This has a side effect of adding the extensions passed during initialization
                // into the config.extensions, so you can see all of the extensions loaded.
                // This will also get updated by the addPlugin() and remove plugin code.
                var cfgExtensions = _self.config[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EXTENSIONS /* @min:%2eextensions */] || [];
                cfgExtensions.splice(0, cfgExtensions[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */]);
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_25__.arrAppend)(cfgExtensions, _extensions);
                var rootCtx = _createTelCtx();
                // Initializing the channels first
                if (_channels && _channels[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    (0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_22__.initializePlugins)(rootCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_CREATE_NEW /* @min:%2ecreateNew */](_channels), allExtensions);
                }
                // Now initialize the normal extensions (explicitly not including the _channels as this can cause duplicate initialization)
                (0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_22__.initializePlugins)(rootCtx, allExtensions);
                if (updateState) {
                    _doUpdate(updateState);
                }
            }
            function _getPlugin(pluginIdentifier) {
                var theExt = null;
                var thePlugin = null;
                var channelHosts = [];
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(_extensions, function (ext) {
                    if (ext[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IDENTIFIER /* @min:%2eidentifier */] === pluginIdentifier && ext !== _telemetryInitializerPlugin) {
                        thePlugin = ext;
                        return -1;
                    }
                    if (ext.getChannel) {
                        channelHosts[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](ext);
                    }
                });
                if (!thePlugin && channelHosts[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(channelHosts, function (host) {
                        thePlugin = host.getChannel(pluginIdentifier);
                        if (!thePlugin) {
                            return -1;
                        }
                    });
                }
                if (thePlugin) {
                    theExt = {
                        plugin: thePlugin,
                        setEnabled: function (enabled) {
                            (0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_22__._getPluginState)(thePlugin)[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_DISABLED] = !enabled;
                        },
                        isEnabled: function () {
                            var pluginState = (0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_22__._getPluginState)(thePlugin);
                            return !pluginState[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_TEARDOWN /* @min:%2eteardown */] && !pluginState[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_DISABLED];
                        },
                        remove: function (isAsync, removeCb) {
                            var _a;
                            if (isAsync === void 0) { isAsync = true; }
                            var pluginsToRemove = [thePlugin];
                            var unloadState = (_a = {
                                    reason: 1 /* TelemetryUnloadReason.PluginUnload */
                                },
                                _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IS_ASYNC /* @min:isAsync */] = isAsync,
                                _a);
                            _removePlugins(pluginsToRemove, unloadState, function (removed) {
                                if (removed) {
                                    // Re-Initialize the plugin chain
                                    _initPluginChain({
                                        reason: 32 /* TelemetryUpdateReason.PluginRemoved */,
                                        removed: pluginsToRemove
                                    });
                                }
                                removeCb && removeCb(removed);
                            });
                        }
                    };
                }
                return theExt;
            }
            function _getPluginChain() {
                if (!_pluginChain) {
                    // copy the collection of extensions
                    var extensions = (_extensions || []).slice();
                    // During add / remove this may get called again, so don't read if already present
                    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_31__.arrIndexOf)(extensions, _telemetryInitializerPlugin) === -1) {
                        extensions[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](_telemetryInitializerPlugin);
                    }
                    _pluginChain = (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_19__.createTelemetryProxyChain)((0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_22__.sortPlugins)(extensions), _configHandler.cfg, _self);
                }
                return _pluginChain;
            }
            function _removePlugins(thePlugins, unloadState, removeComplete) {
                if (thePlugins && thePlugins[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    var unloadChain = (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_19__.createTelemetryProxyChain)(thePlugins, _configHandler.cfg, _self);
                    var unloadCtx = (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_19__.createProcessTelemetryUnloadContext)(unloadChain, _self);
                    unloadCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_ON_COMPLETE /* @min:%2eonComplete */](function () {
                        var removed = false;
                        // Remove the listed config extensions
                        var newConfigExtensions = [];
                        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(_configExtensions, function (plugin, idx) {
                            if (!_isPluginPresent(plugin, thePlugins)) {
                                newConfigExtensions[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](plugin);
                            }
                            else {
                                removed = true;
                            }
                        });
                        _configExtensions = newConfigExtensions;
                        _pluginVersionString = null;
                        _pluginVersionStringArr = null;
                        // Re-Create the channel config
                        var newChannelConfig = [];
                        if (_channelConfig) {
                            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(_channelConfig, function (queue, idx) {
                                var newQueue = [];
                                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(queue, function (channel) {
                                    if (!_isPluginPresent(channel, thePlugins)) {
                                        newQueue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](channel);
                                    }
                                    else {
                                        removed = true;
                                    }
                                });
                                newChannelConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](newQueue);
                            });
                            _channelConfig = newChannelConfig;
                        }
                        removeComplete && removeComplete(removed);
                        _startLogPoller();
                    });
                    unloadCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](unloadState);
                }
                else {
                    removeComplete(false);
                }
            }
            function _flushInternalLogs() {
                if (_logger && _logger.queue) {
                    var queue = _logger.queue.slice(0);
                    _logger.queue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */] = 0;
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(queue, function (logMessage) {
                        var _a;
                        var item = (_a = {},
                            _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_NAME /* @min:name */] = _internalLogsEventName ? _internalLogsEventName : "InternalMessageId: " + logMessage[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_MESSAGE_ID /* @min:%2emessageId */],
                            _a.iKey = _instrumentationKey,
                            _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_TIME /* @min:time */] = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_13__.toISOString)(new Date()),
                            _a.baseType = _DiagnosticLogger__WEBPACK_IMPORTED_MODULE_7__._InternalLogMessage.dataType,
                            _a.baseData = { message: logMessage[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_MESSAGE /* @min:%2emessage */] },
                            _a);
                        _self.track(item);
                    });
                }
            }
            function _flushChannels(isAsync, callBack, sendReason, cbTimeout) {
                // Setting waiting to one so that we don't call the callBack until we finish iterating
                var waiting = 1;
                var doneIterating = false;
                var cbTimer = null;
                cbTimeout = cbTimeout || 5000;
                function doCallback() {
                    waiting--;
                    if (doneIterating && waiting === 0) {
                        cbTimer && cbTimer[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_CANCEL /* @min:%2ecancel */]();
                        cbTimer = null;
                        callBack && callBack(doneIterating);
                        callBack = null;
                    }
                }
                if (_channels && _channels[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    var flushCtx = _createTelCtx()[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_CREATE_NEW /* @min:%2ecreateNew */](_channels);
                    flushCtx.iterate(function (plugin) {
                        if (plugin.flush) {
                            waiting++;
                            var handled_1 = false;
                            // Not all channels will call this callback for every scenario
                            if (!plugin.flush(isAsync, function () {
                                handled_1 = true;
                                doCallback();
                            }, sendReason)) {
                                if (!handled_1) {
                                    // If any channel doesn't return true and it didn't call the callback, then we should assume that the callback
                                    // will never be called, so use a timeout to allow the channel(s) some time to "finish" before triggering any
                                    // followup function (such as unloading)
                                    if (isAsync && cbTimer == null) {
                                        cbTimer = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_17__.scheduleTimeout)(function () {
                                            cbTimer = null;
                                            doCallback();
                                        }, cbTimeout);
                                    }
                                    else {
                                        doCallback();
                                    }
                                }
                            }
                        }
                    });
                }
                doneIterating = true;
                doCallback();
                return true;
            }
            function _initDebugListener() {
                // Lazily ensure that the notification manager is created
                !_notificationManager && _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_GET_NOTIFY_MGR /* @min:%2egetNotifyMgr */]();
                // Will get recalled if any referenced config values are changed
                _addUnloadHook(_configHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_WATCH /* @min:%2ewatch */](function (details) {
                    var disableDbgExt = details.cfg.disableDbgExt;
                    if (disableDbgExt === true && _debugListener) {
                        // Remove any previously loaded debug listener
                        _notificationManager[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_REMOVE_NOTIFICATION_2 /* @min:%2eremoveNotificationListener */](_debugListener);
                        _debugListener = null;
                    }
                    if (_notificationManager && !_debugListener && disableDbgExt !== true) {
                        _debugListener = (0,_DbgExtensionUtils__WEBPACK_IMPORTED_MODULE_32__.getDebugListener)(details.cfg);
                        _notificationManager[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_ADD_NOTIFICATION_LIS1 /* @min:%2eaddNotificationListener */](_debugListener);
                    }
                }));
            }
            function _initPerfManager() {
                // Will get recalled if any referenced config values are changed
                _addUnloadHook(_configHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_WATCH /* @min:%2ewatch */](function (details) {
                    var enablePerfMgr = details.cfg.enablePerfMgr;
                    if (!enablePerfMgr && _cfgPerfManager) {
                        // Remove any existing config based performance manager
                        _cfgPerfManager = null;
                    }
                    if (enablePerfMgr) {
                        // Set the performance manager creation function if not defined
                        (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_13__.getSetValue)(details.cfg, _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CREATE_PERF_MGR, _createPerfManager);
                    }
                }));
            }
            function _doUpdate(updateState) {
                var updateCtx = (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_19__.createProcessTelemetryUpdateContext)(_getPluginChain(), _self);
                updateCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_ON_COMPLETE /* @min:%2eonComplete */](_startLogPoller);
                if (!_self._updateHook || _self._updateHook(updateCtx, updateState) !== true) {
                    updateCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](updateState);
                }
            }
            function _logOrThrowError(message) {
                var logger = _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */];
                if (logger) {
                    // there should always be a logger
                    (0,_DiagnosticLogger__WEBPACK_IMPORTED_MODULE_7__._throwInternal)(logger, 2 /* eLoggingSeverity.WARNING */, 73 /* _eInternalMessageId.PluginException */, message);
                    _startLogPoller();
                }
                else {
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.throwError)(message);
                }
            }
            function _notifyInvalidEvent(telemetryItem) {
                var manager = _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_GET_NOTIFY_MGR /* @min:%2egetNotifyMgr */]();
                if (manager) {
                    manager[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EVENTS_DISCARDED /* @min:%2eeventsDiscarded */]([telemetryItem], 2 /* eEventsDiscardedReason.InvalidEvent */);
                }
            }
            function _addUnloadHook(hooks) {
                _hookContainer.add(hooks);
            }
        });
    }
// Removed Stub for AppInsightsCore.prototype.initialize.
// Removed Stub for AppInsightsCore.prototype.getChannels.
// Removed Stub for AppInsightsCore.prototype.track.
// Removed Stub for AppInsightsCore.prototype.getProcessTelContext.
// Removed Stub for AppInsightsCore.prototype.getNotifyMgr.
// Removed Stub for AppInsightsCore.prototype.addNotificationListener.
// Removed Stub for AppInsightsCore.prototype.removeNotificationListener.
// Removed Stub for AppInsightsCore.prototype.getCookieMgr.
// Removed Stub for AppInsightsCore.prototype.setCookieMgr.
// Removed Stub for AppInsightsCore.prototype.getPerfMgr.
// Removed Stub for AppInsightsCore.prototype.setPerfMgr.
// Removed Stub for AppInsightsCore.prototype.eventCnt.
// Removed Stub for AppInsightsCore.prototype.pollInternalLogs.
// Removed Stub for AppInsightsCore.prototype.stopPollingInternalLogs.
// Removed Stub for AppInsightsCore.prototype.addTelemetryInitializer.
// Removed Stub for AppInsightsCore.prototype.unload.
// Removed Stub for AppInsightsCore.prototype.getPlugin.
// Removed Stub for AppInsightsCore.prototype.addPlugin.
// Removed Stub for AppInsightsCore.prototype.updateCfg.
// Removed Stub for AppInsightsCore.prototype.evtNamespace.
// Removed Stub for AppInsightsCore.prototype.addUnloadCb.
// Removed Stub for AppInsightsCore.prototype.flush.
// Removed Stub for AppInsightsCore.prototype.getTraceCtx.
// Removed Stub for AppInsightsCore.prototype.setTraceCtx.
// Removed Stub for AppInsightsCore.prototype.addUnloadHook.
// Removed Stub for AppInsightsCore.prototype.onCfgChange.
// Removed Stub for AppInsightsCore.prototype.releaseQueue.
// Removed Stub for AppInsightsCore.prototype._updateHook.
    // This is a workaround for an IE bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    AppInsightsCore.__ieDyn=1;

    return AppInsightsCore;
}());

//# sourceMappingURL=AppInsightsCore.js.map

/***/ }),
/* 80 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "objAssign": () => (/* binding */ objAssign),
/* harmony export */   "objDeepFreeze": () => (/* binding */ objDeepFreeze),
/* harmony export */   "objEntries": () => (/* binding */ objEntries),
/* harmony export */   "objFreeze": () => (/* binding */ objFreeze),
/* harmony export */   "objGetPrototypeOf": () => (/* binding */ objGetPrototypeOf),
/* harmony export */   "objKeys": () => (/* binding */ objKeys),
/* harmony export */   "objSeal": () => (/* binding */ objSeal),
/* harmony export */   "objValues": () => (/* binding */ objValues)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(74);
/* harmony import */ var _helpers_base__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(73);
/* harmony import */ var _helpers_throw__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(81);
/* harmony import */ var _for_each_key__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(82);
/* harmony import */ var _polyfills_object__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(86);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */





var _objFreeze = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass.freeze;
var _doNothing = function (value) { return value; };
var _getProto = function (value) { return value[_internal_constants__WEBPACK_IMPORTED_MODULE_0__.__PROTO__] || _internal_constants__WEBPACK_IMPORTED_MODULE_0__.NULL_VALUE; };
/**
 * The `objAssign()` method copies all enumerable own properties from one or more source objects
 * to a target object. It returns the modified target object.
 *
 * Properties in the target object are overwritten by properties in the sources if they have the
 * same key. Later sources' properties overwrite earlier ones.
 *
 * The objAssign() method only copies enumerable and own properties from a source object to a
 * target object. It uses `Get` on the source and `Set` on the target, so it will invoke
 * [getters](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/get) and
 * [setters](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/set).
 * Therefore it assigns properties, versus copying or defining new properties. This may make it
 * unsuitable for merging new properties into a prototype if the merge sources contain getters.
 *
 * For copying property definitions (including their enumerability) into prototypes, use
 * {@link objGetOwnPropertyDescriptor} and {@link objDefineProp} instead.
 *
 * Both String and Symbol properties are copied.
 *
 * In case of an error, for example if a property is non-writable, a TypeError is raised, and
 * the target object is changed if any properties are added before the error is raised.
 * @group Object
 * @example
 * ```ts
 * const obj = { a: 1 };
 * const copy = objAssign({}, obj);
 * console.log(copy); // { a: 1 }
 *
 * const o1 = { a: 1 };
 * const o2 = { b: 2 };
 * const o3 = { c: 3 };
 *
 * const obj = objAssign(o1, o2, o3);
 * console.log(obj); // { a: 1, b: 2, c: 3 }
 * console.log(o1);  // { a: 1, b: 2, c: 3 }, target object itself is changed.
 * ```
 */
var objAssign = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass.assign;
/**
 * The `objKeys()` method returns an array of a given object's own enumerable property names, iterated in
 * the same order that a normal loop would.
 *
 * objKeys() returns an array whose elements are strings corresponding to the enumerable properties found
 * directly upon object. The ordering of the properties is the same as that given by looping over the
 * properties of the object manually.
 * @group Object
 * @param value - The object to obtain a copy of the keys from
 * @returns An array of the properties names for the value object.
 * @example
 * ```ts
 * // simple array
 * const arr = ['a', 'b', 'c'];
 * console.log(objKeys(arr)); // console: ['0', '1', '2']
 *
 * // array-like object
 * const obj = { 0: 'a', 1: 'b', 2: 'c' };
 * console.log(objKeys(obj)); // console: ['0', '1', '2']
 *
 * // array-like object with random key ordering
 * const anObj = { 100: 'a', 2: 'b', 7: 'c' };
 * console.log(objKeys(anObj)); // console: ['2', '7', '100']
 *
 * // getFoo is a property which isn't enumerable
 * const myObj = objCreate({}, {
 *   getFoo: {
 *     value() { return this.foo; }
 *   }
 * });
 * myObj.foo = 1;
 * console.log(objKeys(myObj)); // console: ['foo']
 * ```
 */
function objKeys(value) {
    if (!(0,_helpers_base__WEBPACK_IMPORTED_MODULE_1__.isObject)(value) || value === _internal_constants__WEBPACK_IMPORTED_MODULE_0__.NULL_VALUE) {
        (0,_helpers_throw__WEBPACK_IMPORTED_MODULE_2__.throwTypeError)("objKeys called on non-object");
    }
    return _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass.keys(value);
}
/**
 * Perform a deep freeze on the object and all of it's contained values / properties by recursively calling
 * `objFreeze()` on all enumerable properties of the object and on each property returned.
 * @group Object
 * @param value - the object to be completly frozen.
 * @returns The originally passed in object.
 */
function objDeepFreeze(value) {
    if (_objFreeze) {
        (0,_for_each_key__WEBPACK_IMPORTED_MODULE_3__.objForEachKey)(value, function (key, value) {
            if ((0,_helpers_base__WEBPACK_IMPORTED_MODULE_1__.isArray)(value) || (0,_helpers_base__WEBPACK_IMPORTED_MODULE_1__.isObject)(value)) {
                _objFreeze(value);
            }
        });
    }
    return objFreeze(value);
}
/**
 * The `objFreeze()` method freezes an object. A frozen object can no longer be changed; freezing an object
 * prevents new properties from being added to it, existing properties from being removed, prevents changing the
 * enumerability, configurability, or writability of existing properties, and prevents the values of existing
 * properties from being changed. In addition, freezing an object also prevents its prototype from being changed.
 * `objFreeze()` returns the same object that was passed in.
 *
 * Nothing can be added to or removed from the properties set of a frozen object. Any attempt to do so will fail,
 * either silently or by throwing a TypeError exception (most commonly, but not exclusively, when in strict mode).
 *
 * For data properties of a frozen object, values cannot be changed, the writable and configurable attributes are
 * set to false. Accessor properties (getters and setters) work the same (and still give the illusion that you are
 * changing the value). Note that values that are objects can still be modified, unless they are also frozen. As
 * an object, an array can be frozen; after doing so, its elements cannot be altered and no elements can be added
 * to or removed from the array.
 *
 * `objFreeze()` returns the same object that was passed into the function. It does not create a frozen copy.
 * @group Object
 * @param value - The object to freeze.
 * @returns The object that was passed to the function.
 */
var objFreeze = _objFreeze || _doNothing;
/**
 * The `objSeal()` method seals an object, preventing new properties from being added to it and marking all
 * existing properties as non-configurable. Values of present properties can still be changed as long as they
 * are writable.
 * @group Object
 * @param value - The object which should be sealed.
 * @returns The object being sealed.
 */
var objSeal = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass.seal || _doNothing;
/**
 * The objGetPrototypeOf() method returns the prototype (i.e. the value of the internal `Prototype` property)
 * of the specified value.
 * @since 0.4.4
 * @group Object
 * @param value - The object whose prototype is to be returned, which may be null.
 */
var objGetPrototypeOf = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass.getPrototypeOf || _getProto;
/**
 * Returns an array of key/values of the enumerable properties of an object
 * @since 0.9.7
 * @group Object
 * @group ArrayLike
 * @param value Object that contains the properties and methods.
 * @example
 * ```ts
 * objEntries({ Hello: "Darkness", my: "old", friend: "." });
 * // [ [ "Hello", "Darkness" ], [ "my", "old"], [ "friend", "." ] ]
 *
 * // Array-like object
 * objEntries({ 0: "a", 1: "b", 2: "c" }));
 * // [ ['0', 'a'], ['1', 'b'], ['2', 'c'] ]
 *
 * // Array-like object with random key ordering
 * objEntries({ 100: "a", 2: "b", 7: "c" });
 * // [ ['2', 'b'], ['7', 'c'], ['100', 'a'] ]*
 * ```
 */
var objEntries = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass.entries || _polyfills_object__WEBPACK_IMPORTED_MODULE_4__.polyObjEntries;
/**
 * The objValues() returns an array whose elements are values of enumerable string-keyed properties found
 * directly upon object. This is the same as iterating with a for...in loop, except that a for...in loop
 * enumerates properties in the prototype chain as well. The order of the array returned by objValues()
 * is the same as that provided by a for...in loop.
 *
 * If you need the property keys, use objKeys() instead. If you need both the property keys and values, use objEntries() instead.
 * @since 0.9.7
 * @group Object
 * @group ArrayLike
 * @param value - The object that contains the properties and methods.
 * @returns An array containing the given object's own enumerable string-keyed property values.
 * @example
 * ```ts
 * objValues({ Hello: "Darkness", my: "old", friend: "." });
 * // [ "Darkness", "old", "." ]
 *
 * // Array-like object
 * objValues({ 0: "a", 1: "b", 2: "c" }));
 * // [ 'a', 'b', 'c']
 *
 * // Array-like object with random key ordering
 * objValues({ 100: "a", 2: "b", 7: "c" });
 * // [ 'b', 'c', 'a']
 * ```
 */
var objValues = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass.values || _polyfills_object__WEBPACK_IMPORTED_MODULE_4__.polyObjValues;
//# sourceMappingURL=object.js.map

/***/ }),
/* 81 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "throwError": () => (/* binding */ throwError),
/* harmony export */   "throwRangeError": () => (/* binding */ throwRangeError),
/* harmony export */   "throwTypeError": () => (/* binding */ throwTypeError)
/* harmony export */ });
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */
/**
 * Throw an error exception with the specified optional message
 * @group Error
 * @param message
 */
function throwError(message) {
    throw new Error(message);
}
/**
 * Throw a type error with the specified optional message
 * @group Error
 * @param message
 */
function throwTypeError(message) {
    throw new TypeError(message);
}
/**
 * Throw a RangeError with the specified optional message
 * @group Error
 * @param message
 */
function throwRangeError(message) {
    throw new RangeError(message);
}
//# sourceMappingURL=throw.js.map

/***/ }),
/* 82 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "objForEachKey": () => (/* binding */ objForEachKey)
/* harmony export */ });
/* harmony import */ var _helpers_base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(73);
/* harmony import */ var _has_own__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(83);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */


/**
 * Calls the provided `callbackFn` function once for each key in an object. This is equivelent to `arrForEach(Object.keys(theObject), callbackFn)` or
 * if not using the array helper `Object.keys(theObject).forEach(callbackFn)` except that this helper avoid creating a temporary of the object
 * keys before iterating over them and like the `arrForEach` helper you CAN stop or break the iteration by returning -1 from the `callbackFn` function.
 * @group Object
 * @typeParam T - The object type
 * @param callbackfn  A function that accepts up to two arguments, the key name and the current value of the property represented by the key.
 * @param thisArg  [Optional] An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, null or undefined
 * the object will be used as the this value.
 * @example
 * ```ts
 * function performAction<T>(target: T, source: any) {
 *    if (!isNullOrUndefined(source)) {
 *        objForEachKey(source, (key, value) => {
 *            // Set the target with a reference to the same value with the same name
 *            target[key] = value;
 *        });
 *    }
 *
 *    return target;
 * }
 * ```
 */
function objForEachKey(theObject, callbackfn, thisArg) {
    if (theObject && (0,_helpers_base__WEBPACK_IMPORTED_MODULE_0__.isObject)(theObject)) {
        for (var prop in theObject) {
            if ((0,_has_own__WEBPACK_IMPORTED_MODULE_1__.objHasOwn)(theObject, prop)) {
                if (callbackfn.call(thisArg || theObject, prop, theObject[prop]) === -1) {
                    break;
                }
            }
        }
    }
}
//# sourceMappingURL=for_each_key.js.map

/***/ }),
/* 83 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "objHasOwn": () => (/* binding */ objHasOwn),
/* harmony export */   "polyObjHasOwn": () => (/* binding */ polyObjHasOwn)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(74);
/* harmony import */ var _get_own_prop_desc__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(85);
/* harmony import */ var _has_own_prop__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(84);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */



/**
 * The objHasOwn() method returns a boolean indicating whether the object
 * has the specified property as its own property (as opposed to inheriting it).
 * If the property is inherited, or does not exist, the method returns false.
 *
 * The objHasOwn() method returns true if the specified property is a direct property
 * of the object — even if the property value is null or undefined. The method returns
 * false if the property is inherited, or has not been declared at all. Unlike the in operator,
 * this method does not check for the specified property in the object's prototype chain.
 *
 * It is recommended over {@link objHasOwnProperty} () because it works for objects created using
 * objCreate(null) and with objects that have overridden the inherited hasOwnProperty() method.
 * While it is possible to workaround these problems by calling Object.prototype.hasOwnProperty()
 * on an external object, Object.hasOwn() is more intuitive.
 *
 * @since 0.4.3
 * @group Object
 * @param obj - The object being evaluated
 * @param prop - The String or Symbol of the property to test
 * @returns `true` if the object has the specified property as own property; otherwise `false`
 * @example
 * ```ts
 * let example = {};
 * objHasOwn(example, 'prop');   // false
 *
 * example.prop = 'exists';
 * objHasOwn(example, 'prop');   // true - 'prop' has been defined
 *
 * example.prop = null;
 * objHasOwn(example, 'prop');   // true - own property exists with value of null
 *
 * example.prop = undefined;
 * objHasOwn(example, 'prop');   // true - own property exists with value of undefined
 * ```
 */
var objHasOwn = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass.hasOwn || polyObjHasOwn;
/**
 * The polyObjHasOwn() method is a polyfill for {@link objHasOwn} when the native
 * [Object.hasOwnreturns](https://caniuse.com/?search=hasOwn) is not supported, it returns a
 * boolean indicating whether the object has the specified property as its own property (as
 * opposed to inheriting it). If the property is inherited, or does not exist, the method
 * returns false.
 *
 * The objHasOwn() method returns true if the specified property is a direct property
 * of the object — even if the property value is null or undefined. The method returns
 * false if the property is inherited, or has not been declared at all. Unlike the in operator,
 * this method does not check for the specified property in the object's prototype chain.
 *
 * It is recommended over objHasOwnProperty() because it works for objects created using
 * objCreate(null) and with objects that have overridden the inherited hasOwnProperty() method.
 * While it is possible to workaround these problems by calling Object.prototype.hasOwnProperty()
 * on an external object, Object.hasOwn() is more intuitive.
 *
 * @since 0.4.3
 * @group Object
 * @group Polyfill
 * @param obj - The object being evaluated
 * @param prop - The String or Symbol of the property to test
 * @returns `true` if the object has the specified property as own property; otherwise `false`
 * @example
 * ```ts
 * let example = {};
 * polyObjHasOwn(example, 'prop');   // false
 *
 * example.prop = 'exists';
 * polyObjHasOwn(example, 'prop');   // true - 'prop' has been defined
 *
 * example.prop = null;
 * polyObjHasOwn(example, 'prop');   // true - own property exists with value of null
 *
 * example.prop = undefined;
 * polyObjHasOwn(example, 'prop');   // true - own property exists with value of undefined
 * ```
 */
function polyObjHasOwn(obj, prop) {
    return (0,_has_own_prop__WEBPACK_IMPORTED_MODULE_1__.objHasOwnProperty)(obj, prop) || !!(0,_get_own_prop_desc__WEBPACK_IMPORTED_MODULE_2__.objGetOwnPropertyDescriptor)(obj, prop);
}
//# sourceMappingURL=has_own.js.map

/***/ }),
/* 84 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "objHasOwnProperty": () => (/* binding */ objHasOwnProperty)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(74);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */

/**
 * The objHasOwnProperty() method returns a boolean indicating whether the object
 * has the specified property as its own property (as opposed to inheriting it).
 *
 * The objHasOwnProperty() method returns true if the specified property is a direct
 * property of the object — even if the value is null or undefined. The method returns
 * false if the property is inherited, or has not been declared at all. Unlike the in
 * operator, this method does not check for the specified property in the object's
 * prototype chain.
 *
 * The method can be called on most JavaScript objects, because most objects descend
 * from Object, and hence inherit its methods. For example Array is an Object, so you
 * can use objHasOwnProperty() method to check whether an index exists:
 * @group Object
 * @param obj - The object being evaluated
 * @param prop - The String or Symbol of the property to test
 * @returns `true` if the object has the specified property as own property; otherwise `false`
 * @example
 * ```ts
 * let example = {};
 * objHasOwnProperty(example, 'prop');   // false
 *
 * example.prop = 'exists';
 * objHasOwnProperty(example, 'prop');   // true - 'prop' has been defined
 *
 * example.prop = null;
 * objHasOwnProperty(example, 'prop');   // true - own property exists with value of null
 *
 * example.prop = undefined;
 * objHasOwnProperty(example, 'prop');   // true - own property exists with value of undefined
 * ```
 */
function objHasOwnProperty(obj, prop) {
    return obj && _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjProto.hasOwnProperty.call(obj, prop);
}
//# sourceMappingURL=has_own_prop.js.map

/***/ }),
/* 85 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "objGetOwnPropertyDescriptor": () => (/* binding */ objGetOwnPropertyDescriptor)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(74);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */

/**
 * The objGetOwnPropertyDescriptor() method returns an object describing the configuration of a specific property on
 * a given object (that is, one directly present on an object and not in the object's prototype chain). The object
 * returned is mutable but mutating it has no effect on the original property's configuration.
 * @since 0.4.3
 * @group Object
 * @param target - Object that contains the property.
 * @param prop - Name of the property.
 * @returns A property descriptor of the given property if it exists on the object, otherwise undefined.
 *
 * @example
 * ```ts
 * o = {};
 * objDefineProp(o, 'qux', {
 *   value: 8675309,
 *   writable: false,
 *   enumerable: false
 * });
 * d = objGetOwnPropertyDescriptor(o, 'qux');
 * // d is {
 * //   value: 8675309,
 * //   writable: false,
 * //   enumerable: false,
 * //   configurable: false
 * // }
 *
 * objGetOwnPropertyDescriptor('foo', 0);
 * // TypeError: "foo" is not an object  // ES5 code
 *
 * objGetOwnPropertyDescriptor('foo', 0);
 * // Object returned by ES2015 code: {
 * //   configurable: false,
 * //   enumerable: true,
 * //   value: "f",
 * //   writable: false
 * // }
 * ```
 * Note: In ES5, if the first argument to this method is not an object (a primitive), then it will cause a TypeError. In ES2015, a non-object first argument will be coerced to an object at first.
 */
var objGetOwnPropertyDescriptor = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass.getOwnPropertyDescriptor;
//# sourceMappingURL=get_own_prop_desc.js.map

/***/ }),
/* 86 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "polyObjEntries": () => (/* binding */ polyObjEntries),
/* harmony export */   "polyObjKeys": () => (/* binding */ polyObjKeys),
/* harmony export */   "polyObjValues": () => (/* binding */ polyObjValues)
/* harmony export */ });
/* harmony import */ var _helpers_base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(73);
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(74);
/* harmony import */ var _object_for_each_key__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(82);
/* harmony import */ var _object_has_own__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(83);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */




/**
 * Returns the names of the enumerable string properties and methods of an object. This helper exists to avoid adding a polyfil for older browsers
 * that do not define Object.keys eg. ES3 only, IE8 just in case any page checks for presence/absence of the prototype implementation.
 * Note: For consistency this will not use the Object.keys implementation if it exists as this would cause a testing requirement to test with and without the implementations
 * @group Polyfill
 * @group Object
 * @param obj Object that contains the properties and methods. This can be an object that you created or an existing Document Object Model (DOM) object.
 */
function polyObjKeys(obj) {
    if (!(0,_helpers_base__WEBPACK_IMPORTED_MODULE_0__.isObject)(obj) || obj === _internal_constants__WEBPACK_IMPORTED_MODULE_1__.NULL_VALUE) {
        throw new TypeError("polyObjKeys called on non-object");
    }
    var result = [];
    for (var prop in obj) {
        if ((0,_object_has_own__WEBPACK_IMPORTED_MODULE_2__.objHasOwn)(obj, prop)) {
            result.push(prop);
        }
    }
    return result;
}
/**
 * Returns an array of key/values of the enumerable properties of an object
 * @since 0.9.7
 * @group Polyfill
 * @group Object
 * @group ArrayLike
 * @param value Object that contains the properties and methods.
 * @example
 * ```ts
 * polyObjEntries({ Hello: "Darkness", my: "old", friend: "." });
 * // [ [ "Hello", "Darkness" ], [ "my", "old"], [ "friend", "." ] ]
 *
 * // Array-like object
 * polyObjEntries({ 0: "a", 1: "b", 2: "c" }));
 * // [ ['0', 'a'], ['1', 'b'], ['2', 'c'] ]
 *
 * // Array-like object with random key ordering
 * polyObjEntries({ 100: "a", 2: "b", 7: "c" });
 * // [ ['2', 'b'], ['7', 'c'], ['100', 'a'] ]*
 * ```
 */
function polyObjEntries(value) {
    var result = [];
    (0,_object_for_each_key__WEBPACK_IMPORTED_MODULE_3__.objForEachKey)(value, function (key, value) {
        result.push([key, value]);
    });
    return result;
}
/**
 * Returns an array of key/values of the enumerable properties of an object
 * @since 0.9.7
 * @group Polyfill
 * @group Object
 * @group ArrayLike
 * @param value Object that contains the properties and methods.
 * @example
 * ```ts
 * polyObjValues({ Hello: "Darkness", my: "old", friend: "." });
 * // [ "Darkness", "old", "." ]
 *
 * // Array-like object
 * polyObjValues({ 0: "a", 1: "b", 2: "c" }));
 * // [ 'a', 'b', 'c']
 *
 * // Array-like object with random key ordering
 * polyObjValues({ 100: "a", 2: "b", 7: "c" });
 * // [ 'b', 'c', 'a']
 * ```
 */
function polyObjValues(value) {
    var result = [];
    (0,_object_for_each_key__WEBPACK_IMPORTED_MODULE_3__.objForEachKey)(value, function (key, value) {
        result.push(value);
    });
    return result;
}
//# sourceMappingURL=object.js.map

/***/ }),
/* 87 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PerfEvent": () => (/* binding */ PerfEvent),
/* harmony export */   "PerfManager": () => (/* binding */ PerfManager),
/* harmony export */   "doPerf": () => (/* binding */ doPerf),
/* harmony export */   "getGblPerfMgr": () => (/* binding */ getGblPerfMgr),
/* harmony export */   "setGblPerfMgr": () => (/* binding */ setGblPerfMgr)
/* harmony export */ });
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(90);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(88);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(73);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(89);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(77);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(78);
/*
 * Application Insights JavaScript SDK - Core, 3.0.2
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */






var strExecutionContextKey = "ctx";
var strParentContextKey = "ParentContextKey";
var strChildrenContextKey = "ChildrenContextKey";
var _defaultPerfManager = null;
var PerfEvent = /** @class */ (function () {
    function PerfEvent(name, payloadDetails, isAsync) {
        var _self = this;
        _self.start = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.utcNow)();
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_NAME /* @min:%2ename */] = name;
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_ASYNC /* @min:%2eisAsync */] = isAsync;
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_CHILD_EVT /* @min:%2eisChildEvt */] = function () { return false; };
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.isFunction)(payloadDetails)) {
            // Create an accessor to minimize the potential performance impact of executing the payloadDetails callback
            var theDetails_1;
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.objDefine)(_self, "payload", {
                g: function () {
                    // Delay the execution of the payloadDetails until needed
                    if (!theDetails_1 && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.isFunction)(payloadDetails)) {
                        theDetails_1 = payloadDetails();
                        // clear it out now so the referenced objects can be garbage collected
                        payloadDetails = null;
                    }
                    return theDetails_1;
                }
            });
        }
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_CTX /* @min:%2egetCtx */] = function (key) {
            if (key) {
                // The parent and child links are located directly on the object (for better viewing in the DebugPlugin)
                if (key === PerfEvent[strParentContextKey] || key === PerfEvent[strChildrenContextKey]) {
                    return _self[key];
                }
                return (_self[strExecutionContextKey] || {})[key];
            }
            return null;
        };
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */] = function (key, value) {
            if (key) {
                // Put the parent and child links directly on the object (for better viewing in the DebugPlugin)
                if (key === PerfEvent[strParentContextKey]) {
                    // Simple assumption, if we are setting a parent then we must be a child
                    if (!_self[key]) {
                        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_CHILD_EVT /* @min:%2eisChildEvt */] = function () { return true; };
                    }
                    _self[key] = value;
                }
                else if (key === PerfEvent[strChildrenContextKey]) {
                    _self[key] = value;
                }
                else {
                    var ctx = _self[strExecutionContextKey] = _self[strExecutionContextKey] || {};
                    ctx[key] = value;
                }
            }
        };
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_COMPLETE /* @min:%2ecomplete */] = function () {
            var childTime = 0;
            var childEvts = _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_CTX /* @min:%2egetCtx */](PerfEvent[strChildrenContextKey]);
            if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.isArray)(childEvts)) {
                for (var lp = 0; lp < childEvts[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */]; lp++) {
                    var childEvt = childEvts[lp];
                    if (childEvt) {
                        childTime += childEvt[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TIME /* @min:%2etime */];
                    }
                }
            }
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TIME /* @min:%2etime */] = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.utcNow)() - _self.start;
            _self.exTime = _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TIME /* @min:%2etime */] - childTime;
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_COMPLETE /* @min:%2ecomplete */] = function () { };
        };
    }
    PerfEvent.ParentContextKey = "parent";
    PerfEvent.ChildrenContextKey = "childEvts";
    return PerfEvent;
}());

var PerfManager = /** @class */ (function () {
    function PerfManager(manager) {
        /**
         * General bucket used for execution context set and retrieved via setCtx() and getCtx.
         * Defined as private so it can be visualized via the DebugPlugin
         */
        this.ctx = {};
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_4__["default"])(PerfManager, this, function (_self) {
            _self.create = function (src, payloadDetails, isAsync) {
                // TODO (@MSNev): at some point we will want to add additional configuration to "select" which events to instrument
                // for now this is just a simple do everything.
                return new PerfEvent(src, payloadDetails, isAsync);
            };
            _self.fire = function (perfEvent) {
                if (perfEvent) {
                    perfEvent[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_COMPLETE /* @min:%2ecomplete */]();
                    if (manager && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.isFunction)(manager[_InternalConstants__WEBPACK_IMPORTED_MODULE_5__.STR_PERF_EVENT /* @min:%2eperfEvent */])) {
                        manager[_InternalConstants__WEBPACK_IMPORTED_MODULE_5__.STR_PERF_EVENT /* @min:%2eperfEvent */](perfEvent);
                    }
                }
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */] = function (key, value) {
                if (key) {
                    var ctx = _self[strExecutionContextKey] = _self[strExecutionContextKey] || {};
                    ctx[key] = value;
                }
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_CTX /* @min:%2egetCtx */] = function (key) {
                return (_self[strExecutionContextKey] || {})[key];
            };
        });
    }
// Removed Stub for PerfManager.prototype.create.
// Removed Stub for PerfManager.prototype.fire.
// Removed Stub for PerfManager.prototype.setCtx.
// Removed Stub for PerfManager.prototype.getCtx.
    // This is a workaround for an IE bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    PerfManager.__ieDyn=1;

    return PerfManager;
}());

var doPerfActiveKey = "CoreUtils.doPerf";
/**
 * Helper function to wrap a function with a perf event
 * @param mgrSource - The Performance Manager or a Performance provider source (may be null)
 * @param getSource - The callback to create the source name for the event (if perf monitoring is enabled)
 * @param func - The function to call and measure
 * @param details - A function to return the payload details
 * @param isAsync - Is the event / function being call asynchronously or synchronously
 */
function doPerf(mgrSource, getSource, func, details, isAsync) {
    if (mgrSource) {
        var perfMgr = mgrSource;
        if (perfMgr[_InternalConstants__WEBPACK_IMPORTED_MODULE_5__.STR_GET_PERF_MGR]) {
            // Looks like a perf manager provider object
            perfMgr = perfMgr[_InternalConstants__WEBPACK_IMPORTED_MODULE_5__.STR_GET_PERF_MGR]();
        }
        if (perfMgr) {
            var perfEvt = void 0;
            var currentActive = perfMgr[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_CTX /* @min:%2egetCtx */](doPerfActiveKey);
            try {
                perfEvt = perfMgr.create(getSource(), details, isAsync);
                if (perfEvt) {
                    if (currentActive && perfEvt[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */]) {
                        perfEvt[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */](PerfEvent[strParentContextKey], currentActive);
                        if (currentActive[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_CTX /* @min:%2egetCtx */] && currentActive[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */]) {
                            var children = currentActive[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_CTX /* @min:%2egetCtx */](PerfEvent[strChildrenContextKey]);
                            if (!children) {
                                children = [];
                                currentActive[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */](PerfEvent[strChildrenContextKey], children);
                            }
                            children[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PUSH /* @min:%2epush */](perfEvt);
                        }
                    }
                    // Set this event as the active event now
                    perfMgr[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */](doPerfActiveKey, perfEvt);
                    return func(perfEvt);
                }
            }
            catch (ex) {
                if (perfEvt && perfEvt[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */]) {
                    perfEvt[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */]("exception", ex);
                }
            }
            finally {
                // fire the perf event
                if (perfEvt) {
                    perfMgr.fire(perfEvt);
                }
                // Reset the active event to the previous value
                perfMgr[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */](doPerfActiveKey, currentActive);
            }
        }
    }
    return func();
}
/**
 * Set the global performance manager to use when there is no core instance or it has not been initialized yet.
 * @param perfManager - The IPerfManager instance to use when no performance manager is supplied.
 */
function setGblPerfMgr(perfManager) {
    _defaultPerfManager = perfManager;
}
/**
 * Get the current global performance manager that will be used with no performance manager is supplied.
 * @returns - The current default manager
 */
function getGblPerfMgr() {
    return _defaultPerfManager;
}
//# sourceMappingURL=PerfManager.js.map

/***/ }),
/* 88 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "polyUtcNow": () => (/* binding */ polyUtcNow),
/* harmony export */   "utcNow": () => (/* binding */ utcNow)
/* harmony export */ });
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */
/**
 * Return the number of milliseconds that have elapsed since January 1, 1970 00:00:00 UTC.
 *
 * To offer protection against timing attacks and fingerprinting, the precision of dateNow()
 * might get rounded depending on browser settings. In Firefox, the privacy.reduceTimerPrecision
 * preference is enabled by default and defaults to 20µs in Firefox 59; in 60 it will be 2ms.
 *
 * @since 0.4.4
 * @group Timer
 *
 * @returns A Number representing the milliseconds elapsed since the UNIX epoch.
 * @example
 * ```ts
 * let now = utcNow();
 * ```
 */
function utcNow() {
    return (Date.now || polyUtcNow)();
}
/**
 * Polyfill fallback to return the number of milliseconds that have elapsed since January 1, 1970 00:00:00 UTC.
 *
 * To offer protection against timing attacks and fingerprinting, the precision of dateNow()
 * might get rounded depending on browser settings. In Firefox, the privacy.reduceTimerPrecision
 * preference is enabled by default and defaults to 20µs in Firefox 59; in 60 it will be 2ms.
 *
 * @since 0.4.4
 * @group Timer
 * @group Polyfill
 *
 * @returns A Number representing the milliseconds elapsed since the UNIX epoch.
  * @example
 * ```ts
 * let now = polyUtcNow();
 * ```
*/
function polyUtcNow() {
    return new Date().getTime();
}
//# sourceMappingURL=date.js.map

/***/ }),
/* 89 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "objDefine": () => (/* binding */ objDefine),
/* harmony export */   "objDefineAccessors": () => (/* binding */ objDefineAccessors),
/* harmony export */   "objDefineGet": () => (/* binding */ objDefineGet),
/* harmony export */   "objDefineProp": () => (/* binding */ objDefineProp),
/* harmony export */   "objDefineProperties": () => (/* binding */ objDefineProperties),
/* harmony export */   "objDefineProps": () => (/* binding */ objDefineProps)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(74);
/* harmony import */ var _helpers_base__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(73);
/* harmony import */ var _for_each_key__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(82);
/* harmony import */ var _get_own_prop_desc__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(85);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */




/**
 * @internal
 * @ignore
 * Mapping from ObjDefinePropDescriptor key to PropertyDescriptor key
 */
var propMap = {
    e: "enumerable",
    c: "configurable",
    v: _internal_constants__WEBPACK_IMPORTED_MODULE_0__.VALUE,
    w: "writable",
    g: "get",
    s: "set"
};
/**
 * @internal
 * @ignore
 * Helper to convert ObjDefinePropDescriptor into PropertyDescriptor
 * @param value - The prop descriptor to convert
 * @returns
 */
function _createProp(value) {
    var prop = {};
    prop[propMap["c"]] = true;
    prop[propMap["e"]] = true;
    if (value.l) {
        // Asign a getter function to return the value when requested
        prop.get = function () { return value.l.v; };
        // If it has a setter then expose it as well
        var desc = (0,_get_own_prop_desc__WEBPACK_IMPORTED_MODULE_1__.objGetOwnPropertyDescriptor)(value.l, "v");
        if (desc && desc.set) {
            prop.set = function (newValue) {
                value.l.v = newValue;
            };
        }
    }
    (0,_for_each_key__WEBPACK_IMPORTED_MODULE_2__.objForEachKey)(value, function (key, value) {
        prop[propMap[key]] = (0,_helpers_base__WEBPACK_IMPORTED_MODULE_3__.isUndefined)(value) ? prop[propMap[key]] : value;
    });
    return prop;
}
/**
 * Defines a new property directly on an object, or modifies an existing property on an object, and returns the object.
 * This is a wrapper for [Object.defineProperty](https://developer.mozilla.org/en-US/docs/web/javascript/reference/global_objects/object/defineproperty)
 *
 * This method allows a precise addition to or modification of a property on an object. Normal property addition through
 * assignment creates properties which show up during property enumeration (for...in loop or objKeys method), whose
 * values may be changed, and which may be deleted. This method allows these extra details to be changed from their
 * defaults. By default, properties added using objDefineProp() are not writable, not enumerable, and not configurable.
 *
 * Property descriptors present in objects come in two main flavors: data descriptors and accessor descriptors. A data
 * descriptor is a property that has a value, which may or may not be writable. An accessor descriptor is a property
 * described by a getter-setter pair of functions. A descriptor must be one of these two flavors; it cannot be both.
 *
 * This is an alias for Object.defineProperty
 * @group Object
 * @param target - The object on which to define the property.
 * @param key - The name or Symbol of the property to be defined or modified.
 * @param descriptor - The descriptor for the property being defined or modified.
 */
var objDefineProp = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass.defineProperty;
/**
 * The objDefineProperties() method defines new or modifies existing properties directly on an object, returning the object.
 * This is a wrapper for [Object.defineProperties](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/defineProperties)
 * @since 0.6.0
 * @group Object
 * @param target - The object on which to define or modify properties.
 * @param props - An object whose keys represent the names of properties to be defined or modified and whose values are
 * objects describing those properties. Each value in props must be either a data descriptor or an accessor descriptor;
 * it cannot be both (see {@link ObjDefinePropDescriptorMap} for more details).
 * @returns
 */
var objDefineProperties = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass.defineProperties;
/**
 * Try to define a get object property accessor for the target object, if a function is past as the value this will
 * be assumed to be a getter function and NOT the value.
 * @deprecated It is recommended that you use {@link objDefine} instead {@link objDefineGet} or {@link objDefineAccessors}
 * as it provides a deterministic way for identifying whether the value is a value or a function rather than wrapping any
 * function value in another function.
 * @group Object
 * @param target - The object on which to define the property.
 * @param key - The name of the property to be defined or modified
 * @param value - The value or a function that returns the value
 * @param configurable - Can the value be changed, defaults to true.
 * @param enumerable - Should this get property be enumerable, defaults to true.
 * @returns The object that was passed to the function
 */
function objDefineGet(target, key, value, configurable, enumerable) {
    var _a;
    return objDefineProp(target, key, _createProp((_a = {
            e: enumerable,
            c: configurable
        },
        _a[(0,_helpers_base__WEBPACK_IMPORTED_MODULE_3__.isFunction)(value) ? "g" : "v"] = value,
        _a)));
}
/**
 * Try to define get/set object property accessors for the target object/prototype, this will provide compatibility with
 * existing API definition when run within an ES5+ container that supports accessors but still enable the code to be loaded
 * and executed in an ES3 container, providing basic IE8 compatibility.
 * @deprecated It is recommended that you use {@link objDefine} instead {@link objDefineAccessors} as this internally creates
 * the {@link ObjDefinePropDescriptor} definition based on your provided arguments. And only using a minimum set of functions
 * reduces your overall bundle size.
 * @group Object
 * @param target - The object on which to define the property.
 * @param prop - The name of the property to be defined or modified.
 * @param getProp - The getter function to wire against the getter.
 * @param setProp - The setter function to wire against the setter.
 * @param configurable - Can the value be changed, defaults to true
 * @param enumerable - Should this get property be enumerable, defaults to true.
 * @returns The object that was passed to the function
 */
function objDefineAccessors(target, prop, getProp, setProp, configurable, enumerable) {
    var desc = {
        e: enumerable,
        c: configurable
    };
    if (getProp) {
        desc.g = getProp;
    }
    if (setProp) {
        desc.s = setProp;
    }
    return objDefineProp(target, prop, _createProp(desc));
}
/**
 * The objDefine() method defines a new or modifies an existing single property accessors for the target object based
 * on the configuration defined for the propDesc argument of type {@link ObjDefinePropDescriptor}. This will call
 * {@link objDefineProp} after creating the required PropertyDescriptor populating defaults for the propDesc values.
 * Note, the default values (true) for `configurable` and `enumerable` are different from the defaults provided by objDefineProp.
 * @since 0.6.0
 * @group Object
 * @param target - The object on which to define the property.
 * @param key - The name of the property to be defined or modified
 * @param propDesc - An object which defines the Property Descriptor mappings for the mapping.
 * @returns The target object.
 */
function objDefine(target, key, propDesc) {
    return objDefineProp(target, key, _createProp(propDesc));
}
/**
 * The objDefineProps() method defines new or modifies existing properties directly for the target object using the keys
 * and configuration from the propDescMap argument. This will call {@link objDefineProperties} after creating the required
 * PropertyDescriptorMap from the propDescMap values.
 * Note, the default values (true) for `configurable` and `enumerable` are different from the defaults provided by objDefineProperties.
 * @since 0.6.0
 * @group Object
 * @param target - The object on which to define or modify properties.
 * @param propDescMap - An object whose keys represent the names of properties to be defined or modified and whose values are
 * objects describing those properties. Each value in props must be either a data descriptor or an accessor descriptor;
 * it cannot be both (see {@link ObjDefinePropDescriptorMap} for more details).
 * @returns The target object.
 */
function objDefineProps(target, propDescMap) {
    var props = {};
    (0,_for_each_key__WEBPACK_IMPORTED_MODULE_2__.objForEachKey)(propDescMap, function (key, value) {
        props[key] = _createProp(value);
    });
    return objDefineProperties(target, props);
}
//# sourceMappingURL=define.js.map

/***/ }),
/* 90 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ dynamicProto)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(91);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(84);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(81);
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
var _a;

;
var UNDEFINED = "undefined";
/**
 * Constant string defined to support minimization
 * @ignore
 */
var Constructor = 'constructor';
/**
 * Constant string defined to support minimization
 * @ignore
 */
var Prototype = 'prototype';
/**
 * Constant string defined to support minimization
 * @ignore
 */
var strFunction = 'function';
/**
 * Used to define the name of the instance function lookup table
 * @ignore
 */
var DynInstFuncTable = '_dynInstFuncs';
/**
 * Name used to tag the dynamic prototype function
 * @ignore
 */
var DynProxyTag = '_isDynProxy';
/**
 * Name added to a prototype to define the dynamic prototype "class" name used to lookup the function table
 * @ignore
 */
var DynClassName = '_dynClass';
/**
 * Prefix added to the classname to avoid any name clashes with other instance level properties
 * @ignore
 */
var DynClassNamePrefix = '_dynCls$';
/**
 * A tag which is used to check if we have already to attempted to set the instance function if one is not present
 * @ignore
 */
var DynInstChkTag = '_dynInstChk';
/**
 * A tag which is used to check if we are allows to try and set an instance function is one is not present. Using the same
 * tag name as the function level but a different const name for readability only.
 */
var DynAllowInstChkTag = DynInstChkTag;
/**
 * The global (imported) instances where the global performance options are stored
 */
var DynProtoDefaultOptions = '_dfOpts';
/**
 * Value used as the name of a class when it cannot be determined
 * @ignore
 */
var UnknownValue = '_unknown_';
/**
 * Constant string defined to support minimization
 * @ignore
 */
var str__Proto = "__proto__";
/**
 * The polyfill version of __proto__ so that it doesn't cause issues for anyone not expecting it to exist
 */
var DynProtoBaseProto = "_dyn" + str__Proto;
/**
 * Runtime Global holder for dynamicProto settings
 */
var DynProtoGlobalSettings = "__dynProto$Gbl";
/**
 * Track the current prototype for IE8 as you can't look back to get the prototype
 */
var DynProtoCurrent = "_dynInstProto";
/**
 * Constant string defined to support minimization
 * @ignore
 */
var strUseBaseInst = 'useBaseInst';
/**
 * Constant string defined to support minimization
 * @ignore
 */
var strSetInstFuncs = 'setInstFuncs';
var Obj = Object;
/**
 * Pre-lookup to check if we are running on a modern browser (i.e. not IE8)
 * @ignore
 */
var _objGetPrototypeOf = Obj["getPrototypeOf"];
/**
 * Pre-lookup to check for the existence of this function
 */
var _objGetOwnProps = Obj["getOwnPropertyNames"];
// Since 1.1.7 moving these to the runtime global to work around mixed version and module issues
// See Issue https://github.com/microsoft/DynamicProto-JS/issues/57 for details
var _gbl = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.getGlobal)();
var _gblInst = _gbl[DynProtoGlobalSettings] || (_gbl[DynProtoGlobalSettings] = {
    o: (_a = {},
        _a[strSetInstFuncs] = true,
        _a[strUseBaseInst] = true,
        _a),
    n: 1000 // Start new global index @ 1000 so we "fix" some cases when mixed with 1.1.6 or earlier
});
/**
 * Helper used to check whether the target is an Object prototype or Array prototype
 * @ignore
 */
function _isObjectOrArrayPrototype(target) {
    return target && (target === Obj[Prototype] || target === Array[Prototype]);
}
/**
 * Helper used to check whether the target is an Object prototype, Array prototype or Function prototype
 * @ignore
 */
function _isObjectArrayOrFunctionPrototype(target) {
    return _isObjectOrArrayPrototype(target) || target === Function[Prototype];
}
/**
 * Helper used to get the prototype of the target object as getPrototypeOf is not available in an ES3 environment.
 * @ignore
 */
function _getObjProto(target) {
    var newProto;
    if (target) {
        // This method doesn't exist in older browsers (e.g. IE8)
        if (_objGetPrototypeOf) {
            return _objGetPrototypeOf(target);
        }
        var curProto = target[str__Proto] || target[Prototype] || (target[Constructor] ? target[Constructor][Prototype] : null);
        // Using the pre-calculated value as IE8 doesn't support looking up the prototype of a prototype and thus fails for more than 1 base class
        newProto = target[DynProtoBaseProto] || curProto;
        if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objHasOwnProperty)(target, DynProtoBaseProto)) {
            // As this prototype doesn't have this property then this is from an inherited class so newProto is the base to return so save it
            // so we can look it up value (which for a multiple hierarchy dynamicProto will be the base class)
            delete target[DynProtoCurrent]; // Delete any current value allocated to this instance so we pick up the value from prototype hierarchy
            newProto = target[DynProtoBaseProto] = target[DynProtoCurrent] || target[DynProtoBaseProto];
            target[DynProtoCurrent] = curProto;
        }
    }
    return newProto;
}
/**
 * Helper to get the properties of an object, including none enumerable ones as functions on a prototype in ES6
 * are not enumerable.
 * @param target
 */
function _forEachProp(target, func) {
    var props = [];
    if (_objGetOwnProps) {
        props = _objGetOwnProps(target);
    }
    else {
        for (var name_1 in target) {
            if (typeof name_1 === "string" && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objHasOwnProperty)(target, name_1)) {
                props.push(name_1);
            }
        }
    }
    if (props && props.length > 0) {
        for (var lp = 0; lp < props.length; lp++) {
            func(props[lp]);
        }
    }
}
/**
 * Helper function to check whether the provided function name is a potential candidate for dynamic
 * callback and prototype generation.
 * @param target The target object, may be a prototype or class object
 * @param funcName The function name
 * @param skipOwn Skips the check for own property
 * @ignore
 */
function _isDynamicCandidate(target, funcName, skipOwn) {
    return (funcName !== Constructor && typeof target[funcName] === strFunction && (skipOwn || (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objHasOwnProperty)(target, funcName)));
}
/**
 * Helper to throw a TypeError exception
 * @param message the message
 * @ignore
 */
function _throwTypeError(message) {
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.throwTypeError)("DynamicProto: " + message);
}
/**
 * Returns a collection of the instance functions that are defined directly on the thisTarget object, it does
 * not return any inherited functions
 * @param thisTarget The object to get the instance functions from
 * @ignore
 */
function _getInstanceFuncs(thisTarget) {
    // Get the base proto
    var instFuncs = {};
    // Save any existing instance functions
    _forEachProp(thisTarget, function (name) {
        // Don't include any dynamic prototype instances - as we only want the real functions
        if (!instFuncs[name] && _isDynamicCandidate(thisTarget, name, false)) {
            // Create an instance callback for passing the base function to the caller
            instFuncs[name] = thisTarget[name];
        }
    });
    return instFuncs;
}
/**
 * Returns whether the value is included in the array
 * @param values The array of values
 * @param value  The value
 */
function _hasVisited(values, value) {
    for (var lp = values.length - 1; lp >= 0; lp--) {
        if (values[lp] === value) {
            return true;
        }
    }
    return false;
}
/**
 * Returns an object that contains callback functions for all "base/super" functions, this is used to "save"
 * enabling calling super.xxx() functions without requiring that the base "class" has defined a prototype references
 * @param target The current instance
 * @ignore
 */
function _getBaseFuncs(classProto, thisTarget, instFuncs, useBaseInst) {
    function _instFuncProxy(target, funcHost, funcName) {
        var theFunc = funcHost[funcName];
        if (theFunc[DynProxyTag] && useBaseInst) {
            // grab and reuse the hosted looking function (if available) otherwise the original passed function
            var instFuncTable = target[DynInstFuncTable] || {};
            if (instFuncTable[DynAllowInstChkTag] !== false) {
                theFunc = (instFuncTable[funcHost[DynClassName]] || {})[funcName] || theFunc;
            }
        }
        return function () {
            // eslint-disable-next-line prefer-rest-params
            return theFunc.apply(target, arguments);
        };
    }
    // Start creating a new baseFuncs by creating proxies for the instance functions (as they may get replaced)
    var baseFuncs = {};
    _forEachProp(instFuncs, function (name) {
        // Create an instance callback for passing the base function to the caller
        baseFuncs[name] = _instFuncProxy(thisTarget, instFuncs, name);
    });
    // Get the base prototype functions
    var baseProto = _getObjProto(classProto);
    var visited = [];
    // Don't include base object functions for Object, Array or Function
    while (baseProto && !_isObjectArrayOrFunctionPrototype(baseProto) && !_hasVisited(visited, baseProto)) {
        // look for prototype functions
        _forEachProp(baseProto, function (name) {
            // Don't include any dynamic prototype instances - as we only want the real functions
            // For IE 7/8 the prototype lookup doesn't provide the full chain so we need to bypass the 
            // hasOwnProperty check we get all of the methods, main difference is that IE7/8 doesn't return
            // the Object prototype methods while bypassing the check
            if (!baseFuncs[name] && _isDynamicCandidate(baseProto, name, !_objGetPrototypeOf)) {
                // Create an instance callback for passing the base function to the caller
                baseFuncs[name] = _instFuncProxy(thisTarget, baseProto, name);
            }
        });
        // We need to find all possible functions that might be overloaded by walking the entire prototype chain
        // This avoids the caller from needing to check whether it's direct base class implements the function or not
        // by walking the entire chain it simplifies the usage and issues from upgrading any of the base classes.
        visited.push(baseProto);
        baseProto = _getObjProto(baseProto);
    }
    return baseFuncs;
}
function _getInstFunc(target, funcName, proto, currentDynProtoProxy) {
    var instFunc = null;
    // We need to check whether the class name is defined directly on this prototype otherwise
    // it will walk the proto chain and return any parent proto classname.
    if (target && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objHasOwnProperty)(proto, DynClassName)) {
        var instFuncTable = target[DynInstFuncTable] || {};
        instFunc = (instFuncTable[proto[DynClassName]] || {})[funcName];
        if (!instFunc) {
            // Avoid stack overflow from recursive calling the same function
            _throwTypeError("Missing [" + funcName + "] " + strFunction);
        }
        // We have the instance function, lets check it we can speed up further calls
        // by adding the instance function back directly on the instance (avoiding the dynamic func lookup)
        if (!instFunc[DynInstChkTag] && instFuncTable[DynAllowInstChkTag] !== false) {
            // If the instance already has an instance function we can't replace it
            var canAddInst = !(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objHasOwnProperty)(target, funcName);
            // Get current prototype
            var objProto = _getObjProto(target);
            var visited = [];
            // Lookup the function starting at the top (instance level prototype) and traverse down, if the first matching function
            // if nothing is found or if the first hit is a dynamic proto instance then we can safely add an instance shortcut
            while (canAddInst && objProto && !_isObjectArrayOrFunctionPrototype(objProto) && !_hasVisited(visited, objProto)) {
                var protoFunc = objProto[funcName];
                if (protoFunc) {
                    canAddInst = (protoFunc === currentDynProtoProxy);
                    break;
                }
                // We need to find all possible initial functions to ensure that we don't bypass a valid override function
                visited.push(objProto);
                objProto = _getObjProto(objProto);
            }
            try {
                if (canAddInst) {
                    // This instance doesn't have an instance func and the class hierarchy does have a higher level prototype version
                    // so it's safe to directly assign for any subsequent calls (for better performance)
                    target[funcName] = instFunc;
                }
                // Block further attempts to set the instance function for any
                instFunc[DynInstChkTag] = 1;
            }
            catch (e) {
                // Don't crash if the object is readonly or the runtime doesn't allow changing this
                // And set a flag so we don't try again for any function
                instFuncTable[DynAllowInstChkTag] = false;
            }
        }
    }
    return instFunc;
}
function _getProtoFunc(funcName, proto, currentDynProtoProxy) {
    var protoFunc = proto[funcName];
    // Check that the prototype function is not a self reference -- try to avoid stack overflow!
    if (protoFunc === currentDynProtoProxy) {
        // It is so lookup the base prototype
        protoFunc = _getObjProto(proto)[funcName];
    }
    if (typeof protoFunc !== strFunction) {
        _throwTypeError("[" + funcName + "] is not a " + strFunction);
    }
    return protoFunc;
}
/**
 * Add the required dynamic prototype methods to the the class prototype
 * @param proto - The class prototype
 * @param className - The instance classname
 * @param target - The target instance
 * @param baseInstFuncs - The base instance functions
 * @param setInstanceFunc - Flag to allow prototype function to reset the instance function if one does not exist
 * @ignore
 */
function _populatePrototype(proto, className, target, baseInstFuncs, setInstanceFunc) {
    function _createDynamicPrototype(proto, funcName) {
        var dynProtoProxy = function () {
            // Use the instance or prototype function
            var instFunc = _getInstFunc(this, funcName, proto, dynProtoProxy) || _getProtoFunc(funcName, proto, dynProtoProxy);
            // eslint-disable-next-line prefer-rest-params
            return instFunc.apply(this, arguments);
        };
        // Tag this function as a proxy to support replacing dynamic proxy elements (primary use case is for unit testing
        // via which can dynamically replace the prototype function reference)
        dynProtoProxy[DynProxyTag] = 1;
        return dynProtoProxy;
    }
    if (!_isObjectOrArrayPrototype(proto)) {
        var instFuncTable = target[DynInstFuncTable] = target[DynInstFuncTable] || {};
        var instFuncs_1 = instFuncTable[className] = (instFuncTable[className] || {}); // fetch and assign if as it may not exist yet
        // Set whether we are allow to lookup instances, if someone has set to false then do not re-enable
        if (instFuncTable[DynAllowInstChkTag] !== false) {
            instFuncTable[DynAllowInstChkTag] = !!setInstanceFunc;
        }
        _forEachProp(target, function (name) {
            // Only add overridden functions
            if (_isDynamicCandidate(target, name, false) && target[name] !== baseInstFuncs[name]) {
                // Save the instance Function to the lookup table and remove it from the instance as it's not a dynamic proto function
                instFuncs_1[name] = target[name];
                delete target[name];
                // Add a dynamic proto if one doesn't exist or if a prototype function exists and it's not a dynamic one
                if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objHasOwnProperty)(proto, name) || (proto[name] && !proto[name][DynProxyTag])) {
                    proto[name] = _createDynamicPrototype(proto, name);
                }
            }
        });
    }
}
/**
 * Checks whether the passed prototype object appears to be correct by walking the prototype hierarchy of the instance
 * @param classProto The class prototype instance
 * @param thisTarget The current instance that will be checked whether the passed prototype instance is in the hierarchy
 * @ignore
 */
function _checkPrototype(classProto, thisTarget) {
    // This method doesn't existing in older browsers (e.g. IE8)
    if (_objGetPrototypeOf) {
        // As this is primarily a coding time check, don't bother checking if running in IE8 or lower
        var visited = [];
        var thisProto = _getObjProto(thisTarget);
        while (thisProto && !_isObjectArrayOrFunctionPrototype(thisProto) && !_hasVisited(visited, thisProto)) {
            if (thisProto === classProto) {
                return true;
            }
            // This avoids the caller from needing to check whether it's direct base class implements the function or not
            // by walking the entire chain it simplifies the usage and issues from upgrading any of the base classes.
            visited.push(thisProto);
            thisProto = _getObjProto(thisProto);
        }
        return false;
    }
    // If objGetPrototypeOf doesn't exist then just assume everything is ok.
    return true;
}
/**
 * Gets the current prototype name using the ES6 name if available otherwise falling back to a use unknown as the name.
 * It's not critical for this to return a name, it's used to decorate the generated unique name for easier debugging only.
 * @param target
 * @param unknownValue
 * @ignore
 */
function _getObjName(target, unknownValue) {
    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objHasOwnProperty)(target, Prototype)) {
        // Look like a prototype
        return target.name || unknownValue || UnknownValue;
    }
    return (((target || {})[Constructor]) || {}).name || unknownValue || UnknownValue;
}
/**
 * Helper function when creating dynamic (inline) functions for classes, this helper performs the following tasks :-
 * - Saves references to all defined base class functions
 * - Calls the delegateFunc with the current target (this) and a base object reference that can be used to call all "super" functions.
 * - Will populate the class prototype for all overridden functions to support class extension that call the prototype instance.
 * Callers should use this helper when declaring all function within the constructor of a class, as mentioned above the delegateFunc is
 * passed both the target "this" and an object that can be used to call any base (super) functions, using this based object in place of
 * super.XXX() (which gets expanded to _super.prototype.XXX()) provides a better minification outcome and also ensures the correct "this"
 * context is maintained as TypeScript creates incorrect references using super.XXXX() for dynamically defined functions i.e. Functions
 * defined in the constructor or some other function (rather than declared as complete typescript functions).
 * ### Usage
 * ```typescript
 * import dynamicProto from "@microsoft/dynamicproto-js";
 * class ExampleClass extends BaseClass {
 *     constructor() {
 *         dynamicProto(ExampleClass, this, (_self, base) => {
 *             // This will define a function that will be converted to a prototype function
 *             _self.newFunc = () => {
 *                 // Access any "this" instance property
 *                 if (_self.someProperty) {
 *                     ...
 *                 }
 *             }
 *             // This will define a function that will be converted to a prototype function
 *             _self.myFunction = () => {
 *                 // Access any "this" instance property
 *                 if (_self.someProperty) {
 *                     // Call the base version of the function that we are overriding
 *                     base.myFunction();
 *                 }
 *                 ...
 *             }
 *             _self.initialize = () => {
 *                 ...
 *             }
 *             // Warnings: While the following will work as _self is simply a reference to
 *             // this, if anyone overrides myFunction() the overridden will be called first
 *             // as the normal JavaScript method resolution will occur and the defined
 *             // _self.initialize() function is actually gets removed from the instance and
 *             // a proxy prototype version is created to reference the created method.
 *             _self.initialize();
 *         });
 *     }
 * }
 * ```
 * @typeparam DPType This is the generic type of the class, used to keep intellisense valid
 * @typeparam DPCls The type that contains the prototype of the current class
 * @param theClass - This is the current class instance which contains the prototype for the current class
 * @param target - The current "this" (target) reference, when the class has been extended this.prototype will not be the 'theClass' value.
 * @param delegateFunc - The callback function (closure) that will create the dynamic function
 * @param options - Additional options to configure how the dynamic prototype operates
 */
function dynamicProto(theClass, target, delegateFunc, options) {
    // Make sure that the passed theClass argument looks correct
    if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objHasOwnProperty)(theClass, Prototype)) {
        _throwTypeError("theClass is an invalid class definition.");
    }
    // Quick check to make sure that the passed theClass argument looks correct (this is a common copy/paste error)
    var classProto = theClass[Prototype];
    if (!_checkPrototype(classProto, target)) {
        _throwTypeError("[" + _getObjName(theClass) + "] not in hierarchy of [" + _getObjName(target) + "]");
    }
    var className = null;
    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objHasOwnProperty)(classProto, DynClassName)) {
        // Only grab the class name if it's defined on this prototype (i.e. don't walk the prototype chain)
        className = classProto[DynClassName];
    }
    else {
        // As not all browser support name on the prototype creating a unique dynamic one if we have not already
        // assigned one, so we can use a simple string as the lookup rather than an object for the dynamic instance
        // function table lookup.
        className = DynClassNamePrefix + _getObjName(theClass, "_") + "$" + _gblInst.n;
        _gblInst.n++;
        classProto[DynClassName] = className;
    }
    var perfOptions = dynamicProto[DynProtoDefaultOptions];
    var useBaseInst = !!perfOptions[strUseBaseInst];
    if (useBaseInst && options && options[strUseBaseInst] !== undefined) {
        useBaseInst = !!options[strUseBaseInst];
    }
    // Get the current instance functions
    var instFuncs = _getInstanceFuncs(target);
    // Get all of the functions for any base instance (before they are potentially overridden)
    var baseFuncs = _getBaseFuncs(classProto, target, instFuncs, useBaseInst);
    // Execute the delegate passing in both the current target "this" and "base" function references
    // Note casting the same type as we don't actually have the base class here and this will provide some intellisense support
    delegateFunc(target, baseFuncs);
    // Don't allow setting instance functions for older IE instances
    var setInstanceFunc = !!_objGetPrototypeOf && !!perfOptions[strSetInstFuncs];
    if (setInstanceFunc && options) {
        setInstanceFunc = !!options[strSetInstFuncs];
    }
    // Populate the Prototype for any overridden instance functions
    _populatePrototype(classProto, className, target, instFuncs, setInstanceFunc !== false);
}
/**
 * Exposes the default global options to allow global configuration, if the global values are disabled these will override
 * any passed values. This is primarily exposed to support unit-testing without the need for individual classes to expose
 * their internal usage of dynamic proto.
 */
dynamicProto[DynProtoDefaultOptions] = _gblInst.o;
//# sourceMappingURL=DynamicProto.js.map

/***/ }),
/* 91 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getDocument": () => (/* binding */ getDocument),
/* harmony export */   "getGlobal": () => (/* binding */ getGlobal),
/* harmony export */   "getHistory": () => (/* binding */ getHistory),
/* harmony export */   "getInst": () => (/* binding */ getInst),
/* harmony export */   "getNavigator": () => (/* binding */ getNavigator),
/* harmony export */   "getWindow": () => (/* binding */ getWindow),
/* harmony export */   "hasDocument": () => (/* binding */ hasDocument),
/* harmony export */   "hasHistory": () => (/* binding */ hasHistory),
/* harmony export */   "hasNavigator": () => (/* binding */ hasNavigator),
/* harmony export */   "hasWindow": () => (/* binding */ hasWindow),
/* harmony export */   "isNode": () => (/* binding */ isNode),
/* harmony export */   "isWebWorker": () => (/* binding */ isWebWorker),
/* harmony export */   "lazySafeGetInst": () => (/* binding */ lazySafeGetInst)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(74);
/* harmony import */ var _internal_global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(94);
/* harmony import */ var _safe_lazy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(92);
/* harmony import */ var _lazy__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(93);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */




var WINDOW = "window";
var _cachedGlobal;
var _cachedWindow;
var _cachedDocument;
var _cachedNavigator;
var _cachedHistory;
var _isWebWorker;
var _isNode;
/**
 * Create and return an readonly {@link ILazyValue} instance which will cache and return the named global
 * value if available, will return `null` if the named global object is not available or if the runtime
 * throws an exception when attempting to access the global object.
 * Unlike {@link getInst} the value is cached after the first access, so if the global value changes after
 * the initial fetch the original cached value is still returned.
 * @since 0.9.5
 * @group Environment
 * @group Lazy
 * @group Safe
 * @param name The name of the global object to get.
 * @returns A new readonly {@link ILazyValue} instance which will lazily attempt to return the globally
 * available named instance.
 * @example
 * ```ts
 * // This does not cause the evaluation to occur
 * window.myGlobal = "Hello";
 * let cachedValue = lazySafeGetInst("myGlobal");
 * // cachedValue.v === "Hello"
 *
 * window.myGlobal = "Darkness";
 * // cachedValue.v === "Hello"
 *
 * let promiseCls = lazySafeGetInst("Promise");
 * // null if Promise is not supported in the runtime
 * // otherwise the Promise class.
 * ```
 */
var lazySafeGetInst = function (name) { return (0,_safe_lazy__WEBPACK_IMPORTED_MODULE_0__.safeGetLazy)(function () { return getInst(name) || _internal_constants__WEBPACK_IMPORTED_MODULE_1__.UNDEF_VALUE; }, _internal_constants__WEBPACK_IMPORTED_MODULE_1__.UNDEF_VALUE); };
/**
 * Returns the current global scope object, for a normal web page this will be the current
 * window, for a Web Worker this will be current worker global scope via "self". The internal
 * implementation returns the first available instance object in the following order
 * - globalThis (New standard)
 * - self (Will return the current window instance for supported browsers)
 * - window (fallback for older browser implementations)
 * - global (NodeJS standard)
 * - <null> (When all else fails)
 * While the return type is a Window for the normal case, not all environments will support all
 * of the properties or functions. And this caches the lookup of the global as in some environments
 * this can be an expensive operation.
 * @group Environment
 * @param useCached - [Optional] used for testing to bypass the cached lookup, when `true` this will
 * cause the cached global to be reset.
 */
var getGlobal = function (useCached) {
    (!_cachedGlobal || useCached === false || (_lazy__WEBPACK_IMPORTED_MODULE_2__._globalLazyTestHooks && _lazy__WEBPACK_IMPORTED_MODULE_2__._globalLazyTestHooks.lzy && !_cachedGlobal.b)) && (_cachedGlobal = (0,_safe_lazy__WEBPACK_IMPORTED_MODULE_0__.safeGetLazy)(_internal_global__WEBPACK_IMPORTED_MODULE_3__._getGlobalValue, _internal_constants__WEBPACK_IMPORTED_MODULE_1__.NULL_VALUE));
    return _cachedGlobal.v;
};
/**
 * Return the named global object if available, will return null if the object is not available.
 * @group Environment
 * @param name The globally named object
 * @param useCached - [Optional] used for testing to bypass the cached lookup, when `true` this will
 * cause the cached global to be reset.
 * @example
 * ```ts
 * // This does not cause the evaluation to occur
 * window.myGlobal = "Hello";
 * let cachedValue = getInst("myGlobal");
 * // cachedValue === "Hello"
 *
 * window.myGlobal = "Darkness";
 * // getInst("myGlobal") === "Darkness"
 *
 * let promiseCls = getInst("Promise");
 * // May throw if the global is not supported by the runtime
 * // otherwise the Promise class.
 * ```
 */
var getInst = function (name, useCached) {
    var gbl = (!_cachedGlobal || useCached === false) ? getGlobal(useCached) : _cachedGlobal.v;
    if (gbl && gbl[name]) {
        return gbl[name];
    }
    // Test workaround, for environments where <global>.window (when global == window) doesn't return the base window
    if (name === WINDOW && _cachedWindow) {
        // tslint:disable-next-line: no-angle-bracket-type-assertion
        return _cachedWindow.v;
    }
    return _internal_constants__WEBPACK_IMPORTED_MODULE_1__.NULL_VALUE;
};
/**
 * Identify whether the runtime contains a `document` object
 * @group Environment
 * @returns - True if a `document` exists
 */
var hasDocument = function () { return !!getDocument(); };
/**
 * Return the global `document` instance.
 * @group Environment
 * @returns
 */
var getDocument = function () {
    (!_cachedDocument || (_lazy__WEBPACK_IMPORTED_MODULE_2__._globalLazyTestHooks && _lazy__WEBPACK_IMPORTED_MODULE_2__._globalLazyTestHooks.lzy && !_cachedDocument.b)) && (_cachedDocument = lazySafeGetInst("document"));
    return _cachedDocument.v;
};
/**
 * Identify whether the runtime contains a `window` object
 * @group Environment
 * @returns
 */
var hasWindow = function () { return !!getWindow(); };
/**
 * Return the global `window` instance.
 * @group Environment
 * @returns
 */
var getWindow = function () {
    (!_cachedWindow || (_lazy__WEBPACK_IMPORTED_MODULE_2__._globalLazyTestHooks && _lazy__WEBPACK_IMPORTED_MODULE_2__._globalLazyTestHooks.lzy && !_cachedWindow.b)) && (_cachedWindow = lazySafeGetInst(WINDOW));
    return _cachedWindow.v;
};
/**
 * Identify whether the runtimne contains a `navigator` object
 * @group Environment
 * @returns
 */
var hasNavigator = function () { return !!getNavigator(); };
/**
 * Returns the global `navigator` instance
 * @group Environment
 * @returns
 */
var getNavigator = function () {
    (!_cachedNavigator || (_lazy__WEBPACK_IMPORTED_MODULE_2__._globalLazyTestHooks && _lazy__WEBPACK_IMPORTED_MODULE_2__._globalLazyTestHooks.lzy && !_cachedNavigator.b)) && (_cachedNavigator = lazySafeGetInst("navigator"));
    return _cachedNavigator.v;
};
/**
 * Identifies whether the runtime contains a `history` object
 * @group Environment
 * @returns
 */
var hasHistory = function () { return !!getHistory(); };
/**
 * Returns the global `history` instance
 * @group Environment
 * @returns
 */
var getHistory = function () {
    (!_cachedHistory || (_lazy__WEBPACK_IMPORTED_MODULE_2__._globalLazyTestHooks && _lazy__WEBPACK_IMPORTED_MODULE_2__._globalLazyTestHooks.lzy