/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.text.edits.TextEditGroup;

public class ValueOfRatherThanInstantiationFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit) {
        ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations = new ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation>();
        ValueOfRatherThanInstantiationFinder finder = new ValueOfRatherThanInstantiationFinder(operations);
        compilationUnit.accept((ASTVisitor)finder);
        if (operations.isEmpty()) {
            return null;
        }
        CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] ops = operations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]);
        return new ValueOfRatherThanInstantiationFixCore(FixMessages.ValueOfRatherThanInstantiationFix_description, compilationUnit, ops);
    }

    protected ValueOfRatherThanInstantiationFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    public static final class ValueOfRatherThanInstantiationFinder
    extends ASTVisitor {
        private List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> fResult;

        public ValueOfRatherThanInstantiationFinder(List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> ops) {
            this.fResult = ops;
        }

        public boolean visit(ClassInstanceCreation visited) {
            ITypeBinding typeBinding = visited.getType().resolveBinding();
            List args = visited.arguments();
            if (args.size() == 1) {
                Expression arg0 = (Expression)args.get(0);
                if (ASTNodes.hasType(typeBinding, Float.class.getCanonicalName())) {
                    if (ASTNodes.hasType(arg0, Double.TYPE.getSimpleName())) {
                        this.fResult.add(new ValueOfRatherThanInstantiationFloatWithValueOfFixOperation(visited, typeBinding, arg0));
                        return false;
                    }
                    if (ASTNodes.hasType(arg0, Double.class.getCanonicalName())) {
                        this.fResult.add(new ValueOfRatherThanInstantiationFloatWithFloatValueFixOperation(visited, arg0));
                        return false;
                    }
                }
                if (ASTNodes.hasType(typeBinding, Boolean.class.getCanonicalName(), Integer.class.getCanonicalName(), Long.class.getCanonicalName(), Double.class.getCanonicalName(), Short.class.getCanonicalName(), Float.class.getCanonicalName(), Byte.class.getCanonicalName(), Character.class.getCanonicalName())) {
                    ITypeBinding destinationTypeBinding = ASTNodes.getTargetType((Expression)visited);
                    if (destinationTypeBinding != null && destinationTypeBinding.isPrimitive() && !ASTNodes.hasType(arg0, String.class.getCanonicalName())) {
                        this.fResult.add(new ValueOfRatherThanInstantiationWithTheSingleArgumentFixOperation(visited));
                        return false;
                    }
                    if (JavaModelUtil.is50OrHigher(((CompilationUnit)visited.getRoot()).getJavaElement().getJavaProject()) || ASTNodes.hasType(typeBinding, String.class.getCanonicalName())) {
                        this.fResult.add(new ValueOfRatherThanInstantiationWithValueOfFixOperation(visited, typeBinding, arg0));
                        return false;
                    }
                }
            }
            return true;
        }
    }

    public static class ValueOfRatherThanInstantiationFloatWithFloatValueFixOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final ClassInstanceCreation visited;
        private final Expression arg0;

        public ValueOfRatherThanInstantiationFloatWithFloatValueFixOperation(ClassInstanceCreation visited, Expression arg0) {
            this.visited = visited;
            this.arg0 = arg0;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.ValueOfRatherThanInstantiationCleanup_description_float_with_float_value, cuRewrite);
            rewrite.setTargetSourceRangeComputer(new TargetSourceRangeComputer(){

                public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode nodeWithComment) {
                    if (Boolean.TRUE.equals(nodeWithComment.getProperty("untouchComment"))) {
                        return new TargetSourceRangeComputer.SourceRange(nodeWithComment.getStartPosition(), nodeWithComment.getLength());
                    }
                    return super.computeSourceRange(nodeWithComment);
                }
            });
            MethodInvocation floatValueMethod = ast.newMethodInvocation();
            floatValueMethod.setExpression(ASTNodes.createMoveTarget(rewrite, this.arg0));
            floatValueMethod.setName(ast.newSimpleName("floatValue"));
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.visited, (ASTNode)floatValueMethod, group);
        }
    }

    public static class ValueOfRatherThanInstantiationFloatWithValueOfFixOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final ClassInstanceCreation visited;
        private final ITypeBinding typeBinding;
        private final Expression arg0;

        public ValueOfRatherThanInstantiationFloatWithValueOfFixOperation(ClassInstanceCreation visited, ITypeBinding typeBinding, Expression arg0) {
            this.visited = visited;
            this.typeBinding = typeBinding;
            this.arg0 = arg0;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.ValueOfRatherThanInstantiationCleanup_description_float_with_valueof, cuRewrite);
            rewrite.setTargetSourceRangeComputer(new TargetSourceRangeComputer(){

                public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode nodeWithComment) {
                    if (Boolean.TRUE.equals(nodeWithComment.getProperty("untouchComment"))) {
                        return new TargetSourceRangeComputer.SourceRange(nodeWithComment.getStartPosition(), nodeWithComment.getLength());
                    }
                    return super.computeSourceRange(nodeWithComment);
                }
            });
            MethodInvocation valueOfMethod = ast.newMethodInvocation();
            valueOfMethod.setExpression((Expression)ASTNodeFactory.newName(ast, this.typeBinding.getName()));
            valueOfMethod.setName(ast.newSimpleName("valueOf"));
            Expression newArgument = this.arg0;
            while (true) {
                if (newArgument instanceof CastExpression) {
                    newArgument = ((CastExpression)newArgument).getExpression();
                    continue;
                }
                if (!(newArgument instanceof ParenthesizedExpression)) break;
                newArgument = ((ParenthesizedExpression)newArgument).getExpression();
            }
            if (!ASTNodes.hasType(newArgument, Float.TYPE.getSimpleName())) {
                CastExpression newCastExpression = ast.newCastExpression();
                newCastExpression.setType((Type)ast.newPrimitiveType(PrimitiveType.FLOAT));
                Expression moveTarget = ASTNodes.createMoveTarget(rewrite, newArgument);
                if (newArgument.getNodeType() == 27 || newArgument.getNodeType() == 7) {
                    ParenthesizedExpression parens = ast.newParenthesizedExpression();
                    parens.setExpression(moveTarget);
                    moveTarget = parens;
                }
                newCastExpression.setExpression(moveTarget);
                newArgument = newCastExpression;
            }
            valueOfMethod.arguments().add(newArgument);
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.visited, (ASTNode)valueOfMethod, group);
        }
    }

    public static class ValueOfRatherThanInstantiationWithTheSingleArgumentFixOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final ClassInstanceCreation visited;

        public ValueOfRatherThanInstantiationWithTheSingleArgumentFixOperation(ClassInstanceCreation visited) {
            this.visited = visited;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.ValueOfRatherThanInstantiationCleanup_description_single_argument, cuRewrite);
            rewrite.setTargetSourceRangeComputer(new TargetSourceRangeComputer(){

                public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode nodeWithComment) {
                    if (Boolean.TRUE.equals(nodeWithComment.getProperty("untouchComment"))) {
                        return new TargetSourceRangeComputer.SourceRange(nodeWithComment.getStartPosition(), nodeWithComment.getLength());
                    }
                    return super.computeSourceRange(nodeWithComment);
                }
            });
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.visited, (ASTNode)ASTNodes.createMoveTarget(rewrite, (Expression)this.visited.arguments().get(0)), group);
        }
    }

    public static class ValueOfRatherThanInstantiationWithValueOfFixOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final ClassInstanceCreation visited;
        private final ITypeBinding typeBinding;
        private final Expression arg0;

        public ValueOfRatherThanInstantiationWithValueOfFixOperation(ClassInstanceCreation visited, ITypeBinding typeBinding, Expression arg0) {
            this.visited = visited;
            this.typeBinding = typeBinding;
            this.arg0 = arg0;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.ValueOfRatherThanInstantiationCleanup_description_valueof, cuRewrite);
            rewrite.setTargetSourceRangeComputer(new TargetSourceRangeComputer(){

                public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode nodeWithComment) {
                    if (Boolean.TRUE.equals(nodeWithComment.getProperty("untouchComment"))) {
                        return new TargetSourceRangeComputer.SourceRange(nodeWithComment.getStartPosition(), nodeWithComment.getLength());
                    }
                    return super.computeSourceRange(nodeWithComment);
                }
            });
            MethodInvocation valueOfMethod = ast.newMethodInvocation();
            valueOfMethod.setExpression((Expression)ASTNodeFactory.newName(ast, this.typeBinding.getName()));
            valueOfMethod.setName(ast.newSimpleName("valueOf"));
            valueOfMethod.arguments().add(ASTNodes.createMoveTarget(rewrite, ASTNodes.getUnparenthesedExpression(this.arg0)));
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.visited, (ASTNode)valueOfMethod, group);
        }
    }
}

