/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSLine;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;

public class ConvertToMessageFormatFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public ConvertToMessageFormatFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation operation) {
        super(name, compilationUnit, operation);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ConvertToMessageFormatFixCore createConvertToMessageFormatFix(CompilationUnit compilationUnit, ASTNode node) {
        BodyDeclaration parentDecl = ASTResolving.findParentBodyDeclaration(node);
        if (!(parentDecl instanceof MethodDeclaration) && !(parentDecl instanceof Initializer)) {
            return null;
        }
        AST ast = node.getAST();
        ITypeBinding stringBinding = ast.resolveWellKnownType("java.lang.String");
        if (node instanceof Expression && !(node instanceof InfixExpression)) {
            node = node.getParent();
        }
        if (node instanceof VariableDeclarationFragment) {
            node = ((VariableDeclarationFragment)node).getInitializer();
        } else if (node instanceof Assignment) {
            node = ((Assignment)node).getRightHandSide();
        }
        InfixExpression oldInfixExpression = null;
        while (node instanceof InfixExpression) {
            InfixExpression curr = (InfixExpression)node;
            if (curr.resolveTypeBinding() != stringBinding || curr.getOperator() != InfixExpression.Operator.PLUS) break;
            oldInfixExpression = curr;
            node = node.getParent();
        }
        if (oldInfixExpression == null) {
            return null;
        }
        boolean is50OrHigher = JavaModelUtil.is50OrHigher(compilationUnit.getTypeRoot().getJavaProject());
        ArrayList<Expression> operands = new ArrayList<Expression>();
        ConvertToMessageFormatFixCore.collectInfixPlusOperands((Expression)oldInfixExpression, operands);
        boolean foundNoneLiteralOperand = false;
        boolean seenTag = false;
        boolean seenNoTag = false;
        block3: for (Expression operand : operands) {
            if (!(operand instanceof StringLiteral)) {
                ITypeBinding binding;
                if (!is50OrHigher && (binding = operand.resolveTypeBinding()) == null) {
                    return null;
                }
                foundNoneLiteralOperand = true;
                continue;
            }
            ICompilationUnit cu = (ICompilationUnit)compilationUnit.getJavaElement();
            try {
                NLSLine nlsLine = NLSUtil.scanCurrentLine(cu, operand.getStartPosition());
                if (nlsLine == null) continue;
                NLSElement[] nLSElementArray = nlsLine.getElements();
                int n = nLSElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    NLSElement element = nLSElementArray[n2];
                    if (element.getPosition().getOffset() == operand.getStartPosition()) {
                        if (element.hasTag()) {
                            if (seenNoTag) {
                                return null;
                            }
                            seenTag = true;
                            continue block3;
                        }
                        if (seenTag) {
                            return null;
                        }
                        seenNoTag = true;
                        continue block3;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                return null;
            }
        }
        if (!foundNoneLiteralOperand) {
            return null;
        }
        return new ConvertToMessageFormatFixCore(CorrectionMessages.QuickAssistProcessor_convert_to_message_format, compilationUnit, new ConvertToMessageFormatProposalOperation(oldInfixExpression));
    }

    private static void collectInfixPlusOperands(Expression expression, List<Expression> collector) {
        if (expression instanceof InfixExpression && ((InfixExpression)expression).getOperator() == InfixExpression.Operator.PLUS) {
            InfixExpression infixExpression = (InfixExpression)expression;
            ConvertToMessageFormatFixCore.collectInfixPlusOperands(infixExpression.getLeftOperand(), collector);
            ConvertToMessageFormatFixCore.collectInfixPlusOperands(infixExpression.getRightOperand(), collector);
            List extendedOperands = infixExpression.extendedOperands();
            for (Expression expression2 : extendedOperands) {
                ConvertToMessageFormatFixCore.collectInfixPlusOperands(expression2, collector);
            }
        } else {
            collector.add(expression);
        }
    }

    private static class ConvertToMessageFormatProposalOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private InfixExpression infixExpression;

        public ConvertToMessageFormatProposalOperation(InfixExpression infixExpression) {
            this.infixExpression = infixExpression;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ICompilationUnit cu = cuRewrite.getCu();
            boolean is50OrHigher = JavaModelUtil.is50OrHigher(cu.getJavaProject());
            AST fAst = cuRewrite.getAST();
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            CompilationUnit root = cuRewrite.getRoot();
            String cuContents = cuRewrite.getCu().getBuffer().getContents();
            ImportRewrite importRewrite = cuRewrite.getImportRewrite();
            ContextSensitiveImportRewriteContext importContext = new ContextSensitiveImportRewriteContext(root, this.infixExpression.getStartPosition(), importRewrite);
            ArrayList<Expression> operands = new ArrayList<Expression>();
            ConvertToMessageFormatFixCore.collectInfixPlusOperands((Expression)this.infixExpression, operands);
            ArrayList<String> formatArguments = new ArrayList<String>();
            StringBuilder formatString = new StringBuilder();
            int i = 0;
            int tagsCount = 0;
            for (Expression operand : operands) {
                Object argument;
                if (operand instanceof StringLiteral) {
                    NLSLine nlsLine = NLSUtil.scanCurrentLine(cu, operand.getStartPosition());
                    if (nlsLine != null) {
                        NLSElement[] nLSElementArray = nlsLine.getElements();
                        int n = nLSElementArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            NLSElement element = nLSElementArray[n2];
                            if (element.getPosition().getOffset() == operand.getStartPosition() && element.hasTag()) {
                                ++tagsCount;
                            }
                            ++n2;
                        }
                    }
                    String value = ((StringLiteral)operand).getEscapedValue();
                    value = value.substring(1, value.length() - 1);
                    value = value.replace("'", "''");
                    formatString.append(value);
                    continue;
                }
                formatString.append("{").append(i).append("}");
                if (is50OrHigher) {
                    int origStart = root.getExtendedStartPosition((ASTNode)operand);
                    int origLength = root.getExtendedLength((ASTNode)operand);
                    argument = cuContents.substring(origStart, origStart + origLength);
                } else {
                    ITypeBinding boxedBinding;
                    ITypeBinding binding = operand.resolveTypeBinding();
                    int origStart = root.getExtendedStartPosition((ASTNode)operand);
                    int origLength = root.getExtendedLength((ASTNode)operand);
                    argument = cuContents.substring(origStart, origStart + origLength);
                    if (binding.isPrimitive() && (boxedBinding = Bindings.getBoxedTypeBinding(binding, fAst)) != binding) {
                        importRewrite.addImport(boxedBinding, fAst, (ImportRewrite.ImportRewriteContext)importContext);
                        String cic = "new " + boxedBinding.getName() + "(" + (String)argument + ")";
                        argument = cic;
                    }
                }
                formatArguments.add((String)argument);
                ++i;
            }
            importRewrite.addImport("java.text.MessageFormat", (ImportRewrite.ImportRewriteContext)importContext);
            StringBuilder buffer = new StringBuilder();
            buffer.append("MessageFormat.format(");
            buffer.append("\"" + formatString.toString().replaceAll("\"", "\\\"") + "\"");
            if (is50OrHigher) {
                for (String formatArgument : formatArguments) {
                    buffer.append(", " + formatArgument);
                }
            } else {
                buffer.append(", new Object[]{");
                if (formatArguments.size() > 0) {
                    buffer.append((String)formatArguments.get(0));
                }
                int i1 = 1;
                while (i1 < formatArguments.size()) {
                    buffer.append(", " + (String)formatArguments.get(i1));
                    ++i1;
                }
                buffer.append("}");
            }
            buffer.append(")");
            if (tagsCount > 1) {
                ASTNodes.replaceAndRemoveNLSByCount(rewrite, (ASTNode)this.infixExpression, buffer.toString(), tagsCount - 1, null, cuRewrite);
            } else {
                MethodInvocation formatInvocation = (MethodInvocation)rewrite.createStringPlaceholder(buffer.toString(), 32);
                rewrite.replace((ASTNode)this.infixExpression, (ASTNode)formatInvocation, null);
            }
        }
    }
}

