/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.cleanup.CleanUpRegistry;
import org.eclipse.jdt.ls.core.internal.commands.OrganizeImportsCommand;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WillSaveTextDocumentParams;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.osgi.service.prefs.BackingStoreException;

public class SaveActionHandler {
    private PreferenceManager preferenceManager;
    private OrganizeImportsCommand organizeImportsCommand;
    private CleanUpRegistry cleanUpRegistry;

    public SaveActionHandler(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
        this.organizeImportsCommand = new OrganizeImportsCommand();
        this.cleanUpRegistry = new CleanUpRegistry();
    }

    public List<TextEdit> willSaveWaitUntil(WillSaveTextDocumentParams params, IProgressMonitor monitor) {
        ArrayList<TextEdit> edit = new ArrayList<TextEdit>();
        if (monitor.isCanceled()) {
            return edit;
        }
        String documentUri = params.getTextDocument().getUri();
        Preferences preferences = this.preferenceManager.getPreferences();
        IEclipsePreferences jdtUiPreferences = this.getJdtUiProjectPreferences(documentUri);
        boolean canUseInternalSettings = this.preferenceManager.getClientPreferences().canUseInternalSettings();
        if (preferences.isJavaSaveActionsOrganizeImportsEnabled() || canUseInternalSettings && jdtUiPreferences != null && jdtUiPreferences.getBoolean("sp_cleanup.organize_imports", false)) {
            edit.addAll(this.handleSaveActionOrganizeImports(documentUri, monitor));
        }
        LinkedHashSet<String> cleanUpIds = new LinkedHashSet<String>();
        List<String> lspCleanups = preferences.getCleanUpActionsOnSave();
        Collection<String> jdtSettingCleanups = this.getCleanupsFromJDTUIPreferences(jdtUiPreferences);
        cleanUpIds.addAll(canUseInternalSettings ? jdtSettingCleanups : lspCleanups);
        List<TextEdit> cleanUpEdits = this.cleanUpRegistry.getEditsForAllActiveCleanUps(params.getTextDocument(), new ArrayList<String>(cleanUpIds), monitor);
        edit.addAll(cleanUpEdits);
        return edit;
    }

    private Collection<String> getCleanupsFromJDTUIPreferences(IEclipsePreferences jdtUIPrefs) {
        if (jdtUIPrefs == null) {
            return List.of();
        }
        try {
            if (jdtUIPrefs.getBoolean("editor_save_participant_org.eclipse.jdt.ui.postsavelistener.cleanup", false)) {
                return Arrays.stream(jdtUIPrefs.keys()).filter(key -> key.startsWith("sp_")).filter(key -> jdtUIPrefs.getBoolean(key, false)).map(key -> key.substring(3)).toList();
            }
        }
        catch (BackingStoreException e) {
            JavaLanguageServerPlugin.logException(e);
        }
        return List.of();
    }

    /*
     * WARNING - void declaration
     */
    private IEclipsePreferences getJdtUiProjectPreferences(String documentUri) {
        ICompilationUnit compilationUnit = JDTUtils.resolveCompilationUnit(documentUri);
        if (compilationUnit != null) {
            IJavaProject javaProject = compilationUnit.getJavaProject();
            try {
                IResource iResource = javaProject.getCorrespondingResource();
                if (iResource instanceof IProject) {
                    void project;
                    IProject iProject = (IProject)iResource;
                    IProject cfr_ignored_0 = (IProject)iResource;
                    ProjectScope scope = new ProjectScope((IProject)project);
                    return scope.getNode("org.eclipse.jdt.ui");
                }
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.log((CoreException)((Object)e));
            }
        }
        return null;
    }

    private List<TextEdit> handleSaveActionOrganizeImports(String documentUri, IProgressMonitor monitor) {
        String uri = ResourceUtils.fixURI(JDTUtils.toURI(documentUri));
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        WorkspaceEdit organizedResult = this.organizeImportsCommand.organizeImportsInFile(uri);
        List edit = (List)organizedResult.getChanges().get(uri);
        edit = edit == null ? Collections.emptyList() : edit;
        return edit;
    }
}

