(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_ai-ide_lib_browser_frontend-module_js"],{

/***/ "../../node_modules/@theia/ai-chat/lib/browser/task-context-storage-service.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/browser/task-context-storage-service.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InMemoryTaskContextStorage = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const ai_core_1 = __webpack_require__(/*! @theia/ai-core */ "../../node_modules/@theia/ai-core/lib/common/index.js");
const task_context_variable_1 = __webpack_require__(/*! ./task-context-variable */ "../../node_modules/@theia/ai-chat/lib/browser/task-context-variable.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
let InMemoryTaskContextStorage = class InMemoryTaskContextStorage {
    constructor() {
        this.summaries = new Map();
        this.onDidChangeEmitter = new core_1.Emitter();
        this.onDidChange = this.onDidChangeEmitter.event;
    }
    store(summary) {
        this.summaries.set(summary.id, summary);
        this.onDidChangeEmitter.fire();
    }
    getAll() {
        return Array.from(this.summaries.values());
    }
    get(identifier) {
        return this.summaries.get(identifier);
    }
    delete(identifier) {
        const didDelete = this.summaries.delete(identifier);
        if (didDelete) {
            this.onDidChangeEmitter.fire();
        }
        return didDelete;
    }
    clear() {
        if (this.summaries.size) {
            this.summaries.clear();
            this.onDidChangeEmitter.fire();
        }
    }
    async open(identifier) {
        const summary = this.get(identifier);
        if (!summary) {
            throw new Error('Unable to upon requested task context: none found.');
        }
        const resource = this.variableResourceResolver.getOrCreate({ variable: task_context_variable_1.TASK_CONTEXT_VARIABLE, arg: identifier }, {}, summary.summary);
        resource.update({ onSave: async (content) => { summary.summary = content; }, readOnly: false });
        await (0, browser_1.open)(this.openerService, resource.uri);
        resource.dispose();
    }
};
exports.InMemoryTaskContextStorage = InMemoryTaskContextStorage;
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_core_1.AIVariableResourceResolver),
    tslib_1.__metadata("design:type", ai_core_1.AIVariableResourceResolver)
], InMemoryTaskContextStorage.prototype, "variableResourceResolver", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.OpenerService),
    tslib_1.__metadata("design:type", Object)
], InMemoryTaskContextStorage.prototype, "openerService", void 0);
exports.InMemoryTaskContextStorage = InMemoryTaskContextStorage = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], InMemoryTaskContextStorage);


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/agent-configuration-widget.js":
/*!***************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/agent-configuration-widget.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var AIAgentConfigurationWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AIAgentConfigurationWidget = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const common_1 = __webpack_require__(/*! @theia/ai-core/lib/common */ "../../node_modules/@theia/ai-core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const ai_configuration_service_1 = __webpack_require__(/*! ./ai-configuration-service */ "../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/ai-configuration-service.js");
const language_model_renderer_1 = __webpack_require__(/*! ./language-model-renderer */ "../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/language-model-renderer.js");
const template_settings_renderer_1 = __webpack_require__(/*! ./template-settings-renderer */ "../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/template-settings-renderer.js");
const variable_configuration_widget_1 = __webpack_require__(/*! ./variable-configuration-widget */ "../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/variable-configuration-widget.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
;
let AIAgentConfigurationWidget = AIAgentConfigurationWidget_1 = class AIAgentConfigurationWidget extends browser_1.ReactWidget {
    constructor() {
        super(...arguments);
        this.toggleAgentEnabled = () => {
            const agent = this.aiConfigurationSelectionService.getActiveAgent();
            if (!agent) {
                return false;
            }
            const enabled = this.agentService.isEnabled(agent.id);
            if (enabled) {
                this.agentService.disableAgent(agent.id);
            }
            else {
                this.agentService.enableAgent(agent.id);
            }
            this.update();
        };
    }
    init() {
        this.id = AIAgentConfigurationWidget_1.ID;
        this.title.label = AIAgentConfigurationWidget_1.LABEL;
        this.title.closable = false;
        this.languageModelRegistry.getLanguageModels().then(models => {
            this.languageModels = models !== null && models !== void 0 ? models : [];
            this.update();
        });
        this.toDispose.push(this.languageModelRegistry.onChange(({ models }) => {
            this.languageModels = models;
            this.update();
        }));
        this.toDispose.push(this.promptCustomizationService.onDidChangePrompt(() => this.update()));
        this.aiSettingsService.onDidChange(() => this.update());
        this.aiConfigurationSelectionService.onDidAgentChange(() => this.update());
        this.agentService.onDidChangeAgents(() => this.update());
        this.update();
    }
    render() {
        return React.createElement("div", { className: 'ai-agent-configuration-main' },
            React.createElement("div", { className: 'configuration-agents-list preferences-tree-widget theia-TreeContainer', style: { width: '25%' } },
                React.createElement("ul", null, this.agentService.getAllAgents().map(agent => React.createElement("li", { key: agent.id, className: 'theia-TreeNode theia-CompositeTreeNode theia-ExpandableTreeNode', onClick: () => this.setActiveAgent(agent) }, this.renderAgentName(agent)))),
                React.createElement("div", { className: 'configuration-agents-add' },
                    React.createElement("button", { style: { marginLeft: 0 }, className: 'theia-button main', onClick: () => this.addCustomAgent() }, core_1.nls.localize('theia/ai/core/agentConfiguration/addCustomAgent', 'Add Custom Agent')))),
            React.createElement("div", { className: 'configuration-agent-panel preferences-editor-widget' }, this.renderAgentDetails()));
    }
    renderAgentName(agent) {
        var _a;
        const tagsSuffix = ((_a = agent.tags) === null || _a === void 0 ? void 0 : _a.length) ? React.createElement("span", null, agent.tags.map(tag => React.createElement("span", { key: tag, className: 'agent-tag' }, tag))) : '';
        return React.createElement("span", null,
            agent.name,
            " ",
            tagsSuffix);
    }
    renderAgentDetails() {
        const agent = this.aiConfigurationSelectionService.getActiveAgent();
        if (!agent) {
            return React.createElement("div", null, core_1.nls.localize('theia/ai/core/agentConfiguration/selectAgentMessage', 'Please select an Agent first!'));
        }
        const enabled = this.agentService.isEnabled(agent.id);
        const parsedPromptParts = this.parsePromptTemplatesForVariableAndFunction(agent);
        const globalVariables = Array.from(new Set([...parsedPromptParts.globalVariables, ...agent.variables]));
        const functions = Array.from(new Set([...parsedPromptParts.functions, ...agent.functions]));
        return React.createElement("div", { key: agent.id, style: { display: 'flex', flexDirection: 'column', alignItems: 'flex-start' } },
            React.createElement("div", { className: 'settings-section-title settings-section-category-title', style: { paddingLeft: 0, paddingBottom: 10 } },
                this.renderAgentName(agent),
                React.createElement("pre", { style: { fontSize: 'small', margin: 0 } },
                    "Id: ",
                    agent.id)),
            React.createElement("div", { style: { paddingBottom: 10 } }, agent.description),
            React.createElement("div", { style: { paddingBottom: 10 } },
                React.createElement("label", null,
                    React.createElement("input", { type: "checkbox", checked: enabled, onChange: this.toggleAgentEnabled }),
                    core_1.nls.localize('theia/ai/core/agentConfiguration/enableAgent', 'Enable Agent'))),
            React.createElement("div", { className: "settings-section-subcategory-title ai-settings-section-subcategory-title" }, core_1.nls.localize('theia/ai/core/agentConfiguration/promptTemplates', 'Prompt Templates')),
            React.createElement("div", { className: "ai-templates" }, (() => {
                var _a;
                const defaultTemplates = ((_a = agent.promptTemplates) === null || _a === void 0 ? void 0 : _a.filter(template => !template.variantOf)) || [];
                return defaultTemplates.length > 0 ? (defaultTemplates.map(template => (React.createElement("div", { key: agent.id + '.' + template.id },
                    React.createElement(template_settings_renderer_1.TemplateRenderer, { key: agent.id + '.' + template.id, agentId: agent.id, template: template, promptService: this.promptService, aiSettingsService: this.aiSettingsService, promptCustomizationService: this.promptCustomizationService }))))) : (React.createElement("div", null, core_1.nls.localize('theia/ai/core/agentConfiguration/noDefaultTemplate', 'No default template available')));
            })()),
            React.createElement("div", { className: 'ai-lm-requirements' },
                React.createElement(language_model_renderer_1.LanguageModelRenderer, { agent: agent, languageModels: this.languageModels, aiSettingsService: this.aiSettingsService, languageModelRegistry: this.languageModelRegistry })),
            React.createElement("div", null,
                React.createElement("span", null, "Used Global Variables:"),
                React.createElement("ul", { className: 'variable-references' },
                    React.createElement(AgentGlobalVariables, { variables: globalVariables, showVariableConfigurationTab: this.showVariableConfigurationTab.bind(this) }))),
            React.createElement("div", null,
                React.createElement("span", null, "Used agent-specific Variables:"),
                React.createElement("ul", { className: 'variable-references' },
                    React.createElement(AgentSpecificVariables, { promptVariables: parsedPromptParts.agentSpecificVariables, agent: agent }))),
            React.createElement("div", null,
                React.createElement("span", null, "Used Functions:"),
                React.createElement("ul", { className: 'function-references' },
                    React.createElement(AgentFunctions, { functions: functions }))));
    }
    parsePromptTemplatesForVariableAndFunction(agent) {
        const promptTemplates = agent.promptTemplates;
        const result = { functions: [], globalVariables: [], agentSpecificVariables: [] };
        promptTemplates.forEach(template => {
            var _a;
            const storedPrompt = this.promptService.getUnresolvedPrompt(template.id);
            const prompt = (_a = storedPrompt === null || storedPrompt === void 0 ? void 0 : storedPrompt.template) !== null && _a !== void 0 ? _a : template.template;
            const variableMatches = (0, common_1.matchVariablesRegEx)(prompt);
            variableMatches.forEach(match => {
                const variableId = match[1];
                // if the variable is part of the variable service and not part of the agent specific variables then it is a global variable
                if (this.variableService.hasVariable(variableId) &&
                    agent.agentSpecificVariables.find(v => v.name === variableId) === undefined) {
                    result.globalVariables.push(variableId);
                }
                else {
                    result.agentSpecificVariables.push(variableId);
                }
            });
            const functionMatches = [...prompt.matchAll(common_1.PROMPT_FUNCTION_REGEX)];
            functionMatches.forEach(match => {
                const functionId = match[1];
                result.functions.push(functionId);
            });
        });
        return result;
    }
    showVariableConfigurationTab() {
        this.aiConfigurationSelectionService.selectConfigurationTab(variable_configuration_widget_1.AIVariableConfigurationWidget.ID);
    }
    async addCustomAgent() {
        const locations = await this.promptCustomizationService.getCustomAgentsLocations();
        // If only one location is available, use the direct approach
        if (locations.length === 1) {
            this.promptCustomizationService.openCustomAgentYaml(locations[0].uri);
            return;
        }
        // Multiple locations - show quick picker
        const quickPick = this.quickInputService.createQuickPick();
        quickPick.title = 'Select Location for Custom Agents File';
        quickPick.placeholder = 'Choose where to create or open a custom agents file';
        quickPick.items = locations.map(location => ({
            label: location.uri.path.toString(),
            description: location.exists ? 'Open existing file' : 'Create new file',
            location
        }));
        quickPick.onDidAccept(async () => {
            const selectedItem = quickPick.selectedItems[0];
            if (selectedItem && selectedItem.location) {
                quickPick.dispose();
                this.promptCustomizationService.openCustomAgentYaml(selectedItem.location.uri);
            }
        });
        quickPick.show();
    }
    setActiveAgent(agent) {
        this.aiConfigurationSelectionService.setActiveAgent(agent);
        this.update();
    }
};
exports.AIAgentConfigurationWidget = AIAgentConfigurationWidget;
AIAgentConfigurationWidget.ID = 'ai-agent-configuration-container-widget';
AIAgentConfigurationWidget.LABEL = core_1.nls.localize('theia/ai/core/agentConfiguration/label', 'Agents');
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.AgentService),
    tslib_1.__metadata("design:type", Object)
], AIAgentConfigurationWidget.prototype, "agentService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.LanguageModelRegistry),
    tslib_1.__metadata("design:type", Object)
], AIAgentConfigurationWidget.prototype, "languageModelRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.PromptCustomizationService),
    tslib_1.__metadata("design:type", Object)
], AIAgentConfigurationWidget.prototype, "promptCustomizationService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.AISettingsService),
    tslib_1.__metadata("design:type", Object)
], AIAgentConfigurationWidget.prototype, "aiSettingsService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_configuration_service_1.AIConfigurationSelectionService),
    tslib_1.__metadata("design:type", ai_configuration_service_1.AIConfigurationSelectionService)
], AIAgentConfigurationWidget.prototype, "aiConfigurationSelectionService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.AIVariableService),
    tslib_1.__metadata("design:type", Object)
], AIAgentConfigurationWidget.prototype, "variableService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.PromptService),
    tslib_1.__metadata("design:type", Object)
], AIAgentConfigurationWidget.prototype, "promptService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.QuickInputService),
    tslib_1.__metadata("design:type", Object)
], AIAgentConfigurationWidget.prototype, "quickInputService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], AIAgentConfigurationWidget.prototype, "init", null);
exports.AIAgentConfigurationWidget = AIAgentConfigurationWidget = AIAgentConfigurationWidget_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], AIAgentConfigurationWidget);
const AgentGlobalVariables = ({ variables: globalVariables, showVariableConfigurationTab }) => {
    if (globalVariables.length === 0) {
        return React.createElement(React.Fragment, null, core_1.nls.localizeByDefault('None'));
    }
    return React.createElement(React.Fragment, null, globalVariables.map(variableId => React.createElement("li", { key: variableId, className: 'theia-TreeNode theia-CompositeTreeNode theia-ExpandableTreeNode theia-mod-selected' },
        React.createElement("div", { key: variableId, onClick: () => { showVariableConfigurationTab(); }, className: 'variable-reference' },
            React.createElement("span", null, variableId),
            React.createElement("i", { className: (0, browser_1.codicon)('chevron-right') })))));
};
const AgentFunctions = ({ functions }) => {
    if (functions.length === 0) {
        return React.createElement(React.Fragment, null, core_1.nls.localizeByDefault('None'));
    }
    return React.createElement(React.Fragment, null, functions.map(functionId => React.createElement("li", { key: functionId, className: 'variable-reference' },
        React.createElement("span", null, functionId))));
};
const AgentSpecificVariables = ({ promptVariables, agent }) => {
    const agentDefinedVariablesName = agent.agentSpecificVariables.map(v => v.name);
    const variables = Array.from(new Set([...promptVariables, ...agentDefinedVariablesName]));
    if (variables.length === 0) {
        return React.createElement(React.Fragment, null, core_1.nls.localizeByDefault('None'));
    }
    return React.createElement(React.Fragment, null, variables.map(variableId => React.createElement(AgentSpecifcVariable, { key: variableId, variableId: variableId, agent: agent, promptVariables: promptVariables })));
};
const AgentSpecifcVariable = ({ variableId, agent, promptVariables }) => {
    const agentDefinedVariable = agent.agentSpecificVariables.find(v => v.name === variableId);
    const undeclared = agentDefinedVariable === undefined;
    const notUsed = !promptVariables.includes(variableId) && (agentDefinedVariable === null || agentDefinedVariable === void 0 ? void 0 : agentDefinedVariable.usedInPrompt) === true;
    return React.createElement("li", { key: variableId },
        React.createElement("div", null,
            React.createElement("span", null, core_1.nls.localize('theia/ai/core/agentConfiguration/name', 'Name:')),
            " ",
            React.createElement("span", null, variableId)),
        undeclared ? React.createElement("div", null,
            React.createElement("span", null, core_1.nls.localize('theia/ai/core/agentConfiguration/undeclared', 'Undeclared'))) :
            (React.createElement(React.Fragment, null,
                React.createElement("div", null,
                    React.createElement("span", null, core_1.nls.localize('theia/ai/core/agentConfiguration/description', 'Description:')),
                    " ",
                    React.createElement("span", null, agentDefinedVariable.description)),
                notUsed && React.createElement("div", null, core_1.nls.localize('theia/ai/core/agentConfiguration/notUsedInPrompt', 'Not used in prompt')))),
        React.createElement("hr", null));
};


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/ai-configuration-preferences.js":
/*!*****************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/ai-configuration-preferences.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AiConfigurationPreferences = void 0;
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
/**
 * These preferences are not intended to reflect real settings.
 * They are placeholders to redirect users to the appropriate widget
 * in case the user looks in the preferences editor UI to find the configuration.
 */
exports.AiConfigurationPreferences = {
    type: 'object',
    properties: {
        'ai-features.agentSettings.details': {
            type: 'null',
            markdownDescription: core_1.nls.localize('theia/ai/ide/agent-description', 'Configure AI agent settings including enablement, LLM selection, prompt template customization, and custom agent creation in the [AI Configuration View]({0}).', 'command:aiConfiguration:open')
        },
        'ai-features.promptTemplates.details': {
            type: 'null',
            markdownDescription: core_1.nls.localize('theia/ai/ide/prompt-template-description', 'Select prompt variants and customize prompt templates for AI agents in the [AI Configuration View]({0}).', 'command:aiConfiguration:open')
        },
        'ai-features.modelSelection.details': {
            type: 'null',
            markdownDescription: core_1.nls.localize('theia/ai/ide/model-selection-description', 'Choose which Large Language Models (LLMs) are used by each AI agent in the [AI Configuration View]({0}).', 'command:aiConfiguration:open')
        }
    }
};


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/ai-configuration-service.js":
/*!*************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/ai-configuration-service.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AIConfigurationSelectionService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
let AIConfigurationSelectionService = class AIConfigurationSelectionService {
    constructor() {
        this.onDidSelectConfigurationEmitter = new core_1.Emitter();
        this.onDidSelectConfiguration = this.onDidSelectConfigurationEmitter.event;
        this.onDidAgentChangeEmitter = new core_1.Emitter();
        this.onDidAgentChange = this.onDidSelectConfigurationEmitter.event;
    }
    getActiveAgent() {
        return this.activeAgent;
    }
    setActiveAgent(agent) {
        this.activeAgent = agent;
        this.onDidAgentChangeEmitter.fire(agent);
    }
    selectConfigurationTab(widgetId) {
        this.onDidSelectConfigurationEmitter.fire(widgetId);
    }
};
exports.AIConfigurationSelectionService = AIConfigurationSelectionService;
exports.AIConfigurationSelectionService = AIConfigurationSelectionService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], AIConfigurationSelectionService);


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/ai-configuration-view-contribution.js":
/*!***********************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/ai-configuration-view-contribution.js ***!
  \***********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AIAgentConfigurationViewContribution = exports.OPEN_AI_CONFIG_VIEW = exports.AI_CONFIGURATION_TOGGLE_COMMAND_ID = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/ai-core/lib/browser */ "../../node_modules/@theia/ai-core/lib/browser/index.js");
const chat_view_widget_1 = __webpack_require__(/*! @theia/ai-chat-ui/lib/browser/chat-view-widget */ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-view-widget.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const ai_configuration_widget_1 = __webpack_require__(/*! ./ai-configuration-widget */ "../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/ai-configuration-widget.js");
exports.AI_CONFIGURATION_TOGGLE_COMMAND_ID = 'aiConfiguration:toggle';
exports.OPEN_AI_CONFIG_VIEW = core_1.Command.toLocalizedCommand({
    id: 'aiConfiguration:open',
    label: 'Open AI Configuration view',
});
let AIAgentConfigurationViewContribution = class AIAgentConfigurationViewContribution extends browser_1.AIViewContribution {
    constructor() {
        super({
            widgetId: ai_configuration_widget_1.AIConfigurationContainerWidget.ID,
            widgetName: ai_configuration_widget_1.AIConfigurationContainerWidget.LABEL,
            defaultWidgetOptions: {
                area: 'main',
                rank: 100
            },
            toggleCommandId: exports.AI_CONFIGURATION_TOGGLE_COMMAND_ID
        });
    }
    async initializeLayout(_app) {
        await this.openView();
    }
    registerCommands(commands) {
        super.registerCommands(commands);
        commands.registerCommand(exports.OPEN_AI_CONFIG_VIEW, {
            execute: () => this.openView({ activate: true }),
        });
    }
    registerToolbarItems(registry) {
        registry.registerItem({
            id: 'chat-view.' + exports.OPEN_AI_CONFIG_VIEW.id,
            command: exports.OPEN_AI_CONFIG_VIEW.id,
            tooltip: core_1.nls.localize('theia/ai-ide/open-agent-settings-tooltip', 'Open Agent settings...'),
            group: 'ai-settings',
            priority: 2,
            isVisible: widget => widget instanceof chat_view_widget_1.ChatViewWidget
        });
    }
};
exports.AIAgentConfigurationViewContribution = AIAgentConfigurationViewContribution;
exports.AIAgentConfigurationViewContribution = AIAgentConfigurationViewContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)(),
    tslib_1.__metadata("design:paramtypes", [])
], AIAgentConfigurationViewContribution);


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/ai-configuration-widget.js":
/*!************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/ai-configuration-widget.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var AIConfigurationContainerWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AIConfigurationContainerWidget = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const theia_dock_panel_1 = __webpack_require__(/*! @theia/core/lib/browser/shell/theia-dock-panel */ "../../node_modules/@theia/core/lib/browser/shell/theia-dock-panel.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
__webpack_require__(/*! ../../../src/browser/style/index.css */ "../../node_modules/@theia/ai-ide/src/browser/style/index.css");
const agent_configuration_widget_1 = __webpack_require__(/*! ./agent-configuration-widget */ "../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/agent-configuration-widget.js");
const variable_configuration_widget_1 = __webpack_require__(/*! ./variable-configuration-widget */ "../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/variable-configuration-widget.js");
const ai_configuration_service_1 = __webpack_require__(/*! ./ai-configuration-service */ "../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/ai-configuration-service.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const mcp_configuration_widget_1 = __webpack_require__(/*! ./mcp-configuration-widget */ "../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/mcp-configuration-widget.js");
const token_usage_configuration_widget_1 = __webpack_require__(/*! ./token-usage-configuration-widget */ "../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/token-usage-configuration-widget.js");
let AIConfigurationContainerWidget = AIConfigurationContainerWidget_1 = class AIConfigurationContainerWidget extends browser_1.BaseWidget {
    init() {
        this.id = AIConfigurationContainerWidget_1.ID;
        this.title.label = AIConfigurationContainerWidget_1.LABEL;
        this.title.closable = true;
        this.addClass('theia-settings-container');
        this.title.iconClass = (0, browser_1.codicon)('hubot');
        this.initUI();
        this.initListeners();
    }
    async initUI() {
        const layout = (this.layout = new browser_1.BoxLayout({ direction: 'top-to-bottom', spacing: 0 }));
        this.dockpanel = this.dockPanelFactory({
            mode: 'multiple-document',
            spacing: 0
        });
        browser_1.BoxLayout.setStretch(this.dockpanel, 1);
        layout.addWidget(this.dockpanel);
        this.dockpanel.addClass('ai-configuration-widget');
        this.agentsWidget = await this.widgetManager.getOrCreateWidget(agent_configuration_widget_1.AIAgentConfigurationWidget.ID);
        this.variablesWidget = await this.widgetManager.getOrCreateWidget(variable_configuration_widget_1.AIVariableConfigurationWidget.ID);
        this.mcpWidget = await this.widgetManager.getOrCreateWidget(mcp_configuration_widget_1.AIMCPConfigurationWidget.ID);
        this.tokenUsageWidget = await this.widgetManager.getOrCreateWidget(token_usage_configuration_widget_1.AITokenUsageConfigurationWidget.ID);
        this.dockpanel.addWidget(this.agentsWidget);
        this.dockpanel.addWidget(this.variablesWidget, { mode: 'tab-after', ref: this.agentsWidget });
        this.dockpanel.addWidget(this.mcpWidget, { mode: 'tab-after', ref: this.variablesWidget });
        this.dockpanel.addWidget(this.tokenUsageWidget, { mode: 'tab-after', ref: this.mcpWidget });
        this.update();
    }
    initListeners() {
        this.aiConfigurationSelectionService.onDidSelectConfiguration(widgetId => {
            if (widgetId === agent_configuration_widget_1.AIAgentConfigurationWidget.ID) {
                this.dockpanel.activateWidget(this.agentsWidget);
            }
            else if (widgetId === variable_configuration_widget_1.AIVariableConfigurationWidget.ID) {
                this.dockpanel.activateWidget(this.variablesWidget);
            }
            else if (widgetId === mcp_configuration_widget_1.AIMCPConfigurationWidget.ID) {
                this.dockpanel.activateWidget(this.mcpWidget);
            }
            else if (widgetId === token_usage_configuration_widget_1.AITokenUsageConfigurationWidget.ID) {
                this.dockpanel.activateWidget(this.tokenUsageWidget);
            }
        });
    }
};
exports.AIConfigurationContainerWidget = AIConfigurationContainerWidget;
AIConfigurationContainerWidget.ID = 'ai-configuration';
AIConfigurationContainerWidget.LABEL = core_1.nls.localize('theia/ai/core/aiConfiguration/label', 'AI Configuration [Alpha]');
tslib_1.__decorate([
    (0, inversify_1.inject)(theia_dock_panel_1.TheiaDockPanel.Factory),
    tslib_1.__metadata("design:type", Function)
], AIConfigurationContainerWidget.prototype, "dockPanelFactory", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.WidgetManager),
    tslib_1.__metadata("design:type", browser_1.WidgetManager)
], AIConfigurationContainerWidget.prototype, "widgetManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_configuration_service_1.AIConfigurationSelectionService),
    tslib_1.__metadata("design:type", ai_configuration_service_1.AIConfigurationSelectionService)
], AIConfigurationContainerWidget.prototype, "aiConfigurationSelectionService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], AIConfigurationContainerWidget.prototype, "init", null);
exports.AIConfigurationContainerWidget = AIConfigurationContainerWidget = AIConfigurationContainerWidget_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], AIConfigurationContainerWidget);


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/language-model-renderer.js":
/*!************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/language-model-renderer.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LanguageModelRenderer = void 0;
// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
const LanguageModelRenderer = ({ agent, languageModels, aiSettingsService, languageModelRegistry }) => {
    const findLanguageModelRequirement = async (purpose) => {
        var _a;
        const requirementSetting = await aiSettingsService.getAgentSettings(agent.id);
        return (_a = requirementSetting === null || requirementSetting === void 0 ? void 0 : requirementSetting.languageModelRequirements) === null || _a === void 0 ? void 0 : _a.find(e => e.purpose === purpose);
    };
    const [lmRequirementMap, setLmRequirementMap] = React.useState({});
    React.useEffect(() => {
        const computeLmRequirementMap = async () => {
            const map = await agent.languageModelRequirements.reduce(async (accPromise, curr) => {
                var _a;
                const acc = await accPromise;
                // take the agents requirements and override them with the user settings if present
                const lmRequirement = (_a = await findLanguageModelRequirement(curr.purpose)) !== null && _a !== void 0 ? _a : curr;
                // if no llm is selected through the identifier, see what would be the default
                if (!lmRequirement.identifier) {
                    const llm = await languageModelRegistry.selectLanguageModel({ agent: agent.id, ...lmRequirement });
                    lmRequirement.identifier = llm === null || llm === void 0 ? void 0 : llm.id;
                }
                acc[curr.purpose] = lmRequirement;
                return acc;
            }, Promise.resolve({}));
            setLmRequirementMap(map);
        };
        computeLmRequirementMap();
    }, []);
    const renderLanguageModelMetadata = (requirement, index) => {
        const languageModel = languageModels === null || languageModels === void 0 ? void 0 : languageModels.find(model => model.id === requirement.identifier);
        if (!languageModel) {
            return React.createElement("div", null);
        }
        return React.createElement(React.Fragment, null,
            React.createElement("div", null, requirement.purpose),
            React.createElement("div", { key: index },
                languageModel.id && React.createElement("p", null,
                    React.createElement("strong", null,
                        nls_1.nls.localizeByDefault('Identifier'),
                        ": "),
                    " ",
                    languageModel.id),
                languageModel.name && React.createElement("p", null,
                    React.createElement("strong", null,
                        nls_1.nls.localizeByDefault('Name'),
                        ": "),
                    " ",
                    languageModel.name),
                languageModel.vendor && React.createElement("p", null,
                    React.createElement("strong", null,
                        nls_1.nls.localize('theia/ai/core/languageModelRenderer/vendor', 'Vendor'),
                        ": "),
                    " ",
                    languageModel.vendor),
                languageModel.version && React.createElement("p", null,
                    React.createElement("strong", null,
                        nls_1.nls.localizeByDefault('Version'),
                        ": "),
                    " ",
                    languageModel.version),
                languageModel.family && React.createElement("p", null,
                    React.createElement("strong", null,
                        nls_1.nls.localize('theia/ai/core/languageModelRenderer/family', 'Family'),
                        ": "),
                    " ",
                    languageModel.family),
                languageModel.maxInputTokens &&
                    React.createElement("p", null,
                        React.createElement("strong", null,
                            nls_1.nls.localize('theia/ai/core/languageModelRenderer/minInputTokens', 'Min Input Tokens'),
                            ":"),
                        " ",
                        languageModel.maxInputTokens),
                languageModel.maxOutputTokens &&
                    React.createElement("p", null,
                        React.createElement("strong", null,
                            nls_1.nls.localize('theia/ai/core/languageModelRenderer/maxOutputTokens', 'Max Output Tokens'),
                            ":"),
                        " ",
                        languageModel.maxOutputTokens)));
    };
    const onSelectedModelChange = (purpose, event) => {
        const newLmRequirementMap = { ...lmRequirementMap, [purpose]: { purpose, identifier: event.target.value } };
        aiSettingsService.updateAgentSettings(agent.id, { languageModelRequirements: Object.values(newLmRequirementMap) });
        setLmRequirementMap(newLmRequirementMap);
    };
    return React.createElement("div", { className: 'language-model-container' }, Object.values(lmRequirementMap).map((requirements, index) => (React.createElement(React.Fragment, { key: index },
        React.createElement("div", null,
            React.createElement("strong", null,
                nls_1.nls.localize('theia/ai/core/languageModelRenderer/purpose', 'Purpose'),
                ":")),
        React.createElement("div", null,
            renderLanguageModelMetadata(requirements, index),
            React.createElement(React.Fragment, null,
                React.createElement("label", { className: "theia-header no-select", htmlFor: `model-select-${agent.id}` },
                    nls_1.nls.localize('theia/ai/core/languageModelRenderer/languageModel', 'Language Model'),
                    ":"),
                React.createElement("select", { className: "theia-select", id: `model-select-${agent.id}`, value: requirements.identifier, onChange: event => onSelectedModelChange(requirements.purpose, event) },
                    React.createElement("option", { value: "" }), languageModels === null || languageModels === void 0 ? void 0 :
                    languageModels.sort((a, b) => { var _a, _b; return ((_a = a.name) !== null && _a !== void 0 ? _a : a.id).localeCompare((_b = b.name) !== null && _b !== void 0 ? _b : b.id); }).map(model => {
                        var _a;
                        return (React.createElement("option", { key: model.id, value: model.id }, (_a = model.name) !== null && _a !== void 0 ? _a : model.id));
                    }))),
            React.createElement("hr", null))))));
};
exports.LanguageModelRenderer = LanguageModelRenderer;


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/mcp-configuration-widget.js":
/*!*************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/mcp-configuration-widget.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var AIMCPConfigurationWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AIMCPConfigurationWidget = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const hover_service_1 = __webpack_require__(/*! @theia/core/lib/browser/hover-service */ "../../node_modules/@theia/core/lib/browser/hover-service.js");
const mcp_server_manager_1 = __webpack_require__(/*! @theia/ai-mcp/lib/common/mcp-server-manager */ "../../node_modules/@theia/ai-mcp/lib/common/mcp-server-manager.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const prompt_variable_contribution_1 = __webpack_require__(/*! @theia/ai-core/lib/common/prompt-variable-contribution */ "../../node_modules/@theia/ai-core/lib/common/prompt-variable-contribution.js");
let AIMCPConfigurationWidget = AIMCPConfigurationWidget_1 = class AIMCPConfigurationWidget extends browser_1.ReactWidget {
    constructor() {
        super(...arguments);
        this.servers = [];
        this.expandedTools = {};
    }
    init() {
        this.id = AIMCPConfigurationWidget_1.ID;
        this.title.label = AIMCPConfigurationWidget_1.LABEL;
        this.title.closable = false;
        this.toDispose.push(this.mcpFrontendNotificationService.onDidUpdateMCPServers(async () => {
            this.loadServers();
        }));
        this.loadServers();
    }
    async loadServers() {
        const serverNames = await this.mcpFrontendService.getServerNames();
        const descriptions = await Promise.all(serverNames.map(name => this.mcpFrontendService.getServerDescription(name)));
        this.servers = descriptions.filter((desc) => desc !== undefined);
        this.update();
    }
    getStatusColor(status) {
        if (!status) {
            return { bg: 'var(--theia-descriptionForeground)', fg: 'white' };
        }
        switch (status) {
            case mcp_server_manager_1.MCPServerStatus.Running:
                return { bg: 'var(--theia-successBackground)', fg: 'var(--theia-successForeground)' };
            case mcp_server_manager_1.MCPServerStatus.Starting:
                return { bg: 'var(--theia-warningBackground)', fg: 'var(--theia-warningForeground)' };
            case mcp_server_manager_1.MCPServerStatus.Errored:
                return { bg: 'var(--theia-errorBackground)', fg: 'var(--theia-errorForeground)' };
            case mcp_server_manager_1.MCPServerStatus.NotRunning:
            default:
                return { bg: 'var(--theia-inputValidation-infoBackground)', fg: 'var(--theia-inputValidation-infoForeground)' };
        }
    }
    showErrorHover(spanRef, error) {
        this.hoverService.requestHover({ content: error, target: spanRef.current, position: 'left' });
    }
    hideErrorHover() {
        this.hoverService.cancelHover();
    }
    async handleStartServer(serverName) {
        await this.mcpFrontendService.startServer(serverName);
    }
    async handleStopServer(serverName) {
        await this.mcpFrontendService.stopServer(serverName);
    }
    renderButton(text, title, onClick, className, style) {
        return (React.createElement("button", { className: className, title: title, onClick: onClick, style: style }, text));
    }
    renderStatusBadge(status, error) {
        const colors = this.getStatusColor(status);
        const displayStatus = status || mcp_server_manager_1.MCPServerStatus.NotRunning;
        const spanRef = React.createRef();
        return (React.createElement("div", { className: "mcp-status-container" },
            React.createElement("span", { className: "mcp-status-badge", style: {
                    backgroundColor: colors.bg,
                    color: colors.fg
                } }, displayStatus),
            error && (React.createElement("span", { onMouseEnter: () => this.showErrorHover(spanRef, error), onMouseLeave: () => this.hideErrorHover(), ref: spanRef, className: "mcp-error-indicator" }, "?"))));
    }
    renderServerHeader(server) {
        return (React.createElement("div", { className: "mcp-server-header" },
            React.createElement("div", { className: "mcp-server-name" }, server.name),
            this.renderStatusBadge(server.status, server.error)));
    }
    renderCommandSection(server) {
        return (React.createElement("div", { className: "mcp-server-section" },
            React.createElement("span", { className: "mcp-section-label" }, core_1.nls.localize('theia/ai/mcpConfiguration/command', 'Command: ')),
            React.createElement("code", { className: "mcp-code-block" }, server.command)));
    }
    renderArgumentsSection(server) {
        if (!server.args || server.args.length === 0) {
            return;
        }
        return (React.createElement("div", { className: "mcp-server-section" },
            React.createElement("span", { className: "mcp-section-label" }, core_1.nls.localize('theia/ai/mcpConfiguration/arguments', 'Arguments: ')),
            React.createElement("code", { className: "mcp-code-block" }, server.args.join(' '))));
    }
    renderEnvironmentSection(server) {
        if (!server.env || Object.keys(server.env).length === 0) {
            return;
        }
        return (React.createElement("div", { className: "mcp-server-section" },
            React.createElement("span", { className: "mcp-section-label" }, core_1.nls.localize('theia/ai/mcpConfiguration/environmentVariables', 'Environment Variables: ')),
            React.createElement("div", { className: "mcp-env-block" }, Object.entries(server.env).map(([key, value]) => (React.createElement("div", { key: key },
                key,
                "=",
                key.toLowerCase().includes('token') ? '******' : value))))));
    }
    renderAutostartSection(server) {
        return (React.createElement("div", { className: "mcp-server-section" },
            React.createElement("span", { className: "mcp-section-label" }, core_1.nls.localize('theia/ai/mcpConfiguration/autostart', 'Autostart: ')),
            React.createElement("span", { className: "mcp-autostart-badge", style: {
                    backgroundColor: server.autostart ? 'var(--theia-successBackground)' : 'var(--theia-errorBackground)',
                    color: server.autostart ? 'var(--theia-successForeground)' : 'var(--theia-errorForeground)',
                } }, server.autostart ? core_1.nls.localize('theia/ai/mcpConfiguration/enabled', 'Enabled') : core_1.nls.localize('theia/ai/mcpConfiguration/disabled', 'Disabled'))));
    }
    renderToolsSection(server) {
        if (!server.tools || server.tools.length === 0) {
            return;
        }
        const isToolsExpanded = this.expandedTools[server.name] || false;
        return (React.createElement("div", { className: "mcp-tools-section" },
            React.createElement("div", { style: { display: 'flex', alignItems: 'center' }, onClick: () => this.toggleTools(server.name) },
                React.createElement("div", { className: "mcp-toggle-indicator", style: { display: 'flex' } },
                    React.createElement("span", { style: {
                            display: 'inline-block',
                            transition: 'transform 0.2s ease',
                            fontSize: '12px'
                        } }, isToolsExpanded ? '▼' : '►')),
                React.createElement("div", { style: { flexGrow: 1 } },
                    React.createElement("span", { className: "mcp-section-label" }, core_1.nls.localize('theia/ai/mcpConfiguration/tools', 'Tools: '))),
                React.createElement("div", { style: { display: 'flex', gap: '4px' } },
                    this.renderButton(React.createElement("i", { className: "codicon codicon-versions" }), core_1.nls.localize('theia/ai/mcpConfiguration/copyAllList', 'Copy all (list of all tools)'), e => {
                        e.stopPropagation();
                        if (server.tools) {
                            const toolNames = server.tools.map(tool => `~{mcp_${server.name}_${tool.name}}`).join('\n');
                            navigator.clipboard.writeText(toolNames);
                            this.messageService.info(core_1.nls.localize('theia/ai/mcpConfiguration/copiedAllList', 'Copied all tools to clipboard (list of all tools)'));
                        }
                    }, 'mcp-copy-tool-button'),
                    this.renderButton(React.createElement("i", { className: "codicon codicon-bracket" }), core_1.nls.localize('theia/ai/mcpConfiguration/copyForPromptTemplate', 'Copy all for prompt template (single prompt fragment with all tools)'), e => {
                        e.stopPropagation();
                        navigator.clipboard.writeText(`{{${prompt_variable_contribution_1.PROMPT_VARIABLE.name}:${this.mcpFrontendService.getPromptTemplateId(server.name)}}}`);
                        this.messageService.info(core_1.nls.localize('theia/ai/mcpConfiguration/copiedForPromptTemplate', 'Copied all tools to clipboard for prompt template \
                                    (single prompt fragment with all tools)'));
                    }, 'mcp-copy-tool-button'),
                    this.renderButton(React.createElement("i", { className: "codicon codicon-copy" }), core_1.nls.localize('theia/ai/mcpConfiguration/copyAllSingle', 'Copy all for chat (single prompt fragment with all tools)'), e => {
                        e.stopPropagation();
                        navigator.clipboard.writeText(`#${prompt_variable_contribution_1.PROMPT_VARIABLE.name}:${this.mcpFrontendService.getPromptTemplateId(server.name)}`);
                        this.messageService.info(core_1.nls.localize('theia/ai/mcpConfiguration/copiedAllSingle', 'Copied all tools to clipboard (single prompt fragment with \
                                    all tools)'));
                    }, 'mcp-copy-tool-button'))),
            isToolsExpanded && (React.createElement("div", { className: "mcp-tools-list" }, server.tools.map(tool => (React.createElement("div", { key: tool.name, style: { display: 'flex', alignItems: 'center' } },
                React.createElement("div", { style: { flexGrow: 1 } },
                    React.createElement("strong", null,
                        tool.name,
                        ":"),
                    " ",
                    tool.description),
                React.createElement("div", { style: { display: 'flex', gap: '4px' } }, this.renderButton(React.createElement("i", { className: "codicon codicon-copy" }), core_1.nls.localize('theia/ai/mcpConfiguration/copyForPrompt', 'Copy tool (for chat or prompt template)'), e => {
                    e.stopPropagation();
                    const copied = `~{mcp_${server.name}_${tool.name}}`;
                    navigator.clipboard.writeText(copied);
                    this.messageService.info(`Copied ${copied} to clipboard (for chat or prompt template)`);
                }, 'mcp-copy-tool-button')))))))));
    }
    toggleTools(serverName) {
        this.expandedTools[serverName] = !this.expandedTools[serverName];
        this.update();
    }
    renderServerControls(server) {
        const isStoppable = server.status === mcp_server_manager_1.MCPServerStatus.Running || server.status === mcp_server_manager_1.MCPServerStatus.Starting;
        const isStartable = server.status === mcp_server_manager_1.MCPServerStatus.NotRunning || server.status === mcp_server_manager_1.MCPServerStatus.Errored;
        return (React.createElement("div", { className: "mcp-server-controls" },
            isStartable && this.renderButton(React.createElement(React.Fragment, null,
                React.createElement("i", { className: "codicon codicon-play" }),
                " ",
                core_1.nls.localize('theia/ai/mcpConfiguration/startServer', 'Start Server')), core_1.nls.localize('theia/ai/mcpConfiguration/startServer', 'Start Server'), () => this.handleStartServer(server.name), 'mcp-server-button play-button'),
            isStoppable && this.renderButton(React.createElement(React.Fragment, null,
                React.createElement("i", { className: "codicon codicon-close" }),
                " ",
                core_1.nls.localize('theia/ai/mcpConfiguration/stopServer', 'Stop Server')), core_1.nls.localize('theia/ai/mcpConfiguration/stopServer', 'Stop Server'), () => this.handleStopServer(server.name), 'mcp-server-button stop-button')));
    }
    renderServerCard(server) {
        return (React.createElement("div", { key: server.name, className: "mcp-server-card" },
            this.renderServerHeader(server),
            this.renderCommandSection(server),
            this.renderArgumentsSection(server),
            this.renderEnvironmentSection(server),
            this.renderAutostartSection(server),
            this.renderToolsSection(server),
            this.renderServerControls(server)));
    }
    render() {
        if (this.servers.length === 0) {
            return (React.createElement("div", { className: "mcp-no-servers" }, core_1.nls.localize('theia/ai/mcpConfiguration/noServers', 'No MCP servers configured')));
        }
        return (React.createElement("div", { className: "mcp-configuration-container" },
            React.createElement("h2", { className: "mcp-configuration-title" }, core_1.nls.localize('theia/ai/mcpConfiguration/serverConfigurations', 'MCP Server Configurations')),
            this.servers.map(server => this.renderServerCard(server))));
    }
};
exports.AIMCPConfigurationWidget = AIMCPConfigurationWidget;
AIMCPConfigurationWidget.ID = 'ai-mcp-configuration-container-widget';
AIMCPConfigurationWidget.LABEL = core_1.nls.localize('theia/ai/mcpConfiguration/widgetLabel', 'MCP Servers');
tslib_1.__decorate([
    (0, inversify_1.inject)(mcp_server_manager_1.MCPFrontendService),
    tslib_1.__metadata("design:type", Object)
], AIMCPConfigurationWidget.prototype, "mcpFrontendService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(mcp_server_manager_1.MCPFrontendNotificationService),
    tslib_1.__metadata("design:type", Object)
], AIMCPConfigurationWidget.prototype, "mcpFrontendNotificationService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(hover_service_1.HoverService),
    tslib_1.__metadata("design:type", hover_service_1.HoverService)
], AIMCPConfigurationWidget.prototype, "hoverService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.MessageService),
    tslib_1.__metadata("design:type", core_1.MessageService)
], AIMCPConfigurationWidget.prototype, "messageService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], AIMCPConfigurationWidget.prototype, "init", null);
exports.AIMCPConfigurationWidget = AIMCPConfigurationWidget = AIMCPConfigurationWidget_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], AIMCPConfigurationWidget);


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/template-settings-renderer.js":
/*!***************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/template-settings-renderer.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TemplateRenderer = void 0;
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
const DEFAULT_VARIANT = 'default';
const TemplateRenderer = ({ agentId, template, promptCustomizationService, promptService, aiSettingsService, }) => {
    const variantIds = [DEFAULT_VARIANT, ...promptService.getVariantIds(template.id)];
    const [selectedVariant, setSelectedVariant] = React.useState(DEFAULT_VARIANT);
    React.useEffect(() => {
        (async () => {
            var _a;
            const agentSettings = await aiSettingsService.getAgentSettings(agentId);
            const currentVariant = ((_a = agentSettings === null || agentSettings === void 0 ? void 0 : agentSettings.selectedVariants) === null || _a === void 0 ? void 0 : _a[template.id]) || DEFAULT_VARIANT;
            setSelectedVariant(currentVariant);
        })();
    }, [template.id, aiSettingsService, agentId]);
    const isInvalidVariant = !variantIds.includes(selectedVariant);
    const handleVariantChange = async (event) => {
        const newVariant = event.target.value;
        setSelectedVariant(newVariant);
        const agentSettings = await aiSettingsService.getAgentSettings(agentId);
        const selectedVariants = (agentSettings === null || agentSettings === void 0 ? void 0 : agentSettings.selectedVariants) || {};
        const updatedVariants = { ...selectedVariants };
        if (newVariant === DEFAULT_VARIANT) {
            delete updatedVariants[template.id];
        }
        else {
            updatedVariants[template.id] = newVariant;
        }
        await aiSettingsService.updateAgentSettings(agentId, {
            selectedVariants: updatedVariants,
        });
    };
    const openTemplate = () => {
        const templateId = selectedVariant === DEFAULT_VARIANT ? template.id : selectedVariant;
        const selectedTemplate = promptService.getRawPrompt(templateId);
        promptCustomizationService.editTemplate(templateId, (selectedTemplate === null || selectedTemplate === void 0 ? void 0 : selectedTemplate.template) || '');
    };
    const resetTemplate = () => {
        const templateId = selectedVariant === DEFAULT_VARIANT ? template.id : selectedVariant;
        promptCustomizationService.resetTemplate(templateId);
    };
    return (React.createElement("div", { className: "template-renderer" },
        React.createElement("div", { className: "settings-section-title template-header" },
            React.createElement("strong", null, template.id)),
        React.createElement("div", { className: "template-controls" },
            (variantIds.length > 1 || isInvalidVariant) && (React.createElement(React.Fragment, null,
                React.createElement("label", { htmlFor: `variant-selector-${template.id}`, className: "template-select-label" }, nls_1.nls.localize('theia/ai/core/templateSettings/selectVariant', 'Select Variant:')),
                React.createElement("select", { id: `variant-selector-${template.id}`, className: `theia-select template-variant-selector ${isInvalidVariant ? 'error' : ''}`, value: isInvalidVariant ? 'invalid' : selectedVariant, onChange: handleVariantChange },
                    isInvalidVariant && (React.createElement("option", { value: "invalid", disabled: true }, nls_1.nls.localize('theia/ai/core/templateSettings/unavailableVariant', 'The selected variant is no longer available'))),
                    variantIds.map(variantId => (React.createElement("option", { key: variantId, value: variantId }, variantId)))))),
            React.createElement("button", { className: "theia-button main", onClick: openTemplate, disabled: isInvalidVariant }, nls_1.nls.localizeByDefault('Edit')),
            React.createElement("button", { className: "theia-button secondary", onClick: resetTemplate, disabled: isInvalidVariant }, nls_1.nls.localizeByDefault('Reset')))));
};
exports.TemplateRenderer = TemplateRenderer;


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/token-usage-configuration-widget.js":
/*!*********************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/token-usage-configuration-widget.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var AITokenUsageConfigurationWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AITokenUsageConfigurationWidget = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const token_usage_frontend_service_1 = __webpack_require__(/*! @theia/ai-core/lib/browser/token-usage-frontend-service */ "../../node_modules/@theia/ai-core/lib/browser/token-usage-frontend-service.js");
const date_fns_1 = __webpack_require__(/*! date-fns */ "../../node_modules/date-fns/index.cjs");
// Using the interface from the token usage service
let AITokenUsageConfigurationWidget = AITokenUsageConfigurationWidget_1 = class AITokenUsageConfigurationWidget extends browser_1.ReactWidget {
    constructor() {
        super(...arguments);
        // Data will be fetched from the service
        this.tokenUsageData = [];
    }
    init() {
        this.id = AITokenUsageConfigurationWidget_1.ID;
        this.title.label = AITokenUsageConfigurationWidget_1.LABEL;
        this.title.closable = false;
        this.refreshData();
        this.tokenUsageService.onTokenUsageUpdated(data => {
            this.tokenUsageData = data;
            this.update();
        });
    }
    async refreshData() {
        try {
            this.tokenUsageData = await this.tokenUsageService.getTokenUsageData();
            this.update();
        }
        catch (error) {
            this.messageService.error(`Failed to fetch token usage data: ${error}`);
        }
    }
    formatNumber(num) {
        return num.toLocaleString();
    }
    formatDate(date) {
        if (!date) {
            return core_1.nls.localize('theia/ai/tokenUsage/never', 'Never');
        }
        return (0, date_fns_1.formatDistanceToNow)(date, { addSuffix: true });
    }
    hasCacheData() {
        return this.tokenUsageData.some(model => model.cachedInputTokens !== undefined ||
            model.readCachedInputTokens !== undefined);
    }
    renderHeaderRow() {
        const showCacheColumns = this.hasCacheData();
        return (React.createElement("tr", { className: "token-usage-header" },
            React.createElement("th", { className: "token-usage-model-column" }, core_1.nls.localize('theia/ai/tokenUsage/model', 'Model')),
            React.createElement("th", { className: "token-usage-column" }, core_1.nls.localize('theia/ai/tokenUsage/inputTokens', 'Input Tokens')),
            showCacheColumns && (React.createElement(React.Fragment, null,
                React.createElement("th", { className: "token-usage-column", title: core_1.nls.localize('theia/ai/tokenUsage/cachedInputTokensTooltip', "Tracked additionally to 'Input Tokens'. Usually more expensive than non-cached tokens.") }, core_1.nls.localize('theia/ai/tokenUsage/cachedInputTokens', 'Input Tokens Written to Cache')),
                React.createElement("th", { className: "token-usage-column", title: core_1.nls.localize('theia/ai/tokenUsage/readCachedInputTokensTooltip', "Tracked additionally to 'Input Token'. Usually much less expensive than not cached. Usually does not count to rate limits.") }, core_1.nls.localize('theia/ai/tokenUsage/readCachedInputTokens', 'Input Tokens Read From Cache')))),
            React.createElement("th", { className: "token-usage-column" }, core_1.nls.localize('theia/ai/tokenUsage/outputTokens', 'Output Tokens')),
            React.createElement("th", { className: "token-usage-column", title: core_1.nls.localize('theia/ai/tokenUsage/totalTokensTooltip', "'Input Tokens' + 'Output Tokens'") }, core_1.nls.localize('theia/ai/tokenUsage/totalTokens', 'Total Tokens')),
            React.createElement("th", { className: "token-usage-column" }, core_1.nls.localize('theia/ai/tokenUsage/lastUsed', 'Last Used'))));
    }
    renderModelRow(model) {
        var _a;
        const lastUsedDate = model.lastUsed ? new Date(model.lastUsed) : undefined;
        const exactDateString = lastUsedDate ? lastUsedDate.toLocaleString() : '';
        const showCacheColumns = this.hasCacheData();
        const totalTokens = model.inputTokens + model.outputTokens + ((_a = model.cachedInputTokens) !== null && _a !== void 0 ? _a : 0);
        return (React.createElement("tr", { key: model.modelId, className: "token-usage-row" },
            React.createElement("td", { className: "token-usage-model-cell" }, model.modelId),
            React.createElement("td", { className: "token-usage-cell" }, this.formatNumber(model.inputTokens)),
            showCacheColumns && (React.createElement(React.Fragment, null,
                React.createElement("td", { className: "token-usage-cell" }, model.cachedInputTokens !== undefined ? this.formatNumber(model.cachedInputTokens) : '-'),
                React.createElement("td", { className: "token-usage-cell" }, model.readCachedInputTokens !== undefined ? this.formatNumber(model.readCachedInputTokens) : '-'))),
            React.createElement("td", { className: "token-usage-cell" }, this.formatNumber(model.outputTokens)),
            React.createElement("td", { className: "token-usage-cell" }, this.formatNumber(totalTokens)),
            React.createElement("td", { className: "token-usage-cell", title: exactDateString }, this.formatDate(lastUsedDate))));
    }
    renderSummaryRow() {
        // Only show summary row if there is data
        if (this.tokenUsageData.length === 0) {
            return undefined;
        }
        const totalInputTokens = this.tokenUsageData.reduce((sum, model) => sum + model.inputTokens, 0);
        const totalOutputTokens = this.tokenUsageData.reduce((sum, model) => sum + model.outputTokens, 0);
        const totalCachedInputTokens = this.tokenUsageData.reduce((sum, model) => sum + (model.cachedInputTokens || 0), 0);
        const totalReadCachedInputTokens = this.tokenUsageData.reduce((sum, model) => sum + (model.readCachedInputTokens || 0), 0);
        const totalTokens = totalInputTokens + totalCachedInputTokens + totalOutputTokens;
        const showCacheColumns = this.hasCacheData();
        return (React.createElement("tr", { className: "token-usage-summary-row" },
            React.createElement("td", { className: "token-usage-model-cell" },
                React.createElement("strong", null, core_1.nls.localize('theia/ai/tokenUsage/total', 'Total'))),
            React.createElement("td", { className: "token-usage-cell" },
                React.createElement("strong", null, this.formatNumber(totalInputTokens))),
            showCacheColumns && (React.createElement(React.Fragment, null,
                React.createElement("td", { className: "token-usage-cell" },
                    React.createElement("strong", null, this.formatNumber(totalCachedInputTokens))),
                React.createElement("td", { className: "token-usage-cell" },
                    React.createElement("strong", null, this.formatNumber(totalReadCachedInputTokens))))),
            React.createElement("td", { className: "token-usage-cell" },
                React.createElement("strong", null, this.formatNumber(totalOutputTokens))),
            React.createElement("td", { className: "token-usage-cell" },
                React.createElement("strong", null, this.formatNumber(totalTokens))),
            React.createElement("td", { className: "token-usage-cell" })));
    }
    render() {
        return (React.createElement("div", { className: "token-usage-configuration-container" },
            React.createElement("h2", { className: "token-usage-configuration-title" }, core_1.nls.localize('theia/ai/tokenUsage/title', 'AI Model Token Usage')),
            React.createElement("div", { className: "token-usage-table-container" }, this.tokenUsageData.length > 0 ? (React.createElement("table", { className: "token-usage-table" },
                React.createElement("thead", null, this.renderHeaderRow()),
                React.createElement("tbody", null,
                    this.tokenUsageData.map(model => this.renderModelRow(model)),
                    this.renderSummaryRow()))) : (React.createElement("div", { className: "token-usage-empty" },
                React.createElement("p", null, core_1.nls.localize('theia/ai/tokenUsage/noData', 'No token usage data available yet.'))))),
            React.createElement("div", { className: "token-usage-notes" },
                React.createElement("p", { className: "token-usage-note" },
                    React.createElement("i", { className: "codicon codicon-info" }),
                    core_1.nls.localize('theia/ai/tokenUsage/note', 'Token usage is tracked since the start of the application and is not persisted.')))));
    }
};
exports.AITokenUsageConfigurationWidget = AITokenUsageConfigurationWidget;
AITokenUsageConfigurationWidget.ID = 'ai-token-usage-configuration-container-widget';
AITokenUsageConfigurationWidget.LABEL = core_1.nls.localize('theia/ai/tokenUsage/label', 'Token Usage');
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.MessageService),
    tslib_1.__metadata("design:type", core_1.MessageService)
], AITokenUsageConfigurationWidget.prototype, "messageService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(token_usage_frontend_service_1.TokenUsageFrontendService),
    tslib_1.__metadata("design:type", Object)
], AITokenUsageConfigurationWidget.prototype, "tokenUsageService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], AITokenUsageConfigurationWidget.prototype, "init", null);
exports.AITokenUsageConfigurationWidget = AITokenUsageConfigurationWidget = AITokenUsageConfigurationWidget_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], AITokenUsageConfigurationWidget);


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/variable-configuration-widget.js":
/*!******************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/variable-configuration-widget.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var AIVariableConfigurationWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AIVariableConfigurationWidget = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const common_1 = __webpack_require__(/*! @theia/ai-core/lib/common */ "../../node_modules/@theia/ai-core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const agent_configuration_widget_1 = __webpack_require__(/*! ./agent-configuration-widget */ "../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/agent-configuration-widget.js");
const ai_configuration_service_1 = __webpack_require__(/*! ./ai-configuration-service */ "../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/ai-configuration-service.js");
let AIVariableConfigurationWidget = AIVariableConfigurationWidget_1 = class AIVariableConfigurationWidget extends browser_1.ReactWidget {
    init() {
        this.id = AIVariableConfigurationWidget_1.ID;
        this.title.label = AIVariableConfigurationWidget_1.LABEL;
        this.title.closable = false;
        this.update();
        this.toDispose.push(this.variableService.onDidChangeVariables(() => this.update()));
    }
    render() {
        return React.createElement("div", { className: 'configuration-variables-list' },
            React.createElement("ul", null, this.variableService.getVariables().map(variable => React.createElement("li", { key: variable.id, className: 'variable-item' },
                React.createElement("div", { className: 'settings-section-title settings-section-category-title', style: { paddingLeft: 0, paddingBottom: 10 } }, variable.name),
                React.createElement("small", null, variable.id),
                React.createElement("small", null, variable.description),
                this.renderReferencedVariables(variable),
                this.renderArgs(variable)))));
    }
    renderReferencedVariables(variable) {
        const agents = this.getAgentsForVariable(variable);
        if (agents.length === 0) {
            return;
        }
        return React.createElement("div", null,
            React.createElement("h3", null, "Agents"),
            React.createElement("ul", { className: 'variable-references' }, agents.map(agent => React.createElement("li", { key: agent.id, className: 'theia-TreeNode theia-CompositeTreeNode theia-ExpandableTreeNode theia-mod-selected' },
                React.createElement("div", { onClick: () => { this.showAgentConfiguration(agent); }, className: 'variable-reference' },
                    React.createElement("span", null, agent.name),
                    React.createElement("i", { className: (0, browser_1.codicon)('chevron-right') }))))));
    }
    renderArgs(variable) {
        if (variable.args === undefined || variable.args.length === 0) {
            return;
        }
        return React.createElement("div", { className: 'variable-args-container' },
            React.createElement("h3", null, "Variable Arguments"),
            React.createElement("div", { className: 'variable-args' }, variable.args.map(arg => React.createElement(React.Fragment, { key: arg.name },
                React.createElement("span", null, arg.name),
                React.createElement("small", null, arg.description)))));
    }
    showAgentConfiguration(agent) {
        this.aiConfigurationSelectionService.setActiveAgent(agent);
        this.aiConfigurationSelectionService.selectConfigurationTab(agent_configuration_widget_1.AIAgentConfigurationWidget.ID);
    }
    getAgentsForVariable(variable) {
        return this.agentService.getAgents().filter(a => { var _a; return (_a = a.variables) === null || _a === void 0 ? void 0 : _a.includes(variable.id); });
    }
};
exports.AIVariableConfigurationWidget = AIVariableConfigurationWidget;
AIVariableConfigurationWidget.ID = 'ai-variable-configuration-container-widget';
AIVariableConfigurationWidget.LABEL = 'Variables';
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.AIVariableService),
    tslib_1.__metadata("design:type", Object)
], AIVariableConfigurationWidget.prototype, "variableService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.AgentService),
    tslib_1.__metadata("design:type", Object)
], AIVariableConfigurationWidget.prototype, "agentService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_configuration_service_1.AIConfigurationSelectionService),
    tslib_1.__metadata("design:type", ai_configuration_service_1.AIConfigurationSelectionService)
], AIVariableConfigurationWidget.prototype, "aiConfigurationSelectionService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], AIVariableConfigurationWidget.prototype, "init", null);
exports.AIVariableConfigurationWidget = AIVariableConfigurationWidget = AIVariableConfigurationWidget_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], AIVariableConfigurationWidget);


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/browser/architect-agent.js":
/*!***********************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/browser/architect-agent.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ArchitectAgent = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
const common_1 = __webpack_require__(/*! @theia/ai-chat/lib/common */ "../../node_modules/@theia/ai-chat/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const architect_prompt_template_1 = __webpack_require__(/*! ../common/architect-prompt-template */ "../../node_modules/@theia/ai-ide/lib/common/architect-prompt-template.js");
const workspace_functions_1 = __webpack_require__(/*! ../common/workspace-functions */ "../../node_modules/@theia/ai-ide/lib/common/workspace-functions.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const markdown_rendering_1 = __webpack_require__(/*! @theia/core/lib/common/markdown-rendering */ "../../node_modules/@theia/core/lib/common/markdown-rendering/index.js");
const summarize_session_commands_1 = __webpack_require__(/*! ../common/summarize-session-commands */ "../../node_modules/@theia/ai-ide/lib/common/summarize-session-commands.js");
let ArchitectAgent = class ArchitectAgent extends common_1.AbstractStreamParsingChatAgent {
    constructor() {
        super(...arguments);
        this.name = 'Architect';
        this.id = 'Architect';
        this.languageModelRequirements = [{
                purpose: 'chat',
                identifier: 'openai/gpt-4o',
            }];
        this.defaultLanguageModelPurpose = 'chat';
        this.description = core_1.nls.localize('theia/ai/workspace/workspaceAgent/description', 'An AI assistant integrated into Theia IDE, designed to assist software developers. This agent can access the users workspace, it can get a list of all available files \
         and folders and retrieve their content. It cannot modify files. It can therefore answer questions about the current project, project files and source code in the \
         workspace, such as how to build the project, where to put source code, where to find specific code or configurations, etc.');
        this.promptTemplates = [architect_prompt_template_1.architectPromptTemplate, architect_prompt_template_1.architectTaskSummaryPromptTemplate];
        this.functions = [workspace_functions_1.GET_WORKSPACE_FILE_LIST_FUNCTION_ID, workspace_functions_1.FILE_CONTENT_FUNCTION_ID];
        this.systemPromptId = architect_prompt_template_1.architectPromptTemplate.id;
    }
    async invoke(request) {
        await super.invoke(request);
        this.suggest(request);
    }
    async suggest(context) {
        const model = common_1.ChatRequestModel.is(context) ? context.session : context.model;
        const session = this.chatService.getSessions().find(candidate => candidate.model.id === model.id);
        if (!(model instanceof common_1.MutableChatModel) || !session) {
            return;
        }
        if (!model.isEmpty()) {
            model.setSuggestions([new markdown_rendering_1.MarkdownStringImpl(`[Summarize this session as a task for Coder](command:${summarize_session_commands_1.AI_SUMMARIZE_SESSION_AS_TASK_FOR_CODER.id}).`)]);
        }
    }
};
exports.ArchitectAgent = ArchitectAgent;
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.ChatService),
    tslib_1.__metadata("design:type", Object)
], ArchitectAgent.prototype, "chatService", void 0);
exports.ArchitectAgent = ArchitectAgent = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ArchitectAgent);


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/browser/coder-agent.js":
/*!*******************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/browser/coder-agent.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CoderAgent = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
const common_1 = __webpack_require__(/*! @theia/ai-chat/lib/common */ "../../node_modules/@theia/ai-chat/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const workspace_functions_1 = __webpack_require__(/*! ../common/workspace-functions */ "../../node_modules/@theia/ai-ide/lib/common/workspace-functions.js");
const coder_replace_prompt_template_1 = __webpack_require__(/*! ../common/coder-replace-prompt-template */ "../../node_modules/@theia/ai-ide/lib/common/coder-replace-prompt-template.js");
const file_changeset_functions_1 = __webpack_require__(/*! ./file-changeset-functions */ "../../node_modules/@theia/ai-ide/lib/browser/file-changeset-functions.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const markdown_rendering_1 = __webpack_require__(/*! @theia/core/lib/common/markdown-rendering */ "../../node_modules/@theia/core/lib/common/markdown-rendering/index.js");
const chat_view_commands_1 = __webpack_require__(/*! @theia/ai-chat-ui/lib/browser/chat-view-commands */ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-view-commands.js");
let CoderAgent = class CoderAgent extends common_1.AbstractStreamParsingChatAgent {
    constructor() {
        super(...arguments);
        this.id = 'Coder';
        this.name = 'Coder';
        this.languageModelRequirements = [{
                purpose: 'chat',
                identifier: 'openai/gpt-4o',
            }];
        this.defaultLanguageModelPurpose = 'chat';
        this.description = core_1.nls.localize('theia/ai/workspace/coderAgent/description', 'An AI assistant integrated into Theia IDE, designed to assist software developers. This agent can access the users workspace, it can get a list of all available files \
        and folders and retrieve their content. Futhermore, it can suggest modifications of files to the user. It can therefore assist the user with coding tasks or other \
        tasks involving file changes.');
        this.promptTemplates = [(0, coder_replace_prompt_template_1.getCoderReplacePromptTemplate)(true), (0, coder_replace_prompt_template_1.getCoderReplacePromptTemplate)(false), (0, coder_replace_prompt_template_1.getCoderReplacePromptTemplateNext)()];
        this.functions = [workspace_functions_1.GET_WORKSPACE_DIRECTORY_STRUCTURE_FUNCTION_ID, workspace_functions_1.GET_WORKSPACE_FILE_LIST_FUNCTION_ID, workspace_functions_1.FILE_CONTENT_FUNCTION_ID, file_changeset_functions_1.WriteChangeToFileProvider.ID];
        this.systemPromptId = coder_replace_prompt_template_1.CODER_REPLACE_PROMPT_TEMPLATE_ID;
    }
    async invoke(request) {
        await super.invoke(request);
        this.suggest(request);
    }
    async suggest(context) {
        const contextIsRequest = common_1.ChatRequestModel.is(context);
        const model = contextIsRequest ? context.session : context.model;
        const session = contextIsRequest ? this.chatService.getSessions().find(candidate => candidate.model.id === model.id) : context;
        if (!(model instanceof common_1.MutableChatModel) || !session) {
            return;
        }
        if (model.isEmpty()) {
            model.setSuggestions([
                {
                    kind: 'callback',
                    callback: () => this.chatService.sendRequest(session.id, { text: '@Coder please look at #_f and fix any problems.' }),
                    content: '[Fix problems](_callback) in the current file.'
                },
            ]);
        }
        else {
            model.setSuggestions([new markdown_rendering_1.MarkdownStringImpl(`Keep chats short and focused. [Start a new chat](command:${chat_view_commands_1.AI_CHAT_NEW_CHAT_WINDOW_COMMAND.id}) for a new task`
                    + ` or [start a new chat with a summary of this one](command:${chat_view_commands_1.ChatCommands.AI_CHAT_NEW_WITH_TASK_CONTEXT.id}).`)]);
        }
    }
};
exports.CoderAgent = CoderAgent;
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.ChatService),
    tslib_1.__metadata("design:type", Object)
], CoderAgent.prototype, "chatService", void 0);
exports.CoderAgent = CoderAgent = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], CoderAgent);


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/browser/context-functions.js":
/*!*************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/browser/context-functions.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var ListChatContext_1, ResolveChatContext_1, AddFileToChatContext_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AddFileToChatContext = exports.ResolveChatContext = exports.ListChatContext = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const context_functions_1 = __webpack_require__(/*! ../common/context-functions */ "../../node_modules/@theia/ai-ide/lib/common/context-functions.js");
const file_variable_contribution_1 = __webpack_require__(/*! @theia/ai-core/lib/browser/file-variable-contribution */ "../../node_modules/@theia/ai-core/lib/browser/file-variable-contribution.js");
let ListChatContext = ListChatContext_1 = class ListChatContext {
    getTool() {
        return {
            id: ListChatContext_1.ID,
            name: ListChatContext_1.ID,
            description: 'Returns the list of context elements (such as files) specified by the user manually as part of the chat request.',
            handler: async (_, ctx) => {
                const result = ctx.context.variables.map(contextElement => ({
                    id: contextElement.variable.id + contextElement.arg,
                    type: contextElement.variable.name
                }));
                return JSON.stringify(result, undefined, 2);
            },
            parameters: {
                type: 'object',
                properties: {}
            },
        };
    }
};
exports.ListChatContext = ListChatContext;
ListChatContext.ID = context_functions_1.LIST_CHAT_CONTEXT_FUNCTION_ID;
exports.ListChatContext = ListChatContext = ListChatContext_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ListChatContext);
let ResolveChatContext = ResolveChatContext_1 = class ResolveChatContext {
    getTool() {
        return {
            id: ResolveChatContext_1.ID,
            name: ResolveChatContext_1.ID,
            description: 'Returns the content of a specific context element (such as files) specified by the user manually as part of the chat request.',
            parameters: {
                type: 'object',
                properties: {
                    contextElementId: {
                        type: 'string',
                        description: 'The id of the context element to resolve.'
                    }
                },
                required: ['contextElementId']
            },
            handler: async (args, ctx) => {
                const { contextElementId } = JSON.parse(args);
                const variable = ctx.context.variables.find(contextElement => contextElement.variable.id + contextElement.arg === contextElementId);
                if (variable) {
                    const result = {
                        type: variable.variable.name,
                        ref: variable.value,
                        content: variable.contextValue
                    };
                    return JSON.stringify(result, undefined, 2);
                }
                return JSON.stringify({ error: 'Context element not found' }, undefined, 2);
            }
        };
    }
};
exports.ResolveChatContext = ResolveChatContext;
ResolveChatContext.ID = context_functions_1.RESOLVE_CHAT_CONTEXT_FUNCTION_ID;
exports.ResolveChatContext = ResolveChatContext = ResolveChatContext_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ResolveChatContext);
let AddFileToChatContext = AddFileToChatContext_1 = class AddFileToChatContext {
    getTool() {
        return {
            id: AddFileToChatContext_1.ID,
            name: AddFileToChatContext_1.ID,
            parameters: {
                type: 'object',
                properties: {
                    filesToAdd: {
                        type: 'array',
                        description: 'The absolute paths of files to add to the context of the current chat.',
                        items: { type: 'string' }
                    }
                },
                required: ['filesToAdd']
            },
            description: 'Adds one or more files to the context of the current chat session, and returns the current list of files in the context.',
            handler: async (arg, ctx) => {
                const { filesToAdd } = JSON.parse(arg);
                ctx.session.context.addVariables(...filesToAdd.map(file => ({ arg: file, variable: file_variable_contribution_1.FILE_VARIABLE })));
                const result = ctx.session.context.getVariables().filter(candidate => candidate.variable.id === file_variable_contribution_1.FILE_VARIABLE.id && !!candidate.arg)
                    .map(fileRequest => fileRequest.arg);
                return JSON.stringify(result);
            }
        };
    }
};
exports.AddFileToChatContext = AddFileToChatContext;
AddFileToChatContext.ID = context_functions_1.UPDATE_CONTEXT_FILES_FUNCTION_ID;
exports.AddFileToChatContext = AddFileToChatContext = AddFileToChatContext_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], AddFileToChatContext);


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/browser/file-changeset-functions.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/browser/file-changeset-functions.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

var WriteChangeToFileProvider_1, SimpleReplaceContentInFileProvider_1, ReplaceContentInFileProvider_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ReplaceContentInFileProvider = exports.SimpleReplaceContentInFileProvider = exports.ReplaceContentInFileFunctionHelper = exports.WriteChangeToFileProvider = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const workspace_functions_1 = __webpack_require__(/*! ./workspace-functions */ "../../node_modules/@theia/ai-ide/lib/browser/workspace-functions.js");
const change_set_file_element_1 = __webpack_require__(/*! @theia/ai-chat/lib/browser/change-set-file-element */ "../../node_modules/@theia/ai-chat/lib/browser/change-set-file-element.js");
const ai_chat_1 = __webpack_require__(/*! @theia/ai-chat */ "../../node_modules/@theia/ai-chat/lib/common/index.js");
const file_service_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/file-service */ "../../node_modules/@theia/filesystem/lib/browser/file-service.js");
const content_replacer_1 = __webpack_require__(/*! @theia/core/lib/common/content-replacer */ "../../node_modules/@theia/core/lib/common/content-replacer.js");
let WriteChangeToFileProvider = WriteChangeToFileProvider_1 = class WriteChangeToFileProvider {
    getTool() {
        return {
            id: WriteChangeToFileProvider_1.ID,
            name: WriteChangeToFileProvider_1.ID,
            description: `Proposes writing content to a file. If the file exists, it will be overwritten with the provided content.\n
             If the file does not exist, it will be created. This tool will automatically create any directories needed to write the file.\n
             If the new content is empty, the file will be deleted. To move a file, delete it and re-create it at the new location.\n
             The proposed changes will be applied when the user accepts. If called again for the same file, previously proposed changes will be overridden.`,
            parameters: {
                type: 'object',
                properties: {
                    path: {
                        type: 'string',
                        description: 'The path of the file to write to.'
                    },
                    content: {
                        type: 'string',
                        description: `The content to write to the file. ALWAYS provide the COMPLETE intended content of the file, without any truncation or omissions.\n
                         You MUST include ALL parts of the file, even if they haven\'t been modified.`
                    }
                },
                required: ['path', 'content']
            },
            handler: async (args, ctx) => {
                const { path, content } = JSON.parse(args);
                const chatSessionId = ctx.session.id;
                let changeSet = ctx.session.changeSet;
                if (!changeSet) {
                    changeSet = new ai_chat_1.ChangeSetImpl('Changes proposed by Coder');
                    ctx.session.setChangeSet(changeSet);
                }
                const uri = await this.workspaceFunctionScope.resolveRelativePath(path);
                let type = 'modify';
                if (content === '') {
                    type = 'delete';
                }
                if (!await this.fileService.exists(uri)) {
                    type = 'add';
                }
                changeSet.addElements(this.fileChangeFactory({
                    uri: uri,
                    type: type,
                    state: 'pending',
                    targetState: content,
                    changeSet,
                    chatSessionId
                }));
                return `Proposed writing to file ${path}. The user will review and potentially apply the changes`;
            }
        };
    }
};
exports.WriteChangeToFileProvider = WriteChangeToFileProvider;
WriteChangeToFileProvider.ID = 'changeSet_writeChangeToFile';
tslib_1.__decorate([
    (0, inversify_1.inject)(workspace_functions_1.WorkspaceFunctionScope),
    tslib_1.__metadata("design:type", workspace_functions_1.WorkspaceFunctionScope)
], WriteChangeToFileProvider.prototype, "workspaceFunctionScope", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    tslib_1.__metadata("design:type", file_service_1.FileService)
], WriteChangeToFileProvider.prototype, "fileService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(change_set_file_element_1.ChangeSetFileElementFactory),
    tslib_1.__metadata("design:type", Function)
], WriteChangeToFileProvider.prototype, "fileChangeFactory", void 0);
exports.WriteChangeToFileProvider = WriteChangeToFileProvider = WriteChangeToFileProvider_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], WriteChangeToFileProvider);
let ReplaceContentInFileFunctionHelper = class ReplaceContentInFileFunctionHelper {
    constructor() {
        this.replacer = new content_replacer_1.ContentReplacer();
    }
    getToolMetadata(supportMutipleReplace = false) {
        const replacementProperties = {
            oldContent: {
                type: 'string',
                description: 'The exact content to be replaced. Must match exactly, including whitespace, comments, etc.'
            },
            newContent: {
                type: 'string',
                description: 'The new content to insert in place of matched old content.'
            }
        };
        if (supportMutipleReplace) {
            replacementProperties.multiple = {
                type: 'boolean',
                description: 'Set to true if multiple occurrences of the oldContent are expected to be replaced.'
            };
        }
        const replacementParameters = {
            type: 'object',
            properties: {
                path: {
                    type: 'string',
                    description: 'The path of the file where content will be replaced.'
                },
                replacements: {
                    type: 'array',
                    items: {
                        type: 'object',
                        properties: replacementProperties,
                        required: ['oldContent', 'newContent']
                    },
                    description: 'An array of replacement objects, each containing oldContent and newContent strings.'
                }
            },
            required: ['path', 'replacements']
        };
        const replacementSentence = supportMutipleReplace
            ? 'By default, a single occurrence of each old content in the tuples is expected to be replaced. If the optional \'multiple\' flag is set to true, all occurrences will\
             be replaced. In either case, if the number of occurrences in the file does not match the expectation the function will return an error. \
             In that case try a different approach.'
            : 'A single occurrence of each old content in the tuples is expected to be replaced. If the number of occurrences in the file does not match the expectation,\
              the function will return an error. In that case try a different approach.';
        const replacementDescription = `Propose to replace sections of content in an existing file by providing a list of tuples with old content to be matched and replaced.
            ${replacementSentence}. For deletions, use an empty new content in the tuple.\
            Make sure you use the same line endings and whitespace as in the original file content. The proposed changes will be applied when the user accepts.\
            If called again for the same file, it will override previous change proposals for this file. So you must ultimatly call this function only once per file with a tuple\
            containing all proposed changes for this file`;
        return {
            description: replacementDescription,
            parameters: replacementParameters
        };
    }
    async createChangesetFromToolCall(toolCallString, ctx) {
        try {
            const { path, replacements } = JSON.parse(toolCallString);
            const fileUri = await this.workspaceFunctionScope.resolveRelativePath(path);
            const fileContent = (await this.fileService.read(fileUri)).value.toString();
            const { updatedContent, errors } = this.replacer.applyReplacements(fileContent, replacements);
            if (errors.length > 0) {
                return `Errors encountered: ${errors.join('; ')}`;
            }
            if (updatedContent !== fileContent) {
                let changeSet = ctx.session.changeSet;
                if (!changeSet) {
                    changeSet = new ai_chat_1.ChangeSetImpl('Changes proposed by Coder');
                    ctx.session.setChangeSet(changeSet);
                }
                changeSet.addElements(this.fileChangeFactory({
                    uri: fileUri,
                    type: 'modify',
                    state: 'pending',
                    targetState: updatedContent,
                    changeSet,
                    chatSessionId: ctx.session.id
                }));
            }
            return `Proposed replacements in file ${path}. The user will review and potentially apply the changes.`;
        }
        catch (error) {
            console.debug('Error processing replacements:', error.message);
            return JSON.stringify({ error: error.message });
        }
    }
};
exports.ReplaceContentInFileFunctionHelper = ReplaceContentInFileFunctionHelper;
tslib_1.__decorate([
    (0, inversify_1.inject)(workspace_functions_1.WorkspaceFunctionScope),
    tslib_1.__metadata("design:type", workspace_functions_1.WorkspaceFunctionScope)
], ReplaceContentInFileFunctionHelper.prototype, "workspaceFunctionScope", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    tslib_1.__metadata("design:type", file_service_1.FileService)
], ReplaceContentInFileFunctionHelper.prototype, "fileService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(change_set_file_element_1.ChangeSetFileElementFactory),
    tslib_1.__metadata("design:type", Function)
], ReplaceContentInFileFunctionHelper.prototype, "fileChangeFactory", void 0);
exports.ReplaceContentInFileFunctionHelper = ReplaceContentInFileFunctionHelper = tslib_1.__decorate([
    (0, inversify_1.injectable)(),
    tslib_1.__metadata("design:paramtypes", [])
], ReplaceContentInFileFunctionHelper);
let SimpleReplaceContentInFileProvider = SimpleReplaceContentInFileProvider_1 = class SimpleReplaceContentInFileProvider {
    getTool() {
        const metadata = this.replaceContentInFileFunctionHelper.getToolMetadata();
        return {
            id: SimpleReplaceContentInFileProvider_1.ID,
            name: SimpleReplaceContentInFileProvider_1.ID,
            description: metadata.description,
            parameters: metadata.parameters,
            handler: async (args, ctx) => this.replaceContentInFileFunctionHelper.createChangesetFromToolCall(args, ctx)
        };
    }
};
exports.SimpleReplaceContentInFileProvider = SimpleReplaceContentInFileProvider;
SimpleReplaceContentInFileProvider.ID = 'changeSet_replaceContentInFilev1';
tslib_1.__decorate([
    (0, inversify_1.inject)(ReplaceContentInFileFunctionHelper),
    tslib_1.__metadata("design:type", ReplaceContentInFileFunctionHelper)
], SimpleReplaceContentInFileProvider.prototype, "replaceContentInFileFunctionHelper", void 0);
exports.SimpleReplaceContentInFileProvider = SimpleReplaceContentInFileProvider = SimpleReplaceContentInFileProvider_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], SimpleReplaceContentInFileProvider);
let ReplaceContentInFileProvider = ReplaceContentInFileProvider_1 = class ReplaceContentInFileProvider {
    getTool() {
        const metadata = this.replaceContentInFileFunctionHelper.getToolMetadata(true);
        return {
            id: ReplaceContentInFileProvider_1.ID,
            name: ReplaceContentInFileProvider_1.ID,
            description: metadata.description,
            parameters: metadata.parameters,
            handler: async (args, ctx) => this.replaceContentInFileFunctionHelper.createChangesetFromToolCall(args, ctx)
        };
    }
};
exports.ReplaceContentInFileProvider = ReplaceContentInFileProvider;
ReplaceContentInFileProvider.ID = 'changeSet_replaceContentInFile';
tslib_1.__decorate([
    (0, inversify_1.inject)(ReplaceContentInFileFunctionHelper),
    tslib_1.__metadata("design:type", ReplaceContentInFileFunctionHelper)
], ReplaceContentInFileProvider.prototype, "replaceContentInFileFunctionHelper", void 0);
exports.ReplaceContentInFileProvider = ReplaceContentInFileProvider = ReplaceContentInFileProvider_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ReplaceContentInFileProvider);


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/browser/frontend-module.js":
/*!***********************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/browser/frontend-module.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! @theia/ai-chat/lib/common */ "../../node_modules/@theia/ai-chat/lib/common/index.js");
const common_2 = __webpack_require__(/*! @theia/ai-core/lib/common */ "../../node_modules/@theia/ai-core/lib/common/index.js");
const architect_agent_1 = __webpack_require__(/*! ./architect-agent */ "../../node_modules/@theia/ai-ide/lib/browser/architect-agent.js");
const coder_agent_1 = __webpack_require__(/*! ./coder-agent */ "../../node_modules/@theia/ai-ide/lib/browser/coder-agent.js");
const summarize_session_command_contribution_1 = __webpack_require__(/*! ./summarize-session-command-contribution */ "../../node_modules/@theia/ai-ide/lib/browser/summarize-session-command-contribution.js");
const workspace_functions_1 = __webpack_require__(/*! ./workspace-functions */ "../../node_modules/@theia/ai-ide/lib/browser/workspace-functions.js");
const workspace_search_provider_1 = __webpack_require__(/*! ./workspace-search-provider */ "../../node_modules/@theia/ai-ide/lib/browser/workspace-search-provider.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const workspace_task_provider_1 = __webpack_require__(/*! ./workspace-task-provider */ "../../node_modules/@theia/ai-ide/lib/browser/workspace-task-provider.js");
const workspace_preferences_1 = __webpack_require__(/*! ./workspace-preferences */ "../../node_modules/@theia/ai-ide/lib/browser/workspace-preferences.js");
const file_changeset_functions_1 = __webpack_require__(/*! ./file-changeset-functions */ "../../node_modules/@theia/ai-ide/lib/browser/file-changeset-functions.js");
const orchestrator_chat_agent_1 = __webpack_require__(/*! ../common/orchestrator-chat-agent */ "../../node_modules/@theia/ai-ide/lib/common/orchestrator-chat-agent.js");
const universal_chat_agent_1 = __webpack_require__(/*! ../common/universal-chat-agent */ "../../node_modules/@theia/ai-ide/lib/common/universal-chat-agent.js");
const command_chat_agents_1 = __webpack_require__(/*! ../common/command-chat-agents */ "../../node_modules/@theia/ai-ide/lib/common/command-chat-agents.js");
const context_functions_1 = __webpack_require__(/*! ./context-functions */ "../../node_modules/@theia/ai-ide/lib/browser/context-functions.js");
const agent_configuration_widget_1 = __webpack_require__(/*! ./ai-configuration/agent-configuration-widget */ "../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/agent-configuration-widget.js");
const ai_configuration_service_1 = __webpack_require__(/*! ./ai-configuration/ai-configuration-service */ "../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/ai-configuration-service.js");
const ai_configuration_view_contribution_1 = __webpack_require__(/*! ./ai-configuration/ai-configuration-view-contribution */ "../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/ai-configuration-view-contribution.js");
const ai_configuration_widget_1 = __webpack_require__(/*! ./ai-configuration/ai-configuration-widget */ "../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/ai-configuration-widget.js");
const variable_configuration_widget_1 = __webpack_require__(/*! ./ai-configuration/variable-configuration-widget */ "../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/variable-configuration-widget.js");
const context_files_variable_1 = __webpack_require__(/*! ../common/context-files-variable */ "../../node_modules/@theia/ai-ide/lib/common/context-files-variable.js");
const tab_bar_toolbar_1 = __webpack_require__(/*! @theia/core/lib/browser/shell/tab-bar-toolbar */ "../../node_modules/@theia/core/lib/browser/shell/tab-bar-toolbar/index.js");
const ai_configuration_preferences_1 = __webpack_require__(/*! ./ai-configuration/ai-configuration-preferences */ "../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/ai-configuration-preferences.js");
const template_preference_contribution_1 = __webpack_require__(/*! ./template-preference-contribution */ "../../node_modules/@theia/ai-ide/lib/browser/template-preference-contribution.js");
const mcp_configuration_widget_1 = __webpack_require__(/*! ./ai-configuration/mcp-configuration-widget */ "../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/mcp-configuration-widget.js");
const chat_tree_view_1 = __webpack_require__(/*! @theia/ai-chat-ui/lib/browser/chat-tree-view */ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-tree-view/index.js");
const ide_chat_welcome_message_provider_1 = __webpack_require__(/*! ./ide-chat-welcome-message-provider */ "../../node_modules/@theia/ai-ide/lib/browser/ide-chat-welcome-message-provider.js");
const token_usage_configuration_widget_1 = __webpack_require__(/*! ./ai-configuration/token-usage-configuration-widget */ "../../node_modules/@theia/ai-ide/lib/browser/ai-configuration/token-usage-configuration-widget.js");
const task_background_summary_variable_1 = __webpack_require__(/*! ./task-background-summary-variable */ "../../node_modules/@theia/ai-ide/lib/browser/task-background-summary-variable.js");
const task_context_file_storage_service_1 = __webpack_require__(/*! ./task-context-file-storage-service */ "../../node_modules/@theia/ai-ide/lib/browser/task-context-file-storage-service.js");
const task_context_service_1 = __webpack_require__(/*! @theia/ai-chat/lib/browser/task-context-service */ "../../node_modules/@theia/ai-chat/lib/browser/task-context-service.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
exports["default"] = new inversify_1.ContainerModule((bind, _unbind, _isBound, rebind) => {
    bind(browser_1.PreferenceContribution).toConstantValue({ schema: workspace_preferences_1.WorkspacePreferencesSchema });
    bind(architect_agent_1.ArchitectAgent).toSelf().inSingletonScope();
    bind(common_2.Agent).toService(architect_agent_1.ArchitectAgent);
    bind(common_1.ChatAgent).toService(architect_agent_1.ArchitectAgent);
    bind(coder_agent_1.CoderAgent).toSelf().inSingletonScope();
    bind(common_2.Agent).toService(coder_agent_1.CoderAgent);
    bind(common_1.ChatAgent).toService(coder_agent_1.CoderAgent);
    bind(orchestrator_chat_agent_1.OrchestratorChatAgent).toSelf().inSingletonScope();
    bind(common_2.Agent).toService(orchestrator_chat_agent_1.OrchestratorChatAgent);
    bind(common_1.ChatAgent).toService(orchestrator_chat_agent_1.OrchestratorChatAgent);
    bind(universal_chat_agent_1.UniversalChatAgent).toSelf().inSingletonScope();
    bind(common_2.Agent).toService(universal_chat_agent_1.UniversalChatAgent);
    bind(common_1.ChatAgent).toService(universal_chat_agent_1.UniversalChatAgent);
    bind(command_chat_agents_1.CommandChatAgent).toSelf().inSingletonScope();
    bind(common_2.Agent).toService(command_chat_agents_1.CommandChatAgent);
    bind(common_1.ChatAgent).toService(command_chat_agents_1.CommandChatAgent);
    bind(common_1.DefaultChatAgentId).toConstantValue({ id: orchestrator_chat_agent_1.OrchestratorChatAgentId });
    bind(common_1.FallbackChatAgentId).toConstantValue({ id: universal_chat_agent_1.UniversalChatAgentId });
    bind(chat_tree_view_1.ChatWelcomeMessageProvider).to(ide_chat_welcome_message_provider_1.IdeChatWelcomeMessageProvider);
    (0, common_2.bindToolProvider)(workspace_functions_1.GetWorkspaceFileList, bind);
    (0, common_2.bindToolProvider)(workspace_functions_1.FileContentFunction, bind);
    (0, common_2.bindToolProvider)(workspace_functions_1.GetWorkspaceDirectoryStructure, bind);
    (0, common_2.bindToolProvider)(workspace_functions_1.FileDiagonsticProvider, bind);
    bind(workspace_functions_1.WorkspaceFunctionScope).toSelf().inSingletonScope();
    (0, common_2.bindToolProvider)(workspace_search_provider_1.WorkspaceSearchProvider, bind);
    (0, common_2.bindToolProvider)(file_changeset_functions_1.WriteChangeToFileProvider, bind);
    (0, common_2.bindToolProvider)(workspace_task_provider_1.TaskListProvider, bind);
    (0, common_2.bindToolProvider)(workspace_task_provider_1.TaskRunnerProvider, bind);
    bind(file_changeset_functions_1.ReplaceContentInFileFunctionHelper).toSelf().inSingletonScope();
    (0, common_2.bindToolProvider)(file_changeset_functions_1.ReplaceContentInFileProvider, bind);
    (0, common_2.bindToolProvider)(context_functions_1.ListChatContext, bind);
    (0, common_2.bindToolProvider)(context_functions_1.ResolveChatContext, bind);
    bind(ai_configuration_service_1.AIConfigurationSelectionService).toSelf().inSingletonScope();
    bind(ai_configuration_widget_1.AIConfigurationContainerWidget).toSelf();
    bind(browser_1.WidgetFactory)
        .toDynamicValue(ctx => ({
        id: ai_configuration_widget_1.AIConfigurationContainerWidget.ID,
        createWidget: () => ctx.container.get(ai_configuration_widget_1.AIConfigurationContainerWidget)
    }))
        .inSingletonScope();
    (0, browser_1.bindViewContribution)(bind, ai_configuration_view_contribution_1.AIAgentConfigurationViewContribution);
    bind(tab_bar_toolbar_1.TabBarToolbarContribution).toService(ai_configuration_view_contribution_1.AIAgentConfigurationViewContribution);
    bind(variable_configuration_widget_1.AIVariableConfigurationWidget).toSelf();
    bind(browser_1.WidgetFactory)
        .toDynamicValue(ctx => ({
        id: variable_configuration_widget_1.AIVariableConfigurationWidget.ID,
        createWidget: () => ctx.container.get(variable_configuration_widget_1.AIVariableConfigurationWidget)
    }))
        .inSingletonScope();
    bind(agent_configuration_widget_1.AIAgentConfigurationWidget).toSelf();
    bind(browser_1.WidgetFactory)
        .toDynamicValue(ctx => ({
        id: agent_configuration_widget_1.AIAgentConfigurationWidget.ID,
        createWidget: () => ctx.container.get(agent_configuration_widget_1.AIAgentConfigurationWidget)
    }))
        .inSingletonScope();
    (0, common_2.bindToolProvider)(file_changeset_functions_1.SimpleReplaceContentInFileProvider, bind);
    (0, common_2.bindToolProvider)(context_functions_1.AddFileToChatContext, bind);
    bind(common_2.AIVariableContribution).to(context_files_variable_1.ContextFilesVariableContribution).inSingletonScope();
    bind(browser_1.PreferenceContribution).toConstantValue({ schema: ai_configuration_preferences_1.AiConfigurationPreferences });
    bind(browser_1.FrontendApplicationContribution).to(template_preference_contribution_1.TemplatePreferenceContribution);
    bind(mcp_configuration_widget_1.AIMCPConfigurationWidget).toSelf();
    bind(browser_1.WidgetFactory)
        .toDynamicValue(ctx => ({
        id: mcp_configuration_widget_1.AIMCPConfigurationWidget.ID,
        createWidget: () => ctx.container.get(mcp_configuration_widget_1.AIMCPConfigurationWidget)
    }))
        .inSingletonScope();
    // Register the token usage configuration widget
    bind(token_usage_configuration_widget_1.AITokenUsageConfigurationWidget).toSelf();
    bind(browser_1.WidgetFactory)
        .toDynamicValue(ctx => ({
        id: token_usage_configuration_widget_1.AITokenUsageConfigurationWidget.ID,
        createWidget: () => ctx.container.get(token_usage_configuration_widget_1.AITokenUsageConfigurationWidget)
    }))
        .inSingletonScope();
    bind(task_background_summary_variable_1.TaskContextSummaryVariableContribution).toSelf().inSingletonScope();
    bind(common_2.AIVariableContribution).toService(task_background_summary_variable_1.TaskContextSummaryVariableContribution);
    bind(task_context_file_storage_service_1.TaskContextFileStorageService).toSelf().inSingletonScope();
    rebind(task_context_service_1.TaskContextStorageService).toService(task_context_file_storage_service_1.TaskContextFileStorageService);
    bind(core_1.CommandContribution).to(summarize_session_command_contribution_1.SummarizeSessionCommandContribution);
});


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/browser/ide-chat-welcome-message-provider.js":
/*!*****************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/browser/ide-chat-welcome-message-provider.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.IdeChatWelcomeMessageProvider = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const chat_tree_view_1 = __webpack_require__(/*! @theia/ai-chat-ui/lib/browser/chat-tree-view */ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-tree-view/index.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const TheiaIdeAiLogo = ({ width = 200, height = 200, className = '' }) => React.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 200 200", width: width, height: height, className: className },
    React.createElement("rect", { x: "55", y: "45", width: "90", height: "85", rx: "30", fill: "var(--theia-disabledForeground)" }),
    React.createElement("line", { x1: "100", y1: "45", x2: "100", y2: "30", stroke: "var(--theia-foreground)", strokeWidth: "4" }),
    React.createElement("circle", { cx: "100", cy: "25", r: "6", fill: "var(--theia-foreground)" }),
    React.createElement("rect", { x: "40", y: "75", width: "15", height: "30", rx: "5", fill: "var(--theia-foreground)" }),
    React.createElement("rect", { x: "145", y: "75", width: "15", height: "30", rx: "5", fill: "var(--theia-foreground)" }),
    React.createElement("circle", { cx: "80", cy: "80", r: "10", fill: "var(--theia-editor-background)" }),
    React.createElement("circle", { cx: "120", cy: "80", r: "10", fill: "var(--theia-editor-background)" }),
    React.createElement("path", { d: "M85 105 Q100 120 115 105", fill: "none", stroke: "var(--theia-editor-background)", strokeWidth: "4", strokeLinecap: "round" }),
    React.createElement("rect", { x: "55", y: "135", width: "90", height: "30", rx: "5", fill: "var(--theia-foreground)" }),
    React.createElement("rect", { x: "60", y: "140", width: "10", height: "8", rx: "2", fill: "var(--theia-editor-background)" }),
    React.createElement("rect", { x: "75", y: "140", width: "10", height: "8", rx: "2", fill: "var(--theia-editor-background)" }),
    React.createElement("rect", { x: "90", y: "140", width: "10", height: "8", rx: "2", fill: "var(--theia-editor-background)" }),
    React.createElement("rect", { x: "105", y: "140", width: "10", height: "8", rx: "2", fill: "var(--theia-editor-background)" }),
    React.createElement("rect", { x: "120", y: "140", width: "10", height: "8", rx: "2", fill: "var(--theia-editor-background)" }),
    React.createElement("rect", { x: "65", y: "152", width: "50", height: "8", rx: "2", fill: "var(--theia-editor-background)" }),
    React.createElement("rect", { x: "120", y: "152", width: "10", height: "8", rx: "2", fill: "var(--theia-editor-background)" }));
let IdeChatWelcomeMessageProvider = class IdeChatWelcomeMessageProvider {
    renderWelcomeMessage() {
        return React.createElement("div", { className: 'theia-WelcomeMessage' },
            React.createElement(TheiaIdeAiLogo, { width: 200, height: 200, className: "theia-WelcomeMessage-Logo" }),
            React.createElement("div", { className: "theia-WelcomeMessage-Content" },
                React.createElement("h1", null, "Ask the Theia IDE AI"),
                React.createElement("p", null,
                    "To talk to a specialized agent, simply start your message with ",
                    React.createElement("em", null, "@"),
                    " followed by the agent's name:",
                    ' ',
                    React.createElement("em", null, "@Coder"),
                    ", ",
                    React.createElement("em", null, "@Architect"),
                    ", ",
                    React.createElement("em", null, "@Universal"),
                    ", and more."),
                React.createElement("p", null,
                    "Attach context:  use variables, like ",
                    React.createElement("em", null, "#file"),
                    ", ",
                    React.createElement("em", null, "#_f"),
                    " (current file), ",
                    React.createElement("em", null, "#selectedText"),
                    ' ',
                    "or click ",
                    React.createElement("span", { className: "codicon codicon-add" }),
                    "."),
                React.createElement("p", null,
                    "Lean more in the ",
                    React.createElement("a", { target: '_blank', href: "https://theia-ide.org/docs/user_ai/#chat" }, "documentation"),
                    ".")));
    }
    renderDisabledMessage() {
        return React.createElement("div", { className: 'theia-ResponseNode' },
            React.createElement("div", { className: 'theia-ResponseNode-Content', key: 'disabled-message' },
                React.createElement("div", { className: "disable-message" },
                    React.createElement("span", { className: "section-header" }, nls_1.nls.localize('theia/ai/chat-ui/chat-view-tree-widget/aiFeatureHeader', '🚀 AI Features Available (Alpha Version)!')),
                    React.createElement("div", { className: "section-title" },
                        React.createElement("p", null,
                            React.createElement("code", null, nls_1.nls.localize('theia/ai/chat-ui/chat-view-tree-widget/featuresDisabled', 'Currently, all AI Features are disabled!')))),
                    React.createElement("div", { className: "section-title" },
                        React.createElement("p", null, nls_1.nls.localize('theia/ai/chat-ui/chat-view-tree-widget/howToEnable', 'How to Enable the AI Features:'))),
                    React.createElement("div", { className: "section-content" },
                        React.createElement("p", null,
                            "To enable the AI features, please go to the AI features section of the\u00A0",
                            this.renderLinkButton(nls_1.nls.localize('theia/ai/chat-ui/chat-view-tree-widget/settingsMenu', 'the settings menu'), browser_1.CommonCommands.OPEN_PREFERENCES.id, 'ai-features'),
                            "\u00A0and"),
                        React.createElement("ol", null,
                            React.createElement("li", null,
                                "Toggle the switch for ",
                                React.createElement("strong", null, nls_1.nls.localize('theia/ai/chat-ui/chat-view-tree-widget/aiFeaturesEnable', 'Ai-features: Enable')),
                                "."),
                            React.createElement("li", null,
                                "Provide at least one LLM provider (e.g. OpenAI). See ",
                                React.createElement("a", { href: "https://theia-ide.org/docs/user_ai/", target: "_blank" }, "the documentation"),
                                "\u00A0for more information.")),
                        React.createElement("p", null,
                            "This will activate the AI capabilities in the app. Please remember, these features are ",
                            React.createElement("strong", null, "in an alpha state"),
                            ", so they may change and we are working on improving them \uD83D\uDEA7.",
                            React.createElement("br", null),
                            "Please support us by ",
                            React.createElement("a", { href: "https://github.com/eclipse-theia/theia" }, "providing feedback"),
                            "!")),
                    React.createElement("div", { className: "section-title" },
                        React.createElement("p", null, "Currently Supported Views and Features:")),
                    React.createElement("div", { className: "section-content" },
                        React.createElement("p", null, "Once the AI features are enabled, you can access the following views and features:"),
                        React.createElement("ul", null,
                            React.createElement("li", null, "Code Completion"),
                            React.createElement("li", null, "Terminal Assistance (via CTRL+I in a terminal)"),
                            React.createElement("li", null,
                                "This Chat View (features the following agents):",
                                React.createElement("ul", null,
                                    React.createElement("li", null, "Universal Chat Agent"),
                                    React.createElement("li", null, "Coder Chat Agent"),
                                    React.createElement("li", null, "Architect Chat Agent"),
                                    React.createElement("li", null, "Command Chat Agent"),
                                    React.createElement("li", null, "Orchestrator Chat Agent"))),
                            React.createElement("li", null, this.renderLinkButton(nls_1.nls.localize('theia/ai/chat-ui/chat-view-tree-widget/aiHistoryView', 'AI History View'), 'aiHistory:open')),
                            React.createElement("li", null, this.renderLinkButton(nls_1.nls.localize('theia/ai/chat-ui/chat-view-tree-widget/aiConfigurationView', 'AI Configuration View'), 'aiConfiguration:open'))),
                        React.createElement("p", null,
                            "See ",
                            React.createElement("a", { href: "https://theia-ide.org/docs/user_ai/", target: "_blank" }, "the documentation"),
                            " for more information.")))));
    }
    renderLinkButton(title, openCommandId, ...commandArgs) {
        return React.createElement("a", { role: 'button', tabIndex: 0, onClick: () => this.commandRegistry.executeCommand(openCommandId, ...commandArgs), onKeyDown: e => (0, chat_tree_view_1.isEnterKey)(e) && this.commandRegistry.executeCommand(openCommandId) }, title);
    }
};
exports.IdeChatWelcomeMessageProvider = IdeChatWelcomeMessageProvider;
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.CommandRegistry),
    tslib_1.__metadata("design:type", core_1.CommandRegistry)
], IdeChatWelcomeMessageProvider.prototype, "commandRegistry", void 0);
exports.IdeChatWelcomeMessageProvider = IdeChatWelcomeMessageProvider = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], IdeChatWelcomeMessageProvider);


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/browser/summarize-session-command-contribution.js":
/*!**********************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/browser/summarize-session-command-contribution.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SummarizeSessionCommandContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const common_1 = __webpack_require__(/*! @theia/ai-chat/lib/common */ "../../node_modules/@theia/ai-chat/lib/common/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const summarize_session_commands_1 = __webpack_require__(/*! ../common/summarize-session-commands */ "../../node_modules/@theia/ai-ide/lib/common/summarize-session-commands.js");
const task_context_service_1 = __webpack_require__(/*! @theia/ai-chat/lib/browser/task-context-service */ "../../node_modules/@theia/ai-chat/lib/browser/task-context-service.js");
const coder_agent_1 = __webpack_require__(/*! ./coder-agent */ "../../node_modules/@theia/ai-ide/lib/browser/coder-agent.js");
const task_context_variable_1 = __webpack_require__(/*! @theia/ai-chat/lib/browser/task-context-variable */ "../../node_modules/@theia/ai-chat/lib/browser/task-context-variable.js");
const architect_prompt_template_1 = __webpack_require__(/*! ../common/architect-prompt-template */ "../../node_modules/@theia/ai-ide/lib/common/architect-prompt-template.js");
let SummarizeSessionCommandContribution = class SummarizeSessionCommandContribution {
    registerCommands(registry) {
        registry.registerCommand(summarize_session_commands_1.AI_SUMMARIZE_SESSION_AS_TASK_FOR_CODER, {
            execute: async () => {
                const activeSession = this.chatService.getActiveSession();
                if (!activeSession) {
                    return;
                }
                const summaryId = await this.taskContextService.summarize(activeSession, architect_prompt_template_1.ARCHITECT_TASK_SUMMARY_PROMPT_TEMPLATE_ID);
                const newSession = this.chatService.createSession(common_1.ChatAgentLocation.Panel, { focus: true }, this.coderAgent);
                const summaryVariable = { variable: task_context_variable_1.TASK_CONTEXT_VARIABLE, arg: summaryId };
                newSession.model.context.addVariables(summaryVariable);
            }
        });
    }
};
exports.SummarizeSessionCommandContribution = SummarizeSessionCommandContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.ChatService),
    tslib_1.__metadata("design:type", Object)
], SummarizeSessionCommandContribution.prototype, "chatService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(task_context_service_1.TaskContextService),
    tslib_1.__metadata("design:type", task_context_service_1.TaskContextService)
], SummarizeSessionCommandContribution.prototype, "taskContextService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.CommandService),
    tslib_1.__metadata("design:type", Object)
], SummarizeSessionCommandContribution.prototype, "commandService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(coder_agent_1.CoderAgent),
    tslib_1.__metadata("design:type", coder_agent_1.CoderAgent)
], SummarizeSessionCommandContribution.prototype, "coderAgent", void 0);
exports.SummarizeSessionCommandContribution = SummarizeSessionCommandContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], SummarizeSessionCommandContribution);


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/browser/task-background-summary-variable.js":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/browser/task-background-summary-variable.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TaskContextSummaryVariableContribution = exports.TASK_CONTEXT_SUMMARY_VARIABLE = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const ai_chat_1 = __webpack_require__(/*! @theia/ai-chat */ "../../node_modules/@theia/ai-chat/lib/common/index.js");
const task_context_variable_1 = __webpack_require__(/*! @theia/ai-chat/lib/browser/task-context-variable */ "../../node_modules/@theia/ai-chat/lib/browser/task-context-variable.js");
const context_variables_1 = __webpack_require__(/*! ../common/context-variables */ "../../node_modules/@theia/ai-ide/lib/common/context-variables.js");
exports.TASK_CONTEXT_SUMMARY_VARIABLE = {
    id: context_variables_1.TASK_CONTEXT_SUMMARY_VARIABLE_ID,
    description: core_1.nls.localize('theia/ai/core/taskContextSummary/description', 'Resolves all task context items present in the session context.'),
    name: context_variables_1.TASK_CONTEXT_SUMMARY_VARIABLE_ID,
};
let TaskContextSummaryVariableContribution = class TaskContextSummaryVariableContribution {
    registerVariables(service) {
        service.registerResolver(exports.TASK_CONTEXT_SUMMARY_VARIABLE, this);
    }
    canResolve(request, context) {
        return request.variable.name === exports.TASK_CONTEXT_SUMMARY_VARIABLE.name ? 50 : 0;
    }
    async resolve(request, context, resolveDependency) {
        if (!resolveDependency || !ai_chat_1.ChatSessionContext.is(context) || request.variable.name !== exports.TASK_CONTEXT_SUMMARY_VARIABLE.name) {
            return undefined;
        }
        const allSummaryRequests = context.model.context.getVariables().filter(candidate => candidate.variable.id === task_context_variable_1.TASK_CONTEXT_VARIABLE.id);
        if (!allSummaryRequests.length) {
            return { ...request, value: '' };
        }
        const allSummaries = await Promise.all(allSummaryRequests.map(summaryRequest => resolveDependency(summaryRequest).then(resolved => resolved === null || resolved === void 0 ? void 0 : resolved.value)));
        const value = `# Current Task Context\n\n${allSummaries.map((content, index) => `## Task ${index + 1}\n\n${content}`).join('\n\n')}`;
        return {
            ...request,
            value
        };
    }
};
exports.TaskContextSummaryVariableContribution = TaskContextSummaryVariableContribution;
exports.TaskContextSummaryVariableContribution = TaskContextSummaryVariableContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
    /**
     * @class provides a summary of all TaskContextVariables in the context of a given session. Oriented towards use in prompts.
     */
], TaskContextSummaryVariableContribution);


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/browser/task-context-file-storage-service.js":
/*!*****************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/browser/task-context-file-storage-service.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TaskContextFileStorageService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const task_context_storage_service_1 = __webpack_require__(/*! @theia/ai-chat/lib/browser/task-context-storage-service */ "../../node_modules/@theia/ai-chat/lib/browser/task-context-storage-service.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const file_service_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/file-service */ "../../node_modules/@theia/filesystem/lib/browser/file-service.js");
const browser_2 = __webpack_require__(/*! @theia/workspace/lib/browser */ "../../node_modules/@theia/workspace/lib/browser/index.js");
const yaml = __webpack_require__(/*! js-yaml */ "../../node_modules/js-yaml/index.js");
const workspace_preferences_1 = __webpack_require__(/*! ./workspace-preferences */ "../../node_modules/@theia/ai-ide/lib/browser/workspace-preferences.js");
const buffer_1 = __webpack_require__(/*! @theia/core/lib/common/buffer */ "../../node_modules/@theia/core/lib/common/buffer.js");
let TaskContextFileStorageService = class TaskContextFileStorageService {
    constructor() {
        this.onDidChangeEmitter = new core_1.Emitter();
        this.onDidChange = this.onDidChangeEmitter.event;
    }
    getStorageLocation() {
        var _a;
        if (!this.workspaceService.opened) {
            return;
        }
        const values = this.preferenceService.inspect(workspace_preferences_1.TASK_CONTEXT_STORAGE_DIRECTORY_PREF);
        const configuredPath = (values === null || values === void 0 ? void 0 : values.globalValue) === undefined ? values === null || values === void 0 ? void 0 : values.defaultValue : values === null || values === void 0 ? void 0 : values.globalValue;
        if (!configuredPath || typeof configuredPath !== 'string') {
            return;
        }
        const asPath = new core_1.Path(configuredPath);
        return asPath.isAbsolute ? new core_1.URI(configuredPath) : (_a = this.workspaceService.tryGetRoots().at(0)) === null || _a === void 0 ? void 0 : _a.resource.resolve(configuredPath);
    }
    init() {
        this.watchStorage();
        this.preferenceService.onPreferenceChanged(e => {
            if (e.affects(workspace_preferences_1.TASK_CONTEXT_STORAGE_DIRECTORY_PREF)) {
                this.watchStorage();
            }
        });
    }
    async watchStorage() {
        var _a;
        (_a = this.toDisposeOnStorageChange) === null || _a === void 0 ? void 0 : _a.dispose();
        this.toDisposeOnStorageChange = undefined;
        const newStorage = this.getStorageLocation();
        if (!newStorage) {
            return;
        }
        this.toDisposeOnStorageChange = new core_1.DisposableCollection(this.fileService.watch(newStorage, { recursive: true, excludes: [] }), this.fileService.onDidFilesChange(event => {
            const relevantChanges = event.changes.filter(candidate => newStorage.isEqualOrParent(candidate.resource));
            this.handleChanges(relevantChanges);
        }), { dispose: () => this.clearInMemoryStorage() });
        await this.cacheNewTasks(newStorage);
    }
    async handleChanges(changes) {
        await Promise.all(changes.map(change => {
            switch (change.type) {
                case 2 /* FileChangeType.DELETED */: return this.deleteFileReference(change.resource);
                case 1 /* FileChangeType.ADDED */:
                case 0 /* FileChangeType.UPDATED */:
                    return this.readFile(change.resource);
                default: return (0, core_1.unreachable)(change.type);
            }
        }));
    }
    clearInMemoryStorage() {
        this.inMemoryStorage.clear();
    }
    deleteFileReference(uri) {
        var _a;
        if (this.inMemoryStorage.delete(uri.path.base)) {
            return true;
        }
        for (const summary of this.inMemoryStorage.getAll()) {
            if ((_a = summary.uri) === null || _a === void 0 ? void 0 : _a.isEqual(uri)) {
                return this.inMemoryStorage.delete(summary.id);
            }
        }
        return false;
    }
    async cacheNewTasks(storageLocation) {
        var _a;
        const contents = await this.fileService.resolve(storageLocation).catch(() => undefined);
        if (!((_a = contents === null || contents === void 0 ? void 0 : contents.children) === null || _a === void 0 ? void 0 : _a.length)) {
            return;
        }
        await Promise.all(contents.children.map(child => this.readFile(child.resource)));
        this.onDidChangeEmitter.fire();
    }
    async readFile(uri) {
        const content = await this.fileService.read(uri).then(read => read.value).catch(() => undefined);
        if (content === undefined) {
            return;
        }
        const { frontmatter, body } = this.maybeReadFrontmatter(content);
        const summary = {
            ...frontmatter,
            summary: body,
            label: (frontmatter === null || frontmatter === void 0 ? void 0 : frontmatter.label) || uri.path.base.slice(0, (-1 * uri.path.ext.length) || uri.path.base.length),
            uri,
            id: (frontmatter === null || frontmatter === void 0 ? void 0 : frontmatter.sessionId) || uri.path.base
        };
        const existingSummary = summary.sessionId && this.getAll().find(candidate => candidate.sessionId === summary.sessionId);
        if (existingSummary) {
            summary.id = existingSummary.id;
        }
        this.inMemoryStorage.store(summary);
    }
    async store(summary) {
        const storageLocation = this.getStorageLocation();
        if (storageLocation) {
            const frontmatter = {
                sessionId: summary.sessionId,
                date: new Date().toISOString(),
                label: summary.label,
            };
            const derivedName = summary.label.trim().replace(/[^\p{L}\p{N}]/vg, '-').replace(/^-+|-+$/g, '');
            const filename = (derivedName.length > 32 ? derivedName.slice(0, derivedName.indexOf('-', 32)) : derivedName) + '.md';
            const content = yaml.dump(frontmatter).trim() + `${core_1.EOL}---${core_1.EOL}` + summary.summary;
            const uri = storageLocation.resolve(filename);
            summary.uri = uri;
            await this.fileService.writeFile(uri, buffer_1.BinaryBuffer.fromString(content));
        }
        this.inMemoryStorage.store(summary);
        this.onDidChangeEmitter.fire();
    }
    getAll() {
        return this.inMemoryStorage.getAll();
    }
    get(identifier) {
        return this.inMemoryStorage.get(identifier);
    }
    async delete(identifier) {
        const summary = this.inMemoryStorage.get(identifier);
        if (summary === null || summary === void 0 ? void 0 : summary.uri) {
            await this.fileService.delete(summary.uri);
        }
        this.inMemoryStorage.delete(identifier);
        if (summary) {
            this.onDidChangeEmitter.fire();
        }
        return !!summary;
    }
    maybeReadFrontmatter(content) {
        const frontmatterEnd = content.indexOf('---');
        if (frontmatterEnd !== -1) {
            try {
                const frontmatter = yaml.load(content.slice(0, frontmatterEnd));
                if (this.hasLabel(frontmatter)) {
                    return { frontmatter, body: content.slice(frontmatterEnd + 3).trim() };
                }
            }
            catch { /* Probably not frontmatter, then. */ }
        }
        return { body: content, frontmatter: undefined };
    }
    hasLabel(candidate) {
        return !!candidate && typeof candidate === 'object' && !Array.isArray(candidate) && 'label' in candidate && typeof candidate.label === 'string';
    }
    async open(identifier) {
        const summary = this.get(identifier);
        if (!summary) {
            throw new Error('Unable to open requested task context: none found with specified identifier.');
        }
        await (summary.uri ? (0, browser_1.open)(this.openerService, summary.uri) : this.inMemoryStorage.open(identifier));
    }
};
exports.TaskContextFileStorageService = TaskContextFileStorageService;
tslib_1.__decorate([
    (0, inversify_1.inject)(task_context_storage_service_1.InMemoryTaskContextStorage),
    tslib_1.__metadata("design:type", task_context_storage_service_1.InMemoryTaskContextStorage)
], TaskContextFileStorageService.prototype, "inMemoryStorage", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.PreferenceService),
    tslib_1.__metadata("design:type", Object)
], TaskContextFileStorageService.prototype, "preferenceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.WorkspaceService),
    tslib_1.__metadata("design:type", browser_2.WorkspaceService)
], TaskContextFileStorageService.prototype, "workspaceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    tslib_1.__metadata("design:type", file_service_1.FileService)
], TaskContextFileStorageService.prototype, "fileService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.OpenerService),
    tslib_1.__metadata("design:type", Object)
], TaskContextFileStorageService.prototype, "openerService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], TaskContextFileStorageService.prototype, "init", null);
exports.TaskContextFileStorageService = TaskContextFileStorageService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], TaskContextFileStorageService);


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/browser/template-preference-contribution.js":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/browser/template-preference-contribution.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TemplatePreferenceContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const frontend_prompt_customization_service_1 = __webpack_require__(/*! @theia/ai-core/lib/browser/frontend-prompt-customization-service */ "../../node_modules/@theia/ai-core/lib/browser/frontend-prompt-customization-service.js");
const workspace_preferences_1 = __webpack_require__(/*! ./workspace-preferences */ "../../node_modules/@theia/ai-ide/lib/browser/workspace-preferences.js");
const browser_2 = __webpack_require__(/*! @theia/workspace/lib/browser */ "../../node_modules/@theia/workspace/lib/browser/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
let TemplatePreferenceContribution = class TemplatePreferenceContribution {
    onStart() {
        Promise.all([this.preferenceService.ready, this.workspaceService.ready]).then(() => {
            // Set initial template configuration from preferences
            this.updateConfiguration();
            // Listen for preference changes
            this.preferenceService.onPreferenceChanged(event => {
                if (event.preferenceName === workspace_preferences_1.PROMPT_TEMPLATE_WORKSPACE_DIRECTORIES_PREF ||
                    event.preferenceName === workspace_preferences_1.PROMPT_TEMPLATE_ADDITIONAL_EXTENSIONS_PREF ||
                    event.preferenceName === workspace_preferences_1.PROMPT_TEMPLATE_WORKSPACE_FILES_PREF) {
                    this.updateConfiguration(event.preferenceName);
                }
            });
            // Listen for workspace root changes
            this.workspaceService.onWorkspaceLocationChanged(() => {
                this.updateConfiguration();
            });
        });
    }
    /**
     * Updates the template configuration in the customization service.
     * If a specific preference name is provided, only that configuration aspect is updated.
     * @param changedPreference Optional name of the preference that changed
     */
    async updateConfiguration(changedPreference) {
        const workspaceRoot = this.workspaceService.tryGetRoots()[0];
        if (!workspaceRoot) {
            return;
        }
        const workspaceRootUri = workspaceRoot.resource;
        const configProperties = {};
        if (!changedPreference || changedPreference === workspace_preferences_1.PROMPT_TEMPLATE_WORKSPACE_DIRECTORIES_PREF) {
            const relativeDirectories = this.preferenceService.get(workspace_preferences_1.PROMPT_TEMPLATE_WORKSPACE_DIRECTORIES_PREF, []);
            configProperties.directoryPaths = relativeDirectories.map(dir => {
                const path = new core_1.Path(dir);
                const uri = workspaceRootUri.resolve(path.toString());
                return uri.path.toString();
            });
        }
        if (!changedPreference || changedPreference === workspace_preferences_1.PROMPT_TEMPLATE_ADDITIONAL_EXTENSIONS_PREF) {
            configProperties.extensions = this.preferenceService.get(workspace_preferences_1.PROMPT_TEMPLATE_ADDITIONAL_EXTENSIONS_PREF, []);
        }
        if (!changedPreference || changedPreference === workspace_preferences_1.PROMPT_TEMPLATE_WORKSPACE_FILES_PREF) {
            const relativeFilePaths = this.preferenceService.get(workspace_preferences_1.PROMPT_TEMPLATE_WORKSPACE_FILES_PREF, []);
            configProperties.filePaths = relativeFilePaths.map(filePath => {
                const path = new core_1.Path(filePath);
                const uri = workspaceRootUri.resolve(path.toString());
                return uri.path.toString();
            });
        }
        await this.customizationService.updateConfiguration(configProperties);
    }
};
exports.TemplatePreferenceContribution = TemplatePreferenceContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.PreferenceService),
    tslib_1.__metadata("design:type", Object)
], TemplatePreferenceContribution.prototype, "preferenceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(frontend_prompt_customization_service_1.FrontendPromptCustomizationServiceImpl),
    tslib_1.__metadata("design:type", frontend_prompt_customization_service_1.FrontendPromptCustomizationServiceImpl)
], TemplatePreferenceContribution.prototype, "customizationService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.WorkspaceService),
    tslib_1.__metadata("design:type", browser_2.WorkspaceService)
], TemplatePreferenceContribution.prototype, "workspaceService", void 0);
exports.TemplatePreferenceContribution = TemplatePreferenceContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], TemplatePreferenceContribution);


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/browser/workspace-functions.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/browser/workspace-functions.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

var GetWorkspaceDirectoryStructure_1, FileContentFunction_1, GetWorkspaceFileList_1, FileDiagonsticProvider_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FileDiagonsticProvider = exports.GetWorkspaceFileList = exports.FileContentFunction = exports.GetWorkspaceDirectoryStructure = exports.WorkspaceFunctionScope = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const file_service_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/file-service */ "../../node_modules/@theia/filesystem/lib/browser/file-service.js");
const browser_1 = __webpack_require__(/*! @theia/workspace/lib/browser */ "../../node_modules/@theia/workspace/lib/browser/index.js");
const workspace_functions_1 = __webpack_require__(/*! ../common/workspace-functions */ "../../node_modules/@theia/ai-ide/lib/common/workspace-functions.js");
const ignore_1 = __webpack_require__(/*! ignore */ "../../node_modules/@theia/ai-ide/node_modules/ignore/index.js");
const minimatch_1 = __webpack_require__(/*! minimatch */ "../../node_modules/@theia/ai-ide/node_modules/minimatch/dist/commonjs/index.js");
const browser_2 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const workspace_preferences_1 = __webpack_require__(/*! ./workspace-preferences */ "../../node_modules/@theia/ai-ide/lib/browser/workspace-preferences.js");
const monaco_workspace_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-workspace */ "../../node_modules/@theia/monaco/lib/browser/monaco-workspace.js");
const monaco_text_model_service_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-text-model-service */ "../../node_modules/@theia/monaco/lib/browser/monaco-text-model-service.js");
const browser_3 = __webpack_require__(/*! @theia/markers/lib/browser */ "../../node_modules/@theia/markers/lib/browser/index.js");
const vscode_languageserver_protocol_1 = __webpack_require__(/*! @theia/core/shared/vscode-languageserver-protocol */ "../../node_modules/@theia/core/shared/vscode-languageserver-protocol/index.js");
let WorkspaceFunctionScope = class WorkspaceFunctionScope {
    constructor() {
        this.GITIGNORE_FILE_NAME = '.gitignore';
        this.gitignoreWatcherInitialized = false;
    }
    async getWorkspaceRoot() {
        const wsRoots = await this.workspaceService.roots;
        if (wsRoots.length === 0) {
            throw new Error('No workspace has been opened yet');
        }
        return wsRoots[0].resource;
    }
    ensureWithinWorkspace(targetUri, workspaceRootUri) {
        if (!targetUri.toString().startsWith(workspaceRootUri.toString())) {
            throw new Error('Access outside of the workspace is not allowed');
        }
    }
    async resolveRelativePath(relativePath) {
        const workspaceRoot = await this.getWorkspaceRoot();
        return workspaceRoot.resolve(relativePath);
    }
    async initializeGitignoreWatcher(workspaceRoot) {
        if (this.gitignoreWatcherInitialized) {
            return;
        }
        const gitignoreUri = workspaceRoot.resolve(this.GITIGNORE_FILE_NAME);
        this.fileService.watch(gitignoreUri);
        this.fileService.onDidFilesChange(async (event) => {
            if (event.contains(gitignoreUri)) {
                this.gitignoreMatcher = undefined;
            }
        });
        this.gitignoreWatcherInitialized = true;
    }
    async shouldExclude(stat) {
        const shouldConsiderGitIgnore = this.preferences.get(workspace_preferences_1.CONSIDER_GITIGNORE_PREF, false);
        const userExcludePatterns = this.preferences.get(workspace_preferences_1.USER_EXCLUDE_PATTERN_PREF, []);
        if (this.isUserExcluded(stat.resource.path.base, userExcludePatterns)) {
            return true;
        }
        const workspaceRoot = await this.getWorkspaceRoot();
        if (shouldConsiderGitIgnore && await this.isGitIgnored(stat, workspaceRoot)) {
            return true;
        }
        return false;
    }
    isUserExcluded(fileName, userExcludePatterns) {
        return userExcludePatterns.some(pattern => new minimatch_1.Minimatch(pattern, { dot: true }).match(fileName));
    }
    async isGitIgnored(stat, workspaceRoot) {
        await this.initializeGitignoreWatcher(workspaceRoot);
        const gitignoreUri = workspaceRoot.resolve(this.GITIGNORE_FILE_NAME);
        try {
            const fileStat = await this.fileService.resolve(gitignoreUri);
            if (fileStat) {
                if (!this.gitignoreMatcher) {
                    const gitignoreContent = await this.fileService.read(gitignoreUri);
                    this.gitignoreMatcher = (0, ignore_1.default)().add(gitignoreContent.value);
                }
                const relativePath = workspaceRoot.relative(stat.resource);
                if (relativePath) {
                    const relativePathStr = relativePath.toString() + (stat.isDirectory ? '/' : '');
                    if (this.gitignoreMatcher.ignores(relativePathStr)) {
                        return true;
                    }
                }
            }
        }
        catch {
            // If .gitignore does not exist or cannot be read, continue without error
        }
        return false;
    }
};
exports.WorkspaceFunctionScope = WorkspaceFunctionScope;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.WorkspaceService),
    tslib_1.__metadata("design:type", browser_1.WorkspaceService)
], WorkspaceFunctionScope.prototype, "workspaceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    tslib_1.__metadata("design:type", file_service_1.FileService)
], WorkspaceFunctionScope.prototype, "fileService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.PreferenceService),
    tslib_1.__metadata("design:type", Object)
], WorkspaceFunctionScope.prototype, "preferences", void 0);
exports.WorkspaceFunctionScope = WorkspaceFunctionScope = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], WorkspaceFunctionScope);
let GetWorkspaceDirectoryStructure = GetWorkspaceDirectoryStructure_1 = class GetWorkspaceDirectoryStructure {
    getTool() {
        return {
            id: GetWorkspaceDirectoryStructure_1.ID,
            name: GetWorkspaceDirectoryStructure_1.ID,
            description: `Retrieve the complete directory structure of the workspace, listing only directories (no file contents). This structure excludes specific directories,
            such as node_modules and hidden files, ensuring paths are within workspace boundaries.`,
            parameters: {
                type: 'object',
                properties: {}
            },
            handler: () => this.getDirectoryStructure()
        };
    }
    async getDirectoryStructure() {
        let workspaceRoot;
        try {
            workspaceRoot = await this.workspaceScope.getWorkspaceRoot();
        }
        catch (error) {
            return [`Error: ${error.message}`];
        }
        return this.buildDirectoryStructure(workspaceRoot);
    }
    async buildDirectoryStructure(uri, prefix = '') {
        const stat = await this.fileService.resolve(uri);
        const result = [];
        if (stat && stat.isDirectory && stat.children) {
            for (const child of stat.children) {
                if (!child.isDirectory || await this.workspaceScope.shouldExclude(child)) {
                    continue;
                }
                ;
                const path = `${prefix}${child.resource.path.base}/`;
                result.push(path);
                result.push(...await this.buildDirectoryStructure(child.resource, `${path}`));
            }
        }
        return result;
    }
};
exports.GetWorkspaceDirectoryStructure = GetWorkspaceDirectoryStructure;
GetWorkspaceDirectoryStructure.ID = workspace_functions_1.GET_WORKSPACE_DIRECTORY_STRUCTURE_FUNCTION_ID;
tslib_1.__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    tslib_1.__metadata("design:type", file_service_1.FileService)
], GetWorkspaceDirectoryStructure.prototype, "fileService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(WorkspaceFunctionScope),
    tslib_1.__metadata("design:type", WorkspaceFunctionScope)
], GetWorkspaceDirectoryStructure.prototype, "workspaceScope", void 0);
exports.GetWorkspaceDirectoryStructure = GetWorkspaceDirectoryStructure = GetWorkspaceDirectoryStructure_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], GetWorkspaceDirectoryStructure);
let FileContentFunction = FileContentFunction_1 = class FileContentFunction {
    getTool() {
        return {
            id: FileContentFunction_1.ID,
            name: FileContentFunction_1.ID,
            description: `Return the content of a specified file within the workspace. The file path must be provided relative to the workspace root. Only files within
                workspace boundaries are accessible; attempting to access files outside the workspace will return an error.`,
            parameters: {
                type: 'object',
                properties: {
                    file: {
                        type: 'string',
                        description: `The relative path to the target file within the workspace. This path is resolved from the workspace root, and only files within the workspace
                            boundaries are accessible. Attempting to access paths outside the workspace will result in an error.`,
                    }
                },
                required: ['file']
            },
            handler: (arg_string) => {
                const file = this.parseArg(arg_string);
                return this.getFileContent(file);
            }
        };
    }
    parseArg(arg_string) {
        const result = JSON.parse(arg_string);
        return result.file;
    }
    async getFileContent(file) {
        var _a;
        let targetUri;
        try {
            const workspaceRoot = await this.workspaceScope.getWorkspaceRoot();
            targetUri = workspaceRoot.resolve(file);
            this.workspaceScope.ensureWithinWorkspace(targetUri, workspaceRoot);
        }
        catch (error) {
            return JSON.stringify({ error: error.message });
        }
        try {
            const openEditorValue = (_a = this.monacoWorkspace.getTextDocument(targetUri.toString())) === null || _a === void 0 ? void 0 : _a.getText();
            if (openEditorValue !== undefined) {
                return openEditorValue;
            }
            const fileContent = await this.fileService.read(targetUri);
            return fileContent.value;
        }
        catch (error) {
            return JSON.stringify({ error: 'File not found' });
        }
    }
};
exports.FileContentFunction = FileContentFunction;
FileContentFunction.ID = workspace_functions_1.FILE_CONTENT_FUNCTION_ID;
tslib_1.__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    tslib_1.__metadata("design:type", file_service_1.FileService)
], FileContentFunction.prototype, "fileService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(WorkspaceFunctionScope),
    tslib_1.__metadata("design:type", WorkspaceFunctionScope)
], FileContentFunction.prototype, "workspaceScope", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(monaco_workspace_1.MonacoWorkspace),
    tslib_1.__metadata("design:type", monaco_workspace_1.MonacoWorkspace)
], FileContentFunction.prototype, "monacoWorkspace", void 0);
exports.FileContentFunction = FileContentFunction = FileContentFunction_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], FileContentFunction);
let GetWorkspaceFileList = GetWorkspaceFileList_1 = class GetWorkspaceFileList {
    getTool() {
        return {
            id: GetWorkspaceFileList_1.ID,
            name: GetWorkspaceFileList_1.ID,
            parameters: {
                type: 'object',
                properties: {
                    path: {
                        type: 'string',
                        description: `Optional relative path to a directory within the workspace. If no path is specified, the function lists contents directly in the workspace
                         root. Paths are resolved within workspace boundaries only; paths outside the workspace or unvalidated paths will result in an error.`
                    }
                },
                required: ['path']
            },
            description: `List files and directories within a specified workspace directory. Paths are relative to the workspace root, and only workspace-contained paths are
             allowed. If no path is provided, the root contents are listed. Paths outside the workspace will result in an error.`,
            handler: (arg_string) => {
                const args = JSON.parse(arg_string);
                return this.getProjectFileList(args.path);
            }
        };
    }
    async getProjectFileList(path) {
        let workspaceRoot;
        try {
            workspaceRoot = await this.workspaceScope.getWorkspaceRoot();
        }
        catch (error) {
            return [`Error: ${error.message}`];
        }
        const targetUri = path ? workspaceRoot.resolve(path) : workspaceRoot;
        this.workspaceScope.ensureWithinWorkspace(targetUri, workspaceRoot);
        try {
            const stat = await this.fileService.resolve(targetUri);
            if (!stat || !stat.isDirectory) {
                return ['Error: Directory not found'];
            }
            return await this.listFilesDirectly(targetUri, workspaceRoot);
        }
        catch (error) {
            return ['Error: Directory not found'];
        }
    }
    async listFilesDirectly(uri, workspaceRootUri) {
        const stat = await this.fileService.resolve(uri);
        const result = [];
        if (stat && stat.isDirectory) {
            if (await this.workspaceScope.shouldExclude(stat)) {
                return result;
            }
            const children = await this.fileService.resolve(uri);
            if (children.children) {
                for (const child of children.children) {
                    if (await this.workspaceScope.shouldExclude(child)) {
                        continue;
                    }
                    ;
                    const relativePath = workspaceRootUri.relative(child.resource);
                    if (relativePath) {
                        result.push(relativePath.toString());
                    }
                }
            }
        }
        return result;
    }
};
exports.GetWorkspaceFileList = GetWorkspaceFileList;
GetWorkspaceFileList.ID = workspace_functions_1.GET_WORKSPACE_FILE_LIST_FUNCTION_ID;
tslib_1.__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    tslib_1.__metadata("design:type", file_service_1.FileService)
], GetWorkspaceFileList.prototype, "fileService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(WorkspaceFunctionScope),
    tslib_1.__metadata("design:type", WorkspaceFunctionScope)
], GetWorkspaceFileList.prototype, "workspaceScope", void 0);
exports.GetWorkspaceFileList = GetWorkspaceFileList = GetWorkspaceFileList_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], GetWorkspaceFileList);
let FileDiagonsticProvider = FileDiagonsticProvider_1 = class FileDiagonsticProvider {
    getTool() {
        return {
            id: FileDiagonsticProvider_1.ID,
            name: FileDiagonsticProvider_1.ID,
            description: 'A function to retrieve diagnostics associated with a specific file in the workspace. It will return a list of problems that includes the surrounding text \
            a message describing the problem, and optionally a code and a codeDescription field describing that code.',
            parameters: {
                type: 'object',
                properties: {
                    file: {
                        type: 'string',
                        description: `The relative path to the target file within the workspace. This path is resolved from the workspace root, and only files within the workspace
                        boundaries are accessible. Attempting to access paths outside the workspace will result in an error.`,
                    }
                },
                required: ['file']
            },
            handler: async (arg) => {
                try {
                    const { file } = JSON.parse(arg);
                    const workspaceRoot = await this.workspaceScope.getWorkspaceRoot();
                    const targetUri = workspaceRoot.resolve(file);
                    this.workspaceScope.ensureWithinWorkspace(targetUri, workspaceRoot);
                    return this.getDiagnosticsForFile(targetUri);
                }
                catch (error) {
                    return JSON.stringify({ error: error instanceof Error ? error.message : 'Unknown error.' });
                }
            }
        };
    }
    async getDiagnosticsForFile(uri) {
        const toDispose = [];
        try {
            let markers = this.problemManager.findMarkers({ uri });
            if (markers.length === 0) {
                // Open editor to ensure that the language services are active.
                await (0, browser_2.open)(this.openerService, uri);
                // Give some time to fetch problems in a newly opened editor.
                await new Promise(res => {
                    setTimeout(res, 5000);
                    // Give another moment for additional markers to come in from different sources.
                    const listener = this.problemManager.onDidChangeMarkers(changed => changed.isEqual(uri) && setTimeout(res, 500));
                    toDispose.push(listener);
                });
                markers = this.problemManager.findMarkers({ uri });
            }
            if (markers.length) {
                const editor = await this.modelService.createModelReference(uri);
                toDispose.push(editor);
                return JSON.stringify(markers.filter(marker => marker.data.severity !== vscode_languageserver_protocol_1.DiagnosticSeverity.Information && marker.data.severity !== vscode_languageserver_protocol_1.DiagnosticSeverity.Hint)
                    .map(marker => {
                    const contextRange = this.atLeastNLines(3, marker.data.range, editor.object.lineCount);
                    const text = editor.object.getText(contextRange);
                    const message = marker.data.message;
                    const code = marker.data.code;
                    const codeDescription = marker.data.codeDescription;
                    return { text, message, code, codeDescription };
                }));
            }
            return JSON.stringify({
                error: 'No diagnostics were found. The file may contain no problems, or language services may not be available. Retrying may return fresh results.'
            });
        }
        catch (err) {
            console.warn('Error when fetching markers for', uri.toString(), err);
            return JSON.stringify({ error: err instanceof Error ? err.message : 'Unknown error when fetching for problems for ' + uri.toString() });
        }
        finally {
            toDispose.forEach(disposable => disposable.dispose());
        }
    }
    /**
     * Expands the range provided until it contains at least {@link desiredLines} lines or reaches the end of the document
     *  to attempt to provide the agent sufficient context to understand the diagnostic.
     */
    atLeastNLines(desiredLines, range, documentLineCount) {
        let startLine = range.start.line;
        let endLine = range.end.line;
        const desiredDifference = desiredLines - 1;
        while (endLine - startLine < desiredDifference && (startLine > 0 || endLine < documentLineCount - 1)) {
            if (startLine > 0) {
                startLine--;
            }
            else if (endLine < documentLineCount - 1) {
                endLine++;
            }
            if (endLine < documentLineCount - 1) {
                endLine++;
            }
            else if (startLine > 0) {
                startLine--;
            }
        }
        return { end: { character: Number.MAX_SAFE_INTEGER, line: endLine }, start: { character: 0, line: startLine } };
    }
};
exports.FileDiagonsticProvider = FileDiagonsticProvider;
FileDiagonsticProvider.ID = workspace_functions_1.GET_FILE_DIAGNOSTICS_ID;
tslib_1.__decorate([
    (0, inversify_1.inject)(WorkspaceFunctionScope),
    tslib_1.__metadata("design:type", WorkspaceFunctionScope)
], FileDiagonsticProvider.prototype, "workspaceScope", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_3.ProblemManager),
    tslib_1.__metadata("design:type", browser_3.ProblemManager)
], FileDiagonsticProvider.prototype, "problemManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(monaco_text_model_service_1.MonacoTextModelService),
    tslib_1.__metadata("design:type", monaco_text_model_service_1.MonacoTextModelService)
], FileDiagonsticProvider.prototype, "modelService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.OpenerService),
    tslib_1.__metadata("design:type", Object)
], FileDiagonsticProvider.prototype, "openerService", void 0);
exports.FileDiagonsticProvider = FileDiagonsticProvider = FileDiagonsticProvider_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], FileDiagonsticProvider);


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/browser/workspace-preferences.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/browser/workspace-preferences.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WorkspacePreferencesSchema = exports.TASK_CONTEXT_STORAGE_DIRECTORY_PREF = exports.PROMPT_TEMPLATE_WORKSPACE_FILES_PREF = exports.PROMPT_TEMPLATE_ADDITIONAL_EXTENSIONS_PREF = exports.PROMPT_TEMPLATE_WORKSPACE_DIRECTORIES_PREF = exports.USER_EXCLUDE_PATTERN_PREF = exports.CONSIDER_GITIGNORE_PREF = void 0;
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
exports.CONSIDER_GITIGNORE_PREF = 'ai-features.workspaceFunctions.considerGitIgnore';
exports.USER_EXCLUDE_PATTERN_PREF = 'ai-features.workspaceFunctions.userExcludes';
exports.PROMPT_TEMPLATE_WORKSPACE_DIRECTORIES_PREF = 'ai-features.promptTemplates.WorkspaceTemplateDirectories';
exports.PROMPT_TEMPLATE_ADDITIONAL_EXTENSIONS_PREF = 'ai-features.promptTemplates.TemplateExtensions';
exports.PROMPT_TEMPLATE_WORKSPACE_FILES_PREF = 'ai-features.promptTemplates.WorkspaceTemplateFiles';
exports.TASK_CONTEXT_STORAGE_DIRECTORY_PREF = 'ai-features.promptTemplates.taskContextStorageDirectory';
const CONFLICT_RESOLUTION_DESCRIPTION = 'When templates with the same ID (filename) exist in multiple locations, conflicts are resolved by priority: specific template files \
(highest) > workspace directories > global directories (lowest).';
exports.WorkspacePreferencesSchema = {
    type: 'object',
    properties: {
        [exports.CONSIDER_GITIGNORE_PREF]: {
            type: 'boolean',
            title: core_1.nls.localize('theia/ai/workspace/considerGitignore/title', 'Consider .gitignore'),
            description: core_1.nls.localize('theia/ai/workspace/considerGitignore/description', 'If enabled, excludes files/folders specified in a global .gitignore file (expected location is the workspace root).'),
            default: false
        },
        [exports.USER_EXCLUDE_PATTERN_PREF]: {
            type: 'array',
            title: core_1.nls.localize('theia/ai/workspace/excludedPattern/title', 'Excluded File Patterns'),
            description: core_1.nls.localize('theia/ai/workspace/excludedPattern/description', 'List of patterns (glob or regex) for files/folders to exclude.'),
            default: ['node_modules', 'lib', '.*'],
            items: {
                type: 'string'
            }
        },
        [exports.PROMPT_TEMPLATE_WORKSPACE_DIRECTORIES_PREF]: {
            type: 'array',
            title: core_1.nls.localize('theia/ai/promptTemplates/directories/title', 'Workspace-specific Prompt Template Directories'),
            description: core_1.nls.localize('theia/ai/promptTemplates/directories/description', 'List of relative paths indicating folders in the current workspace to be scanned for WORKSPACE specific prompt templates. ' +
                CONFLICT_RESOLUTION_DESCRIPTION),
            default: ['.prompts'],
            items: {
                type: 'string'
            }
        },
        [exports.PROMPT_TEMPLATE_ADDITIONAL_EXTENSIONS_PREF]: {
            type: 'array',
            title: core_1.nls.localize('theia/ai/promptTemplates/extensions/title', 'Additional Prompt Template File Extensions'),
            description: core_1.nls.localize('theia/ai/promptTemplates/extensions/description', 'List of additional file extensions in prompt locations that are considered as prompt templates. \'.prompttemplate\' is always considered as a default.'),
            items: {
                type: 'string'
            }
        },
        [exports.PROMPT_TEMPLATE_WORKSPACE_FILES_PREF]: {
            type: 'array',
            title: core_1.nls.localize('theia/ai/promptTemplates/files/title', 'Workspace-specific Prompt Template Files'),
            description: core_1.nls.localize('theia/ai/promptTemplates/files/description', 'List of relative paths to specific files in the current workspace to be used as prompt templates. ' +
                CONFLICT_RESOLUTION_DESCRIPTION),
            default: [],
            items: {
                type: 'string'
            }
        },
        [exports.TASK_CONTEXT_STORAGE_DIRECTORY_PREF]: {
            type: 'string',
            description: core_1.nls.localize('theia/ai/chat/taskContextStorageDirectory/description', 'A workspace relative path in which to persist and from which to retrieve task context descriptions.' +
                ' If set to empty value, generated task contexts will be stored in memory rather than on disk.'),
            default: '.prompts/task-contexts'
        }
    }
};


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/browser/workspace-search-provider.js":
/*!*********************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/browser/workspace-search-provider.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WorkspaceSearchProvider = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const search_in_workspace_service_1 = __webpack_require__(/*! @theia/search-in-workspace/lib/browser/search-in-workspace-service */ "../../node_modules/@theia/search-in-workspace/lib/browser/search-in-workspace-service.js");
const workspace_functions_1 = __webpack_require__(/*! ../common/workspace-functions */ "../../node_modules/@theia/ai-ide/lib/common/workspace-functions.js");
let WorkspaceSearchProvider = class WorkspaceSearchProvider {
    constructor() {
        this.MAX_RESULTS = 50;
    }
    getTool() {
        return {
            id: workspace_functions_1.SEARCH_IN_WORKSPACE_FUNCTION_ID,
            name: workspace_functions_1.SEARCH_IN_WORKSPACE_FUNCTION_ID,
            description: 'Searches the content of files within the workspace for lines matching the given search term (`query`). \
            The search uses case-insensitive string matching or regular expressions (controlled by the `useRegExp` parameter). \
            It returns a list of matching files, including the file path (URI), the line number, and the full text content of each matching line. \
            Multi-word patterns must match exactly (including spaces, case-insensitively). \
            For complex searches, prefer multiple simpler queries over one complex query or regular expression.',
            parameters: {
                type: 'object',
                properties: {
                    query: {
                        type: 'string',
                        description: 'The search term or regular expression pattern.',
                    },
                    useRegExp: {
                        type: 'boolean',
                        description: 'Set to true if the query is a regular expression.',
                    }
                },
                required: ['query', 'useRegExp']
            },
            handler: (argString, ctx) => { var _a; return this.handleSearch(argString, (_a = ctx === null || ctx === void 0 ? void 0 : ctx.response) === null || _a === void 0 ? void 0 : _a.cancellationToken); }
        };
    }
    async handleSearch(argString, cancellationToken) {
        try {
            const args = JSON.parse(argString);
            const results = [];
            let expectedSearchId;
            let searchCompleted = false;
            const searchPromise = new Promise((resolve, reject) => {
                const callbacks = {
                    onResult: (id, result) => {
                        if (expectedSearchId !== undefined && id !== expectedSearchId) {
                            return;
                        }
                        if (searchCompleted) {
                            return;
                        }
                        results.push(result);
                    },
                    onDone: (id, error) => {
                        if (expectedSearchId !== undefined && id !== expectedSearchId) {
                            return;
                        }
                        if (searchCompleted) {
                            return;
                        }
                        searchCompleted = true;
                        if (error) {
                            reject(new Error(`Search failed: ${error}`));
                        }
                        else {
                            resolve(results);
                        }
                    }
                };
                const options = {
                    useRegExp: args.useRegExp,
                    matchCase: false,
                    matchWholeWord: false,
                    maxResults: this.MAX_RESULTS,
                };
                this.searchService.search(args.query, callbacks, options)
                    .then(id => {
                    expectedSearchId = id;
                    cancellationToken === null || cancellationToken === void 0 ? void 0 : cancellationToken.onCancellationRequested(() => {
                        this.searchService.cancel(id);
                    });
                })
                    .catch(err => {
                    searchCompleted = true;
                    reject(err);
                });
            });
            const timeoutPromise = new Promise((_, reject) => {
                setTimeout(() => {
                    if (expectedSearchId !== undefined && !searchCompleted) {
                        this.searchService.cancel(expectedSearchId);
                        searchCompleted = true;
                        reject(new Error('Search timed out after 30 seconds'));
                    }
                }, 30000);
            });
            const finalResults = await Promise.race([searchPromise, timeoutPromise]);
            const formattedResults = finalResults.map(r => ({
                file: r.fileUri,
                matches: r.matches.map(m => ({ line: m.line, text: m.lineText }))
            }));
            return JSON.stringify(formattedResults);
        }
        catch (error) {
            return JSON.stringify({ error: error.message || 'Failed to execute search' });
        }
    }
};
exports.WorkspaceSearchProvider = WorkspaceSearchProvider;
tslib_1.__decorate([
    (0, inversify_1.inject)(search_in_workspace_service_1.SearchInWorkspaceService),
    tslib_1.__metadata("design:type", search_in_workspace_service_1.SearchInWorkspaceService)
], WorkspaceSearchProvider.prototype, "searchService", void 0);
exports.WorkspaceSearchProvider = WorkspaceSearchProvider = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], WorkspaceSearchProvider);


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/browser/workspace-task-provider.js":
/*!*******************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/browser/workspace-task-provider.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TaskRunnerProvider = exports.TaskListProvider = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const task_service_1 = __webpack_require__(/*! @theia/task/lib/browser/task-service */ "../../node_modules/@theia/task/lib/browser/task-service.js");
const terminal_service_1 = __webpack_require__(/*! @theia/terminal/lib/browser/base/terminal-service */ "../../node_modules/@theia/terminal/lib/browser/base/terminal-service.js");
const workspace_functions_1 = __webpack_require__(/*! ../common/workspace-functions */ "../../node_modules/@theia/ai-ide/lib/common/workspace-functions.js");
let TaskListProvider = class TaskListProvider {
    getTool() {
        return {
            id: workspace_functions_1.LIST_TASKS_FUNCTION_ID,
            name: workspace_functions_1.LIST_TASKS_FUNCTION_ID,
            description: 'Lists available tool tasks in the workspace, such as build, run, test. Tasks can be filtered by name.',
            parameters: {
                type: 'object',
                properties: {
                    filter: {
                        type: 'string',
                        description: 'Filter to apply on task names (empty string to retrieve all tasks).'
                    }
                },
                required: ['filter']
            },
            handler: async (argString) => {
                const filterArgs = JSON.parse(argString);
                const tasks = await this.getAvailableTasks(filterArgs.filter);
                const taskString = JSON.stringify(tasks);
                return taskString;
            }
        };
    }
    async getAvailableTasks(filter = '') {
        const userActionToken = this.taskService.startUserAction();
        const tasks = await this.taskService.getTasks(userActionToken);
        const filteredTasks = tasks.filter(task => task.label.toLowerCase().includes(filter.toLowerCase()));
        return filteredTasks.map(task => task.label);
    }
};
exports.TaskListProvider = TaskListProvider;
tslib_1.__decorate([
    (0, inversify_1.inject)(task_service_1.TaskService),
    tslib_1.__metadata("design:type", task_service_1.TaskService)
], TaskListProvider.prototype, "taskService", void 0);
exports.TaskListProvider = TaskListProvider = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], TaskListProvider);
let TaskRunnerProvider = class TaskRunnerProvider {
    getTool() {
        return {
            id: workspace_functions_1.RUN_TASK_FUNCTION_ID,
            name: workspace_functions_1.RUN_TASK_FUNCTION_ID,
            description: 'Executes a specified task.',
            parameters: {
                type: 'object',
                properties: {
                    taskName: {
                        type: 'string',
                        description: 'The name of the task to execute.'
                    }
                },
                required: ['taskName']
            },
            handler: async (argString, ctx) => { var _a; return this.handleRunTask(argString, (_a = ctx === null || ctx === void 0 ? void 0 : ctx.response) === null || _a === void 0 ? void 0 : _a.cancellationToken); }
        };
    }
    async handleRunTask(argString, cancellationToken) {
        var _a, _b;
        try {
            const args = JSON.parse(argString);
            const token = this.taskService.startUserAction();
            const taskInfo = await this.taskService.runTaskByLabel(token, args.taskName);
            if (!taskInfo) {
                return `Did not find a task for the label: '${args.taskName}'`;
            }
            cancellationToken === null || cancellationToken === void 0 ? void 0 : cancellationToken.onCancellationRequested(() => {
                this.taskService.terminateTask(taskInfo);
            });
            const signal = await this.taskService.getTerminateSignal(taskInfo.taskId);
            if (taskInfo.terminalId) {
                const terminal = this.terminalService.getByTerminalId(taskInfo.terminalId);
                const length = (_a = terminal === null || terminal === void 0 ? void 0 : terminal.buffer.length) !== null && _a !== void 0 ? _a : 0;
                const numberOfLines = Math.min(length, 50);
                const result = [];
                const allLines = (_b = terminal === null || terminal === void 0 ? void 0 : terminal.buffer.getLines(0, length).reverse()) !== null && _b !== void 0 ? _b : [];
                // collect the first 50 lines:
                const firstLines = allLines.slice(0, numberOfLines);
                result.push(...firstLines);
                // collect the last 50 lines:
                if (length > numberOfLines) {
                    const lastLines = allLines.slice(length - numberOfLines);
                    result.push(...lastLines);
                }
                terminal === null || terminal === void 0 ? void 0 : terminal.clearOutput();
                return result.join('\n');
            }
            return `No terminal output available. The terminate signal was :${signal}.`;
        }
        catch (error) {
            return JSON.stringify({ success: false, message: error.message || 'Failed to run task' });
        }
    }
};
exports.TaskRunnerProvider = TaskRunnerProvider;
tslib_1.__decorate([
    (0, inversify_1.inject)(task_service_1.TaskService),
    tslib_1.__metadata("design:type", task_service_1.TaskService)
], TaskRunnerProvider.prototype, "taskService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(terminal_service_1.TerminalService),
    tslib_1.__metadata("design:type", Object)
], TaskRunnerProvider.prototype, "terminalService", void 0);
exports.TaskRunnerProvider = TaskRunnerProvider = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], TaskRunnerProvider);


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/common/architect-prompt-template.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/common/architect-prompt-template.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.architectTaskSummaryPromptTemplate = exports.architectPromptTemplate = exports.ARCHITECT_TASK_SUMMARY_PROMPT_TEMPLATE_ID = void 0;
const workspace_functions_1 = __webpack_require__(/*! ./workspace-functions */ "../../node_modules/@theia/ai-ide/lib/common/workspace-functions.js");
const context_variables_1 = __webpack_require__(/*! ./context-variables */ "../../node_modules/@theia/ai-ide/lib/common/context-variables.js");
exports.ARCHITECT_TASK_SUMMARY_PROMPT_TEMPLATE_ID = 'architect-task-summary';
exports.architectPromptTemplate = {
    id: 'architect-system',
    template: `{{!-- This prompt is licensed under the MIT License (https://opensource.org/license/mit).
Made improvements or adaptations to this prompt template? We’d love for you to share it with the community! Contribute back here:
https://github.com/eclipse-theia/theia/discussions/new?category=prompt-template-contribution --}}
# Instructions

You are an AI assistant integrated into Theia IDE, designed to assist software developers. You can't change any files, but you can navigate and read the users workspace using \
the provided functions. Therefore describe and explain the details or procedures necessary to achieve the desired outcome. If file changes are necessary to help the user, be \
aware that there is another agent called 'Coder' that can suggest file changes. In this case you can create a description on what to do and tell the user to ask '@Coder' to \
implement the change plan. If you refer to files, always mention the workspace-relative path.\

Use the following functions to interact with the workspace files as needed:
- **~{${workspace_functions_1.GET_WORKSPACE_DIRECTORY_STRUCTURE_FUNCTION_ID}}**: Returns the complete directory structure.
- **~{${workspace_functions_1.GET_WORKSPACE_FILE_LIST_FUNCTION_ID}}**: Lists files and directories in a specific directory.
- **~{${workspace_functions_1.FILE_CONTENT_FUNCTION_ID}}**: Retrieves the content of a specific file.

### Workspace Navigation Guidelines

1. **Start at the Root**: For general questions (e.g., "How to build the project"), check root-level documentation files or setup files before browsing subdirectories.
2. **Confirm Paths**: Always verify paths by listing directories or files as you navigate. Avoid assumptions based on user input alone.
3. **Navigate Step-by-Step**: Move into subdirectories only as needed, confirming each directory level.

## Additional Context

The following files have been provided for additional context. Some of them may also be referred to by the user. \
Always look at the relevant files to understand your task using the function ~{${workspace_functions_1.FILE_CONTENT_FUNCTION_ID}}.
{{${context_variables_1.CONTEXT_FILES_VARIABLE_ID}}}

{{prompt:project-info}}
`
};
exports.architectTaskSummaryPromptTemplate = {
    id: exports.ARCHITECT_TASK_SUMMARY_PROMPT_TEMPLATE_ID,
    template: `{{!-- This prompt is licensed under the MIT License (https://opensource.org/license/mit).
Made improvements or adaptations to this prompt template? We'd love for you to share it with the community! Contribute back here:
https://github.com/eclipse-theia/theia/discussions/new?category=prompt-template-contribution --}}

Your task is to analyze the current chat session and summarize it to prepare to complete the coding task.
Your instructions should be complete. They are used by a coding agent.
Include all necessary information. 
Use unique identifiers such as file paths or URIs to artifacts.
Skip irrelevant information, e.g. for discussions, only sum up the final result.

## Instructions
1. Analyze the conversation carefully.
2. Identify the main coding objective and requirements.
3. Propose a clear approach to implement the requested functionality in task steps.
4. If any part of the task is ambiguous, note the ambiguity so that it can be clarified later.

Focus on providing actionable steps and implementation guidance. The coding agent needs practical help with this specific coding task.
`,
    variantOf: 'architect-system'
};


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/common/coder-replace-prompt-template.js":
/*!************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/common/coder-replace-prompt-template.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/* eslint-disable @typescript-eslint/tslint/config */
// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH and others.
//
// This file is licensed under the MIT License.
// See LICENSE-MIT.txt in the project root for license information.
// https://opensource.org/license/mit.
//
// SPDX-License-Identifier: MIT
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getCoderReplacePromptTemplate = exports.getCoderReplacePromptTemplateNext = exports.CODER_REPLACE_PROMPT_TEMPLATE_NEXT_ID = exports.CODER_REPLACE_PROMPT_TEMPLATE_ID = exports.CODER_REWRITE_PROMPT_TEMPLATE_ID = void 0;
const ai_chat_1 = __webpack_require__(/*! @theia/ai-chat */ "../../node_modules/@theia/ai-chat/lib/common/index.js");
const workspace_functions_1 = __webpack_require__(/*! ./workspace-functions */ "../../node_modules/@theia/ai-ide/lib/common/workspace-functions.js");
const context_variables_1 = __webpack_require__(/*! ./context-variables */ "../../node_modules/@theia/ai-ide/lib/common/context-variables.js");
const context_functions_1 = __webpack_require__(/*! ./context-functions */ "../../node_modules/@theia/ai-ide/lib/common/context-functions.js");
exports.CODER_REWRITE_PROMPT_TEMPLATE_ID = 'coder-rewrite';
exports.CODER_REPLACE_PROMPT_TEMPLATE_ID = 'coder-search-replace';
exports.CODER_REPLACE_PROMPT_TEMPLATE_NEXT_ID = 'coder-search-replace-next';
function getCoderReplacePromptTemplateNext() {
    return {
        id: exports.CODER_REPLACE_PROMPT_TEMPLATE_NEXT_ID,
        template: `{{!-- This prompt is licensed under the MIT License (https://opensource.org/license/mit).
Made improvements or adaptations to this prompt template? We’d love for you to share it with the community! Contribute back here:
https://github.com/eclipse-theia/theia/discussions/new?category=prompt-template-contribution --}}
You are an AI assistant integrated into Theia IDE, designed to assist software developers with code tasks. You can interact with the code base and suggest changes.

## Context Retrieval
Use the following functions to interact with the workspace files if you require context:
- **~{${workspace_functions_1.GET_WORKSPACE_DIRECTORY_STRUCTURE_FUNCTION_ID}}**: Returns the complete directory structure.
- **~{${workspace_functions_1.GET_WORKSPACE_FILE_LIST_FUNCTION_ID}}**: Lists files and directories in a specific directory.
- **~{${workspace_functions_1.FILE_CONTENT_FUNCTION_ID}}**: Retrieves the content of a specific file.
- **~{${context_functions_1.UPDATE_CONTEXT_FILES_FUNCTION_ID}}**: Remember file locations that are relevant for completing your tasks. Only add files that are really relevant to look at later.

## File Validation
Use the following function to retrieve a list of problems in a file if the user requests fixes in a given file:
- **~{${workspace_functions_1.GET_FILE_DIAGNOSTICS_ID}}**: Retrieves a list of problems identified in a given file by tool integrations such as language servers and linters.

## Propose Code Changes
To propose code changes or any file changes to the user, never print code or new file content in your response.

Instead, for each file you want to propose changes for:
- **Always Retrieve Current Content**: Use ${workspace_functions_1.FILE_CONTENT_FUNCTION_ID} to get the latest content of the target file.
- **Change Content**: Use ~{changeSet_writeChangeToFile} or ~{changeSet_replaceContentInFile} to propose file changes to the user.\
If ~{changeSet_replaceContentInFile} continously fails use ~{changeSet_writeChangeToFile}. Calling a function on a file will override previous \
function calls on the same file, so you need exactly one successful call with all proposed changes per changed file. The changes will be presented as a applicable diff to \
the user in any case.'
  
## File Search

To search for content in workspace files, use the following function: ~{${workspace_functions_1.SEARCH_IN_WORKSPACE_FUNCTION_ID}}

## Tasks

The user might want you to execute some task. You can find tasks using ~{${workspace_functions_1.LIST_TASKS_FUNCTION_ID}} and execute them using ~{${workspace_functions_1.RUN_TASK_FUNCTION_ID}}.

## Additional Context

The following files have been provided for additional context. Some of them may also be referred to by the user. \
Always look at the relevant files to understand your task using the function ~{${workspace_functions_1.FILE_CONTENT_FUNCTION_ID}}
{{${context_variables_1.CONTEXT_FILES_VARIABLE_ID}}}

## Previously Proposed Changes
You have previously proposed changes for the following files. Some suggestions may have been accepted by the user, while others may still be pending.
{{${ai_chat_1.CHANGE_SET_SUMMARY_VARIABLE_ID}}}

{{prompt:project-info}}
`,
        ...({ variantOf: exports.CODER_REPLACE_PROMPT_TEMPLATE_ID }),
    };
}
exports.getCoderReplacePromptTemplateNext = getCoderReplacePromptTemplateNext;
function getCoderReplacePromptTemplate(withSearchAndReplace = false) {
    return {
        id: withSearchAndReplace ? exports.CODER_REPLACE_PROMPT_TEMPLATE_ID : exports.CODER_REWRITE_PROMPT_TEMPLATE_ID,
        template: `{{!-- This prompt is licensed under the MIT License (https://opensource.org/license/mit).
Made improvements or adaptations to this prompt template? We’d love for you to share it with the community! Contribute back here:
https://github.com/eclipse-theia/theia/discussions/new?category=prompt-template-contribution --}}
You are an AI assistant integrated into Theia IDE, designed to assist software developers with code tasks. You can interact with the code base and suggest changes.

## Context Retrieval
Use the following functions to interact with the workspace files if you require context:
- **~{${workspace_functions_1.GET_WORKSPACE_DIRECTORY_STRUCTURE_FUNCTION_ID}}**: Returns the complete directory structure.
- **~{${workspace_functions_1.GET_WORKSPACE_FILE_LIST_FUNCTION_ID}}**: Lists files and directories in a specific directory.
- **~{${workspace_functions_1.FILE_CONTENT_FUNCTION_ID}}**: Retrieves the content of a specific file.
- **~{${context_functions_1.UPDATE_CONTEXT_FILES_FUNCTION_ID}}**: Remember file locations that are relevant for completing your tasks. Only add files that are really relevant to look at later.

## File Validation
Use the following function to retrieve a list of problems in a file if the user requests fixes in a given file:
- **~{${workspace_functions_1.GET_FILE_DIAGNOSTICS_ID}}**: Retrieves a list of problems identified in a given file by tool integrations such as language servers and linters.

## Propose Code Changes
To propose code changes or any file changes to the user, never print code or new file content in your response.

Instead, for each file you want to propose changes for:
- **Always Retrieve Current Content**: Use ${workspace_functions_1.FILE_CONTENT_FUNCTION_ID} to get the latest content of the target file.
- **Change Content**: Use ~{changeSet_writeChangeToFile}${withSearchAndReplace ? ' or ~{changeSet_replaceContentInFile}' : ''} to propose file changes to the user.\
${withSearchAndReplace ? ' If ~{changeSet_replaceContentInFile} continously fails use ~{changeSet_writeChangeToFile}. Calling a function on a file will override previous \
function calls on the same file, so you need exactly one successful call with all proposed changes per changed file. The changes will be presented as a applicable diff to \
the user in any case.' : ''}

## Additional Context

The following files have been provided for additional context. Some of them may also be referred to by the user. \
Always look at the relevant files to understand your task using the function ~{${workspace_functions_1.FILE_CONTENT_FUNCTION_ID}}
{{${context_variables_1.CONTEXT_FILES_VARIABLE_ID}}}

{{${ai_chat_1.CHANGE_SET_SUMMARY_VARIABLE_ID}}}

{{prompt:project-info}}

{{${context_variables_1.TASK_CONTEXT_SUMMARY_VARIABLE_ID}}}
`,
        ...(!withSearchAndReplace ? { variantOf: exports.CODER_REPLACE_PROMPT_TEMPLATE_ID } : {}),
    };
}
exports.getCoderReplacePromptTemplate = getCoderReplacePromptTemplate;


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/common/command-chat-agents.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/common/command-chat-agents.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CommandChatAgent = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const chat_agents_1 = __webpack_require__(/*! @theia/ai-chat/lib/common/chat-agents */ "../../node_modules/@theia/ai-chat/lib/common/chat-agents.js");
const chat_model_1 = __webpack_require__(/*! @theia/ai-chat/lib/common/chat-model */ "../../node_modules/@theia/ai-chat/lib/common/chat-model.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const command_prompt_template_1 = __webpack_require__(/*! ./command-prompt-template */ "../../node_modules/@theia/ai-ide/lib/common/command-prompt-template.js");
let CommandChatAgent = class CommandChatAgent extends chat_agents_1.AbstractTextToModelParsingChatAgent {
    constructor() {
        super(...arguments);
        this.id = 'Command';
        this.name = 'Command';
        this.languageModelRequirements = [{
                purpose: 'command',
                identifier: 'openai/gpt-4o',
            }];
        this.defaultLanguageModelPurpose = 'command';
        this.description = 'This agent is aware of all commands that the user can execute within the Theia IDE, the tool that the user is currently working with. \
    Based on the user request, it can find the right command and then let the user execute it.';
        this.promptTemplates = [command_prompt_template_1.commandTemplate];
        this.agentSpecificVariables = [{
                name: 'command-ids',
                description: 'The list of available commands in Theia.',
                usedInPrompt: true
            }];
    }
    async getSystemMessageDescription(context) {
        const knownCommands = [];
        for (const command of this.commandRegistry.getAllCommands()) {
            knownCommands.push(`${command.id}: ${command.label}`);
        }
        const systemPrompt = await this.promptService.getPrompt(command_prompt_template_1.commandTemplate.id, {
            'command-ids': knownCommands.join('\n')
        }, context);
        if (systemPrompt === undefined) {
            throw new Error('Couldn\'t get system prompt ');
        }
        return chat_agents_1.SystemMessageDescription.fromResolvedPromptTemplate(systemPrompt);
    }
    /**
     * @param text the text received from the language model
     * @returns the parsed command if the text contained a valid command.
     * If there was no json in the text, return a no-command response.
     */
    async parseTextResponse(text) {
        const jsonMatch = text.match(/(\{[\s\S]*\})/);
        const jsonString = jsonMatch ? jsonMatch[1] : `{
    "type": "no-command",
    "message": "Please try again."
}`;
        const parsedCommand = JSON.parse(jsonString);
        return parsedCommand;
    }
    createResponseContent(parsedCommand, request) {
        var _a;
        if (parsedCommand.type === 'theia-command') {
            const theiaCommand = this.commandRegistry.getCommand(parsedCommand.commandId);
            if (theiaCommand === undefined) {
                console.error(`No Theia Command with id ${parsedCommand.commandId}`);
                request.cancel();
            }
            const args = parsedCommand.arguments !== undefined &&
                parsedCommand.arguments.length > 0
                ? parsedCommand.arguments
                : undefined;
            return new chat_model_1.HorizontalLayoutChatResponseContentImpl([
                new chat_model_1.MarkdownChatResponseContentImpl('I found this command that might help you:'),
                new chat_model_1.CommandChatResponseContentImpl(theiaCommand, undefined, args),
            ]);
        }
        else if (parsedCommand.type === 'custom-handler') {
            const id = `ai-command-${(0, core_1.generateUuid)()}`;
            const commandArgs = parsedCommand.arguments !== undefined && parsedCommand.arguments.length > 0 ? parsedCommand.arguments : [];
            const args = [id, ...commandArgs];
            const customCallback = {
                label: 'AI command',
                callback: () => this.commandCallback(...args),
            };
            return new chat_model_1.HorizontalLayoutChatResponseContentImpl([
                new chat_model_1.MarkdownChatResponseContentImpl('Try executing this:'),
                new chat_model_1.CommandChatResponseContentImpl(undefined, customCallback, args),
            ]);
        }
        else {
            return new chat_model_1.MarkdownChatResponseContentImpl((_a = parsedCommand.message) !== null && _a !== void 0 ? _a : 'Sorry, I can\'t find such a command');
        }
    }
    async commandCallback(...commandArgs) {
        this.messageService.info(`Executing callback with args ${commandArgs.join(', ')}. The first arg is the command id registered for the dynamically registered command. \
        The other args are the actual args for the handler.`, 'Got it');
    }
};
exports.CommandChatAgent = CommandChatAgent;
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.CommandRegistry),
    tslib_1.__metadata("design:type", core_1.CommandRegistry)
], CommandChatAgent.prototype, "commandRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.MessageService),
    tslib_1.__metadata("design:type", core_1.MessageService)
], CommandChatAgent.prototype, "messageService", void 0);
exports.CommandChatAgent = CommandChatAgent = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], CommandChatAgent);


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/common/command-prompt-template.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/common/command-prompt-template.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/* eslint-disable @typescript-eslint/tslint/config */
// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH and others.
//
// This file is licensed under the MIT License.
// See LICENSE-MIT.txt in the project root for license information.
// https://opensource.org/license/mit.
//
// SPDX-License-Identifier: MIT
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.commandTemplate = void 0;
exports.commandTemplate = {
    id: 'command-system',
    template: `{{!-- This prompt is licensed under the MIT License (https://opensource.org/license/mit).
Made improvements or adaptations to this prompt template? We\u2019d love for you to share it with the community! Contribute back here:
https://github.com/eclipse-theia/theia/discussions/new?category=prompt-template-contribution --}}
# System Prompt

You are a service that helps users find commands to execute in an IDE.
You reply with stringified JSON Objects that tell the user which command to execute and its arguments, if any. 

# Examples

The examples start with a short explanation of the return object. 
The response can be found within the markdown \`\`\`json and \`\`\` markers.
Please include these markers in the reply.

Never under any circumstances may you reply with just the command-id!

## Example 1

This reply is to tell the user to execute the \`theia-ai-prompt-template:show-prompts-command\` command that is available in the Theia command registry.

\`\`\`json
{
    "type": "theia-command",
    "commandId": "theia-ai-prompt-template:show-prompts-command"
}
\`\`\`

## Example 2

This reply is to tell the user to execute the \`theia-ai-prompt-template:show-prompts-command\` command that is available in the theia command registry, 
when the user want to pass arguments to the command.

\`\`\`json
{
    "type": "theia-command",
    "commandId": "theia-ai-prompt-template:show-prompts-command",
    "arguments": ["foo"]
}
\`\`\`

## Example 3

This reply is for custom commands that are not registered in the Theia command registry. 
These commands always have the command id \`ai-chat.command-chat-response.generic\`.
The arguments are an array and may differ, depending on the user's instructions. 

\`\`\`json
{
    "type": "custom-handler",
    "commandId": "ai-chat.command-chat-response.generic",
    "arguments": ["foo", "bar"]
}
\`\`\`

## Example 4

This reply of type no-command is for cases where you can't find a proper command. 
You may use the message to explain the situation to the user.

\`\`\`json
{
    "type": "no-command",
    "message": "a message explaining what is wrong"
}
\`\`\`

# Rules

## Theia Commands

If a user asks for a Theia command, or the context implies it is about a command in Theia, return a response with \`"type": "theia-command"\`.
You need to exchange the "commandId". 
The available command ids in Theia are in the list below. The list of commands is formatted like this:

command-id1: Label1
command-id2: Label2
command-id3: 
command-id4: Label4

The Labels may be empty, but there is always a command-id.

Suggest a command that probably fits the user's message based on the label and the command ids you know. 
If you have multiple commands that fit, return the one that fits best. We only want a single command in the reply.
If the user says that the last command was not right, try to return the next best fit based on the conversation history with the user.

If there are no more command ids that seem to fit, return a response of \`"type": "no-command"\` explaining the situation.

Here are the known Theia commands:

Begin List:
{{command-ids}}
End List

You may only use commands from this list when responding with \`"type": "theia-command"\`.
Do not come up with command ids that are not in this list.
If you need to do this, use the \`"type": "no-command"\`. instead

## Custom Handlers

If the user asks for a command that is not a Theia command, return a response with \`"type": "custom-handler"\`.

## Other Cases

In all other cases, return a reply of \`"type": "no-command"\`.

# Examples of Invalid Responses

## Invalid Response Example 1

This example is invalid because it returns text and two commands. 
Only one command should be replied, and it must be parseable JSON.

### The Example

Yes, there are a few more theme-related commands. Here is another one:

\`\`\`json
{
    "type": "theia-command",
    "commandId": "workbench.action.selectIconTheme"
}
\`\`\`

And another one:

\`\`\`json
{
    "type": "theia-command",
    "commandId": "core.close.right.tabs"
}
\`\`\`

## Invalid Response Example 2

The following example is invalid because it only returns the command id and is not parseable JSON:

### The Example

workbench.action.selectIconTheme

## Invalid Response Example 3

The following example is invalid because it returns a message with the command id. We need JSON objects based on the above rules.
Do not respond like this in any case! We need a command of \`"type": "theia-command"\`.

The expected response would be:
\`\`\`json
{
    "type": "theia-command",
    "commandId": "core.close.right.tabs"
}
\`\`\`

### The Example

I found this command that might help you: core.close.right.tabs

## Invalid Response Example 4

The following example is invalid because it has an explanation string before the JSON. 
We only want the JSON!

### The Example

You can toggle high contrast mode with this command:

\`\`\`json
{
    "type": "theia-command",
    "commandId": "editor.action.toggleHighContrast"
}
\`\`\`

## Invalid Response Example 5

The following example is invalid because it explains that no command was found. 
We want a response of \`"type": "no-command"\` and have the message there.

### The Example

There is no specific command available to "open the windows" in the provided Theia command list.

## Invalid Response Example 6

In this example we were using the following theia id command list:

Begin List:
container--theia-open-editors-widget: Hello
foo:toggle-visibility-explorer-view-container--files: Label 1
foo:toggle-visibility-explorer-view-container--plugin-view: Label 2
End List

The problem is that workbench.action.toggleHighContrast is not in this list. 
theia-command types may only use commandIds from this list. 
This should have been of \`"type": "no-command"\`.

### The Example

\`\`\`json
{
    "type": "theia-command",
    "commandId": "workbench.action.toggleHighContrast"
}
\`\`\`

`
};


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/common/context-files-variable.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/common/context-files-variable.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ContextFilesVariableContribution = exports.CONTEXT_FILES_VARIABLE = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const ai_chat_1 = __webpack_require__(/*! @theia/ai-chat */ "../../node_modules/@theia/ai-chat/lib/common/index.js");
const context_variables_1 = __webpack_require__(/*! ./context-variables */ "../../node_modules/@theia/ai-ide/lib/common/context-variables.js");
exports.CONTEXT_FILES_VARIABLE = {
    id: context_variables_1.CONTEXT_FILES_VARIABLE_ID,
    description: core_1.nls.localize('theia/ai/core/contextSummaryVariable/description', 'Describes files in the context for a given session.'),
    name: context_variables_1.CONTEXT_FILES_VARIABLE_ID,
};
let ContextFilesVariableContribution = class ContextFilesVariableContribution {
    registerVariables(service) {
        service.registerResolver(exports.CONTEXT_FILES_VARIABLE, this);
    }
    canResolve(request, context) {
        return request.variable.name === exports.CONTEXT_FILES_VARIABLE.name ? 50 : 0;
    }
    async resolve(request, context) {
        if (!ai_chat_1.ChatSessionContext.is(context) || request.variable.name !== exports.CONTEXT_FILES_VARIABLE.name) {
            return undefined;
        }
        const variables = ai_chat_1.ChatSessionContext.getVariables(context);
        return {
            variable: exports.CONTEXT_FILES_VARIABLE,
            value: variables.filter(variable => variable.variable.name === 'file' && !!variable.arg)
                .map(variable => `- ${variable.arg}`).join('\n')
        };
    }
};
exports.ContextFilesVariableContribution = ContextFilesVariableContribution;
exports.ContextFilesVariableContribution = ContextFilesVariableContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ContextFilesVariableContribution);


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/common/context-functions.js":
/*!************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/common/context-functions.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LIST_CHAT_CONTEXT_FUNCTION_ID = exports.RESOLVE_CHAT_CONTEXT_FUNCTION_ID = exports.UPDATE_CONTEXT_FILES_FUNCTION_ID = void 0;
exports.UPDATE_CONTEXT_FILES_FUNCTION_ID = 'context_addFile';
exports.RESOLVE_CHAT_CONTEXT_FUNCTION_ID = 'context_ResolveChatContext';
exports.LIST_CHAT_CONTEXT_FUNCTION_ID = 'context_ListChatContext';


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/common/context-variables.js":
/*!************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/common/context-variables.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TASK_CONTEXT_SUMMARY_VARIABLE_ID = exports.CONTEXT_FILES_VARIABLE_ID = void 0;
exports.CONTEXT_FILES_VARIABLE_ID = 'contextFiles';
exports.TASK_CONTEXT_SUMMARY_VARIABLE_ID = 'taskContextSummary';


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/common/orchestrator-chat-agent.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/common/orchestrator-chat-agent.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.OrchestratorChatAgent = exports.OrchestratorChatAgentId = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const ai_core_1 = __webpack_require__(/*! @theia/ai-core */ "../../node_modules/@theia/ai-core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const chat_agent_service_1 = __webpack_require__(/*! @theia/ai-chat/lib/common/chat-agent-service */ "../../node_modules/@theia/ai-chat/lib/common/chat-agent-service.js");
const chat_agents_1 = __webpack_require__(/*! @theia/ai-chat/lib/common/chat-agents */ "../../node_modules/@theia/ai-chat/lib/common/chat-agents.js");
const chat_model_1 = __webpack_require__(/*! @theia/ai-chat/lib/common/chat-model */ "../../node_modules/@theia/ai-chat/lib/common/chat-model.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const orchestrator_prompt_template_1 = __webpack_require__(/*! ./orchestrator-prompt-template */ "../../node_modules/@theia/ai-ide/lib/common/orchestrator-prompt-template.js");
exports.OrchestratorChatAgentId = 'Orchestrator';
const OrchestratorRequestIdKey = 'orchestatorRequestIdKey';
let OrchestratorChatAgent = class OrchestratorChatAgent extends chat_agents_1.AbstractStreamParsingChatAgent {
    constructor() {
        super(...arguments);
        this.id = exports.OrchestratorChatAgentId;
        this.name = exports.OrchestratorChatAgentId;
        this.languageModelRequirements = [{
                purpose: 'agent-selection',
                identifier: 'openai/gpt-4o',
            }];
        this.defaultLanguageModelPurpose = 'agent-selection';
        this.variables = ['chatAgents'];
        this.promptTemplates = [orchestrator_prompt_template_1.orchestratorTemplate];
        this.description = core_1.nls.localize('theia/ai/chat/orchestrator/description', 'This agent analyzes the user request against the description of all available chat agents and selects the best fitting agent to answer the request \
    (by using AI).The user\'s request will be directly delegated to the selected agent without further confirmation.');
        this.iconClass = 'codicon codicon-symbol-boolean';
        this.systemPromptId = orchestrator_prompt_template_1.orchestratorTemplate.id;
        this.fallBackChatAgentId = 'Universal';
    }
    async invoke(request) {
        request.response.addProgressMessage({ content: 'Determining the most appropriate agent', status: 'inProgress' });
        // We generate a dedicated ID for recording the orchestrator request/response, as we will forward the original request to another agent
        const orchestratorRequestId = (0, core_1.generateUuid)();
        request.addData(OrchestratorRequestIdKey, orchestratorRequestId);
        return super.invoke(request);
    }
    // override sendLlmRequest to modify the data sent to the recording service
    // should no longer be needed after https://github.com/eclipse-theia/theia/issues/15221
    async sendLlmRequest(request, messages, toolRequests, languageModel) {
        var _a;
        const agentSettings = this.getLlmSettings();
        const settings = { ...agentSettings, ...request.session.settings };
        const tools = toolRequests.length > 0 ? toolRequests : undefined;
        this.recordingService.recordRequest({
            agentId: this.id,
            sessionId: request.session.id,
            requestId: (_a = request.getDataByKey(OrchestratorRequestIdKey)) !== null && _a !== void 0 ? _a : request.id,
            request: messages
        });
        return this.languageModelService.sendRequest(languageModel, {
            messages,
            tools,
            settings,
            agentId: this.id,
            sessionId: request.session.id,
            requestId: request.id,
            cancellationToken: request.response.cancellationToken
        });
    }
    // override onResponseComplete to not send data to the communication service on completion
    // should no longer be needed after https://github.com/eclipse-theia/theia/issues/15221
    async onResponseComplete(request) {
        return request.response.complete();
    }
    async addContentsToResponse(response, request) {
        var _a, _b;
        const responseText = await (0, ai_core_1.getTextOfResponse)(response);
        // record orchestrator response
        this.recordingService.recordResponse({
            agentId: this.id,
            sessionId: request.session.id,
            requestId: (_a = request.getDataByKey(OrchestratorRequestIdKey)) !== null && _a !== void 0 ? _a : request.id,
            response: [{ type: 'text', actor: 'ai', text: responseText }]
        });
        let agentIds = [];
        try {
            const jsonResponse = await (0, ai_core_1.getJsonOfText)(responseText);
            if (Array.isArray(jsonResponse)) {
                agentIds = jsonResponse.filter((id) => id !== this.id);
            }
        }
        catch (error) {
            // The llm sometimes does not return a parseable result
            this.logger.error('Failed to parse JSON response', error);
        }
        if (agentIds.length < 1) {
            this.logger.error('No agent was selected, delegating to fallback chat agent');
            request.response.progressMessages.forEach(progressMessage => request.response.updateProgressMessage({ ...progressMessage, status: 'failed' }));
            agentIds = [this.fallBackChatAgentId];
        }
        // check if selected (or fallback) agent exists
        if (!this.chatAgentService.getAgent(agentIds[0])) {
            this.logger.error(`Chat agent ${agentIds[0]} not found. Falling back to first registered agent.`);
            const firstRegisteredAgent = (_b = this.chatAgentService.getAgents().filter(a => a.id !== this.id)[0]) === null || _b === void 0 ? void 0 : _b.id;
            if (firstRegisteredAgent) {
                agentIds = [firstRegisteredAgent];
            }
            else {
                throw new Error('No chat agent available to handle request. Please check your configuration whether any are enabled.');
            }
        }
        // TODO support delegating to more than one agent
        const delegatedToAgent = agentIds[0];
        request.response.response.addContent(new chat_model_1.InformationalChatResponseContentImpl(`*Orchestrator*: Delegating to \`@${delegatedToAgent}\`
            
            ---

            `));
        request.response.overrideAgentId(delegatedToAgent);
        request.response.progressMessages.forEach(progressMessage => request.response.updateProgressMessage({ ...progressMessage, status: 'completed' }));
        const agent = this.chatAgentService.getAgent(delegatedToAgent);
        if (!agent) {
            throw new Error(`Chat agent ${delegatedToAgent} not found.`);
        }
        await agent.invoke(request);
    }
};
exports.OrchestratorChatAgent = OrchestratorChatAgent;
tslib_1.__decorate([
    (0, inversify_1.inject)(chat_agent_service_1.ChatAgentService),
    tslib_1.__metadata("design:type", Object)
], OrchestratorChatAgent.prototype, "chatAgentService", void 0);
exports.OrchestratorChatAgent = OrchestratorChatAgent = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], OrchestratorChatAgent);


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/common/orchestrator-prompt-template.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/common/orchestrator-prompt-template.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/* eslint-disable @typescript-eslint/tslint/config */
// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH and others.
//
// This file is licensed under the MIT License.
// See LICENSE-MIT.txt in the project root for license information.
// https://opensource.org/license/mit.
//
// SPDX-License-Identifier: MIT
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.orchestratorTemplate = void 0;
exports.orchestratorTemplate = {
    id: 'orchestrator-system',
    template: `{{!-- This prompt is licensed under the MIT License (https://opensource.org/license/mit).
Made improvements or adaptations to this prompt template? We’d love for you to share it with the community! Contribute back here:
https://github.com/eclipse-theia/theia/discussions/new?category=prompt-template-contribution --}}
# Instructions

Your task is to identify which Chat Agent(s) should best reply a given user's message.
You consider all messages of the conversation to ensure consistency and avoid agent switches without a clear context change.
You should select the best Chat Agent based on the name and description of the agents, matching them to the user message.

## Constraints

Your response must be a JSON array containing the id(s) of the selected Chat Agent(s).

* Do not use ids that are not provided in the list below.
* Do not include any additional information, explanations, or questions for the user.
* If there is no suitable choice, pick \`Universal\`.
* If there are multiple good choices, return all of them.

Unless there is a more specific agent available, select \`Universal\`, especially for general programming-related questions.
You must only use the \`id\` attribute of the agent, never the name.

### Example Results

\`\`\`json
["Universal"]
\`\`\`

\`\`\`json
["AnotherChatAgent", "Universal"]
\`\`\`

## List of Currently Available Chat Agents

{{chatAgents}}
`
};


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/common/summarize-session-commands.js":
/*!*********************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/common/summarize-session-commands.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AI_SUMMARIZE_SESSION_AS_TASK_FOR_CODER = void 0;
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
exports.AI_SUMMARIZE_SESSION_AS_TASK_FOR_CODER = core_1.Command.toLocalizedCommand({
    id: 'ai-chat:summarize-session-as-task-for-coder',
    label: 'Summarize Session as Task for Coder'
});


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/common/universal-chat-agent.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/common/universal-chat-agent.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UniversalChatAgent = exports.UniversalChatAgentId = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const chat_agents_1 = __webpack_require__(/*! @theia/ai-chat/lib/common/chat-agents */ "../../node_modules/@theia/ai-chat/lib/common/chat-agents.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const universal_prompt_template_1 = __webpack_require__(/*! ./universal-prompt-template */ "../../node_modules/@theia/ai-ide/lib/common/universal-prompt-template.js");
exports.UniversalChatAgentId = 'Universal';
let UniversalChatAgent = class UniversalChatAgent extends chat_agents_1.AbstractStreamParsingChatAgent {
    constructor() {
        super(...arguments);
        this.id = exports.UniversalChatAgentId;
        this.name = exports.UniversalChatAgentId;
        this.languageModelRequirements = [{
                purpose: 'chat',
                identifier: 'openai/gpt-4o',
            }];
        this.defaultLanguageModelPurpose = 'chat';
        this.description = core_1.nls.localize('theia/ai/chat/universal/description', 'This agent is designed to help software developers by providing concise and accurate '
            + 'answers to general programming and software development questions. It is also the fall-back for any generic '
            + 'questions the user might ask. The universal agent currently does not have any context by default, i.e. it cannot '
            + 'access the current user context or the workspace.');
        this.promptTemplates = [universal_prompt_template_1.universalTemplate, universal_prompt_template_1.universalTemplateVariant];
        this.systemPromptId = universal_prompt_template_1.universalTemplate.id;
    }
};
exports.UniversalChatAgent = UniversalChatAgent;
exports.UniversalChatAgent = UniversalChatAgent = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], UniversalChatAgent);


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/common/universal-prompt-template.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/common/universal-prompt-template.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/* eslint-disable @typescript-eslint/tslint/config */
// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH and others.
//
// This file is licensed under the MIT License.
// See LICENSE-MIT.txt in the project root for license information.
// https://opensource.org/license/mit.
//
// SPDX-License-Identifier: MIT
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.universalTemplateVariant = exports.universalTemplate = void 0;
const ai_chat_1 = __webpack_require__(/*! @theia/ai-chat */ "../../node_modules/@theia/ai-chat/lib/common/index.js");
exports.universalTemplate = {
    id: 'universal-system',
    template: `{{!-- This prompt is licensed under the MIT License (https://opensource.org/license/mit).
Made improvements or adaptations to this prompt template? We’d love for you to share it with the community! Contribute back here:
https://github.com/eclipse-theia/theia/discussions/new?category=prompt-template-contribution --}}

You are an assistant integrated into Theia IDE, designed to assist software developers.

## Current Context
Some files and other pieces of data may have been added by the user to the context of the chat. If any have, the details can be found below.
{{${ai_chat_1.CHAT_CONTEXT_DETAILS_VARIABLE_ID}}}
`
};
exports.universalTemplateVariant = {
    id: 'universal-system-empty',
    template: '',
    variantOf: exports.universalTemplate.id,
};


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/lib/common/workspace-functions.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/lib/common/workspace-functions.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RUN_TASK_FUNCTION_ID = exports.LIST_TASKS_FUNCTION_ID = exports.SEARCH_IN_WORKSPACE_FUNCTION_ID = exports.GET_FILE_DIAGNOSTICS_ID = exports.GET_WORKSPACE_DIRECTORY_STRUCTURE_FUNCTION_ID = exports.GET_WORKSPACE_FILE_LIST_FUNCTION_ID = exports.FILE_CONTENT_FUNCTION_ID = void 0;
// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
exports.FILE_CONTENT_FUNCTION_ID = 'getFileContent';
exports.GET_WORKSPACE_FILE_LIST_FUNCTION_ID = 'getWorkspaceFileList';
exports.GET_WORKSPACE_DIRECTORY_STRUCTURE_FUNCTION_ID = 'getWorkspaceDirectoryStructure';
exports.GET_FILE_DIAGNOSTICS_ID = 'getFileDiagnostics';
exports.SEARCH_IN_WORKSPACE_FUNCTION_ID = 'searchInWorkspace';
exports.LIST_TASKS_FUNCTION_ID = 'listTasks';
exports.RUN_TASK_FUNCTION_ID = 'runTask';


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/node_modules/ignore/index.js":
/*!*********************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/node_modules/ignore/index.js ***!
  \*********************************************************************/
/***/ ((module) => {

// A simple implementation of make-array
function makeArray (subject) {
  return Array.isArray(subject)
    ? subject
    : [subject]
}

const EMPTY = ''
const SPACE = ' '
const ESCAPE = '\\'
const REGEX_TEST_BLANK_LINE = /^\s+$/
const REGEX_INVALID_TRAILING_BACKSLASH = /(?:[^\\]|^)\\$/
const REGEX_REPLACE_LEADING_EXCAPED_EXCLAMATION = /^\\!/
const REGEX_REPLACE_LEADING_EXCAPED_HASH = /^\\#/
const REGEX_SPLITALL_CRLF = /\r?\n/g
// /foo,
// ./foo,
// ../foo,
// .
// ..
const REGEX_TEST_INVALID_PATH = /^\.*\/|^\.+$/

const SLASH = '/'

// Do not use ternary expression here, since "istanbul ignore next" is buggy
let TMP_KEY_IGNORE = 'node-ignore'
/* istanbul ignore else */
if (typeof Symbol !== 'undefined') {
  TMP_KEY_IGNORE = Symbol.for('node-ignore')
}
const KEY_IGNORE = TMP_KEY_IGNORE

const define = (object, key, value) =>
  Object.defineProperty(object, key, {value})

const REGEX_REGEXP_RANGE = /([0-z])-([0-z])/g

const RETURN_FALSE = () => false

// Sanitize the range of a regular expression
// The cases are complicated, see test cases for details
const sanitizeRange = range => range.replace(
  REGEX_REGEXP_RANGE,
  (match, from, to) => from.charCodeAt(0) <= to.charCodeAt(0)
    ? match
    // Invalid range (out of order) which is ok for gitignore rules but
    //   fatal for JavaScript regular expression, so eliminate it.
    : EMPTY
)

// See fixtures #59
const cleanRangeBackSlash = slashes => {
  const {length} = slashes
  return slashes.slice(0, length - length % 2)
}

// > If the pattern ends with a slash,
// > it is removed for the purpose of the following description,
// > but it would only find a match with a directory.
// > In other words, foo/ will match a directory foo and paths underneath it,
// > but will not match a regular file or a symbolic link foo
// >  (this is consistent with the way how pathspec works in general in Git).
// '`foo/`' will not match regular file '`foo`' or symbolic link '`foo`'
// -> ignore-rules will not deal with it, because it costs extra `fs.stat` call
//      you could use option `mark: true` with `glob`

// '`foo/`' should not continue with the '`..`'
const REPLACERS = [

  [
    // remove BOM
    // TODO:
    // Other similar zero-width characters?
    /^\uFEFF/,
    () => EMPTY
  ],

  // > Trailing spaces are ignored unless they are quoted with backslash ("\")
  [
    // (a\ ) -> (a )
    // (a  ) -> (a)
    // (a ) -> (a)
    // (a \ ) -> (a  )
    /((?:\\\\)*?)(\\?\s+)$/,
    (_, m1, m2) => m1 + (
      m2.indexOf('\\') === 0
        ? SPACE
        : EMPTY
    )
  ],

  // replace (\ ) with ' '
  // (\ ) -> ' '
  // (\\ ) -> '\\ '
  // (\\\ ) -> '\\ '
  [
    /(\\+?)\s/g,
    (_, m1) => {
      const {length} = m1
      return m1.slice(0, length - length % 2) + SPACE
    }
  ],

  // Escape metacharacters
  // which is written down by users but means special for regular expressions.

  // > There are 12 characters with special meanings:
  // > - the backslash \,
  // > - the caret ^,
  // > - the dollar sign $,
  // > - the period or dot .,
  // > - the vertical bar or pipe symbol |,
  // > - the question mark ?,
  // > - the asterisk or star *,
  // > - the plus sign +,
  // > - the opening parenthesis (,
  // > - the closing parenthesis ),
  // > - and the opening square bracket [,
  // > - the opening curly brace {,
  // > These special characters are often called "metacharacters".
  [
    /[\\$.|*+(){^]/g,
    match => `\\${match}`
  ],

  [
    // > a question mark (?) matches a single character
    /(?!\\)\?/g,
    () => '[^/]'
  ],

  // leading slash
  [

    // > A leading slash matches the beginning of the pathname.
    // > For example, "/*.c" matches "cat-file.c" but not "mozilla-sha1/sha1.c".
    // A leading slash matches the beginning of the pathname
    /^\//,
    () => '^'
  ],

  // replace special metacharacter slash after the leading slash
  [
    /\//g,
    () => '\\/'
  ],

  [
    // > A leading "**" followed by a slash means match in all directories.
    // > For example, "**/foo" matches file or directory "foo" anywhere,
    // > the same as pattern "foo".
    // > "**/foo/bar" matches file or directory "bar" anywhere that is directly
    // >   under directory "foo".
    // Notice that the '*'s have been replaced as '\\*'
    /^\^*\\\*\\\*\\\//,

    // '**/foo' <-> 'foo'
    () => '^(?:.*\\/)?'
  ],

  // starting
  [
    // there will be no leading '/'
    //   (which has been replaced by section "leading slash")
    // If starts with '**', adding a '^' to the regular expression also works
    /^(?=[^^])/,
    function startingReplacer () {
      // If has a slash `/` at the beginning or middle
      return !/\/(?!$)/.test(this)
        // > Prior to 2.22.1
        // > If the pattern does not contain a slash /,
        // >   Git treats it as a shell glob pattern
        // Actually, if there is only a trailing slash,
        //   git also treats it as a shell glob pattern

        // After 2.22.1 (compatible but clearer)
        // > If there is a separator at the beginning or middle (or both)
        // > of the pattern, then the pattern is relative to the directory
        // > level of the particular .gitignore file itself.
        // > Otherwise the pattern may also match at any level below
        // > the .gitignore level.
        ? '(?:^|\\/)'

        // > Otherwise, Git treats the pattern as a shell glob suitable for
        // >   consumption by fnmatch(3)
        : '^'
    }
  ],

  // two globstars
  [
    // Use lookahead assertions so that we could match more than one `'/**'`
    /\\\/\\\*\\\*(?=\\\/|$)/g,

    // Zero, one or several directories
    // should not use '*', or it will be replaced by the next replacer

    // Check if it is not the last `'/**'`
    (_, index, str) => index + 6 < str.length

      // case: /**/
      // > A slash followed by two consecutive asterisks then a slash matches
      // >   zero or more directories.
      // > For example, "a/**/b" matches "a/b", "a/x/b", "a/x/y/b" and so on.
      // '/**/'
      ? '(?:\\/[^\\/]+)*'

      // case: /**
      // > A trailing `"/**"` matches everything inside.

      // #21: everything inside but it should not include the current folder
      : '\\/.+'
  ],

  // normal intermediate wildcards
  [
    // Never replace escaped '*'
    // ignore rule '\*' will match the path '*'

    // 'abc.*/' -> go
    // 'abc.*'  -> skip this rule,
    //    coz trailing single wildcard will be handed by [trailing wildcard]
    /(^|[^\\]+)(\\\*)+(?=.+)/g,

    // '*.js' matches '.js'
    // '*.js' doesn't match 'abc'
    (_, p1, p2) => {
      // 1.
      // > An asterisk "*" matches anything except a slash.
      // 2.
      // > Other consecutive asterisks are considered regular asterisks
      // > and will match according to the previous rules.
      const unescaped = p2.replace(/\\\*/g, '[^\\/]*')
      return p1 + unescaped
    }
  ],

  [
    // unescape, revert step 3 except for back slash
    // For example, if a user escape a '\\*',
    // after step 3, the result will be '\\\\\\*'
    /\\\\\\(?=[$.|*+(){^])/g,
    () => ESCAPE
  ],

  [
    // '\\\\' -> '\\'
    /\\\\/g,
    () => ESCAPE
  ],

  [
    // > The range notation, e.g. [a-zA-Z],
    // > can be used to match one of the characters in a range.

    // `\` is escaped by step 3
    /(\\)?\[([^\]/]*?)(\\*)($|\])/g,
    (match, leadEscape, range, endEscape, close) => leadEscape === ESCAPE
      // '\\[bar]' -> '\\\\[bar\\]'
      ? `\\[${range}${cleanRangeBackSlash(endEscape)}${close}`
      : close === ']'
        ? endEscape.length % 2 === 0
          // A normal case, and it is a range notation
          // '[bar]'
          // '[bar\\\\]'
          ? `[${sanitizeRange(range)}${endEscape}]`
          // Invalid range notaton
          // '[bar\\]' -> '[bar\\\\]'
          : '[]'
        : '[]'
  ],

  // ending
  [
    // 'js' will not match 'js.'
    // 'ab' will not match 'abc'
    /(?:[^*])$/,

    // WTF!
    // https://git-scm.com/docs/gitignore
    // changes in [2.22.1](https://git-scm.com/docs/gitignore/2.22.1)
    // which re-fixes #24, #38

    // > If there is a separator at the end of the pattern then the pattern
    // > will only match directories, otherwise the pattern can match both
    // > files and directories.

    // 'js*' will not match 'a.js'
    // 'js/' will not match 'a.js'
    // 'js' will match 'a.js' and 'a.js/'
    match => /\/$/.test(match)
      // foo/ will not match 'foo'
      ? `${match}$`
      // foo matches 'foo' and 'foo/'
      : `${match}(?=$|\\/$)`
  ],

  // trailing wildcard
  [
    /(\^|\\\/)?\\\*$/,
    (_, p1) => {
      const prefix = p1
        // '\^':
        // '/*' does not match EMPTY
        // '/*' does not match everything

        // '\\\/':
        // 'abc/*' does not match 'abc/'
        ? `${p1}[^/]+`

        // 'a*' matches 'a'
        // 'a*' matches 'aa'
        : '[^/]*'

      return `${prefix}(?=$|\\/$)`
    }
  ],
]

// A simple cache, because an ignore rule only has only one certain meaning
const regexCache = Object.create(null)

// @param {pattern}
const makeRegex = (pattern, ignoreCase) => {
  let source = regexCache[pattern]

  if (!source) {
    source = REPLACERS.reduce(
      (prev, [matcher, replacer]) =>
        prev.replace(matcher, replacer.bind(pattern)),
      pattern
    )
    regexCache[pattern] = source
  }

  return ignoreCase
    ? new RegExp(source, 'i')
    : new RegExp(source)
}

const isString = subject => typeof subject === 'string'

// > A blank line matches no files, so it can serve as a separator for readability.
const checkPattern = pattern => pattern
  && isString(pattern)
  && !REGEX_TEST_BLANK_LINE.test(pattern)
  && !REGEX_INVALID_TRAILING_BACKSLASH.test(pattern)

  // > A line starting with # serves as a comment.
  && pattern.indexOf('#') !== 0

const splitPattern = pattern => pattern.split(REGEX_SPLITALL_CRLF)

class IgnoreRule {
  constructor (
    origin,
    pattern,
    negative,
    regex
  ) {
    this.origin = origin
    this.pattern = pattern
    this.negative = negative
    this.regex = regex
  }
}

const createRule = (pattern, ignoreCase) => {
  const origin = pattern
  let negative = false

  // > An optional prefix "!" which negates the pattern;
  if (pattern.indexOf('!') === 0) {
    negative = true
    pattern = pattern.substr(1)
  }

  pattern = pattern
  // > Put a backslash ("\") in front of the first "!" for patterns that
  // >   begin with a literal "!", for example, `"\!important!.txt"`.
  .replace(REGEX_REPLACE_LEADING_EXCAPED_EXCLAMATION, '!')
  // > Put a backslash ("\") in front of the first hash for patterns that
  // >   begin with a hash.
  .replace(REGEX_REPLACE_LEADING_EXCAPED_HASH, '#')

  const regex = makeRegex(pattern, ignoreCase)

  return new IgnoreRule(
    origin,
    pattern,
    negative,
    regex
  )
}

const throwError = (message, Ctor) => {
  throw new Ctor(message)
}

const checkPath = (path, originalPath, doThrow) => {
  if (!isString(path)) {
    return doThrow(
      `path must be a string, but got \`${originalPath}\``,
      TypeError
    )
  }

  // We don't know if we should ignore EMPTY, so throw
  if (!path) {
    return doThrow(`path must not be empty`, TypeError)
  }

  // Check if it is a relative path
  if (checkPath.isNotRelative(path)) {
    const r = '`path.relative()`d'
    return doThrow(
      `path should be a ${r} string, but got "${originalPath}"`,
      RangeError
    )
  }

  return true
}

const isNotRelative = path => REGEX_TEST_INVALID_PATH.test(path)

checkPath.isNotRelative = isNotRelative
checkPath.convert = p => p

class Ignore {
  constructor ({
    ignorecase = true,
    ignoreCase = ignorecase,
    allowRelativePaths = false
  } = {}) {
    define(this, KEY_IGNORE, true)

    this._rules = []
    this._ignoreCase = ignoreCase
    this._allowRelativePaths = allowRelativePaths
    this._initCache()
  }

  _initCache () {
    this._ignoreCache = Object.create(null)
    this._testCache = Object.create(null)
  }

  _addPattern (pattern) {
    // #32
    if (pattern && pattern[KEY_IGNORE]) {
      this._rules = this._rules.concat(pattern._rules)
      this._added = true
      return
    }

    if (checkPattern(pattern)) {
      const rule = createRule(pattern, this._ignoreCase)
      this._added = true
      this._rules.push(rule)
    }
  }

  // @param {Array<string> | string | Ignore} pattern
  add (pattern) {
    this._added = false

    makeArray(
      isString(pattern)
        ? splitPattern(pattern)
        : pattern
    ).forEach(this._addPattern, this)

    // Some rules have just added to the ignore,
    // making the behavior changed.
    if (this._added) {
      this._initCache()
    }

    return this
  }

  // legacy
  addPattern (pattern) {
    return this.add(pattern)
  }

  //          |           ignored : unignored
  // negative |   0:0   |   0:1   |   1:0   |   1:1
  // -------- | ------- | ------- | ------- | --------
  //     0    |  TEST   |  TEST   |  SKIP   |    X
  //     1    |  TESTIF |  SKIP   |  TEST   |    X

  // - SKIP: always skip
  // - TEST: always test
  // - TESTIF: only test if checkUnignored
  // - X: that never happen

  // @param {boolean} whether should check if the path is unignored,
  //   setting `checkUnignored` to `false` could reduce additional
  //   path matching.

  // @returns {TestResult} true if a file is ignored
  _testOne (path, checkUnignored) {
    let ignored = false
    let unignored = false

    this._rules.forEach(rule => {
      const {negative} = rule
      if (
        unignored === negative && ignored !== unignored
        || negative && !ignored && !unignored && !checkUnignored
      ) {
        return
      }

      const matched = rule.regex.test(path)

      if (matched) {
        ignored = !negative
        unignored = negative
      }
    })

    return {
      ignored,
      unignored
    }
  }

  // @returns {TestResult}
  _test (originalPath, cache, checkUnignored, slices) {
    const path = originalPath
      // Supports nullable path
      && checkPath.convert(originalPath)

    checkPath(
      path,
      originalPath,
      this._allowRelativePaths
        ? RETURN_FALSE
        : throwError
    )

    return this._t(path, cache, checkUnignored, slices)
  }

  _t (path, cache, checkUnignored, slices) {
    if (path in cache) {
      return cache[path]
    }

    if (!slices) {
      // path/to/a.js
      // ['path', 'to', 'a.js']
      slices = path.split(SLASH)
    }

    slices.pop()

    // If the path has no parent directory, just test it
    if (!slices.length) {
      return cache[path] = this._testOne(path, checkUnignored)
    }

    const parent = this._t(
      slices.join(SLASH) + SLASH,
      cache,
      checkUnignored,
      slices
    )

    // If the path contains a parent directory, check the parent first
    return cache[path] = parent.ignored
      // > It is not possible to re-include a file if a parent directory of
      // >   that file is excluded.
      ? parent
      : this._testOne(path, checkUnignored)
  }

  ignores (path) {
    return this._test(path, this._ignoreCache, false).ignored
  }

  createFilter () {
    return path => !this.ignores(path)
  }

  filter (paths) {
    return makeArray(paths).filter(this.createFilter())
  }

  // @returns {TestResult}
  test (path) {
    return this._test(path, this._testCache, true)
  }
}

const factory = options => new Ignore(options)

const isPathValid = path =>
  checkPath(path && checkPath.convert(path), path, RETURN_FALSE)

factory.isPathValid = isPathValid

// Fixes typescript
factory.default = factory

module.exports = factory

// Windows
// --------------------------------------------------------------
/* istanbul ignore if */
if (
  // Detect `process` so that it can run in browsers.
  typeof process !== 'undefined'
  && (
    process.env && process.env.IGNORE_TEST_WIN32
    || process.platform === 'win32'
  )
) {
  /* eslint no-control-regex: "off" */
  const makePosix = str => /^\\\\\?\\/.test(str)
  || /["<>|\u0000-\u001F]+/u.test(str)
    ? str
    : str.replace(/\\/g, '/')

  checkPath.convert = makePosix

  // 'C:\\foo'     <- 'C:\\foo' has been converted to 'C:/'
  // 'd:\\foo'
  const REGIX_IS_WINDOWS_PATH_ABSOLUTE = /^[a-z]:\//i
  checkPath.isNotRelative = path =>
    REGIX_IS_WINDOWS_PATH_ABSOLUTE.test(path)
    || isNotRelative(path)
}


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/node_modules/minimatch/dist/commonjs/assert-valid-pattern.js":
/*!*****************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/node_modules/minimatch/dist/commonjs/assert-valid-pattern.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.assertValidPattern = void 0;
const MAX_PATTERN_LENGTH = 1024 * 64;
const assertValidPattern = (pattern) => {
    if (typeof pattern !== 'string') {
        throw new TypeError('invalid pattern');
    }
    if (pattern.length > MAX_PATTERN_LENGTH) {
        throw new TypeError('pattern is too long');
    }
};
exports.assertValidPattern = assertValidPattern;


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/node_modules/minimatch/dist/commonjs/ast.js":
/*!************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/node_modules/minimatch/dist/commonjs/ast.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// parse a single path portion
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AST = void 0;
const brace_expressions_js_1 = __webpack_require__(/*! ./brace-expressions.js */ "../../node_modules/@theia/ai-ide/node_modules/minimatch/dist/commonjs/brace-expressions.js");
const unescape_js_1 = __webpack_require__(/*! ./unescape.js */ "../../node_modules/@theia/ai-ide/node_modules/minimatch/dist/commonjs/unescape.js");
const types = new Set(['!', '?', '+', '*', '@']);
const isExtglobType = (c) => types.has(c);
// Patterns that get prepended to bind to the start of either the
// entire string, or just a single path portion, to prevent dots
// and/or traversal patterns, when needed.
// Exts don't need the ^ or / bit, because the root binds that already.
const startNoTraversal = '(?!(?:^|/)\\.\\.?(?:$|/))';
const startNoDot = '(?!\\.)';
// characters that indicate a start of pattern needs the "no dots" bit,
// because a dot *might* be matched. ( is not in the list, because in
// the case of a child extglob, it will handle the prevention itself.
const addPatternStart = new Set(['[', '.']);
// cases where traversal is A-OK, no dot prevention needed
const justDots = new Set(['..', '.']);
const reSpecials = new Set('().*{}+?[]^$\\!');
const regExpEscape = (s) => s.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, '\\$&');
// any single thing other than /
const qmark = '[^/]';
// * => any number of characters
const star = qmark + '*?';
// use + when we need to ensure that *something* matches, because the * is
// the only thing in the path portion.
const starNoEmpty = qmark + '+?';
// remove the \ chars that we added if we end up doing a nonmagic compare
// const deslash = (s: string) => s.replace(/\\(.)/g, '$1')
class AST {
    type;
    #root;
    #hasMagic;
    #uflag = false;
    #parts = [];
    #parent;
    #parentIndex;
    #negs;
    #filledNegs = false;
    #options;
    #toString;
    // set to true if it's an extglob with no children
    // (which really means one child of '')
    #emptyExt = false;
    constructor(type, parent, options = {}) {
        this.type = type;
        // extglobs are inherently magical
        if (type)
            this.#hasMagic = true;
        this.#parent = parent;
        this.#root = this.#parent ? this.#parent.#root : this;
        this.#options = this.#root === this ? options : this.#root.#options;
        this.#negs = this.#root === this ? [] : this.#root.#negs;
        if (type === '!' && !this.#root.#filledNegs)
            this.#negs.push(this);
        this.#parentIndex = this.#parent ? this.#parent.#parts.length : 0;
    }
    get hasMagic() {
        /* c8 ignore start */
        if (this.#hasMagic !== undefined)
            return this.#hasMagic;
        /* c8 ignore stop */
        for (const p of this.#parts) {
            if (typeof p === 'string')
                continue;
            if (p.type || p.hasMagic)
                return (this.#hasMagic = true);
        }
        // note: will be undefined until we generate the regexp src and find out
        return this.#hasMagic;
    }
    // reconstructs the pattern
    toString() {
        if (this.#toString !== undefined)
            return this.#toString;
        if (!this.type) {
            return (this.#toString = this.#parts.map(p => String(p)).join(''));
        }
        else {
            return (this.#toString =
                this.type + '(' + this.#parts.map(p => String(p)).join('|') + ')');
        }
    }
    #fillNegs() {
        /* c8 ignore start */
        if (this !== this.#root)
            throw new Error('should only call on root');
        if (this.#filledNegs)
            return this;
        /* c8 ignore stop */
        // call toString() once to fill this out
        this.toString();
        this.#filledNegs = true;
        let n;
        while ((n = this.#negs.pop())) {
            if (n.type !== '!')
                continue;
            // walk up the tree, appending everthing that comes AFTER parentIndex
            let p = n;
            let pp = p.#parent;
            while (pp) {
                for (let i = p.#parentIndex + 1; !pp.type && i < pp.#parts.length; i++) {
                    for (const part of n.#parts) {
                        /* c8 ignore start */
                        if (typeof part === 'string') {
                            throw new Error('string part in extglob AST??');
                        }
                        /* c8 ignore stop */
                        part.copyIn(pp.#parts[i]);
                    }
                }
                p = pp;
                pp = p.#parent;
            }
        }
        return this;
    }
    push(...parts) {
        for (const p of parts) {
            if (p === '')
                continue;
            /* c8 ignore start */
            if (typeof p !== 'string' && !(p instanceof AST && p.#parent === this)) {
                throw new Error('invalid part: ' + p);
            }
            /* c8 ignore stop */
            this.#parts.push(p);
        }
    }
    toJSON() {
        const ret = this.type === null
            ? this.#parts.slice().map(p => (typeof p === 'string' ? p : p.toJSON()))
            : [this.type, ...this.#parts.map(p => p.toJSON())];
        if (this.isStart() && !this.type)
            ret.unshift([]);
        if (this.isEnd() &&
            (this === this.#root ||
                (this.#root.#filledNegs && this.#parent?.type === '!'))) {
            ret.push({});
        }
        return ret;
    }
    isStart() {
        if (this.#root === this)
            return true;
        // if (this.type) return !!this.#parent?.isStart()
        if (!this.#parent?.isStart())
            return false;
        if (this.#parentIndex === 0)
            return true;
        // if everything AHEAD of this is a negation, then it's still the "start"
        const p = this.#parent;
        for (let i = 0; i < this.#parentIndex; i++) {
            const pp = p.#parts[i];
            if (!(pp instanceof AST && pp.type === '!')) {
                return false;
            }
        }
        return true;
    }
    isEnd() {
        if (this.#root === this)
            return true;
        if (this.#parent?.type === '!')
            return true;
        if (!this.#parent?.isEnd())
            return false;
        if (!this.type)
            return this.#parent?.isEnd();
        // if not root, it'll always have a parent
        /* c8 ignore start */
        const pl = this.#parent ? this.#parent.#parts.length : 0;
        /* c8 ignore stop */
        return this.#parentIndex === pl - 1;
    }
    copyIn(part) {
        if (typeof part === 'string')
            this.push(part);
        else
            this.push(part.clone(this));
    }
    clone(parent) {
        const c = new AST(this.type, parent);
        for (const p of this.#parts) {
            c.copyIn(p);
        }
        return c;
    }
    static #parseAST(str, ast, pos, opt) {
        let escaping = false;
        let inBrace = false;
        let braceStart = -1;
        let braceNeg = false;
        if (ast.type === null) {
            // outside of a extglob, append until we find a start
            let i = pos;
            let acc = '';
            while (i < str.length) {
                const c = str.charAt(i++);
                // still accumulate escapes at this point, but we do ignore
                // starts that are escaped
                if (escaping || c === '\\') {
                    escaping = !escaping;
                    acc += c;
                    continue;
                }
                if (inBrace) {
                    if (i === braceStart + 1) {
                        if (c === '^' || c === '!') {
                            braceNeg = true;
                        }
                    }
                    else if (c === ']' && !(i === braceStart + 2 && braceNeg)) {
                        inBrace = false;
                    }
                    acc += c;
                    continue;
                }
                else if (c === '[') {
                    inBrace = true;
                    braceStart = i;
                    braceNeg = false;
                    acc += c;
                    continue;
                }
                if (!opt.noext && isExtglobType(c) && str.charAt(i) === '(') {
                    ast.push(acc);
                    acc = '';
                    const ext = new AST(c, ast);
                    i = AST.#parseAST(str, ext, i, opt);
                    ast.push(ext);
                    continue;
                }
                acc += c;
            }
            ast.push(acc);
            return i;
        }
        // some kind of extglob, pos is at the (
        // find the next | or )
        let i = pos + 1;
        let part = new AST(null, ast);
        const parts = [];
        let acc = '';
        while (i < str.length) {
            const c = str.charAt(i++);
            // still accumulate escapes at this point, but we do ignore
            // starts that are escaped
            if (escaping || c === '\\') {
                escaping = !escaping;
                acc += c;
                continue;
            }
            if (inBrace) {
                if (i === braceStart + 1) {
                    if (c === '^' || c === '!') {
                        braceNeg = true;
                    }
                }
                else if (c === ']' && !(i === braceStart + 2 && braceNeg)) {
                    inBrace = false;
                }
                acc += c;
                continue;
            }
            else if (c === '[') {
                inBrace = true;
                braceStart = i;
                braceNeg = false;
                acc += c;
                continue;
            }
            if (isExtglobType(c) && str.charAt(i) === '(') {
                part.push(acc);
                acc = '';
                const ext = new AST(c, part);
                part.push(ext);
                i = AST.#parseAST(str, ext, i, opt);
                continue;
            }
            if (c === '|') {
                part.push(acc);
                acc = '';
                parts.push(part);
                part = new AST(null, ast);
                continue;
            }
            if (c === ')') {
                if (acc === '' && ast.#parts.length === 0) {
                    ast.#emptyExt = true;
                }
                part.push(acc);
                acc = '';
                ast.push(...parts, part);
                return i;
            }
            acc += c;
        }
        // unfinished extglob
        // if we got here, it was a malformed extglob! not an extglob, but
        // maybe something else in there.
        ast.type = null;
        ast.#hasMagic = undefined;
        ast.#parts = [str.substring(pos - 1)];
        return i;
    }
    static fromGlob(pattern, options = {}) {
        const ast = new AST(null, undefined, options);
        AST.#parseAST(pattern, ast, 0, options);
        return ast;
    }
    // returns the regular expression if there's magic, or the unescaped
    // string if not.
    toMMPattern() {
        // should only be called on root
        /* c8 ignore start */
        if (this !== this.#root)
            return this.#root.toMMPattern();
        /* c8 ignore stop */
        const glob = this.toString();
        const [re, body, hasMagic, uflag] = this.toRegExpSource();
        // if we're in nocase mode, and not nocaseMagicOnly, then we do
        // still need a regular expression if we have to case-insensitively
        // match capital/lowercase characters.
        const anyMagic = hasMagic ||
            this.#hasMagic ||
            (this.#options.nocase &&
                !this.#options.nocaseMagicOnly &&
                glob.toUpperCase() !== glob.toLowerCase());
        if (!anyMagic) {
            return body;
        }
        const flags = (this.#options.nocase ? 'i' : '') + (uflag ? 'u' : '');
        return Object.assign(new RegExp(`^${re}$`, flags), {
            _src: re,
            _glob: glob,
        });
    }
    get options() {
        return this.#options;
    }
    // returns the string match, the regexp source, whether there's magic
    // in the regexp (so a regular expression is required) and whether or
    // not the uflag is needed for the regular expression (for posix classes)
    // TODO: instead of injecting the start/end at this point, just return
    // the BODY of the regexp, along with the start/end portions suitable
    // for binding the start/end in either a joined full-path makeRe context
    // (where we bind to (^|/), or a standalone matchPart context (where
    // we bind to ^, and not /).  Otherwise slashes get duped!
    //
    // In part-matching mode, the start is:
    // - if not isStart: nothing
    // - if traversal possible, but not allowed: ^(?!\.\.?$)
    // - if dots allowed or not possible: ^
    // - if dots possible and not allowed: ^(?!\.)
    // end is:
    // - if not isEnd(): nothing
    // - else: $
    //
    // In full-path matching mode, we put the slash at the START of the
    // pattern, so start is:
    // - if first pattern: same as part-matching mode
    // - if not isStart(): nothing
    // - if traversal possible, but not allowed: /(?!\.\.?(?:$|/))
    // - if dots allowed or not possible: /
    // - if dots possible and not allowed: /(?!\.)
    // end is:
    // - if last pattern, same as part-matching mode
    // - else nothing
    //
    // Always put the (?:$|/) on negated tails, though, because that has to be
    // there to bind the end of the negated pattern portion, and it's easier to
    // just stick it in now rather than try to inject it later in the middle of
    // the pattern.
    //
    // We can just always return the same end, and leave it up to the caller
    // to know whether it's going to be used joined or in parts.
    // And, if the start is adjusted slightly, can do the same there:
    // - if not isStart: nothing
    // - if traversal possible, but not allowed: (?:/|^)(?!\.\.?$)
    // - if dots allowed or not possible: (?:/|^)
    // - if dots possible and not allowed: (?:/|^)(?!\.)
    //
    // But it's better to have a simpler binding without a conditional, for
    // performance, so probably better to return both start options.
    //
    // Then the caller just ignores the end if it's not the first pattern,
    // and the start always gets applied.
    //
    // But that's always going to be $ if it's the ending pattern, or nothing,
    // so the caller can just attach $ at the end of the pattern when building.
    //
    // So the todo is:
    // - better detect what kind of start is needed
    // - return both flavors of starting pattern
    // - attach $ at the end of the pattern when creating the actual RegExp
    //
    // Ah, but wait, no, that all only applies to the root when the first pattern
    // is not an extglob. If the first pattern IS an extglob, then we need all
    // that dot prevention biz to live in the extglob portions, because eg
    // +(*|.x*) can match .xy but not .yx.
    //
    // So, return the two flavors if it's #root and the first child is not an
    // AST, otherwise leave it to the child AST to handle it, and there,
    // use the (?:^|/) style of start binding.
    //
    // Even simplified further:
    // - Since the start for a join is eg /(?!\.) and the start for a part
    // is ^(?!\.), we can just prepend (?!\.) to the pattern (either root
    // or start or whatever) and prepend ^ or / at the Regexp construction.
    toRegExpSource(allowDot) {
        const dot = allowDot ?? !!this.#options.dot;
        if (this.#root === this)
            this.#fillNegs();
        if (!this.type) {
            const noEmpty = this.isStart() && this.isEnd();
            const src = this.#parts
                .map(p => {
                const [re, _, hasMagic, uflag] = typeof p === 'string'
                    ? AST.#parseGlob(p, this.#hasMagic, noEmpty)
                    : p.toRegExpSource(allowDot);
                this.#hasMagic = this.#hasMagic || hasMagic;
                this.#uflag = this.#uflag || uflag;
                return re;
            })
                .join('');
            let start = '';
            if (this.isStart()) {
                if (typeof this.#parts[0] === 'string') {
                    // this is the string that will match the start of the pattern,
                    // so we need to protect against dots and such.
                    // '.' and '..' cannot match unless the pattern is that exactly,
                    // even if it starts with . or dot:true is set.
                    const dotTravAllowed = this.#parts.length === 1 && justDots.has(this.#parts[0]);
                    if (!dotTravAllowed) {
                        const aps = addPatternStart;
                        // check if we have a possibility of matching . or ..,
                        // and prevent that.
                        const needNoTrav = 
                        // dots are allowed, and the pattern starts with [ or .
                        (dot && aps.has(src.charAt(0))) ||
                            // the pattern starts with \., and then [ or .
                            (src.startsWith('\\.') && aps.has(src.charAt(2))) ||
                            // the pattern starts with \.\., and then [ or .
                            (src.startsWith('\\.\\.') && aps.has(src.charAt(4)));
                        // no need to prevent dots if it can't match a dot, or if a
                        // sub-pattern will be preventing it anyway.
                        const needNoDot = !dot && !allowDot && aps.has(src.charAt(0));
                        start = needNoTrav ? startNoTraversal : needNoDot ? startNoDot : '';
                    }
                }
            }
            // append the "end of path portion" pattern to negation tails
            let end = '';
            if (this.isEnd() &&
                this.#root.#filledNegs &&
                this.#parent?.type === '!') {
                end = '(?:$|\\/)';
            }
            const final = start + src + end;
            return [
                final,
                (0, unescape_js_1.unescape)(src),
                (this.#hasMagic = !!this.#hasMagic),
                this.#uflag,
            ];
        }
        // We need to calculate the body *twice* if it's a repeat pattern
        // at the start, once in nodot mode, then again in dot mode, so a
        // pattern like *(?) can match 'x.y'
        const repeated = this.type === '*' || this.type === '+';
        // some kind of extglob
        const start = this.type === '!' ? '(?:(?!(?:' : '(?:';
        let body = this.#partsToRegExp(dot);
        if (this.isStart() && this.isEnd() && !body && this.type !== '!') {
            // invalid extglob, has to at least be *something* present, if it's
            // the entire path portion.
            const s = this.toString();
            this.#parts = [s];
            this.type = null;
            this.#hasMagic = undefined;
            return [s, (0, unescape_js_1.unescape)(this.toString()), false, false];
        }
        // XXX abstract out this map method
        let bodyDotAllowed = !repeated || allowDot || dot || !startNoDot
            ? ''
            : this.#partsToRegExp(true);
        if (bodyDotAllowed === body) {
            bodyDotAllowed = '';
        }
        if (bodyDotAllowed) {
            body = `(?:${body})(?:${bodyDotAllowed})*?`;
        }
        // an empty !() is exactly equivalent to a starNoEmpty
        let final = '';
        if (this.type === '!' && this.#emptyExt) {
            final = (this.isStart() && !dot ? startNoDot : '') + starNoEmpty;
        }
        else {
            const close = this.type === '!'
                ? // !() must match something,but !(x) can match ''
                    '))' +
                        (this.isStart() && !dot && !allowDot ? startNoDot : '') +
                        star +
                        ')'
                : this.type === '@'
                    ? ')'
                    : this.type === '?'
                        ? ')?'
                        : this.type === '+' && bodyDotAllowed
                            ? ')'
                            : this.type === '*' && bodyDotAllowed
                                ? `)?`
                                : `)${this.type}`;
            final = start + body + close;
        }
        return [
            final,
            (0, unescape_js_1.unescape)(body),
            (this.#hasMagic = !!this.#hasMagic),
            this.#uflag,
        ];
    }
    #partsToRegExp(dot) {
        return this.#parts
            .map(p => {
            // extglob ASTs should only contain parent ASTs
            /* c8 ignore start */
            if (typeof p === 'string') {
                throw new Error('string type in extglob ast??');
            }
            /* c8 ignore stop */
            // can ignore hasMagic, because extglobs are already always magic
            const [re, _, _hasMagic, uflag] = p.toRegExpSource(dot);
            this.#uflag = this.#uflag || uflag;
            return re;
        })
            .filter(p => !(this.isStart() && this.isEnd()) || !!p)
            .join('|');
    }
    static #parseGlob(glob, hasMagic, noEmpty = false) {
        let escaping = false;
        let re = '';
        let uflag = false;
        for (let i = 0; i < glob.length; i++) {
            const c = glob.charAt(i);
            if (escaping) {
                escaping = false;
                re += (reSpecials.has(c) ? '\\' : '') + c;
                continue;
            }
            if (c === '\\') {
                if (i === glob.length - 1) {
                    re += '\\\\';
                }
                else {
                    escaping = true;
                }
                continue;
            }
            if (c === '[') {
                const [src, needUflag, consumed, magic] = (0, brace_expressions_js_1.parseClass)(glob, i);
                if (consumed) {
                    re += src;
                    uflag = uflag || needUflag;
                    i += consumed - 1;
                    hasMagic = hasMagic || magic;
                    continue;
                }
            }
            if (c === '*') {
                if (noEmpty && glob === '*')
                    re += starNoEmpty;
                else
                    re += star;
                hasMagic = true;
                continue;
            }
            if (c === '?') {
                re += qmark;
                hasMagic = true;
                continue;
            }
            re += regExpEscape(c);
        }
        return [re, (0, unescape_js_1.unescape)(glob), !!hasMagic, uflag];
    }
}
exports.AST = AST;


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/node_modules/minimatch/dist/commonjs/brace-expressions.js":
/*!**************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/node_modules/minimatch/dist/commonjs/brace-expressions.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// translate the various posix character classes into unicode properties
// this works across all unicode locales
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.parseClass = void 0;
// { <posix class>: [<translation>, /u flag required, negated]
const posixClasses = {
    '[:alnum:]': ['\\p{L}\\p{Nl}\\p{Nd}', true],
    '[:alpha:]': ['\\p{L}\\p{Nl}', true],
    '[:ascii:]': ['\\x' + '00-\\x' + '7f', false],
    '[:blank:]': ['\\p{Zs}\\t', true],
    '[:cntrl:]': ['\\p{Cc}', true],
    '[:digit:]': ['\\p{Nd}', true],
    '[:graph:]': ['\\p{Z}\\p{C}', true, true],
    '[:lower:]': ['\\p{Ll}', true],
    '[:print:]': ['\\p{C}', true],
    '[:punct:]': ['\\p{P}', true],
    '[:space:]': ['\\p{Z}\\t\\r\\n\\v\\f', true],
    '[:upper:]': ['\\p{Lu}', true],
    '[:word:]': ['\\p{L}\\p{Nl}\\p{Nd}\\p{Pc}', true],
    '[:xdigit:]': ['A-Fa-f0-9', false],
};
// only need to escape a few things inside of brace expressions
// escapes: [ \ ] -
const braceEscape = (s) => s.replace(/[[\]\\-]/g, '\\$&');
// escape all regexp magic characters
const regexpEscape = (s) => s.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, '\\$&');
// everything has already been escaped, we just have to join
const rangesToString = (ranges) => ranges.join('');
// takes a glob string at a posix brace expression, and returns
// an equivalent regular expression source, and boolean indicating
// whether the /u flag needs to be applied, and the number of chars
// consumed to parse the character class.
// This also removes out of order ranges, and returns ($.) if the
// entire class just no good.
const parseClass = (glob, position) => {
    const pos = position;
    /* c8 ignore start */
    if (glob.charAt(pos) !== '[') {
        throw new Error('not in a brace expression');
    }
    /* c8 ignore stop */
    const ranges = [];
    const negs = [];
    let i = pos + 1;
    let sawStart = false;
    let uflag = false;
    let escaping = false;
    let negate = false;
    let endPos = pos;
    let rangeStart = '';
    WHILE: while (i < glob.length) {
        const c = glob.charAt(i);
        if ((c === '!' || c === '^') && i === pos + 1) {
            negate = true;
            i++;
            continue;
        }
        if (c === ']' && sawStart && !escaping) {
            endPos = i + 1;
            break;
        }
        sawStart = true;
        if (c === '\\') {
            if (!escaping) {
                escaping = true;
                i++;
                continue;
            }
            // escaped \ char, fall through and treat like normal char
        }
        if (c === '[' && !escaping) {
            // either a posix class, a collation equivalent, or just a [
            for (const [cls, [unip, u, neg]] of Object.entries(posixClasses)) {
                if (glob.startsWith(cls, i)) {
                    // invalid, [a-[] is fine, but not [a-[:alpha]]
                    if (rangeStart) {
                        return ['$.', false, glob.length - pos, true];
                    }
                    i += cls.length;
                    if (neg)
                        negs.push(unip);
                    else
                        ranges.push(unip);
                    uflag = uflag || u;
                    continue WHILE;
                }
            }
        }
        // now it's just a normal character, effectively
        escaping = false;
        if (rangeStart) {
            // throw this range away if it's not valid, but others
            // can still match.
            if (c > rangeStart) {
                ranges.push(braceEscape(rangeStart) + '-' + braceEscape(c));
            }
            else if (c === rangeStart) {
                ranges.push(braceEscape(c));
            }
            rangeStart = '';
            i++;
            continue;
        }
        // now might be the start of a range.
        // can be either c-d or c-] or c<more...>] or c] at this point
        if (glob.startsWith('-]', i + 1)) {
            ranges.push(braceEscape(c + '-'));
            i += 2;
            continue;
        }
        if (glob.startsWith('-', i + 1)) {
            rangeStart = c;
            i += 2;
            continue;
        }
        // not the start of a range, just a single character
        ranges.push(braceEscape(c));
        i++;
    }
    if (endPos < i) {
        // didn't see the end of the class, not a valid class,
        // but might still be valid as a literal match.
        return ['', false, 0, false];
    }
    // if we got no ranges and no negates, then we have a range that
    // cannot possibly match anything, and that poisons the whole glob
    if (!ranges.length && !negs.length) {
        return ['$.', false, glob.length - pos, true];
    }
    // if we got one positive range, and it's a single character, then that's
    // not actually a magic pattern, it's just that one literal character.
    // we should not treat that as "magic", we should just return the literal
    // character. [_] is a perfectly valid way to escape glob magic chars.
    if (negs.length === 0 &&
        ranges.length === 1 &&
        /^\\?.$/.test(ranges[0]) &&
        !negate) {
        const r = ranges[0].length === 2 ? ranges[0].slice(-1) : ranges[0];
        return [regexpEscape(r), false, endPos - pos, false];
    }
    const sranges = '[' + (negate ? '^' : '') + rangesToString(ranges) + ']';
    const snegs = '[' + (negate ? '' : '^') + rangesToString(negs) + ']';
    const comb = ranges.length && negs.length
        ? '(' + sranges + '|' + snegs + ')'
        : ranges.length
            ? sranges
            : snegs;
    return [comb, uflag, endPos - pos, true];
};
exports.parseClass = parseClass;


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/node_modules/minimatch/dist/commonjs/escape.js":
/*!***************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/node_modules/minimatch/dist/commonjs/escape.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.escape = void 0;
/**
 * Escape all magic characters in a glob pattern.
 *
 * If the {@link windowsPathsNoEscape | GlobOptions.windowsPathsNoEscape}
 * option is used, then characters are escaped by wrapping in `[]`, because
 * a magic character wrapped in a character class can only be satisfied by
 * that exact character.  In this mode, `\` is _not_ escaped, because it is
 * not interpreted as a magic character, but instead as a path separator.
 */
const escape = (s, { windowsPathsNoEscape = false, } = {}) => {
    // don't need to escape +@! because we escape the parens
    // that make those magic, and escaping ! as [!] isn't valid,
    // because [!]] is a valid glob class meaning not ']'.
    return windowsPathsNoEscape
        ? s.replace(/[?*()[\]]/g, '[$&]')
        : s.replace(/[?*()[\]\\]/g, '\\$&');
};
exports.escape = escape;


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/node_modules/minimatch/dist/commonjs/index.js":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/node_modules/minimatch/dist/commonjs/index.js ***!
  \**************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.unescape = exports.escape = exports.AST = exports.Minimatch = exports.match = exports.makeRe = exports.braceExpand = exports.defaults = exports.filter = exports.GLOBSTAR = exports.sep = exports.minimatch = void 0;
const brace_expansion_1 = __importDefault(__webpack_require__(/*! brace-expansion */ "../../node_modules/brace-expansion/index.js"));
const assert_valid_pattern_js_1 = __webpack_require__(/*! ./assert-valid-pattern.js */ "../../node_modules/@theia/ai-ide/node_modules/minimatch/dist/commonjs/assert-valid-pattern.js");
const ast_js_1 = __webpack_require__(/*! ./ast.js */ "../../node_modules/@theia/ai-ide/node_modules/minimatch/dist/commonjs/ast.js");
const escape_js_1 = __webpack_require__(/*! ./escape.js */ "../../node_modules/@theia/ai-ide/node_modules/minimatch/dist/commonjs/escape.js");
const unescape_js_1 = __webpack_require__(/*! ./unescape.js */ "../../node_modules/@theia/ai-ide/node_modules/minimatch/dist/commonjs/unescape.js");
const minimatch = (p, pattern, options = {}) => {
    (0, assert_valid_pattern_js_1.assertValidPattern)(pattern);
    // shortcut: comments match nothing.
    if (!options.nocomment && pattern.charAt(0) === '#') {
        return false;
    }
    return new Minimatch(pattern, options).match(p);
};
exports.minimatch = minimatch;
// Optimized checking for the most common glob patterns.
const starDotExtRE = /^\*+([^+@!?\*\[\(]*)$/;
const starDotExtTest = (ext) => (f) => !f.startsWith('.') && f.endsWith(ext);
const starDotExtTestDot = (ext) => (f) => f.endsWith(ext);
const starDotExtTestNocase = (ext) => {
    ext = ext.toLowerCase();
    return (f) => !f.startsWith('.') && f.toLowerCase().endsWith(ext);
};
const starDotExtTestNocaseDot = (ext) => {
    ext = ext.toLowerCase();
    return (f) => f.toLowerCase().endsWith(ext);
};
const starDotStarRE = /^\*+\.\*+$/;
const starDotStarTest = (f) => !f.startsWith('.') && f.includes('.');
const starDotStarTestDot = (f) => f !== '.' && f !== '..' && f.includes('.');
const dotStarRE = /^\.\*+$/;
const dotStarTest = (f) => f !== '.' && f !== '..' && f.startsWith('.');
const starRE = /^\*+$/;
const starTest = (f) => f.length !== 0 && !f.startsWith('.');
const starTestDot = (f) => f.length !== 0 && f !== '.' && f !== '..';
const qmarksRE = /^\?+([^+@!?\*\[\(]*)?$/;
const qmarksTestNocase = ([$0, ext = '']) => {
    const noext = qmarksTestNoExt([$0]);
    if (!ext)
        return noext;
    ext = ext.toLowerCase();
    return (f) => noext(f) && f.toLowerCase().endsWith(ext);
};
const qmarksTestNocaseDot = ([$0, ext = '']) => {
    const noext = qmarksTestNoExtDot([$0]);
    if (!ext)
        return noext;
    ext = ext.toLowerCase();
    return (f) => noext(f) && f.toLowerCase().endsWith(ext);
};
const qmarksTestDot = ([$0, ext = '']) => {
    const noext = qmarksTestNoExtDot([$0]);
    return !ext ? noext : (f) => noext(f) && f.endsWith(ext);
};
const qmarksTest = ([$0, ext = '']) => {
    const noext = qmarksTestNoExt([$0]);
    return !ext ? noext : (f) => noext(f) && f.endsWith(ext);
};
const qmarksTestNoExt = ([$0]) => {
    const len = $0.length;
    return (f) => f.length === len && !f.startsWith('.');
};
const qmarksTestNoExtDot = ([$0]) => {
    const len = $0.length;
    return (f) => f.length === len && f !== '.' && f !== '..';
};
/* c8 ignore start */
const defaultPlatform = (typeof process === 'object' && process
    ? (typeof process.env === 'object' &&
        process.env &&
        process.env.__MINIMATCH_TESTING_PLATFORM__) ||
        process.platform
    : 'posix');
const path = {
    win32: { sep: '\\' },
    posix: { sep: '/' },
};
/* c8 ignore stop */
exports.sep = defaultPlatform === 'win32' ? path.win32.sep : path.posix.sep;
exports.minimatch.sep = exports.sep;
exports.GLOBSTAR = Symbol('globstar **');
exports.minimatch.GLOBSTAR = exports.GLOBSTAR;
// any single thing other than /
// don't need to escape / when using new RegExp()
const qmark = '[^/]';
// * => any number of characters
const star = qmark + '*?';
// ** when dots are allowed.  Anything goes, except .. and .
// not (^ or / followed by one or two dots followed by $ or /),
// followed by anything, any number of times.
const twoStarDot = '(?:(?!(?:\\/|^)(?:\\.{1,2})($|\\/)).)*?';
// not a ^ or / followed by a dot,
// followed by anything, any number of times.
const twoStarNoDot = '(?:(?!(?:\\/|^)\\.).)*?';
const filter = (pattern, options = {}) => (p) => (0, exports.minimatch)(p, pattern, options);
exports.filter = filter;
exports.minimatch.filter = exports.filter;
const ext = (a, b = {}) => Object.assign({}, a, b);
const defaults = (def) => {
    if (!def || typeof def !== 'object' || !Object.keys(def).length) {
        return exports.minimatch;
    }
    const orig = exports.minimatch;
    const m = (p, pattern, options = {}) => orig(p, pattern, ext(def, options));
    return Object.assign(m, {
        Minimatch: class Minimatch extends orig.Minimatch {
            constructor(pattern, options = {}) {
                super(pattern, ext(def, options));
            }
            static defaults(options) {
                return orig.defaults(ext(def, options)).Minimatch;
            }
        },
        AST: class AST extends orig.AST {
            /* c8 ignore start */
            constructor(type, parent, options = {}) {
                super(type, parent, ext(def, options));
            }
            /* c8 ignore stop */
            static fromGlob(pattern, options = {}) {
                return orig.AST.fromGlob(pattern, ext(def, options));
            }
        },
        unescape: (s, options = {}) => orig.unescape(s, ext(def, options)),
        escape: (s, options = {}) => orig.escape(s, ext(def, options)),
        filter: (pattern, options = {}) => orig.filter(pattern, ext(def, options)),
        defaults: (options) => orig.defaults(ext(def, options)),
        makeRe: (pattern, options = {}) => orig.makeRe(pattern, ext(def, options)),
        braceExpand: (pattern, options = {}) => orig.braceExpand(pattern, ext(def, options)),
        match: (list, pattern, options = {}) => orig.match(list, pattern, ext(def, options)),
        sep: orig.sep,
        GLOBSTAR: exports.GLOBSTAR,
    });
};
exports.defaults = defaults;
exports.minimatch.defaults = exports.defaults;
// Brace expansion:
// a{b,c}d -> abd acd
// a{b,}c -> abc ac
// a{0..3}d -> a0d a1d a2d a3d
// a{b,c{d,e}f}g -> abg acdfg acefg
// a{b,c}d{e,f}g -> abdeg acdeg abdeg abdfg
//
// Invalid sets are not expanded.
// a{2..}b -> a{2..}b
// a{b}c -> a{b}c
const braceExpand = (pattern, options = {}) => {
    (0, assert_valid_pattern_js_1.assertValidPattern)(pattern);
    // Thanks to Yeting Li <https://github.com/yetingli> for
    // improving this regexp to avoid a ReDOS vulnerability.
    if (options.nobrace || !/\{(?:(?!\{).)*\}/.test(pattern)) {
        // shortcut. no need to expand.
        return [pattern];
    }
    return (0, brace_expansion_1.default)(pattern);
};
exports.braceExpand = braceExpand;
exports.minimatch.braceExpand = exports.braceExpand;
// parse a component of the expanded set.
// At this point, no pattern may contain "/" in it
// so we're going to return a 2d array, where each entry is the full
// pattern, split on '/', and then turned into a regular expression.
// A regexp is made at the end which joins each array with an
// escaped /, and another full one which joins each regexp with |.
//
// Following the lead of Bash 4.1, note that "**" only has special meaning
// when it is the *only* thing in a path portion.  Otherwise, any series
// of * is equivalent to a single *.  Globstar behavior is enabled by
// default, and can be disabled by setting options.noglobstar.
const makeRe = (pattern, options = {}) => new Minimatch(pattern, options).makeRe();
exports.makeRe = makeRe;
exports.minimatch.makeRe = exports.makeRe;
const match = (list, pattern, options = {}) => {
    const mm = new Minimatch(pattern, options);
    list = list.filter(f => mm.match(f));
    if (mm.options.nonull && !list.length) {
        list.push(pattern);
    }
    return list;
};
exports.match = match;
exports.minimatch.match = exports.match;
// replace stuff like \* with *
const globMagic = /[?*]|[+@!]\(.*?\)|\[|\]/;
const regExpEscape = (s) => s.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, '\\$&');
class Minimatch {
    options;
    set;
    pattern;
    windowsPathsNoEscape;
    nonegate;
    negate;
    comment;
    empty;
    preserveMultipleSlashes;
    partial;
    globSet;
    globParts;
    nocase;
    isWindows;
    platform;
    windowsNoMagicRoot;
    regexp;
    constructor(pattern, options = {}) {
        (0, assert_valid_pattern_js_1.assertValidPattern)(pattern);
        options = options || {};
        this.options = options;
        this.pattern = pattern;
        this.platform = options.platform || defaultPlatform;
        this.isWindows = this.platform === 'win32';
        this.windowsPathsNoEscape =
            !!options.windowsPathsNoEscape || options.allowWindowsEscape === false;
        if (this.windowsPathsNoEscape) {
            this.pattern = this.pattern.replace(/\\/g, '/');
        }
        this.preserveMultipleSlashes = !!options.preserveMultipleSlashes;
        this.regexp = null;
        this.negate = false;
        this.nonegate = !!options.nonegate;
        this.comment = false;
        this.empty = false;
        this.partial = !!options.partial;
        this.nocase = !!this.options.nocase;
        this.windowsNoMagicRoot =
            options.windowsNoMagicRoot !== undefined
                ? options.windowsNoMagicRoot
                : !!(this.isWindows && this.nocase);
        this.globSet = [];
        this.globParts = [];
        this.set = [];
        // make the set of regexps etc.
        this.make();
    }
    hasMagic() {
        if (this.options.magicalBraces && this.set.length > 1) {
            return true;
        }
        for (const pattern of this.set) {
            for (const part of pattern) {
                if (typeof part !== 'string')
                    return true;
            }
        }
        return false;
    }
    debug(..._) { }
    make() {
        const pattern = this.pattern;
        const options = this.options;
        // empty patterns and comments match nothing.
        if (!options.nocomment && pattern.charAt(0) === '#') {
            this.comment = true;
            return;
        }
        if (!pattern) {
            this.empty = true;
            return;
        }
        // step 1: figure out negation, etc.
        this.parseNegate();
        // step 2: expand braces
        this.globSet = [...new Set(this.braceExpand())];
        if (options.debug) {
            this.debug = (...args) => console.error(...args);
        }
        this.debug(this.pattern, this.globSet);
        // step 3: now we have a set, so turn each one into a series of
        // path-portion matching patterns.
        // These will be regexps, except in the case of "**", which is
        // set to the GLOBSTAR object for globstar behavior,
        // and will not contain any / characters
        //
        // First, we preprocess to make the glob pattern sets a bit simpler
        // and deduped.  There are some perf-killing patterns that can cause
        // problems with a glob walk, but we can simplify them down a bit.
        const rawGlobParts = this.globSet.map(s => this.slashSplit(s));
        this.globParts = this.preprocess(rawGlobParts);
        this.debug(this.pattern, this.globParts);
        // glob --> regexps
        let set = this.globParts.map((s, _, __) => {
            if (this.isWindows && this.windowsNoMagicRoot) {
                // check if it's a drive or unc path.
                const isUNC = s[0] === '' &&
                    s[1] === '' &&
                    (s[2] === '?' || !globMagic.test(s[2])) &&
                    !globMagic.test(s[3]);
                const isDrive = /^[a-z]:/i.test(s[0]);
                if (isUNC) {
                    return [...s.slice(0, 4), ...s.slice(4).map(ss => this.parse(ss))];
                }
                else if (isDrive) {
                    return [s[0], ...s.slice(1).map(ss => this.parse(ss))];
                }
            }
            return s.map(ss => this.parse(ss));
        });
        this.debug(this.pattern, set);
        // filter out everything that didn't compile properly.
        this.set = set.filter(s => s.indexOf(false) === -1);
        // do not treat the ? in UNC paths as magic
        if (this.isWindows) {
            for (let i = 0; i < this.set.length; i++) {
                const p = this.set[i];
                if (p[0] === '' &&
                    p[1] === '' &&
                    this.globParts[i][2] === '?' &&
                    typeof p[3] === 'string' &&
                    /^[a-z]:$/i.test(p[3])) {
                    p[2] = '?';
                }
            }
        }
        this.debug(this.pattern, this.set);
    }
    // various transforms to equivalent pattern sets that are
    // faster to process in a filesystem walk.  The goal is to
    // eliminate what we can, and push all ** patterns as far
    // to the right as possible, even if it increases the number
    // of patterns that we have to process.
    preprocess(globParts) {
        // if we're not in globstar mode, then turn all ** into *
        if (this.options.noglobstar) {
            for (let i = 0; i < globParts.length; i++) {
                for (let j = 0; j < globParts[i].length; j++) {
                    if (globParts[i][j] === '**') {
                        globParts[i][j] = '*';
                    }
                }
            }
        }
        const { optimizationLevel = 1 } = this.options;
        if (optimizationLevel >= 2) {
            // aggressive optimization for the purpose of fs walking
            globParts = this.firstPhasePreProcess(globParts);
            globParts = this.secondPhasePreProcess(globParts);
        }
        else if (optimizationLevel >= 1) {
            // just basic optimizations to remove some .. parts
            globParts = this.levelOneOptimize(globParts);
        }
        else {
            // just collapse multiple ** portions into one
            globParts = this.adjascentGlobstarOptimize(globParts);
        }
        return globParts;
    }
    // just get rid of adjascent ** portions
    adjascentGlobstarOptimize(globParts) {
        return globParts.map(parts => {
            let gs = -1;
            while (-1 !== (gs = parts.indexOf('**', gs + 1))) {
                let i = gs;
                while (parts[i + 1] === '**') {
                    i++;
                }
                if (i !== gs) {
                    parts.splice(gs, i - gs);
                }
            }
            return parts;
        });
    }
    // get rid of adjascent ** and resolve .. portions
    levelOneOptimize(globParts) {
        return globParts.map(parts => {
            parts = parts.reduce((set, part) => {
                const prev = set[set.length - 1];
                if (part === '**' && prev === '**') {
                    return set;
                }
                if (part === '..') {
                    if (prev && prev !== '..' && prev !== '.' && prev !== '**') {
                        set.pop();
                        return set;
                    }
                }
                set.push(part);
                return set;
            }, []);
            return parts.length === 0 ? [''] : parts;
        });
    }
    levelTwoFileOptimize(parts) {
        if (!Array.isArray(parts)) {
            parts = this.slashSplit(parts);
        }
        let didSomething = false;
        do {
            didSomething = false;
            // <pre>/<e>/<rest> -> <pre>/<rest>
            if (!this.preserveMultipleSlashes) {
                for (let i = 1; i < parts.length - 1; i++) {
                    const p = parts[i];
                    // don't squeeze out UNC patterns
                    if (i === 1 && p === '' && parts[0] === '')
                        continue;
                    if (p === '.' || p === '') {
                        didSomething = true;
                        parts.splice(i, 1);
                        i--;
                    }
                }
                if (parts[0] === '.' &&
                    parts.length === 2 &&
                    (parts[1] === '.' || parts[1] === '')) {
                    didSomething = true;
                    parts.pop();
                }
            }
            // <pre>/<p>/../<rest> -> <pre>/<rest>
            let dd = 0;
            while (-1 !== (dd = parts.indexOf('..', dd + 1))) {
                const p = parts[dd - 1];
                if (p && p !== '.' && p !== '..' && p !== '**') {
                    didSomething = true;
                    parts.splice(dd - 1, 2);
                    dd -= 2;
                }
            }
        } while (didSomething);
        return parts.length === 0 ? [''] : parts;
    }
    // First phase: single-pattern processing
    // <pre> is 1 or more portions
    // <rest> is 1 or more portions
    // <p> is any portion other than ., .., '', or **
    // <e> is . or ''
    //
    // **/.. is *brutal* for filesystem walking performance, because
    // it effectively resets the recursive walk each time it occurs,
    // and ** cannot be reduced out by a .. pattern part like a regexp
    // or most strings (other than .., ., and '') can be.
    //
    // <pre>/**/../<p>/<p>/<rest> -> {<pre>/../<p>/<p>/<rest>,<pre>/**/<p>/<p>/<rest>}
    // <pre>/<e>/<rest> -> <pre>/<rest>
    // <pre>/<p>/../<rest> -> <pre>/<rest>
    // **/**/<rest> -> **/<rest>
    //
    // **/*/<rest> -> */**/<rest> <== not valid because ** doesn't follow
    // this WOULD be allowed if ** did follow symlinks, or * didn't
    firstPhasePreProcess(globParts) {
        let didSomething = false;
        do {
            didSomething = false;
            // <pre>/**/../<p>/<p>/<rest> -> {<pre>/../<p>/<p>/<rest>,<pre>/**/<p>/<p>/<rest>}
            for (let parts of globParts) {
                let gs = -1;
                while (-1 !== (gs = parts.indexOf('**', gs + 1))) {
                    let gss = gs;
                    while (parts[gss + 1] === '**') {
                        // <pre>/**/**/<rest> -> <pre>/**/<rest>
                        gss++;
                    }
                    // eg, if gs is 2 and gss is 4, that means we have 3 **
                    // parts, and can remove 2 of them.
                    if (gss > gs) {
                        parts.splice(gs + 1, gss - gs);
                    }
                    let next = parts[gs + 1];
                    const p = parts[gs + 2];
                    const p2 = parts[gs + 3];
                    if (next !== '..')
                        continue;
                    if (!p ||
                        p === '.' ||
                        p === '..' ||
                        !p2 ||
                        p2 === '.' ||
                        p2 === '..') {
                        continue;
                    }
                    didSomething = true;
                    // edit parts in place, and push the new one
                    parts.splice(gs, 1);
                    const other = parts.slice(0);
                    other[gs] = '**';
                    globParts.push(other);
                    gs--;
                }
                // <pre>/<e>/<rest> -> <pre>/<rest>
                if (!this.preserveMultipleSlashes) {
                    for (let i = 1; i < parts.length - 1; i++) {
                        const p = parts[i];
                        // don't squeeze out UNC patterns
                        if (i === 1 && p === '' && parts[0] === '')
                            continue;
                        if (p === '.' || p === '') {
                            didSomething = true;
                            parts.splice(i, 1);
                            i--;
                        }
                    }
                    if (parts[0] === '.' &&
                        parts.length === 2 &&
                        (parts[1] === '.' || parts[1] === '')) {
                        didSomething = true;
                        parts.pop();
                    }
                }
                // <pre>/<p>/../<rest> -> <pre>/<rest>
                let dd = 0;
                while (-1 !== (dd = parts.indexOf('..', dd + 1))) {
                    const p = parts[dd - 1];
                    if (p && p !== '.' && p !== '..' && p !== '**') {
                        didSomething = true;
                        const needDot = dd === 1 && parts[dd + 1] === '**';
                        const splin = needDot ? ['.'] : [];
                        parts.splice(dd - 1, 2, ...splin);
                        if (parts.length === 0)
                            parts.push('');
                        dd -= 2;
                    }
                }
            }
        } while (didSomething);
        return globParts;
    }
    // second phase: multi-pattern dedupes
    // {<pre>/*/<rest>,<pre>/<p>/<rest>} -> <pre>/*/<rest>
    // {<pre>/<rest>,<pre>/<rest>} -> <pre>/<rest>
    // {<pre>/**/<rest>,<pre>/<rest>} -> <pre>/**/<rest>
    //
    // {<pre>/**/<rest>,<pre>/**/<p>/<rest>} -> <pre>/**/<rest>
    // ^-- not valid because ** doens't follow symlinks
    secondPhasePreProcess(globParts) {
        for (let i = 0; i < globParts.length - 1; i++) {
            for (let j = i + 1; j < globParts.length; j++) {
                const matched = this.partsMatch(globParts[i], globParts[j], !this.preserveMultipleSlashes);
                if (matched) {
                    globParts[i] = [];
                    globParts[j] = matched;
                    break;
                }
            }
        }
        return globParts.filter(gs => gs.length);
    }
    partsMatch(a, b, emptyGSMatch = false) {
        let ai = 0;
        let bi = 0;
        let result = [];
        let which = '';
        while (ai < a.length && bi < b.length) {
            if (a[ai] === b[bi]) {
                result.push(which === 'b' ? b[bi] : a[ai]);
                ai++;
                bi++;
            }
            else if (emptyGSMatch && a[ai] === '**' && b[bi] === a[ai + 1]) {
                result.push(a[ai]);
                ai++;
            }
            else if (emptyGSMatch && b[bi] === '**' && a[ai] === b[bi + 1]) {
                result.push(b[bi]);
                bi++;
            }
            else if (a[ai] === '*' &&
                b[bi] &&
                (this.options.dot || !b[bi].startsWith('.')) &&
                b[bi] !== '**') {
                if (which === 'b')
                    return false;
                which = 'a';
                result.push(a[ai]);
                ai++;
                bi++;
            }
            else if (b[bi] === '*' &&
                a[ai] &&
                (this.options.dot || !a[ai].startsWith('.')) &&
                a[ai] !== '**') {
                if (which === 'a')
                    return false;
                which = 'b';
                result.push(b[bi]);
                ai++;
                bi++;
            }
            else {
                return false;
            }
        }
        // if we fall out of the loop, it means they two are identical
        // as long as their lengths match
        return a.length === b.length && result;
    }
    parseNegate() {
        if (this.nonegate)
            return;
        const pattern = this.pattern;
        let negate = false;
        let negateOffset = 0;
        for (let i = 0; i < pattern.length && pattern.charAt(i) === '!'; i++) {
            negate = !negate;
            negateOffset++;
        }
        if (negateOffset)
            this.pattern = pattern.slice(negateOffset);
        this.negate = negate;
    }
    // set partial to true to test if, for example,
    // "/a/b" matches the start of "/*/b/*/d"
    // Partial means, if you run out of file before you run
    // out of pattern, then that's fine, as long as all
    // the parts match.
    matchOne(file, pattern, partial = false) {
        const options = this.options;
        // UNC paths like //?/X:/... can match X:/... and vice versa
        // Drive letters in absolute drive or unc paths are always compared
        // case-insensitively.
        if (this.isWindows) {
            const fileDrive = typeof file[0] === 'string' && /^[a-z]:$/i.test(file[0]);
            const fileUNC = !fileDrive &&
                file[0] === '' &&
                file[1] === '' &&
                file[2] === '?' &&
                /^[a-z]:$/i.test(file[3]);
            const patternDrive = typeof pattern[0] === 'string' && /^[a-z]:$/i.test(pattern[0]);
            const patternUNC = !patternDrive &&
                pattern[0] === '' &&
                pattern[1] === '' &&
                pattern[2] === '?' &&
                typeof pattern[3] === 'string' &&
                /^[a-z]:$/i.test(pattern[3]);
            const fdi = fileUNC ? 3 : fileDrive ? 0 : undefined;
            const pdi = patternUNC ? 3 : patternDrive ? 0 : undefined;
            if (typeof fdi === 'number' && typeof pdi === 'number') {
                const [fd, pd] = [file[fdi], pattern[pdi]];
                if (fd.toLowerCase() === pd.toLowerCase()) {
                    pattern[pdi] = fd;
                    if (pdi > fdi) {
                        pattern = pattern.slice(pdi);
                    }
                    else if (fdi > pdi) {
                        file = file.slice(fdi);
                    }
                }
            }
        }
        // resolve and reduce . and .. portions in the file as well.
        // dont' need to do the second phase, because it's only one string[]
        const { optimizationLevel = 1 } = this.options;
        if (optimizationLevel >= 2) {
            file = this.levelTwoFileOptimize(file);
        }
        this.debug('matchOne', this, { file, pattern });
        this.debug('matchOne', file.length, pattern.length);
        for (var fi = 0, pi = 0, fl = file.length, pl = pattern.length; fi < fl && pi < pl; fi++, pi++) {
            this.debug('matchOne loop');
            var p = pattern[pi];
            var f = file[fi];
            this.debug(pattern, p, f);
            // should be impossible.
            // some invalid regexp stuff in the set.
            /* c8 ignore start */
            if (p === false) {
                return false;
            }
            /* c8 ignore stop */
            if (p === exports.GLOBSTAR) {
                this.debug('GLOBSTAR', [pattern, p, f]);
                // "**"
                // a/**/b/**/c would match the following:
                // a/b/x/y/z/c
                // a/x/y/z/b/c
                // a/b/x/b/x/c
                // a/b/c
                // To do this, take the rest of the pattern after
                // the **, and see if it would match the file remainder.
                // If so, return success.
                // If not, the ** "swallows" a segment, and try again.
                // This is recursively awful.
                //
                // a/**/b/**/c matching a/b/x/y/z/c
                // - a matches a
                // - doublestar
                //   - matchOne(b/x/y/z/c, b/**/c)
                //     - b matches b
                //     - doublestar
                //       - matchOne(x/y/z/c, c) -> no
                //       - matchOne(y/z/c, c) -> no
                //       - matchOne(z/c, c) -> no
                //       - matchOne(c, c) yes, hit
                var fr = fi;
                var pr = pi + 1;
                if (pr === pl) {
                    this.debug('** at the end');
                    // a ** at the end will just swallow the rest.
                    // We have found a match.
                    // however, it will not swallow /.x, unless
                    // options.dot is set.
                    // . and .. are *never* matched by **, for explosively
                    // exponential reasons.
                    for (; fi < fl; fi++) {
                        if (file[fi] === '.' ||
                            file[fi] === '..' ||
                            (!options.dot && file[fi].charAt(0) === '.'))
                            return false;
                    }
                    return true;
                }
                // ok, let's see if we can swallow whatever we can.
                while (fr < fl) {
                    var swallowee = file[fr];
                    this.debug('\nglobstar while', file, fr, pattern, pr, swallowee);
                    // XXX remove this slice.  Just pass the start index.
                    if (this.matchOne(file.slice(fr), pattern.slice(pr), partial)) {
                        this.debug('globstar found match!', fr, fl, swallowee);
                        // found a match.
                        return true;
                    }
                    else {
                        // can't swallow "." or ".." ever.
                        // can only swallow ".foo" when explicitly asked.
                        if (swallowee === '.' ||
                            swallowee === '..' ||
                            (!options.dot && swallowee.charAt(0) === '.')) {
                            this.debug('dot detected!', file, fr, pattern, pr);
                            break;
                        }
                        // ** swallows a segment, and continue.
                        this.debug('globstar swallow a segment, and continue');
                        fr++;
                    }
                }
                // no match was found.
                // However, in partial mode, we can't say this is necessarily over.
                /* c8 ignore start */
                if (partial) {
                    // ran out of file
                    this.debug('\n>>> no match, partial?', file, fr, pattern, pr);
                    if (fr === fl) {
                        return true;
                    }
                }
                /* c8 ignore stop */
                return false;
            }
            // something other than **
            // non-magic patterns just have to match exactly
            // patterns with magic have been turned into regexps.
            let hit;
            if (typeof p === 'string') {
                hit = f === p;
                this.debug('string match', p, f, hit);
            }
            else {
                hit = p.test(f);
                this.debug('pattern match', p, f, hit);
            }
            if (!hit)
                return false;
        }
        // Note: ending in / means that we'll get a final ""
        // at the end of the pattern.  This can only match a
        // corresponding "" at the end of the file.
        // If the file ends in /, then it can only match a
        // a pattern that ends in /, unless the pattern just
        // doesn't have any more for it. But, a/b/ should *not*
        // match "a/b/*", even though "" matches against the
        // [^/]*? pattern, except in partial mode, where it might
        // simply not be reached yet.
        // However, a/b/ should still satisfy a/*
        // now either we fell off the end of the pattern, or we're done.
        if (fi === fl && pi === pl) {
            // ran out of pattern and filename at the same time.
            // an exact hit!
            return true;
        }
        else if (fi === fl) {
            // ran out of file, but still had pattern left.
            // this is ok if we're doing the match as part of
            // a glob fs traversal.
            return partial;
        }
        else if (pi === pl) {
            // ran out of pattern, still have file left.
            // this is only acceptable if we're on the very last
            // empty segment of a file with a trailing slash.
            // a/* should match a/b/
            return fi === fl - 1 && file[fi] === '';
            /* c8 ignore start */
        }
        else {
            // should be unreachable.
            throw new Error('wtf?');
        }
        /* c8 ignore stop */
    }
    braceExpand() {
        return (0, exports.braceExpand)(this.pattern, this.options);
    }
    parse(pattern) {
        (0, assert_valid_pattern_js_1.assertValidPattern)(pattern);
        const options = this.options;
        // shortcuts
        if (pattern === '**')
            return exports.GLOBSTAR;
        if (pattern === '')
            return '';
        // far and away, the most common glob pattern parts are
        // *, *.*, and *.<ext>  Add a fast check method for those.
        let m;
        let fastTest = null;
        if ((m = pattern.match(starRE))) {
            fastTest = options.dot ? starTestDot : starTest;
        }
        else if ((m = pattern.match(starDotExtRE))) {
            fastTest = (options.nocase
                ? options.dot
                    ? starDotExtTestNocaseDot
                    : starDotExtTestNocase
                : options.dot
                    ? starDotExtTestDot
                    : starDotExtTest)(m[1]);
        }
        else if ((m = pattern.match(qmarksRE))) {
            fastTest = (options.nocase
                ? options.dot
                    ? qmarksTestNocaseDot
                    : qmarksTestNocase
                : options.dot
                    ? qmarksTestDot
                    : qmarksTest)(m);
        }
        else if ((m = pattern.match(starDotStarRE))) {
            fastTest = options.dot ? starDotStarTestDot : starDotStarTest;
        }
        else if ((m = pattern.match(dotStarRE))) {
            fastTest = dotStarTest;
        }
        const re = ast_js_1.AST.fromGlob(pattern, this.options).toMMPattern();
        if (fastTest && typeof re === 'object') {
            // Avoids overriding in frozen environments
            Reflect.defineProperty(re, 'test', { value: fastTest });
        }
        return re;
    }
    makeRe() {
        if (this.regexp || this.regexp === false)
            return this.regexp;
        // at this point, this.set is a 2d array of partial
        // pattern strings, or "**".
        //
        // It's better to use .match().  This function shouldn't
        // be used, really, but it's pretty convenient sometimes,
        // when you just want to work with a regex.
        const set = this.set;
        if (!set.length) {
            this.regexp = false;
            return this.regexp;
        }
        const options = this.options;
        const twoStar = options.noglobstar
            ? star
            : options.dot
                ? twoStarDot
                : twoStarNoDot;
        const flags = new Set(options.nocase ? ['i'] : []);
        // regexpify non-globstar patterns
        // if ** is only item, then we just do one twoStar
        // if ** is first, and there are more, prepend (\/|twoStar\/)? to next
        // if ** is last, append (\/twoStar|) to previous
        // if ** is in the middle, append (\/|\/twoStar\/) to previous
        // then filter out GLOBSTAR symbols
        let re = set
            .map(pattern => {
            const pp = pattern.map(p => {
                if (p instanceof RegExp) {
                    for (const f of p.flags.split(''))
                        flags.add(f);
                }
                return typeof p === 'string'
                    ? regExpEscape(p)
                    : p === exports.GLOBSTAR
                        ? exports.GLOBSTAR
                        : p._src;
            });
            pp.forEach((p, i) => {
                const next = pp[i + 1];
                const prev = pp[i - 1];
                if (p !== exports.GLOBSTAR || prev === exports.GLOBSTAR) {
                    return;
                }
                if (prev === undefined) {
                    if (next !== undefined && next !== exports.GLOBSTAR) {
                        pp[i + 1] = '(?:\\/|' + twoStar + '\\/)?' + next;
                    }
                    else {
                        pp[i] = twoStar;
                    }
                }
                else if (next === undefined) {
                    pp[i - 1] = prev + '(?:\\/|' + twoStar + ')?';
                }
                else if (next !== exports.GLOBSTAR) {
                    pp[i - 1] = prev + '(?:\\/|\\/' + twoStar + '\\/)' + next;
                    pp[i + 1] = exports.GLOBSTAR;
                }
            });
            return pp.filter(p => p !== exports.GLOBSTAR).join('/');
        })
            .join('|');
        // need to wrap in parens if we had more than one thing with |,
        // otherwise only the first will be anchored to ^ and the last to $
        const [open, close] = set.length > 1 ? ['(?:', ')'] : ['', ''];
        // must match entire pattern
        // ending in a * or ** will make it less strict.
        re = '^' + open + re + close + '$';
        // can match anything, as long as it's not this.
        if (this.negate)
            re = '^(?!' + re + ').+$';
        try {
            this.regexp = new RegExp(re, [...flags].join(''));
            /* c8 ignore start */
        }
        catch (ex) {
            // should be impossible
            this.regexp = false;
        }
        /* c8 ignore stop */
        return this.regexp;
    }
    slashSplit(p) {
        // if p starts with // on windows, we preserve that
        // so that UNC paths aren't broken.  Otherwise, any number of
        // / characters are coalesced into one, unless
        // preserveMultipleSlashes is set to true.
        if (this.preserveMultipleSlashes) {
            return p.split('/');
        }
        else if (this.isWindows && /^\/\/[^\/]+/.test(p)) {
            // add an extra '' for the one we lose
            return ['', ...p.split(/\/+/)];
        }
        else {
            return p.split(/\/+/);
        }
    }
    match(f, partial = this.partial) {
        this.debug('match', f, this.pattern);
        // short-circuit in the case of busted things.
        // comments, etc.
        if (this.comment) {
            return false;
        }
        if (this.empty) {
            return f === '';
        }
        if (f === '/' && partial) {
            return true;
        }
        const options = this.options;
        // windows: need to use /, not \
        if (this.isWindows) {
            f = f.split('\\').join('/');
        }
        // treat the test path as a set of pathparts.
        const ff = this.slashSplit(f);
        this.debug(this.pattern, 'split', ff);
        // just ONE of the pattern sets in this.set needs to match
        // in order for it to be valid.  If negating, then just one
        // match means that we have failed.
        // Either way, return on the first hit.
        const set = this.set;
        this.debug(this.pattern, 'set', set);
        // Find the basename of the path by looking for the last non-empty segment
        let filename = ff[ff.length - 1];
        if (!filename) {
            for (let i = ff.length - 2; !filename && i >= 0; i--) {
                filename = ff[i];
            }
        }
        for (let i = 0; i < set.length; i++) {
            const pattern = set[i];
            let file = ff;
            if (options.matchBase && pattern.length === 1) {
                file = [filename];
            }
            const hit = this.matchOne(file, pattern, partial);
            if (hit) {
                if (options.flipNegate) {
                    return true;
                }
                return !this.negate;
            }
        }
        // didn't get any hits.  this is success if it's a negative
        // pattern, failure otherwise.
        if (options.flipNegate) {
            return false;
        }
        return this.negate;
    }
    static defaults(def) {
        return exports.minimatch.defaults(def).Minimatch;
    }
}
exports.Minimatch = Minimatch;
/* c8 ignore start */
var ast_js_2 = __webpack_require__(/*! ./ast.js */ "../../node_modules/@theia/ai-ide/node_modules/minimatch/dist/commonjs/ast.js");
Object.defineProperty(exports, "AST", ({ enumerable: true, get: function () { return ast_js_2.AST; } }));
var escape_js_2 = __webpack_require__(/*! ./escape.js */ "../../node_modules/@theia/ai-ide/node_modules/minimatch/dist/commonjs/escape.js");
Object.defineProperty(exports, "escape", ({ enumerable: true, get: function () { return escape_js_2.escape; } }));
var unescape_js_2 = __webpack_require__(/*! ./unescape.js */ "../../node_modules/@theia/ai-ide/node_modules/minimatch/dist/commonjs/unescape.js");
Object.defineProperty(exports, "unescape", ({ enumerable: true, get: function () { return unescape_js_2.unescape; } }));
/* c8 ignore stop */
exports.minimatch.AST = ast_js_1.AST;
exports.minimatch.Minimatch = Minimatch;
exports.minimatch.escape = escape_js_1.escape;
exports.minimatch.unescape = unescape_js_1.unescape;


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/node_modules/minimatch/dist/commonjs/unescape.js":
/*!*****************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/node_modules/minimatch/dist/commonjs/unescape.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.unescape = void 0;
/**
 * Un-escape a string that has been escaped with {@link escape}.
 *
 * If the {@link windowsPathsNoEscape} option is used, then square-brace
 * escapes are removed, but not backslash escapes.  For example, it will turn
 * the string `'[*]'` into `*`, but it will not turn `'\\*'` into `'*'`,
 * becuase `\` is a path separator in `windowsPathsNoEscape` mode.
 *
 * When `windowsPathsNoEscape` is not set, then both brace escapes and
 * backslash escapes are removed.
 *
 * Slashes (and backslashes in `windowsPathsNoEscape` mode) cannot be escaped
 * or unescaped.
 */
const unescape = (s, { windowsPathsNoEscape = false, } = {}) => {
    return windowsPathsNoEscape
        ? s.replace(/\[([^\/\\])\]/g, '$1')
        : s.replace(/((?!\\).|^)\[([^\/\\])\]/g, '$1$2').replace(/\\([^\/])/g, '$1');
};
exports.unescape = unescape;


/***/ }),

/***/ "../../node_modules/@theia/ai-ide/src/browser/style/index.css":
/*!********************************************************************!*\
  !*** ../../node_modules/@theia/ai-ide/src/browser/style/index.css ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_loader_dist_cjs_js_index_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !!../../../../../css-loader/dist/cjs.js!./index.css */ "../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/ai-ide/src/browser/style/index.css");

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_css_loader_dist_cjs_js_index_css__WEBPACK_IMPORTED_MODULE_1__["default"], options);



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_css_loader_dist_cjs_js_index_css__WEBPACK_IMPORTED_MODULE_1__["default"].locals || {});

/***/ }),

/***/ "../../node_modules/@theia/ai-mcp/lib/common/mcp-server-manager.js":
/*!*************************************************************************!*\
  !*** ../../node_modules/@theia/ai-mcp/lib/common/mcp-server-manager.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MCPServerManagerPath = exports.MCPServerManager = exports.MCPServerStatus = exports.MCPFrontendNotificationService = exports.MCPFrontendService = void 0;
exports.MCPFrontendService = Symbol('MCPFrontendService');
exports.MCPFrontendNotificationService = Symbol('MCPFrontendNotificationService');
var MCPServerStatus;
(function (MCPServerStatus) {
    MCPServerStatus["NotRunning"] = "Not Running";
    MCPServerStatus["Starting"] = "Starting";
    MCPServerStatus["Running"] = "Running";
    MCPServerStatus["Errored"] = "Errored";
})(MCPServerStatus || (exports.MCPServerStatus = MCPServerStatus = {}));
exports.MCPServerManager = Symbol('MCPServerManager');
exports.MCPServerManagerPath = '/services/mcpservermanager';


/***/ }),

/***/ "../../node_modules/@theia/core/lib/common/content-replacer.js":
/*!*********************************************************************!*\
  !*** ../../node_modules/@theia/core/lib/common/content-replacer.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ContentReplacer = void 0;
class ContentReplacer {
    /**
     * Applies a list of replacements to the original content using a multi-step matching strategy.
     * @param originalContent The original file content.
     * @param replacements Array of Replacement objects.
     * @param allowMultiple If true, all occurrences of each oldContent will be replaced. If false, an error is returned when multiple occurrences are found.
     * @returns An object containing the updated content and any error messages.
     */
    applyReplacements(originalContent, replacements) {
        let updatedContent = originalContent;
        const errorMessages = [];
        // Guard against conflicting replacements: if the same oldContent appears with different newContent, return with an error.
        const conflictMap = new Map();
        for (const replacement of replacements) {
            if (conflictMap.has(replacement.oldContent) && conflictMap.get(replacement.oldContent) !== replacement.newContent) {
                return { updatedContent: originalContent, errors: [`Conflicting replacement values for: "${replacement.oldContent}"`] };
            }
            conflictMap.set(replacement.oldContent, replacement.newContent);
        }
        replacements.forEach(({ oldContent, newContent, multiple }) => {
            // If the old content is empty, prepend the new content to the beginning of the file (e.g. in new file)
            if (oldContent === '') {
                updatedContent = newContent + updatedContent;
                return;
            }
            let matchIndices = this.findExactMatches(updatedContent, oldContent);
            if (matchIndices.length === 0) {
                matchIndices = this.findLineTrimmedMatches(updatedContent, oldContent);
            }
            if (matchIndices.length === 0) {
                errorMessages.push(`Content to replace not found: "${oldContent}"`);
            }
            else if (matchIndices.length > 1) {
                if (multiple) {
                    updatedContent = this.replaceContentAll(updatedContent, oldContent, newContent);
                }
                else {
                    errorMessages.push(`Multiple occurrences found for: "${oldContent}". Set 'multiple' to true if multiple occurrences of the oldContent are expected to be\
                         replaced at once.`);
                }
            }
            else {
                updatedContent = this.replaceContentOnce(updatedContent, oldContent, newContent);
            }
        });
        return { updatedContent, errors: errorMessages };
    }
    /**
     * Finds all exact matches of a substring within a string.
     * @param content The content to search within.
     * @param search The substring to search for.
     * @returns An array of starting indices where the exact substring is found.
     */
    findExactMatches(content, search) {
        const indices = [];
        let startIndex = 0;
        while ((startIndex = content.indexOf(search, startIndex)) !== -1) {
            indices.push(startIndex);
            startIndex += search.length;
        }
        return indices;
    }
    /**
     * Attempts to find matches by trimming whitespace from lines in the original content and the search string.
     * @param content The original content.
     * @param search The substring to search for, potentially with varying whitespace.
     * @returns An array of starting indices where a trimmed match is found.
     */
    findLineTrimmedMatches(content, search) {
        const trimmedSearch = search.trim();
        const lines = content.split('\n');
        for (let i = 0; i < lines.length; i++) {
            const trimmedLine = lines[i].trim();
            if (trimmedLine === trimmedSearch) {
                // Calculate the starting index of this line in the original content
                const startIndex = this.getLineStartIndex(content, i);
                return [startIndex];
            }
        }
        return [];
    }
    /**
     * Calculates the starting index of a specific line number in the content.
     * @param content The original content.
     * @param lineNumber The zero-based line number.
     * @returns The starting index of the specified line.
     */
    getLineStartIndex(content, lineNumber) {
        const lines = content.split('\n');
        let index = 0;
        for (let i = 0; i < lineNumber; i++) {
            index += lines[i].length + 1; // +1 for the newline character
        }
        return index;
    }
    /**
     * Replaces the first occurrence of oldContent with newContent in the content.
     * @param content The original content.
     * @param oldContent The content to be replaced.
     * @param newContent The content to replace with.
     * @returns The content after replacement.
     */
    replaceContentOnce(content, oldContent, newContent) {
        const index = content.indexOf(oldContent);
        if (index === -1) {
            return content;
        }
        return content.substring(0, index) + newContent + content.substring(index + oldContent.length);
    }
    /**
     * Replaces all occurrences of oldContent with newContent in the content.
     * @param content The original content.
     * @param oldContent The content to be replaced.
     * @param newContent The content to replace with.
     * @returns The content after all replacements.
     */
    replaceContentAll(content, oldContent, newContent) {
        return content.split(oldContent).join(newContent);
    }
}
exports.ContentReplacer = ContentReplacer;


/***/ }),

/***/ "../../node_modules/@theia/search-in-workspace/lib/browser/search-in-workspace-service.js":
/*!************************************************************************************************!*\
  !*** ../../node_modules/@theia/search-in-workspace/lib/browser/search-in-workspace-service.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2017-2018 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SearchInWorkspaceService = exports.SearchInWorkspaceClientImpl = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const search_in_workspace_interface_1 = __webpack_require__(/*! ../common/search-in-workspace-interface */ "../../node_modules/@theia/search-in-workspace/lib/common/search-in-workspace-interface.js");
const browser_1 = __webpack_require__(/*! @theia/workspace/lib/browser */ "../../node_modules/@theia/workspace/lib/browser/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
/**
 * Class that will receive the search results from the server.  This is separate
 * from the SearchInWorkspaceService class only to avoid a cycle in the
 * dependency injection.
 */
let SearchInWorkspaceClientImpl = class SearchInWorkspaceClientImpl {
    onResult(searchId, result) {
        this.service.onResult(searchId, result);
    }
    onDone(searchId, error) {
        this.service.onDone(searchId, error);
    }
    setService(service) {
        this.service = service;
    }
};
exports.SearchInWorkspaceClientImpl = SearchInWorkspaceClientImpl;
exports.SearchInWorkspaceClientImpl = SearchInWorkspaceClientImpl = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], SearchInWorkspaceClientImpl);
/**
 * Service to search text in the workspace files.
 */
let SearchInWorkspaceService = class SearchInWorkspaceService {
    constructor() {
        // All the searches that we have started, that are not done yet (onDone
        // with that searchId has not been called).
        this.pendingSearches = new Map();
        // Due to the asynchronicity of the node backend, it's possible that we
        // start a search, receive an event for that search, and then receive
        // the search id for that search.We therefore need to keep those
        // events until we get the search id and return it to the caller.
        // Otherwise the caller would discard the event because it doesn't know
        // the search id yet.
        this.pendingOnDones = new Map();
        this.lastKnownSearchId = -1;
    }
    init() {
        this.client.setService(this);
    }
    isEnabled() {
        return this.workspaceService.opened;
    }
    onResult(searchId, result) {
        const callbacks = this.pendingSearches.get(searchId);
        if (callbacks) {
            callbacks.onResult(searchId, result);
        }
    }
    onDone(searchId, error) {
        const callbacks = this.pendingSearches.get(searchId);
        if (callbacks) {
            this.pendingSearches.delete(searchId);
            callbacks.onDone(searchId, error);
        }
        else {
            if (searchId > this.lastKnownSearchId) {
                this.logger.debug(`Got an onDone for a searchId we don't know about (${searchId}), stashing it for later with error = `, error);
                this.pendingOnDones.set(searchId, error);
            }
            else {
                // It's possible to receive an onDone for a search we have cancelled.  Just ignore it.
                this.logger.debug(`Got an onDone for a searchId we don't know about (${searchId}), but it's probably an old one, error = `, error);
            }
        }
    }
    // Start a search of the string "what" in the workspace.
    async search(what, callbacks, opts) {
        if (!this.workspaceService.opened) {
            throw new Error('Search failed: no workspace root.');
        }
        const roots = await this.workspaceService.roots;
        return this.doSearch(what, roots.map(r => r.resource.toString()), callbacks, opts);
    }
    async doSearch(what, rootsUris, callbacks, opts) {
        const searchId = await this.searchServer.search(what, rootsUris, opts);
        this.pendingSearches.set(searchId, callbacks);
        this.lastKnownSearchId = searchId;
        this.logger.debug('Service launched search ' + searchId);
        // Check if we received an onDone before search() returned.
        if (this.pendingOnDones.has(searchId)) {
            this.logger.debug('Ohh, we have a stashed onDone for that searchId');
            const error = this.pendingOnDones.get(searchId);
            this.pendingOnDones.delete(searchId);
            // Call the client's searchId, but first give it a
            // chance to record the returned searchId.
            setTimeout(() => {
                this.onDone(searchId, error);
            }, 0);
        }
        return searchId;
    }
    async searchWithCallback(what, rootsUris, callbacks, opts) {
        return this.doSearch(what, rootsUris, callbacks, opts);
    }
    // Cancel an ongoing search.
    cancel(searchId) {
        this.pendingSearches.delete(searchId);
        this.searchServer.cancel(searchId);
    }
};
exports.SearchInWorkspaceService = SearchInWorkspaceService;
tslib_1.__decorate([
    (0, inversify_1.inject)(search_in_workspace_interface_1.SearchInWorkspaceServer),
    tslib_1.__metadata("design:type", Object)
], SearchInWorkspaceService.prototype, "searchServer", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(SearchInWorkspaceClientImpl),
    tslib_1.__metadata("design:type", SearchInWorkspaceClientImpl)
], SearchInWorkspaceService.prototype, "client", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.WorkspaceService),
    tslib_1.__metadata("design:type", browser_1.WorkspaceService)
], SearchInWorkspaceService.prototype, "workspaceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.ILogger),
    tslib_1.__metadata("design:type", Object)
], SearchInWorkspaceService.prototype, "logger", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], SearchInWorkspaceService.prototype, "init", null);
exports.SearchInWorkspaceService = SearchInWorkspaceService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], SearchInWorkspaceService);


/***/ }),

/***/ "../../node_modules/@theia/search-in-workspace/lib/common/search-in-workspace-interface.js":
/*!*************************************************************************************************!*\
  !*** ../../node_modules/@theia/search-in-workspace/lib/common/search-in-workspace-interface.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2017-2018 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SearchInWorkspaceServer = exports.SIW_WS_PATH = exports.SearchInWorkspaceClient = exports.SearchInWorkspaceResult = void 0;
var SearchInWorkspaceResult;
(function (SearchInWorkspaceResult) {
    /**
     * Sort search in workspace results according to file, line, character position
     * and then length.
     */
    function compare(a, b) {
        if (a.fileUri !== b.fileUri) {
            return a.fileUri < b.fileUri ? -1 : 1;
        }
        return 0;
    }
    SearchInWorkspaceResult.compare = compare;
})(SearchInWorkspaceResult || (exports.SearchInWorkspaceResult = SearchInWorkspaceResult = {}));
exports.SearchInWorkspaceClient = Symbol('SearchInWorkspaceClient');
exports.SIW_WS_PATH = '/services/search-in-workspace';
exports.SearchInWorkspaceServer = Symbol('SearchInWorkspaceServer');


/***/ }),

/***/ "../../node_modules/@theia/workspace/lib/browser/index.js":
/*!****************************************************************!*\
  !*** ../../node_modules/@theia/workspace/lib/browser/index.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-commands */ "../../node_modules/@theia/workspace/lib/browser/workspace-commands.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-service.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./canonical-uri-service */ "../../node_modules/@theia/workspace/lib/browser/canonical-uri-service.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-frontend-contribution */ "../../node_modules/@theia/workspace/lib/browser/workspace-frontend-contribution.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-frontend-module */ "../../node_modules/@theia/workspace/lib/browser/workspace-frontend-module.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-preferences */ "../../node_modules/@theia/workspace/lib/browser/workspace-preferences.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-trust-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-trust-service.js"), exports);


/***/ }),

/***/ "../../node_modules/balanced-match/index.js":
/*!**************************************************!*\
  !*** ../../node_modules/balanced-match/index.js ***!
  \**************************************************/
/***/ ((module) => {

"use strict";

module.exports = balanced;
function balanced(a, b, str) {
  if (a instanceof RegExp) a = maybeMatch(a, str);
  if (b instanceof RegExp) b = maybeMatch(b, str);

  var r = range(a, b, str);

  return r && {
    start: r[0],
    end: r[1],
    pre: str.slice(0, r[0]),
    body: str.slice(r[0] + a.length, r[1]),
    post: str.slice(r[1] + b.length)
  };
}

function maybeMatch(reg, str) {
  var m = str.match(reg);
  return m ? m[0] : null;
}

balanced.range = range;
function range(a, b, str) {
  var begs, beg, left, right, result;
  var ai = str.indexOf(a);
  var bi = str.indexOf(b, ai + 1);
  var i = ai;

  if (ai >= 0 && bi > 0) {
    if(a===b) {
      return [ai, bi];
    }
    begs = [];
    left = str.length;

    while (i >= 0 && !result) {
      if (i == ai) {
        begs.push(i);
        ai = str.indexOf(a, i + 1);
      } else if (begs.length == 1) {
        result = [ begs.pop(), bi ];
      } else {
        beg = begs.pop();
        if (beg < left) {
          left = beg;
          right = bi;
        }

        bi = str.indexOf(b, i + 1);
      }

      i = ai < bi && ai >= 0 ? ai : bi;
    }

    if (begs.length) {
      result = [ left, right ];
    }
  }

  return result;
}


/***/ }),

/***/ "../../node_modules/brace-expansion/index.js":
/*!***************************************************!*\
  !*** ../../node_modules/brace-expansion/index.js ***!
  \***************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var balanced = __webpack_require__(/*! balanced-match */ "../../node_modules/balanced-match/index.js");

module.exports = expandTop;

var escSlash = '\0SLASH'+Math.random()+'\0';
var escOpen = '\0OPEN'+Math.random()+'\0';
var escClose = '\0CLOSE'+Math.random()+'\0';
var escComma = '\0COMMA'+Math.random()+'\0';
var escPeriod = '\0PERIOD'+Math.random()+'\0';

function numeric(str) {
  return parseInt(str, 10) == str
    ? parseInt(str, 10)
    : str.charCodeAt(0);
}

function escapeBraces(str) {
  return str.split('\\\\').join(escSlash)
            .split('\\{').join(escOpen)
            .split('\\}').join(escClose)
            .split('\\,').join(escComma)
            .split('\\.').join(escPeriod);
}

function unescapeBraces(str) {
  return str.split(escSlash).join('\\')
            .split(escOpen).join('{')
            .split(escClose).join('}')
            .split(escComma).join(',')
            .split(escPeriod).join('.');
}


// Basically just str.split(","), but handling cases
// where we have nested braced sections, which should be
// treated as individual members, like {a,{b,c},d}
function parseCommaParts(str) {
  if (!str)
    return [''];

  var parts = [];
  var m = balanced('{', '}', str);

  if (!m)
    return str.split(',');

  var pre = m.pre;
  var body = m.body;
  var post = m.post;
  var p = pre.split(',');

  p[p.length-1] += '{' + body + '}';
  var postParts = parseCommaParts(post);
  if (post.length) {
    p[p.length-1] += postParts.shift();
    p.push.apply(p, postParts);
  }

  parts.push.apply(parts, p);

  return parts;
}

function expandTop(str) {
  if (!str)
    return [];

  // I don't know why Bash 4.3 does this, but it does.
  // Anything starting with {} will have the first two bytes preserved
  // but *only* at the top level, so {},a}b will not expand to anything,
  // but a{},b}c will be expanded to [a}c,abc].
  // One could argue that this is a bug in Bash, but since the goal of
  // this module is to match Bash's rules, we escape a leading {}
  if (str.substr(0, 2) === '{}') {
    str = '\\{\\}' + str.substr(2);
  }

  return expand(escapeBraces(str), true).map(unescapeBraces);
}

function embrace(str) {
  return '{' + str + '}';
}
function isPadded(el) {
  return /^-?0\d/.test(el);
}

function lte(i, y) {
  return i <= y;
}
function gte(i, y) {
  return i >= y;
}

function expand(str, isTop) {
  var expansions = [];

  var m = balanced('{', '}', str);
  if (!m) return [str];

  // no need to expand pre, since it is guaranteed to be free of brace-sets
  var pre = m.pre;
  var post = m.post.length
    ? expand(m.post, false)
    : [''];

  if (/\$$/.test(m.pre)) {    
    for (var k = 0; k < post.length; k++) {
      var expansion = pre+ '{' + m.body + '}' + post[k];
      expansions.push(expansion);
    }
  } else {
    var isNumericSequence = /^-?\d+\.\.-?\d+(?:\.\.-?\d+)?$/.test(m.body);
    var isAlphaSequence = /^[a-zA-Z]\.\.[a-zA-Z](?:\.\.-?\d+)?$/.test(m.body);
    var isSequence = isNumericSequence || isAlphaSequence;
    var isOptions = m.body.indexOf(',') >= 0;
    if (!isSequence && !isOptions) {
      // {a},b}
      if (m.post.match(/,.*\}/)) {
        str = m.pre + '{' + m.body + escClose + m.post;
        return expand(str);
      }
      return [str];
    }

    var n;
    if (isSequence) {
      n = m.body.split(/\.\./);
    } else {
      n = parseCommaParts(m.body);
      if (n.length === 1) {
        // x{{a,b}}y ==> x{a}y x{b}y
        n = expand(n[0], false).map(embrace);
        if (n.length === 1) {
          return post.map(function(p) {
            return m.pre + n[0] + p;
          });
        }
      }
    }

    // at this point, n is the parts, and we know it's not a comma set
    // with a single entry.
    var N;

    if (isSequence) {
      var x = numeric(n[0]);
      var y = numeric(n[1]);
      var width = Math.max(n[0].length, n[1].length)
      var incr = n.length == 3
        ? Math.abs(numeric(n[2]))
        : 1;
      var test = lte;
      var reverse = y < x;
      if (reverse) {
        incr *= -1;
        test = gte;
      }
      var pad = n.some(isPadded);

      N = [];

      for (var i = x; test(i, y); i += incr) {
        var c;
        if (isAlphaSequence) {
          c = String.fromCharCode(i);
          if (c === '\\')
            c = '';
        } else {
          c = String(i);
          if (pad) {
            var need = width - c.length;
            if (need > 0) {
              var z = new Array(need + 1).join('0');
              if (i < 0)
                c = '-' + z + c.slice(1);
              else
                c = z + c;
            }
          }
        }
        N.push(c);
      }
    } else {
      N = [];

      for (var j = 0; j < n.length; j++) {
        N.push.apply(N, expand(n[j], false));
      }
    }

    for (var j = 0; j < N.length; j++) {
      for (var k = 0; k < post.length; k++) {
        var expansion = pre + N[j] + post[k];
        if (!isTop || isSequence || expansion)
          expansions.push(expansion);
      }
    }
  }

  return expansions;
}



/***/ }),

/***/ "../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/ai-ide/src/browser/style/index.css":
/*!**************************************************************************************************************!*\
  !*** ../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/ai-ide/src/browser/style/index.css ***!
  \**************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../css-loader/dist/runtime/sourceMaps.js */ "../../node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../css-loader/dist/runtime/api.js */ "../../node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `.ai-configuration-widget {
  padding: var(--theia-ui-padding);
}

.theia-ai-settings-container {
  padding: var(--theia-ui-padding);
}

.language-model-container {
  padding-top: calc(2 * var(--theia-ui-padding));
}

.language-model-container .theia-select {
  margin-left: var(--theia-ui-padding);
}

.theia-settings-container
  .settings-section-subcategory-title.ai-settings-section-subcategory-title {
  padding-left: 0;
}

.ai-templates {
  display: flex;
  flex-direction: column;
  gap: 5px;
}

.template-renderer {
  display: flex;
  flex-direction: column;
  padding: 10px;
}

.template-header {
  margin-bottom: 8px;
}

.template-controls {
  display: flex;
  align-items: center;
  gap: 10px;
}

.template-select-label {
  margin-right: 5px;
}

.template-variant-selector {
  min-width: 120px;
}

.template-variant-selector.error {
  border-color: var(--theia-errorForeground);
  background-color: var(--theia-errorBackground, rgba(255, 0, 0, 0.1));
  color: var(--theia-errorForeground);
}

#ai-variable-configuration-container-widget,
#ai-agent-configuration-container-widget {
  margin-top: 5px;
}

/* Variable Settings */
#ai-variable-configuration-container-widget ul {
  list-style: none;
  padding: 0;
  margin: 0;
}

#ai-variable-configuration-container-widget .variable-item {
  display: flex;
  flex-direction: column;
  margin-bottom: 1rem;
}

#ai-variable-configuration-container-widget .variable-args {
  display: grid;
  grid-template-columns: 1fr 2fr;
}

/* Agent Settings */
#ai-agent-configuration-container-widget ul {
  list-style: none;
  padding: 0;
  margin: 0;
}

.ai-agent-configuration-main {
  display: flex;
  flex-direction: row;
}

.configuration-agents-list {
  width: 128px;
}

.configuration-agent-panel {
  flex: 1;
}

#ai-variable-configuration-container-widget .variable-references,
#ai-agent-configuration-container-widget .variable-references,
#ai-agent-configuration-container-widget .function-references {
  margin-left: 0.5rem;
  padding: 0.5rem;
  border-left: solid 1px var(--theia-tree-indentGuidesStroke);
}

#ai-variable-configuration-container-widget .variable-reference,
#ai-agent-configuration-container-widget .variable-reference,
#ai-agent-configuration-container-widget .function-reference {
  display: flex;
  flex-direction: row;
  align-items: center;
}

.agent-tag {
  padding: calc(var(--theia-ui-padding) * 2 / 3);
  padding-top: 0px;
  padding-bottom: 0px;
  border-radius: calc(var(--theia-ui-padding) * 2 / 3);
  background: hsla(0, 0%, 68%, 0.31);
}

.configuration-agents-add {
  margin-top: 3em;
  margin-left: 0;
}

/* MCP Configuration Styles */
.mcp-configuration-container {
  padding: 16px;
}

.mcp-configuration-title {
  margin: 0 0 16px 0;
  border-bottom: 1px solid var(--theia-panelTitle-activeBorder);
  padding-bottom: 8px;
}

.mcp-server-card {
  border: 1px solid var(--theia-panelTitle-activeBorder);
  border-radius: 6px;
  padding: 12px;
  margin-bottom: 16px;
  background-color: var(--theia-editorWidget-background);
}

.mcp-server-header {
  display: flex;
  justify-content: space-between;
  align-items: center;
  margin-bottom: 12px;
}

.mcp-server-name {
  font-weight: bold;
  font-size: var(--theia-ui-font-size3);
}

.mcp-status-badge {
  padding: 3px 8px;
  border-radius: 12px;
  font-size: 12px;
  font-weight: bold;
  display: inline-block;
}

.mcp-error-indicator {
  display: inline-flex;
  align-items: center;
  justify-content: center;
  width: 18px;
  height: 18px;
  border-radius: 50%;
  background-color: var(--theia-errorBackground);
  color: var(--theia-errorForeground);
  font-size: 12px;
  font-weight: bold;
  cursor: pointer;
  margin-left: 8px;
}

.mcp-server-section {
  margin-bottom: 6px;
}

.mcp-section-label {
  font-weight: bold;
  color: var(--theia-descriptionForeground);
}

.mcp-code-block {
  background-color: var(--theia-editor-background);
  padding: 2px 4px;
  border-radius: 3px;
  font-family: monospace;
}

.mcp-env-block {
  margin-left: 10px;
  background-color: var(--theia-editor-background);
  padding: 4px 8px;
  border-radius: 3px;
  font-family: monospace;
  font-size: 12px;
}

.mcp-toggle-indicator {
  width: 16px;
  height: 16px;
  display: flex;
  align-items: center;
  justify-content: center;
  margin-right: 6px;
  transition: transform 0.2s ease;
}

.mcp-tools-section {
  margin-top: 12px;
  cursor: pointer;
  user-select: none;
}

.mcp-tools-list {
  margin-left: 24px;
  margin-top: 4px;
  background-color: var(--theia-editor-background);
  border-radius: 3px;
  font-family: monospace;
  font-size: 12px;
}

.mcp-autostart-badge {
  padding: 2px 6px;
  border-radius: 3px;
  font-size: 12px;
  font-weight: bold;
}

.mcp-no-servers {
  padding: 20px;
  text-align: center;
  color: var(--theia-descriptionForeground);
}

.mcp-status-container {
  display: flex;
  align-items: center;
}

.mcp-server-controls {
  display: flex;
  align-items: center;
  margin-top: 12px;
  border-top: 1px solid var(--theia-panelTitle-inactiveForeground);
  padding-top: 12px;
}

.mcp-server-button {
  display: inline-flex;
  align-items: center;
  justify-content: center;
  background-color: var(--theia-button-background);
  color: var(--theia-button-foreground);
  border: none;
  border-radius: 4px;
  padding: 6px 8px;
  font-size: 12px;
  cursor: pointer;
  transition: background-color 0.2s;
  margin-right: 10px;
}

.mcp-server-button:hover {
  background-color: var(--theia-button-hoverBackground);
}

.mcp-server-button.play-button {
  background-color: var(--theia-successBackground);
  color: var(--theia-successForeground);
}

.mcp-server-button.play-button:hover {
  background-color: var(--theia-successBackground);
  filter: brightness(1.1);
}

.mcp-server-button.stop-button {
  background-color: var(--theia-errorBackground);
  color: var(--theia-errorForeground);
}

.mcp-server-button.stop-button:hover {
  background-color: var(--theia-errorBackground);
  filter: brightness(1.1);
}

.mcp-server-button-icon {
  margin-right: 6px;
  font-size: 14px;
}

.mcp-copy-tool-button {
  background: transparent;
  border: none;
  padding: 0;
  cursor: pointer;
  font-size: 12px;
  color: var(--theia-descriptionForeground);
  white-space: nowrap;
}

.theia-ResponseNode-Content .disable-message {
  font-size: 12px;
  line-height: 1.6;
  padding: 15px;
}

.theia-WelcomeMessage {
  display: flex;
  flex-direction: column;
  justify-content: center;
  align-items: center;
  height: 100%;
}

.theia-WelcomeMessage-Content {
  text-align: center;
  padding: 0 18px;
  max-width: 350px;
}

.theia-WelcomeMessage-Content h1 {
  margin-top: 0;
}

.theia-WelcomeMessage-Content p {
  font-size: var(--theia-ui-font-size2);
  line-height: 18px;
}

.theia-WelcomeMessage-Content p .codicon {
  vertical-align: sub;
}

.theia-WelcomeMessage-Content em {
  font-weight: bolder;
  font-style: normal;
}

/* Token Usage Configuration Styles */
.token-usage-configuration-container {
  padding: 16px;
}

.token-usage-configuration-title {
  margin: 0 0 16px 0;
  border-bottom: 1px solid var(--theia-widget-border);
  padding-bottom: 8px;
}

.token-usage-controls {
  display: flex;
  justify-content: flex-end;
  margin-bottom: 16px;
}

.token-usage-refresh-button {
  display: inline-flex;
  align-items: center;
  background-color: var(--theia-button-background);
  color: var(--theia-button-foreground);
  border: none;
  border-radius: 4px;
  padding: 6px 12px;
  font-size: 12px;
  cursor: pointer;
  transition: background-color 0.2s;
}

.token-usage-refresh-button:hover {
  background-color: var(--theia-button-hoverBackground);
}

.token-usage-refresh-button i {
  margin-right: 6px;
}

.token-usage-table-container {
  overflow-x: auto;
  border-radius: 6px;
  background-color: var(--theia-editorWidget-background);
}

.token-usage-table {
  width: 100%;
  border-collapse: collapse;
}

.token-usage-header th {
  text-align: left;
  padding: 10px;
  background-color: var(--theia-editor-background);
  color: var(--theia-descriptionForeground);
  font-weight: bold;
}

.token-usage-model-column {
  width: 25%;
}

.token-usage-column {
  width: 18.75%;
}

.token-usage-row td {
  padding: 10px;
}

.token-usage-row:hover {
  background-color: var(--theia-list-hoverBackground);
}

.token-usage-summary-row td {
  padding: 10px;
  background-color: var(--theia-editor-background);
  color: var(--theia-foreground);
}

.token-usage-model-cell {
  font-weight: 500;
}

.token-usage-notes {
  margin-top: 16px;
  color: var(--theia-descriptionForeground);
}

.token-usage-note {
  display: flex;
  align-items: center;
  font-size: 12px;
}

.token-usage-note i {
  margin-right: 8px;
}
`, "",{"version":3,"sources":["webpack://./../../node_modules/@theia/ai-ide/src/browser/style/index.css"],"names":[],"mappings":"AAAA;EACE,gCAAgC;AAClC;;AAEA;EACE,gCAAgC;AAClC;;AAEA;EACE,8CAA8C;AAChD;;AAEA;EACE,oCAAoC;AACtC;;AAEA;;EAEE,eAAe;AACjB;;AAEA;EACE,aAAa;EACb,sBAAsB;EACtB,QAAQ;AACV;;AAEA;EACE,aAAa;EACb,sBAAsB;EACtB,aAAa;AACf;;AAEA;EACE,kBAAkB;AACpB;;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,SAAS;AACX;;AAEA;EACE,iBAAiB;AACnB;;AAEA;EACE,gBAAgB;AAClB;;AAEA;EACE,0CAA0C;EAC1C,oEAAoE;EACpE,mCAAmC;AACrC;;AAEA;;EAEE,eAAe;AACjB;;AAEA,sBAAsB;AACtB;EACE,gBAAgB;EAChB,UAAU;EACV,SAAS;AACX;;AAEA;EACE,aAAa;EACb,sBAAsB;EACtB,mBAAmB;AACrB;;AAEA;EACE,aAAa;EACb,8BAA8B;AAChC;;AAEA,mBAAmB;AACnB;EACE,gBAAgB;EAChB,UAAU;EACV,SAAS;AACX;;AAEA;EACE,aAAa;EACb,mBAAmB;AACrB;;AAEA;EACE,YAAY;AACd;;AAEA;EACE,OAAO;AACT;;AAEA;;;EAGE,mBAAmB;EACnB,eAAe;EACf,2DAA2D;AAC7D;;AAEA;;;EAGE,aAAa;EACb,mBAAmB;EACnB,mBAAmB;AACrB;;AAEA;EACE,8CAA8C;EAC9C,gBAAgB;EAChB,mBAAmB;EACnB,oDAAoD;EACpD,kCAAkC;AACpC;;AAEA;EACE,eAAe;EACf,cAAc;AAChB;;AAEA,6BAA6B;AAC7B;EACE,aAAa;AACf;;AAEA;EACE,kBAAkB;EAClB,6DAA6D;EAC7D,mBAAmB;AACrB;;AAEA;EACE,sDAAsD;EACtD,kBAAkB;EAClB,aAAa;EACb,mBAAmB;EACnB,sDAAsD;AACxD;;AAEA;EACE,aAAa;EACb,8BAA8B;EAC9B,mBAAmB;EACnB,mBAAmB;AACrB;;AAEA;EACE,iBAAiB;EACjB,qCAAqC;AACvC;;AAEA;EACE,gBAAgB;EAChB,mBAAmB;EACnB,eAAe;EACf,iBAAiB;EACjB,qBAAqB;AACvB;;AAEA;EACE,oBAAoB;EACpB,mBAAmB;EACnB,uBAAuB;EACvB,WAAW;EACX,YAAY;EACZ,kBAAkB;EAClB,8CAA8C;EAC9C,mCAAmC;EACnC,eAAe;EACf,iBAAiB;EACjB,eAAe;EACf,gBAAgB;AAClB;;AAEA;EACE,kBAAkB;AACpB;;AAEA;EACE,iBAAiB;EACjB,yCAAyC;AAC3C;;AAEA;EACE,gDAAgD;EAChD,gBAAgB;EAChB,kBAAkB;EAClB,sBAAsB;AACxB;;AAEA;EACE,iBAAiB;EACjB,gDAAgD;EAChD,gBAAgB;EAChB,kBAAkB;EAClB,sBAAsB;EACtB,eAAe;AACjB;;AAEA;EACE,WAAW;EACX,YAAY;EACZ,aAAa;EACb,mBAAmB;EACnB,uBAAuB;EACvB,iBAAiB;EACjB,+BAA+B;AACjC;;AAEA;EACE,gBAAgB;EAChB,eAAe;EACf,iBAAiB;AACnB;;AAEA;EACE,iBAAiB;EACjB,eAAe;EACf,gDAAgD;EAChD,kBAAkB;EAClB,sBAAsB;EACtB,eAAe;AACjB;;AAEA;EACE,gBAAgB;EAChB,kBAAkB;EAClB,eAAe;EACf,iBAAiB;AACnB;;AAEA;EACE,aAAa;EACb,kBAAkB;EAClB,yCAAyC;AAC3C;;AAEA;EACE,aAAa;EACb,mBAAmB;AACrB;;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,gBAAgB;EAChB,gEAAgE;EAChE,iBAAiB;AACnB;;AAEA;EACE,oBAAoB;EACpB,mBAAmB;EACnB,uBAAuB;EACvB,gDAAgD;EAChD,qCAAqC;EACrC,YAAY;EACZ,kBAAkB;EAClB,gBAAgB;EAChB,eAAe;EACf,eAAe;EACf,iCAAiC;EACjC,kBAAkB;AACpB;;AAEA;EACE,qDAAqD;AACvD;;AAEA;EACE,gDAAgD;EAChD,qCAAqC;AACvC;;AAEA;EACE,gDAAgD;EAChD,uBAAuB;AACzB;;AAEA;EACE,8CAA8C;EAC9C,mCAAmC;AACrC;;AAEA;EACE,8CAA8C;EAC9C,uBAAuB;AACzB;;AAEA;EACE,iBAAiB;EACjB,eAAe;AACjB;;AAEA;EACE,uBAAuB;EACvB,YAAY;EACZ,UAAU;EACV,eAAe;EACf,eAAe;EACf,yCAAyC;EACzC,mBAAmB;AACrB;;AAEA;EACE,eAAe;EACf,gBAAgB;EAChB,aAAa;AACf;;AAEA;EACE,aAAa;EACb,sBAAsB;EACtB,uBAAuB;EACvB,mBAAmB;EACnB,YAAY;AACd;;AAEA;EACE,kBAAkB;EAClB,eAAe;EACf,gBAAgB;AAClB;;AAEA;EACE,aAAa;AACf;;AAEA;EACE,qCAAqC;EACrC,iBAAiB;AACnB;;AAEA;EACE,mBAAmB;AACrB;;AAEA;EACE,mBAAmB;EACnB,kBAAkB;AACpB;;AAEA,qCAAqC;AACrC;EACE,aAAa;AACf;;AAEA;EACE,kBAAkB;EAClB,mDAAmD;EACnD,mBAAmB;AACrB;;AAEA;EACE,aAAa;EACb,yBAAyB;EACzB,mBAAmB;AACrB;;AAEA;EACE,oBAAoB;EACpB,mBAAmB;EACnB,gDAAgD;EAChD,qCAAqC;EACrC,YAAY;EACZ,kBAAkB;EAClB,iBAAiB;EACjB,eAAe;EACf,eAAe;EACf,iCAAiC;AACnC;;AAEA;EACE,qDAAqD;AACvD;;AAEA;EACE,iBAAiB;AACnB;;AAEA;EACE,gBAAgB;EAChB,kBAAkB;EAClB,sDAAsD;AACxD;;AAEA;EACE,WAAW;EACX,yBAAyB;AAC3B;;AAEA;EACE,gBAAgB;EAChB,aAAa;EACb,gDAAgD;EAChD,yCAAyC;EACzC,iBAAiB;AACnB;;AAEA;EACE,UAAU;AACZ;;AAEA;EACE,aAAa;AACf;;AAEA;EACE,aAAa;AACf;;AAEA;EACE,mDAAmD;AACrD;;AAEA;EACE,aAAa;EACb,gDAAgD;EAChD,8BAA8B;AAChC;;AAEA;EACE,gBAAgB;AAClB;;AAEA;EACE,gBAAgB;EAChB,yCAAyC;AAC3C;;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,eAAe;AACjB;;AAEA;EACE,iBAAiB;AACnB","sourcesContent":[".ai-configuration-widget {\n  padding: var(--theia-ui-padding);\n}\n\n.theia-ai-settings-container {\n  padding: var(--theia-ui-padding);\n}\n\n.language-model-container {\n  padding-top: calc(2 * var(--theia-ui-padding));\n}\n\n.language-model-container .theia-select {\n  margin-left: var(--theia-ui-padding);\n}\n\n.theia-settings-container\n  .settings-section-subcategory-title.ai-settings-section-subcategory-title {\n  padding-left: 0;\n}\n\n.ai-templates {\n  display: flex;\n  flex-direction: column;\n  gap: 5px;\n}\n\n.template-renderer {\n  display: flex;\n  flex-direction: column;\n  padding: 10px;\n}\n\n.template-header {\n  margin-bottom: 8px;\n}\n\n.template-controls {\n  display: flex;\n  align-items: center;\n  gap: 10px;\n}\n\n.template-select-label {\n  margin-right: 5px;\n}\n\n.template-variant-selector {\n  min-width: 120px;\n}\n\n.template-variant-selector.error {\n  border-color: var(--theia-errorForeground);\n  background-color: var(--theia-errorBackground, rgba(255, 0, 0, 0.1));\n  color: var(--theia-errorForeground);\n}\n\n#ai-variable-configuration-container-widget,\n#ai-agent-configuration-container-widget {\n  margin-top: 5px;\n}\n\n/* Variable Settings */\n#ai-variable-configuration-container-widget ul {\n  list-style: none;\n  padding: 0;\n  margin: 0;\n}\n\n#ai-variable-configuration-container-widget .variable-item {\n  display: flex;\n  flex-direction: column;\n  margin-bottom: 1rem;\n}\n\n#ai-variable-configuration-container-widget .variable-args {\n  display: grid;\n  grid-template-columns: 1fr 2fr;\n}\n\n/* Agent Settings */\n#ai-agent-configuration-container-widget ul {\n  list-style: none;\n  padding: 0;\n  margin: 0;\n}\n\n.ai-agent-configuration-main {\n  display: flex;\n  flex-direction: row;\n}\n\n.configuration-agents-list {\n  width: 128px;\n}\n\n.configuration-agent-panel {\n  flex: 1;\n}\n\n#ai-variable-configuration-container-widget .variable-references,\n#ai-agent-configuration-container-widget .variable-references,\n#ai-agent-configuration-container-widget .function-references {\n  margin-left: 0.5rem;\n  padding: 0.5rem;\n  border-left: solid 1px var(--theia-tree-indentGuidesStroke);\n}\n\n#ai-variable-configuration-container-widget .variable-reference,\n#ai-agent-configuration-container-widget .variable-reference,\n#ai-agent-configuration-container-widget .function-reference {\n  display: flex;\n  flex-direction: row;\n  align-items: center;\n}\n\n.agent-tag {\n  padding: calc(var(--theia-ui-padding) * 2 / 3);\n  padding-top: 0px;\n  padding-bottom: 0px;\n  border-radius: calc(var(--theia-ui-padding) * 2 / 3);\n  background: hsla(0, 0%, 68%, 0.31);\n}\n\n.configuration-agents-add {\n  margin-top: 3em;\n  margin-left: 0;\n}\n\n/* MCP Configuration Styles */\n.mcp-configuration-container {\n  padding: 16px;\n}\n\n.mcp-configuration-title {\n  margin: 0 0 16px 0;\n  border-bottom: 1px solid var(--theia-panelTitle-activeBorder);\n  padding-bottom: 8px;\n}\n\n.mcp-server-card {\n  border: 1px solid var(--theia-panelTitle-activeBorder);\n  border-radius: 6px;\n  padding: 12px;\n  margin-bottom: 16px;\n  background-color: var(--theia-editorWidget-background);\n}\n\n.mcp-server-header {\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n  margin-bottom: 12px;\n}\n\n.mcp-server-name {\n  font-weight: bold;\n  font-size: var(--theia-ui-font-size3);\n}\n\n.mcp-status-badge {\n  padding: 3px 8px;\n  border-radius: 12px;\n  font-size: 12px;\n  font-weight: bold;\n  display: inline-block;\n}\n\n.mcp-error-indicator {\n  display: inline-flex;\n  align-items: center;\n  justify-content: center;\n  width: 18px;\n  height: 18px;\n  border-radius: 50%;\n  background-color: var(--theia-errorBackground);\n  color: var(--theia-errorForeground);\n  font-size: 12px;\n  font-weight: bold;\n  cursor: pointer;\n  margin-left: 8px;\n}\n\n.mcp-server-section {\n  margin-bottom: 6px;\n}\n\n.mcp-section-label {\n  font-weight: bold;\n  color: var(--theia-descriptionForeground);\n}\n\n.mcp-code-block {\n  background-color: var(--theia-editor-background);\n  padding: 2px 4px;\n  border-radius: 3px;\n  font-family: monospace;\n}\n\n.mcp-env-block {\n  margin-left: 10px;\n  background-color: var(--theia-editor-background);\n  padding: 4px 8px;\n  border-radius: 3px;\n  font-family: monospace;\n  font-size: 12px;\n}\n\n.mcp-toggle-indicator {\n  width: 16px;\n  height: 16px;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  margin-right: 6px;\n  transition: transform 0.2s ease;\n}\n\n.mcp-tools-section {\n  margin-top: 12px;\n  cursor: pointer;\n  user-select: none;\n}\n\n.mcp-tools-list {\n  margin-left: 24px;\n  margin-top: 4px;\n  background-color: var(--theia-editor-background);\n  border-radius: 3px;\n  font-family: monospace;\n  font-size: 12px;\n}\n\n.mcp-autostart-badge {\n  padding: 2px 6px;\n  border-radius: 3px;\n  font-size: 12px;\n  font-weight: bold;\n}\n\n.mcp-no-servers {\n  padding: 20px;\n  text-align: center;\n  color: var(--theia-descriptionForeground);\n}\n\n.mcp-status-container {\n  display: flex;\n  align-items: center;\n}\n\n.mcp-server-controls {\n  display: flex;\n  align-items: center;\n  margin-top: 12px;\n  border-top: 1px solid var(--theia-panelTitle-inactiveForeground);\n  padding-top: 12px;\n}\n\n.mcp-server-button {\n  display: inline-flex;\n  align-items: center;\n  justify-content: center;\n  background-color: var(--theia-button-background);\n  color: var(--theia-button-foreground);\n  border: none;\n  border-radius: 4px;\n  padding: 6px 8px;\n  font-size: 12px;\n  cursor: pointer;\n  transition: background-color 0.2s;\n  margin-right: 10px;\n}\n\n.mcp-server-button:hover {\n  background-color: var(--theia-button-hoverBackground);\n}\n\n.mcp-server-button.play-button {\n  background-color: var(--theia-successBackground);\n  color: var(--theia-successForeground);\n}\n\n.mcp-server-button.play-button:hover {\n  background-color: var(--theia-successBackground);\n  filter: brightness(1.1);\n}\n\n.mcp-server-button.stop-button {\n  background-color: var(--theia-errorBackground);\n  color: var(--theia-errorForeground);\n}\n\n.mcp-server-button.stop-button:hover {\n  background-color: var(--theia-errorBackground);\n  filter: brightness(1.1);\n}\n\n.mcp-server-button-icon {\n  margin-right: 6px;\n  font-size: 14px;\n}\n\n.mcp-copy-tool-button {\n  background: transparent;\n  border: none;\n  padding: 0;\n  cursor: pointer;\n  font-size: 12px;\n  color: var(--theia-descriptionForeground);\n  white-space: nowrap;\n}\n\n.theia-ResponseNode-Content .disable-message {\n  font-size: 12px;\n  line-height: 1.6;\n  padding: 15px;\n}\n\n.theia-WelcomeMessage {\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n  align-items: center;\n  height: 100%;\n}\n\n.theia-WelcomeMessage-Content {\n  text-align: center;\n  padding: 0 18px;\n  max-width: 350px;\n}\n\n.theia-WelcomeMessage-Content h1 {\n  margin-top: 0;\n}\n\n.theia-WelcomeMessage-Content p {\n  font-size: var(--theia-ui-font-size2);\n  line-height: 18px;\n}\n\n.theia-WelcomeMessage-Content p .codicon {\n  vertical-align: sub;\n}\n\n.theia-WelcomeMessage-Content em {\n  font-weight: bolder;\n  font-style: normal;\n}\n\n/* Token Usage Configuration Styles */\n.token-usage-configuration-container {\n  padding: 16px;\n}\n\n.token-usage-configuration-title {\n  margin: 0 0 16px 0;\n  border-bottom: 1px solid var(--theia-widget-border);\n  padding-bottom: 8px;\n}\n\n.token-usage-controls {\n  display: flex;\n  justify-content: flex-end;\n  margin-bottom: 16px;\n}\n\n.token-usage-refresh-button {\n  display: inline-flex;\n  align-items: center;\n  background-color: var(--theia-button-background);\n  color: var(--theia-button-foreground);\n  border: none;\n  border-radius: 4px;\n  padding: 6px 12px;\n  font-size: 12px;\n  cursor: pointer;\n  transition: background-color 0.2s;\n}\n\n.token-usage-refresh-button:hover {\n  background-color: var(--theia-button-hoverBackground);\n}\n\n.token-usage-refresh-button i {\n  margin-right: 6px;\n}\n\n.token-usage-table-container {\n  overflow-x: auto;\n  border-radius: 6px;\n  background-color: var(--theia-editorWidget-background);\n}\n\n.token-usage-table {\n  width: 100%;\n  border-collapse: collapse;\n}\n\n.token-usage-header th {\n  text-align: left;\n  padding: 10px;\n  background-color: var(--theia-editor-background);\n  color: var(--theia-descriptionForeground);\n  font-weight: bold;\n}\n\n.token-usage-model-column {\n  width: 25%;\n}\n\n.token-usage-column {\n  width: 18.75%;\n}\n\n.token-usage-row td {\n  padding: 10px;\n}\n\n.token-usage-row:hover {\n  background-color: var(--theia-list-hoverBackground);\n}\n\n.token-usage-summary-row td {\n  padding: 10px;\n  background-color: var(--theia-editor-background);\n  color: var(--theia-foreground);\n}\n\n.token-usage-model-cell {\n  font-weight: 500;\n}\n\n.token-usage-notes {\n  margin-top: 16px;\n  color: var(--theia-descriptionForeground);\n}\n\n.token-usage-note {\n  display: flex;\n  align-items: center;\n  font-size: 12px;\n}\n\n.token-usage-note i {\n  margin-right: 8px;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_ai-ide_lib_browser_frontend-module_js.js.map