"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_markers_lib_browser_problem_problem-frontend-module_js"],{

/***/ "../../node_modules/@theia/markers/lib/browser/marker-tree-label-provider.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@theia/markers/lib/browser/marker-tree-label-provider.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2019 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MarkerTreeLabelProvider = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const label_provider_1 = __webpack_require__(/*! @theia/core/lib/browser/label-provider */ "../../node_modules/@theia/core/lib/browser/label-provider.js");
const marker_tree_1 = __webpack_require__(/*! ./marker-tree */ "../../node_modules/@theia/markers/lib/browser/marker-tree.js");
const tree_label_provider_1 = __webpack_require__(/*! @theia/core/lib/browser/tree/tree-label-provider */ "../../node_modules/@theia/core/lib/browser/tree/tree-label-provider.js");
const browser_1 = __webpack_require__(/*! @theia/workspace/lib/browser */ "../../node_modules/@theia/workspace/lib/browser/index.js");
let MarkerTreeLabelProvider = class MarkerTreeLabelProvider {
    canHandle(element) {
        return marker_tree_1.MarkerInfoNode.is(element) ?
            this.treeLabelProvider.canHandle(element) + 1 :
            0;
    }
    getIcon(node) {
        return this.labelProvider.getIcon(node.uri);
    }
    getName(node) {
        return this.labelProvider.getName(node.uri);
    }
    getLongName(node) {
        const description = [];
        const rootUri = this.workspaceService.getWorkspaceRootUri(node.uri);
        // In a multiple-root workspace include the root name to the label before the parent directory.
        if (this.workspaceService.isMultiRootWorkspaceOpened && rootUri) {
            description.push(this.labelProvider.getName(rootUri));
        }
        // If the given resource is not at the workspace root, include the parent directory to the label.
        if (rootUri && rootUri.toString() !== node.uri.parent.toString()) {
            description.push(this.labelProvider.getLongName(node.uri.parent));
        }
        // Get the full path of a resource which does not exist in the given workspace.
        if (!rootUri) {
            description.push(this.labelProvider.getLongName(node.uri.parent.withScheme('markers')));
        }
        return description.join(' ● ');
    }
    getDescription(node) {
        return this.labelProvider.getLongName(node.uri.parent);
    }
    affects(node, event) {
        return event.affects(node.uri) || event.affects(node.uri.parent);
    }
};
exports.MarkerTreeLabelProvider = MarkerTreeLabelProvider;
tslib_1.__decorate([
    (0, inversify_1.inject)(label_provider_1.LabelProvider),
    tslib_1.__metadata("design:type", label_provider_1.LabelProvider)
], MarkerTreeLabelProvider.prototype, "labelProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(tree_label_provider_1.TreeLabelProvider),
    tslib_1.__metadata("design:type", tree_label_provider_1.TreeLabelProvider)
], MarkerTreeLabelProvider.prototype, "treeLabelProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.WorkspaceService),
    tslib_1.__metadata("design:type", browser_1.WorkspaceService)
], MarkerTreeLabelProvider.prototype, "workspaceService", void 0);
exports.MarkerTreeLabelProvider = MarkerTreeLabelProvider = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], MarkerTreeLabelProvider);


/***/ }),

/***/ "../../node_modules/@theia/markers/lib/browser/problem/problem-container.js":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@theia/markers/lib/browser/problem/problem-container.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.createProblemWidget = exports.createProblemTreeContainer = exports.PROBLEM_OPTIONS = exports.PROBLEM_TREE_PROPS = void 0;
const marker_tree_1 = __webpack_require__(/*! ../marker-tree */ "../../node_modules/@theia/markers/lib/browser/marker-tree.js");
const problem_widget_1 = __webpack_require__(/*! ./problem-widget */ "../../node_modules/@theia/markers/lib/browser/problem/problem-widget.js");
const problem_tree_model_1 = __webpack_require__(/*! ./problem-tree-model */ "../../node_modules/@theia/markers/lib/browser/problem/problem-tree-model.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const problem_marker_1 = __webpack_require__(/*! ../../common/problem-marker */ "../../node_modules/@theia/markers/lib/common/problem-marker.js");
exports.PROBLEM_TREE_PROPS = {
    ...browser_1.defaultTreeProps,
    contextMenuPath: [problem_marker_1.PROBLEM_KIND],
    globalSelection: true
};
exports.PROBLEM_OPTIONS = {
    kind: 'problem'
};
function createProblemTreeContainer(parent) {
    const child = (0, browser_1.createTreeContainer)(parent, {
        tree: problem_tree_model_1.ProblemTree,
        widget: problem_widget_1.ProblemWidget,
        model: problem_tree_model_1.ProblemTreeModel,
        props: exports.PROBLEM_TREE_PROPS,
    });
    child.bind(marker_tree_1.MarkerOptions).toConstantValue(exports.PROBLEM_OPTIONS);
    return child;
}
exports.createProblemTreeContainer = createProblemTreeContainer;
function createProblemWidget(parent) {
    return createProblemTreeContainer(parent).get(problem_widget_1.ProblemWidget);
}
exports.createProblemWidget = createProblemWidget;


/***/ }),

/***/ "../../node_modules/@theia/markers/lib/browser/problem/problem-contribution.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@theia/markers/lib/browser/problem/problem-contribution.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ProblemContribution = exports.ProblemsCommands = exports.ProblemsMenu = exports.PROBLEMS_CONTEXT_MENU = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const debounce = __webpack_require__(/*! @theia/core/shared/lodash.debounce */ "../../node_modules/@theia/core/shared/lodash.debounce/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const status_bar_1 = __webpack_require__(/*! @theia/core/lib/browser/status-bar/status-bar */ "../../node_modules/@theia/core/lib/browser/status-bar/status-bar.js");
const view_contribution_1 = __webpack_require__(/*! @theia/core/lib/browser/shell/view-contribution */ "../../node_modules/@theia/core/lib/browser/shell/view-contribution.js");
const problem_marker_1 = __webpack_require__(/*! ../../common/problem-marker */ "../../node_modules/@theia/markers/lib/common/problem-marker.js");
const problem_manager_1 = __webpack_require__(/*! ./problem-manager */ "../../node_modules/@theia/markers/lib/browser/problem/problem-manager.js");
const problem_widget_1 = __webpack_require__(/*! ./problem-widget */ "../../node_modules/@theia/markers/lib/browser/problem/problem-widget.js");
const command_1 = __webpack_require__(/*! @theia/core/lib/common/command */ "../../node_modules/@theia/core/lib/common/command.js");
const selection_service_1 = __webpack_require__(/*! @theia/core/lib/common/selection-service */ "../../node_modules/@theia/core/lib/common/selection-service.js");
const problem_selection_1 = __webpack_require__(/*! ./problem-selection */ "../../node_modules/@theia/markers/lib/browser/problem/problem-selection.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
exports.PROBLEMS_CONTEXT_MENU = [problem_marker_1.PROBLEM_KIND];
var ProblemsMenu;
(function (ProblemsMenu) {
    ProblemsMenu.CLIPBOARD = [...exports.PROBLEMS_CONTEXT_MENU, '1_clipboard'];
    ProblemsMenu.PROBLEMS = [...exports.PROBLEMS_CONTEXT_MENU, '2_problems'];
})(ProblemsMenu || (exports.ProblemsMenu = ProblemsMenu = {}));
var ProblemsCommands;
(function (ProblemsCommands) {
    ProblemsCommands.COLLAPSE_ALL = {
        id: 'problems.collapse.all'
    };
    ProblemsCommands.COLLAPSE_ALL_TOOLBAR = {
        id: 'problems.collapse.all.toolbar',
        iconClass: (0, browser_1.codicon)('collapse-all')
    };
    ProblemsCommands.COPY = {
        id: 'problems.copy'
    };
    ProblemsCommands.COPY_MESSAGE = {
        id: 'problems.copy.message',
    };
    ProblemsCommands.CLEAR_ALL = command_1.Command.toLocalizedCommand({
        id: 'problems.clear.all',
        category: 'Problems',
        label: 'Clear All',
        iconClass: (0, browser_1.codicon)('clear-all')
    }, 'theia/markers/clearAll', nls_1.nls.getDefaultKey('Problems'));
})(ProblemsCommands || (exports.ProblemsCommands = ProblemsCommands = {}));
let ProblemContribution = class ProblemContribution extends view_contribution_1.AbstractViewContribution {
    constructor() {
        super({
            widgetId: problem_widget_1.PROBLEMS_WIDGET_ID,
            widgetName: nls_1.nls.localizeByDefault('Problems'),
            defaultWidgetOptions: {
                area: 'bottom'
            },
            toggleCommandId: 'problemsView:toggle',
            toggleKeybinding: 'ctrlcmd+shift+m'
        });
        this.updateStatusBarElement = debounce(() => this.setStatusBarElement(this.problemManager.getProblemStat()), 10);
    }
    onStart(app) {
        this.updateStatusBarElement();
        this.problemManager.onDidChangeMarkers(this.updateStatusBarElement);
    }
    async initializeLayout(app) {
        await this.openView();
    }
    setStatusBarElement(problemStat) {
        this.statusBar.setElement('problem-marker-status', {
            text: problemStat.infos <= 0
                ? `$(codicon-error) ${problemStat.errors} $(codicon-warning) ${problemStat.warnings}`
                : `$(codicon-error) ${problemStat.errors} $(codicon-warning) ${problemStat.warnings} $(codicon-info) ${problemStat.infos}`,
            alignment: status_bar_1.StatusBarAlignment.LEFT,
            priority: 10,
            command: this.toggleCommand ? this.toggleCommand.id : undefined,
            tooltip: this.getStatusBarTooltip(problemStat)
        });
    }
    /**
     * Get the tooltip to be displayed when hovering over the problem statusbar item.
     * - Displays `No Problems` when no problems are present.
     * - Displays a human-readable label which describes for each type of problem stat properties,
     * their overall count and type when any one of these properties has a positive count.
     * @param stat the problem stat describing the number of `errors`, `warnings` and `infos`.
     *
     * @return the tooltip to be displayed in the statusbar.
     */
    getStatusBarTooltip(stat) {
        if (stat.errors <= 0 && stat.warnings <= 0 && stat.infos <= 0) {
            return nls_1.nls.localizeByDefault('No Problems');
        }
        const tooltip = [];
        if (stat.errors > 0) {
            tooltip.push(nls_1.nls.localizeByDefault('{0} Errors', stat.errors));
        }
        if (stat.warnings > 0) {
            tooltip.push(nls_1.nls.localizeByDefault('{0} Warnings', stat.warnings));
        }
        if (stat.infos > 0) {
            tooltip.push(nls_1.nls.localizeByDefault('{0} Infos', stat.infos));
        }
        return tooltip.join(', ');
    }
    registerCommands(commands) {
        super.registerCommands(commands);
        commands.registerCommand(ProblemsCommands.COLLAPSE_ALL, {
            execute: () => this.collapseAllProblems()
        });
        commands.registerCommand(ProblemsCommands.COLLAPSE_ALL_TOOLBAR, {
            isEnabled: widget => this.withWidget(widget, () => true),
            isVisible: widget => this.withWidget(widget, () => true),
            execute: widget => this.withWidget(widget, () => this.collapseAllProblems())
        });
        commands.registerCommand(ProblemsCommands.COPY, new problem_selection_1.ProblemSelection.CommandHandler(this.selectionService, {
            multi: false,
            isEnabled: () => true,
            isVisible: () => true,
            execute: selection => this.copy(selection)
        }));
        commands.registerCommand(ProblemsCommands.COPY_MESSAGE, new problem_selection_1.ProblemSelection.CommandHandler(this.selectionService, {
            multi: false,
            isEnabled: () => true,
            isVisible: () => true,
            execute: selection => this.copyMessage(selection)
        }));
        commands.registerCommand(ProblemsCommands.CLEAR_ALL, {
            isEnabled: widget => this.withWidget(widget, () => true),
            isVisible: widget => this.withWidget(widget, () => true),
            execute: widget => this.withWidget(widget, () => this.problemManager.cleanAllMarkers())
        });
    }
    registerMenus(menus) {
        super.registerMenus(menus);
        menus.registerMenuAction(ProblemsMenu.CLIPBOARD, {
            commandId: ProblemsCommands.COPY.id,
            label: nls_1.nls.localizeByDefault('Copy'),
            order: '0'
        });
        menus.registerMenuAction(ProblemsMenu.CLIPBOARD, {
            commandId: ProblemsCommands.COPY_MESSAGE.id,
            label: nls_1.nls.localizeByDefault('Copy Message'),
            order: '1'
        });
        menus.registerMenuAction(ProblemsMenu.PROBLEMS, {
            commandId: ProblemsCommands.COLLAPSE_ALL.id,
            label: nls_1.nls.localizeByDefault('Collapse All'),
            order: '2'
        });
    }
    async registerToolbarItems(toolbarRegistry) {
        toolbarRegistry.registerItem({
            id: ProblemsCommands.COLLAPSE_ALL_TOOLBAR.id,
            command: ProblemsCommands.COLLAPSE_ALL_TOOLBAR.id,
            tooltip: nls_1.nls.localizeByDefault('Collapse All'),
            priority: 0,
        });
        toolbarRegistry.registerItem({
            id: ProblemsCommands.CLEAR_ALL.id,
            command: ProblemsCommands.CLEAR_ALL.id,
            tooltip: ProblemsCommands.CLEAR_ALL.label,
            priority: 1,
        });
    }
    async collapseAllProblems() {
        const { model } = await this.widget;
        const root = model.root;
        const firstChild = root.children[0];
        root.children.forEach(child => browser_1.CompositeTreeNode.is(child) && model.collapseAll(child));
        if (browser_1.SelectableTreeNode.is(firstChild)) {
            model.selectNode(firstChild);
        }
    }
    addToClipboard(content) {
        const handleCopy = (e) => {
            document.removeEventListener('copy', handleCopy);
            if (e.clipboardData) {
                e.clipboardData.setData('text/plain', content);
                e.preventDefault();
            }
        };
        document.addEventListener('copy', handleCopy);
        document.execCommand('copy');
    }
    copy(selection) {
        const marker = selection.marker;
        const serializedProblem = JSON.stringify({
            resource: marker.uri,
            owner: marker.owner,
            code: marker.data.code,
            severity: marker.data.severity,
            message: marker.data.message,
            source: marker.data.source,
            startLineNumber: marker.data.range.start.line,
            startColumn: marker.data.range.start.character,
            endLineNumber: marker.data.range.end.line,
            endColumn: marker.data.range.end.character
        }, undefined, '\t');
        this.addToClipboard(serializedProblem);
    }
    copyMessage(selection) {
        const marker = selection.marker;
        this.addToClipboard(marker.data.message);
    }
    withWidget(widget = this.tryGetWidget(), cb) {
        if (widget instanceof problem_widget_1.ProblemWidget && widget.id === problem_widget_1.PROBLEMS_WIDGET_ID) {
            return cb(widget);
        }
        return false;
    }
};
exports.ProblemContribution = ProblemContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(problem_manager_1.ProblemManager),
    tslib_1.__metadata("design:type", problem_manager_1.ProblemManager)
], ProblemContribution.prototype, "problemManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(status_bar_1.StatusBar),
    tslib_1.__metadata("design:type", Object)
], ProblemContribution.prototype, "statusBar", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(selection_service_1.SelectionService),
    tslib_1.__metadata("design:type", selection_service_1.SelectionService)
], ProblemContribution.prototype, "selectionService", void 0);
exports.ProblemContribution = ProblemContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)(),
    tslib_1.__metadata("design:paramtypes", [])
], ProblemContribution);


/***/ }),

/***/ "../../node_modules/@theia/markers/lib/browser/problem/problem-decorations-provider.js":
/*!*********************************************************************************************!*\
  !*** ../../node_modules/@theia/markers/lib/browser/problem/problem-decorations-provider.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2022 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ProblemDecorationContribution = exports.ProblemDecorationsProvider = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const decorations_service_1 = __webpack_require__(/*! @theia/core/lib/browser/decorations-service */ "../../node_modules/@theia/core/lib/browser/decorations-service.js");
const problem_manager_1 = __webpack_require__(/*! ./problem-manager */ "../../node_modules/@theia/markers/lib/browser/problem/problem-manager.js");
const problem_utils_1 = __webpack_require__(/*! ./problem-utils */ "../../node_modules/@theia/markers/lib/browser/problem/problem-utils.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const debounce = __webpack_require__(/*! @theia/core/shared/lodash.debounce */ "../../node_modules/@theia/core/shared/lodash.debounce/index.js");
let ProblemDecorationsProvider = class ProblemDecorationsProvider {
    constructor() {
        this.currentUris = [];
        this.onDidChangeEmitter = new core_1.Emitter();
        this.fireDidDecorationsChanged = debounce(() => this.doFireDidDecorationsChanged(), 50);
    }
    get onDidChange() {
        return this.onDidChangeEmitter.event;
    }
    init() {
        this.problemManager.onDidChangeMarkers(() => this.fireDidDecorationsChanged());
    }
    doFireDidDecorationsChanged() {
        const newUris = Array.from(this.problemManager.getUris(), stringified => new uri_1.default(stringified));
        this.onDidChangeEmitter.fire(newUris.concat(this.currentUris));
        this.currentUris = newUris;
    }
    provideDecorations(uri, token) {
        const markers = this.problemManager.findMarkers({ uri }).filter(problem_utils_1.ProblemUtils.filterMarker).sort(problem_utils_1.ProblemUtils.severityCompareMarker);
        if (markers.length) {
            return {
                bubble: true,
                letter: markers.length.toString(),
                weight: problem_utils_1.ProblemUtils.getPriority(markers[0]),
                colorId: problem_utils_1.ProblemUtils.getColor(markers[0]),
                tooltip: markers.length === 1 ? core_1.nls.localizeByDefault('1 problem in this file') : core_1.nls.localizeByDefault('{0} problems in this file', markers.length),
            };
        }
    }
};
exports.ProblemDecorationsProvider = ProblemDecorationsProvider;
tslib_1.__decorate([
    (0, inversify_1.inject)(problem_manager_1.ProblemManager),
    tslib_1.__metadata("design:type", problem_manager_1.ProblemManager)
], ProblemDecorationsProvider.prototype, "problemManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], ProblemDecorationsProvider.prototype, "init", null);
exports.ProblemDecorationsProvider = ProblemDecorationsProvider = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ProblemDecorationsProvider);
let ProblemDecorationContribution = class ProblemDecorationContribution {
    initialize() {
        this.decorationsService.registerDecorationsProvider(this.problemDecorationProvider);
    }
};
exports.ProblemDecorationContribution = ProblemDecorationContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(decorations_service_1.DecorationsService),
    tslib_1.__metadata("design:type", Object)
], ProblemDecorationContribution.prototype, "decorationsService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(ProblemDecorationsProvider),
    tslib_1.__metadata("design:type", ProblemDecorationsProvider)
], ProblemDecorationContribution.prototype, "problemDecorationProvider", void 0);
exports.ProblemDecorationContribution = ProblemDecorationContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ProblemDecorationContribution);


/***/ }),

/***/ "../../node_modules/@theia/markers/lib/browser/problem/problem-frontend-module.js":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@theia/markers/lib/browser/problem/problem-frontend-module.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
__webpack_require__(/*! ../../../src/browser/style/index.css */ "../../node_modules/@theia/markers/src/browser/style/index.css");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const problem_widget_1 = __webpack_require__(/*! ./problem-widget */ "../../node_modules/@theia/markers/lib/browser/problem/problem-widget.js");
const problem_contribution_1 = __webpack_require__(/*! ./problem-contribution */ "../../node_modules/@theia/markers/lib/browser/problem/problem-contribution.js");
const problem_container_1 = __webpack_require__(/*! ./problem-container */ "../../node_modules/@theia/markers/lib/browser/problem/problem-container.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const problem_manager_1 = __webpack_require__(/*! ./problem-manager */ "../../node_modules/@theia/markers/lib/browser/problem/problem-manager.js");
const widget_manager_1 = __webpack_require__(/*! @theia/core/lib/browser/widget-manager */ "../../node_modules/@theia/core/lib/browser/widget-manager.js");
const problem_tabbar_decorator_1 = __webpack_require__(/*! ./problem-tabbar-decorator */ "../../node_modules/@theia/markers/lib/browser/problem/problem-tabbar-decorator.js");
const tab_bar_toolbar_1 = __webpack_require__(/*! @theia/core/lib/browser/shell/tab-bar-toolbar */ "../../node_modules/@theia/core/lib/browser/shell/tab-bar-toolbar/index.js");
const problem_layout_migrations_1 = __webpack_require__(/*! ./problem-layout-migrations */ "../../node_modules/@theia/markers/lib/browser/problem/problem-layout-migrations.js");
const tab_bar_decorator_1 = __webpack_require__(/*! @theia/core/lib/browser/shell/tab-bar-decorator */ "../../node_modules/@theia/core/lib/browser/shell/tab-bar-decorator.js");
const problem_preferences_1 = __webpack_require__(/*! ./problem-preferences */ "../../node_modules/@theia/markers/lib/browser/problem/problem-preferences.js");
const marker_tree_label_provider_1 = __webpack_require__(/*! ../marker-tree-label-provider */ "../../node_modules/@theia/markers/lib/browser/marker-tree-label-provider.js");
const problem_widget_tab_bar_decorator_1 = __webpack_require__(/*! ./problem-widget-tab-bar-decorator */ "../../node_modules/@theia/markers/lib/browser/problem/problem-widget-tab-bar-decorator.js");
const problem_decorations_provider_1 = __webpack_require__(/*! ./problem-decorations-provider */ "../../node_modules/@theia/markers/lib/browser/problem/problem-decorations-provider.js");
exports["default"] = new inversify_1.ContainerModule(bind => {
    (0, problem_preferences_1.bindProblemPreferences)(bind);
    bind(problem_manager_1.ProblemManager).toSelf().inSingletonScope();
    bind(problem_widget_1.ProblemWidget).toDynamicValue(ctx => (0, problem_container_1.createProblemWidget)(ctx.container));
    bind(widget_manager_1.WidgetFactory).toDynamicValue(context => ({
        id: problem_widget_1.PROBLEMS_WIDGET_ID,
        createWidget: () => context.container.get(problem_widget_1.ProblemWidget)
    }));
    bind(browser_1.ApplicationShellLayoutMigration).to(problem_layout_migrations_1.ProblemLayoutVersion3Migration).inSingletonScope();
    (0, browser_1.bindViewContribution)(bind, problem_contribution_1.ProblemContribution);
    bind(browser_1.FrontendApplicationContribution).toService(problem_contribution_1.ProblemContribution);
    bind(tab_bar_toolbar_1.TabBarToolbarContribution).toService(problem_contribution_1.ProblemContribution);
    bind(problem_decorations_provider_1.ProblemDecorationsProvider).toSelf().inSingletonScope();
    bind(problem_tabbar_decorator_1.ProblemTabBarDecorator).toSelf().inSingletonScope();
    bind(tab_bar_decorator_1.TabBarDecorator).toService(problem_tabbar_decorator_1.ProblemTabBarDecorator);
    bind(problem_decorations_provider_1.ProblemDecorationContribution).toSelf().inSingletonScope();
    bind(browser_1.FrontendApplicationContribution).toService(problem_decorations_provider_1.ProblemDecorationContribution);
    bind(marker_tree_label_provider_1.MarkerTreeLabelProvider).toSelf().inSingletonScope();
    bind(browser_1.LabelProviderContribution).toService(marker_tree_label_provider_1.MarkerTreeLabelProvider);
    bind(problem_widget_tab_bar_decorator_1.ProblemWidgetTabBarDecorator).toSelf().inSingletonScope();
    bind(tab_bar_decorator_1.TabBarDecorator).toService(problem_widget_tab_bar_decorator_1.ProblemWidgetTabBarDecorator);
});


/***/ }),

/***/ "../../node_modules/@theia/markers/lib/browser/problem/problem-layout-migrations.js":
/*!******************************************************************************************!*\
  !*** ../../node_modules/@theia/markers/lib/browser/problem/problem-layout-migrations.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2019 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ProblemLayoutVersion3Migration = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const problem_marker_1 = __webpack_require__(/*! ../../common/problem-marker */ "../../node_modules/@theia/markers/lib/common/problem-marker.js");
const problem_widget_1 = __webpack_require__(/*! ./problem-widget */ "../../node_modules/@theia/markers/lib/browser/problem/problem-widget.js");
let ProblemLayoutVersion3Migration = class ProblemLayoutVersion3Migration {
    constructor() {
        this.layoutVersion = 3.0;
    }
    onWillInflateWidget(desc) {
        if (desc.constructionOptions.factoryId === problem_marker_1.PROBLEM_KIND) {
            desc.constructionOptions.factoryId = problem_widget_1.PROBLEMS_WIDGET_ID;
            return desc;
        }
        return undefined;
    }
};
exports.ProblemLayoutVersion3Migration = ProblemLayoutVersion3Migration;
exports.ProblemLayoutVersion3Migration = ProblemLayoutVersion3Migration = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ProblemLayoutVersion3Migration);


/***/ }),

/***/ "../../node_modules/@theia/markers/lib/browser/problem/problem-tabbar-decorator.js":
/*!*****************************************************************************************!*\
  !*** ../../node_modules/@theia/markers/lib/browser/problem/problem-tabbar-decorator.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2019 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ProblemTabBarDecorator = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const vscode_languageserver_protocol_1 = __webpack_require__(/*! @theia/core/shared/vscode-languageserver-protocol */ "../../node_modules/@theia/core/shared/vscode-languageserver-protocol/index.js");
const event_1 = __webpack_require__(/*! @theia/core/lib/common/event */ "../../node_modules/@theia/core/lib/common/event.js");
const widget_decoration_1 = __webpack_require__(/*! @theia/core/lib/browser/widget-decoration */ "../../node_modules/@theia/core/lib/browser/widget-decoration.js");
const problem_manager_1 = __webpack_require__(/*! ./problem-manager */ "../../node_modules/@theia/markers/lib/browser/problem/problem-manager.js");
const problem_preferences_1 = __webpack_require__(/*! ./problem-preferences */ "../../node_modules/@theia/markers/lib/browser/problem/problem-preferences.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
let ProblemTabBarDecorator = class ProblemTabBarDecorator {
    constructor() {
        this.id = 'theia-problem-tabbar-decorator';
        this.emitter = new event_1.Emitter();
    }
    init() {
        this.problemManager.onDidChangeMarkers(() => this.fireDidChangeDecorations());
        this.preferences.onPreferenceChanged(event => this.handlePreferenceChange(event));
    }
    decorate(title) {
        if (!this.preferences['problems.decorations.tabbar.enabled']) {
            return [];
        }
        const widget = title.owner;
        if (browser_1.Navigatable.is(widget)) {
            const resourceUri = widget.getResourceUri();
            if (resourceUri) {
                // Get the list of problem markers for the given resource URI.
                const markers = this.problemManager.findMarkers({ uri: resourceUri });
                // If no markers are available, return early.
                if (markers.length === 0) {
                    return [];
                }
                // Store the marker with the highest severity.
                let maxSeverity;
                // Iterate over available markers to determine that which has the highest severity.
                // Only display a decoration if an error or warning marker is available.
                for (const marker of markers) {
                    // Break early if an error marker is present, since it represents the highest severity.
                    if (marker.data.severity === vscode_languageserver_protocol_1.DiagnosticSeverity.Error) {
                        maxSeverity = marker;
                        break;
                    }
                    else if (marker.data.severity === vscode_languageserver_protocol_1.DiagnosticSeverity.Warning) {
                        maxSeverity = marker;
                    }
                }
                // Decorate the tabbar with the highest marker severity if available.
                return maxSeverity ? [this.toDecorator(maxSeverity)] : [];
            }
        }
        return [];
    }
    get onDidChangeDecorations() {
        return this.emitter.event;
    }
    fireDidChangeDecorations() {
        this.emitter.fire(undefined);
    }
    /**
     * Handle changes in preference.
     * @param {PreferenceChangeEvent<ProblemConfiguration>} event The event of the changes in preference.
     */
    async handlePreferenceChange(event) {
        const { preferenceName } = event;
        if (preferenceName === 'problems.decorations.tabbar.enabled') {
            this.fireDidChangeDecorations();
        }
    }
    /**
     * Convert a diagnostic marker to a decorator.
     * @param {Marker<Diagnostic>} marker A diagnostic marker.
     * @returns {WidgetDecoration.Data} The decoration data.
     */
    toDecorator(marker) {
        const position = widget_decoration_1.WidgetDecoration.IconOverlayPosition.BOTTOM_RIGHT;
        const icon = this.getOverlayIcon(marker);
        const color = this.getOverlayIconColor(marker);
        return {
            iconOverlay: {
                position,
                icon,
                color,
                background: {
                    shape: 'circle',
                    color: 'transparent'
                }
            }
        };
    }
    /**
     * Get the appropriate overlay icon for decoration.
     * @param {Marker<Diagnostic>} marker A diagnostic marker.
     * @returns {string} A string representing the overlay icon class.
     */
    getOverlayIcon(marker) {
        const { severity } = marker.data;
        switch (severity) {
            case 1: return 'times-circle';
            case 2: return 'exclamation-circle';
            case 3: return 'info-circle';
            default: return 'hand-o-up';
        }
    }
    /**
     * Get the appropriate overlay icon color for decoration.
     * @param {Marker<Diagnostic>} marker A diagnostic marker.
     * @returns {WidgetDecoration.Color} The decoration color.
     */
    getOverlayIconColor(marker) {
        const { severity } = marker.data;
        switch (severity) {
            case 1: return 'var(--theia-list-errorForeground)';
            case 2: return 'var(--theia-list-warningForeground)';
            default: return 'var(--theia-successBackground)';
        }
    }
};
exports.ProblemTabBarDecorator = ProblemTabBarDecorator;
tslib_1.__decorate([
    (0, inversify_1.inject)(problem_preferences_1.ProblemPreferences),
    tslib_1.__metadata("design:type", Object)
], ProblemTabBarDecorator.prototype, "preferences", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(problem_manager_1.ProblemManager),
    tslib_1.__metadata("design:type", problem_manager_1.ProblemManager)
], ProblemTabBarDecorator.prototype, "problemManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], ProblemTabBarDecorator.prototype, "init", null);
exports.ProblemTabBarDecorator = ProblemTabBarDecorator = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ProblemTabBarDecorator);


/***/ }),

/***/ "../../node_modules/@theia/markers/lib/browser/problem/problem-widget-tab-bar-decorator.js":
/*!*************************************************************************************************!*\
  !*** ../../node_modules/@theia/markers/lib/browser/problem/problem-widget-tab-bar-decorator.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2020 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ProblemWidgetTabBarDecorator = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const event_1 = __webpack_require__(/*! @theia/core/lib/common/event */ "../../node_modules/@theia/core/lib/common/event.js");
const problem_manager_1 = __webpack_require__(/*! ./problem-manager */ "../../node_modules/@theia/markers/lib/browser/problem/problem-manager.js");
let ProblemWidgetTabBarDecorator = class ProblemWidgetTabBarDecorator {
    constructor() {
        this.id = 'theia-problems-widget-tabbar-decorator';
        this.emitter = new event_1.Emitter();
    }
    init() {
        this.problemManager.onDidChangeMarkers(() => this.fireDidChangeDecorations());
    }
    decorate(title) {
        if (title.owner.id === 'problems') {
            const { infos, warnings, errors } = this.problemManager.getProblemStat();
            const markerCount = infos + warnings + errors;
            return markerCount > 0 ? [{ badge: markerCount }] : [];
        }
        else {
            return [];
        }
    }
    get onDidChangeDecorations() {
        return this.emitter.event;
    }
    fireDidChangeDecorations() {
        this.emitter.fire(undefined);
    }
};
exports.ProblemWidgetTabBarDecorator = ProblemWidgetTabBarDecorator;
tslib_1.__decorate([
    (0, inversify_1.inject)(problem_manager_1.ProblemManager),
    tslib_1.__metadata("design:type", problem_manager_1.ProblemManager)
], ProblemWidgetTabBarDecorator.prototype, "problemManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], ProblemWidgetTabBarDecorator.prototype, "init", null);
exports.ProblemWidgetTabBarDecorator = ProblemWidgetTabBarDecorator = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ProblemWidgetTabBarDecorator);


/***/ }),

/***/ "../../node_modules/@theia/markers/src/browser/style/index.css":
/*!*********************************************************************!*\
  !*** ../../node_modules/@theia/markers/src/browser/style/index.css ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_loader_dist_cjs_js_index_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !!../../../../../css-loader/dist/cjs.js!./index.css */ "../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/markers/src/browser/style/index.css");

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_css_loader_dist_cjs_js_index_css__WEBPACK_IMPORTED_MODULE_1__["default"], options);



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_css_loader_dist_cjs_js_index_css__WEBPACK_IMPORTED_MODULE_1__["default"].locals || {});

/***/ }),

/***/ "../../node_modules/@theia/workspace/lib/browser/index.js":
/*!****************************************************************!*\
  !*** ../../node_modules/@theia/workspace/lib/browser/index.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-commands */ "../../node_modules/@theia/workspace/lib/browser/workspace-commands.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-service.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./canonical-uri-service */ "../../node_modules/@theia/workspace/lib/browser/canonical-uri-service.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-frontend-contribution */ "../../node_modules/@theia/workspace/lib/browser/workspace-frontend-contribution.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-frontend-module */ "../../node_modules/@theia/workspace/lib/browser/workspace-frontend-module.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-preferences */ "../../node_modules/@theia/workspace/lib/browser/workspace-preferences.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-trust-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-trust-service.js"), exports);


/***/ }),

/***/ "../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/markers/src/browser/style/index.css":
/*!***************************************************************************************************************!*\
  !*** ../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/markers/src/browser/style/index.css ***!
  \***************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../css-loader/dist/runtime/sourceMaps.js */ "../../node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../css-loader/dist/runtime/api.js */ "../../node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
 ********************************************************************************/

.theia-marker-container {
  font-size: var(--theia-ui-font-size1);
}

.theia-side-panel .theia-marker-container .noMarkers {
  padding-left: 19px;
}

.theia-marker-container .markerNode,
.theia-marker-container .markerFileNode {
  display: flex;
  align-items: center;
}

.theia-marker-container .markerNode div,
.theia-marker-container .markerFileNode div:not(.file-icon) {
  display: flex;
  margin-right: 5px;
}

.theia-marker-container .markerFileNode .name,
.theia-marker-container .markerFileNode .path {
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
}

.theia-marker-container .markerFileNode .path {
  font-size: var(--theia-ui-font-size0);
  align-self: flex-end;
  white-space: nowrap;
}

.theia-marker-container .error {
  color: var(--theia-editorError-foreground);
  opacity: 1;
}

.theia-marker-container .warning {
  color: var(--theia-editorWarning-foreground);
  opacity: 1;
}

.theia-marker-container .information {
  color: var(--theia-editorInfo-foreground);
  opacity: 1;
}

.theia-marker-container .hint {
  color: var(--theia-successBackground);
  opacity: 1;
}

.theia-marker-container .markerNode .position,
.theia-marker-container .markerNode .owner {
  white-space: nowrap;
  margin-left: 5px;
}

.theia-marker-container .markerNode .message {
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
}

.theia-marker-container .row-button-container {
  display: none;
}

.theia-marker-container .theia-TreeNodeContent:hover .row-button-container {
  display: flex;
  justify-content: flex-end;
  flex: 1;
  align-items: center;
  align-self: center;
}
`, "",{"version":3,"sources":["webpack://./../../node_modules/@theia/markers/src/browser/style/index.css"],"names":[],"mappings":"AAAA;;;;;;;;;;;;;;iFAciF;;AAEjF;EACE,qCAAqC;AACvC;;AAEA;EACE,kBAAkB;AACpB;;AAEA;;EAEE,aAAa;EACb,mBAAmB;AACrB;;AAEA;;EAEE,aAAa;EACb,iBAAiB;AACnB;;AAEA;;EAEE,gBAAgB;EAChB,uBAAuB;EACvB,mBAAmB;AACrB;;AAEA;EACE,qCAAqC;EACrC,oBAAoB;EACpB,mBAAmB;AACrB;;AAEA;EACE,0CAA0C;EAC1C,UAAU;AACZ;;AAEA;EACE,4CAA4C;EAC5C,UAAU;AACZ;;AAEA;EACE,yCAAyC;EACzC,UAAU;AACZ;;AAEA;EACE,qCAAqC;EACrC,UAAU;AACZ;;AAEA;;EAEE,mBAAmB;EACnB,gBAAgB;AAClB;;AAEA;EACE,mBAAmB;EACnB,gBAAgB;EAChB,uBAAuB;AACzB;;AAEA;EACE,aAAa;AACf;;AAEA;EACE,aAAa;EACb,yBAAyB;EACzB,OAAO;EACP,mBAAmB;EACnB,kBAAkB;AACpB","sourcesContent":["/********************************************************************************\n * Copyright (C) 2017 TypeFox and others.\n *\n * This program and the accompanying materials are made available under the\n * terms of the Eclipse Public License v. 2.0 which is available at\n * http://www.eclipse.org/legal/epl-2.0.\n *\n * This Source Code may also be made available under the following Secondary\n * Licenses when the conditions for such availability set forth in the Eclipse\n * Public License v. 2.0 are satisfied: GNU General Public License, version 2\n * with the GNU Classpath Exception which is available at\n * https://www.gnu.org/software/classpath/license.html.\n *\n * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0\n ********************************************************************************/\n\n.theia-marker-container {\n  font-size: var(--theia-ui-font-size1);\n}\n\n.theia-side-panel .theia-marker-container .noMarkers {\n  padding-left: 19px;\n}\n\n.theia-marker-container .markerNode,\n.theia-marker-container .markerFileNode {\n  display: flex;\n  align-items: center;\n}\n\n.theia-marker-container .markerNode div,\n.theia-marker-container .markerFileNode div:not(.file-icon) {\n  display: flex;\n  margin-right: 5px;\n}\n\n.theia-marker-container .markerFileNode .name,\n.theia-marker-container .markerFileNode .path {\n  overflow: hidden;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n}\n\n.theia-marker-container .markerFileNode .path {\n  font-size: var(--theia-ui-font-size0);\n  align-self: flex-end;\n  white-space: nowrap;\n}\n\n.theia-marker-container .error {\n  color: var(--theia-editorError-foreground);\n  opacity: 1;\n}\n\n.theia-marker-container .warning {\n  color: var(--theia-editorWarning-foreground);\n  opacity: 1;\n}\n\n.theia-marker-container .information {\n  color: var(--theia-editorInfo-foreground);\n  opacity: 1;\n}\n\n.theia-marker-container .hint {\n  color: var(--theia-successBackground);\n  opacity: 1;\n}\n\n.theia-marker-container .markerNode .position,\n.theia-marker-container .markerNode .owner {\n  white-space: nowrap;\n  margin-left: 5px;\n}\n\n.theia-marker-container .markerNode .message {\n  white-space: nowrap;\n  overflow: hidden;\n  text-overflow: ellipsis;\n}\n\n.theia-marker-container .row-button-container {\n  display: none;\n}\n\n.theia-marker-container .theia-TreeNodeContent:hover .row-button-container {\n  display: flex;\n  justify-content: flex-end;\n  flex: 1;\n  align-items: center;\n  align-self: center;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_markers_lib_browser_problem_problem-frontend-module_js.js.map