"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_ai-code-completion_lib_browser_ai-code-completion-frontend-module_js"],{

/***/ "../../node_modules/@theia/ai-code-completion/lib/browser/ai-code-completion-frontend-module.js":
/*!******************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-code-completion/lib/browser/ai-code-completion-frontend-module.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const code_completion_agent_1 = __webpack_require__(/*! ./code-completion-agent */ "../../node_modules/@theia/ai-code-completion/lib/browser/code-completion-agent.js");
const ai_code_frontend_application_contribution_1 = __webpack_require__(/*! ./ai-code-frontend-application-contribution */ "../../node_modules/@theia/ai-code-completion/lib/browser/ai-code-frontend-application-contribution.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const ai_core_1 = __webpack_require__(/*! @theia/ai-core */ "../../node_modules/@theia/ai-core/lib/common/index.js");
const ai_code_completion_preference_1 = __webpack_require__(/*! ./ai-code-completion-preference */ "../../node_modules/@theia/ai-code-completion/lib/browser/ai-code-completion-preference.js");
const ai_code_inline_completion_provider_1 = __webpack_require__(/*! ./ai-code-inline-completion-provider */ "../../node_modules/@theia/ai-code-completion/lib/browser/ai-code-inline-completion-provider.js");
const code_completion_postprocessor_1 = __webpack_require__(/*! ./code-completion-postprocessor */ "../../node_modules/@theia/ai-code-completion/lib/browser/code-completion-postprocessor.js");
exports["default"] = new inversify_1.ContainerModule(bind => {
    bind(code_completion_agent_1.CodeCompletionAgentImpl).toSelf().inSingletonScope();
    bind(code_completion_agent_1.CodeCompletionAgent).toService(code_completion_agent_1.CodeCompletionAgentImpl);
    bind(ai_core_1.Agent).toService(code_completion_agent_1.CodeCompletionAgentImpl);
    bind(ai_code_inline_completion_provider_1.AICodeInlineCompletionsProvider).toSelf().inSingletonScope();
    bind(ai_code_frontend_application_contribution_1.AIFrontendApplicationContribution).toSelf().inSingletonScope();
    bind(browser_1.FrontendApplicationContribution).to(ai_code_frontend_application_contribution_1.AIFrontendApplicationContribution);
    bind(browser_1.KeybindingContribution).toService(ai_code_frontend_application_contribution_1.AIFrontendApplicationContribution);
    bind(browser_1.PreferenceContribution).toConstantValue({ schema: ai_code_completion_preference_1.AICodeCompletionPreferencesSchema });
    bind(code_completion_postprocessor_1.CodeCompletionPostProcessor).to(code_completion_postprocessor_1.DefaultCodeCompletionPostProcessor).inSingletonScope();
});


/***/ }),

/***/ "../../node_modules/@theia/ai-code-completion/lib/browser/ai-code-completion-preference.js":
/*!*************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-code-completion/lib/browser/ai-code-completion-preference.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AICodeCompletionPreferencesSchema = exports.PREF_AI_INLINE_COMPLETION_STRIP_BACKTICKS = exports.PREF_AI_INLINE_COMPLETION_MAX_CONTEXT_LINES = exports.PREF_AI_INLINE_COMPLETION_EXCLUDED_EXTENSIONS = exports.PREF_AI_INLINE_COMPLETION_AUTOMATIC_ENABLE = void 0;
const ai_core_preferences_1 = __webpack_require__(/*! @theia/ai-core/lib/browser/ai-core-preferences */ "../../node_modules/@theia/ai-core/lib/browser/ai-core-preferences.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
exports.PREF_AI_INLINE_COMPLETION_AUTOMATIC_ENABLE = 'ai-features.codeCompletion.automaticCodeCompletion';
exports.PREF_AI_INLINE_COMPLETION_EXCLUDED_EXTENSIONS = 'ai-features.codeCompletion.excludedFileExtensions';
exports.PREF_AI_INLINE_COMPLETION_MAX_CONTEXT_LINES = 'ai-features.codeCompletion.maxContextLines';
exports.PREF_AI_INLINE_COMPLETION_STRIP_BACKTICKS = 'ai-features.codeCompletion.stripBackticks';
exports.AICodeCompletionPreferencesSchema = {
    type: 'object',
    properties: {
        [exports.PREF_AI_INLINE_COMPLETION_AUTOMATIC_ENABLE]: {
            title: ai_core_preferences_1.AI_CORE_PREFERENCES_TITLE,
            type: 'boolean',
            description: core_1.nls.localize('theia/ai/completion/automaticEnable/description', 'Automatically trigger AI completions inline within any (Monaco) editor while editing.\
            \n\
            Alternatively, you can manually trigger the code via the command "Trigger Inline Suggestion" or the default shortcut "Ctrl+Alt+Space".'),
            default: false
        },
        [exports.PREF_AI_INLINE_COMPLETION_EXCLUDED_EXTENSIONS]: {
            title: core_1.nls.localize('theia/ai/completion/excludedFileExts/title', 'Excluded File Extensions'),
            type: 'array',
            description: core_1.nls.localize('theia/ai/completion/excludedFileExts/description', 'Specify file extensions (e.g., .md, .txt) where AI completions should be disabled.'),
            items: {
                type: 'string'
            },
            default: []
        },
        [exports.PREF_AI_INLINE_COMPLETION_MAX_CONTEXT_LINES]: {
            title: core_1.nls.localize('theia/ai/completion/maxContextLines/title', 'Maximum Context Lines'),
            type: 'number',
            description: core_1.nls.localize('theia/ai/completion/maxContextLines/description', 'The maximum number of lines used as context, distributed among the lines before and after the cursor position (prefix and suffix).\
            Set this to -1 to use the full file as context without any line limit and 0 to only use the current line.'),
            default: -1,
            minimum: -1
        },
        [exports.PREF_AI_INLINE_COMPLETION_STRIP_BACKTICKS]: {
            title: core_1.nls.localize('theia/ai/completion/stripBackticks/title', 'Strip Backticks from Inline Completions'),
            type: 'boolean',
            description: core_1.nls.localize('theia/ai/completion/stripBackticks/description', 'Remove surrounding backticks from the code returned by some LLMs. If a backtick is detected, all content after the closing\
             backtick is stripped as well. This setting helps ensure plain code is returned when language models use markdown-like formatting.'),
            default: true
        }
    }
};


/***/ }),

/***/ "../../node_modules/@theia/ai-code-completion/lib/browser/ai-code-frontend-application-contribution.js":
/*!*************************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-code-completion/lib/browser/ai-code-frontend-application-contribution.js ***!
  \*************************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AIFrontendApplicationContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const monaco = __webpack_require__(/*! @theia/monaco-editor-core */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/editor.main.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_2 = __webpack_require__(/*! @theia/ai-core/lib/browser */ "../../node_modules/@theia/ai-core/lib/browser/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const ai_code_inline_completion_provider_1 = __webpack_require__(/*! ./ai-code-inline-completion-provider */ "../../node_modules/@theia/ai-code-completion/lib/browser/ai-code-inline-completion-provider.js");
const ai_code_completion_preference_1 = __webpack_require__(/*! ./ai-code-completion-preference */ "../../node_modules/@theia/ai-code-completion/lib/browser/ai-code-completion-preference.js");
const languages_1 = __webpack_require__(/*! @theia/monaco-editor-core/esm/vs/editor/common/languages */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/common/languages.js");
let AIFrontendApplicationContribution = class AIFrontendApplicationContribution {
    constructor() {
        this.toDispose = new Map();
    }
    onDidInitializeLayout() {
        this.preferenceService.ready.then(() => {
            this.handlePreferences();
        });
    }
    handlePreferences() {
        const handler = () => this.handleInlineCompletions();
        this.toDispose.set('inlineCompletions', handler());
        this.preferenceService.onPreferenceChanged(event => {
            var _a;
            if (event.preferenceName === ai_code_completion_preference_1.PREF_AI_INLINE_COMPLETION_AUTOMATIC_ENABLE
                || event.preferenceName === ai_code_completion_preference_1.PREF_AI_INLINE_COMPLETION_EXCLUDED_EXTENSIONS) {
                (_a = this.toDispose.get('inlineCompletions')) === null || _a === void 0 ? void 0 : _a.dispose();
                this.toDispose.set('inlineCompletions', handler());
            }
        });
        this.activationService.onDidChangeActiveStatus(change => {
            var _a;
            (_a = this.toDispose.get('inlineCompletions')) === null || _a === void 0 ? void 0 : _a.dispose();
            this.toDispose.set('inlineCompletions', handler());
        });
    }
    registerKeybindings(keybindings) {
        keybindings.registerKeybinding({
            command: 'editor.action.inlineSuggest.trigger',
            keybinding: 'Ctrl+Alt+Space',
            when: '!editorReadonly && editorTextFocus'
        });
    }
    handleInlineCompletions() {
        if (!this.activationService.isActive) {
            return core_1.Disposable.NULL;
        }
        const automatic = this.preferenceService.get(ai_code_completion_preference_1.PREF_AI_INLINE_COMPLETION_AUTOMATIC_ENABLE, true);
        const excludedExtensions = this.preferenceService.get(ai_code_completion_preference_1.PREF_AI_INLINE_COMPLETION_EXCLUDED_EXTENSIONS, []);
        return monaco.languages.registerInlineCompletionsProvider({ scheme: 'file' }, {
            provideInlineCompletions: (model, position, context, token) => {
                if (!automatic && context.triggerKind === languages_1.InlineCompletionTriggerKind.Automatic) {
                    return { items: [] };
                }
                const fileName = model.uri.toString();
                if (excludedExtensions.some(ext => fileName.endsWith(ext))) {
                    return { items: [] };
                }
                return this.inlineCodeCompletionProvider.provideInlineCompletions(model, position, context, token);
            },
            freeInlineCompletions: completions => {
                this.inlineCodeCompletionProvider.freeInlineCompletions(completions);
            }
        });
    }
};
exports.AIFrontendApplicationContribution = AIFrontendApplicationContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_code_inline_completion_provider_1.AICodeInlineCompletionsProvider),
    tslib_1.__metadata("design:type", ai_code_inline_completion_provider_1.AICodeInlineCompletionsProvider)
], AIFrontendApplicationContribution.prototype, "inlineCodeCompletionProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.PreferenceService),
    tslib_1.__metadata("design:type", Object)
], AIFrontendApplicationContribution.prototype, "preferenceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.AIActivationService),
    tslib_1.__metadata("design:type", browser_2.AIActivationService)
], AIFrontendApplicationContribution.prototype, "activationService", void 0);
exports.AIFrontendApplicationContribution = AIFrontendApplicationContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], AIFrontendApplicationContribution);


/***/ }),

/***/ "../../node_modules/@theia/ai-code-completion/lib/browser/ai-code-inline-completion-provider.js":
/*!******************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-code-completion/lib/browser/ai-code-inline-completion-provider.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AICodeInlineCompletionsProvider = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const code_completion_agent_1 = __webpack_require__(/*! ./code-completion-agent */ "../../node_modules/@theia/ai-code-completion/lib/browser/code-completion-agent.js");
const ai_core_1 = __webpack_require__(/*! @theia/ai-core */ "../../node_modules/@theia/ai-core/lib/common/index.js");
let AICodeInlineCompletionsProvider = class AICodeInlineCompletionsProvider {
    async provideInlineCompletions(model, position, context, token) {
        if (!this.agentService.isEnabled(this.agent.id)) {
            return undefined;
        }
        return this.agent.provideInlineCompletions(model, position, context, token);
    }
    freeInlineCompletions(completions) {
        // nothing to do
    }
};
exports.AICodeInlineCompletionsProvider = AICodeInlineCompletionsProvider;
tslib_1.__decorate([
    (0, inversify_1.inject)(code_completion_agent_1.CodeCompletionAgent),
    tslib_1.__metadata("design:type", Object)
], AICodeInlineCompletionsProvider.prototype, "agent", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_core_1.AgentService),
    tslib_1.__metadata("design:type", Object)
], AICodeInlineCompletionsProvider.prototype, "agentService", void 0);
exports.AICodeInlineCompletionsProvider = AICodeInlineCompletionsProvider = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], AICodeInlineCompletionsProvider);


/***/ }),

/***/ "../../node_modules/@theia/ai-code-completion/lib/browser/code-completion-agent.js":
/*!*****************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-code-completion/lib/browser/code-completion-agent.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CodeCompletionAgentImpl = exports.CodeCompletionAgent = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const browser_1 = __webpack_require__(/*! @theia/ai-core/lib/browser */ "../../node_modules/@theia/ai-core/lib/browser/index.js");
const common_1 = __webpack_require__(/*! @theia/ai-core/lib/common */ "../../node_modules/@theia/ai-core/lib/common/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_2 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const monaco = __webpack_require__(/*! @theia/monaco-editor-core */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/editor.main.js");
const ai_code_completion_preference_1 = __webpack_require__(/*! ./ai-code-completion-preference */ "../../node_modules/@theia/ai-code-completion/lib/browser/ai-code-completion-preference.js");
const code_completion_prompt_template_1 = __webpack_require__(/*! ./code-completion-prompt-template */ "../../node_modules/@theia/ai-code-completion/lib/browser/code-completion-prompt-template.js");
const code_completion_postprocessor_1 = __webpack_require__(/*! ./code-completion-postprocessor */ "../../node_modules/@theia/ai-code-completion/lib/browser/code-completion-postprocessor.js");
exports.CodeCompletionAgent = Symbol('CodeCompletionAgent');
let CodeCompletionAgentImpl = class CodeCompletionAgentImpl {
    constructor() {
        this.id = 'Code Completion';
        this.name = 'Code Completion';
        this.description = core_1.nls.localize('theia/ai/completion/agent/description', 'This agent provides inline code completion in the code editor in the Theia IDE.');
        this.promptTemplates = code_completion_prompt_template_1.codeCompletionPromptTemplates;
        this.languageModelRequirements = [
            {
                purpose: 'code-completion',
                identifier: 'openai/gpt-4o',
            },
        ];
        this.variables = [];
        this.functions = [];
        this.agentSpecificVariables = [
            { name: 'file', usedInPrompt: true, description: 'The uri of the file being edited.' },
            { name: 'language', usedInPrompt: true, description: 'The languageId of the file being edited.' },
            { name: 'prefix', usedInPrompt: true, description: 'The code before the current position of the cursor.' },
            { name: 'suffix', usedInPrompt: true, description: 'The code after the current position of the cursor.' }
        ];
    }
    async provideInlineCompletions(model, position, context, token) {
        const progress = await this.progressService.showProgress({ text: core_1.nls.localize('theia/ai/code-completion/progressText', 'Calculating AI code completion...'), options: { location: 'window' } });
        try {
            const languageModel = await this.languageModelRegistry.selectLanguageModel({
                agent: this.id,
                ...this.languageModelRequirements[0],
            });
            if (!languageModel) {
                this.logger.error('No language model found for code-completion-agent');
                return undefined;
            }
            const maxContextLines = this.preferences.get(ai_code_completion_preference_1.PREF_AI_INLINE_COMPLETION_MAX_CONTEXT_LINES, -1);
            let prefixStartLine = 1;
            let suffixEndLine = model.getLineCount();
            // if maxContextLines is -1, use the full file as context without any line limit
            if (maxContextLines === 0) {
                // Only the cursor line
                prefixStartLine = position.lineNumber;
                suffixEndLine = position.lineNumber;
            }
            else if (maxContextLines > 0) {
                const linesBeforeCursor = position.lineNumber - 1;
                const linesAfterCursor = model.getLineCount() - position.lineNumber;
                // Allocate one more line to the prefix in case of an odd maxContextLines
                const prefixLines = Math.min(Math.ceil(maxContextLines / 2), linesBeforeCursor);
                const suffixLines = Math.min(Math.floor(maxContextLines / 2), linesAfterCursor);
                prefixStartLine = Math.max(1, position.lineNumber - prefixLines);
                suffixEndLine = Math.min(model.getLineCount(), position.lineNumber + suffixLines);
            }
            const prefix = model.getValueInRange({
                startLineNumber: prefixStartLine,
                startColumn: 1,
                endLineNumber: position.lineNumber,
                endColumn: position.column,
            });
            const suffix = model.getValueInRange({
                startLineNumber: position.lineNumber,
                startColumn: position.column,
                endLineNumber: suffixEndLine,
                endColumn: model.getLineMaxColumn(suffixEndLine),
            });
            const file = model.uri.toString(false);
            const language = model.getLanguageId();
            if (token.isCancellationRequested) {
                return undefined;
            }
            const prompt = await this.promptService
                .getPrompt('code-completion-prompt', { prefix, suffix, file, language })
                .then(p => p === null || p === void 0 ? void 0 : p.text);
            if (!prompt) {
                this.logger.error('No prompt found for code-completion-agent');
                return undefined;
            }
            // since we do not actually hold complete conversions, the request/response pair is considered a session
            const sessionId = (0, core_1.generateUuid)();
            const requestId = (0, core_1.generateUuid)();
            const request = {
                messages: [{ type: 'text', actor: 'user', text: prompt }],
                settings: {
                    stream: false
                },
                agentId: this.id,
                sessionId,
                requestId,
                cancellationToken: token
            };
            if (token.isCancellationRequested) {
                return undefined;
            }
            this.recordingService.recordRequest({
                agentId: this.id,
                sessionId,
                requestId,
                request: request.messages
            });
            const response = await this.languageModelService.sendRequest(languageModel, request);
            if (token.isCancellationRequested) {
                return undefined;
            }
            const completionText = await (0, common_1.getTextOfResponse)(response);
            if (token.isCancellationRequested) {
                return undefined;
            }
            this.recordingService.recordResponse({
                agentId: this.id,
                sessionId,
                requestId,
                response: [{ actor: 'ai', text: completionText, type: 'text' }]
            });
            const postProcessedCompletionText = this.postProcessor.postProcess(completionText);
            return {
                items: [{
                        insertText: postProcessedCompletionText,
                        range: new monaco.Range(position.lineNumber, position.column, position.lineNumber, position.column)
                    }],
                enableForwardStability: true
            };
        }
        catch (e) {
            if (!token.isCancellationRequested) {
                console.error(e.message, e);
            }
        }
        finally {
            progress.cancel();
        }
    }
};
exports.CodeCompletionAgentImpl = CodeCompletionAgentImpl;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.LanguageModelService),
    tslib_1.__metadata("design:type", Object)
], CodeCompletionAgentImpl.prototype, "languageModelService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.ILogger),
    (0, inversify_1.named)('code-completion-agent'),
    tslib_1.__metadata("design:type", Object)
], CodeCompletionAgentImpl.prototype, "logger", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.LanguageModelRegistry),
    tslib_1.__metadata("design:type", Object)
], CodeCompletionAgentImpl.prototype, "languageModelRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.PromptService),
    tslib_1.__metadata("design:type", Object)
], CodeCompletionAgentImpl.prototype, "promptService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.CommunicationRecordingService),
    tslib_1.__metadata("design:type", Object)
], CodeCompletionAgentImpl.prototype, "recordingService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.ProgressService),
    tslib_1.__metadata("design:type", core_1.ProgressService)
], CodeCompletionAgentImpl.prototype, "progressService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.PreferenceService),
    tslib_1.__metadata("design:type", Object)
], CodeCompletionAgentImpl.prototype, "preferences", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(code_completion_postprocessor_1.CodeCompletionPostProcessor),
    tslib_1.__metadata("design:type", Object)
], CodeCompletionAgentImpl.prototype, "postProcessor", void 0);
exports.CodeCompletionAgentImpl = CodeCompletionAgentImpl = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], CodeCompletionAgentImpl);


/***/ }),

/***/ "../../node_modules/@theia/ai-code-completion/lib/browser/code-completion-postprocessor.js":
/*!*************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-code-completion/lib/browser/code-completion-postprocessor.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DefaultCodeCompletionPostProcessor = exports.CodeCompletionPostProcessor = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const ai_code_completion_preference_1 = __webpack_require__(/*! ./ai-code-completion-preference */ "../../node_modules/@theia/ai-code-completion/lib/browser/ai-code-completion-preference.js");
exports.CodeCompletionPostProcessor = Symbol('CodeCompletionPostProcessor');
let DefaultCodeCompletionPostProcessor = class DefaultCodeCompletionPostProcessor {
    postProcess(text) {
        if (this.preferenceService.get(ai_code_completion_preference_1.PREF_AI_INLINE_COMPLETION_STRIP_BACKTICKS, true)) {
            return this.stripBackticks(text);
        }
        return text;
    }
    stripBackticks(text) {
        if (text.startsWith('```')) {
            // Remove the first backticks and any language identifier
            const startRemoved = text.slice(3).replace(/^\w*\n/, '');
            const lastBacktickIndex = startRemoved.lastIndexOf('```');
            return lastBacktickIndex !== -1 ? startRemoved.slice(0, lastBacktickIndex).trim() : startRemoved.trim();
        }
        return text;
    }
};
exports.DefaultCodeCompletionPostProcessor = DefaultCodeCompletionPostProcessor;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.PreferenceService),
    tslib_1.__metadata("design:type", Object)
], DefaultCodeCompletionPostProcessor.prototype, "preferenceService", void 0);
exports.DefaultCodeCompletionPostProcessor = DefaultCodeCompletionPostProcessor = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DefaultCodeCompletionPostProcessor);


/***/ }),

/***/ "../../node_modules/@theia/ai-code-completion/lib/browser/code-completion-prompt-template.js":
/*!***************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-code-completion/lib/browser/code-completion-prompt-template.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


/* eslint-disable @typescript-eslint/tslint/config */
// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH and others.
//
// This file is licensed under the MIT License.
// See LICENSE-MIT.txt in the project root for license information.
// https://opensource.org/license/mit.
//
// SPDX-License-Identifier: MIT
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.codeCompletionPromptTemplates = void 0;
exports.codeCompletionPromptTemplates = [
    {
        id: 'code-completion-prompt-previous',
        variantOf: 'code-completion-prompt',
        template: `{{!-- This prompt is licensed under the MIT License (https://opensource.org/license/mit).
Made improvements or adaptations to this prompt template? We’d love for you to share it with the community! Contribute back here:
https://github.com/eclipse-theia/theia/discussions/new?category=prompt-template-contribution --}}
You are a code completion agent. The current file you have to complete is named {{file}}.
The language of the file is {{language}}. Return your result as plain text without markdown formatting.
Finish the following code snippet.

{{prefix}}[[MARKER]]{{suffix}}

Only return the exact replacement for [[MARKER]] to complete the snippet.`
    },
    {
        id: 'code-completion-prompt',
        template: `{{!-- This prompt is licensed under the MIT License (https://opensource.org/license/mit).
Made improvements or adaptations to this prompt template? We’d love for you to share it with the community! Contribute back here:
https://github.com/eclipse-theia/theia/discussions/new?category=prompt-template-contribution --}}
## Code snippet
\`\`\`
{{ prefix }}[[MARKER]]{{ suffix }}
\`\`\`

## Meta Data
- File: {{file}}
- Language: {{language}}

Replace [[MARKER]] with the exact code to complete the code snippet. Return only the replacement of [[MARKER]] as plain text.`,
    },
];


/***/ }),

/***/ "../../node_modules/@theia/ai-core/lib/browser/ai-view-contribution.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@theia/ai-core/lib/browser/ai-view-contribution.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AIViewContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const ai_activation_service_1 = __webpack_require__(/*! ./ai-activation-service */ "../../node_modules/@theia/ai-core/lib/browser/ai-activation-service.js");
const ai_command_handler_factory_1 = __webpack_require__(/*! ./ai-command-handler-factory */ "../../node_modules/@theia/ai-core/lib/browser/ai-command-handler-factory.js");
let AIViewContribution = class AIViewContribution extends browser_1.AbstractViewContribution {
    init() {
        this.activationService.onDidChangeActiveStatus(active => {
            if (!active) {
                this.closeView();
            }
        });
    }
    registerCommands(commands) {
        var _a;
        if (this.toggleCommand) {
            commands.registerCommand(this.toggleCommand, this.commandHandlerFactory({
                execute: () => this.toggleView(),
            }));
        }
        (_a = this.quickView) === null || _a === void 0 ? void 0 : _a.registerItem({
            label: this.viewLabel,
            when: ai_activation_service_1.ENABLE_AI_CONTEXT_KEY,
            open: () => this.openView({ activate: true })
        });
    }
    registerMenus(menus) {
        if (this.toggleCommand) {
            menus.registerMenuAction(browser_1.CommonMenus.VIEW_VIEWS, {
                commandId: this.toggleCommand.id,
                when: ai_activation_service_1.ENABLE_AI_CONTEXT_KEY,
                label: this.viewLabel
            });
        }
    }
    registerKeybindings(keybindings) {
        if (this.toggleCommand && this.options.toggleKeybinding) {
            keybindings.registerKeybinding({
                command: this.toggleCommand.id,
                when: ai_activation_service_1.ENABLE_AI_CONTEXT_KEY,
                keybinding: this.options.toggleKeybinding
            });
        }
    }
};
exports.AIViewContribution = AIViewContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.PreferenceService),
    tslib_1.__metadata("design:type", Object)
], AIViewContribution.prototype, "preferenceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_activation_service_1.AIActivationService),
    tslib_1.__metadata("design:type", ai_activation_service_1.AIActivationService)
], AIViewContribution.prototype, "activationService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_command_handler_factory_1.AICommandHandlerFactory),
    tslib_1.__metadata("design:type", Function)
], AIViewContribution.prototype, "commandHandlerFactory", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], AIViewContribution.prototype, "init", null);
exports.AIViewContribution = AIViewContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], AIViewContribution);


/***/ }),

/***/ "../../node_modules/@theia/ai-core/lib/browser/index.js":
/*!**************************************************************!*\
  !*** ../../node_modules/@theia/ai-core/lib/browser/index.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
tslib_1.__exportStar(__webpack_require__(/*! ./ai-activation-service */ "../../node_modules/@theia/ai-core/lib/browser/ai-activation-service.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./ai-core-frontend-application-contribution */ "../../node_modules/@theia/ai-core/lib/browser/ai-core-frontend-application-contribution.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./ai-core-frontend-module */ "../../node_modules/@theia/ai-core/lib/browser/ai-core-frontend-module.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./ai-core-preferences */ "../../node_modules/@theia/ai-core/lib/browser/ai-core-preferences.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./ai-settings-service */ "../../node_modules/@theia/ai-core/lib/browser/ai-settings-service.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./ai-view-contribution */ "../../node_modules/@theia/ai-core/lib/browser/ai-view-contribution.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./frontend-language-model-registry */ "../../node_modules/@theia/ai-core/lib/browser/frontend-language-model-registry.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./frontend-variable-service */ "../../node_modules/@theia/ai-core/lib/browser/frontend-variable-service.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./prompttemplate-contribution */ "../../node_modules/@theia/ai-core/lib/browser/prompttemplate-contribution.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./theia-variable-contribution */ "../../node_modules/@theia/ai-core/lib/browser/theia-variable-contribution.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./frontend-variable-service */ "../../node_modules/@theia/ai-core/lib/browser/frontend-variable-service.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./ai-core-command-contribution */ "../../node_modules/@theia/ai-core/lib/browser/ai-core-command-contribution.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ../common/language-model-service */ "../../node_modules/@theia/ai-core/lib/common/language-model-service.js"), exports);


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_ai-code-completion_lib_browser_ai-code-completion-frontend-module_js.js.map