"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GDBFileSystemProcessManagerBase = void 0;
const child_process_1 = require("child_process");
const createEnvValues_1 = require("../../util/createEnvValues");
const fs_1 = require("fs");
const path_1 = require("path");
class GDBFileSystemProcessManagerBase {
    constructor() {
        this.token = 0;
    }
    getEnvironment(additionalEnvironment) {
        return additionalEnvironment
            ? (0, createEnvValues_1.createEnvValues)(process.env, additionalEnvironment)
            : process.env;
    }
    getCwd(requestArgs) {
        const cwd = requestArgs.cwd ||
            (requestArgs.program && (0, fs_1.existsSync)(requestArgs.program)
                ? (0, path_1.dirname)(requestArgs.program)
                : process.cwd());
        return (0, fs_1.existsSync)(cwd) ? cwd : process.cwd();
    }
    spawn(executable, args, options) {
        return __awaiter(this, void 0, void 0, function* () {
            const env = this.getEnvironment(options.additionalEnvironment);
            this.proc = (0, child_process_1.spawn)(executable, args, { env, cwd: options.cwd });
            return this.proc;
        });
    }
    kill() {
        return __awaiter(this, void 0, void 0, function* () {
            if (!this.proc) {
                throw new Error('GDB is not running, nothing to interrupt');
            }
            // logger.verbose(`GDB signal: SIGINT to pid ${this.proc.pid}`);
            this.proc.kill('SIGINT');
        });
    }
    onStop(callback) {
        var _a;
        (_a = this.proc) === null || _a === void 0 ? void 0 : _a.on('exit', callback);
    }
    onError(callback) {
        var _a;
        (_a = this.proc) === null || _a === void 0 ? void 0 : _a.on('error', callback);
    }
}
exports.GDBFileSystemProcessManagerBase = GDBFileSystemProcessManagerBase;
//# sourceMappingURL=GDBFileSystemProcessManagerBase.js.map